
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int NOT NULL,
  `transaction_id` int DEFAULT NULL,
  `transaction_payment_id` int DEFAULT NULL,
  `transfer_transaction_id` int DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
INSERT INTO `account_transactions` VALUES (1,1,'credit','',800000.0000,NULL,'2024-03-11 19:18:00',2,NULL,NULL,NULL,'Actually Midland Bank',NULL,'2024-03-11 19:18:48','2024-03-11 19:18:48'),(2,1,'credit','',579800.0000,NULL,'2024-03-12 14:35:00',2,NULL,NULL,NULL,'premium fish er trust',NULL,'2024-03-12 14:36:16','2024-03-12 14:36:16'),(3,3,'credit','',97310.0000,NULL,'2024-03-12 14:37:00',2,NULL,NULL,NULL,'rony mojumdari',NULL,'2024-03-12 14:38:04','2024-03-12 14:38:04'),(4,1,'credit','',212500.0000,NULL,'2024-03-25 22:40:00',2,NULL,NULL,NULL,'bank alfalah rasel sreemongol fund',NULL,'2024-03-25 22:40:42','2024-03-25 22:40:42'),(5,1,'credit','',100000.0000,NULL,'2024-04-09 14:37:00',2,NULL,NULL,NULL,'premium fish',NULL,'2024-04-09 14:37:51','2024-04-09 14:37:51'),(6,1,'debit','',120.0000,NULL,'2024-04-17 19:58:00',2,NULL,NULL,7,NULL,NULL,'2024-04-17 19:59:20','2024-04-17 19:59:20'),(7,1,'debit','',120.0000,NULL,'2024-04-17 19:58:00',2,NULL,NULL,6,NULL,NULL,'2024-04-17 19:59:20','2024-04-17 19:59:20'),(8,1,'debit','',10.0000,NULL,'2024-04-17 20:14:00',2,NULL,NULL,9,NULL,NULL,'2024-04-17 20:15:08','2024-04-17 20:15:08'),(9,1,'debit','',10.0000,NULL,'2024-04-17 20:14:00',2,NULL,NULL,8,NULL,NULL,'2024-04-17 20:15:08','2024-04-17 20:15:08'),(10,1,'debit','',5.0000,NULL,'2024-04-17 20:17:00',2,NULL,NULL,NULL,NULL,NULL,'2024-04-17 20:17:54','2024-04-17 20:17:54'),(11,1,'debit','',115.0000,NULL,'2024-04-17 20:19:00',2,NULL,NULL,NULL,'cust. exchange pay',NULL,'2024-04-17 20:19:42','2024-04-17 20:19:42'),(12,1,'credit','',50000.0000,NULL,'2024-04-25 12:44:00',2,NULL,NULL,NULL,NULL,NULL,'2024-04-25 12:44:22','2024-04-25 12:44:22'),(13,3,'credit','',16630.0000,NULL,'2024-04-28 19:13:00',2,NULL,NULL,NULL,'8-11 er joma',NULL,'2024-04-28 19:14:15','2024-04-28 19:14:15'),(14,1,'credit','',12000.0000,NULL,'2024-05-02 13:13:00',3,NULL,NULL,NULL,'kutub ali koifot',NULL,'2024-05-02 13:13:58','2024-05-02 13:13:58'),(15,1,'debit','',12000.0000,NULL,'2024-05-02 14:56:00',3,NULL,NULL,NULL,'ractify',NULL,'2024-05-02 14:57:09','2024-05-02 14:57:09'),(16,1,'credit','deposit',150000.0000,NULL,'2024-05-05 19:59:00',2,NULL,NULL,NULL,NULL,'2024-05-05 20:18:18','2024-05-05 19:59:38','2024-05-05 20:18:18'),(17,1,'credit','deposit',150000.0000,NULL,'2024-05-05 20:18:00',2,NULL,NULL,NULL,NULL,'2024-05-05 20:19:43','2024-05-05 20:18:47','2024-05-05 20:19:43'),(19,1,'credit','',150000.0000,NULL,'2024-05-05 20:34:00',2,NULL,NULL,NULL,NULL,NULL,'2024-05-05 20:34:24','2024-05-05 20:34:24'),(20,1,'debit','',150000.0000,NULL,'2024-05-05 20:54:00',2,NULL,NULL,NULL,'ractify',NULL,'2024-05-05 20:55:49','2024-05-05 20:55:49'),(21,1,'credit','',100000.0000,NULL,'2024-06-02 13:03:00',2,NULL,NULL,NULL,'premium fisheries',NULL,'2024-06-02 13:03:37','2024-06-02 13:03:37'),(22,4,'credit','',400000.0000,NULL,'2024-08-21 18:59:00',2,NULL,NULL,NULL,'house initially',NULL,'2024-08-21 18:59:54','2024-08-21 18:59:54'),(23,1,'credit','',72000.0000,NULL,'2024-09-05 13:18:00',2,NULL,NULL,NULL,'premium fish',NULL,'2024-09-05 13:18:19','2024-09-05 13:18:19'),(24,1,'credit','',171700.0000,NULL,'2024-09-23 14:56:00',2,NULL,NULL,NULL,'deposited to Alfalah',NULL,'2024-09-23 14:57:17','2024-09-23 14:57:17'),(25,1,'credit','',96700.0000,NULL,'2024-09-26 19:01:00',2,NULL,NULL,NULL,'premium fish',NULL,'2024-09-26 19:02:04','2024-09-26 19:02:04'),(26,1,'credit','',100500.0000,NULL,'2024-10-09 19:31:00',2,NULL,NULL,NULL,'premium fish',NULL,'2024-10-09 19:31:31','2024-10-09 19:31:31'),(27,4,'credit','',550000.0000,NULL,'2024-11-17 11:24:00',2,NULL,NULL,NULL,'bashay',NULL,'2024-11-17 11:24:22','2024-11-17 11:24:22'),(28,4,'credit','',4000.0000,NULL,'2024-11-17 14:34:00',2,NULL,NULL,NULL,'biron 50 kg sale kutub',NULL,'2024-11-17 14:34:42','2024-11-17 14:34:42'),(29,4,'credit','',250000.0000,NULL,'2024-11-20 12:07:00',2,NULL,NULL,NULL,NULL,NULL,'2024-11-20 12:07:55','2024-11-20 12:07:55'),(30,1,'credit','',78050.0000,NULL,'2024-11-28 18:54:00',2,NULL,NULL,NULL,'+15650',NULL,'2024-11-28 18:55:17','2024-11-28 18:55:17'),(31,3,'credit','',500000.0000,NULL,'2024-12-04 14:12:00',2,NULL,NULL,NULL,'b.alfalah vault',NULL,'2024-12-04 14:12:25','2024-12-04 14:12:25'),(32,1,'credit','',2600.0000,NULL,'2024-12-07 12:38:00',2,NULL,NULL,NULL,'mahinor maa',NULL,'2024-12-07 12:38:36','2024-12-07 12:38:36'),(33,1,'debit','',500000.0000,NULL,'2024-12-19 12:22:00',2,NULL,NULL,34,'from vault',NULL,'2024-12-19 12:22:57','2024-12-19 12:22:57'),(34,1,'debit','',500000.0000,NULL,'2024-12-19 12:22:00',2,NULL,NULL,33,'from vault',NULL,'2024-12-19 12:22:57','2024-12-19 12:22:57'),(35,1,'debit','',500000.0000,NULL,'2024-12-19 12:23:00',2,NULL,NULL,NULL,'from vault',NULL,'2024-12-19 12:23:55','2024-12-19 12:23:55'),(36,1,'credit','',100000.0000,NULL,'2025-01-01 13:14:00',2,NULL,NULL,NULL,NULL,NULL,'2025-01-01 13:15:27','2025-01-01 13:15:27'),(37,3,'credit','',743000.0000,NULL,'2025-01-08 11:25:00',2,NULL,NULL,NULL,'cash 500000+243000(rasel sreemongol)',NULL,'2025-01-08 11:25:39','2025-01-08 11:25:39'),(38,1,'credit','',2427.0000,NULL,'2025-01-13 12:49:00',2,NULL,NULL,NULL,'BR 49 mistaken',NULL,'2025-01-13 12:50:05','2025-01-13 12:50:05'),(39,1,'debit','',2427.0000,NULL,'2025-01-13 12:51:00',2,NULL,NULL,NULL,'ractify',NULL,'2025-01-13 12:51:49','2025-01-13 12:51:49'),(40,3,'debit','',2427.0000,NULL,'2025-01-13 12:55:00',2,NULL,NULL,NULL,'added',NULL,'2025-01-13 12:55:26','2025-01-13 12:55:26'),(41,1,'credit','',194250.0000,NULL,'2025-01-18 19:24:00',2,NULL,NULL,NULL,'shamsu',NULL,'2025-01-18 19:24:27','2025-01-18 19:24:27'),(42,3,'debit','',194000.0000,NULL,'2025-01-21 12:37:00',2,NULL,NULL,NULL,'B alfalah',NULL,'2025-01-21 12:38:07','2025-01-21 12:38:07'),(43,1,'credit','',123025.0000,NULL,'2025-01-22 19:05:00',2,NULL,NULL,NULL,'from hasan br',NULL,'2025-01-22 19:06:04','2025-01-22 19:06:04'),(44,4,'credit','',3080.0000,NULL,'2025-02-02 12:55:00',2,NULL,NULL,NULL,'khaja mill exp',NULL,'2025-02-02 12:56:07','2025-02-02 12:56:07'),(45,1,'credit','',28800.0000,NULL,'2025-02-02 18:21:00',2,NULL,NULL,NULL,'15000 wrogly dewa asil account e premium fish',NULL,'2025-02-02 18:22:15','2025-02-02 18:22:15'),(46,4,'credit','',119000.0000,NULL,'2025-02-06 12:06:00',2,NULL,NULL,NULL,'rasel kolil sreemongol',NULL,'2025-02-06 12:06:30','2025-02-06 12:06:30'),(47,4,'credit','',80000.0000,NULL,'2025-02-17 12:42:00',2,NULL,NULL,NULL,'shaky 80000',NULL,'2025-02-17 12:43:04','2025-02-17 12:43:04'),(48,4,'credit','',105840.0000,NULL,'2025-02-19 18:36:00',2,NULL,NULL,NULL,'rasel sreemongol',NULL,'2025-02-19 18:37:03','2025-02-19 18:37:03'),(49,3,'credit','',136000.0000,NULL,'2025-03-02 15:57:00',2,NULL,NULL,NULL,'rony mojum',NULL,'2025-03-02 15:57:23','2025-03-02 15:57:23'),(50,3,'credit','',25000.0000,NULL,'2025-03-04 12:00:00',2,NULL,NULL,NULL,'bkash doc shahed +a kaiyum madrasha',NULL,'2025-03-04 12:01:06','2025-03-04 12:01:06'),(51,4,'credit','',300000.0000,NULL,'2025-03-25 16:46:00',2,NULL,NULL,NULL,'afsana 300000. b. alfalah',NULL,'2025-03-25 16:46:53','2025-03-25 16:46:53'),(52,4,'credit','',167500.0000,NULL,'2025-04-13 15:28:00',2,NULL,NULL,NULL,'Rasel khalil',NULL,'2025-04-13 15:28:29','2025-04-13 15:28:29'),(53,4,'credit','',69090.0000,NULL,'2025-04-17 19:52:00',2,NULL,NULL,NULL,'rasel khalil kaddo',NULL,'2025-04-17 19:53:01','2025-04-17 19:53:01');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int DEFAULT NULL,
  `business_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
INSERT INTO `account_types` VALUES (1,'Business',NULL,1,'2024-03-11 18:48:37','2024-03-11 18:48:37');
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text COLLATE utf8mb4_unicode_ci,
  `account_type_id` int DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,1,'M/S SALAM ENTERPRISE (B. Alfalah)','0704-2100328774','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,NULL,2,0,NULL,'2024-03-11 18:52:53','2024-04-09 14:39:24'),(3,1,'BKASH','01717258050','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,'self',3,0,NULL,'2024-03-12 00:58:24','2025-03-25 16:49:37'),(4,1,'Rent for Shop (house)','0022-1350000119','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,'Midland bank ltd',3,0,NULL,'2024-03-12 01:01:40','2025-02-06 12:05:52'),(5,1,'softwae mistaken fund','112233','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,NULL,2,0,NULL,'2024-04-15 14:29:45','2024-04-15 14:29:45'),(6,1,'Bank Account (ALFALAH)','00001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',1,NULL,2,1,NULL,'2024-05-02 13:07:37','2024-05-02 13:12:29');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int DEFAULT NULL,
  `causer_id` int DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `batch_uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=32891 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 17:32:22','2023-10-15 17:32:22'),(2,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 17:59:17','2023-10-15 17:59:17'),(3,'default','added',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 18:23:51','2023-10-15 18:23:51'),(4,'default','added',1,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7507650}}',NULL,'2023-10-15 18:24:30','2023-10-15 18:24:30'),(5,'default','added',2,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41075}}',NULL,'2023-10-15 18:28:40','2023-10-15 18:28:40'),(6,'default','added',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 18:30:44','2023-10-15 18:30:44'),(7,'default','added',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17280}}',NULL,'2023-10-15 18:31:53','2023-10-15 18:31:53'),(8,'default','added',4,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":421.3999999999999772626324556767940521240234375}}',NULL,'2023-10-15 18:59:04','2023-10-15 18:59:04'),(9,'default','edited',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17280.0000\"}}',NULL,'2023-10-15 19:00:11','2023-10-15 19:00:11'),(10,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:04','2023-10-15 19:04:04'),(11,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:09','2023-10-15 19:04:09'),(12,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:31','2023-10-15 19:04:31'),(13,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:35','2023-10-15 19:04:35'),(14,'default','edited',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17280.0000\"}}',NULL,'2023-10-15 19:11:44','2023-10-15 19:11:44'),(15,'default','added',5,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4437}}',NULL,'2023-10-15 19:24:34','2023-10-15 19:24:34'),(16,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 01:02:01','2023-10-16 01:02:01'),(17,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-17 17:27:10','2023-10-17 17:27:10'),(18,'default','added',6,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":442}}',NULL,'2023-10-17 17:28:45','2023-10-17 17:28:45'),(19,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-18 13:38:23','2023-10-18 13:38:23'),(20,'default','sell_deleted',6,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":6,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"442.0000\"}}',NULL,'2023-10-18 16:56:51','2023-10-18 16:56:51'),(21,'default','sell_deleted',5,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":5,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4437.0000\"}}',NULL,'2023-10-18 16:56:55','2023-10-18 16:56:55'),(22,'default','sell_deleted',4,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":4,\"invoice_no\":\"0003\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"421.4000\"}}',NULL,'2023-10-18 16:57:01','2023-10-18 16:57:01'),(23,'default','sell_deleted',3,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":3,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17280.0000\"}}',NULL,'2023-10-18 16:57:05','2023-10-18 16:57:05'),(24,'default','sell_deleted',2,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":2,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"41075.0000\"}}',NULL,'2023-10-18 16:57:14','2023-10-18 16:57:14'),(25,'default','purchase_deleted',1,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"7507650.0000\"}}',NULL,'2023-10-18 17:00:12','2023-10-18 17:00:12'),(26,'default','added',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-18 17:03:45','2023-10-18 17:03:45'),(27,'default','added',7,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":133500}}',NULL,'2023-10-18 17:04:37','2023-10-18 17:04:37'),(28,'default','added',8,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-10-18 17:06:54','2023-10-18 17:06:54'),(29,'default','added',9,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":80000}}',NULL,'2023-10-18 17:24:40','2023-10-18 17:24:40'),(30,'default','added',10,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4700}}',NULL,'2023-10-18 17:29:46','2023-10-18 17:29:46'),(31,'default','added',11,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0}}',NULL,'2023-10-18 17:39:54','2023-10-18 17:39:54'),(32,'default','added',12,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1450}}',NULL,'2023-10-18 17:42:39','2023-10-18 17:42:39'),(33,'default','payment_edited',12,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2023-10-18 17:43:46','2023-10-18 17:43:46'),(34,'default','added',13,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":0}}',NULL,'2023-10-18 17:51:57','2023-10-18 17:51:57'),(35,'default','added',14,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":2800}}',NULL,'2023-10-18 17:53:37','2023-10-18 17:53:37'),(36,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 01:25:17','2023-10-19 01:25:17'),(37,'default','added',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 02:06:24','2023-10-19 02:06:24'),(38,'default','added',15,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":16950}}',NULL,'2023-10-19 02:07:00','2023-10-19 02:07:00'),(39,'default','edited',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 02:09:07','2023-10-19 02:09:07'),(40,'default','contact_deleted',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 02:09:19','2023-10-19 02:09:19'),(41,'default','added',16,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1525}}',NULL,'2023-10-19 02:20:33','2023-10-19 02:20:33'),(42,'default','added',17,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-10-19 14:27:35','2023-10-19 14:27:35'),(43,'default','added',18,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-10-19 14:28:15','2023-10-19 14:28:15'),(44,'default','added',19,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":208000}}',NULL,'2023-10-19 14:35:00','2023-10-19 14:35:00'),(45,'default','added',20,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4700}}',NULL,'2023-10-19 14:38:14','2023-10-19 14:38:14'),(46,'default','added',21,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-10-19 14:38:44','2023-10-19 14:38:44'),(47,'default','added',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:25:55','2023-10-19 16:25:55'),(48,'default','added',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:29:34','2023-10-19 16:29:34'),(49,'default','edited',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:30:09','2023-10-19 16:30:09'),(50,'default','edited',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:30:25','2023-10-19 16:30:25'),(51,'default','added',8,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:34:28','2023-10-19 16:34:28'),(52,'default','added',9,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:36:27','2023-10-19 16:36:27'),(53,'default','added',10,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:39:12','2023-10-19 16:39:12'),(54,'default','added',11,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:41:22','2023-10-19 16:41:22'),(55,'default','edited',11,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:41:42','2023-10-19 16:41:42'),(56,'default','added',12,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:47:47','2023-10-19 16:47:47'),(57,'default','added',13,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:50:51','2023-10-19 16:50:51'),(58,'default','added',14,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:52:11','2023-10-19 16:52:11'),(59,'default','added',15,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:53:37','2023-10-19 16:53:37'),(60,'default','added',16,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:54:46','2023-10-19 16:54:46'),(61,'default','edited',16,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:55:05','2023-10-19 16:55:05'),(62,'default','added',17,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:56:37','2023-10-19 16:56:37'),(63,'default','added',18,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:57:41','2023-10-19 16:57:41'),(64,'default','added',19,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:01:48','2023-10-19 17:01:48'),(65,'default','added',20,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:02:40','2023-10-19 17:02:40'),(66,'default','added',21,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:04:13','2023-10-19 17:04:13'),(67,'default','added',22,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:05:48','2023-10-19 17:05:48'),(68,'default','added',23,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:07:23','2023-10-19 17:07:23'),(69,'default','added',24,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:10:38','2023-10-19 17:10:38'),(70,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:17:55','2023-10-19 17:17:55'),(71,'default','edited',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:19:52','2023-10-19 17:19:52'),(72,'default','edited',24,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:21:50','2023-10-19 17:21:50'),(73,'default','edited',24,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:22:47','2023-10-19 17:22:47'),(75,'default','sell_deleted',15,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":15,\"invoice_no\":\"0007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16950.0000\"}}',NULL,'2023-10-19 18:01:46','2023-10-19 18:01:46'),(76,'default','sell_deleted',16,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":16,\"invoice_no\":\"0008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1525.0000\"}}',NULL,'2023-10-19 18:01:53','2023-10-19 18:01:53'),(77,'default','sell_deleted',17,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":17,\"invoice_no\":\"0009\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"70.0000\"}}',NULL,'2023-10-19 18:01:58','2023-10-19 18:01:58'),(78,'default','sell_deleted',21,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":21,\"invoice_no\":\"0012\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"70.0000\"}}',NULL,'2023-10-19 18:02:06','2023-10-19 18:02:06'),(79,'default','sell_deleted',20,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":20,\"invoice_no\":\"0011\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-19 18:02:10','2023-10-19 18:02:10'),(80,'default','sell_deleted',18,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":18,\"invoice_no\":\"0010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-19 18:02:14','2023-10-19 18:02:14'),(81,'default','sell_deleted',10,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":10,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-19 18:02:46','2023-10-19 18:02:46'),(82,'default','purchase_deleted',19,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"208000.0000\"}}',NULL,'2023-10-19 18:03:02','2023-10-19 18:03:02'),(83,'default','purchase_deleted',11,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-10-19 18:03:57','2023-10-19 18:03:57'),(84,'default','purchase_deleted',9,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"80000.0000\"}}',NULL,'2023-10-19 18:04:06','2023-10-19 18:04:06'),(85,'default','purchase_deleted',7,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"133500.0000\"}}',NULL,'2023-10-19 18:04:10','2023-10-19 18:04:10'),(86,'default','purchase_deleted',8,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-10-19 18:04:14','2023-10-19 18:04:14'),(87,'default','added',24,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":560500}}',NULL,'2023-10-19 18:12:30','2023-10-19 18:12:30'),(88,'default','added',25,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":22870}}',NULL,'2023-10-19 18:18:23','2023-10-19 18:18:23'),(89,'default','added',26,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4840}}',NULL,'2023-10-19 18:33:39','2023-10-19 18:33:39'),(90,'default','added',27,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7040}}',NULL,'2023-10-21 14:27:58','2023-10-21 14:27:58'),(91,'default','added',28,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1540}}',NULL,'2023-10-21 14:31:39','2023-10-21 14:31:39'),(92,'default','added',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":770}}',NULL,'2023-10-21 14:32:36','2023-10-21 14:32:36'),(93,'default','edited',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":-154},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"770.0000\"}}',NULL,'2023-10-21 14:35:36','2023-10-21 14:35:36'),(94,'default','added',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3168}}',NULL,'2023-10-21 14:41:28','2023-10-21 14:41:28'),(95,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:41:55','2023-10-21 14:41:55'),(96,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:42:05','2023-10-21 14:42:05'),(97,'default','payment_edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:42:50','2023-10-21 14:42:50'),(98,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:43:19','2023-10-21 14:43:19'),(99,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:44:21','2023-10-21 14:44:21'),(100,'default','added',31,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":30000}}',NULL,'2023-10-21 14:45:05','2023-10-21 14:45:05'),(101,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:45:22','2023-10-21 14:45:22'),(102,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:46:08','2023-10-21 14:46:08'),(103,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:46:52','2023-10-21 14:46:52'),(104,'default','added',32,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3190}}',NULL,'2023-10-21 14:48:14','2023-10-21 14:48:14'),(105,'default','payment_edited',32,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3190.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3190.0000\"}}',NULL,'2023-10-21 14:49:00','2023-10-21 14:49:00'),(106,'default','payment_edited',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-154.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-154.0000\"}}',NULL,'2023-10-21 14:49:10','2023-10-21 14:49:10'),(107,'default','edited',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":308},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-154.0000\"}}',NULL,'2023-10-21 14:50:07','2023-10-21 14:50:07'),(108,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:53:16','2023-10-21 14:53:16'),(109,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:59:05','2023-10-21 14:59:05'),(110,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:29:43','2023-10-21 15:29:43'),(111,'default','added',33,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5170}}',NULL,'2023-10-21 15:31:32','2023-10-21 15:31:32'),(112,'default','added',25,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:32:48','2023-10-21 15:32:48'),(113,'default','added',34,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3300}}',NULL,'2023-10-21 15:33:00','2023-10-21 15:33:00'),(114,'default','sell_deleted',34,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":34,\"invoice_no\":\"0018\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-21 15:40:46','2023-10-21 15:40:46'),(115,'default','sell_deleted',33,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":33,\"invoice_no\":\"0017\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5170.0000\"}}',NULL,'2023-10-21 15:41:00','2023-10-21 15:41:00'),(116,'default','sell_deleted',28,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":28,\"invoice_no\":\"0016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1540.0000\"}}',NULL,'2023-10-21 15:41:39','2023-10-21 15:41:39'),(117,'default','sell_deleted',27,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":27,\"invoice_no\":\"0015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7040.0000\"}}',NULL,'2023-10-21 15:41:43','2023-10-21 15:41:43'),(118,'default','sell_deleted',26,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":26,\"invoice_no\":\"0014\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4840.0000\"}}',NULL,'2023-10-21 15:41:46','2023-10-21 15:41:46'),(119,'default','sell_deleted',25,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":25,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"22870.0000\"}}',NULL,'2023-10-21 15:41:51','2023-10-21 15:41:51'),(120,'default','purchase_deleted',24,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"560500.0000\"}}',NULL,'2023-10-21 15:42:25','2023-10-21 15:42:25'),(121,'default','contact_deleted',25,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:44:01','2023-10-21 15:44:01'),(122,'default','contact_deleted',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:45:11','2023-10-21 15:45:11'),(123,'default','contact_deleted',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:45:19','2023-10-21 15:45:19'),(124,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:09:17','2023-10-21 19:09:17'),(125,'default','added',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" \\u0986\\u0995\\u09b0\\u09be\\u09ae \\u0986\\u09b2\\u09c0 \\u0985\\u09cd\\u09af\\u09be\\u09a8\\u09cd\\u09a1 \\u09b8\\u09a8\\u09cd\\u09b8\"}',NULL,'2023-10-21 19:12:28','2023-10-21 19:12:28'),(126,'default','edited',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Abdus Subahan Manna\"}',NULL,'2023-10-21 19:13:25','2023-10-21 19:13:25'),(127,'default','added',3,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Abdus Subahan Manna\"}',NULL,'2023-10-21 19:15:29','2023-10-21 19:15:29'),(128,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:16:32','2023-10-21 19:16:32'),(129,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:16:42','2023-10-21 19:16:42'),(130,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:16:55','2023-10-21 19:16:55'),(131,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-21 19:17:00','2023-10-21 19:17:00'),(132,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-21 19:17:06','2023-10-21 19:17:06'),(133,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 19:43:04','2023-10-21 19:43:04'),(134,'default','added',26,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 19:46:50','2023-10-21 19:46:50'),(135,'default','added',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191460}}',NULL,'2023-10-21 19:51:58','2023-10-21 19:51:58'),(136,'default','edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191810},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191460.0000\"}}',NULL,'2023-10-21 19:56:07','2023-10-21 19:56:07'),(137,'default','edited',26,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 19:58:33','2023-10-21 19:58:33'),(138,'default','edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191820},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191810.0000\"}}',NULL,'2023-10-21 20:00:42','2023-10-21 20:00:42'),(139,'default','edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191490},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191820.0000\"}}',NULL,'2023-10-21 20:03:03','2023-10-21 20:03:03'),(140,'default','payment_edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"191490.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191490.0000\"}}',NULL,'2023-10-21 20:04:10','2023-10-21 20:04:10'),(141,'default','payment_edited',36,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 20:04:10','2023-10-21 20:04:10'),(142,'default','added',37,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-21 20:05:52','2023-10-21 20:05:52'),(143,'default','payment_edited',37,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-21 20:06:23','2023-10-21 20:06:23'),(144,'default','added',38,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-10-21 20:20:13','2023-10-21 20:20:13'),(145,'default','added',39,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":2200}}',NULL,'2023-10-21 20:25:26','2023-10-21 20:25:26'),(146,'default','added',27,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 20:32:03','2023-10-21 20:32:03'),(147,'default','added',40,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-10-21 20:32:09','2023-10-21 20:32:09'),(148,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 20:38:06','2023-10-21 20:38:06'),(149,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 21:40:58','2023-10-21 21:40:58'),(150,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 21:45:53','2023-10-21 21:45:53'),(151,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 21:46:53','2023-10-21 21:46:53'),(152,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-22 11:53:44','2023-10-22 11:53:44'),(153,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-22 11:55:59','2023-10-22 11:55:59'),(154,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 11:56:52','2023-10-22 11:56:52'),(155,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:13:39','2023-10-22 12:13:39'),(156,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:31:23','2023-10-22 12:31:23'),(157,'default','edited',7,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:37:40','2023-10-22 12:37:40'),(158,'default','edited',8,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:39:00','2023-10-22 12:39:00'),(159,'default','edited',9,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:40:23','2023-10-22 12:40:23'),(160,'default','edited',10,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:41:43','2023-10-22 12:41:43'),(161,'default','edited',11,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:42:45','2023-10-22 12:42:45'),(162,'default','edited',5,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:44:12','2023-10-22 12:44:12'),(163,'default','edited',13,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:48:33','2023-10-22 12:48:33'),(164,'default','edited',14,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:51:15','2023-10-22 12:51:15'),(165,'default','edited',16,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:55:15','2023-10-22 12:55:15'),(166,'default','edited',17,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:21:44','2023-10-22 13:21:44'),(167,'default','edited',18,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:23:53','2023-10-22 13:23:53'),(168,'default','edited',20,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:26:14','2023-10-22 13:26:14'),(169,'default','edited',21,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:27:42','2023-10-22 13:27:42'),(170,'default','edited',22,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:31:04','2023-10-22 13:31:04'),(171,'default','edited',23,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:32:54','2023-10-22 13:32:54'),(172,'default','edited',15,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:35:16','2023-10-22 13:35:16'),(173,'default','edited',19,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:37:16','2023-10-22 13:37:16'),(174,'default','edited',6,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:38:58','2023-10-22 13:38:58'),(175,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:40:06','2023-10-22 13:40:06'),(176,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:40:30','2023-10-22 13:40:30'),(177,'default','added',28,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:46:43','2023-10-22 13:46:43'),(178,'default','added',29,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:49:21','2023-10-22 13:49:21'),(179,'default','added',30,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:50:52','2023-10-22 13:50:52'),(180,'default','added',31,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:55:18','2023-10-22 13:55:18'),(181,'default','added',32,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:56:36','2023-10-22 13:56:36'),(182,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:00:23','2023-10-22 14:00:23'),(183,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:00:40','2023-10-22 14:00:40'),(184,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:00:59','2023-10-22 14:00:59'),(185,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:02:43','2023-10-22 14:02:43'),(186,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-22 14:03:25','2023-10-22 14:03:25'),(187,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-22 14:08:30','2023-10-22 14:08:30'),(188,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-22 14:11:18','2023-10-22 14:11:18'),(189,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:12:01','2023-10-22 14:12:01'),(190,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 17:35:44','2023-10-22 17:35:44'),(191,'default','sell_deleted',38,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":38,\"invoice_no\":\"0019\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-22 17:41:52','2023-10-22 17:41:52'),(192,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 17:52:25','2023-10-22 17:52:25'),(193,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 17:53:56','2023-10-22 17:53:56'),(194,'default','purchase_deleted',40,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-10-22 18:10:27','2023-10-22 18:10:27'),(195,'default','sell_deleted',39,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":39,\"invoice_no\":\"2023\\/0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-22 18:15:39','2023-10-22 18:15:39'),(196,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 00:39:23','2023-10-23 00:39:23'),(197,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 00:40:04','2023-10-23 00:40:04'),(198,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 00:40:29','2023-10-23 00:40:29'),(199,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 00:49:07','2023-10-23 00:49:07'),(200,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 00:49:14','2023-10-23 00:49:14'),(201,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:08:03','2023-10-23 13:08:03'),(202,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:08:32','2023-10-23 13:08:32'),(203,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:51:36','2023-10-23 13:51:36'),(204,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:59:14','2023-10-23 13:59:14'),(205,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 13:59:26','2023-10-23 13:59:26'),(206,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 16:42:06','2023-10-23 16:42:06'),(207,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 16:42:12','2023-10-23 16:42:12'),(208,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 18:49:23','2023-10-24 18:49:24'),(209,'default','added',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":61940}}',NULL,'2023-10-24 19:38:50','2023-10-24 19:38:50'),(210,'default','added',33,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:42:16','2023-10-24 19:42:16'),(211,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:47:21','2023-10-24 19:47:21'),(212,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:53:13','2023-10-24 19:53:13'),(213,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:59:28','2023-10-24 19:59:28'),(214,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 20:01:23','2023-10-24 20:01:23'),(215,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 10:28:16','2023-10-25 10:28:16'),(216,'default','added',34,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 11:27:03','2023-10-25 11:27:03'),(217,'default','added',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":377400}}',NULL,'2023-10-25 11:34:03','2023-10-25 11:34:03'),(218,'default','edited',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":341880},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"377400.0000\"}}',NULL,'2023-10-25 11:38:29','2023-10-25 11:38:29'),(219,'default','added',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50160}}',NULL,'2023-10-25 11:40:10','2023-10-25 11:40:10'),(220,'default','added',61,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":16020}}',NULL,'2023-10-25 11:43:37','2023-10-25 11:43:37'),(221,'default','added',62,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":18690}}',NULL,'2023-10-25 11:45:01','2023-10-25 11:45:01'),(222,'default','added',63,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":55944}}',NULL,'2023-10-25 11:50:47','2023-10-25 11:50:47'),(223,'default','added',64,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1192759}}',NULL,'2023-10-25 12:30:38','2023-10-25 12:30:38'),(224,'default','payment_edited',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"341880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"341880.0000\"}}',NULL,'2023-10-25 12:32:18','2023-10-25 12:32:18'),(225,'default','payment_edited',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"61940.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"61940.0000\"}}',NULL,'2023-10-25 12:33:02','2023-10-25 12:33:02'),(226,'default','added',65,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":338965}}',NULL,'2023-10-25 12:35:17','2023-10-25 12:35:17'),(227,'default','added',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":295394}}',NULL,'2023-10-25 13:01:34','2023-10-25 13:01:34'),(228,'default','edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":295394},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"295394.0000\"}}',NULL,'2023-10-25 13:30:03','2023-10-25 13:30:03'),(229,'default','added',67,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":149350}}',NULL,'2023-10-25 13:52:01','2023-10-25 13:52:01'),(230,'default','edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":366058},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"295394.0000\"}}',NULL,'2023-10-25 14:05:16','2023-10-25 14:05:16'),(231,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"366058.0000\"}}',NULL,'2023-10-25 14:05:49','2023-10-25 14:05:49'),(232,'default','added',68,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":211250}}',NULL,'2023-10-25 14:17:21','2023-10-25 14:17:21'),(233,'default','added',69,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":87080}}',NULL,'2023-10-25 14:20:38','2023-10-25 14:20:38'),(234,'default','purchase_deleted',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"341880.0000\"}}',NULL,'2023-10-25 14:23:00','2023-10-25 14:23:00'),(235,'default','edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":392040},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50160.0000\"}}',NULL,'2023-10-25 14:24:09','2023-10-25 14:24:09'),(236,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"392040.0000\"}}',NULL,'2023-10-25 14:25:06','2023-10-25 14:25:06'),(237,'default','added',70,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50305}}',NULL,'2023-10-25 14:32:19','2023-10-25 14:32:19'),(238,'default','added',71,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":272320}}',NULL,'2023-10-25 14:35:37','2023-10-25 14:35:37'),(239,'default','added',72,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":93779}}',NULL,'2023-10-25 14:47:24','2023-10-25 14:47:24'),(240,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 14:56:07','2023-10-25 14:56:07'),(241,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 14:56:33','2023-10-25 14:56:33'),(242,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 14:58:48','2023-10-25 14:58:48'),(243,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 14:58:57','2023-10-25 14:58:57'),(244,'default','added',73,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6060}}',NULL,'2023-10-25 15:02:43','2023-10-25 15:02:43'),(245,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:08:37','2023-10-25 15:08:37'),(246,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:09:20','2023-10-25 15:09:20'),(247,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:09:25','2023-10-25 15:09:25'),(248,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:09:45','2023-10-25 15:09:45'),(249,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:09:50','2023-10-25 15:09:50'),(250,'default','added',74,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":25850}}',NULL,'2023-10-25 15:10:36','2023-10-25 15:10:36'),(251,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:11:40','2023-10-25 15:11:40'),(252,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:11:47','2023-10-25 15:11:47'),(253,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:12:27','2023-10-25 15:12:27'),(254,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:12:34','2023-10-25 15:12:34'),(255,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:13:52','2023-10-25 15:13:52'),(256,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:13:57','2023-10-25 15:13:57'),(257,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:14:46','2023-10-25 15:14:46'),(258,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:14:51','2023-10-25 15:14:51'),(259,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:15:43','2023-10-25 15:15:43'),(260,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:15:56','2023-10-25 15:15:56'),(261,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:16:40','2023-10-25 15:16:40'),(262,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:16:46','2023-10-25 15:16:46'),(263,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:16:57','2023-10-25 15:16:57'),(264,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:17:03','2023-10-25 15:17:03'),(265,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:20:33','2023-10-25 15:20:33'),(266,'default','purchase_deleted',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"paid\",\"final_total\":\"191490.0000\"}}',NULL,'2023-10-25 15:31:18','2023-10-25 15:31:18'),(267,'default','edited',72,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":27625},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"93779.0000\"}}',NULL,'2023-10-25 15:40:55','2023-10-25 15:40:55'),(268,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:44:16','2023-10-25 15:44:16'),(269,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:44:21','2023-10-25 15:44:21'),(270,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:44:25','2023-10-25 15:44:25'),(271,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:49:54','2023-10-25 15:49:54'),(272,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:49:58','2023-10-25 15:49:58'),(273,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 17:37:29','2023-10-25 17:37:29'),(274,'default','edited',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":80522},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"61940.0000\"}}',NULL,'2023-10-25 18:17:30','2023-10-25 18:17:30'),(275,'default','payment_edited',62,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"18690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"18690.0000\"}}',NULL,'2023-10-25 18:21:31','2023-10-25 18:21:31'),(276,'default','payment_edited',61,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"16020.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"16020.0000\"}}',NULL,'2023-10-25 18:22:04','2023-10-25 18:22:04'),(277,'default','payment_edited',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"80522.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"80522.0000\"}}',NULL,'2023-10-25 18:22:36','2023-10-25 18:22:36'),(278,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 18:55:55','2023-10-25 18:55:55'),(279,'default','added',75,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":40480}}',NULL,'2023-10-25 19:02:11','2023-10-25 19:02:11'),(280,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 19:56:57','2023-10-25 19:56:57'),(281,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 19:57:04','2023-10-25 19:57:04'),(282,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 19:57:26','2023-10-25 19:57:26'),(283,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 19:57:31','2023-10-25 19:57:31'),(284,'default','added',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":502690}}',NULL,'2023-10-25 20:27:43','2023-10-25 20:27:43'),(285,'default','payment_edited',71,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"272320.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"272320.0000\"}}',NULL,'2023-10-25 20:29:45','2023-10-25 20:29:45'),(286,'default','added',77,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5370}}',NULL,'2023-10-25 20:34:15','2023-10-25 20:34:15'),(287,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 20:53:38','2023-10-25 20:53:38'),(288,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 12:23:41','2023-10-26 12:23:41'),(289,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-10-26 12:43:23','2023-10-26 12:43:23'),(290,'default','added',78,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36440}}',NULL,'2023-10-26 13:00:03','2023-10-26 13:00:03'),(291,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 13:00:24','2023-10-26 13:00:24'),(292,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 13:16:38','2023-10-26 13:16:38'),(293,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-26 13:19:45','2023-10-26 13:19:45'),(294,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-26 13:19:51','2023-10-26 13:19:51'),(295,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 13:19:55','2023-10-26 13:19:55'),(296,'default','edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":502690},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"502690.0000\"}}',NULL,'2023-10-26 14:52:36','2023-10-26 14:52:36'),(297,'default','edited',64,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":1192759},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"1192759.0000\"}}',NULL,'2023-10-26 14:54:15','2023-10-26 14:54:15'),(298,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 17:33:03','2023-10-26 17:33:03'),(299,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 17:33:06','2023-10-26 17:33:06'),(300,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 13:58:24','2023-10-27 13:58:24'),(301,'default','added',79,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15110}}',NULL,'2023-10-27 14:05:25','2023-10-27 14:05:25'),(302,'default','added',80,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":129930}}',NULL,'2023-10-27 14:29:48','2023-10-27 14:29:48'),(303,'default','added',81,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21330}}',NULL,'2023-10-27 14:47:33','2023-10-27 14:47:33'),(304,'default','added',82,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":79192}}',NULL,'2023-10-27 15:01:40','2023-10-27 15:01:40'),(305,'default','added',83,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1040}}',NULL,'2023-10-27 15:04:16','2023-10-27 15:04:16'),(306,'default','added',84,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7600}}',NULL,'2023-10-27 15:07:34','2023-10-27 15:07:34'),(307,'default','added',85,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9120}}',NULL,'2023-10-27 15:08:14','2023-10-27 15:08:14'),(308,'default','added',86,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18370}}',NULL,'2023-10-27 15:13:43','2023-10-27 15:13:43'),(309,'default','added',87,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76000}}',NULL,'2023-10-27 15:16:47','2023-10-27 15:16:47'),(310,'default','added',88,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-10-27 15:18:48','2023-10-27 15:18:48'),(311,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 15:23:16','2023-10-27 15:23:16'),(312,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 19:17:00','2023-10-27 19:17:00'),(313,'default','added',89,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:22:30','2023-10-27 19:22:30'),(314,'default','added',90,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:27:04','2023-10-27 19:27:04'),(315,'default','added',91,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:36:44','2023-10-27 19:36:44'),(316,'default','added',92,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:37:39','2023-10-27 19:37:39'),(317,'default','added',93,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:38:22','2023-10-27 19:38:22'),(318,'default','added',94,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:38:56','2023-10-27 19:38:56'),(319,'default','added',95,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:40:26','2023-10-27 19:40:26'),(320,'default','edited',27,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:05:15','2023-10-27 20:05:15'),(321,'default','contact_deleted',27,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:05:36','2023-10-27 20:05:36'),(322,'default','added',35,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:07:14','2023-10-27 20:07:14'),(323,'default','edited',12,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:12:38','2023-10-27 20:12:38'),(324,'default','added',36,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:14:00','2023-10-27 20:14:00'),(325,'default','edited',36,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:16:18','2023-10-27 20:16:18'),(326,'default','added',37,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:18:39','2023-10-27 20:18:39'),(327,'default','added',99,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":169075}}',NULL,'2023-10-27 20:26:57','2023-10-27 20:26:57'),(328,'default','added',100,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":35250}}',NULL,'2023-10-27 20:32:56','2023-10-27 20:32:56'),(329,'default','edited',77,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5370},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5370.0000\"}}',NULL,'2023-10-27 23:28:21','2023-10-27 23:28:21'),(330,'default','edited',78,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36440},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"36440.0000\"}}',NULL,'2023-10-27 23:38:12','2023-10-27 23:38:12'),(331,'default','added',101,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-10-27 23:49:40','2023-10-27 23:49:40'),(332,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 01:04:47','2023-10-28 01:04:47'),(333,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 10:46:29','2023-10-28 10:46:29'),(334,'default','added',38,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:17:36','2023-10-28 11:17:36'),(335,'default','added',39,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:18:49','2023-10-28 11:18:49'),(336,'default','added',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:28:53','2023-10-28 11:28:53'),(337,'default','edited',35,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:30:59','2023-10-28 11:30:59'),(338,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:33:02','2023-10-28 11:33:02'),(339,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 12:08:14','2023-10-28 12:08:14'),(340,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 14:33:27','2023-10-28 14:33:27'),(341,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 17:29:16','2023-10-28 17:29:16'),(342,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 17:46:52','2023-10-28 17:46:52'),(343,'default','payment_edited',98,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 17:49:29','2023-10-28 17:49:29'),(344,'default','added',106,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25950}}',NULL,'2023-10-28 17:58:57','2023-10-28 17:58:57'),(345,'default','added',107,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9640}}',NULL,'2023-10-28 18:12:44','2023-10-28 18:12:44'),(346,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 18:14:22','2023-10-28 18:14:22'),(347,'default','added',108,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-10-28 18:20:17','2023-10-28 18:20:17'),(348,'default','sell_deleted',108,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":108,\"invoice_no\":\"0036\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-28 18:26:26','2023-10-28 18:26:26'),(349,'default','added',109,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12600}}',NULL,'2023-10-28 18:38:17','2023-10-28 18:38:17'),(350,'default','added',110,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35180}}',NULL,'2023-10-28 18:51:27','2023-10-28 18:51:27'),(351,'default','added',111,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40620}}',NULL,'2023-10-28 18:57:11','2023-10-28 18:57:11'),(352,'default','added',112,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-28 19:56:04','2023-10-28 19:56:04'),(353,'default','added',41,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 20:12:03','2023-10-28 20:12:03'),(354,'default','added',113,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":173140}}',NULL,'2023-10-28 20:15:10','2023-10-28 20:15:10'),(355,'default','added',114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":49860}}',NULL,'2023-10-28 20:17:16','2023-10-28 20:17:16'),(356,'default','payment_edited',71,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"272320.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"272320.0000\"}}',NULL,'2023-10-28 20:19:37','2023-10-28 20:19:37'),(357,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"502690.0000\"}}',NULL,'2023-10-28 20:19:37','2023-10-28 20:19:37'),(358,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 20:30:36','2023-10-28 20:30:36'),(359,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 12:41:14','2023-10-29 12:41:14'),(360,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 13:07:55','2023-10-29 13:07:55'),(361,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 13:07:59','2023-10-29 13:07:59'),(362,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 17:25:28','2023-10-29 17:25:28'),(363,'default','added',115,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3300}}',NULL,'2023-10-29 17:38:54','2023-10-29 17:38:54'),(364,'default','added',116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56561.0400000000008731149137020111083984375}}',NULL,'2023-10-29 17:45:19','2023-10-29 17:45:19'),(365,'default','added',117,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33068.949999999997089616954326629638671875}}',NULL,'2023-10-29 18:13:27','2023-10-29 18:13:27'),(366,'default','added',118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30660.02000000000043655745685100555419921875}}',NULL,'2023-10-29 18:20:12','2023-10-29 18:20:12'),(367,'default','added',119,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26150}}',NULL,'2023-10-29 18:25:17','2023-10-29 18:25:17'),(368,'default','added',120,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-10-29 18:28:13','2023-10-29 18:28:13'),(369,'default','added',42,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:31:37','2023-10-29 18:31:37'),(370,'default','added',121,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-10-29 18:32:36','2023-10-29 18:32:36'),(371,'default','added',122,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-10-29 18:35:11','2023-10-29 18:35:11'),(372,'default','added',123,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":97600}}',NULL,'2023-10-29 18:36:30','2023-10-29 18:36:30'),(373,'default','edited',123,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":115200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"97600.0000\"}}',NULL,'2023-10-29 18:37:39','2023-10-29 18:37:39'),(374,'default','added',43,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:38:26','2023-10-29 18:38:26'),(375,'default','added',124,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2400}}',NULL,'2023-10-29 18:39:13','2023-10-29 18:39:13'),(376,'default','added',125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-10-29 18:40:30','2023-10-29 18:40:30'),(377,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:42:55','2023-10-29 18:42:55'),(378,'default','added',126,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4770}}',NULL,'2023-10-29 18:44:44','2023-10-29 18:44:44'),(379,'default','payment_edited',42,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:45:33','2023-10-29 18:45:33'),(380,'default','added',127,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:49:00','2023-10-29 18:49:00'),(381,'default','added',128,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:50:23','2023-10-29 18:50:23'),(382,'default','payment_edited',68,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"211250.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"211250.0000\"}}',NULL,'2023-10-29 18:55:40','2023-10-29 18:55:40'),(383,'default','payment_edited',68,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"211250.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"211250.0000\"}}',NULL,'2023-10-29 18:56:17','2023-10-29 18:56:17'),(384,'default','payment_edited',99,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"169075.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"169075.0000\"}}',NULL,'2023-10-29 18:56:17','2023-10-29 18:56:17'),(385,'default','added',129,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:57:28','2023-10-29 18:57:28'),(386,'default','payment_edited',91,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:57:59','2023-10-29 18:57:59'),(387,'default','payment_edited',95,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:17','2023-10-29 18:58:17'),(388,'default','payment_edited',94,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:28','2023-10-29 18:58:28'),(389,'default','payment_edited',93,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:39','2023-10-29 18:58:39'),(390,'default','payment_edited',92,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:50','2023-10-29 18:58:50'),(391,'default','added',130,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-10-29 19:07:43','2023-10-29 19:07:43'),(392,'default','added',44,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:11:46','2023-10-29 19:11:46'),(393,'default','added',45,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:12:45','2023-10-29 19:12:45'),(394,'default','added',46,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:13:59','2023-10-29 19:13:59'),(395,'default','added',47,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:15:16','2023-10-29 19:15:16'),(396,'default','edited',38,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:17:12','2023-10-29 19:17:12'),(397,'default','payment_edited',103,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:19:10','2023-10-29 19:19:10'),(398,'default','payment_edited',36,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:30:27','2023-10-29 19:30:27'),(399,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"}}',NULL,'2023-10-29 19:30:27','2023-10-29 19:30:27'),(400,'default','added',135,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-10-29 19:44:55','2023-10-29 19:44:55'),(401,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:56:01','2023-10-29 19:56:01'),(402,'default','added',136,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-10-29 20:07:08','2023-10-29 20:07:08'),(403,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 20:22:44','2023-10-29 20:22:44'),(404,'default','added',137,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-10-29 20:52:09','2023-10-29 20:52:09'),(405,'default','added',138,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7830}}',NULL,'2023-10-29 20:59:34','2023-10-29 20:59:34'),(406,'default','added',140,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-10-29 21:04:43','2023-10-29 21:04:43'),(407,'default','added',141,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250}}',NULL,'2023-10-29 21:18:53','2023-10-29 21:18:53'),(408,'default','added',142,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5950}}',NULL,'2023-10-29 21:24:37','2023-10-29 21:24:37'),(409,'default','added',147,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-10-29 21:33:35','2023-10-29 21:33:35'),(410,'default','added',148,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4950}}',NULL,'2023-10-29 21:36:02','2023-10-29 21:36:02'),(411,'default','added',150,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-10-29 21:39:08','2023-10-29 21:39:08'),(412,'default','added',153,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-10-29 21:42:12','2023-10-29 21:42:12'),(413,'default','added',156,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-10-29 21:45:11','2023-10-29 21:45:11'),(414,'default','added',158,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-29 21:51:13','2023-10-29 21:51:13'),(415,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 22:01:38','2023-10-29 22:01:38'),(416,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 12:43:56','2023-10-30 12:43:56'),(417,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 12:53:20','2023-10-30 12:53:20'),(418,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 12:53:41','2023-10-30 12:53:41'),(419,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:07:49','2023-10-30 13:07:49'),(420,'default','edited',1,'App\\User',NULL,1,3,'App\\User','{\"name\":\" Super Admin\"}',NULL,'2023-10-30 13:22:40','2023-10-30 13:22:40'),(421,'default','edited',2,'App\\User',NULL,1,3,'App\\User','{\"name\":\" Salam Enterprise Staff\"}',NULL,'2023-10-30 13:23:14','2023-10-30 13:23:14'),(422,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:23:48','2023-10-30 13:23:48'),(423,'default','added',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:30:02','2023-10-30 13:30:02'),(424,'default','payment_edited',124,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2400.0000\"}}',NULL,'2023-10-30 13:33:46','2023-10-30 13:33:46'),(425,'default','added',159,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-10-30 13:36:25','2023-10-30 13:36:25'),(426,'default','edited',43,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:37:35','2023-10-30 13:37:35'),(427,'default','added',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":165900}}',NULL,'2023-10-30 13:53:55','2023-10-30 13:53:55'),(428,'default','added',161,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-10-30 13:55:18','2023-10-30 13:55:18'),(429,'default','added',162,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-10-30 13:56:22','2023-10-30 13:56:22'),(430,'default','added',163,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-10-30 13:58:18','2023-10-30 13:58:18'),(431,'default','added',49,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 14:06:27','2023-10-30 14:06:27'),(432,'default','added',164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-10-30 14:07:58','2023-10-30 14:07:58'),(433,'default','added',165,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-10-30 14:08:57','2023-10-30 14:08:57'),(434,'default','added',166,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7400}}',NULL,'2023-10-30 14:12:02','2023-10-30 14:12:02'),(435,'default','added',167,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-10-30 14:13:21','2023-10-30 14:13:21'),(436,'default','added',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-10-30 14:19:38','2023-10-30 14:19:38'),(437,'default','added',169,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11900}}',NULL,'2023-10-30 14:29:12','2023-10-30 14:29:12'),(438,'default','added',170,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33000}}',NULL,'2023-10-30 14:34:24','2023-10-30 14:34:24'),(439,'default','added',50,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 14:36:05','2023-10-30 14:36:05'),(440,'default','added',171,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3130}}',NULL,'2023-10-30 14:37:51','2023-10-30 14:37:51'),(441,'default','added',172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-10-30 14:38:24','2023-10-30 14:38:24'),(442,'default','added',173,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-10-30 14:42:47','2023-10-30 14:42:47'),(443,'default','added',174,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5380}}',NULL,'2023-10-30 14:44:07','2023-10-30 14:44:07'),(444,'default','added',175,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-10-30 14:44:49','2023-10-30 14:44:49'),(445,'default','added',176,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15169.5}}',NULL,'2023-10-30 14:59:23','2023-10-30 14:59:23'),(446,'default','added',177,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-10-30 15:02:42','2023-10-30 15:02:42'),(447,'default','added',178,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11434.600000000000363797880709171295166015625}}',NULL,'2023-10-30 15:11:34','2023-10-30 15:11:34'),(448,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 16:07:37','2023-10-30 16:07:37'),(449,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 16:07:40','2023-10-30 16:07:40'),(450,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 17:17:17','2023-10-30 17:17:17'),(451,'default','added',179,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-10-30 17:19:11','2023-10-30 17:19:11'),(452,'default','edited',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 17:21:49','2023-10-30 17:21:49'),(453,'default','payment_edited',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"165900.0000\"}}',NULL,'2023-10-30 17:22:21','2023-10-30 17:22:21'),(454,'default','payment_edited',164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-30 17:44:45','2023-10-30 17:44:45'),(455,'default','added',180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":192160}}',NULL,'2023-10-30 17:58:44','2023-10-30 17:58:44'),(456,'default','added',181,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3450}}',NULL,'2023-10-30 17:59:21','2023-10-30 17:59:21'),(457,'default','added',182,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-10-30 18:01:05','2023-10-30 18:01:05'),(458,'default','added',183,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-10-30 18:02:34','2023-10-30 18:02:34'),(459,'default','added',184,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-10-30 18:04:51','2023-10-30 18:04:51'),(460,'default','added',185,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-10-30 18:06:33','2023-10-30 18:06:33'),(461,'default','added',186,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25280}}',NULL,'2023-10-30 18:13:50','2023-10-30 18:13:50'),(462,'default','added',187,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-10-30 18:19:12','2023-10-30 18:19:12'),(463,'default','added',188,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16750}}',NULL,'2023-10-30 18:23:58','2023-10-30 18:23:58'),(464,'default','added',189,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5550}}',NULL,'2023-10-30 18:28:40','2023-10-30 18:28:40'),(465,'default','added',190,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-10-30 18:32:16','2023-10-30 18:32:16'),(466,'default','added',191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50070}}',NULL,'2023-10-30 18:34:50','2023-10-30 18:34:50'),(467,'default','added',51,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 18:40:16','2023-10-30 18:40:16'),(468,'default','added',192,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-10-30 18:41:34','2023-10-30 18:41:34'),(469,'default','added',193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6200}}',NULL,'2023-10-30 18:43:03','2023-10-30 18:43:03'),(470,'default','added',194,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16459.20000000000072759576141834259033203125}}',NULL,'2023-10-30 18:45:15','2023-10-30 18:45:15'),(471,'default','added',195,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7700}}',NULL,'2023-10-30 18:48:05','2023-10-30 18:48:05'),(472,'default','added',196,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-10-30 18:51:20','2023-10-30 18:51:20'),(473,'default','added',197,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-10-30 18:52:41','2023-10-30 18:52:41'),(474,'default','added',198,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-10-30 18:57:12','2023-10-30 18:57:12'),(475,'default','added',199,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-30 19:02:05','2023-10-30 19:02:05'),(476,'default','added',200,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-10-30 19:23:47','2023-10-30 19:23:47'),(477,'default','added',201,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-30 19:24:35','2023-10-30 19:24:35'),(478,'default','added',202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4550}}',NULL,'2023-10-30 19:28:56','2023-10-30 19:28:56'),(479,'default','added',52,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:31:43','2023-10-30 19:31:43'),(480,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:32:01','2023-10-30 19:32:01'),(481,'default','added',204,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-10-30 19:33:50','2023-10-30 19:33:50'),(482,'default','added',205,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-10-30 19:34:10','2023-10-30 19:34:10'),(483,'default','added',206,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-10-30 19:37:30','2023-10-30 19:37:30'),(484,'default','added',53,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:41:31','2023-10-30 19:41:31'),(485,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:42:25','2023-10-30 19:42:25'),(486,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:08:07','2023-10-31 11:08:07'),(487,'default','payment_edited',132,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:10:14','2023-10-31 11:10:14'),(488,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:10:46','2023-10-31 11:10:46'),(489,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:11:16','2023-10-31 11:11:16'),(490,'default','added',208,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29049.5999999999985448084771633148193359375}}',NULL,'2023-10-31 11:19:21','2023-10-31 11:19:21'),(491,'default','added',209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-10-31 11:24:33','2023-10-31 11:24:33'),(492,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-10-31 11:30:38','2023-10-31 11:30:38'),(493,'default','added',210,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25200}}',NULL,'2023-10-31 11:44:45','2023-10-31 11:44:45'),(494,'default','added',211,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-10-31 11:46:20','2023-10-31 11:46:20'),(495,'default','added',212,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-10-31 11:52:27','2023-10-31 11:52:27'),(496,'default','added',213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":15020}}',NULL,'2023-10-31 11:57:23','2023-10-31 11:57:23'),(497,'default','added',214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2023-10-31 12:00:00','2023-10-31 12:00:00'),(498,'default','added',215,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 12:01:09','2023-10-31 12:01:09'),(499,'default','added',216,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 12:01:58','2023-10-31 12:01:58'),(500,'default','added',217,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 12:03:40','2023-10-31 12:03:40'),(501,'default','added',54,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:04:58','2023-10-31 12:04:58'),(502,'default','edited',54,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:06:10','2023-10-31 12:06:10'),(503,'default','edited',54,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:06:19','2023-10-31 12:06:19'),(504,'default','payment_edited',172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-10-31 12:12:59','2023-10-31 12:12:59'),(505,'default','payment_edited',218,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:13:53','2023-10-31 12:13:53'),(506,'default','added',219,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12090}}',NULL,'2023-10-31 12:18:16','2023-10-31 12:18:16'),(507,'default','added',220,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-10-31 12:25:13','2023-10-31 12:25:13'),(508,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:38:54','2023-10-31 12:38:54'),(509,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:38:58','2023-10-31 12:38:58'),(510,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:40:29','2023-10-31 12:40:29'),(511,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:53:42','2023-10-31 12:53:42'),(512,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:53:46','2023-10-31 12:53:46'),(513,'default','added',55,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:55:34','2023-10-31 12:55:34'),(514,'default','added',222,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":15150}}',NULL,'2023-10-31 12:58:52','2023-10-31 12:58:52'),(515,'default','added',223,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-10-31 13:45:39','2023-10-31 13:45:39'),(516,'default','added',224,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-10-31 14:20:49','2023-10-31 14:20:49'),(517,'default','added',225,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12160}}',NULL,'2023-10-31 14:36:07','2023-10-31 14:36:07'),(518,'default','added',226,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-10-31 14:39:53','2023-10-31 14:39:53'),(519,'default','added',227,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-31 14:41:45','2023-10-31 14:41:45'),(520,'default','added',228,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 14:44:34','2023-10-31 14:44:34'),(521,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 15:17:38','2023-10-31 15:17:38'),(522,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 17:35:26','2023-10-31 17:35:26'),(523,'default','payment_edited',164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-31 17:41:55','2023-10-31 17:41:55'),(524,'default','added',229,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11500}}',NULL,'2023-10-31 17:47:28','2023-10-31 17:47:28'),(525,'default','added',230,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-10-31 17:48:32','2023-10-31 17:48:32'),(526,'default','added',56,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 17:52:03','2023-10-31 17:52:03'),(527,'default','payment_edited',231,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 17:55:07','2023-10-31 17:55:07'),(528,'default','added',232,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-10-31 17:57:23','2023-10-31 17:57:23'),(529,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:17:59','2023-10-31 18:17:59'),(530,'default','added',57,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:48:47','2023-10-31 18:48:47'),(531,'default','added',233,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-10-31 18:49:14','2023-10-31 18:49:14'),(532,'default','added',234,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-10-31 18:52:01','2023-10-31 18:52:01'),(533,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:54:09','2023-10-31 18:54:09'),(534,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:54:12','2023-10-31 18:54:13'),(535,'default','payment_edited',193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6200.0000\"}}',NULL,'2023-10-31 18:55:26','2023-10-31 18:55:26'),(536,'default','added',235,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-10-31 18:57:02','2023-10-31 18:57:02'),(537,'default','added',236,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4650}}',NULL,'2023-10-31 18:58:30','2023-10-31 18:58:30'),(538,'default','added',237,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-10-31 19:39:23','2023-10-31 19:39:23'),(539,'default','added',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":187880}}',NULL,'2023-10-31 20:02:52','2023-10-31 20:02:52'),(540,'default','payment_edited',64,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"1192759.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"1192759.0000\"}}',NULL,'2023-10-31 20:04:33','2023-10-31 20:04:33'),(541,'default','payment_edited',180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"192160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"192160.0000\"}}',NULL,'2023-10-31 20:04:33','2023-10-31 20:04:33'),(542,'default','added',239,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":46800}}',NULL,'2023-10-31 20:12:40','2023-10-31 20:12:40'),(543,'default','added',240,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 20:14:24','2023-10-31 20:14:24'),(544,'default','added',241,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 20:15:39','2023-10-31 20:15:39'),(545,'default','added',242,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 20:16:02','2023-10-31 20:16:02'),(546,'default','added',243,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6270}}',NULL,'2023-10-31 20:18:04','2023-10-31 20:18:04'),(547,'default','added',244,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1500}}',NULL,'2023-10-31 20:30:59','2023-10-31 20:30:59'),(548,'default','payment_edited',244,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-10-31 20:38:09','2023-10-31 20:38:09'),(549,'default','added',245,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-10-31 20:40:47','2023-10-31 20:40:47'),(550,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 20:43:15','2023-10-31 20:43:15'),(551,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 11:15:19','2023-11-01 11:15:19'),(552,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:11:57','2023-11-01 17:11:57'),(553,'default','added',246,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-01 17:14:11','2023-11-01 17:14:11'),(554,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:16:08','2023-11-01 17:16:08'),(555,'default','payment_edited',233,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-01 17:23:15','2023-11-01 17:23:15'),(556,'default','added',247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-01 17:26:40','2023-11-01 17:26:40'),(557,'default','edited',247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-01 17:28:07','2023-11-01 17:28:07'),(558,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:29:11','2023-11-01 17:29:11'),(559,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:32:13','2023-11-01 17:32:13'),(560,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:32:18','2023-11-01 17:32:18'),(561,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:33:10','2023-11-01 17:33:10'),(562,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:33:12','2023-11-01 17:33:12'),(563,'default','added',248,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29000}}',NULL,'2023-11-01 17:44:15','2023-11-01 17:44:15'),(564,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:46:33','2023-11-01 17:46:33'),(565,'default','added',249,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31730}}',NULL,'2023-11-01 17:51:23','2023-11-01 17:51:23'),(566,'default','added',250,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9080}}',NULL,'2023-11-01 17:53:29','2023-11-01 17:53:29'),(567,'default','added',58,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:54:31','2023-11-01 17:54:31'),(568,'default','added',251,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-01 17:55:12','2023-11-01 17:55:12'),(569,'default','added',59,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:56:52','2023-11-01 17:56:52'),(570,'default','added',252,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750}}',NULL,'2023-11-01 17:57:12','2023-11-01 17:57:12'),(571,'default','added',60,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:02:56','2023-11-01 18:02:56'),(572,'default','added',253,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-01 18:05:09','2023-11-01 18:05:09'),(573,'default','edited',60,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:07:18','2023-11-01 18:07:18'),(574,'default','added',255,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-11-01 18:08:15','2023-11-01 18:08:15'),(575,'default','added',256,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-01 18:33:40','2023-11-01 18:33:40'),(576,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:35:43','2023-11-01 18:35:43'),(577,'default','added',257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":53400}}',NULL,'2023-11-01 18:44:42','2023-11-01 18:44:42'),(578,'default','payment_edited',99,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"169075.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"169075.0000\"}}',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(579,'default','payment_edited',239,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"46800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"46800.0000\"}}',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(580,'default','payment_edited',257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"53400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"53400.0000\"}}',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(581,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:53:16','2023-11-01 18:53:16'),(582,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:54:00','2023-11-01 18:54:00'),(583,'default','added',258,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-01 18:55:44','2023-11-01 18:55:44'),(584,'default','added',61,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 19:21:42','2023-11-01 19:21:42'),(585,'default','added',259,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750}}',NULL,'2023-11-01 19:22:27','2023-11-01 19:22:27'),(586,'default','added',260,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-01 19:23:25','2023-11-01 19:23:25'),(587,'default','added',261,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-01 19:27:52','2023-11-01 19:27:52'),(588,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 19:31:32','2023-11-01 19:31:32'),(589,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 19:32:44','2023-11-01 19:32:44'),(590,'default','added',262,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1530}}',NULL,'2023-11-01 19:36:35','2023-11-01 19:36:35'),(591,'default','added',263,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-01 19:48:27','2023-11-01 19:48:27'),(592,'default','added',264,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-01 19:50:37','2023-11-01 19:50:37'),(593,'default','added',265,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-01 19:55:44','2023-11-01 19:55:44'),(594,'default','added',266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-01 20:01:42','2023-11-01 20:01:42'),(595,'default','added',267,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-01 20:07:04','2023-11-01 20:07:04'),(596,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 20:19:58','2023-11-01 20:19:58'),(597,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 10:14:50','2023-11-02 10:14:50'),(598,'default','added',268,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-02 10:23:57','2023-11-02 10:23:57'),(599,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 10:25:57','2023-11-02 10:25:57'),(600,'default','added',269,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-02 10:33:07','2023-11-02 10:33:07'),(601,'default','added',270,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4480}}',NULL,'2023-11-02 10:34:26','2023-11-02 10:34:26'),(602,'default','payment_edited',252,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1750.0000\"}}',NULL,'2023-11-02 10:39:07','2023-11-02 10:39:07'),(603,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 10:41:14','2023-11-02 10:41:14'),(604,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-02 10:43:54','2023-11-02 10:43:54'),(605,'default','added',271,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 10:45:46','2023-11-02 10:45:46'),(606,'default','added',272,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 10:46:16','2023-11-02 10:46:16'),(607,'default','added',273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-02 10:47:55','2023-11-02 10:47:55'),(608,'default','added',274,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24350}}',NULL,'2023-11-02 10:51:44','2023-11-02 10:51:44'),(609,'default','added',275,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8290}}',NULL,'2023-11-02 10:54:55','2023-11-02 10:54:55'),(610,'default','added',276,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-02 10:55:16','2023-11-02 10:55:16'),(611,'default','added',62,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 11:00:20','2023-11-02 11:00:20'),(612,'default','added',278,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-11-02 11:01:36','2023-11-02 11:01:36'),(613,'default','payment_edited',56,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 11:19:14','2023-11-02 11:19:14'),(614,'default','added',279,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-02 11:32:35','2023-11-02 11:32:35'),(615,'default','added',280,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-02 11:37:22','2023-11-02 11:37:22'),(616,'default','added',281,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-02 11:48:53','2023-11-02 11:48:53'),(617,'default','added',282,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-02 11:55:41','2023-11-02 11:55:41'),(618,'default','added',283,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-02 12:02:20','2023-11-02 12:02:20'),(619,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"}}',NULL,'2023-11-02 12:20:01','2023-11-02 12:20:01'),(620,'default','added',284,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3650}}',NULL,'2023-11-02 12:25:11','2023-11-02 12:25:11'),(621,'default','added',285,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-11-02 12:26:51','2023-11-02 12:26:51'),(622,'default','added',286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3100}}',NULL,'2023-11-02 12:33:44','2023-11-02 12:33:44'),(623,'default','added',287,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-02 12:41:50','2023-11-02 12:41:50'),(624,'default','added',288,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-02 12:50:29','2023-11-02 12:50:29'),(625,'default','added',289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-11-02 13:17:27','2023-11-02 13:17:27'),(626,'default','added',290,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-02 13:21:43','2023-11-02 13:21:43'),(627,'default','added',291,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-02 13:32:44','2023-11-02 13:32:44'),(628,'default','added',292,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2023-11-02 14:02:13','2023-11-02 14:02:13'),(629,'default','added',293,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-11-02 14:03:55','2023-11-02 14:03:55'),(630,'default','payment_edited',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"}}',NULL,'2023-11-02 14:15:11','2023-11-02 14:15:11'),(631,'default','added',294,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-02 14:17:52','2023-11-02 14:17:52'),(632,'default','added',295,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11900}}',NULL,'2023-11-02 14:34:48','2023-11-02 14:34:48'),(633,'default','added',296,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":42140}}',NULL,'2023-11-02 14:39:04','2023-11-02 14:39:04'),(634,'default','added',297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":69360}}',NULL,'2023-11-02 14:43:00','2023-11-02 14:43:00'),(635,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 14:57:20','2023-11-02 14:57:20'),(636,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:24:15','2023-11-02 17:24:15'),(637,'default','added',298,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-02 17:34:07','2023-11-02 17:34:07'),(638,'default','added',299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-02 17:36:44','2023-11-02 17:36:44'),(639,'default','added',300,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-02 17:38:07','2023-11-02 17:38:07'),(640,'default','added',301,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-02 17:38:46','2023-11-02 17:38:46'),(641,'default','added',63,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:40:54','2023-11-02 17:40:54'),(642,'default','edited',63,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:42:09','2023-11-02 17:42:09'),(643,'default','added',303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5250}}',NULL,'2023-11-02 17:43:52','2023-11-02 17:43:52'),(644,'default','added',304,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29380}}',NULL,'2023-11-02 17:48:49','2023-11-02 17:48:49'),(645,'default','added',305,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-02 17:49:47','2023-11-02 17:49:47'),(646,'default','payment_edited',43,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:51:32','2023-11-02 17:51:32'),(647,'default','added',306,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10900}}',NULL,'2023-11-02 17:53:30','2023-11-02 17:53:30'),(648,'default','added',307,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-02 17:55:53','2023-11-02 17:55:53'),(649,'default','payment_edited',113,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"173140.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"173140.0000\"}}',NULL,'2023-11-02 17:56:42','2023-11-02 17:56:42'),(650,'default','payment_edited',69,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"87080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87080.0000\"}}',NULL,'2023-11-02 17:57:03','2023-11-02 17:57:03'),(651,'default','payment_edited',191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"50070.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50070.0000\"}}',NULL,'2023-11-02 17:57:03','2023-11-02 17:57:03'),(652,'default','added',308,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5630}}',NULL,'2023-11-02 18:21:08','2023-11-02 18:21:08'),(653,'default','added',309,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-02 18:30:10','2023-11-02 18:30:10'),(654,'default','added',310,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 18:42:04','2023-11-02 18:42:04'),(655,'default','added',311,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 18:42:37','2023-11-02 18:42:37'),(656,'default','added',312,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-02 18:44:07','2023-11-02 18:44:07'),(657,'default','added',313,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-02 18:48:25','2023-11-02 18:48:25'),(658,'default','added',314,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-02 18:48:39','2023-11-02 18:48:39'),(659,'default','added',315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-02 19:01:05','2023-11-02 19:01:05'),(660,'default','added',316,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-02 19:46:51','2023-11-02 19:46:51'),(661,'default','added',64,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 19:57:50','2023-11-02 19:57:50'),(662,'default','edited',64,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 19:58:24','2023-11-02 19:58:24'),(663,'default','added',317,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5430}}',NULL,'2023-11-02 19:59:08','2023-11-02 19:59:08'),(664,'default','added',318,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7900}}',NULL,'2023-11-02 20:11:26','2023-11-02 20:11:26'),(665,'default','added',319,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-02 20:16:55','2023-11-02 20:16:55'),(666,'default','added',320,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-02 20:18:48','2023-11-02 20:18:48'),(667,'default','added',321,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23367.70000000000072759576141834259033203125}}',NULL,'2023-11-02 20:21:47','2023-11-02 20:21:47'),(668,'default','added',65,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 20:29:06','2023-11-02 20:29:06'),(669,'default','added',322,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-11-02 20:29:24','2023-11-02 20:29:24'),(670,'default','added',323,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-02 20:45:11','2023-11-02 20:45:11'),(671,'default','added',324,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-02 20:48:35','2023-11-02 20:48:35'),(672,'default','added',325,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-02 20:56:54','2023-11-02 20:56:54'),(673,'default','added',326,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32250}}',NULL,'2023-11-02 21:18:10','2023-11-02 21:18:10'),(674,'default','added',327,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-02 21:18:50','2023-11-02 21:18:50'),(675,'default','added',328,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9350}}',NULL,'2023-11-02 21:22:28','2023-11-02 21:22:28'),(676,'default','added',329,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-02 21:26:11','2023-11-02 21:26:11'),(677,'default','added',330,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3030}}',NULL,'2023-11-02 21:27:11','2023-11-02 21:27:11'),(678,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 21:27:31','2023-11-02 21:27:31'),(679,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-03 14:13:51','2023-11-03 14:13:51'),(680,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 10:14:31','2023-11-04 10:14:31'),(681,'default','added',331,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-04 10:15:17','2023-11-04 10:15:17'),(682,'default','payment_edited',251,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-04 10:21:45','2023-11-04 10:21:45'),(683,'default','payment_edited',295,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11900.0000\"}}',NULL,'2023-11-04 10:22:26','2023-11-04 10:22:26'),(684,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 10:29:53','2023-11-04 10:29:53'),(685,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 10:36:28','2023-11-04 10:36:28'),(686,'default','added',332,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-04 10:38:49','2023-11-04 10:38:49'),(687,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-11-04 10:43:51','2023-11-04 10:43:51'),(688,'default','added',333,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-11-04 10:49:19','2023-11-04 10:49:19'),(689,'default','added',334,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8950}}',NULL,'2023-11-04 10:56:46','2023-11-04 10:56:46'),(690,'default','added',335,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-04 10:59:25','2023-11-04 10:59:25'),(691,'default','added',336,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1490}}',NULL,'2023-11-04 11:23:57','2023-11-04 11:23:57'),(692,'default','added',337,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9650}}',NULL,'2023-11-04 11:25:55','2023-11-04 11:25:55'),(693,'default','added',338,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-04 11:28:17','2023-11-04 11:28:17'),(694,'default','added',339,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2180}}',NULL,'2023-11-04 11:43:17','2023-11-04 11:43:17'),(695,'default','added',340,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3780}}',NULL,'2023-11-04 11:47:05','2023-11-04 11:47:05'),(696,'default','added',341,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-04 11:48:48','2023-11-04 11:48:48'),(697,'default','added',342,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-04 11:51:04','2023-11-04 11:51:04'),(698,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 11:57:46','2023-11-04 11:57:46'),(699,'default','added',343,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-04 12:01:02','2023-11-04 12:01:02'),(700,'default','added',344,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900}}',NULL,'2023-11-04 12:01:59','2023-11-04 12:01:59'),(701,'default','added',345,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-04 12:04:53','2023-11-04 12:04:53'),(702,'default','added',346,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-11-04 12:14:33','2023-11-04 12:14:33'),(703,'default','added',347,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-04 12:18:05','2023-11-04 12:18:05'),(704,'default','added',348,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5130}}',NULL,'2023-11-04 12:29:45','2023-11-04 12:29:45'),(705,'default','added',349,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-04 12:32:13','2023-11-04 12:32:13'),(706,'default','added',350,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-04 12:36:02','2023-11-04 12:36:02'),(707,'default','added',351,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-04 12:41:53','2023-11-04 12:41:53'),(708,'default','added',352,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3030}}',NULL,'2023-11-04 12:43:51','2023-11-04 12:43:51'),(709,'default','added',353,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-04 12:44:33','2023-11-04 12:44:33'),(710,'default','added',354,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-11-04 12:46:11','2023-11-04 12:46:11'),(711,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 12:59:35','2023-11-04 12:59:35'),(712,'default','added',355,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-04 13:21:02','2023-11-04 13:21:02'),(713,'default','added',356,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-04 13:23:37','2023-11-04 13:23:37'),(714,'default','added',357,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-04 13:24:01','2023-11-04 13:24:01'),(715,'default','added',358,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 13:26:55','2023-11-04 13:26:55'),(716,'default','added',359,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 13:27:37','2023-11-04 13:27:37'),(717,'default','added',360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-04 13:28:57','2023-11-04 13:28:57'),(718,'default','added',361,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8590}}',NULL,'2023-11-04 13:32:12','2023-11-04 13:32:12'),(719,'default','added',362,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4930}}',NULL,'2023-11-04 13:35:06','2023-11-04 13:35:06'),(720,'default','added',363,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6050}}',NULL,'2023-11-04 13:37:38','2023-11-04 13:37:38'),(721,'default','added',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12670}}',NULL,'2023-11-04 13:41:24','2023-11-04 13:41:24'),(722,'default','added',365,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-04 13:45:44','2023-11-04 13:45:44'),(723,'default','added',366,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-04 13:48:16','2023-11-04 13:48:16'),(724,'default','added',367,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-11-04 13:52:38','2023-11-04 13:52:38'),(725,'default','added',368,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6700}}',NULL,'2023-11-04 14:00:18','2023-11-04 14:00:18'),(726,'default','added',369,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-04 14:04:06','2023-11-04 14:04:06'),(727,'default','added',370,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-04 14:09:00','2023-11-04 14:09:00'),(728,'default','added',371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":308000}}',NULL,'2023-11-04 14:11:45','2023-11-04 14:11:45'),(729,'default','added',372,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12950}}',NULL,'2023-11-04 14:15:26','2023-11-04 14:15:26'),(730,'default','added',373,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2440}}',NULL,'2023-11-04 14:24:30','2023-11-04 14:24:30'),(731,'default','added',374,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-04 14:31:30','2023-11-04 14:31:30'),(732,'default','added',375,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1364}}',NULL,'2023-11-04 16:30:10','2023-11-04 16:30:10'),(733,'default','purchase_deleted',375,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1364.0000\"}}',NULL,'2023-11-04 16:30:48','2023-11-04 16:30:48'),(734,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:04:20','2023-11-04 17:04:20'),(735,'default','added',376,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-04 17:04:49','2023-11-04 17:04:49'),(736,'default','added',377,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 17:06:16','2023-11-04 17:06:16'),(737,'default','payment_edited',221,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:15:06','2023-11-04 17:15:06'),(738,'default','payment_edited',222,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15150.0000\"}}',NULL,'2023-11-04 17:15:06','2023-11-04 17:15:06'),(739,'default','payment_edited',236,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4650.0000\"}}',NULL,'2023-11-04 17:16:36','2023-11-04 17:16:36'),(740,'default','payment_edited',286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-04 17:16:36','2023-11-04 17:16:36'),(741,'default','payment_edited',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"165900.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"}}',NULL,'2023-11-04 17:25:05','2023-11-04 17:25:05'),(742,'default','added',378,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-04 17:28:32','2023-11-04 17:28:32'),(743,'default','added',379,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":42460}}',NULL,'2023-11-04 17:34:48','2023-11-04 17:34:48'),(744,'default','added',380,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23780}}',NULL,'2023-11-04 17:43:35','2023-11-04 17:43:35'),(745,'default','added',381,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8222}}',NULL,'2023-11-04 17:45:53','2023-11-04 17:45:53'),(746,'default','added',382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-11-04 17:46:41','2023-11-04 17:46:41'),(747,'default','added',383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":151635}}',NULL,'2023-11-04 17:48:23','2023-11-04 17:48:23'),(748,'default','added',384,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":181120}}',NULL,'2023-11-04 17:49:29','2023-11-04 17:49:29'),(749,'default','added',66,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:55:25','2023-11-04 17:55:25'),(750,'default','payment_edited',385,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:57:06','2023-11-04 17:57:06'),(751,'default','added',386,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6100}}',NULL,'2023-11-04 17:57:57','2023-11-04 17:57:57'),(752,'default','added',387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4650}}',NULL,'2023-11-04 18:01:38','2023-11-04 18:01:38'),(753,'default','added',388,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-04 18:02:53','2023-11-04 18:02:53'),(754,'default','added',389,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-04 18:13:34','2023-11-04 18:13:34'),(755,'default','edited',37,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 18:52:49','2023-11-04 18:52:49'),(756,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:17:32','2023-11-04 19:17:32'),(757,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:17:35','2023-11-04 19:17:35'),(758,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:17:47','2023-11-04 19:17:47'),(759,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:25:43','2023-11-04 19:25:43'),(760,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:31:43','2023-11-04 19:31:43'),(761,'default','added',390,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25040}}',NULL,'2023-11-04 19:56:25','2023-11-04 19:56:25'),(762,'default','added',67,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:56:26','2023-11-04 19:56:26'),(763,'default','payment_edited',391,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:56:40','2023-11-04 19:56:40'),(764,'default','added',392,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-04 20:01:58','2023-11-04 20:01:58'),(765,'default','added',393,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2620}}',NULL,'2023-11-04 20:05:02','2023-11-04 20:05:02'),(766,'default','added',394,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-04 20:07:09','2023-11-04 20:07:09'),(767,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"}}',NULL,'2023-11-04 20:19:38','2023-11-04 20:19:38'),(768,'default','payment_edited',100,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"35250.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"35250.0000\"}}',NULL,'2023-11-04 20:19:38','2023-11-04 20:19:38'),(769,'default','added',395,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22860}}',NULL,'2023-11-04 20:37:19','2023-11-04 20:37:19'),(770,'default','added',396,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6700}}',NULL,'2023-11-04 20:39:48','2023-11-04 20:39:48'),(771,'default','added',397,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-04 20:40:10','2023-11-04 20:40:10'),(772,'default','payment_edited',277,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 20:45:04','2023-11-04 20:45:04'),(773,'default','payment_edited',278,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-11-04 20:45:04','2023-11-04 20:45:04'),(774,'default','added',398,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":12500}}',NULL,'2023-11-04 20:49:06','2023-11-04 20:49:06'),(775,'default','payment_edited',70,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50305.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"50305.0000\"}}',NULL,'2023-11-04 20:51:41','2023-11-04 20:51:41'),(776,'default','payment_edited',114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"49860.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"49860.0000\"}}',NULL,'2023-11-04 20:51:41','2023-11-04 20:51:41'),(777,'default','added',399,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-04 21:01:09','2023-11-04 21:01:09'),(778,'default','added',400,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16036.20000000000072759576141834259033203125}}',NULL,'2023-11-04 21:03:30','2023-11-04 21:03:30'),(779,'default','added',401,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5880}}',NULL,'2023-11-04 21:05:16','2023-11-04 21:05:16'),(780,'default','added',402,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":130380}}',NULL,'2023-11-04 21:07:21','2023-11-04 21:07:21'),(781,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 21:13:09','2023-11-04 21:13:09'),(782,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 21:13:13','2023-11-04 21:13:13'),(783,'default','added',403,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 21:14:15','2023-11-04 21:14:15'),(784,'default','added',404,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 21:14:48','2023-11-04 21:14:48'),(785,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 21:14:57','2023-11-04 21:14:57'),(786,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 22:59:47','2023-11-04 22:59:47'),(787,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:26:51','2023-11-05 10:26:51'),(788,'default','added',405,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-05 10:28:31','2023-11-05 10:28:31'),(789,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:29:39','2023-11-05 10:29:39'),(790,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:31:27','2023-11-05 10:31:27'),(791,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:32:07','2023-11-05 10:32:07'),(792,'default','added',406,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 10:32:33','2023-11-05 10:32:33'),(793,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:37:40','2023-11-05 10:37:40'),(794,'default','added',407,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18480}}',NULL,'2023-11-05 10:40:26','2023-11-05 10:40:26'),(795,'default','added',68,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:41:28','2023-11-05 10:41:28'),(796,'default','added',408,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-11-05 10:42:12','2023-11-05 10:42:12'),(797,'default','added',409,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-05 10:43:39','2023-11-05 10:43:39'),(798,'default','added',410,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11800}}',NULL,'2023-11-05 10:46:29','2023-11-05 10:46:29'),(799,'default','added',411,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8150}}',NULL,'2023-11-05 10:47:35','2023-11-05 10:47:35'),(800,'default','added',412,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4480}}',NULL,'2023-11-05 10:48:43','2023-11-05 10:48:43'),(801,'default','added',69,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:49:55','2023-11-05 10:49:55'),(802,'default','added',413,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-11-05 10:50:55','2023-11-05 10:50:55'),(803,'default','added',414,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3400}}',NULL,'2023-11-05 10:53:17','2023-11-05 10:53:17'),(804,'default','added',415,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14840}}',NULL,'2023-11-05 10:56:51','2023-11-05 10:56:51'),(805,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 11:09:19','2023-11-05 11:09:19'),(806,'default','added',416,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 11:09:54','2023-11-05 11:09:54'),(807,'default','added',417,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 11:14:43','2023-11-05 11:14:43'),(808,'default','added',70,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 11:27:34','2023-11-05 11:27:34'),(809,'default','added',419,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-11-05 11:29:16','2023-11-05 11:29:16'),(810,'default','payment_edited',418,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 11:30:22','2023-11-05 11:30:22'),(811,'default','added',420,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-05 11:32:58','2023-11-05 11:32:58'),(812,'default','added',421,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-05 11:48:06','2023-11-05 11:48:06'),(813,'default','added',422,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3950}}',NULL,'2023-11-05 11:49:02','2023-11-05 11:49:02'),(814,'default','added',423,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-05 11:50:39','2023-11-05 11:50:39'),(815,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 12:49:12','2023-11-05 12:49:12'),(816,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 14:35:01','2023-11-05 14:35:01'),(817,'default','added',424,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-05 14:35:25','2023-11-05 14:35:25'),(818,'default','added',425,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2900}}',NULL,'2023-11-05 14:47:06','2023-11-05 14:47:06'),(819,'default','payment_edited',425,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-05 14:50:27','2023-11-05 14:50:27'),(820,'default','added',426,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-05 14:51:07','2023-11-05 14:51:07'),(821,'default','edited',426,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-05 14:55:15','2023-11-05 14:55:15'),(822,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 15:24:13','2023-11-05 15:24:13'),(823,'default','added',71,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 16:46:08','2023-11-05 16:46:08'),(824,'default','added',428,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-05 16:46:56','2023-11-05 16:46:56'),(825,'default','added',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7150}}',NULL,'2023-11-05 17:06:15','2023-11-05 17:06:15'),(826,'default','edited',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7180},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7150.0000\"}}',NULL,'2023-11-05 17:08:19','2023-11-05 17:08:19'),(827,'default','payment_edited',302,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:10:34','2023-11-05 17:10:34'),(828,'default','payment_edited',303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5250.0000\"}}',NULL,'2023-11-05 17:10:34','2023-11-05 17:10:34'),(829,'default','added',430,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-05 17:12:08','2023-11-05 17:12:08'),(830,'default','added',72,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:13:11','2023-11-05 17:13:11'),(831,'default','payment_edited',431,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:13:44','2023-11-05 17:13:44'),(832,'default','payment_edited',405,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-05 17:14:23','2023-11-05 17:14:23'),(833,'default','added',432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-05 17:16:22','2023-11-05 17:16:22'),(834,'default','added',433,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24820}}',NULL,'2023-11-05 17:19:16','2023-11-05 17:19:16'),(835,'default','added',434,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21000}}',NULL,'2023-11-05 17:21:22','2023-11-05 17:21:22'),(836,'default','added',73,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:37:44','2023-11-05 17:37:44'),(837,'default','added',435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":156978}}',NULL,'2023-11-05 17:40:41','2023-11-05 17:40:41'),(838,'default','added',436,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 17:41:32','2023-11-05 17:41:32'),(839,'default','added',74,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:42:29','2023-11-05 17:42:29'),(840,'default','added',437,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-05 17:42:58','2023-11-05 17:42:58'),(841,'default','added',441,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":4400}}',NULL,'2023-11-05 17:48:19','2023-11-05 17:48:19'),(842,'default','added',443,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36450}}',NULL,'2023-11-05 17:53:28','2023-11-05 17:53:28'),(843,'default','added',444,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-05 17:55:31','2023-11-05 17:55:31'),(844,'default','added',445,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":769.950000000000045474735088646411895751953125}}',NULL,'2023-11-05 17:56:43','2023-11-05 17:56:43'),(845,'default','added',446,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7200}}',NULL,'2023-11-05 18:00:11','2023-11-05 18:00:11'),(846,'default','added',447,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4550}}',NULL,'2023-11-05 18:21:30','2023-11-05 18:21:30'),(847,'default','added',448,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1302}}',NULL,'2023-11-05 18:29:28','2023-11-05 18:29:28'),(848,'default','added',449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.2000000000000028421709430404007434844970703125}}',NULL,'2023-11-05 18:31:42','2023-11-05 18:31:42'),(849,'default','added',450,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-05 18:32:31','2023-11-05 18:32:31'),(850,'default','added',451,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-11-05 18:34:07','2023-11-05 18:34:07'),(851,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-11-05 18:52:35','2023-11-05 18:52:35'),(852,'default','payment_edited',180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"192160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"192160.0000\"}}',NULL,'2023-11-05 19:20:26','2023-11-05 19:20:26'),(853,'default','payment_edited',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"187880.0000\"}}',NULL,'2023-11-05 19:20:26','2023-11-05 19:20:26'),(854,'default','added',452,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-05 19:28:36','2023-11-05 19:28:36'),(855,'default','added',458,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-05 19:48:57','2023-11-05 19:48:57'),(856,'default','added',459,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-05 19:53:41','2023-11-05 19:53:41'),(857,'default','added',460,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-05 19:56:43','2023-11-05 19:56:43'),(858,'default','payment_edited',257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"53400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"53400.0000\"}}',NULL,'2023-11-05 20:02:59','2023-11-05 20:02:59'),(859,'default','payment_edited',371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"308000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"308000.0000\"}}',NULL,'2023-11-05 20:02:59','2023-11-05 20:02:59'),(860,'default','edited',459,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"}}',NULL,'2023-11-05 20:05:19','2023-11-05 20:05:19'),(861,'default','added',461,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":352}}',NULL,'2023-11-05 20:14:47','2023-11-05 20:14:47'),(862,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 20:20:23','2023-11-05 20:20:23'),(863,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:08:05','2023-11-06 10:08:05'),(864,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(865,'default','payment_edited',126,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4770.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4770.0000\"}}',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(866,'default','payment_edited',213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15020.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15020.0000\"}}',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(867,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(868,'default','payment_edited',115,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(869,'default','payment_edited',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(870,'default','added',462,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 10:10:48','2023-11-06 10:10:48'),(871,'default','added',463,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24250}}',NULL,'2023-11-06 10:16:21','2023-11-06 10:16:21'),(872,'default','added',464,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12830}}',NULL,'2023-11-06 10:18:18','2023-11-06 10:18:18'),(873,'default','added',465,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-06 10:23:33','2023-11-06 10:23:33'),(874,'default','added',75,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:30:08','2023-11-06 10:30:08'),(875,'default','added',466,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500}}',NULL,'2023-11-06 10:31:25','2023-11-06 10:31:25'),(876,'default','payment_edited',133,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 11:12:04','2023-11-06 11:12:04'),(877,'default','added',467,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-06 11:29:21','2023-11-06 11:29:21'),(878,'default','added',468,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-11-06 11:30:45','2023-11-06 11:30:45'),(879,'default','added',469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7520}}',NULL,'2023-11-06 11:32:56','2023-11-06 11:32:56'),(880,'default','added',470,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-06 11:41:45','2023-11-06 11:41:45'),(881,'default','added',471,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-06 11:42:39','2023-11-06 11:42:39'),(882,'default','added',472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":111100}}',NULL,'2023-11-06 11:45:22','2023-11-06 11:45:22'),(883,'default','added',473,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-06 11:49:13','2023-11-06 11:49:13'),(884,'default','added',474,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":32300}}',NULL,'2023-11-06 12:05:19','2023-11-06 12:05:19'),(885,'default','added',475,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-06 12:18:06','2023-11-06 12:18:06'),(886,'default','payment_edited',102,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 12:20:53','2023-11-06 12:20:53'),(887,'default','added',476,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1240}}',NULL,'2023-11-06 12:34:05','2023-11-06 12:34:05'),(888,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 13:46:57','2023-11-06 13:46:57'),(889,'default','added',477,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4150}}',NULL,'2023-11-06 13:48:39','2023-11-06 13:48:39'),(890,'default','added',481,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8490}}',NULL,'2023-11-06 13:52:37','2023-11-06 13:52:37'),(891,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 13:53:23','2023-11-06 13:53:23'),(892,'default','added',482,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-06 13:56:49','2023-11-06 13:56:49'),(893,'default','added',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":241965}}',NULL,'2023-11-06 14:01:13','2023-11-06 14:01:13'),(894,'default','edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":242465},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"241965.0000\"}}',NULL,'2023-11-06 14:06:55','2023-11-06 14:06:55'),(895,'default','payment_edited',383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"151635.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"151635.0000\"}}',NULL,'2023-11-06 14:08:38','2023-11-06 14:08:38'),(896,'default','added',486,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 14:16:11','2023-11-06 14:16:11'),(897,'default','added',489,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2023-11-06 14:18:07','2023-11-06 14:18:07'),(898,'default','added',490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":51800}}',NULL,'2023-11-06 14:20:57','2023-11-06 14:20:57'),(899,'default','edited',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:25:41','2023-11-06 14:25:41'),(900,'default','edited',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:26:26','2023-11-06 14:26:26'),(901,'default','added',491,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-06 14:33:14','2023-11-06 14:33:14'),(902,'default','added',492,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 14:45:30','2023-11-06 14:45:30'),(903,'default','added',493,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4560}}',NULL,'2023-11-06 14:50:50','2023-11-06 14:50:50'),(904,'default','added',76,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:53:32','2023-11-06 14:53:32'),(905,'default','added',494,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":149760}}',NULL,'2023-11-06 14:54:14','2023-11-06 14:54:14'),(906,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:54:24','2023-11-06 14:54:24'),(907,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 17:05:24','2023-11-06 17:05:24'),(908,'default','payment_edited',474,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"32300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"32300.0000\"}}',NULL,'2023-11-06 17:05:47','2023-11-06 17:05:47'),(909,'default','payment_edited',386,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6100.0000\"}}',NULL,'2023-11-06 17:06:36','2023-11-06 17:06:36'),(910,'default','added',495,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-06 17:07:27','2023-11-06 17:07:27'),(911,'default','added',496,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15850}}',NULL,'2023-11-06 17:09:50','2023-11-06 17:09:50'),(912,'default','added',497,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5900}}',NULL,'2023-11-06 17:11:02','2023-11-06 17:11:02'),(913,'default','added',498,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 17:32:57','2023-11-06 17:32:57'),(914,'default','added',499,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-06 17:33:18','2023-11-06 17:33:18'),(915,'default','added',500,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-06 17:36:59','2023-11-06 17:36:59'),(916,'default','added',501,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-06 17:57:53','2023-11-06 17:57:53'),(917,'default','payment_edited',317,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5430.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5430.0000\"}}',NULL,'2023-11-06 17:58:42','2023-11-06 17:58:42'),(918,'default','added',502,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-06 18:03:19','2023-11-06 18:03:19'),(919,'default','added',503,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-06 18:05:24','2023-11-06 18:05:24'),(920,'default','added',504,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-06 18:31:44','2023-11-06 18:31:44'),(921,'default','added',505,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-06 18:40:59','2023-11-06 18:40:59'),(922,'default','added',506,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-06 18:41:42','2023-11-06 18:41:42'),(923,'default','added',507,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-06 18:45:31','2023-11-06 18:45:31'),(924,'default','added',508,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-06 18:47:18','2023-11-06 18:47:18'),(925,'default','edited',56,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 19:00:45','2023-11-06 19:00:45'),(926,'default','added',509,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15538.879999999999199644662439823150634765625}}',NULL,'2023-11-06 19:18:06','2023-11-06 19:18:06'),(927,'default','added',510,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-06 19:26:52','2023-11-06 19:26:52'),(928,'default','added',511,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-06 19:32:18','2023-11-06 19:32:18'),(929,'default','added',512,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-06 19:36:43','2023-11-06 19:36:43'),(930,'default','added',513,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-06 19:37:13','2023-11-06 19:37:13'),(931,'default','added',514,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3030}}',NULL,'2023-11-06 19:44:03','2023-11-06 19:44:03'),(932,'default','added',515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3400}}',NULL,'2023-11-06 19:44:21','2023-11-06 19:44:21'),(933,'default','edited',515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":3400},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-06 19:45:16','2023-11-06 19:45:16'),(934,'default','payment_edited',515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-06 19:46:03','2023-11-06 19:46:03'),(935,'default','added',516,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-06 19:46:35','2023-11-06 19:46:35'),(936,'default','added',517,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1650}}',NULL,'2023-11-06 19:50:08','2023-11-06 19:50:08'),(937,'default','payment_edited',517,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-06 19:50:36','2023-11-06 19:50:36'),(938,'default','added',518,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-06 19:50:51','2023-11-06 19:50:51'),(939,'default','added',519,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3050}}',NULL,'2023-11-06 19:52:08','2023-11-06 19:52:08'),(940,'default','payment_edited',519,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-06 19:52:26','2023-11-06 19:52:26'),(941,'default','added',520,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-06 19:53:25','2023-11-06 19:53:25'),(942,'default','added',521,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2600}}',NULL,'2023-11-06 19:54:33','2023-11-06 19:54:33'),(943,'default','payment_edited',521,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-06 19:54:56','2023-11-06 19:54:56'),(944,'default','added',522,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-06 20:10:31','2023-11-06 20:10:31'),(945,'default','added',523,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-06 20:10:57','2023-11-06 20:10:57'),(946,'default','payment_edited',387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4650.0000\"}}',NULL,'2023-11-06 20:13:51','2023-11-06 20:13:51'),(947,'default','added',524,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-06 20:17:05','2023-11-06 20:17:05'),(948,'default','added',525,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3100}}',NULL,'2023-11-06 20:21:29','2023-11-06 20:21:29'),(949,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 20:22:01','2023-11-06 20:22:01'),(950,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 10:10:24','2023-11-07 10:10:24'),(951,'default','payment_edited',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-07 10:12:20','2023-11-07 10:12:20'),(952,'default','added',526,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-07 10:16:34','2023-11-07 10:16:34'),(953,'default','added',527,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2023-11-07 10:18:23','2023-11-07 10:18:23'),(954,'default','added',528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-07 10:19:26','2023-11-07 10:19:26'),(955,'default','added',529,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-07 10:20:10','2023-11-07 10:20:10'),(956,'default','added',530,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-07 10:20:37','2023-11-07 10:20:37'),(957,'default','added',531,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-07 10:27:02','2023-11-07 10:27:02'),(958,'default','added',532,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5750}}',NULL,'2023-11-07 10:28:45','2023-11-07 10:28:45'),(959,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 10:30:37','2023-11-07 10:30:37'),(960,'default','added',535,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5970}}',NULL,'2023-11-07 10:44:26','2023-11-07 10:44:26'),(961,'default','added',536,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-07 11:00:58','2023-11-07 11:00:58'),(962,'default','added',77,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 11:02:08','2023-11-07 11:02:08'),(963,'default','added',537,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-11-07 11:02:38','2023-11-07 11:02:38'),(964,'default','added',538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-11-07 11:08:27','2023-11-07 11:08:27'),(965,'default','added',539,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-07 11:18:27','2023-11-07 11:18:27'),(966,'default','added',540,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2023-11-07 11:19:00','2023-11-07 11:19:00'),(967,'default','added',541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-07 11:45:26','2023-11-07 11:45:26'),(968,'default','added',542,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12250}}',NULL,'2023-11-07 11:48:50','2023-11-07 11:48:50'),(969,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 14:14:39','2023-11-07 14:14:39'),(970,'default','added',543,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-11-07 14:18:53','2023-11-07 14:18:53'),(971,'default','added',544,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20030}}',NULL,'2023-11-07 14:25:51','2023-11-07 14:25:51'),(972,'default','added',545,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5150}}',NULL,'2023-11-07 14:27:24','2023-11-07 14:27:24'),(973,'default','added',546,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-07 14:29:19','2023-11-07 14:29:19'),(974,'default','added',547,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6200}}',NULL,'2023-11-07 14:30:45','2023-11-07 14:30:45'),(975,'default','payment_edited',494,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"149760.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"149760.0000\"}}',NULL,'2023-11-07 14:32:37','2023-11-07 14:32:37'),(976,'default','added',548,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-07 14:59:06','2023-11-07 14:59:06'),(977,'default','added',78,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 14:59:34','2023-11-07 14:59:34'),(978,'default','added',549,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":33904}}',NULL,'2023-11-07 15:05:43','2023-11-07 15:05:43'),(979,'default','added',550,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-07 15:06:31','2023-11-07 15:06:31'),(980,'default','added',551,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3240}}',NULL,'2023-11-07 15:08:39','2023-11-07 15:08:39'),(981,'default','added',552,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-07 15:15:32','2023-11-07 15:15:32'),(982,'default','added',553,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-07 16:45:07','2023-11-07 16:45:07'),(983,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 16:46:32','2023-11-07 16:46:32'),(984,'default','added',554,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10640}}',NULL,'2023-11-07 17:07:49','2023-11-07 17:07:49'),(985,'default','added',555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-07 17:08:36','2023-11-07 17:08:36'),(986,'default','added',556,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16690}}',NULL,'2023-11-07 17:11:52','2023-11-07 17:11:52'),(987,'default','added',557,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-07 17:12:53','2023-11-07 17:12:53'),(988,'default','added',558,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-07 17:14:32','2023-11-07 17:14:32'),(989,'default','added',559,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-07 17:21:46','2023-11-07 17:21:46'),(990,'default','added',560,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2125}}',NULL,'2023-11-07 17:22:23','2023-11-07 17:22:23'),(991,'default','added',561,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3850}}',NULL,'2023-11-07 17:27:29','2023-11-07 17:27:29'),(992,'default','added',562,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-07 17:34:48','2023-11-07 17:34:48'),(993,'default','edited',562,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"}}',NULL,'2023-11-07 17:40:19','2023-11-07 17:40:19'),(994,'default','added',563,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-07 17:54:16','2023-11-07 17:54:16'),(995,'default','added',564,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-07 17:56:06','2023-11-07 17:56:06'),(996,'default','added',565,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-07 17:58:20','2023-11-07 17:58:20'),(997,'default','payment_edited',132,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 18:07:27','2023-11-07 18:07:27'),(998,'default','added',566,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-07 18:08:06','2023-11-07 18:08:06'),(999,'default','added',567,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-07 18:11:09','2023-11-07 18:11:09'),(1000,'default','added',568,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65000}}',NULL,'2023-11-07 18:17:13','2023-11-07 18:17:13'),(1001,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 18:48:33','2023-11-07 18:48:33'),(1002,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 10:07:40','2023-11-08 10:07:40'),(1003,'default','added',569,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-08 10:08:06','2023-11-08 10:08:06'),(1004,'default','payment_edited',537,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-11-08 10:11:26','2023-11-08 10:11:26'),(1005,'default','payment_edited',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-08 10:12:30','2023-11-08 10:12:30'),(1006,'default','payment_edited',185,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-08 10:12:30','2023-11-08 10:12:30'),(1007,'default','payment_edited',525,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-08 10:12:57','2023-11-08 10:12:57'),(1008,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 10:13:28','2023-11-08 10:13:28'),(1009,'default','payment_edited',213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15020.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15020.0000\"}}',NULL,'2023-11-08 10:13:50','2023-11-08 10:13:50'),(1010,'default','payment_edited',214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-11-08 10:13:50','2023-11-08 10:13:50'),(1011,'default','payment_edited',427,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 10:15:16','2023-11-08 10:15:16'),(1012,'default','payment_edited',428,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-08 10:15:16','2023-11-08 10:15:16'),(1013,'default','added',570,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20469.79999999999927240423858165740966796875}}',NULL,'2023-11-08 10:20:29','2023-11-08 10:20:29'),(1014,'default','added',571,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1830}}',NULL,'2023-11-08 10:21:32','2023-11-08 10:21:32'),(1015,'default','added',572,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19120}}',NULL,'2023-11-08 10:23:29','2023-11-08 10:23:29'),(1016,'default','added',573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-08 10:26:11','2023-11-08 10:26:11'),(1017,'default','added',574,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12490}}',NULL,'2023-11-08 10:28:49','2023-11-08 10:28:49'),(1018,'default','added',575,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-08 10:35:02','2023-11-08 10:35:02'),(1019,'default','added',576,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4630}}',NULL,'2023-11-08 11:03:14','2023-11-08 11:03:14'),(1020,'default','payment_edited',134,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 11:05:08','2023-11-08 11:05:08'),(1021,'default','added',577,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-08 11:05:52','2023-11-08 11:05:52'),(1022,'default','added',578,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-08 11:11:27','2023-11-08 11:11:27'),(1023,'default','added',579,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11000}}',NULL,'2023-11-08 11:34:21','2023-11-08 11:34:21'),(1024,'default','payment_edited',444,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-08 11:37:26','2023-11-08 11:37:26'),(1025,'default','added',580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-08 11:41:44','2023-11-08 11:41:44'),(1026,'default','payment_edited',383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"151635.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"151635.0000\"}}',NULL,'2023-11-08 11:45:30','2023-11-08 11:45:30'),(1027,'default','payment_edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"242465.0000\"}}',NULL,'2023-11-08 11:45:30','2023-11-08 11:45:30'),(1028,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 11:59:29','2023-11-08 11:59:29'),(1029,'default','added',581,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3130}}',NULL,'2023-11-08 12:01:15','2023-11-08 12:01:15'),(1030,'default','payment_edited',435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"156978.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"156978.0000\"}}',NULL,'2023-11-08 13:33:10','2023-11-08 13:33:10'),(1031,'default','added',582,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":15000}}',NULL,'2023-11-08 13:35:14','2023-11-08 13:35:14'),(1032,'default','added',584,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9540}}',NULL,'2023-11-08 13:41:58','2023-11-08 13:41:58'),(1033,'default','added',586,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-11-08 13:50:07','2023-11-08 13:50:07'),(1034,'default','added',587,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900}}',NULL,'2023-11-08 13:50:36','2023-11-08 13:50:36'),(1035,'default','added',588,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1530}}',NULL,'2023-11-08 14:01:11','2023-11-08 14:01:11'),(1036,'default','added',589,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-08 14:18:19','2023-11-08 14:18:19'),(1037,'default','added',590,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4520}}',NULL,'2023-11-08 14:21:30','2023-11-08 14:21:30'),(1038,'default','edited',579,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11000.0000\"}}',NULL,'2023-11-08 14:22:38','2023-11-08 14:22:38'),(1039,'default','added',591,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2980}}',NULL,'2023-11-08 14:38:37','2023-11-08 14:38:37'),(1040,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 16:50:47','2023-11-08 16:50:47'),(1041,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 17:27:14','2023-11-08 17:27:14'),(1042,'default','added',592,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-08 17:31:03','2023-11-08 17:31:03'),(1043,'default','added',593,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-08 17:38:23','2023-11-08 17:38:23'),(1044,'default','edited',36,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 17:42:56','2023-11-08 17:42:56'),(1045,'default','added',594,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-08 17:43:35','2023-11-08 17:43:35'),(1046,'default','added',595,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-08 17:44:28','2023-11-08 17:44:28'),(1047,'default','added',596,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-08 17:45:08','2023-11-08 17:45:08'),(1048,'default','added',597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2830}}',NULL,'2023-11-08 17:46:30','2023-11-08 17:46:30'),(1049,'default','added',598,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11700}}',NULL,'2023-11-08 17:47:56','2023-11-08 17:47:56'),(1050,'default','added',599,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2280}}',NULL,'2023-11-08 17:50:52','2023-11-08 17:50:52'),(1051,'default','added',600,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":45547}}',NULL,'2023-11-08 17:51:23','2023-11-08 17:51:23'),(1052,'default','added',601,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-08 18:03:15','2023-11-08 18:03:15'),(1053,'default','added',602,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7580}}',NULL,'2023-11-08 18:09:30','2023-11-08 18:09:30'),(1054,'default','added',603,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2650}}',NULL,'2023-11-08 18:15:45','2023-11-08 18:15:45'),(1055,'default','added',604,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-08 18:16:40','2023-11-08 18:16:40'),(1056,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 18:17:00','2023-11-08 18:17:00'),(1057,'default','added',605,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-08 18:32:42','2023-11-08 18:32:42'),(1058,'default','added',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2480}}',NULL,'2023-11-08 18:33:31','2023-11-08 18:33:31'),(1059,'default','added',79,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 18:42:56','2023-11-08 18:42:56'),(1060,'default','added',607,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-11-08 18:44:24','2023-11-08 18:44:24'),(1061,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 18:45:35','2023-11-08 18:45:35'),(1062,'default','added',608,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-08 18:47:44','2023-11-08 18:47:44'),(1063,'default','added',609,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1520}}',NULL,'2023-11-08 18:54:48','2023-11-08 18:54:48'),(1064,'default','payment_edited',580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-08 19:26:15','2023-11-08 19:26:15'),(1065,'default','added',610,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-08 19:27:09','2023-11-08 19:27:09'),(1066,'default','added',611,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-08 19:41:50','2023-11-08 19:41:50'),(1067,'default','added',612,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-08 19:50:37','2023-11-08 19:50:37'),(1068,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 19:51:41','2023-11-08 19:51:41'),(1069,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 10:03:45','2023-11-09 10:03:45'),(1070,'default','added',613,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-09 10:05:51','2023-11-09 10:05:51'),(1071,'default','payment_edited',580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-09 10:06:57','2023-11-09 10:06:57'),(1072,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 10:07:37','2023-11-09 10:07:37'),(1073,'default','payment_edited',230,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-09 10:07:57','2023-11-09 10:07:57'),(1074,'default','payment_edited',273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-09 10:07:57','2023-11-09 10:07:57'),(1075,'default','payment_edited',597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2830.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2830.0000\"}}',NULL,'2023-11-09 10:08:17','2023-11-09 10:08:17'),(1076,'default','payment_edited',214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"}}',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(1077,'default','payment_edited',247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(1078,'default','payment_edited',289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(1079,'default','payment_edited',303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5250.0000\"}}',NULL,'2023-11-09 10:09:29','2023-11-09 10:09:29'),(1080,'default','payment_edited',603,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2650.0000\"}}',NULL,'2023-11-09 10:09:29','2023-11-09 10:09:29'),(1081,'default','added',614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7650}}',NULL,'2023-11-09 10:13:09','2023-11-09 10:13:09'),(1082,'default','added',615,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23090}}',NULL,'2023-11-09 10:20:40','2023-11-09 10:20:40'),(1083,'default','added',616,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-09 10:21:28','2023-11-09 10:21:28'),(1084,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-09 10:22:29','2023-11-09 10:22:29'),(1085,'default','added',617,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-09 10:26:14','2023-11-09 10:26:14'),(1086,'default','added',618,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 10:31:32','2023-11-09 10:31:32'),(1087,'default','payment_edited',618,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 10:31:53','2023-11-09 10:31:53'),(1088,'default','added',619,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7510}}',NULL,'2023-11-09 10:36:50','2023-11-09 10:36:50'),(1089,'default','added',620,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-09 10:41:40','2023-11-09 10:41:40'),(1090,'default','added',621,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-09 10:56:31','2023-11-09 10:56:31'),(1091,'default','added',622,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-09 10:57:47','2023-11-09 10:57:47'),(1092,'default','payment_edited',134,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 11:02:24','2023-11-09 11:02:24'),(1093,'default','added',623,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8350}}',NULL,'2023-11-09 11:03:39','2023-11-09 11:03:39'),(1094,'default','added',624,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-09 12:13:53','2023-11-09 12:13:53'),(1095,'default','added',625,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11880}}',NULL,'2023-11-09 12:15:48','2023-11-09 12:15:48'),(1096,'default','added',626,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-09 12:21:19','2023-11-09 12:21:19'),(1097,'default','added',80,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 12:31:05','2023-11-09 12:31:05'),(1098,'default','added',627,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4950}}',NULL,'2023-11-09 12:31:41','2023-11-09 12:31:41'),(1099,'default','added',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":581400}}',NULL,'2023-11-09 12:40:31','2023-11-09 12:40:31'),(1100,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-11-09 12:42:01','2023-11-09 12:42:01'),(1101,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-09 12:42:01','2023-11-09 12:42:01'),(1102,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-09 12:42:33','2023-11-09 12:42:33'),(1103,'default','payment_edited',571,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1830.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1830.0000\"}}',NULL,'2023-11-09 12:44:40','2023-11-09 12:44:40'),(1104,'default','added',629,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-09 12:46:22','2023-11-09 12:46:22'),(1105,'default','added',630,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-09 12:47:02','2023-11-09 12:47:02'),(1106,'default','added',631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-09 12:52:43','2023-11-09 12:52:43'),(1107,'default','payment_edited',627,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4950.0000\"}}',NULL,'2023-11-09 13:15:48','2023-11-09 13:15:48'),(1108,'default','added',632,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":64500}}',NULL,'2023-11-09 13:33:13','2023-11-09 13:33:13'),(1109,'default','added',633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-09 13:40:35','2023-11-09 13:40:35'),(1110,'default','added',634,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5900}}',NULL,'2023-11-09 13:41:37','2023-11-09 13:41:37'),(1111,'default','added',635,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-09 13:42:15','2023-11-09 13:42:15'),(1112,'default','payment_edited',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"}}',NULL,'2023-11-09 13:50:28','2023-11-09 13:50:28'),(1113,'default','added',636,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 13:55:21','2023-11-09 13:55:21'),(1114,'default','added',637,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-09 13:59:50','2023-11-09 13:59:50'),(1115,'default','added',638,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7520}}',NULL,'2023-11-09 14:09:59','2023-11-09 14:09:59'),(1116,'default','added',639,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 14:30:13','2023-11-09 14:30:13'),(1117,'default','added',640,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4900}}',NULL,'2023-11-09 14:36:42','2023-11-09 14:36:42'),(1118,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 14:38:28','2023-11-09 14:38:28'),(1119,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 17:04:43','2023-11-09 17:04:43'),(1120,'default','payment_edited',607,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-11-09 17:07:59','2023-11-09 17:07:59'),(1121,'default','added',641,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29170}}',NULL,'2023-11-09 17:11:52','2023-11-09 17:11:52'),(1122,'default','added',642,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36120}}',NULL,'2023-11-09 17:14:12','2023-11-09 17:14:12'),(1123,'default','added',81,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 17:16:08','2023-11-09 17:16:08'),(1124,'default','added',643,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-11-09 17:16:40','2023-11-09 17:16:40'),(1125,'default','added',644,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-09 17:16:58','2023-11-09 17:16:58'),(1126,'default','added',645,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-09 17:40:51','2023-11-09 17:40:51'),(1127,'default','added',646,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-09 17:43:25','2023-11-09 17:43:25'),(1128,'default','added',647,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-09 17:48:46','2023-11-09 17:48:46'),(1129,'default','payment_edited',437,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-09 17:55:24','2023-11-09 17:55:24'),(1130,'default','added',648,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-09 18:01:23','2023-11-09 18:01:23'),(1131,'default','added',649,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-09 18:05:06','2023-11-09 18:05:06'),(1132,'default','added',82,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 18:05:58','2023-11-09 18:05:58'),(1133,'default','added',650,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450}}',NULL,'2023-11-09 18:06:31','2023-11-09 18:06:31'),(1134,'default','added',651,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-09 18:29:11','2023-11-09 18:29:11'),(1135,'default','added',652,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6220}}',NULL,'2023-11-09 18:42:10','2023-11-09 18:42:10'),(1136,'default','added',653,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1380}}',NULL,'2023-11-09 18:43:58','2023-11-09 18:43:58'),(1137,'default','payment_edited',653,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1380.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1380.0000\"}}',NULL,'2023-11-09 18:44:18','2023-11-09 18:44:18'),(1138,'default','added',654,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1680}}',NULL,'2023-11-09 18:52:57','2023-11-09 18:52:57'),(1139,'default','payment_edited',654,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1680.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1680.0000\"}}',NULL,'2023-11-09 18:53:28','2023-11-09 18:53:28'),(1140,'default','added',655,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-09 19:05:01','2023-11-09 19:05:01'),(1141,'default','added',656,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-09 19:21:05','2023-11-09 19:21:05'),(1142,'default','added',657,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1500}}',NULL,'2023-11-09 19:26:10','2023-11-09 19:26:10'),(1143,'default','payment_edited',657,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-09 19:26:34','2023-11-09 19:26:34'),(1144,'default','added',658,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-09 19:27:05','2023-11-09 19:27:05'),(1145,'default','added',659,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3080}}',NULL,'2023-11-09 19:28:57','2023-11-09 19:28:57'),(1146,'default','added',660,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-09 19:31:45','2023-11-09 19:31:45'),(1147,'default','added',661,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-11-09 19:33:17','2023-11-09 19:33:17'),(1148,'default','added',662,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-09 19:36:58','2023-11-09 19:36:58'),(1149,'default','added',663,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-11-09 19:43:09','2023-11-09 19:43:09'),(1150,'default','added',664,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 19:48:31','2023-11-09 19:48:31'),(1151,'default','added',665,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-11-09 19:51:27','2023-11-09 19:51:27'),(1152,'default','added',666,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-09 19:51:42','2023-11-09 19:51:42'),(1153,'default','added',667,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-09 19:52:16','2023-11-09 19:52:16'),(1154,'default','added',668,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2530}}',NULL,'2023-11-09 19:52:55','2023-11-09 19:52:55'),(1155,'default','added',669,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-11-09 19:54:10','2023-11-09 19:54:10'),(1156,'default','added',670,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-09 19:57:17','2023-11-09 19:57:17'),(1157,'default','added',671,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 20:01:00','2023-11-09 20:01:00'),(1158,'default','added',672,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 20:01:49','2023-11-09 20:01:49'),(1159,'default','added',673,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-09 20:02:40','2023-11-09 20:02:40'),(1160,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 20:06:55','2023-11-09 20:06:55'),(1161,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 10:17:00','2023-11-11 10:17:00'),(1162,'default','added',674,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-11 10:17:30','2023-11-11 10:17:30'),(1163,'default','payment_edited',273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-11 10:19:13','2023-11-11 10:19:13'),(1164,'default','payment_edited',360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-11 10:19:13','2023-11-11 10:19:13'),(1165,'default','payment_edited',643,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-11-11 10:19:26','2023-11-11 10:19:26'),(1166,'default','payment_edited',659,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3080.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3080.0000\"}}',NULL,'2023-11-11 10:19:41','2023-11-11 10:19:41'),(1167,'default','added',675,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 10:20:45','2023-11-11 10:20:45'),(1168,'default','added',676,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12020}}',NULL,'2023-11-11 10:23:18','2023-11-11 10:23:18'),(1169,'default','added',677,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22310}}',NULL,'2023-11-11 10:27:25','2023-11-11 10:27:25'),(1170,'default','added',678,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8500}}',NULL,'2023-11-11 10:28:26','2023-11-11 10:28:26'),(1171,'default','payment_edited',51,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 10:29:14','2023-11-11 10:29:14'),(1172,'default','added',679,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-11-11 10:31:18','2023-11-11 10:31:18'),(1173,'default','added',680,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-11 10:32:39','2023-11-11 10:32:39'),(1174,'default','added',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-11-11 10:33:32','2023-11-11 10:33:32'),(1175,'default','added',682,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3570}}',NULL,'2023-11-11 10:35:22','2023-11-11 10:35:22'),(1176,'default','added',683,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-11 10:40:01','2023-11-11 10:40:01'),(1177,'default','added',83,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 10:41:27','2023-11-11 10:41:27'),(1178,'default','added',684,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2040}}',NULL,'2023-11-11 10:43:01','2023-11-11 10:43:01'),(1179,'default','added',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15650}}',NULL,'2023-11-11 10:46:06','2023-11-11 10:46:06'),(1180,'default','added',686,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-11 10:59:18','2023-11-11 10:59:18'),(1181,'default','added',687,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-11 11:12:04','2023-11-11 11:12:04'),(1182,'default','added',688,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-11 11:12:40','2023-11-11 11:12:40'),(1183,'default','added',689,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-11-11 11:16:58','2023-11-11 11:16:58'),(1184,'default','added',690,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-11 11:23:45','2023-11-11 11:23:45'),(1185,'default','added',691,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5050}}',NULL,'2023-11-11 11:30:56','2023-11-11 11:30:56'),(1186,'default','added',692,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3480}}',NULL,'2023-11-11 11:39:02','2023-11-11 11:39:02'),(1187,'default','added',693,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-11 11:43:38','2023-11-11 11:43:38'),(1188,'default','payment_edited',692,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3480.0000\"}}',NULL,'2023-11-11 11:48:24','2023-11-11 11:48:24'),(1189,'default','added',84,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 11:52:57','2023-11-11 11:52:57'),(1190,'default','added',694,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2700}}',NULL,'2023-11-11 11:53:37','2023-11-11 11:53:37'),(1191,'default','added',695,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-11 11:55:11','2023-11-11 11:55:11'),(1192,'default','added',696,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-11 12:06:54','2023-11-11 12:06:54'),(1193,'default','payment_edited',402,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"130380.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"130380.0000\"}}',NULL,'2023-11-11 12:17:47','2023-11-11 12:17:47'),(1194,'default','added',697,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":114120}}',NULL,'2023-11-11 12:20:43','2023-11-11 12:20:43'),(1195,'default','added',698,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-11 12:33:50','2023-11-11 12:33:50'),(1196,'default','added',699,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-11 12:36:53','2023-11-11 12:36:53'),(1197,'default','payment_edited',360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-11 13:24:13','2023-11-11 13:24:13'),(1198,'default','payment_edited',382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-11 13:24:13','2023-11-11 13:24:13'),(1199,'default','added',700,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 13:25:13','2023-11-11 13:25:13'),(1200,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 13:31:22','2023-11-11 13:31:22'),(1201,'default','added',701,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-11 13:35:04','2023-11-11 13:35:04'),(1202,'default','added',702,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-11 13:52:26','2023-11-11 13:52:26'),(1203,'default','added',703,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-11 13:54:28','2023-11-11 13:54:28'),(1204,'default','added',704,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1780}}',NULL,'2023-11-11 14:07:40','2023-11-11 14:07:40'),(1205,'default','payment_edited',640,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-11 14:08:13','2023-11-11 14:08:13'),(1206,'default','added',705,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5350}}',NULL,'2023-11-11 14:09:38','2023-11-11 14:09:38'),(1207,'default','added',706,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-11 14:15:58','2023-11-11 14:15:58'),(1208,'default','added',707,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-11 14:16:33','2023-11-11 14:16:33'),(1209,'default','added',708,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14800}}',NULL,'2023-11-11 14:22:21','2023-11-11 14:22:21'),(1210,'default','added',709,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4350}}',NULL,'2023-11-11 14:26:52','2023-11-11 14:26:52'),(1211,'default','added',710,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-11 14:27:06','2023-11-11 14:27:06'),(1212,'default','added',711,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-11 14:29:53','2023-11-11 14:29:53'),(1213,'default','added',712,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-11-11 14:36:14','2023-11-11 14:36:14'),(1214,'default','added',713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-11 14:39:29','2023-11-11 14:39:29'),(1215,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 17:14:14','2023-11-11 17:14:14'),(1216,'default','added',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":37080}}',NULL,'2023-11-11 17:35:54','2023-11-11 17:35:54'),(1217,'default','payment_edited',191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50070.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"50070.0000\"}}',NULL,'2023-11-11 17:36:44','2023-11-11 17:36:44'),(1218,'default','payment_edited',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"37080.0000\"}}',NULL,'2023-11-11 17:36:44','2023-11-11 17:36:44'),(1219,'default','added',715,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31590}}',NULL,'2023-11-11 17:41:10','2023-11-11 17:41:10'),(1220,'default','payment_edited',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"}}',NULL,'2023-11-11 17:42:46','2023-11-11 17:42:46'),(1221,'default','added',716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":207615}}',NULL,'2023-11-11 17:48:49','2023-11-11 17:48:49'),(1222,'default','added',717,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 17:49:52','2023-11-11 17:49:52'),(1223,'default','added',718,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-11-11 17:51:34','2023-11-11 17:51:34'),(1224,'default','added',719,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-11 17:54:02','2023-11-11 17:54:02'),(1225,'default','payment_edited',582,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15000.0000\"}}',NULL,'2023-11-11 17:55:06','2023-11-11 17:55:06'),(1226,'default','added',720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-11-11 17:57:51','2023-11-11 17:57:51'),(1227,'default','added',721,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":91163.25}}',NULL,'2023-11-11 18:02:45','2023-11-11 18:02:45'),(1228,'default','added',722,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12780}}',NULL,'2023-11-11 18:04:20','2023-11-11 18:04:20'),(1229,'default','added',723,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6160}}',NULL,'2023-11-11 18:06:03','2023-11-11 18:06:03'),(1230,'default','payment_edited',631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-11 18:06:54','2023-11-11 18:06:54'),(1231,'default','added',724,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1830}}',NULL,'2023-11-11 18:08:28','2023-11-11 18:08:28'),(1232,'default','added',725,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21660}}',NULL,'2023-11-11 18:11:51','2023-11-11 18:11:51'),(1233,'default','added',726,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-11-11 18:13:27','2023-11-11 18:13:27'),(1234,'default','added',727,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-11-11 18:14:00','2023-11-11 18:14:00'),(1235,'default','payment_edited',578,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-11 18:14:59','2023-11-11 18:14:59'),(1236,'default','added',728,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-11 18:24:23','2023-11-11 18:24:23'),(1237,'default','payment_edited',435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"156978.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"156978.0000\"}}',NULL,'2023-11-11 18:42:55','2023-11-11 18:42:55'),(1238,'default','added',729,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-11 18:43:11','2023-11-11 18:43:11'),(1239,'default','added',730,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 19:07:12','2023-11-11 19:07:12'),(1240,'default','added',731,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-11 19:08:29','2023-11-11 19:08:29'),(1241,'default','added',732,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-11 19:09:49','2023-11-11 19:09:49'),(1242,'default','added',733,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380}}',NULL,'2023-11-11 19:18:05','2023-11-11 19:18:05'),(1243,'default','added',734,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1620}}',NULL,'2023-11-11 19:22:43','2023-11-11 19:22:43'),(1244,'default','payment_edited',371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"308000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"308000.0000\"}}',NULL,'2023-11-11 19:24:36','2023-11-11 19:24:36'),(1245,'default','payment_edited',490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"51800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"51800.0000\"}}',NULL,'2023-11-11 19:24:36','2023-11-11 19:24:36'),(1246,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-11 19:24:59','2023-11-11 19:24:59'),(1247,'default','added',735,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-11 19:33:30','2023-11-11 19:33:30'),(1248,'default','added',736,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-11 19:35:28','2023-11-11 19:35:28'),(1249,'default','added',737,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-11 19:36:29','2023-11-11 19:36:29'),(1250,'default','added',738,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-11 19:51:42','2023-11-11 19:51:42'),(1251,'default','added',739,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-11 19:56:19','2023-11-11 19:56:19'),(1252,'default','added',740,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13670}}',NULL,'2023-11-11 20:27:33','2023-11-11 20:27:33'),(1253,'default','added',741,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 20:28:30','2023-11-11 20:28:30'),(1254,'default','payment_edited',679,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-11 20:28:55','2023-11-11 20:28:55'),(1255,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 20:30:18','2023-11-11 20:30:18'),(1256,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 10:10:57','2023-11-12 10:10:57'),(1257,'default','payment_edited',723,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6160.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6160.0000\"}}',NULL,'2023-11-12 10:12:53','2023-11-12 10:12:53'),(1258,'default','payment_edited',289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-12 10:13:18','2023-11-12 10:13:18'),(1259,'default','payment_edited',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12670.0000\"}}',NULL,'2023-11-12 10:13:18','2023-11-12 10:13:18'),(1260,'default','payment_edited',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2480.0000\"}}',NULL,'2023-11-12 10:16:01','2023-11-12 10:16:01'),(1261,'default','added',742,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-12 10:29:32','2023-11-12 10:29:32'),(1262,'default','added',743,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-12 10:33:00','2023-11-12 10:33:00'),(1263,'default','added',744,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-12 10:48:42','2023-11-12 10:48:42'),(1264,'default','added',745,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5840}}',NULL,'2023-11-12 10:51:55','2023-11-12 10:51:55'),(1265,'default','added',746,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5015}}',NULL,'2023-11-12 10:54:39','2023-11-12 10:54:39'),(1266,'default','added',747,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-11-12 10:54:56','2023-11-12 10:54:56'),(1267,'default','added',748,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9800}}',NULL,'2023-11-12 10:56:34','2023-11-12 10:56:34'),(1268,'default','added',749,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-12 10:56:55','2023-11-12 10:56:55'),(1269,'default','added',750,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-12 10:57:25','2023-11-12 10:57:25'),(1270,'default','added',751,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3380}}',NULL,'2023-11-12 11:01:50','2023-11-12 11:01:50'),(1271,'default','added',752,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-12 11:07:58','2023-11-12 11:07:58'),(1272,'default','added',753,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-12 11:29:27','2023-11-12 11:29:27'),(1273,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 11:30:13','2023-11-12 11:30:13'),(1274,'default','added',754,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-12 11:31:13','2023-11-12 11:31:13'),(1275,'default','added',85,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 12:01:05','2023-11-12 12:01:05'),(1276,'default','added',755,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1650}}',NULL,'2023-11-12 12:01:37','2023-11-12 12:01:37'),(1277,'default','added',756,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-12 12:02:44','2023-11-12 12:02:44'),(1278,'default','added',757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-12 12:03:44','2023-11-12 12:03:44'),(1279,'default','added',758,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-12 12:05:49','2023-11-12 12:05:49'),(1280,'default','added',86,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 12:09:13','2023-11-12 12:09:13'),(1281,'default','edited',757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"}}',NULL,'2023-11-12 12:09:22','2023-11-12 12:09:22'),(1282,'default','added',759,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 12:12:26','2023-11-12 12:12:26'),(1283,'default','added',760,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 12:12:49','2023-11-12 12:12:49'),(1284,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 14:13:16','2023-11-12 14:13:16'),(1285,'default','added',761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-12 14:14:50','2023-11-12 14:14:50'),(1286,'default','added',762,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-12 14:15:30','2023-11-12 14:15:30'),(1287,'default','added',763,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-12 14:29:29','2023-11-12 14:29:29'),(1288,'default','payment_edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"}}',NULL,'2023-11-12 14:30:35','2023-11-12 14:30:35'),(1289,'default','added',764,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-12 14:54:01','2023-11-12 14:54:01'),(1290,'default','added',765,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-11-12 14:56:03','2023-11-12 14:56:03'),(1291,'default','added',766,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-12 14:56:28','2023-11-12 14:56:28'),(1292,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 17:30:42','2023-11-12 17:30:42'),(1293,'default','added',767,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14680}}',NULL,'2023-11-12 17:35:27','2023-11-12 17:35:27'),(1294,'default','added',768,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4950}}',NULL,'2023-11-12 17:36:12','2023-11-12 17:36:12'),(1295,'default','added',769,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-12 17:42:10','2023-11-12 17:42:10'),(1296,'default','added',770,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":57900}}',NULL,'2023-11-12 17:53:01','2023-11-12 17:53:01'),(1297,'default','added',771,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-12 17:59:49','2023-11-12 17:59:49'),(1298,'default','added',772,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-12 18:00:33','2023-11-12 18:00:33'),(1299,'default','added',773,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-12 18:04:31','2023-11-12 18:04:31'),(1300,'default','added',774,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 18:06:19','2023-11-12 18:06:19'),(1301,'default','added',775,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 18:13:11','2023-11-12 18:13:11'),(1302,'default','added',776,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3080}}',NULL,'2023-11-12 18:22:08','2023-11-12 18:22:08'),(1303,'default','payment_edited',650,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2023-11-12 18:32:17','2023-11-12 18:32:17'),(1304,'default','added',777,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-12 18:42:48','2023-11-12 18:42:48'),(1305,'default','added',778,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-11-12 18:46:25','2023-11-12 18:46:25'),(1306,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 18:57:21','2023-11-12 18:57:21'),(1307,'default','added',779,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2023-11-12 19:07:57','2023-11-12 19:07:57'),(1308,'default','edited',21,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 19:11:46','2023-11-12 19:11:46'),(1309,'default','added',780,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-11-12 19:20:32','2023-11-12 19:20:32'),(1310,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 19:26:25','2023-11-12 19:26:25'),(1311,'default','added',781,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-12 19:28:49','2023-11-12 19:28:49'),(1312,'default','added',782,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-12 19:56:34','2023-11-12 19:56:34'),(1313,'default','added',783,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2580}}',NULL,'2023-11-12 19:59:20','2023-11-12 19:59:20'),(1314,'default','added',784,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-12 20:11:52','2023-11-12 20:11:52'),(1315,'default','added',785,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-12 20:13:56','2023-11-12 20:13:56'),(1316,'default','added',786,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-12 20:18:48','2023-11-12 20:18:48'),(1317,'default','added',87,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 20:33:03','2023-11-12 20:33:03'),(1318,'default','added',787,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1500}}',NULL,'2023-11-12 20:33:36','2023-11-12 20:33:36'),(1319,'default','added',788,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-12 20:39:20','2023-11-12 20:39:20'),(1320,'default','added',789,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3550}}',NULL,'2023-11-12 20:45:43','2023-11-12 20:45:43'),(1321,'default','added',790,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 20:47:11','2023-11-12 20:47:11'),(1322,'default','added',791,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}',NULL,'2023-11-12 20:58:26','2023-11-12 20:58:26'),(1323,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 21:07:16','2023-11-12 21:07:16'),(1324,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 21:07:20','2023-11-12 21:07:20'),(1325,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 21:07:26','2023-11-12 21:07:26'),(1326,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 22:27:19','2023-11-12 22:27:19'),(1327,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 10:29:32','2023-11-13 10:29:32'),(1328,'default','added',792,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-13 10:30:01','2023-11-13 10:30:01'),(1329,'default','payment_edited',787,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-13 10:33:19','2023-11-13 10:33:19'),(1330,'default','payment_edited',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"}}',NULL,'2023-11-13 10:33:49','2023-11-13 10:33:49'),(1331,'default','payment_edited',382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-13 10:34:06','2023-11-13 10:34:06'),(1332,'default','payment_edited',432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-13 10:34:06','2023-11-13 10:34:06'),(1333,'default','added',793,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3330}}',NULL,'2023-11-13 10:38:16','2023-11-13 10:38:16'),(1334,'default','added',794,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-13 10:43:09','2023-11-13 10:43:09'),(1335,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 11:00:59','2023-11-13 11:00:59'),(1336,'default','added',795,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":48360}}',NULL,'2023-11-13 11:11:49','2023-11-13 11:11:49'),(1337,'default','added',796,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 11:13:19','2023-11-13 11:13:19'),(1338,'default','added',797,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-13 11:15:40','2023-11-13 11:15:40'),(1339,'default','added',798,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-13 11:37:10','2023-11-13 11:37:10'),(1340,'default','added',799,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-11-13 11:43:56','2023-11-13 11:43:56'),(1341,'default','added',800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-13 12:13:36','2023-11-13 12:13:36'),(1342,'default','added',801,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4120}}',NULL,'2023-11-13 12:35:30','2023-11-13 12:35:30'),(1343,'default','added',802,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-13 12:44:14','2023-11-13 12:44:14'),(1344,'default','added',803,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-13 12:45:59','2023-11-13 12:45:59'),(1345,'default','added',88,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 12:55:22','2023-11-13 12:55:22'),(1346,'default','edited',88,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 12:57:39','2023-11-13 12:57:39'),(1347,'default','payment_edited',804,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 13:00:03','2023-11-13 13:00:03'),(1348,'default','added',805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-11-13 13:00:03','2023-11-13 13:00:03'),(1349,'default','added',806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-13 13:38:36','2023-11-13 13:38:36'),(1350,'default','added',807,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-13 13:44:10','2023-11-13 13:44:10'),(1351,'default','added',808,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-13 14:05:34','2023-11-13 14:05:34'),(1352,'default','added',809,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-13 14:14:22','2023-11-13 14:14:22'),(1353,'default','added',810,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-13 14:37:38','2023-11-13 14:37:38'),(1354,'default','added',811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":86310}}',NULL,'2023-11-13 14:40:25','2023-11-13 14:40:25'),(1355,'default','payment_edited',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"187880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"}}',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(1356,'default','payment_edited',297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"69360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"69360.0000\"}}',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(1357,'default','payment_edited',472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"111100.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"111100.0000\"}}',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(1358,'default','added',812,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7750}}',NULL,'2023-11-13 14:53:58','2023-11-13 14:53:58'),(1359,'default','added',813,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-13 14:54:32','2023-11-13 14:54:32'),(1360,'default','payment_edited',724,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1830.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1830.0000\"}}',NULL,'2023-11-13 14:57:16','2023-11-13 14:57:16'),(1361,'default','added',814,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-13 14:58:09','2023-11-13 14:58:09'),(1362,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 18:39:30','2023-11-13 18:39:30'),(1363,'default','added',815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":34160}}',NULL,'2023-11-13 19:05:05','2023-11-13 19:05:05'),(1364,'default','payment_edited',46,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 19:07:34','2023-11-13 19:07:34'),(1365,'default','payment_edited',237,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-11-13 19:07:34','2023-11-13 19:07:34'),(1366,'default','payment_edited',795,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"48360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"48360.0000\"}}',NULL,'2023-11-13 19:11:49','2023-11-13 19:11:49'),(1367,'default','payment_edited',815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"34160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"34160.0000\"}}',NULL,'2023-11-13 19:11:49','2023-11-13 19:11:49'),(1368,'default','added',816,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-13 19:13:25','2023-11-13 19:13:25'),(1369,'default','added',817,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-13 19:19:59','2023-11-13 19:19:59'),(1370,'default','added',818,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 19:20:59','2023-11-13 19:20:59'),(1371,'default','added',819,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15950}}',NULL,'2023-11-13 19:26:16','2023-11-13 19:26:16'),(1372,'default','added',820,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53200}}',NULL,'2023-11-13 19:29:12','2023-11-13 19:29:12'),(1373,'default','added',821,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12289.920000000000072759576141834259033203125}}',NULL,'2023-11-13 19:34:07','2023-11-13 19:34:07'),(1374,'default','added',822,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5950}}',NULL,'2023-11-13 19:36:43','2023-11-13 19:36:43'),(1375,'default','added',823,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6150}}',NULL,'2023-11-13 19:47:54','2023-11-13 19:47:54'),(1376,'default','added',824,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-13 19:53:40','2023-11-13 19:53:40'),(1377,'default','added',825,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4600}}',NULL,'2023-11-13 20:01:37','2023-11-13 20:01:37'),(1378,'default','added',826,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 20:08:21','2023-11-13 20:08:21'),(1379,'default','added',827,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 20:10:06','2023-11-13 20:10:06'),(1380,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 20:10:44','2023-11-13 20:10:44'),(1381,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:10:56','2023-11-13 20:10:56'),(1382,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:11:16','2023-11-13 20:11:16'),(1383,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:11:29','2023-11-13 20:11:29'),(1384,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:11:40','2023-11-13 20:11:40'),(1385,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 20:14:57','2023-11-13 20:14:57'),(1386,'default','added',828,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-13 20:15:36','2023-11-13 20:15:36'),(1387,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 20:16:06','2023-11-13 20:16:06'),(1388,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 10:18:41','2023-11-14 10:18:41'),(1389,'default','added',829,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12259.97999999999956344254314899444580078125}}',NULL,'2023-11-14 10:22:55','2023-11-14 10:22:55'),(1390,'default','added',830,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3930}}',NULL,'2023-11-14 10:24:14','2023-11-14 10:24:14'),(1391,'default','added',831,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11500}}',NULL,'2023-11-14 10:26:14','2023-11-14 10:26:14'),(1392,'default','added',832,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-14 10:26:49','2023-11-14 10:26:49'),(1393,'default','added',833,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-14 10:32:41','2023-11-14 10:32:41'),(1394,'default','added',834,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-14 10:35:19','2023-11-14 10:35:19'),(1395,'default','payment_edited',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"}}',NULL,'2023-11-14 10:46:35','2023-11-14 10:46:35'),(1396,'default','payment_edited',720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-11-14 10:46:54','2023-11-14 10:46:54'),(1397,'default','payment_edited',432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1398,'default','payment_edited',495,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1399,'default','payment_edited',528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1400,'default','added',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":21210}}',NULL,'2023-11-14 10:51:22','2023-11-14 10:51:22'),(1401,'default','added',836,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-14 10:53:53','2023-11-14 10:53:53'),(1402,'default','added',837,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-14 11:05:44','2023-11-14 11:05:44'),(1403,'default','payment_edited',816,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-14 11:32:04','2023-11-14 11:32:04'),(1404,'default','added',838,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4650}}',NULL,'2023-11-14 12:19:48','2023-11-14 12:19:48'),(1405,'default','added',839,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-14 12:34:22','2023-11-14 12:34:22'),(1406,'default','added',840,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-14 12:36:22','2023-11-14 12:36:22'),(1407,'default','added',841,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28340}}',NULL,'2023-11-14 12:46:28','2023-11-14 12:46:28'),(1408,'default','added',842,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7420}}',NULL,'2023-11-14 13:22:02','2023-11-14 13:22:02'),(1409,'default','added',843,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-11-14 13:23:24','2023-11-14 13:23:24'),(1410,'default','added',844,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-14 13:24:34','2023-11-14 13:24:34'),(1411,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 13:40:31','2023-11-14 13:40:31'),(1412,'default','added',845,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-14 13:40:53','2023-11-14 13:40:53'),(1413,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-14 13:51:04','2023-11-14 13:51:04'),(1414,'default','added',846,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1770}}',NULL,'2023-11-14 13:56:37','2023-11-14 13:56:37'),(1415,'default','added',847,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-11-14 13:59:01','2023-11-14 13:59:01'),(1416,'default','added',848,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2023-11-14 14:00:17','2023-11-14 14:00:17'),(1417,'default','added',849,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-14 14:02:00','2023-11-14 14:02:00'),(1418,'default','added',850,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-14 14:12:38','2023-11-14 14:12:38'),(1419,'default','added',851,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 14:16:53','2023-11-14 14:16:53'),(1420,'default','added',852,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4650}}',NULL,'2023-11-14 14:24:38','2023-11-14 14:24:38'),(1421,'default','added',853,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1775}}',NULL,'2023-11-14 14:54:05','2023-11-14 14:54:05'),(1422,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 17:40:07','2023-11-14 17:40:07'),(1423,'default','added',854,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1525}}',NULL,'2023-11-14 17:43:29','2023-11-14 17:43:29'),(1424,'default','added',855,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":128320}}',NULL,'2023-11-14 17:46:52','2023-11-14 17:46:52'),(1425,'default','added',856,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 17:48:53','2023-11-14 17:48:53'),(1426,'default','added',857,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26160}}',NULL,'2023-11-14 17:53:44','2023-11-14 17:53:44'),(1427,'default','added',858,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22500}}',NULL,'2023-11-14 17:57:38','2023-11-14 17:57:38'),(1428,'default','added',859,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3639.510000000000218278728425502777099609375}}',NULL,'2023-11-14 17:58:25','2023-11-14 17:58:25'),(1429,'default','added',860,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6000}}',NULL,'2023-11-14 18:01:16','2023-11-14 18:01:16'),(1430,'default','added',861,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-11-14 18:07:15','2023-11-14 18:07:15'),(1431,'default','added',862,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2930}}',NULL,'2023-11-14 18:09:36','2023-11-14 18:09:36'),(1432,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 18:23:10','2023-11-14 18:23:10'),(1433,'default','added',863,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3180}}',NULL,'2023-11-14 18:25:47','2023-11-14 18:25:47'),(1434,'default','added',89,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 18:28:59','2023-11-14 18:28:59'),(1435,'default','added',864,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-14 18:29:39','2023-11-14 18:29:39'),(1436,'default','added',865,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-11-14 18:30:23','2023-11-14 18:30:23'),(1437,'default','added',866,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-14 18:32:52','2023-11-14 18:32:52'),(1438,'default','added',867,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-14 18:45:45','2023-11-14 18:45:45'),(1439,'default','added',868,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-14 18:48:55','2023-11-14 18:48:55'),(1440,'default','added',869,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-14 18:50:29','2023-11-14 18:50:29'),(1441,'default','added',870,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-11-14 19:36:46','2023-11-14 19:36:46'),(1442,'default','added',90,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 19:45:26','2023-11-14 19:45:26'),(1443,'default','added',871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":200000}}',NULL,'2023-11-14 19:49:38','2023-11-14 19:49:38'),(1444,'default','added',872,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-14 20:08:38','2023-11-14 20:08:38'),(1445,'default','added',873,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 20:15:27','2023-11-14 20:15:27'),(1446,'default','added',874,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 20:15:53','2023-11-14 20:15:53'),(1447,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 20:15:58','2023-11-14 20:15:58'),(1448,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 22:16:24','2023-11-14 22:16:24'),(1449,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 10:18:10','2023-11-15 10:18:10'),(1450,'default','payment_edited',865,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-15 10:20:37','2023-11-15 10:20:37'),(1451,'default','payment_edited',749,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-15 10:21:18','2023-11-15 10:21:18'),(1452,'default','payment_edited',528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 10:21:45','2023-11-15 10:21:45'),(1453,'default','payment_edited',555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 10:21:45','2023-11-15 10:21:45'),(1454,'default','added',875,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-15 10:27:50','2023-11-15 10:27:50'),(1455,'default','added',876,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-15 10:29:46','2023-11-15 10:29:46'),(1456,'default','added',877,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2730}}',NULL,'2023-11-15 10:31:23','2023-11-15 10:31:23'),(1457,'default','added',878,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15600}}',NULL,'2023-11-15 10:35:53','2023-11-15 10:35:53'),(1458,'default','added',879,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-15 10:38:37','2023-11-15 10:38:37'),(1459,'default','added',880,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-15 10:40:45','2023-11-15 10:40:45'),(1460,'default','added',881,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-15 10:49:01','2023-11-15 10:49:01'),(1461,'default','added',882,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-11-15 10:50:07','2023-11-15 10:50:07'),(1462,'default','added',883,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-15 10:51:25','2023-11-15 10:51:25'),(1463,'default','added',884,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17030}}',NULL,'2023-11-15 10:55:53','2023-11-15 10:55:53'),(1464,'default','edited',871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":200000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"200000.0000\"}}',NULL,'2023-11-15 11:05:24','2023-11-15 11:05:24'),(1465,'default','edited',871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":200000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"200000.0000\"}}',NULL,'2023-11-15 11:12:32','2023-11-15 11:12:32'),(1466,'default','added',885,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43371.330000000001746229827404022216796875}}',NULL,'2023-11-15 11:18:45','2023-11-15 11:18:45'),(1467,'default','added',886,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-15 11:21:21','2023-11-15 11:21:21'),(1468,'default','added',887,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2970}}',NULL,'2023-11-15 11:24:15','2023-11-15 11:24:15'),(1469,'default','added',888,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-15 12:16:10','2023-11-15 12:16:10'),(1470,'default','payment_edited',814,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-15 12:21:17','2023-11-15 12:21:17'),(1471,'default','payment_edited',854,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1525.0000\"}}',NULL,'2023-11-15 12:21:17','2023-11-15 12:21:17'),(1472,'default','added',889,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4300}}',NULL,'2023-11-15 12:24:47','2023-11-15 12:24:47'),(1473,'default','added',890,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-15 12:25:39','2023-11-15 12:25:39'),(1474,'default','added',891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-11-15 12:26:41','2023-11-15 12:26:41'),(1475,'default','edited',891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-15 12:27:13','2023-11-15 12:27:13'),(1476,'default','added',892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6500}}',NULL,'2023-11-15 12:29:43','2023-11-15 12:29:43'),(1477,'default','added',893,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5960}}',NULL,'2023-11-15 12:35:23','2023-11-15 12:35:23'),(1478,'default','added',894,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-15 12:41:34','2023-11-15 12:41:34'),(1479,'default','added',895,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3070}}',NULL,'2023-11-15 12:49:14','2023-11-15 12:49:14'),(1480,'default','added',896,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-15 12:50:06','2023-11-15 12:50:06'),(1481,'default','payment_edited',555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1482,'default','payment_edited',594,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1483,'default','payment_edited',633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1484,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 13:33:55','2023-11-15 13:33:55'),(1485,'default','added',897,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5050}}',NULL,'2023-11-15 14:00:53','2023-11-15 14:00:53'),(1486,'default','added',898,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7860}}',NULL,'2023-11-15 14:01:54','2023-11-15 14:01:54'),(1487,'default','added',899,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50195}}',NULL,'2023-11-15 14:12:47','2023-11-15 14:12:47'),(1488,'default','added',900,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-15 14:13:15','2023-11-15 14:13:15'),(1489,'default','added',901,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-11-15 14:15:39','2023-11-15 14:15:39'),(1490,'default','added',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":551500}}',NULL,'2023-11-15 14:21:46','2023-11-15 14:21:46'),(1491,'default','added',903,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-11-15 14:22:19','2023-11-15 14:22:19'),(1492,'default','added',904,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2023-11-15 14:45:46','2023-11-15 14:45:46'),(1493,'default','added',905,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-15 14:52:00','2023-11-15 14:52:00'),(1494,'default','added',906,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-11-15 14:55:33','2023-11-15 14:55:33'),(1495,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 16:54:03','2023-11-15 16:54:03'),(1496,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 17:04:22','2023-11-15 17:04:22'),(1497,'default','payment_edited',96,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1498,'default','payment_edited',122,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5700.0000\"}}',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1499,'default','payment_edited',179,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1500,'default','payment_edited',423,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1501,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-15 17:32:39','2023-11-15 17:32:39'),(1502,'default','added',907,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-15 17:34:12','2023-11-15 17:34:12'),(1503,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 17:36:50','2023-11-15 17:36:50'),(1504,'default','added',908,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10630}}',NULL,'2023-11-15 18:05:21','2023-11-15 18:05:21'),(1505,'default','added',909,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14400}}',NULL,'2023-11-15 18:07:02','2023-11-15 18:07:02'),(1506,'default','added',910,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-15 18:26:39','2023-11-15 18:26:39'),(1507,'default','added',911,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-15 18:36:07','2023-11-15 18:36:07'),(1508,'default','added',912,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2023-11-15 18:37:21','2023-11-15 18:37:21'),(1509,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 18:39:22','2023-11-15 18:39:22'),(1510,'default','added',913,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-15 18:40:57','2023-11-15 18:40:57'),(1511,'default','payment_edited',408,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-15 18:45:42','2023-11-15 18:45:42'),(1512,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-15 19:19:36','2023-11-15 19:19:36'),(1513,'default','added',914,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-15 19:24:24','2023-11-15 19:24:24'),(1514,'default','payment_edited',322,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-11-15 19:41:39','2023-11-15 19:41:39'),(1515,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 19:49:46','2023-11-15 19:49:46'),(1516,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 19:53:30','2023-11-15 19:53:30'),(1517,'default','payment_edited',757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2950.0000\"}}',NULL,'2023-11-15 19:53:59','2023-11-15 19:53:59'),(1518,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 11:08:30','2023-11-16 11:08:30'),(1519,'default','added',915,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6450}}',NULL,'2023-11-16 11:09:38','2023-11-16 11:09:38'),(1520,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-16 11:19:53','2023-11-16 11:19:53'),(1521,'default','payment_edited',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"551500.0000\"}}',NULL,'2023-11-16 11:19:53','2023-11-16 11:19:53'),(1522,'default','added',916,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-16 11:21:13','2023-11-16 11:21:13'),(1523,'default','added',917,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-16 11:21:45','2023-11-16 11:21:45'),(1524,'default','payment_edited',805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-16 11:25:05','2023-11-16 11:25:05'),(1525,'default','payment_edited',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12670.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"}}',NULL,'2023-11-16 11:31:43','2023-11-16 11:31:43'),(1526,'default','payment_edited',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7180.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7180.0000\"}}',NULL,'2023-11-16 11:31:43','2023-11-16 11:31:43'),(1527,'default','payment_edited',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7180.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7180.0000\"}}',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1528,'default','payment_edited',497,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5900.0000\"}}',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1529,'default','payment_edited',538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1530,'default','payment_edited',882,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-11-16 11:32:30','2023-11-16 11:32:30'),(1531,'default','added',918,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-16 11:33:36','2023-11-16 11:33:36'),(1532,'default','added',919,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-11-16 11:52:28','2023-11-16 11:52:28'),(1533,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-16 12:00:01','2023-11-16 12:00:01'),(1534,'default','payment_edited',855,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"128320.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"128320.0000\"}}',NULL,'2023-11-16 12:00:43','2023-11-16 12:00:43'),(1535,'default','added',920,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18450}}',NULL,'2023-11-16 12:09:23','2023-11-16 12:09:23'),(1536,'default','added',91,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 12:10:32','2023-11-16 12:10:32'),(1537,'default','added',921,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-11-16 12:10:56','2023-11-16 12:10:56'),(1538,'default','added',922,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13350}}',NULL,'2023-11-16 12:13:13','2023-11-16 12:13:13'),(1539,'default','added',923,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34500}}',NULL,'2023-11-16 12:14:37','2023-11-16 12:14:37'),(1540,'default','added',924,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13400}}',NULL,'2023-11-16 12:16:45','2023-11-16 12:16:45'),(1541,'default','added',925,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-16 12:17:27','2023-11-16 12:17:27'),(1542,'default','added',926,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-16 12:18:10','2023-11-16 12:18:10'),(1543,'default','added',927,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-16 12:29:03','2023-11-16 12:29:03'),(1544,'default','added',92,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 12:31:42','2023-11-16 12:31:42'),(1545,'default','added',928,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":54900}}',NULL,'2023-11-16 12:32:41','2023-11-16 12:32:41'),(1546,'default','added',929,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-16 12:53:33','2023-11-16 12:53:33'),(1547,'default','added',930,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10270}}',NULL,'2023-11-16 13:24:12','2023-11-16 13:24:12'),(1548,'default','payment_edited',50,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 13:39:10','2023-11-16 13:39:10'),(1549,'default','added',931,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-16 13:46:12','2023-11-16 13:46:12'),(1550,'default','added',932,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500}}',NULL,'2023-11-16 13:58:46','2023-11-16 13:58:46'),(1551,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 16:58:32','2023-11-16 16:58:32'),(1552,'default','payment_edited',694,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2700.0000\"}}',NULL,'2023-11-16 16:59:56','2023-11-16 16:59:56'),(1553,'default','added',933,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 17:01:40','2023-11-16 17:01:40'),(1554,'default','added',934,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-16 17:04:10','2023-11-16 17:04:10'),(1555,'default','added',935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":87210}}',NULL,'2023-11-16 17:06:52','2023-11-16 17:06:52'),(1556,'default','added',936,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 17:07:22','2023-11-16 17:07:22'),(1557,'default','added',93,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 17:10:29','2023-11-16 17:10:29'),(1558,'default','added',937,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-16 17:11:03','2023-11-16 17:11:03'),(1559,'default','added',938,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6000}}',NULL,'2023-11-16 17:11:37','2023-11-16 17:11:37'),(1560,'default','added',939,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15600}}',NULL,'2023-11-16 17:12:27','2023-11-16 17:12:27'),(1561,'default','added',940,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-16 17:13:00','2023-11-16 17:13:00'),(1562,'default','added',941,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10350}}',NULL,'2023-11-16 17:14:29','2023-11-16 17:14:29'),(1563,'default','added',942,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-16 17:15:00','2023-11-16 17:15:00'),(1564,'default','payment_edited',815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"34160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"34160.0000\"}}',NULL,'2023-11-16 17:16:00','2023-11-16 17:16:00'),(1565,'default','payment_edited',935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87210.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"87210.0000\"}}',NULL,'2023-11-16 17:16:00','2023-11-16 17:16:00'),(1566,'default','added',943,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 17:18:25','2023-11-16 17:18:25'),(1567,'default','added',944,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-16 17:21:37','2023-11-16 17:21:37'),(1568,'default','added',945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-16 17:28:02','2023-11-16 17:28:02'),(1569,'default','edited',945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-16 17:33:07','2023-11-16 17:33:07'),(1570,'default','added',946,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-16 17:49:36','2023-11-16 17:49:36'),(1571,'default','added',947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-16 18:02:49','2023-11-16 18:02:49'),(1572,'default','added',948,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 18:06:23','2023-11-16 18:06:23'),(1573,'default','added',949,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-16 18:14:57','2023-11-16 18:14:57'),(1574,'default','added',950,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-16 18:24:49','2023-11-16 18:24:49'),(1575,'default','added',951,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5550}}',NULL,'2023-11-16 18:33:54','2023-11-16 18:33:54'),(1576,'default','added',952,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1750}}',NULL,'2023-11-16 18:35:40','2023-11-16 18:35:40'),(1577,'default','payment_edited',952,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1750.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1750.0000\"}}',NULL,'2023-11-16 18:36:33','2023-11-16 18:36:33'),(1578,'default','added',953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1500}}',NULL,'2023-11-16 18:41:18','2023-11-16 18:41:18'),(1579,'default','payment_edited',953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-16 18:41:39','2023-11-16 18:41:39'),(1580,'default','added',954,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-16 19:17:13','2023-11-16 19:17:13'),(1581,'default','added',955,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33000}}',NULL,'2023-11-16 19:19:37','2023-11-16 19:19:37'),(1582,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:22:32','2023-11-16 19:22:32'),(1583,'default','added',956,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-16 19:29:02','2023-11-16 19:29:02'),(1584,'default','added',957,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-16 19:34:30','2023-11-16 19:34:30'),(1585,'default','added',958,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-16 19:41:12','2023-11-16 19:41:12'),(1586,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:47:30','2023-11-16 19:47:30'),(1587,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:48:08','2023-11-16 19:48:08'),(1588,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:49:41','2023-11-16 19:49:41'),(1589,'default','added',959,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-16 19:53:39','2023-11-16 19:53:39'),(1590,'default','added',960,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-16 19:59:42','2023-11-16 19:59:42'),(1591,'default','added',961,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:00:16','2023-11-16 20:00:16'),(1592,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 20:02:50','2023-11-16 20:02:50'),(1593,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 20:04:46','2023-11-16 20:04:46'),(1594,'default','added',962,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:05:45','2023-11-16 20:05:45'),(1595,'default','added',963,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:06:19','2023-11-16 20:06:19'),(1596,'default','added',964,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:06:38','2023-11-16 20:06:38'),(1597,'default','added',965,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:07:12','2023-11-16 20:07:12'),(1598,'default','added',966,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-16 20:09:08','2023-11-16 20:09:08'),(1599,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 20:09:39','2023-11-16 20:09:39'),(1600,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 14:43:11','2023-11-18 14:43:11'),(1601,'default','added',967,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 14:45:02','2023-11-18 14:45:02'),(1602,'default','added',968,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 14:45:59','2023-11-18 14:45:59'),(1603,'default','added',969,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 14:46:28','2023-11-18 14:46:28'),(1604,'default','payment_edited',938,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6000.0000\"}}',NULL,'2023-11-18 14:46:56','2023-11-18 14:46:56'),(1605,'default','payment_edited',932,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}',NULL,'2023-11-18 14:47:14','2023-11-18 14:47:14'),(1606,'default','payment_edited',633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-18 14:47:33','2023-11-18 14:47:33'),(1607,'default','payment_edited',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-18 14:47:33','2023-11-18 14:47:33'),(1608,'default','payment_edited',538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-18 14:47:55','2023-11-18 14:47:55'),(1609,'default','payment_edited',614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7650.0000\"}}',NULL,'2023-11-18 14:47:55','2023-11-18 14:47:55'),(1610,'default','added',970,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-18 14:49:37','2023-11-18 14:49:37'),(1611,'default','added',971,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9660}}',NULL,'2023-11-18 14:50:59','2023-11-18 14:50:59'),(1612,'default','added',972,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21010}}',NULL,'2023-11-18 14:53:38','2023-11-18 14:53:38'),(1613,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 14:55:31','2023-11-18 14:55:31'),(1614,'default','added',973,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20120}}',NULL,'2023-11-18 14:59:46','2023-11-18 14:59:46'),(1615,'default','added',974,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2750}}',NULL,'2023-11-18 15:01:58','2023-11-18 15:01:58'),(1616,'default','payment_edited',974,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-11-18 15:02:19','2023-11-18 15:02:19'),(1617,'default','added',975,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41080}}',NULL,'2023-11-18 15:05:41','2023-11-18 15:05:41'),(1618,'default','added',976,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-18 15:06:13','2023-11-18 15:06:13'),(1619,'default','added',977,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18650}}',NULL,'2023-11-18 15:08:48','2023-11-18 15:08:48'),(1620,'default','added',978,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9680}}',NULL,'2023-11-18 15:14:54','2023-11-18 15:14:54'),(1621,'default','edited',978,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9680.0000\"}}',NULL,'2023-11-18 15:16:38','2023-11-18 15:16:38'),(1622,'default','added',979,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8030}}',NULL,'2023-11-18 15:17:51','2023-11-18 15:17:51'),(1623,'default','added',980,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18230}}',NULL,'2023-11-18 15:19:55','2023-11-18 15:19:55'),(1624,'default','added',981,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10950}}',NULL,'2023-11-18 15:22:47','2023-11-18 15:22:47'),(1625,'default','added',982,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-18 15:23:27','2023-11-18 15:23:27'),(1626,'default','added',983,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-11-18 15:45:08','2023-11-18 15:45:08'),(1627,'default','added',984,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-18 15:46:48','2023-11-18 15:46:48'),(1628,'default','added',985,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3400}}',NULL,'2023-11-18 15:49:05','2023-11-18 15:49:05'),(1629,'default','payment_edited',985,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-18 15:49:46','2023-11-18 15:49:46'),(1630,'default','added',986,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-18 15:50:06','2023-11-18 15:50:06'),(1631,'default','added',987,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1780}}',NULL,'2023-11-18 15:50:32','2023-11-18 15:50:32'),(1632,'default','added',988,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-18 15:53:50','2023-11-18 15:53:50'),(1633,'default','added',989,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-11-18 15:56:09','2023-11-18 15:56:09'),(1634,'default','added',990,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-18 15:57:54','2023-11-18 15:57:54'),(1635,'default','added',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":145350}}',NULL,'2023-11-18 16:08:36','2023-11-18 16:08:36'),(1636,'default','added',992,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-18 16:17:36','2023-11-18 16:17:36'),(1637,'default','added',993,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-11-18 16:26:44','2023-11-18 16:26:44'),(1638,'default','added',994,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-11-18 16:59:44','2023-11-18 16:59:44'),(1639,'default','added',995,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-18 17:34:54','2023-11-18 17:34:54'),(1640,'default','added',996,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3180}}',NULL,'2023-11-18 17:44:02','2023-11-18 17:44:02'),(1641,'default','added',997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-18 17:50:52','2023-11-18 17:50:52'),(1642,'default','added',998,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-18 18:00:15','2023-11-18 18:00:15'),(1643,'default','added',999,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-18 18:04:28','2023-11-18 18:04:28'),(1644,'default','added',1000,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-18 18:15:24','2023-11-18 18:15:24'),(1645,'default','added',1001,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-18 18:16:44','2023-11-18 18:16:44'),(1646,'default','added',1002,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-18 18:20:29','2023-11-18 18:20:29'),(1647,'default','added',1003,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-18 18:38:08','2023-11-18 18:38:08'),(1648,'default','added',1004,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-18 18:41:56','2023-11-18 18:41:56'),(1649,'default','added',1005,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-18 18:44:58','2023-11-18 18:44:58'),(1650,'default','added',1006,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-18 18:48:25','2023-11-18 18:48:25'),(1651,'default','added',1007,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-18 18:48:45','2023-11-18 18:48:45'),(1652,'default','added',1008,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1430}}',NULL,'2023-11-18 19:15:09','2023-11-18 19:15:09'),(1653,'default','added',1009,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-18 19:18:34','2023-11-18 19:18:34'),(1654,'default','added',1010,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3170}}',NULL,'2023-11-18 19:20:16','2023-11-18 19:20:16'),(1655,'default','added',1011,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-18 19:34:29','2023-11-18 19:34:29'),(1656,'default','added',1012,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-18 19:36:17','2023-11-18 19:36:17'),(1657,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 19:42:41','2023-11-18 19:42:41'),(1658,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 19:42:45','2023-11-18 19:42:45'),(1659,'default','added',1013,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 19:43:16','2023-11-18 19:43:16'),(1660,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 19:43:37','2023-11-18 19:43:37'),(1661,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 00:30:32','2023-11-19 00:30:32'),(1662,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 10:54:07','2023-11-19 10:54:07'),(1663,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 12:33:35','2023-11-19 12:33:35'),(1664,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-19 12:36:48','2023-11-19 12:36:48'),(1665,'default','payment_edited',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"145350.0000\"}}',NULL,'2023-11-19 12:36:48','2023-11-19 12:36:48'),(1666,'default','payment_edited',935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87210.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87210.0000\"}}',NULL,'2023-11-19 12:37:01','2023-11-19 12:37:01'),(1667,'default','payment_edited',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-19 12:37:32','2023-11-19 12:37:32'),(1668,'default','payment_edited',614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7650.0000\"}}',NULL,'2023-11-19 12:39:03','2023-11-19 12:39:03'),(1669,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-19 12:39:03','2023-11-19 12:39:03'),(1670,'default','added',1014,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600}}',NULL,'2023-11-19 12:41:58','2023-11-19 12:41:58'),(1671,'default','added',1015,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16400}}',NULL,'2023-11-19 12:47:03','2023-11-19 12:47:03'),(1672,'default','added',1016,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26973}}',NULL,'2023-11-19 12:48:35','2023-11-19 12:48:35'),(1673,'default','added',1017,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-19 12:49:09','2023-11-19 12:49:09'),(1674,'default','added',1018,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21130}}',NULL,'2023-11-19 12:53:40','2023-11-19 12:53:40'),(1675,'default','added',1019,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-19 12:54:06','2023-11-19 12:54:06'),(1676,'default','added',1020,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12550}}',NULL,'2023-11-19 13:16:47','2023-11-19 13:16:47'),(1677,'default','added',1021,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8260}}',NULL,'2023-11-19 13:17:32','2023-11-19 13:17:32'),(1678,'default','added',1022,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8600}}',NULL,'2023-11-19 13:18:38','2023-11-19 13:18:38'),(1679,'default','added',1023,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7400}}',NULL,'2023-11-19 13:20:19','2023-11-19 13:20:19'),(1680,'default','added',1024,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":142500}}',NULL,'2023-11-19 13:21:35','2023-11-19 13:21:35'),(1681,'default','added',1025,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-19 13:24:05','2023-11-19 13:24:05'),(1682,'default','added',1026,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-19 13:31:38','2023-11-19 13:31:38'),(1683,'default','added',1027,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-19 13:41:07','2023-11-19 13:41:07'),(1684,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 16:58:20','2023-11-19 16:58:20'),(1685,'default','added',1028,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-19 17:01:12','2023-11-19 17:01:12'),(1686,'default','added',1029,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-19 17:12:21','2023-11-19 17:12:21'),(1687,'default','added',1030,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15250}}',NULL,'2023-11-19 17:14:31','2023-11-19 17:14:31'),(1688,'default','added',1031,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-19 17:18:20','2023-11-19 17:18:20'),(1689,'default','added',1032,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11050}}',NULL,'2023-11-19 17:20:50','2023-11-19 17:20:50'),(1690,'default','added',1033,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2850}}',NULL,'2023-11-19 17:25:44','2023-11-19 17:25:44'),(1691,'default','payment_edited',1033,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2850.0000\"}}',NULL,'2023-11-19 17:26:26','2023-11-19 17:26:26'),(1692,'default','added',1034,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-19 17:30:49','2023-11-19 17:30:49'),(1693,'default','payment_edited',697,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"114120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"114120.0000\"}}',NULL,'2023-11-19 18:00:54','2023-11-19 18:00:54'),(1694,'default','added',1035,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-19 18:01:32','2023-11-19 18:01:32'),(1695,'default','added',1036,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-19 18:05:21','2023-11-19 18:05:21'),(1696,'default','added',1037,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-19 18:32:55','2023-11-19 18:32:55'),(1697,'default','added',1038,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10350}}',NULL,'2023-11-19 18:42:04','2023-11-19 18:42:04'),(1698,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 10:41:05','2023-11-20 10:41:05'),(1699,'default','payment_edited',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1700,'default','payment_edited',695,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1701,'default','payment_edited',761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1702,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-20 10:42:54','2023-11-20 10:42:54'),(1703,'default','payment_edited',472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"111100.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"111100.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1704,'default','payment_edited',600,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"45547.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"45547.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1705,'default','payment_edited',715,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"31590.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"31590.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1706,'default','payment_edited',811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"86310.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"86310.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1707,'default','payment_edited',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"}}',NULL,'2023-11-20 10:44:54','2023-11-20 10:44:54'),(1708,'default','added',1039,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-11-20 10:46:35','2023-11-20 10:46:35'),(1709,'default','added',1040,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16720}}',NULL,'2023-11-20 10:52:08','2023-11-20 10:52:08'),(1710,'default','added',1041,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-20 10:54:31','2023-11-20 10:54:31'),(1711,'default','added',1042,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-20 10:55:52','2023-11-20 10:55:52'),(1712,'default','added',1043,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9050}}',NULL,'2023-11-20 10:59:13','2023-11-20 10:59:13'),(1713,'default','added',1044,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29860}}',NULL,'2023-11-20 11:01:14','2023-11-20 11:01:14'),(1714,'default','added',1045,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-20 11:03:40','2023-11-20 11:03:40'),(1715,'default','added',1046,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 11:06:03','2023-11-20 11:06:03'),(1716,'default','added',1047,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1830}}',NULL,'2023-11-20 11:06:41','2023-11-20 11:06:41'),(1717,'default','added',1048,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-20 11:12:09','2023-11-20 11:12:09'),(1718,'default','added',1049,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":36080}}',NULL,'2023-11-20 11:33:30','2023-11-20 11:33:30'),(1719,'default','added',1050,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-20 11:35:34','2023-11-20 11:35:34'),(1720,'default','added',1051,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-20 11:39:50','2023-11-20 11:39:50'),(1721,'default','edited',1051,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"}}',NULL,'2023-11-20 11:44:38','2023-11-20 11:44:38'),(1722,'default','added',1052,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-20 11:58:35','2023-11-20 11:58:35'),(1723,'default','added',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5800000}}',NULL,'2023-11-20 12:04:51','2023-11-20 12:04:51'),(1724,'default','added',1054,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-20 12:15:20','2023-11-20 12:15:20'),(1725,'default','added',1055,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 12:19:28','2023-11-20 12:19:28'),(1726,'default','added',1056,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 12:19:46','2023-11-20 12:19:46'),(1727,'default','edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":580000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5800000.0000\"}}',NULL,'2023-11-20 12:22:55','2023-11-20 12:22:55'),(1728,'default','added',1057,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-20 12:37:31','2023-11-20 12:37:31'),(1729,'default','added',1058,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-20 13:24:48','2023-11-20 13:24:48'),(1730,'default','added',1059,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 13:25:40','2023-11-20 13:25:40'),(1731,'default','added',1060,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-20 13:29:24','2023-11-20 13:29:24'),(1732,'default','added',1061,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-20 13:31:50','2023-11-20 13:31:50'),(1733,'default','added',1062,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-20 13:32:08','2023-11-20 13:32:08'),(1734,'default','added',1063,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-20 13:58:58','2023-11-20 13:58:58'),(1735,'default','added',1064,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-20 14:11:16','2023-11-20 14:11:16'),(1736,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 14:48:11','2023-11-20 14:48:11'),(1737,'default','payment_edited',890,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-20 14:52:56','2023-11-20 14:52:56'),(1738,'default','added',1065,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-20 14:53:59','2023-11-20 14:53:59'),(1739,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 17:18:24','2023-11-20 17:18:24'),(1740,'default','added',1066,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38798.5}}',NULL,'2023-11-20 17:34:09','2023-11-20 17:34:09'),(1741,'default','added',1067,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1650}}',NULL,'2023-11-20 17:35:26','2023-11-20 17:35:26'),(1742,'default','added',1068,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5780}}',NULL,'2023-11-20 17:36:55','2023-11-20 17:36:55'),(1743,'default','added',1069,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-20 17:55:46','2023-11-20 17:55:46'),(1744,'default','added',1070,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-20 18:08:28','2023-11-20 18:08:28'),(1745,'default','added',1071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-20 18:20:49','2023-11-20 18:20:49'),(1746,'default','added',1072,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-20 18:27:12','2023-11-20 18:27:12'),(1747,'default','added',1073,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6050}}',NULL,'2023-11-20 18:49:18','2023-11-20 18:49:18'),(1748,'default','added',1074,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-20 19:07:11','2023-11-20 19:07:11'),(1749,'default','edited',1071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3840},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"}}',NULL,'2023-11-20 19:10:31','2023-11-20 19:10:31'),(1750,'default','added',1075,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-20 19:12:09','2023-11-20 19:12:09'),(1751,'default','added',1076,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1320}}',NULL,'2023-11-20 19:29:56','2023-11-20 19:29:56'),(1752,'default','added',1077,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-20 19:49:04','2023-11-20 19:49:04'),(1753,'default','payment_edited',490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"51800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"51800.0000\"}}',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1754,'default','payment_edited',632,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"64500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"64500.0000\"}}',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1755,'default','payment_edited',716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"207615.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"207615.0000\"}}',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1756,'default','added',1078,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 19:59:06','2023-11-20 19:59:06'),(1757,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 20:01:22','2023-11-20 20:01:22'),(1758,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 10:31:42','2023-11-21 10:31:42'),(1759,'default','added',1079,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 10:33:09','2023-11-21 10:33:09'),(1760,'default','payment_edited',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"}}',NULL,'2023-11-21 10:34:40','2023-11-21 10:34:40'),(1761,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-21 10:35:13','2023-11-21 10:35:13'),(1762,'default','added',1080,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14870}}',NULL,'2023-11-21 10:38:04','2023-11-21 10:38:04'),(1763,'default','added',1081,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9250}}',NULL,'2023-11-21 10:39:44','2023-11-21 10:39:44'),(1764,'default','added',1082,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12380}}',NULL,'2023-11-21 10:41:23','2023-11-21 10:41:23'),(1765,'default','added',1083,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4380}}',NULL,'2023-11-21 10:42:51','2023-11-21 10:42:51'),(1766,'default','edited',81,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 10:48:01','2023-11-21 10:48:01'),(1767,'default','added',1084,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-21 10:53:20','2023-11-21 10:53:20'),(1768,'default','added',94,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 11:09:43','2023-11-21 11:09:43'),(1769,'default','edited',94,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 11:10:53','2023-11-21 11:10:53'),(1770,'default','added',1085,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-11-21 11:13:27','2023-11-21 11:13:27'),(1771,'default','added',1086,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1940}}',NULL,'2023-11-21 11:22:16','2023-11-21 11:22:16'),(1772,'default','added',1087,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-21 11:24:40','2023-11-21 11:24:40'),(1773,'default','added',1088,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1700}}',NULL,'2023-11-21 11:26:13','2023-11-21 11:26:13'),(1774,'default','payment_edited',1088,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-11-21 11:26:35','2023-11-21 11:26:35'),(1775,'default','payment_edited',384,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"181120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"181120.0000\"}}',NULL,'2023-11-21 11:28:44','2023-11-21 11:28:44'),(1776,'default','payment_edited',1024,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"142500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"142500.0000\"}}',NULL,'2023-11-21 11:28:44','2023-11-21 11:28:44'),(1777,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 11:29:33','2023-11-21 11:29:33'),(1778,'default','payment_edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"242465.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"}}',NULL,'2023-11-21 11:47:32','2023-11-21 11:47:32'),(1779,'default','added',1089,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 11:51:49','2023-11-21 11:51:49'),(1780,'default','payment_edited',928,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"54900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"54900.0000\"}}',NULL,'2023-11-21 13:29:40','2023-11-21 13:29:40'),(1781,'default','payment_edited',805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-21 13:29:59','2023-11-21 13:29:59'),(1782,'default','payment_edited',892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6500.0000\"}}',NULL,'2023-11-21 13:29:59','2023-11-21 13:29:59'),(1783,'default','payment_edited',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"145350.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"}}',NULL,'2023-11-21 13:34:25','2023-11-21 13:34:25'),(1784,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-21 13:34:25','2023-11-21 13:34:25'),(1785,'default','added',1090,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-21 13:40:50','2023-11-21 13:40:50'),(1786,'default','added',95,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 13:52:04','2023-11-21 13:52:04'),(1787,'default','added',1091,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-21 13:53:26','2023-11-21 13:53:26'),(1788,'default','added',1092,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-21 14:02:00','2023-11-21 14:02:00'),(1789,'default','added',1093,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-21 14:13:49','2023-11-21 14:13:49'),(1790,'default','added',1094,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2580}}',NULL,'2023-11-21 14:20:19','2023-11-21 14:20:19'),(1791,'default','added',1095,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11550}}',NULL,'2023-11-21 14:27:45','2023-11-21 14:27:45'),(1792,'default','added',1096,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7100}}',NULL,'2023-11-21 14:37:10','2023-11-21 14:37:10'),(1793,'default','added',1097,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29400}}',NULL,'2023-11-21 14:43:10','2023-11-21 14:43:10'),(1794,'default','added',1098,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-21 14:48:22','2023-11-21 14:48:22'),(1795,'default','added',1099,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5980}}',NULL,'2023-11-21 14:55:17','2023-11-21 14:55:17'),(1796,'default','added',1100,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-21 14:55:56','2023-11-21 14:55:56'),(1797,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 14:59:41','2023-11-21 14:59:41'),(1798,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 17:23:48','2023-11-21 17:23:48'),(1799,'default','contact_deleted',95,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 17:24:25','2023-11-21 17:24:25'),(1800,'default','added',96,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 17:26:14','2023-11-21 17:26:14'),(1801,'default','added',1101,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":175000}}',NULL,'2023-11-21 17:27:50','2023-11-21 17:27:50'),(1802,'default','added',1102,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-21 17:35:00','2023-11-21 17:35:00'),(1803,'default','added',1103,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12590}}',NULL,'2023-11-21 17:39:56','2023-11-21 17:39:56'),(1804,'default','added',1104,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20435}}',NULL,'2023-11-21 17:41:00','2023-11-21 17:41:00'),(1805,'default','added',1105,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3950}}',NULL,'2023-11-21 17:42:13','2023-11-21 17:42:13'),(1806,'default','added',1106,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20640}}',NULL,'2023-11-21 17:46:23','2023-11-21 17:46:23'),(1807,'default','added',1107,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-21 17:47:45','2023-11-21 17:47:45'),(1808,'default','added',1108,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-21 17:54:52','2023-11-21 17:54:52'),(1809,'default','added',1109,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 18:02:29','2023-11-21 18:02:29'),(1810,'default','added',1110,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-21 18:05:25','2023-11-21 18:05:25'),(1811,'default','added',1111,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 18:11:56','2023-11-21 18:11:56'),(1812,'default','added',1112,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-21 18:28:13','2023-11-21 18:28:13'),(1813,'default','added',1113,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3070}}',NULL,'2023-11-21 18:29:48','2023-11-21 18:29:48'),(1814,'default','added',1114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-21 18:38:30','2023-11-21 18:38:30'),(1815,'default','added',1115,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10250}}',NULL,'2023-11-21 18:39:13','2023-11-21 18:39:13'),(1816,'default','added',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":70000}}',NULL,'2023-11-21 18:47:52','2023-11-21 18:47:52'),(1817,'default','added',1117,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-11-21 19:27:20','2023-11-21 19:27:20'),(1818,'default','added',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":251954}}',NULL,'2023-11-21 19:28:45','2023-11-21 19:28:45'),(1819,'default','added',1119,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-21 19:39:07','2023-11-21 19:39:07'),(1820,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 19:40:05','2023-11-21 19:40:05'),(1821,'default','added',1120,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2470}}',NULL,'2023-11-21 19:46:46','2023-11-21 19:46:46'),(1822,'default','added',1121,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":44800}}',NULL,'2023-11-21 20:00:41','2023-11-21 20:00:41'),(1823,'default','added',1122,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-21 20:04:04','2023-11-21 20:04:04'),(1824,'default','added',1123,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":76230}}',NULL,'2023-11-21 20:07:12','2023-11-21 20:07:12'),(1825,'default','added',1124,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 20:16:26','2023-11-21 20:16:26'),(1826,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 20:16:58','2023-11-21 20:16:58'),(1827,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 10:28:22','2023-11-22 10:28:22'),(1828,'default','payment_edited',761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-22 10:29:23','2023-11-22 10:29:23'),(1829,'default','payment_edited',806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-22 10:29:23','2023-11-22 10:29:23'),(1830,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-22 10:29:50','2023-11-22 10:29:50'),(1831,'default','payment_edited',751,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3380.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3380.0000\"}}',NULL,'2023-11-22 10:29:50','2023-11-22 10:29:50'),(1832,'default','payment_edited',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"}}',NULL,'2023-11-22 10:29:50','2023-11-22 10:29:50'),(1833,'default','added',1125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10190}}',NULL,'2023-11-22 10:32:18','2023-11-22 10:32:18'),(1834,'default','added',1126,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10010}}',NULL,'2023-11-22 10:34:32','2023-11-22 10:34:32'),(1835,'default','added',1127,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-11-22 10:35:03','2023-11-22 10:35:03'),(1836,'default','added',1128,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8100}}',NULL,'2023-11-22 10:39:48','2023-11-22 10:39:48'),(1837,'default','added',1129,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-22 10:45:47','2023-11-22 10:45:47'),(1838,'default','added',1130,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-22 10:52:10','2023-11-22 10:52:10'),(1839,'default','added',1131,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-11-22 10:55:11','2023-11-22 10:55:11'),(1840,'default','payment_edited',1127,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-11-22 10:56:37','2023-11-22 10:56:37'),(1841,'default','added',1132,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-22 10:58:25','2023-11-22 10:58:25'),(1842,'default','added',1133,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-22 11:09:23','2023-11-22 11:09:23'),(1843,'default','added',1134,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":164000}}',NULL,'2023-11-22 11:21:41','2023-11-22 11:21:41'),(1844,'default','added',97,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 11:34:33','2023-11-22 11:34:33'),(1845,'default','added',1135,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-11-22 11:35:24','2023-11-22 11:35:24'),(1846,'default','added',1136,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-22 11:38:23','2023-11-22 11:38:23'),(1847,'default','added',1137,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-11-22 11:41:32','2023-11-22 11:41:32'),(1848,'default','added',1138,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-22 11:42:04','2023-11-22 11:42:04'),(1849,'default','added',1139,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2190}}',NULL,'2023-11-22 12:16:50','2023-11-22 12:16:50'),(1850,'default','edited',97,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 12:17:49','2023-11-22 12:17:49'),(1851,'default','added',1140,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-22 12:34:40','2023-11-22 12:34:40'),(1852,'default','added',1141,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-22 12:43:38','2023-11-22 12:43:38'),(1853,'default','added',1142,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-22 12:44:29','2023-11-22 12:44:29'),(1854,'default','added',1143,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":28677}}',NULL,'2023-11-22 12:54:10','2023-11-22 12:54:10'),(1855,'default','payment_edited',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"37080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"}}',NULL,'2023-11-22 13:19:21','2023-11-22 13:19:21'),(1856,'default','payment_edited',1134,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"164000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"164000.0000\"}}',NULL,'2023-11-22 13:19:21','2023-11-22 13:19:21'),(1857,'default','added',1144,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-22 13:38:44','2023-11-22 13:38:44'),(1858,'default','added',1145,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2530}}',NULL,'2023-11-22 13:39:35','2023-11-22 13:39:35'),(1859,'default','added',98,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 13:41:09','2023-11-22 13:41:09'),(1860,'default','added',1146,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":42500}}',NULL,'2023-11-22 13:48:15','2023-11-22 13:48:15'),(1861,'default','added',1147,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-22 13:53:50','2023-11-22 13:53:50'),(1862,'default','added',1148,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4350}}',NULL,'2023-11-22 14:30:05','2023-11-22 14:30:05'),(1863,'default','added',1149,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48815.25}}',NULL,'2023-11-22 14:35:02','2023-11-22 14:35:02'),(1864,'default','added',1150,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 14:37:18','2023-11-22 14:37:18'),(1865,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 17:18:09','2023-11-22 17:18:09'),(1866,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 17:20:46','2023-11-22 17:20:46'),(1867,'default','added',1151,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-22 17:23:17','2023-11-22 17:23:17'),(1868,'default','added',1152,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10150}}',NULL,'2023-11-22 17:27:21','2023-11-22 17:27:21'),(1869,'default','added',1153,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-22 17:28:14','2023-11-22 17:28:14'),(1870,'default','edited',1153,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"}}',NULL,'2023-11-22 17:33:09','2023-11-22 17:33:09'),(1871,'default','sell_deleted',1153,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":1153,\"invoice_no\":\"0888\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"}}',NULL,'2023-11-22 17:36:14','2023-11-22 17:36:14'),(1872,'default','added',1154,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-22 17:37:55','2023-11-22 17:37:55'),(1873,'default','payment_edited',806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-22 17:38:35','2023-11-22 17:38:35'),(1874,'default','added',1155,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-22 17:38:35','2023-11-22 17:38:35'),(1875,'default','added',1156,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9650}}',NULL,'2023-11-22 17:40:57','2023-11-22 17:40:57'),(1876,'default','added',1157,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 17:45:58','2023-11-22 17:45:58'),(1877,'default','added',1158,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-22 17:46:41','2023-11-22 17:46:41'),(1878,'default','added',1159,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34920}}',NULL,'2023-11-22 18:17:56','2023-11-22 18:17:56'),(1879,'default','added',1160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-22 18:18:53','2023-11-22 18:18:53'),(1880,'default','added',1161,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-22 18:24:26','2023-11-22 18:24:26'),(1881,'default','added',1162,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-11-22 18:26:23','2023-11-22 18:26:23'),(1882,'default','added',1163,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 18:33:14','2023-11-22 18:33:14'),(1883,'default','added',1164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 18:37:38','2023-11-22 18:37:38'),(1884,'default','added',1165,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-22 19:12:39','2023-11-22 19:12:39'),(1885,'default','added',1166,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-22 19:15:03','2023-11-22 19:15:03'),(1886,'default','added',1167,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-22 19:15:57','2023-11-22 19:15:57'),(1887,'default','added',1168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-22 19:18:01','2023-11-22 19:18:01'),(1888,'default','added',1169,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-11-22 19:22:58','2023-11-22 19:22:58'),(1889,'default','added',1170,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 19:23:31','2023-11-22 19:23:31'),(1890,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 19:41:46','2023-11-22 19:41:46'),(1891,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 10:23:36','2023-11-23 10:23:36'),(1892,'default','payment_edited',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"}}',NULL,'2023-11-23 10:27:21','2023-11-23 10:27:21'),(1893,'default','added',1171,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-23 10:28:25','2023-11-23 10:28:25'),(1894,'default','added',1172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15290}}',NULL,'2023-11-23 10:30:26','2023-11-23 10:30:26'),(1895,'default','payment_edited',983,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-11-23 10:37:57','2023-11-23 10:37:57'),(1896,'default','added',1173,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-23 10:43:34','2023-11-23 10:43:34'),(1897,'default','payment_edited',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"}}',NULL,'2023-11-23 10:44:28','2023-11-23 10:44:28'),(1898,'default','added',1174,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-23 10:48:03','2023-11-23 10:48:03'),(1899,'default','added',1175,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-23 10:51:13','2023-11-23 10:51:13'),(1900,'default','added',1176,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-23 11:00:49','2023-11-23 11:00:49'),(1901,'default','added',1177,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10630}}',NULL,'2023-11-23 11:03:58','2023-11-23 11:03:58'),(1902,'default','added',1178,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12820}}',NULL,'2023-11-23 11:05:01','2023-11-23 11:05:01'),(1903,'default','added',1179,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44355}}',NULL,'2023-11-23 11:07:16','2023-11-23 11:07:16'),(1904,'default','added',1180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-23 11:15:18','2023-11-23 11:15:18'),(1905,'default','added',1181,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-23 11:27:51','2023-11-23 11:27:51'),(1906,'default','added',1182,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-11-23 11:40:33','2023-11-23 11:40:33'),(1907,'default','added',1183,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 11:41:25','2023-11-23 11:41:25'),(1908,'default','added',1184,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-23 11:44:00','2023-11-23 11:44:00'),(1909,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-23 12:01:52','2023-11-23 12:01:52'),(1910,'default','added',1185,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-23 12:14:44','2023-11-23 12:14:44'),(1911,'default','added',1186,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-11-23 12:30:25','2023-11-23 12:30:25'),(1912,'default','added',1187,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-23 12:32:04','2023-11-23 12:32:04'),(1913,'default','added',1188,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-23 12:36:56','2023-11-23 12:36:56'),(1914,'default','added',1189,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3580}}',NULL,'2023-11-23 12:43:37','2023-11-23 12:43:37'),(1915,'default','added',1190,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-23 13:36:51','2023-11-23 13:36:51'),(1916,'default','added',99,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 13:38:02','2023-11-23 13:38:02'),(1917,'default','added',1191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-11-23 13:38:28','2023-11-23 13:38:28'),(1918,'default','added',1192,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4750}}',NULL,'2023-11-23 13:39:52','2023-11-23 13:39:52'),(1919,'default','added',1193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31200}}',NULL,'2023-11-23 13:42:39','2023-11-23 13:42:39'),(1920,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 13:44:51','2023-11-23 13:44:51'),(1921,'default','added',1194,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-11-23 13:48:58','2023-11-23 13:48:58'),(1922,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-23 13:49:16','2023-11-23 13:49:16'),(1923,'default','added',1195,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4800}}',NULL,'2023-11-23 13:54:14','2023-11-23 13:54:14'),(1924,'default','added',1196,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}',NULL,'2023-11-23 13:55:07','2023-11-23 13:55:07'),(1925,'default','added',1197,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":320}}',NULL,'2023-11-23 14:05:16','2023-11-23 14:05:16'),(1926,'default','added',1198,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250}}',NULL,'2023-11-23 14:41:12','2023-11-23 14:41:12'),(1927,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 17:29:16','2023-11-23 17:29:16'),(1928,'default','added',1199,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":109400}}',NULL,'2023-11-23 17:34:17','2023-11-23 17:34:17'),(1929,'default','added',1200,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":57240}}',NULL,'2023-11-23 17:38:29','2023-11-23 17:38:29'),(1930,'default','added',1201,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8850}}',NULL,'2023-11-23 17:42:38','2023-11-23 17:42:38'),(1931,'default','added',1202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34245.5999999999985448084771633148193359375}}',NULL,'2023-11-23 17:49:04','2023-11-23 17:49:04'),(1932,'default','added',1203,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-11-23 17:50:51','2023-11-23 17:50:51'),(1933,'default','added',1204,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4630}}',NULL,'2023-11-23 17:53:08','2023-11-23 17:53:08'),(1934,'default','added',1205,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13320}}',NULL,'2023-11-23 17:55:29','2023-11-23 17:55:29'),(1935,'default','added',1206,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13000}}',NULL,'2023-11-23 17:56:14','2023-11-23 17:56:14'),(1936,'default','added',100,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 18:00:20','2023-11-23 18:00:20'),(1937,'default','added',1207,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-23 18:01:28','2023-11-23 18:01:28'),(1938,'default','added',1208,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-23 18:14:17','2023-11-23 18:14:17'),(1939,'default','added',1209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8850}}',NULL,'2023-11-23 18:29:11','2023-11-23 18:29:11'),(1940,'default','added',1210,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 18:35:41','2023-11-23 18:35:41'),(1941,'default','payment_edited',811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"86310.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"86310.0000\"}}',NULL,'2023-11-23 18:38:28','2023-11-23 18:38:28'),(1942,'default','payment_edited',899,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50195.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50195.0000\"}}',NULL,'2023-11-23 18:38:28','2023-11-23 18:38:28'),(1943,'default','payment_edited',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"251954.0000\"}}',NULL,'2023-11-23 18:38:28','2023-11-23 18:38:28'),(1944,'default','added',1211,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4330}}',NULL,'2023-11-23 19:08:08','2023-11-23 19:08:08'),(1945,'default','edited',1209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3481},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8850.0000\"}}',NULL,'2023-11-23 19:09:50','2023-11-23 19:09:50'),(1946,'default','sell_deleted',1209,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":1209,\"invoice_no\":\"0936\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3481.0000\"}}',NULL,'2023-11-23 19:10:31','2023-11-23 19:10:31'),(1947,'default','added',1212,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3481}}',NULL,'2023-11-23 19:14:03','2023-11-23 19:14:03'),(1948,'default','added',1213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4560}}',NULL,'2023-11-23 19:17:52','2023-11-23 19:17:52'),(1949,'default','added',1214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-23 19:28:13','2023-11-23 19:28:13'),(1950,'default','added',1215,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-23 19:31:33','2023-11-23 19:31:33'),(1951,'default','added',1216,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1930}}',NULL,'2023-11-23 19:31:48','2023-11-23 19:31:48'),(1952,'default','added',1217,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:40:59','2023-11-23 19:40:59'),(1953,'default','added',1218,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:43:37','2023-11-23 19:43:37'),(1954,'default','added',1219,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:45:23','2023-11-23 19:45:23'),(1955,'default','added',1220,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-23 19:47:01','2023-11-23 19:47:01'),(1956,'default','added',1221,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-23 19:47:56','2023-11-23 19:47:56'),(1957,'default','added',1222,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:50:42','2023-11-23 19:50:42'),(1958,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:51:59','2023-11-23 19:51:59'),(1959,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:52:07','2023-11-23 19:52:07'),(1960,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:52:15','2023-11-23 19:52:15'),(1961,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:52:44','2023-11-23 19:52:44'),(1962,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:53:33','2023-11-23 19:53:33'),(1963,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-24 01:24:15','2023-11-24 01:24:15'),(1964,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 10:38:57','2023-11-25 10:38:57'),(1965,'default','added',1223,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-25 10:39:55','2023-11-25 10:39:55'),(1966,'default','added',1224,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-11-25 10:40:33','2023-11-25 10:40:33'),(1967,'default','payment_edited',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21210.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"}}',NULL,'2023-11-25 10:42:38','2023-11-25 10:42:38'),(1968,'default','payment_edited',981,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10950.0000\"}}',NULL,'2023-11-25 10:42:38','2023-11-25 10:42:38'),(1969,'default','added',1225,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8930}}',NULL,'2023-11-25 10:43:56','2023-11-25 10:43:56'),(1970,'default','added',1226,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9860}}',NULL,'2023-11-25 10:45:37','2023-11-25 10:45:37'),(1971,'default','added',1227,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9700}}',NULL,'2023-11-25 10:47:57','2023-11-25 10:47:57'),(1972,'default','added',1228,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-11-25 10:48:36','2023-11-25 10:48:36'),(1973,'default','added',1229,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8420}}',NULL,'2023-11-25 10:50:24','2023-11-25 10:50:24'),(1974,'default','added',1230,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-25 10:52:53','2023-11-25 10:52:53'),(1975,'default','added',1231,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51695}}',NULL,'2023-11-25 10:54:56','2023-11-25 10:54:56'),(1976,'default','added',1232,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-25 10:58:00','2023-11-25 10:58:00'),(1977,'default','added',1233,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10230}}',NULL,'2023-11-25 11:00:47','2023-11-25 11:00:47'),(1978,'default','added',1234,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3300}}',NULL,'2023-11-25 11:03:40','2023-11-25 11:03:40'),(1979,'default','added',1235,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-11-25 11:04:44','2023-11-25 11:04:44'),(1980,'default','added',1236,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-25 11:04:58','2023-11-25 11:04:58'),(1981,'default','added',1237,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-25 11:07:05','2023-11-25 11:07:05'),(1982,'default','added',1238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-25 11:08:11','2023-11-25 11:08:11'),(1983,'default','added',1239,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-11-25 11:15:27','2023-11-25 11:15:27'),(1984,'default','added',101,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 11:27:01','2023-11-25 11:27:01'),(1985,'default','added',1240,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":21450}}',NULL,'2023-11-25 11:28:26','2023-11-25 11:28:26'),(1986,'default','added',1241,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-25 11:32:40','2023-11-25 11:32:40'),(1987,'default','added',1242,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-25 11:40:32','2023-11-25 11:40:32'),(1988,'default','added',1243,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-25 11:57:21','2023-11-25 11:57:21'),(1989,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 12:06:35','2023-11-25 12:06:35'),(1990,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 12:07:06','2023-11-25 12:07:06'),(1991,'default','added',1244,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-25 12:07:59','2023-11-25 12:08:00'),(1992,'default','added',1245,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-11-25 12:10:59','2023-11-25 12:10:59'),(1993,'default','added',1246,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-25 12:12:19','2023-11-25 12:12:19'),(1994,'default','added',1247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-25 12:20:55','2023-11-25 12:20:55'),(1995,'default','added',1248,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4650}}',NULL,'2023-11-25 12:36:32','2023-11-25 12:36:32'),(1996,'default','added',1249,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-25 12:39:48','2023-11-25 12:39:48'),(1997,'default','payment_edited',1240,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"21450.0000\"}}',NULL,'2023-11-25 12:46:57','2023-11-25 12:46:57'),(1998,'default','added',1250,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-25 13:30:07','2023-11-25 13:30:07'),(1999,'default','added',1251,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-25 13:55:27','2023-11-25 13:55:27'),(2000,'default','added',1252,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-25 13:57:24','2023-11-25 13:57:24'),(2001,'default','added',1253,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-25 13:58:03','2023-11-25 13:58:03'),(2002,'default','added',1254,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-11-25 13:59:44','2023-11-25 13:59:44'),(2003,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 14:02:26','2023-11-25 14:02:26'),(2004,'default','added',1255,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-25 14:10:58','2023-11-25 14:10:58'),(2005,'default','added',1256,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2980}}',NULL,'2023-11-25 14:16:49','2023-11-25 14:16:49'),(2006,'default','added',1257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-11-25 14:24:23','2023-11-25 14:24:23'),(2007,'default','payment_edited',603,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2650.0000\"}}',NULL,'2023-11-25 14:41:15','2023-11-25 14:41:15'),(2008,'default','payment_edited',1224,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-11-25 14:41:15','2023-11-25 14:41:15'),(2009,'default','added',1258,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-25 14:47:25','2023-11-25 14:47:25'),(2010,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 17:03:41','2023-11-25 17:03:41'),(2011,'default','added',1259,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-25 17:09:47','2023-11-25 17:09:47'),(2012,'default','added',1260,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8820}}',NULL,'2023-11-25 17:11:26','2023-11-25 17:11:26'),(2013,'default','added',1261,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-25 17:12:10','2023-11-25 17:12:10'),(2014,'default','added',1262,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20840.02000000000043655745685100555419921875}}',NULL,'2023-11-25 17:14:34','2023-11-25 17:14:34'),(2015,'default','added',1263,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-25 17:17:43','2023-11-25 17:17:43'),(2016,'default','added',1264,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15600}}',NULL,'2023-11-25 17:20:18','2023-11-25 17:20:18'),(2017,'default','added',102,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 17:25:37','2023-11-25 17:25:37'),(2018,'default','added',1266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-11-25 17:26:23','2023-11-25 17:26:23'),(2019,'default','payment_edited',935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"87210.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87210.0000\"}}',NULL,'2023-11-25 17:31:42','2023-11-25 17:31:42'),(2020,'default','payment_edited',1123,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"76230.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"76230.0000\"}}',NULL,'2023-11-25 17:31:42','2023-11-25 17:31:42'),(2021,'default','payment_edited',1143,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"28677.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"28677.0000\"}}',NULL,'2023-11-25 17:31:42','2023-11-25 17:31:42'),(2022,'default','payment_edited',1193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"31200.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"31200.0000\"}}',NULL,'2023-11-25 17:31:42','2023-11-25 17:31:42'),(2023,'default','added',1267,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-25 17:34:42','2023-11-25 17:34:42'),(2024,'default','added',1268,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-25 17:35:40','2023-11-25 17:35:40'),(2025,'default','added',1269,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-25 17:41:32','2023-11-25 17:41:32'),(2026,'default','added',1270,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-25 18:14:55','2023-11-25 18:14:55'),(2027,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 18:19:56','2023-11-25 18:19:56'),(2028,'default','payment_edited',1203,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-11-25 18:27:35','2023-11-25 18:27:35'),(2029,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 18:29:29','2023-11-25 18:29:29'),(2030,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 18:29:34','2023-11-25 18:29:34'),(2031,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-25 18:33:16','2023-11-25 18:33:16'),(2032,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-25 18:40:12','2023-11-25 18:40:12'),(2033,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 19:15:29','2023-11-25 19:15:29'),(2034,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 19:15:46','2023-11-25 19:15:46'),(2035,'default','payment_edited',806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-25 19:44:11','2023-11-25 19:44:11'),(2036,'default','payment_edited',813,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-25 19:44:11','2023-11-25 19:44:11'),(2037,'default','payment_edited',844,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-25 19:44:11','2023-11-25 19:44:11'),(2039,'default','payment_edited',54,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 19:48:39','2023-11-25 19:48:39'),(2040,'default','added',1271,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3380}}',NULL,'2023-11-25 19:59:52','2023-11-25 19:59:52'),(2041,'default','added',1272,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4550}}',NULL,'2023-11-25 20:08:44','2023-11-25 20:08:44'),(2042,'default','added',1273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1430}}',NULL,'2023-11-25 20:09:08','2023-11-25 20:09:08'),(2043,'default','added',103,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 20:11:40','2023-11-25 20:11:40'),(2044,'default','added',1274,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":57520}}',NULL,'2023-11-25 20:14:05','2023-11-25 20:14:05'),(2045,'default','added',1275,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-25 20:14:31','2023-11-25 20:14:31'),(2046,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 20:14:45','2023-11-25 20:14:45'),(2047,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 20:17:35','2023-11-25 20:17:35'),(2048,'default','payment_edited',54,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 20:19:22','2023-11-25 20:19:22'),(2049,'default','added',1276,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-25 20:21:53','2023-11-25 20:21:53'),(2050,'default','added',1277,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-25 20:26:01','2023-11-25 20:26:01'),(2051,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 20:28:09','2023-11-25 20:28:09'),(2052,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 10:30:23','2023-11-26 10:30:23'),(2053,'default','added',1278,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-26 10:33:08','2023-11-26 10:33:08'),(2054,'default','added',1279,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-26 10:33:28','2023-11-26 10:33:28'),(2055,'default','added',1280,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1700}}',NULL,'2023-11-26 10:37:52','2023-11-26 10:37:52'),(2056,'default','payment_edited',1280,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-11-26 10:38:34','2023-11-26 10:38:34'),(2057,'default','added',1281,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-11-26 10:40:38','2023-11-26 10:40:38'),(2058,'default','added',1282,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-11-26 10:41:37','2023-11-26 10:41:37'),(2059,'default','payment_edited',1224,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"}}',NULL,'2023-11-26 10:42:47','2023-11-26 10:42:47'),(2060,'default','payment_edited',1257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-26 10:42:47','2023-11-26 10:42:47'),(2061,'default','added',1283,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-11-26 10:44:20','2023-11-26 10:44:20'),(2062,'default','payment_edited',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"}}',NULL,'2023-11-26 10:44:49','2023-11-26 10:44:49'),(2063,'default','payment_edited',844,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-26 10:45:07','2023-11-26 10:45:07'),(2064,'default','payment_edited',891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-26 10:45:07','2023-11-26 10:45:07'),(2065,'default','added',1284,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14800}}',NULL,'2023-11-26 10:46:45','2023-11-26 10:46:45'),(2066,'default','payment_edited',981,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10950.0000\"}}',NULL,'2023-11-26 10:47:11','2023-11-26 10:47:11'),(2067,'default','payment_edited',1014,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5600.0000\"}}',NULL,'2023-11-26 10:47:11','2023-11-26 10:47:11'),(2068,'default','added',1285,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9050}}',NULL,'2023-11-26 10:48:47','2023-11-26 10:48:47'),(2069,'default','added',1286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550}}',NULL,'2023-11-26 10:49:20','2023-11-26 10:49:20'),(2070,'default','added',104,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 10:52:00','2023-11-26 10:52:00'),(2071,'default','added',1287,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2550}}',NULL,'2023-11-26 10:52:20','2023-11-26 10:52:20'),(2072,'default','added',1288,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41799.449999999997089616954326629638671875}}',NULL,'2023-11-26 10:54:24','2023-11-26 10:54:24'),(2073,'default','added',1289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11270}}',NULL,'2023-11-26 10:55:28','2023-11-26 10:55:28'),(2074,'default','added',1290,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3870}}',NULL,'2023-11-26 10:56:19','2023-11-26 10:56:19'),(2075,'default','payment_edited',134,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 11:01:54','2023-11-26 11:01:54'),(2076,'default','added',1291,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-26 11:05:09','2023-11-26 11:05:09'),(2077,'default','added',1292,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-26 11:22:31','2023-11-26 11:22:31'),(2078,'default','added',1293,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-26 11:26:40','2023-11-26 11:26:40'),(2079,'default','added',1294,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-26 11:27:56','2023-11-26 11:27:56'),(2080,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 11:51:38','2023-11-26 11:51:38'),(2081,'default','added',1295,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7600}}',NULL,'2023-11-26 12:18:14','2023-11-26 12:18:14'),(2082,'default','added',1296,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-26 12:22:25','2023-11-26 12:22:25'),(2083,'default','added',1297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-26 12:24:17','2023-11-26 12:24:17'),(2093,'default','payment_edited',1207,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-26 13:52:57','2023-11-26 13:52:57'),(2094,'default','added',1298,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-26 13:54:03','2023-11-26 13:54:03'),(2095,'default','payment_edited',1287,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"}}',NULL,'2023-11-26 13:54:45','2023-11-26 13:54:45'),(2096,'default','added',1299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-11-26 13:55:17','2023-11-26 13:55:17'),(2097,'default','added',1300,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7600}}',NULL,'2023-11-26 13:56:01','2023-11-26 13:56:01'),(2098,'default','added',1301,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-26 13:57:08','2023-11-26 13:57:08'),(2099,'default','added',1302,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-26 13:59:28','2023-11-26 13:59:28'),(2100,'default','added',1303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-26 14:00:30','2023-11-26 14:00:30'),(2101,'default','added',1304,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10700}}',NULL,'2023-11-26 14:03:00','2023-11-26 14:03:00'),(2102,'default','added',1305,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5850}}',NULL,'2023-11-26 14:17:39','2023-11-26 14:17:39'),(2103,'default','added',1306,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5970}}',NULL,'2023-11-26 14:31:54','2023-11-26 14:31:54'),(2104,'default','added',1307,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-26 14:40:52','2023-11-26 14:40:52'),(2105,'default','added',1308,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8850}}',NULL,'2023-11-26 14:42:30','2023-11-26 14:42:30'),(2106,'default','added',1309,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-11-26 14:42:46','2023-11-26 14:42:46'),(2107,'default','added',1310,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-26 14:43:25','2023-11-26 14:43:25'),(2108,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 17:44:25','2023-11-26 17:44:25'),(2109,'default','added',1311,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16847.5999999999985448084771633148193359375}}',NULL,'2023-11-26 17:51:00','2023-11-26 17:51:00'),(2110,'default','added',1312,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10430}}',NULL,'2023-11-26 17:52:29','2023-11-26 17:52:29'),(2111,'default','added',1313,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7950}}',NULL,'2023-11-26 17:53:55','2023-11-26 17:53:55'),(2112,'default','added',1314,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-26 17:59:59','2023-11-26 17:59:59'),(2113,'default','payment_edited',891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-26 18:07:21','2023-11-26 18:07:21'),(2114,'default','payment_edited',925,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-26 18:07:21','2023-11-26 18:07:21'),(2115,'default','payment_edited',114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"49860.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"49860.0000\"}}',NULL,'2023-11-26 18:10:22','2023-11-26 18:10:22'),(2116,'default','payment_edited',1200,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"57240.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"57240.0000\"}}',NULL,'2023-11-26 18:10:22','2023-11-26 18:10:22'),(2117,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 18:14:47','2023-11-26 18:14:47'),(2118,'default','edited',103,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 18:15:29','2023-11-26 18:15:29'),(2119,'default','payment_edited',1274,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"57520.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"57520.0000\"}}',NULL,'2023-11-26 18:16:21','2023-11-26 18:16:21'),(2120,'default','payment_edited',1315,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 18:16:21','2023-11-26 18:16:21'),(2121,'default','added',1316,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-26 18:20:05','2023-11-26 18:20:05'),(2122,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 18:27:07','2023-11-26 18:27:07'),(2123,'default','added',1317,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-26 18:34:39','2023-11-26 18:34:39'),(2124,'default','added',1318,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-26 18:36:36','2023-11-26 18:36:36'),(2125,'default','added',1319,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-26 18:40:18','2023-11-26 18:40:18'),(2126,'default','added',1320,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-26 18:41:39','2023-11-26 18:41:39'),(2127,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 19:23:31','2023-11-26 19:23:31'),(2128,'default','added',1321,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7550}}',NULL,'2023-11-26 20:02:54','2023-11-26 20:02:54'),(2129,'default','added',1322,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-26 20:05:13','2023-11-26 20:05:13'),(2130,'default','added',1323,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-26 20:11:53','2023-11-26 20:11:53'),(2131,'default','edited',1274,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":57740},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"57520.0000\"}}',NULL,'2023-11-26 20:22:28','2023-11-26 20:22:28'),(2132,'default','added',1324,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":97618}}',NULL,'2023-11-26 20:23:04','2023-11-26 20:23:04'),(2133,'default','added',1325,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-26 20:24:20','2023-11-26 20:24:20'),(2134,'default','added',1326,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-26 20:24:50','2023-11-26 20:24:50'),(2135,'default','added',1327,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7550}}',NULL,'2023-11-26 20:29:05','2023-11-26 20:29:05'),(2136,'default','added',1328,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1390}}',NULL,'2023-11-26 20:30:42','2023-11-26 20:30:42'),(2137,'default','added',1329,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4340}}',NULL,'2023-11-26 20:35:16','2023-11-26 20:35:16'),(2138,'default','added',1330,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8000}}',NULL,'2023-11-26 20:36:21','2023-11-26 20:36:21'),(2139,'default','added',1331,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-26 20:43:59','2023-11-26 20:43:59'),(2140,'default','added',1332,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-26 20:46:59','2023-11-26 20:46:59'),(2141,'default','added',1333,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900}}',NULL,'2023-11-26 20:53:02','2023-11-26 20:53:02'),(2142,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-26 20:54:15','2023-11-26 20:54:15'),(2143,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 10:23:02','2023-11-27 10:23:02'),(2144,'default','edited',73,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 10:27:29','2023-11-27 10:27:29'),(2145,'default','added',1334,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-11-27 10:28:56','2023-11-27 10:28:56'),(2146,'default','added',1335,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-27 10:30:25','2023-11-27 10:30:25'),(2147,'default','payment_edited',1191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-11-27 10:31:01','2023-11-27 10:31:01'),(2148,'default','payment_edited',1282,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-11-27 10:31:27','2023-11-27 10:31:27'),(2149,'default','payment_edited',49,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 10:32:43','2023-11-27 10:32:43'),(2150,'default','payment_edited',1014,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"}}',NULL,'2023-11-27 10:33:35','2023-11-27 10:33:35'),(2151,'default','payment_edited',1039,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-11-27 10:33:35','2023-11-27 10:33:35'),(2152,'default','added',1336,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11299.29999999999927240423858165740966796875}}',NULL,'2023-11-27 10:38:35','2023-11-27 10:38:35'),(2153,'default','added',1337,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8520}}',NULL,'2023-11-27 10:42:17','2023-11-27 10:42:17'),(2154,'default','added',1338,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4790}}',NULL,'2023-11-27 10:44:19','2023-11-27 10:44:19'),(2155,'default','added',1339,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-27 10:46:18','2023-11-27 10:46:18'),(2156,'default','added',1340,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-27 10:49:52','2023-11-27 10:49:52'),(2157,'default','added',1341,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48757.5}}',NULL,'2023-11-27 10:52:40','2023-11-27 10:52:40'),(2158,'default','added',1342,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-27 11:18:33','2023-11-27 11:18:33'),(2159,'default','added',1343,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-27 11:22:39','2023-11-27 11:22:39'),(2160,'default','payment_edited',1274,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"57740.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"57740.0000\"}}',NULL,'2023-11-27 11:36:10','2023-11-27 11:36:10'),(2161,'default','payment_edited',1315,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 11:36:10','2023-11-27 11:36:10'),(2162,'default','added',1344,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-27 13:30:55','2023-11-27 13:30:55'),(2163,'default','payment_edited',716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"207615.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"207615.0000\"}}',NULL,'2023-11-27 13:31:43','2023-11-27 13:31:43'),(2164,'default','payment_edited',1199,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"109400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"109400.0000\"}}',NULL,'2023-11-27 13:31:43','2023-11-27 13:31:43'),(2165,'default','added',1345,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-27 13:32:28','2023-11-27 13:32:28'),(2166,'default','added',1346,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-11-27 13:34:23','2023-11-27 13:34:23'),(2167,'default','added',1347,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":30900}}',NULL,'2023-11-27 13:35:21','2023-11-27 13:35:21'),(2168,'default','added',1348,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-27 13:36:40','2023-11-27 13:36:40'),(2169,'default','added',1349,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8200}}',NULL,'2023-11-27 13:45:13','2023-11-27 13:45:13'),(2170,'default','added',1350,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6700}}',NULL,'2023-11-27 13:46:02','2023-11-27 13:46:02'),(2171,'default','added',1351,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2700}}',NULL,'2023-11-27 13:53:40','2023-11-27 13:53:40'),(2172,'default','added',1352,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3360}}',NULL,'2023-11-27 13:55:20','2023-11-27 13:55:20'),(2173,'default','added',1353,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-27 13:59:29','2023-11-27 13:59:29'),(2174,'default','added',1354,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":231450}}',NULL,'2023-11-27 14:07:49','2023-11-27 14:07:49'),(2175,'default','added',1355,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-27 14:18:43','2023-11-27 14:18:43'),(2176,'default','added',1356,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-27 14:19:03','2023-11-27 14:19:03'),(2177,'default','added',1357,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-27 14:23:33','2023-11-27 14:23:33'),(2178,'default','added',1358,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7800}}',NULL,'2023-11-27 14:27:25','2023-11-27 14:27:25'),(2179,'default','added',1359,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":320}}',NULL,'2023-11-27 14:32:08','2023-11-27 14:32:08'),(2180,'default','added',1360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-11-27 14:34:02','2023-11-27 14:34:02'),(2181,'default','added',1361,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-27 14:35:29','2023-11-27 14:35:29'),(2182,'default','added',1362,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-27 14:37:32','2023-11-27 14:37:32'),(2183,'default','added',1363,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-27 14:42:36','2023-11-27 14:42:36'),(2184,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 17:20:11','2023-11-27 17:20:11'),(2185,'default','payment_edited',871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"200000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"200000.0000\"}}',NULL,'2023-11-27 17:21:03','2023-11-27 17:21:03'),(2186,'default','added',1364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-27 17:23:07','2023-11-27 17:23:07'),(2187,'default','added',1365,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15080}}',NULL,'2023-11-27 17:25:05','2023-11-27 17:25:05'),(2188,'default','added',1366,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5450}}',NULL,'2023-11-27 17:26:12','2023-11-27 17:26:12'),(2189,'default','added',1367,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44533.199999999997089616954326629638671875}}',NULL,'2023-11-27 17:31:30','2023-11-27 17:31:30'),(2190,'default','added',1368,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-11-27 17:33:08','2023-11-27 17:33:08'),(2191,'default','added',1369,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250}}',NULL,'2023-11-27 17:43:44','2023-11-27 17:43:44'),(2192,'default','added',1370,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1950}}',NULL,'2023-11-27 17:44:04','2023-11-27 17:44:04'),(2193,'default','added',1371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-27 17:46:29','2023-11-27 17:46:29'),(2194,'default','added',1372,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9089.72999999999956344254314899444580078125}}',NULL,'2023-11-27 17:48:35','2023-11-27 17:48:35'),(2195,'default','added',1373,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-27 17:50:50','2023-11-27 17:50:50'),(2196,'default','added',1374,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":57740}}',NULL,'2023-11-27 17:52:35','2023-11-27 17:52:35'),(2197,'default','added',105,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 17:54:12','2023-11-27 17:54:12'),(2198,'default','added',1375,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":9504}}',NULL,'2023-11-27 17:54:58','2023-11-27 17:54:58'),(2199,'default','added',1376,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-27 17:55:44','2023-11-27 17:55:44'),(2200,'default','edited',1354,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":231450},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"231450.0000\"}}',NULL,'2023-11-27 17:57:37','2023-11-27 17:57:37'),(2201,'default','added',1377,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1260}}',NULL,'2023-11-27 18:33:53','2023-11-27 18:33:53'),(2202,'default','edited',1369,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5250.0000\"}}',NULL,'2023-11-27 18:37:26','2023-11-27 18:37:26'),(2203,'default','added',1378,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-27 18:42:14','2023-11-27 18:42:14'),(2204,'default','added',1379,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-27 18:44:14','2023-11-27 18:44:14'),(2205,'default','payment_edited',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"}}',NULL,'2023-11-27 18:45:35','2023-11-27 18:45:35'),(2206,'default','added',1380,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3310}}',NULL,'2023-11-27 19:08:55','2023-11-27 19:08:55'),(2207,'default','added',1381,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-27 19:09:10','2023-11-27 19:09:10'),(2208,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-27 19:13:29','2023-11-27 19:13:29'),(2209,'default','added',1382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-27 19:22:06','2023-11-27 19:22:06'),(2210,'default','added',1383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-27 19:26:13','2023-11-27 19:26:13'),(2211,'default','added',1384,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5830}}',NULL,'2023-11-27 19:32:07','2023-11-27 19:32:07'),(2212,'default','added',1385,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5052}}',NULL,'2023-11-27 19:38:31','2023-11-27 19:38:31'),(2213,'default','added',1386,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-27 19:38:48','2023-11-27 19:38:48'),(2214,'default','added',1387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-11-27 19:44:09','2023-11-27 19:44:09'),(2215,'default','added',1388,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3481}}',NULL,'2023-11-27 19:49:40','2023-11-27 19:49:40'),(2216,'default','added',1389,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-27 19:55:41','2023-11-27 19:55:41'),(2217,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 20:46:55','2023-11-27 20:46:55'),(2218,'default','payment_edited',1315,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-27 20:48:43','2023-11-27 20:48:43'),(2219,'default','payment_edited',1324,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"97618.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"97618.0000\"}}',NULL,'2023-11-27 20:48:43','2023-11-27 20:48:43'),(2220,'default','added',1390,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-27 20:51:09','2023-11-27 20:51:09'),(2221,'default','payment_edited',1049,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"36080.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"36080.0000\"}}',NULL,'2023-11-27 20:58:09','2023-11-27 20:58:09'),(2222,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 11:53:08','2023-11-28 11:53:08'),(2223,'default','added',1391,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-28 11:54:53','2023-11-28 11:54:53'),(2224,'default','added',1392,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-28 11:56:12','2023-11-28 11:56:12'),(2225,'default','added',1393,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-11-28 11:57:19','2023-11-28 11:57:19'),(2226,'default','added',1394,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2540}}',NULL,'2023-11-28 12:03:13','2023-11-28 12:03:13'),(2227,'default','added',1395,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-28 12:07:36','2023-11-28 12:07:36'),(2228,'default','added',1396,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7300}}',NULL,'2023-11-28 12:07:58','2023-11-28 12:07:58'),(2229,'default','payment_edited',925,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-28 12:08:58','2023-11-28 12:08:58'),(2230,'default','payment_edited',970,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-28 12:08:58','2023-11-28 12:08:58'),(2231,'default','payment_edited',843,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-11-28 12:09:27','2023-11-28 12:09:27'),(2232,'default','payment_edited',1039,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}',NULL,'2023-11-28 12:09:52','2023-11-28 12:09:52'),(2233,'default','payment_edited',1105,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3950.0000\"}}',NULL,'2023-11-28 12:09:52','2023-11-28 12:09:52'),(2234,'default','payment_edited',1334,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-28 12:10:40','2023-11-28 12:10:40'),(2235,'default','payment_edited',1347,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"30900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"30900.0000\"}}',NULL,'2023-11-28 12:10:40','2023-11-28 12:10:40'),(2236,'default','added',1397,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15420}}',NULL,'2023-11-28 12:12:47','2023-11-28 12:12:47'),(2237,'default','added',1398,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-11-28 12:13:07','2023-11-28 12:13:07'),(2238,'default','added',1399,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4660}}',NULL,'2023-11-28 12:13:54','2023-11-28 12:13:54'),(2239,'default','added',1400,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-28 12:14:26','2023-11-28 12:14:26'),(2240,'default','added',1401,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-11-28 12:15:04','2023-11-28 12:15:04'),(2241,'default','added',1402,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-28 12:15:32','2023-11-28 12:15:32'),(2242,'default','payment_edited',1135,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-28 12:18:07','2023-11-28 12:18:07'),(2243,'default','added',1403,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3850}}',NULL,'2023-11-28 12:21:47','2023-11-28 12:21:47'),(2244,'default','added',1404,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-28 12:24:30','2023-11-28 12:24:30'),(2245,'default','added',106,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 12:26:41','2023-11-28 12:26:41'),(2246,'default','added',1405,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":11800}}',NULL,'2023-11-28 12:27:22','2023-11-28 12:27:22'),(2247,'default','added',107,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 12:29:02','2023-11-28 12:29:02'),(2248,'default','added',1406,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-11-28 12:29:33','2023-11-28 12:29:33'),(2249,'default','added',1407,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1249.950000000000045474735088646411895751953125}}',NULL,'2023-11-28 12:32:28','2023-11-28 12:32:28'),(2250,'default','added',1408,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59180}}',NULL,'2023-11-28 12:34:53','2023-11-28 12:34:53'),(2251,'default','added',1409,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-28 12:45:46','2023-11-28 12:45:46'),(2252,'default','added',1410,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-28 13:21:18','2023-11-28 13:21:18'),(2253,'default','payment_edited',1265,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 13:23:03','2023-11-28 13:23:03'),(2254,'default','payment_edited',1065,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-28 13:50:16','2023-11-28 13:50:16'),(2255,'default','payment_edited',1151,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-28 13:50:16','2023-11-28 13:50:16'),(2256,'default','added',1411,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-28 13:58:57','2023-11-28 13:58:57'),(2257,'default','added',1412,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-28 14:03:22','2023-11-28 14:03:22'),(2258,'default','added',1413,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-28 14:15:04','2023-11-28 14:15:04'),(2259,'default','added',1414,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1050}}',NULL,'2023-11-28 14:21:03','2023-11-28 14:21:03'),(2260,'default','added',1415,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-28 14:28:06','2023-11-28 14:28:06'),(2261,'default','payment_edited',1121,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"44800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"44800.0000\"}}',NULL,'2023-11-28 14:35:00','2023-11-28 14:35:00'),(2262,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 16:08:21','2023-11-28 16:08:21'),(2263,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 16:57:30','2023-11-28 16:57:30'),(2264,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 18:30:10','2023-11-28 18:30:10'),(2265,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 18:38:41','2023-11-28 18:38:41'),(2266,'default','payment_edited',102,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 18:48:45','2023-11-28 18:48:45'),(2267,'default','added',1416,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11530}}',NULL,'2023-11-28 18:51:44','2023-11-28 18:51:44'),(2268,'default','payment_edited',1398,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-28 18:58:28','2023-11-28 18:58:28'),(2269,'default','added',1417,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9200}}',NULL,'2023-11-28 18:59:40','2023-11-28 18:59:40'),(2270,'default','added',1418,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10010}}',NULL,'2023-11-28 19:02:30','2023-11-28 19:02:30'),(2271,'default','added',1419,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2760}}',NULL,'2023-11-28 19:03:10','2023-11-28 19:03:10'),(2272,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 19:05:43','2023-11-28 19:05:43'),(2273,'default','added',1420,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-28 19:06:26','2023-11-28 19:06:26'),(2274,'default','added',1421,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10720}}',NULL,'2023-11-28 19:07:41','2023-11-28 19:07:41'),(2275,'default','added',1422,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3250}}',NULL,'2023-11-28 19:08:25','2023-11-28 19:08:25'),(2276,'default','added',1423,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-28 19:12:39','2023-11-28 19:12:39'),(2277,'default','added',1424,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-11-28 19:15:27','2023-11-28 19:15:27'),(2278,'default','added',108,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 19:17:40','2023-11-28 19:17:40'),(2279,'default','added',1425,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-28 19:19:47','2023-11-28 19:19:47'),(2280,'default','added',1426,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":58000}}',NULL,'2023-11-28 19:20:24','2023-11-28 19:20:24'),(2281,'default','added',1427,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-28 19:20:48','2023-11-28 19:20:48'),(2282,'default','added',1428,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-28 19:23:06','2023-11-28 19:23:06'),(2283,'default','added',1429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44229.800000000002910383045673370361328125}}',NULL,'2023-11-28 19:25:53','2023-11-28 19:25:53'),(2284,'default','payment_edited',1203,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-11-28 19:28:07','2023-11-28 19:28:07'),(2285,'default','added',1430,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1780}}',NULL,'2023-11-28 19:31:47','2023-11-28 19:31:47'),(2286,'default','added',1431,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-28 19:41:18','2023-11-28 19:41:18'),(2287,'default','added',1432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-28 19:50:26','2023-11-28 19:50:26'),(2288,'default','added',1433,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-28 19:55:27','2023-11-28 19:55:27'),(2289,'default','added',1434,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1670}}',NULL,'2023-11-28 20:02:11','2023-11-28 20:02:11'),(2290,'default','added',1435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-11-28 20:20:30','2023-11-28 20:20:30'),(2291,'default','added',1436,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-28 20:38:27','2023-11-28 20:38:27'),(2292,'default','added',1437,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-11-28 20:38:53','2023-11-28 20:38:53'),(2293,'default','payment_edited',1347,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"30900.0000\"}}',NULL,'2023-11-28 20:44:10','2023-11-28 20:44:10'),(2294,'default','added',1438,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-28 20:45:21','2023-11-28 20:45:21'),(2295,'default','added',1439,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-28 21:17:47','2023-11-28 21:17:47'),(2296,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-28 21:34:47','2023-11-28 21:34:47'),(2297,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-29 10:45:28','2023-11-29 10:45:28'),(2298,'default','added',1440,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3235}}',NULL,'2023-11-29 10:47:20','2023-11-29 10:47:20'),(2299,'default','added',1441,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-29 10:49:23','2023-11-29 10:49:23'),(2300,'default','added',109,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-29 10:51:10','2023-11-29 10:51:10'),(2301,'default','payment_edited',1257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-29 10:54:43','2023-11-29 10:54:43'),(2302,'default','payment_edited',1299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-11-29 10:54:43','2023-11-29 10:54:43'),(2303,'default','added',1442,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-11-29 10:59:33','2023-11-29 10:59:33'),(2304,'default','added',1443,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13440}}',NULL,'2023-11-29 11:02:06','2023-11-29 11:02:06'),(2305,'default','added',1444,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31425}}',NULL,'2023-11-29 11:08:58','2023-11-29 11:08:58'),(2306,'default','added',1445,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-29 11:17:30','2023-11-29 11:17:30'),(2307,'default','added',1446,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-29 11:19:31','2023-11-29 11:19:31'),(2308,'default','payment_edited',970,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-29 11:20:39','2023-11-29 11:20:39'),(2309,'default','payment_edited',978,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-29 11:20:39','2023-11-29 11:20:39'),(2310,'default','payment_edited',1031,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-29 11:20:39','2023-11-29 11:20:39'),(2311,'default','added',1447,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-29 11:21:30','2023-11-29 11:21:30'),(2312,'default','payment_edited',1105,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3950.0000\"}}',NULL,'2023-11-29 11:22:24','2023-11-29 11:22:24'),(2313,'default','payment_edited',1128,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8100.0000\"}}',NULL,'2023-11-29 11:22:24','2023-11-29 11:22:24'),(2314,'default','payment_edited',1235,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-11-29 11:25:48','2023-11-29 11:25:48'),(2315,'default','added',1448,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-29 11:27:44','2023-11-29 11:27:44'),(2316,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-29 11:31:27','2023-11-29 11:31:27'),(2317,'default','added',1449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":808360}}',NULL,'2023-11-29 11:33:49','2023-11-29 11:33:49'),(2318,'default','added',1450,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-11-29 11:34:36','2023-11-29 11:34:36'),(2319,'default','added',1451,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-11-29 11:37:46','2023-11-29 11:37:46'),(2320,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-29 11:44:21','2023-11-29 11:44:21'),(2321,'default','payment_edited',1449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"808360.0000\"}}',NULL,'2023-11-29 11:44:21','2023-11-29 11:44:21'),(2322,'default','added',1452,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-29 11:52:31','2023-11-29 11:52:31'),(2323,'default','added',1453,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-29 12:01:22','2023-11-29 12:01:22'),(2324,'default','added',1454,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-29 12:05:27','2023-11-29 12:05:27'),(2325,'default','added',1455,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-29 12:07:05','2023-11-29 12:07:05'),(2326,'default','added',1456,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-29 12:07:52','2023-11-29 12:07:52'),(2327,'default','added',1457,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-29 12:10:47','2023-11-29 12:10:47'),(2328,'default','added',1458,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1460}}',NULL,'2023-11-29 12:11:24','2023-11-29 12:11:24'),(2329,'default','added',1459,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":192000}}',NULL,'2023-11-29 12:28:56','2023-11-29 12:28:56'),(2330,'default','payment_edited',1375,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"9504.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"9504.0000\"}}',NULL,'2023-11-29 12:32:53','2023-11-29 12:32:53'),(2331,'default','payment_edited',1426,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"58000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"58000.0000\"}}',NULL,'2023-11-29 12:34:22','2023-11-29 12:34:22'),(2332,'default','edited',34,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-29 12:35:52','2023-11-29 12:35:52'),(2333,'default','added',1460,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-29 12:36:19','2023-11-29 12:36:19'),(2334,'default','added',1461,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7480}}',NULL,'2023-11-29 12:39:29','2023-11-29 12:39:29'),(2335,'default','added',1462,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":85550}}',NULL,'2023-11-29 12:43:47','2023-11-29 12:43:47'),(2336,'default','added',1463,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-11-29 12:47:57','2023-11-29 12:47:57'),(2337,'default','added',1464,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":67100}}',NULL,'2023-11-29 12:57:02','2023-11-29 12:57:02'),(2338,'default','added',1465,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7800}}',NULL,'2023-11-29 13:23:59','2023-11-29 13:23:59'),(2339,'default','added',1466,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-29 13:40:44','2023-11-29 13:40:44'),(2340,'default','added',1467,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-11-29 13:50:48','2023-11-29 13:50:48'),(2341,'default','added',1468,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2760}}',NULL,'2023-11-29 14:09:12','2023-11-29 14:09:12'),(2342,'default','payment_edited',1467,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-29 14:14:13','2023-11-29 14:14:13'),(2343,'default','added',1469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-29 14:15:35','2023-11-29 14:15:35'),(2344,'default','added',1470,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-11-29 14:20:08','2023-11-29 14:20:08'),(2345,'default','added',1471,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-11-29 14:25:42','2023-11-29 14:25:42'),(2346,'default','added',1472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-29 14:38:55','2023-11-29 14:38:55'),(2347,'default','added',1473,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-11-29 14:50:14','2023-11-29 14:50:14'),(2348,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-29 17:40:06','2023-11-29 17:40:06'),(2349,'default','added',1474,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-29 17:40:58','2023-11-29 17:40:58'),(2350,'default','added',1475,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1370}}',NULL,'2023-11-29 17:46:38','2023-11-29 17:46:38'),(2351,'default','added',1476,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1260}}',NULL,'2023-11-29 17:51:27','2023-11-29 17:51:27'),(2352,'default','payment_edited',1476,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1260.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1260.0000\"}}',NULL,'2023-11-29 17:52:19','2023-11-29 17:52:19'),(2353,'default','added',1477,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8850}}',NULL,'2023-11-29 17:55:24','2023-11-29 17:55:24'),(2354,'default','added',1478,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-29 17:56:12','2023-11-29 17:56:12'),(2355,'default','payment_edited',1031,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-29 17:58:07','2023-11-29 17:58:07'),(2356,'default','payment_edited',1067,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-29 17:58:07','2023-11-29 17:58:07'),(2357,'default','payment_edited',1090,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-29 17:58:07','2023-11-29 17:58:07'),(2358,'default','payment_edited',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"}}',NULL,'2023-11-29 17:59:29','2023-11-29 17:59:29'),(2359,'default','added',1479,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-29 18:06:09','2023-11-29 18:06:09'),(2360,'default','added',1480,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14060}}',NULL,'2023-11-29 18:07:36','2023-11-29 18:07:36'),(2361,'default','added',1481,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6900}}',NULL,'2023-11-29 18:08:43','2023-11-29 18:08:43'),(2362,'default','added',1482,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-11-29 18:09:58','2023-11-29 18:09:58'),(2363,'default','added',1483,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-29 18:10:42','2023-11-29 18:10:42'),(2364,'default','added',1484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3669.6999999999998181010596454143524169921875}}',NULL,'2023-11-29 18:12:47','2023-11-29 18:12:47'),(2365,'default','added',1485,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-29 18:13:58','2023-11-29 18:13:58'),(2366,'default','added',1486,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":47696}}',NULL,'2023-11-29 18:16:39','2023-11-29 18:16:39'),(2367,'default','added',1487,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-29 18:20:36','2023-11-29 18:20:36'),(2368,'default','added',1488,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-29 18:28:43','2023-11-29 18:28:43'),(2369,'default','added',1489,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-29 18:39:29','2023-11-29 18:39:29'),(2370,'default','added',1490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":30280}}',NULL,'2023-11-29 18:44:02','2023-11-29 18:44:02'),(2371,'default','payment_edited',1324,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"97618.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"97618.0000\"}}',NULL,'2023-11-29 18:45:07','2023-11-29 18:45:07'),(2372,'default','payment_edited',1354,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"231450.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"231450.0000\"}}',NULL,'2023-11-29 18:45:07','2023-11-29 18:45:07'),(2373,'default','payment_edited',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"70000.0000\"}}',NULL,'2023-11-29 19:05:33','2023-11-29 19:05:33'),(2374,'default','added',1491,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-29 19:07:13','2023-11-29 19:07:13'),(2375,'default','added',1492,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-29 19:18:34','2023-11-29 19:18:34'),(2376,'default','added',1493,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-29 19:20:07','2023-11-29 19:20:07'),(2377,'default','added',1494,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-29 19:21:24','2023-11-29 19:21:24'),(2378,'default','added',1495,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-29 19:22:12','2023-11-29 19:22:12'),(2379,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-29 19:34:17','2023-11-29 19:34:17'),(2380,'default','added',1496,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-29 19:41:48','2023-11-29 19:41:48'),(2381,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-29 19:44:02','2023-11-29 19:44:02'),(2382,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-30 10:26:43','2023-11-30 10:26:43'),(2383,'default','payment_edited',1473,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-11-30 10:41:16','2023-11-30 10:41:16'),(2384,'default','payment_edited',1128,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8100.0000\"}}',NULL,'2023-11-30 10:41:35','2023-11-30 10:41:35'),(2385,'default','payment_edited',1189,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3580.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3580.0000\"}}',NULL,'2023-11-30 10:41:35','2023-11-30 10:41:35'),(2386,'default','added',1497,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-30 10:42:14','2023-11-30 10:42:14'),(2387,'default','added',1498,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-30 10:42:59','2023-11-30 10:42:59'),(2388,'default','added',1499,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-30 10:46:32','2023-11-30 10:46:32'),(2389,'default','added',1500,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13660}}',NULL,'2023-11-30 10:54:38','2023-11-30 10:54:38'),(2390,'default','added',1501,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4300}}',NULL,'2023-11-30 10:57:27','2023-11-30 10:57:27'),(2391,'default','added',1502,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9801}}',NULL,'2023-11-30 11:00:14','2023-11-30 11:00:14'),(2392,'default','added',1503,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-30 11:02:57','2023-11-30 11:02:57'),(2393,'default','added',1504,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90219}}',NULL,'2023-11-30 11:06:22','2023-11-30 11:06:22'),(2394,'default','added',1505,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-11-30 11:12:10','2023-11-30 11:12:10'),(2395,'default','payment_edited',1134,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"164000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"164000.0000\"}}',NULL,'2023-11-30 11:34:41','2023-11-30 11:34:41'),(2396,'default','added',1506,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-30 11:44:19','2023-11-30 11:44:19'),(2397,'default','added',1507,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800}}',NULL,'2023-11-30 13:45:58','2023-11-30 13:45:58'),(2398,'default','added',1508,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-30 13:47:57','2023-11-30 13:47:57'),(2399,'default','added',1509,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14830}}',NULL,'2023-11-30 13:55:07','2023-11-30 13:55:07'),(2400,'default','added',1510,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2750}}',NULL,'2023-11-30 13:59:33','2023-11-30 13:59:33'),(2401,'default','added',1511,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-30 14:16:31','2023-11-30 14:16:31'),(2402,'default','added',1512,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":90780}}',NULL,'2023-11-30 14:24:41','2023-11-30 14:24:41'),(2403,'default','added',1513,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-11-30 14:26:09','2023-11-30 14:26:09'),(2404,'default','added',1514,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2023-11-30 14:30:16','2023-11-30 14:30:16'),(2405,'default','edited',1514,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"}}',NULL,'2023-11-30 14:32:18','2023-11-30 14:32:18'),(2406,'default','added',1515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5960}}',NULL,'2023-11-30 14:42:16','2023-11-30 14:42:16'),(2407,'default','added',1516,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6000}}',NULL,'2023-11-30 14:43:10','2023-11-30 14:43:10'),(2408,'default','added',1517,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-30 14:45:36','2023-11-30 14:45:36'),(2409,'default','added',1518,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-30 14:47:10','2023-11-30 14:47:10'),(2410,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-30 17:04:00','2023-11-30 17:04:00'),(2411,'default','added',1519,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-30 17:04:15','2023-11-30 17:04:15'),(2412,'default','added',1520,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-30 17:13:24','2023-11-30 17:13:24'),(2413,'default','added',1521,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6280}}',NULL,'2023-11-30 17:14:56','2023-11-30 17:14:56'),(2414,'default','added',110,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-30 17:15:30','2023-11-30 17:15:30'),(2415,'default','added',1522,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2700}}',NULL,'2023-11-30 17:15:44','2023-11-30 17:15:44'),(2416,'default','added',1523,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10690}}',NULL,'2023-11-30 17:17:09','2023-11-30 17:17:09'),(2417,'default','added',1524,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-30 17:17:25','2023-11-30 17:17:25'),(2418,'default','added',1525,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29950}}',NULL,'2023-11-30 17:21:54','2023-11-30 17:21:54'),(2419,'default','added',1526,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-30 17:27:35','2023-11-30 17:27:35'),(2420,'default','added',1527,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11050}}',NULL,'2023-11-30 17:41:43','2023-11-30 17:41:43'),(2421,'default','added',1528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-11-30 17:43:18','2023-11-30 17:43:18'),(2422,'default','added',1529,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-30 17:48:09','2023-11-30 17:48:09'),(2423,'default','added',1530,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-30 17:54:37','2023-11-30 17:54:37'),(2424,'default','added',1531,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1300}}',NULL,'2023-11-30 18:06:13','2023-11-30 18:06:13'),(2425,'default','added',1532,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17598}}',NULL,'2023-11-30 18:12:41','2023-11-30 18:12:41'),(2426,'default','payment_edited',1449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"}}',NULL,'2023-11-30 18:13:52','2023-11-30 18:13:52'),(2427,'default','payment_edited',1531,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-11-30 18:15:50','2023-11-30 18:15:50'),(2428,'default','added',1533,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":970}}',NULL,'2023-11-30 18:46:57','2023-11-30 18:46:57'),(2429,'default','added',1534,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-30 18:48:45','2023-11-30 18:48:45'),(2430,'default','added',1535,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-30 18:50:48','2023-11-30 18:50:48'),(2431,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-30 18:51:02','2023-11-30 18:51:02'),(2432,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 10:20:29','2023-12-02 10:20:29'),(2433,'default','added',1536,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":107590}}',NULL,'2023-12-02 10:24:23','2023-12-02 10:24:23'),(2434,'default','added',1537,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4550}}',NULL,'2023-12-02 10:25:41','2023-12-02 10:25:41'),(2435,'default','added',1538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2150}}',NULL,'2023-12-02 10:39:37','2023-12-02 10:39:37'),(2436,'default','added',1539,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-12-02 10:41:15','2023-12-02 10:41:15'),(2437,'default','added',1540,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9500}}',NULL,'2023-12-02 10:52:20','2023-12-02 10:52:20'),(2438,'default','added',1541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6880}}',NULL,'2023-12-02 10:52:58','2023-12-02 10:52:58'),(2439,'default','added',1542,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8480}}',NULL,'2023-12-02 10:53:46','2023-12-02 10:53:46'),(2440,'default','added',1543,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5800}}',NULL,'2023-12-02 10:54:26','2023-12-02 10:54:26'),(2441,'default','added',1544,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9960}}',NULL,'2023-12-02 10:55:23','2023-12-02 10:55:23'),(2442,'default','added',1545,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-02 11:07:07','2023-12-02 11:07:07'),(2443,'default','added',1546,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7000}}',NULL,'2023-12-02 11:10:28','2023-12-02 11:10:28'),(2444,'default','added',1547,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-02 11:12:14','2023-12-02 11:12:14'),(2445,'default','payment_edited',1090,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-02 11:14:07','2023-12-02 11:14:07'),(2446,'default','payment_edited',1133,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-02 11:14:07','2023-12-02 11:14:07'),(2447,'default','payment_edited',1187,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-02 11:14:07','2023-12-02 11:14:07'),(2448,'default','added',1548,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-02 11:15:09','2023-12-02 11:15:09'),(2449,'default','edited',1548,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-02 11:16:02','2023-12-02 11:16:02'),(2450,'default','added',1549,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3080}}',NULL,'2023-12-02 11:17:34','2023-12-02 11:17:34'),(2451,'default','added',1550,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-02 11:18:41','2023-12-02 11:18:41'),(2452,'default','payment_edited',1191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4500.0000\"}}',NULL,'2023-12-02 11:19:31','2023-12-02 11:19:31'),(2453,'default','payment_edited',1186,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-02 11:19:52','2023-12-02 11:19:52'),(2454,'default','payment_edited',1189,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3580.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3580.0000\"}}',NULL,'2023-12-02 11:20:09','2023-12-02 11:20:09'),(2455,'default','payment_edited',1225,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8930.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8930.0000\"}}',NULL,'2023-12-02 11:20:09','2023-12-02 11:20:09'),(2456,'default','added',1551,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-02 11:20:53','2023-12-02 11:20:53'),(2457,'default','added',1552,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1800}}',NULL,'2023-12-02 11:33:06','2023-12-02 11:33:06'),(2458,'default','added',1553,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-12-02 11:33:20','2023-12-02 11:33:20'),(2459,'default','added',1554,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-02 11:35:17','2023-12-02 11:35:17'),(2460,'default','added',111,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 11:35:48','2023-12-02 11:35:48'),(2461,'default','added',1555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-12-02 11:36:34','2023-12-02 11:36:34'),(2462,'default','added',1556,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6645}}',NULL,'2023-12-02 11:40:00','2023-12-02 11:40:00'),(2463,'default','added',112,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 11:44:16','2023-12-02 11:44:16'),(2464,'default','added',1557,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":7650}}',NULL,'2023-12-02 11:44:46','2023-12-02 11:44:46'),(2465,'default','added',1558,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":67850}}',NULL,'2023-12-02 11:46:04','2023-12-02 11:46:04'),(2466,'default','added',1559,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-02 11:55:11','2023-12-02 11:55:11'),(2467,'default','payment_edited',43,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 11:57:19','2023-12-02 11:57:19'),(2468,'default','added',1560,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100}}',NULL,'2023-12-02 12:00:14','2023-12-02 12:00:14'),(2469,'default','added',1561,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-02 12:00:43','2023-12-02 12:00:43'),(2470,'default','added',1562,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2700}}',NULL,'2023-12-02 12:02:07','2023-12-02 12:02:07'),(2471,'default','added',1563,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-02 12:04:26','2023-12-02 12:04:26'),(2472,'default','added',1564,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-02 12:06:12','2023-12-02 12:06:12'),(2473,'default','added',1565,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-12-02 12:13:30','2023-12-02 12:13:30'),(2474,'default','added',1566,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16450}}',NULL,'2023-12-02 12:15:45','2023-12-02 12:15:45'),(2475,'default','added',1567,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-12-02 12:17:17','2023-12-02 12:17:17'),(2476,'default','added',1568,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1900}}',NULL,'2023-12-02 12:20:17','2023-12-02 12:20:17'),(2477,'default','added',1569,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3680}}',NULL,'2023-12-02 12:51:17','2023-12-02 12:51:17'),(2478,'default','added',1570,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-12-02 13:17:14','2023-12-02 13:17:14'),(2479,'default','added',1571,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2730}}',NULL,'2023-12-02 13:17:57','2023-12-02 13:17:57'),(2480,'default','added',1572,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-12-02 13:28:48','2023-12-02 13:28:48'),(2481,'default','added',1573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11800}}',NULL,'2023-12-02 13:31:17','2023-12-02 13:31:17'),(2482,'default','added',1574,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-02 13:35:42','2023-12-02 13:35:42'),(2483,'default','added',1575,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-02 13:36:36','2023-12-02 13:36:36'),(2484,'default','added',1576,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11500}}',NULL,'2023-12-02 13:47:25','2023-12-02 13:47:25'),(2485,'default','added',1577,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-02 13:57:45','2023-12-02 13:57:45'),(2486,'default','added',1578,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-12-02 13:58:29','2023-12-02 13:58:29'),(2487,'default','added',1579,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250}}',NULL,'2023-12-02 14:06:36','2023-12-02 14:06:36'),(2488,'default','payment_edited',1449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"}}',NULL,'2023-12-02 14:08:02','2023-12-02 14:08:02'),(2489,'default','added',1580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":88530}}',NULL,'2023-12-02 14:26:08','2023-12-02 14:26:08'),(2490,'default','added',113,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 14:27:13','2023-12-02 14:27:13'),(2491,'default','added',1581,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":11800}}',NULL,'2023-12-02 14:27:47','2023-12-02 14:27:47'),(2492,'default','added',1582,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-02 14:29:28','2023-12-02 14:29:28'),(2493,'default','added',1583,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-12-02 14:31:20','2023-12-02 14:31:20'),(2494,'default','added',1584,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2023-12-02 14:34:44','2023-12-02 14:34:44'),(2495,'default','added',1585,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-02 14:35:45','2023-12-02 14:35:45'),(2496,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 17:06:20','2023-12-02 17:06:20'),(2497,'default','payment_edited',1024,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"142500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"142500.0000\"}}',NULL,'2023-12-02 17:08:38','2023-12-02 17:08:38'),(2498,'default','payment_edited',1459,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"192000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"192000.0000\"}}',NULL,'2023-12-02 17:08:38','2023-12-02 17:08:38'),(2499,'default','payment_edited',41,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 17:09:24','2023-12-02 17:09:24'),(2500,'default','added',1586,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-02 17:12:34','2023-12-02 17:12:34'),(2501,'default','added',1587,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-02 17:14:18','2023-12-02 17:14:18'),(2502,'default','added',1588,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-02 17:23:49','2023-12-02 17:23:49'),(2503,'default','added',1589,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-12-02 17:29:39','2023-12-02 17:29:39'),(2504,'default','added',1590,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11380}}',NULL,'2023-12-02 17:32:42','2023-12-02 17:32:42'),(2505,'default','added',1591,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3850}}',NULL,'2023-12-02 17:33:36','2023-12-02 17:33:36'),(2506,'default','added',1592,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15300}}',NULL,'2023-12-02 17:39:20','2023-12-02 17:39:20'),(2507,'default','added',1593,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5300}}',NULL,'2023-12-02 17:40:08','2023-12-02 17:40:08'),(2508,'default','added',1594,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14700}}',NULL,'2023-12-02 17:41:43','2023-12-02 17:41:43'),(2509,'default','payment_edited',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"}}',NULL,'2023-12-02 17:43:04','2023-12-02 17:43:04'),(2510,'default','payment_edited',1146,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"42500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"42500.0000\"}}',NULL,'2023-12-02 17:47:02','2023-12-02 17:47:02'),(2511,'default','added',1595,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":202090}}',NULL,'2023-12-02 17:48:44','2023-12-02 17:48:44'),(2512,'default','added',1596,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-02 17:49:12','2023-12-02 17:49:12'),(2513,'default','added',1597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":58014}}',NULL,'2023-12-02 17:52:57','2023-12-02 17:52:57'),(2514,'default','added',1598,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-02 18:04:20','2023-12-02 18:04:20'),(2515,'default','added',1599,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2730}}',NULL,'2023-12-02 18:09:47','2023-12-02 18:09:47'),(2516,'default','added',1600,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-02 18:13:09','2023-12-02 18:13:09'),(2517,'default','added',1601,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":30250}}',NULL,'2023-12-02 18:18:33','2023-12-02 18:18:33'),(2518,'default','added',1602,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5950}}',NULL,'2023-12-02 18:31:09','2023-12-02 18:31:09'),(2519,'default','added',1603,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-02 18:37:44','2023-12-02 18:37:44'),(2520,'default','added',1604,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-12-02 18:38:26','2023-12-02 18:38:26'),(2521,'default','edited',1597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":58002},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"58014.0000\"}}',NULL,'2023-12-02 18:45:18','2023-12-02 18:45:18'),(2522,'default','payment_edited',1597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"58002.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"58002.0000\"}}',NULL,'2023-12-02 18:46:22','2023-12-02 18:46:22'),(2523,'default','added',1605,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-12-02 19:13:59','2023-12-02 19:13:59'),(2524,'default','added',1606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2670}}',NULL,'2023-12-02 19:23:35','2023-12-02 19:23:35'),(2525,'default','added',1607,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-12-02 19:24:30','2023-12-02 19:24:30'),(2526,'default','added',1608,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-02 19:27:13','2023-12-02 19:27:13'),(2527,'default','added',1609,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10640}}',NULL,'2023-12-02 19:38:52','2023-12-02 19:38:52'),(2528,'default','added',1610,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-12-02 19:39:17','2023-12-02 19:39:17'),(2529,'default','payment_edited',1557,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7650.0000\"}}',NULL,'2023-12-02 19:44:11','2023-12-02 19:44:11'),(2530,'default','edited',111,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 19:44:38','2023-12-02 19:44:38'),(2531,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 19:48:16','2023-12-02 19:48:16'),(2532,'default','payment_edited',1354,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"231450.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"231450.0000\"}}',NULL,'2023-12-02 19:53:55','2023-12-02 19:53:55'),(2533,'default','payment_edited',1374,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"57740.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"57740.0000\"}}',NULL,'2023-12-02 19:53:55','2023-12-02 19:53:55'),(2534,'default','added',1611,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2470}}',NULL,'2023-12-02 20:15:05','2023-12-02 20:15:05'),(2535,'default','added',1612,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-02 20:17:38','2023-12-02 20:17:38'),(2536,'default','edited',113,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 20:23:21','2023-12-02 20:23:21'),(2537,'default','added',1613,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-02 20:23:56','2023-12-02 20:23:56'),(2538,'default','added',1614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":54060}}',NULL,'2023-12-02 20:26:03','2023-12-02 20:26:03'),(2539,'default','payment_edited',1492,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-12-02 20:28:29','2023-12-02 20:28:29'),(2540,'default','payment_edited',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"}}',NULL,'2023-12-02 20:30:18','2023-12-02 20:30:18'),(2541,'default','added',1615,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-02 20:32:08','2023-12-02 20:32:08'),(2542,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-02 20:35:36','2023-12-02 20:35:36'),(2543,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 10:51:20','2023-12-03 10:51:20'),(2544,'default','edited',109,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 10:53:29','2023-12-03 10:53:29'),(2545,'default','payment_edited',1449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"}}',NULL,'2023-12-03 10:58:32','2023-12-03 10:58:32'),(2546,'default','added',1616,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-03 11:00:05','2023-12-03 11:00:05'),(2547,'default','added',1617,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":22500}}',NULL,'2023-12-03 11:06:43','2023-12-03 11:06:43'),(2548,'default','payment_edited',1581,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"}}',NULL,'2023-12-03 11:11:22','2023-12-03 11:11:22'),(2549,'default','payment_edited',1522,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2700.0000\"}}',NULL,'2023-12-03 11:29:34','2023-12-03 11:29:34'),(2550,'default','added',1618,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-12-03 11:29:52','2023-12-03 11:29:52'),(2551,'default','added',1619,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9460}}',NULL,'2023-12-03 11:38:12','2023-12-03 11:38:12'),(2552,'default','added',1620,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-03 11:40:55','2023-12-03 11:40:55'),(2553,'default','added',1621,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-03 11:42:57','2023-12-03 11:42:57'),(2554,'default','added',1622,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72754.5}}',NULL,'2023-12-03 11:45:22','2023-12-03 11:45:22'),(2555,'default','added',1623,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5900}}',NULL,'2023-12-03 11:46:19','2023-12-03 11:46:19'),(2556,'default','added',1624,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9200}}',NULL,'2023-12-03 11:48:27','2023-12-03 11:48:27'),(2557,'default','added',114,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 11:49:29','2023-12-03 11:49:29'),(2558,'default','added',1625,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":7350}}',NULL,'2023-12-03 11:50:26','2023-12-03 11:50:26'),(2559,'default','added',115,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 11:52:15','2023-12-03 11:52:15'),(2560,'default','added',1626,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":17700}}',NULL,'2023-12-03 11:53:07','2023-12-03 11:53:07'),(2561,'default','added',1627,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-03 12:00:04','2023-12-03 12:00:04'),(2562,'default','added',1628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-03 12:12:39','2023-12-03 12:12:39'),(2563,'default','added',1629,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-03 12:21:15','2023-12-03 12:21:15'),(2564,'default','added',1630,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-03 12:24:50','2023-12-03 12:24:50'),(2565,'default','added',1631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-03 12:28:25','2023-12-03 12:28:25'),(2566,'default','edited',1631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"}}',NULL,'2023-12-03 12:29:36','2023-12-03 12:29:36'),(2567,'default','added',1632,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-03 12:31:11','2023-12-03 12:31:11'),(2568,'default','added',1633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-12-03 12:35:31','2023-12-03 12:35:31'),(2569,'default','added',1634,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1670}}',NULL,'2023-12-03 12:41:36','2023-12-03 12:41:36'),(2570,'default','added',1635,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-03 12:43:03','2023-12-03 12:43:03'),(2571,'default','added',1636,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6230}}',NULL,'2023-12-03 13:18:43','2023-12-03 13:18:43'),(2572,'default','added',1637,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5450}}',NULL,'2023-12-03 13:19:18','2023-12-03 13:19:18'),(2573,'default','added',1638,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-03 13:43:59','2023-12-03 13:43:59'),(2574,'default','added',1639,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-12-03 13:49:36','2023-12-03 13:49:36'),(2575,'default','payment_edited',1085,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-12-03 13:57:12','2023-12-03 13:57:12'),(2576,'default','added',1640,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-03 13:57:43','2023-12-03 13:57:43'),(2577,'default','added',1641,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-12-03 14:01:14','2023-12-03 14:01:14'),(2578,'default','added',1642,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-03 14:02:22','2023-12-03 14:02:22'),(2579,'default','added',1643,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1530}}',NULL,'2023-12-03 14:03:52','2023-12-03 14:03:52'),(2580,'default','added',1644,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-03 14:05:22','2023-12-03 14:05:22'),(2581,'default','payment_edited',1225,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8930.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8930.0000\"}}',NULL,'2023-12-03 14:26:30','2023-12-03 14:26:30'),(2582,'default','payment_edited',1304,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10700.0000\"}}',NULL,'2023-12-03 14:26:30','2023-12-03 14:26:30'),(2583,'default','added',1645,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1950}}',NULL,'2023-12-03 14:35:48','2023-12-03 14:35:48'),(2584,'default','added',1646,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-03 14:38:57','2023-12-03 14:38:57'),(2585,'default','added',1647,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12000}}',NULL,'2023-12-03 14:40:46','2023-12-03 14:40:46'),(2586,'default','payment_edited',1187,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-03 14:41:12','2023-12-03 14:41:12'),(2587,'default','payment_edited',1221,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-03 14:41:12','2023-12-03 14:41:12'),(2588,'default','added',1648,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-03 14:41:50','2023-12-03 14:41:50'),(2589,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 17:33:41','2023-12-03 17:33:41'),(2590,'default','added',1649,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-03 17:38:20','2023-12-03 17:38:20'),(2591,'default','payment_edited',1591,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3850.0000\"}}',NULL,'2023-12-03 17:44:30','2023-12-03 17:44:30'),(2592,'default','added',1650,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2160}}',NULL,'2023-12-03 17:49:43','2023-12-03 17:49:43'),(2593,'default','added',1651,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-03 17:50:56','2023-12-03 17:50:56'),(2594,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 17:53:30','2023-12-03 17:53:30'),(2595,'default','added',1652,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-03 18:03:46','2023-12-03 18:03:46'),(2596,'default','added',1653,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2670}}',NULL,'2023-12-03 18:06:10','2023-12-03 18:06:10'),(2597,'default','added',1654,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-03 18:12:06','2023-12-03 18:12:06'),(2598,'default','added',1655,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8940}}',NULL,'2023-12-03 18:12:50','2023-12-03 18:12:50'),(2599,'default','added',1656,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-03 18:19:38','2023-12-03 18:19:38'),(2600,'default','payment_edited',1449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"808360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"808360.0000\"}}',NULL,'2023-12-03 18:42:21','2023-12-03 18:42:21'),(2601,'default','payment_edited',1595,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"202090.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"202090.0000\"}}',NULL,'2023-12-03 18:42:21','2023-12-03 18:42:21'),(2602,'default','added',1657,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13750}}',NULL,'2023-12-03 19:07:29','2023-12-03 19:07:29'),(2603,'default','payment_edited',1411,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-12-03 19:08:45','2023-12-03 19:08:45'),(2604,'default','added',1658,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-12-03 19:09:24','2023-12-03 19:09:24'),(2605,'default','added',1659,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2650}}',NULL,'2023-12-03 19:09:59','2023-12-03 19:09:59'),(2606,'default','added',1660,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7730}}',NULL,'2023-12-03 19:10:40','2023-12-03 19:10:40'),(2607,'default','added',1661,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5130}}',NULL,'2023-12-03 19:11:23','2023-12-03 19:11:23'),(2608,'default','added',1662,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-03 19:12:03','2023-12-03 19:12:03'),(2609,'default','added',1663,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-03 19:14:00','2023-12-03 19:14:00'),(2610,'default','added',1664,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3360}}',NULL,'2023-12-03 19:16:22','2023-12-03 19:16:22'),(2611,'default','added',116,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 19:17:41','2023-12-03 19:17:41'),(2612,'default','added',1665,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15900}}',NULL,'2023-12-03 19:18:09','2023-12-03 19:18:09'),(2613,'default','added',1666,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5301}}',NULL,'2023-12-03 19:19:29','2023-12-03 19:19:29'),(2614,'default','added',1667,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-12-03 19:19:50','2023-12-03 19:19:50'),(2615,'default','added',1668,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35638.6800000000002910383045673370361328125}}',NULL,'2023-12-03 19:22:53','2023-12-03 19:22:53'),(2616,'default','added',1669,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-03 19:25:29','2023-12-03 19:25:29'),(2617,'default','added',1670,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-12-03 19:28:37','2023-12-03 19:28:37'),(2618,'default','added',1671,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2980}}',NULL,'2023-12-03 19:31:30','2023-12-03 19:31:30'),(2619,'default','added',1672,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-03 19:49:06','2023-12-03 19:49:06'),(2620,'default','added',1673,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-03 19:55:14','2023-12-03 19:55:14'),(2621,'default','added',1674,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-03 20:00:30','2023-12-03 20:00:30'),(2622,'default','payment_edited',1670,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-12-03 20:04:28','2023-12-03 20:04:28'),(2623,'default','added',1675,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-03 20:15:03','2023-12-03 20:15:03'),(2624,'default','added',1676,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-03 20:16:53','2023-12-03 20:16:53'),(2625,'default','added',1677,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-03 20:25:08','2023-12-03 20:25:08'),(2626,'default','added',1678,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":275635}}',NULL,'2023-12-03 20:27:20','2023-12-03 20:27:20'),(2627,'default','added',1679,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-03 20:27:57','2023-12-03 20:27:57'),(2628,'default','added',1680,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3380}}',NULL,'2023-12-03 20:35:41','2023-12-03 20:35:41'),(2629,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-03 20:39:17','2023-12-03 20:39:17'),(2630,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-04 12:40:58','2023-12-04 12:40:58'),(2631,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-04 12:46:05','2023-12-04 12:46:05'),(2632,'default','payment_edited',1221,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-04 12:47:00','2023-12-04 12:47:00'),(2633,'default','payment_edited',1261,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-04 12:47:00','2023-12-04 12:47:00'),(2634,'default','payment_edited',1304,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10700.0000\"}}',NULL,'2023-12-04 12:47:18','2023-12-04 12:47:18'),(2635,'default','payment_edited',1351,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2700.0000\"}}',NULL,'2023-12-04 12:47:18','2023-12-04 12:47:18'),(2636,'default','payment_edited',1403,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3850.0000\"}}',NULL,'2023-12-04 12:47:18','2023-12-04 12:47:18'),(2637,'default','payment_edited',1555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-04 12:47:34','2023-12-04 12:47:34'),(2638,'default','added',1681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1300}}',NULL,'2023-12-04 13:21:54','2023-12-04 13:21:54'),(2639,'default','payment_edited',1681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-12-04 13:22:40','2023-12-04 13:22:40'),(2640,'default','added',1682,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-04 13:28:40','2023-12-04 13:28:40'),(2641,'default','added',1683,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10230}}',NULL,'2023-12-04 13:30:10','2023-12-04 13:30:10'),(2642,'default','added',1684,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4100}}',NULL,'2023-12-04 13:30:47','2023-12-04 13:30:47'),(2643,'default','added',1685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-04 13:31:22','2023-12-04 13:31:22'),(2644,'default','added',1686,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3030}}',NULL,'2023-12-04 13:33:10','2023-12-04 13:33:10'),(2645,'default','added',1687,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3980}}',NULL,'2023-12-04 13:36:16','2023-12-04 13:36:16'),(2646,'default','added',1688,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1600}}',NULL,'2023-12-04 13:40:48','2023-12-04 13:40:48'),(2647,'default','added',1689,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5160}}',NULL,'2023-12-04 13:42:07','2023-12-04 13:42:07'),(2648,'default','added',1690,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6150}}',NULL,'2023-12-04 13:43:06','2023-12-04 13:43:06'),(2649,'default','added',1691,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8850}}',NULL,'2023-12-04 13:43:57','2023-12-04 13:43:57'),(2650,'default','added',1692,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5900}}',NULL,'2023-12-04 13:48:08','2023-12-04 13:48:08'),(2651,'default','added',1693,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6880}}',NULL,'2023-12-04 13:50:33','2023-12-04 13:50:33'),(2652,'default','payment_edited',1678,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"275635.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"275635.0000\"}}',NULL,'2023-12-04 13:57:29','2023-12-04 13:57:29'),(2653,'default','added',1694,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-12-04 14:02:20','2023-12-04 14:02:20'),(2654,'default','added',1695,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":85563}}',NULL,'2023-12-04 14:13:04','2023-12-04 14:13:04'),(2655,'default','added',1696,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":35280}}',NULL,'2023-12-04 14:14:18','2023-12-04 14:14:18'),(2656,'default','added',1697,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27192.5}}',NULL,'2023-12-04 14:16:23','2023-12-04 14:16:23'),(2657,'default','added',1698,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-12-04 14:19:27','2023-12-04 14:19:27'),(2658,'default','added',1699,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":76725}}',NULL,'2023-12-04 14:22:31','2023-12-04 14:22:31'),(2659,'default','added',1700,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4600}}',NULL,'2023-12-04 14:27:19','2023-12-04 14:27:19'),(2660,'default','added',1701,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":48154}}',NULL,'2023-12-04 14:28:10','2023-12-04 14:28:10'),(2661,'default','added',1702,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1670}}',NULL,'2023-12-04 14:30:40','2023-12-04 14:30:40'),(2662,'default','added',1703,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-04 14:43:33','2023-12-04 14:43:33'),(2663,'default','added',1704,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-04 14:47:07','2023-12-04 14:47:07'),(2664,'default','added',1705,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":63825}}',NULL,'2023-12-04 14:51:28','2023-12-04 14:51:28'),(2665,'default','added',1706,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-04 14:52:22','2023-12-04 14:52:22'),(2666,'default','added',1707,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-04 14:56:46','2023-12-04 14:56:46'),(2667,'default','added',1708,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-04 14:57:53','2023-12-04 14:57:53'),(2668,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-04 15:03:32','2023-12-04 15:03:32'),(2669,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-04 17:28:38','2023-12-04 17:28:38'),(2670,'default','payment_edited',1557,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7650.0000\"}}',NULL,'2023-12-04 17:33:38','2023-12-04 17:33:38'),(2671,'default','added',1709,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-12-04 17:45:10','2023-12-04 17:45:10'),(2672,'default','added',1710,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1520}}',NULL,'2023-12-04 17:45:45','2023-12-04 17:45:45'),(2673,'default','added',1711,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14050}}',NULL,'2023-12-04 17:58:57','2023-12-04 17:58:57'),(2674,'default','added',1712,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2023-12-04 17:59:44','2023-12-04 17:59:44'),(2675,'default','added',1713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4950}}',NULL,'2023-12-04 18:00:18','2023-12-04 18:00:18'),(2676,'default','edited',1713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4950.0000\"}}',NULL,'2023-12-04 18:04:11','2023-12-04 18:04:11'),(2677,'default','added',1714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8930}}',NULL,'2023-12-04 18:11:20','2023-12-04 18:11:20'),(2678,'default','added',1715,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-04 18:11:42','2023-12-04 18:11:42'),(2679,'default','added',1716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-12-04 18:14:44','2023-12-04 18:14:44'),(2680,'default','added',1717,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8030}}',NULL,'2023-12-04 18:23:11','2023-12-04 18:23:11'),(2681,'default','payment_edited',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"}}',NULL,'2023-12-04 18:35:06','2023-12-04 18:35:06'),(2682,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-04 19:06:36','2023-12-04 19:06:36'),(2683,'default','added',1718,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-12-04 19:11:26','2023-12-04 19:11:26'),(2684,'default','added',1719,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-12-04 19:13:12','2023-12-04 19:13:12'),(2685,'default','added',1720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6480}}',NULL,'2023-12-04 19:19:35','2023-12-04 19:19:35'),(2686,'default','added',1721,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-04 19:25:22','2023-12-04 19:25:22'),(2687,'default','added',1722,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8220}}',NULL,'2023-12-04 19:28:36','2023-12-04 19:28:36'),(2688,'default','added',1723,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-12-04 19:30:25','2023-12-04 19:30:25'),(2689,'default','added',1724,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34640.4000000000014551915228366851806640625}}',NULL,'2023-12-04 19:33:32','2023-12-04 19:33:32'),(2690,'default','added',1725,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-12-04 19:40:23','2023-12-04 19:40:23'),(2691,'default','added',1726,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-04 19:44:44','2023-12-04 19:44:44'),(2692,'default','added',1727,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2500}}',NULL,'2023-12-04 19:47:02','2023-12-04 19:47:02'),(2693,'default','payment_edited',1727,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-12-04 19:47:23','2023-12-04 19:47:23'),(2694,'default','added',1728,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-04 19:50:05','2023-12-04 19:50:05'),(2695,'default','added',1729,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1430}}',NULL,'2023-12-04 19:54:17','2023-12-04 19:54:17'),(2696,'default','added',1730,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-04 20:00:59','2023-12-04 20:00:59'),(2697,'default','added',1731,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-04 20:06:06','2023-12-04 20:06:06'),(2698,'default','payment_edited',976,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-12-04 20:24:04','2023-12-04 20:24:04'),(2699,'default','added',1732,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-04 20:49:37','2023-12-04 20:49:37'),(2700,'default','added',1733,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-04 20:50:40','2023-12-04 20:50:40'),(2701,'default','added',1734,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29880}}',NULL,'2023-12-04 21:08:14','2023-12-04 21:08:14'),(2702,'default','added',1735,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-04 21:15:08','2023-12-04 21:15:08'),(2703,'default','added',1736,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-04 21:18:43','2023-12-04 21:18:43'),(2704,'default','added',1737,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-04 21:19:08','2023-12-04 21:19:08'),(2705,'default','added',117,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-04 21:20:32','2023-12-04 21:20:32'),(2706,'default','added',1738,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-04 21:22:21','2023-12-04 21:22:21'),(2707,'default','added',1739,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7131}}',NULL,'2023-12-04 21:24:30','2023-12-04 21:24:30'),(2708,'default','added',1740,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-04 21:29:50','2023-12-04 21:29:50'),(2709,'default','added',1741,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-12-04 21:40:12','2023-12-04 21:40:12'),(2710,'default','added',1742,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-12-04 21:41:25','2023-12-04 21:41:25'),(2711,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-04 21:41:50','2023-12-04 21:41:50'),(2712,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 09:32:15','2023-12-05 09:32:15'),(2713,'default','added',1743,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11700}}',NULL,'2023-12-05 09:42:38','2023-12-05 09:42:38'),(2714,'default','payment_edited',1725,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-12-05 09:55:11','2023-12-05 09:55:11'),(2715,'default','payment_edited',1191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4500.0000\"}}',NULL,'2023-12-05 09:56:08','2023-12-05 09:56:08'),(2716,'default','payment_edited',1286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-05 09:56:27','2023-12-05 09:56:27'),(2717,'default','payment_edited',1261,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-05 09:56:46','2023-12-05 09:56:46'),(2718,'default','payment_edited',1291,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-05 09:56:46','2023-12-05 09:56:46'),(2719,'default','payment_edited',1335,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-05 09:56:46','2023-12-05 09:56:46'),(2720,'default','payment_edited',1403,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3850.0000\"}}',NULL,'2023-12-05 09:57:21','2023-12-05 09:57:21'),(2721,'default','payment_edited',1465,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7800.0000\"}}',NULL,'2023-12-05 09:57:21','2023-12-05 09:57:21'),(2722,'default','added',1744,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-12-05 10:06:09','2023-12-05 10:06:09'),(2723,'default','added',1745,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-05 10:10:09','2023-12-05 10:10:09'),(2724,'default','added',118,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 10:19:05','2023-12-05 10:19:05'),(2725,'default','added',1746,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":842800}}',NULL,'2023-12-05 10:22:29','2023-12-05 10:22:29'),(2726,'default','added',1747,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-05 10:33:55','2023-12-05 10:33:55'),(2727,'default','added',1748,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-05 10:35:23','2023-12-05 10:35:23'),(2728,'default','added',1749,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-05 10:45:16','2023-12-05 10:45:16'),(2729,'default','payment_edited',1299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-05 10:46:06','2023-12-05 10:46:06'),(2730,'default','added',1750,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-12-05 10:54:16','2023-12-05 10:54:16'),(2731,'default','added',1751,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-05 11:00:29','2023-12-05 11:00:29'),(2732,'default','added',1752,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2520}}',NULL,'2023-12-05 11:01:38','2023-12-05 11:01:38'),(2733,'default','added',1753,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72749.75}}',NULL,'2023-12-05 11:06:48','2023-12-05 11:06:48'),(2734,'default','payment_edited',1698,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5700.0000\"}}',NULL,'2023-12-05 11:08:29','2023-12-05 11:08:29'),(2735,'default','added',1754,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7400}}',NULL,'2023-12-05 11:08:29','2023-12-05 11:08:29'),(2736,'default','added',1755,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-12-05 11:34:53','2023-12-05 11:34:53'),(2737,'default','payment_edited',1595,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"202090.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"202090.0000\"}}',NULL,'2023-12-05 11:41:29','2023-12-05 11:41:29'),(2738,'default','added',1756,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-12-05 11:47:07','2023-12-05 11:47:07'),(2739,'default','added',1757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-12-05 11:48:19','2023-12-05 11:48:19'),(2740,'default','added',1758,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-05 11:54:13','2023-12-05 11:54:13'),(2741,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 12:09:04','2023-12-05 12:09:04'),(2742,'default','added',1759,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-05 12:12:16','2023-12-05 12:12:16'),(2743,'default','added',1760,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6400}}',NULL,'2023-12-05 12:15:28','2023-12-05 12:15:28'),(2744,'default','added',1761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4550}}',NULL,'2023-12-05 12:17:01','2023-12-05 12:17:01'),(2745,'default','added',1762,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-12-05 12:40:24','2023-12-05 12:40:24'),(2746,'default','added',1763,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-05 12:44:08','2023-12-05 12:44:08'),(2747,'default','added',1764,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-05 12:53:58','2023-12-05 12:53:58'),(2748,'default','added',1765,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-05 13:26:59','2023-12-05 13:26:59'),(2749,'default','added',1766,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-05 13:27:33','2023-12-05 13:27:33'),(2750,'default','added',1767,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-05 13:29:42','2023-12-05 13:29:42'),(2751,'default','added',1768,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-05 13:37:45','2023-12-05 13:37:45'),(2752,'default','payment_edited',413,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-05 13:39:09','2023-12-05 13:39:09'),(2753,'default','added',1769,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7128}}',NULL,'2023-12-05 13:45:42','2023-12-05 13:45:42'),(2754,'default','added',1770,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-05 13:54:31','2023-12-05 13:54:31'),(2755,'default','added',1771,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":680}}',NULL,'2023-12-05 14:05:56','2023-12-05 14:05:56'),(2756,'default','payment_edited',1265,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 14:20:36','2023-12-05 14:20:36'),(2757,'default','added',1772,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-05 14:32:34','2023-12-05 14:32:34'),(2758,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 18:16:05','2023-12-05 18:16:05'),(2759,'default','added',1773,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5420}}',NULL,'2023-12-05 18:19:09','2023-12-05 18:19:09'),(2760,'default','added',1774,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2920}}',NULL,'2023-12-05 18:28:17','2023-12-05 18:28:17'),(2761,'default','added',1775,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":94170}}',NULL,'2023-12-05 18:31:35','2023-12-05 18:31:35'),(2762,'default','added',1776,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-05 18:33:10','2023-12-05 18:33:10'),(2763,'default','added',1777,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39750}}',NULL,'2023-12-05 18:38:04','2023-12-05 18:38:04'),(2764,'default','payment_edited',1665,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"15900.0000\"}}',NULL,'2023-12-05 18:40:33','2023-12-05 18:40:33'),(2765,'default','payment_edited',231,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 18:43:20','2023-12-05 18:43:20'),(2766,'default','payment_edited',1625,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7350.0000\"}}',NULL,'2023-12-05 18:43:38','2023-12-05 18:43:38'),(2767,'default','payment_edited',1712,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-12-05 18:43:52','2023-12-05 18:43:52'),(2768,'default','added',1778,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-05 18:44:59','2023-12-05 18:44:59'),(2769,'default','added',1779,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-05 18:45:35','2023-12-05 18:45:35'),(2770,'default','added',1780,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-12-05 18:46:41','2023-12-05 18:46:41'),(2771,'default','added',1781,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4710}}',NULL,'2023-12-05 19:08:26','2023-12-05 19:08:26'),(2772,'default','added',1782,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10020}}',NULL,'2023-12-05 19:09:06','2023-12-05 19:09:06'),(2773,'default','added',1783,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11400}}',NULL,'2023-12-05 19:10:04','2023-12-05 19:10:04'),(2774,'default','added',1784,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15030}}',NULL,'2023-12-05 19:11:53','2023-12-05 19:11:53'),(2775,'default','added',1785,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-05 19:12:40','2023-12-05 19:12:40'),(2776,'default','added',1786,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16663.5999999999985448084771633148193359375}}',NULL,'2023-12-05 19:16:19','2023-12-05 19:16:19'),(2777,'default','added',1787,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11434.75}}',NULL,'2023-12-05 19:19:30','2023-12-05 19:19:30'),(2778,'default','added',1788,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":518}}',NULL,'2023-12-05 19:20:18','2023-12-05 19:20:18'),(2779,'default','added',1789,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":406}}',NULL,'2023-12-05 19:22:03','2023-12-05 19:22:03'),(2780,'default','added',1790,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-05 19:22:45','2023-12-05 19:22:45'),(2781,'default','added',1791,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-05 19:29:27','2023-12-05 19:29:27'),(2782,'default','added',1792,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":46740}}',NULL,'2023-12-05 19:30:16','2023-12-05 19:30:16'),(2783,'default','added',1793,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-05 19:56:59','2023-12-05 19:56:59'),(2784,'default','added',1794,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-05 19:57:19','2023-12-05 19:57:19'),(2785,'default','payment_edited',1451,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-12-05 20:05:42','2023-12-05 20:05:42'),(2786,'default','added',1795,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-05 20:07:36','2023-12-05 20:07:36'),(2787,'default','added',1796,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-05 20:08:10','2023-12-05 20:08:10'),(2788,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 20:36:02','2023-12-05 20:36:02'),(2789,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-05 20:58:50','2023-12-05 20:58:50'),(2790,'default','payment_edited',1510,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-12-05 21:00:13','2023-12-05 21:00:13'),(2791,'default','added',1797,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3180}}',NULL,'2023-12-05 21:23:25','2023-12-05 21:23:25'),(2792,'default','added',1798,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-12-05 21:24:57','2023-12-05 21:24:57'),(2793,'default','added',1799,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-05 21:26:26','2023-12-05 21:26:26'),(2794,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-06 12:27:38','2023-12-06 12:27:38'),(2795,'default','payment_edited',1464,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"67100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"67100.0000\"}}',NULL,'2023-12-06 12:28:15','2023-12-06 12:28:15'),(2796,'default','payment_edited',1335,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-06 12:33:37','2023-12-06 12:33:37'),(2797,'default','payment_edited',1400,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-06 12:33:37','2023-12-06 12:33:37'),(2798,'default','payment_edited',1465,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7800.0000\"}}',NULL,'2023-12-06 12:33:53','2023-12-06 12:33:53'),(2799,'default','payment_edited',1507,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2023-12-06 12:33:53','2023-12-06 12:33:53'),(2800,'default','payment_edited',1573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11800.0000\"}}',NULL,'2023-12-06 12:33:53','2023-12-06 12:33:53'),(2801,'default','payment_edited',1712,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4200.0000\"}}',NULL,'2023-12-06 12:34:14','2023-12-06 12:34:14'),(2802,'default','added',1800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6200}}',NULL,'2023-12-06 12:36:28','2023-12-06 12:36:28'),(2803,'default','added',1801,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4870}}',NULL,'2023-12-06 12:37:32','2023-12-06 12:37:32'),(2804,'default','added',1802,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-06 12:37:51','2023-12-06 12:37:51'),(2805,'default','added',1803,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15750}}',NULL,'2023-12-06 12:40:14','2023-12-06 12:40:14'),(2806,'default','added',1804,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-12-06 12:41:37','2023-12-06 12:41:37'),(2807,'default','added',1805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2580}}',NULL,'2023-12-06 12:43:44','2023-12-06 12:43:44'),(2808,'default','payment_edited',1405,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"}}',NULL,'2023-12-06 12:45:19','2023-12-06 12:45:19'),(2809,'default','payment_edited',1696,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"35280.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"35280.0000\"}}',NULL,'2023-12-06 12:45:19','2023-12-06 12:45:19'),(2810,'default','payment_edited',1754,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7400.0000\"}}',NULL,'2023-12-06 12:45:37','2023-12-06 12:45:37'),(2811,'default','added',1806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":9600}}',NULL,'2023-12-06 12:49:48','2023-12-06 12:49:48'),(2812,'default','added',1807,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-06 13:17:43','2023-12-06 13:17:43'),(2813,'default','added',1808,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-06 13:20:37','2023-12-06 13:20:37'),(2814,'default','added',1809,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-12-06 13:24:18','2023-12-06 13:24:18'),(2815,'default','added',1810,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-06 13:24:40','2023-12-06 13:24:40'),(2816,'default','added',119,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-06 13:50:14','2023-12-06 13:50:14'),(2817,'default','added',1811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-06 13:59:53','2023-12-06 13:59:53'),(2818,'default','added',1812,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-06 14:00:07','2023-12-06 14:00:07'),(2819,'default','added',1813,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":746000}}',NULL,'2023-12-06 14:02:58','2023-12-06 14:02:58'),(2820,'default','payment_edited',1813,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"746000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"746000.0000\"}}',NULL,'2023-12-06 14:04:13','2023-12-06 14:04:13'),(2821,'default','payment_edited',1746,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"842800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"842800.0000\"}}',NULL,'2023-12-06 14:07:08','2023-12-06 14:07:08'),(2822,'default','added',1814,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-06 14:21:20','2023-12-06 14:21:20'),(2823,'default','added',1815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":51900}}',NULL,'2023-12-06 14:26:00','2023-12-06 14:26:00'),(2824,'default','added',1816,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1930}}',NULL,'2023-12-06 14:30:23','2023-12-06 14:30:23'),(2825,'default','added',1817,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-12-06 14:30:48','2023-12-06 14:30:48'),(2826,'default','added',1818,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14500}}',NULL,'2023-12-06 14:40:56','2023-12-06 14:40:56'),(2827,'default','added',1819,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-12-06 14:42:33','2023-12-06 14:42:33'),(2828,'default','added',1820,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-12-06 14:43:22','2023-12-06 14:43:22'),(2829,'default','added',1821,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3000}}',NULL,'2023-12-06 14:45:40','2023-12-06 14:45:40'),(2830,'default','payment_edited',1821,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-06 14:46:05','2023-12-06 14:46:05'),(2831,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-06 17:42:13','2023-12-06 17:42:13'),(2832,'default','payment_edited',1265,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-06 17:44:41','2023-12-06 17:44:41'),(2833,'default','payment_edited',1817,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-12-06 17:45:02','2023-12-06 17:45:02'),(2834,'default','added',1822,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43500}}',NULL,'2023-12-06 17:47:49','2023-12-06 17:47:49'),(2835,'default','added',1823,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63950}}',NULL,'2023-12-06 17:50:19','2023-12-06 17:50:19'),(2836,'default','added',1824,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-06 17:52:22','2023-12-06 17:52:22'),(2837,'default','added',1825,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17670}}',NULL,'2023-12-06 18:00:01','2023-12-06 18:00:01'),(2838,'default','added',1826,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600}}',NULL,'2023-12-06 18:01:12','2023-12-06 18:01:12'),(2839,'default','added',1827,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-06 18:01:46','2023-12-06 18:01:46'),(2840,'default','added',1828,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23200}}',NULL,'2023-12-06 18:02:55','2023-12-06 18:02:55'),(2841,'default','added',1829,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21054}}',NULL,'2023-12-06 18:04:58','2023-12-06 18:04:58'),(2842,'default','added',1830,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-12-06 18:07:28','2023-12-06 18:07:28'),(2843,'default','added',1831,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-06 18:14:38','2023-12-06 18:14:38'),(2844,'default','added',1832,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-06 18:16:41','2023-12-06 18:16:41'),(2845,'default','added',1833,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5550}}',NULL,'2023-12-06 18:20:58','2023-12-06 18:20:58'),(2846,'default','added',1834,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-06 18:22:53','2023-12-06 18:22:53'),(2847,'default','added',1835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-12-06 18:37:12','2023-12-06 18:37:12'),(2848,'default','added',1836,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-12-06 19:13:10','2023-12-06 19:13:10'),(2849,'default','added',1837,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2980}}',NULL,'2023-12-06 19:18:55','2023-12-06 19:18:55'),(2850,'default','added',1838,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":14433}}',NULL,'2023-12-06 19:20:19','2023-12-06 19:20:19'),(2851,'default','added',1839,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-06 19:30:44','2023-12-06 19:30:44'),(2852,'default','added',1840,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9990}}',NULL,'2023-12-06 19:38:10','2023-12-06 19:38:10'),(2853,'default','added',1841,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-06 19:38:44','2023-12-06 19:38:44'),(2854,'default','added',1842,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6700}}',NULL,'2023-12-06 19:39:57','2023-12-06 19:39:57'),(2855,'default','added',1843,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9320}}',NULL,'2023-12-06 19:41:57','2023-12-06 19:41:57'),(2856,'default','added',1844,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-06 19:42:34','2023-12-06 19:42:34'),(2857,'default','added',1845,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-12-06 19:44:10','2023-12-06 19:44:10'),(2858,'default','added',1846,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-06 19:50:03','2023-12-06 19:50:03'),(2859,'default','added',1847,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-06 19:50:43','2023-12-06 19:50:43'),(2860,'default','added',1848,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-06 19:51:35','2023-12-06 19:51:35'),(2861,'default','added',1849,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8100}}',NULL,'2023-12-06 20:00:05','2023-12-06 20:00:05'),(2862,'default','added',1850,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-12-06 20:08:53','2023-12-06 20:08:53'),(2863,'default','payment_edited',860,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6000.0000\"}}',NULL,'2023-12-06 20:11:04','2023-12-06 20:11:04'),(2864,'default','added',1851,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8530}}',NULL,'2023-12-06 20:14:58','2023-12-06 20:14:58'),(2865,'default','added',1852,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-06 20:25:15','2023-12-06 20:25:15'),(2866,'default','payment_edited',1838,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"14433.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"14433.0000\"}}',NULL,'2023-12-06 20:30:59','2023-12-06 20:30:59'),(2867,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-06 20:31:28','2023-12-06 20:31:28'),(2868,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-06 21:52:52','2023-12-06 21:52:52'),(2869,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 10:17:20','2023-12-07 10:17:20'),(2870,'default','added',1853,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-07 10:20:11','2023-12-07 10:20:11'),(2871,'default','added',1854,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-07 10:39:15','2023-12-07 10:39:15'),(2872,'default','added',1855,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-07 10:41:00','2023-12-07 10:41:00'),(2873,'default','payment_edited',1573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"}}',NULL,'2023-12-07 10:45:09','2023-12-07 10:45:09'),(2874,'default','added',1856,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2150}}',NULL,'2023-12-07 11:03:55','2023-12-07 11:03:55'),(2875,'default','added',1857,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8750}}',NULL,'2023-12-07 11:06:09','2023-12-07 11:06:09'),(2876,'default','added',1858,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3630}}',NULL,'2023-12-07 11:11:58','2023-12-07 11:11:58'),(2877,'default','added',1859,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11450}}',NULL,'2023-12-07 11:14:10','2023-12-07 11:14:10'),(2878,'default','added',1860,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-12-07 11:14:32','2023-12-07 11:14:32'),(2879,'default','added',1861,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-07 11:15:26','2023-12-07 11:15:26'),(2880,'default','added',1862,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-12-07 11:25:49','2023-12-07 11:25:49'),(2881,'default','payment_edited',1826,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5600.0000\"}}',NULL,'2023-12-07 11:27:09','2023-12-07 11:27:09'),(2882,'default','added',1863,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7200}}',NULL,'2023-12-07 11:28:38','2023-12-07 11:28:38'),(2883,'default','added',1864,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-12-07 11:29:15','2023-12-07 11:29:15'),(2884,'default','added',1865,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2760}}',NULL,'2023-12-07 11:35:35','2023-12-07 11:35:35'),(2885,'default','added',1866,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":460}}',NULL,'2023-12-07 11:46:29','2023-12-07 11:46:29'),(2886,'default','payment_edited',1134,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"164000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"164000.0000\"}}',NULL,'2023-12-07 11:54:04','2023-12-07 11:54:04'),(2887,'default','payment_edited',1699,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"76725.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"76725.0000\"}}',NULL,'2023-12-07 11:54:04','2023-12-07 11:54:04'),(2888,'default','added',1867,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-12-07 11:58:31','2023-12-07 11:58:31'),(2889,'default','added',1868,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-07 12:06:01','2023-12-07 12:06:01'),(2890,'default','payment_edited',1678,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"275635.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"275635.0000\"}}',NULL,'2023-12-07 13:21:34','2023-12-07 13:21:34'),(2891,'default','added',1869,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-07 13:22:59','2023-12-07 13:22:59'),(2892,'default','added',1870,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-07 13:23:26','2023-12-07 13:23:26'),(2893,'default','added',1871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-07 13:24:09','2023-12-07 13:24:09'),(2894,'default','added',1872,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1270}}',NULL,'2023-12-07 13:25:07','2023-12-07 13:25:07'),(2895,'default','added',1873,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-07 13:30:52','2023-12-07 13:30:52'),(2896,'default','added',1874,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-12-07 13:46:22','2023-12-07 13:46:22'),(2897,'default','added',1875,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":27170}}',NULL,'2023-12-07 14:26:17','2023-12-07 14:26:17'),(2898,'default','added',1876,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":43000}}',NULL,'2023-12-07 14:28:36','2023-12-07 14:28:36'),(2899,'default','added',1877,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-07 14:40:39','2023-12-07 14:40:39'),(2900,'default','added',1878,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-07 14:51:37','2023-12-07 14:51:37'),(2901,'default','payment_edited',1121,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"44800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"44800.0000\"}}',NULL,'2023-12-07 14:54:10','2023-12-07 14:54:10'),(2902,'default','payment_edited',1536,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"107590.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"107590.0000\"}}',NULL,'2023-12-07 14:54:10','2023-12-07 14:54:10'),(2903,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 15:02:26','2023-12-07 15:02:26'),(2904,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 15:56:11','2023-12-07 15:56:11'),(2905,'default','added',1879,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":39700}}',NULL,'2023-12-07 15:59:42','2023-12-07 15:59:42'),(2906,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 17:33:35','2023-12-07 17:33:35'),(2907,'default','added',1880,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8600}}',NULL,'2023-12-07 17:35:46','2023-12-07 17:35:46'),(2908,'default','added',1881,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-07 17:42:33','2023-12-07 17:42:33'),(2909,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 17:43:38','2023-12-07 17:43:38'),(2910,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 17:44:26','2023-12-07 17:44:26'),(2911,'default','added',1882,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-12-07 17:45:38','2023-12-07 17:45:38'),(2912,'default','added',1883,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23500}}',NULL,'2023-12-07 17:48:39','2023-12-07 17:48:39'),(2913,'default','added',1884,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6960}}',NULL,'2023-12-07 17:49:14','2023-12-07 17:49:14'),(2914,'default','added',1885,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4350}}',NULL,'2023-12-07 17:51:15','2023-12-07 17:51:15'),(2915,'default','added',1886,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8100}}',NULL,'2023-12-07 17:52:14','2023-12-07 17:52:14'),(2916,'default','edited',53,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 17:53:20','2023-12-07 17:53:20'),(2917,'default','added',1887,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":7200}}',NULL,'2023-12-07 17:54:09','2023-12-07 17:54:09'),(2918,'default','added',1888,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-07 17:55:57','2023-12-07 17:55:57'),(2919,'default','added',1889,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-07 17:58:36','2023-12-07 17:58:36'),(2920,'default','added',1890,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-07 18:04:42','2023-12-07 18:04:42'),(2921,'default','edited',1890,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"}}',NULL,'2023-12-07 18:15:26','2023-12-07 18:15:26'),(2922,'default','added',1891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-07 18:28:07','2023-12-07 18:28:07'),(2923,'default','added',1892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-07 18:40:47','2023-12-07 18:40:47'),(2924,'default','added',1893,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-07 18:49:26','2023-12-07 18:49:26'),(2925,'default','added',1894,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20900}}',NULL,'2023-12-07 19:18:57','2023-12-07 19:18:57'),(2926,'default','added',1895,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2450}}',NULL,'2023-12-07 19:22:41','2023-12-07 19:22:41'),(2927,'default','payment_edited',1895,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-12-07 19:23:04','2023-12-07 19:23:04'),(2928,'default','added',1896,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":4500}}',NULL,'2023-12-07 19:26:43','2023-12-07 19:26:43'),(2929,'default','payment_edited',1896,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-12-07 19:27:43','2023-12-07 19:27:43'),(2930,'default','added',1897,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3850}}',NULL,'2023-12-07 19:32:02','2023-12-07 19:32:02'),(2931,'default','payment_edited',1374,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"57740.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"57740.0000\"}}',NULL,'2023-12-07 19:34:22','2023-12-07 19:34:22'),(2932,'default','payment_edited',1490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"30280.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"30280.0000\"}}',NULL,'2023-12-07 19:34:22','2023-12-07 19:34:22'),(2933,'default','payment_edited',1705,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"63825.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"63825.0000\"}}',NULL,'2023-12-07 19:34:22','2023-12-07 19:34:22'),(2934,'default','added',1898,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-07 19:35:17','2023-12-07 19:35:17'),(2935,'default','added',1899,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-07 19:37:19','2023-12-07 19:37:19'),(2936,'default','added',1900,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-07 19:39:39','2023-12-07 19:39:39'),(2937,'default','added',1901,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-07 19:40:12','2023-12-07 19:40:12'),(2938,'default','payment_edited',1867,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-12-07 19:49:12','2023-12-07 19:49:12'),(2939,'default','added',1902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-07 19:56:15','2023-12-07 19:56:15'),(2940,'default','added',1903,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-07 20:06:31','2023-12-07 20:06:31'),(2941,'default','added',1904,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8700}}',NULL,'2023-12-07 20:11:07','2023-12-07 20:11:07'),(2942,'default','added',1905,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2530}}',NULL,'2023-12-07 20:18:16','2023-12-07 20:18:16'),(2943,'default','added',1906,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475}}',NULL,'2023-12-07 20:23:58','2023-12-07 20:23:58'),(2944,'default','added',1907,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-12-07 20:38:35','2023-12-07 20:38:35'),(2945,'default','added',1908,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10100}}',NULL,'2023-12-07 20:40:08','2023-12-07 20:40:08'),(2946,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-07 20:45:50','2023-12-07 20:45:50'),(2947,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-08 17:25:30','2023-12-08 17:25:30'),(2948,'default','added',1909,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-08 17:28:49','2023-12-08 17:28:49'),(2949,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-08 21:36:28','2023-12-08 21:36:28'),(2950,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 10:00:14','2023-12-09 10:00:14'),(2951,'default','added',1910,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4650}}',NULL,'2023-12-09 10:24:59','2023-12-09 10:24:59'),(2952,'default','added',1911,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1430}}',NULL,'2023-12-09 10:25:45','2023-12-09 10:25:45'),(2953,'default','payment_edited',1400,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-09 10:32:51','2023-12-09 10:32:51'),(2954,'default','payment_edited',1422,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3250.0000\"}}',NULL,'2023-12-09 10:32:51','2023-12-09 10:32:51'),(2955,'default','added',1912,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-09 10:36:05','2023-12-09 10:36:05'),(2956,'default','added',120,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 10:39:28','2023-12-09 10:39:28'),(2957,'default','added',1913,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":23200}}',NULL,'2023-12-09 10:42:05','2023-12-09 10:42:05'),(2958,'default','added',1914,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2780}}',NULL,'2023-12-09 10:43:42','2023-12-09 10:43:42'),(2959,'default','added',1915,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9330}}',NULL,'2023-12-09 10:44:49','2023-12-09 10:44:49'),(2960,'default','added',1916,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2600}}',NULL,'2023-12-09 10:45:30','2023-12-09 10:45:30'),(2961,'default','added',1917,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-12-09 10:53:49','2023-12-09 10:53:49'),(2962,'default','added',1918,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-09 10:54:47','2023-12-09 10:54:47'),(2963,'default','added',1919,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":127992.5}}',NULL,'2023-12-09 11:00:38','2023-12-09 11:00:38'),(2964,'default','added',1920,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-09 11:05:33','2023-12-09 11:05:33'),(2965,'default','added',1921,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-12-09 11:06:45','2023-12-09 11:06:45'),(2966,'default','payment_edited',466,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}',NULL,'2023-12-09 11:08:18','2023-12-09 11:08:18'),(2967,'default','added',1922,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-09 11:09:12','2023-12-09 11:09:12'),(2968,'default','payment_edited',1573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"}}',NULL,'2023-12-09 11:10:30','2023-12-09 11:10:30'),(2969,'default','added',1923,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-09 11:12:20','2023-12-09 11:12:20'),(2970,'default','added',1924,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-09 11:12:40','2023-12-09 11:12:40'),(2971,'default','added',1925,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-09 11:30:01','2023-12-09 11:30:01'),(2972,'default','added',1926,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8350}}',NULL,'2023-12-09 11:31:01','2023-12-09 11:31:01'),(2973,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 12:16:45','2023-12-09 12:16:45'),(2974,'default','added',1927,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-12-09 13:15:26','2023-12-09 13:15:26'),(2975,'default','payment_edited',1775,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"94170.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"94170.0000\"}}',NULL,'2023-12-09 13:16:31','2023-12-09 13:16:31'),(2976,'default','payment_edited',1299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-09 13:18:18','2023-12-09 13:18:18'),(2977,'default','added',1928,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-09 13:19:21','2023-12-09 13:19:21'),(2978,'default','added',1929,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12780}}',NULL,'2023-12-09 13:22:01','2023-12-09 13:22:01'),(2979,'default','added',1930,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-09 13:22:32','2023-12-09 13:22:32'),(2980,'default','added',1931,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3260}}',NULL,'2023-12-09 13:32:37','2023-12-09 13:32:37'),(2981,'default','added',1932,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-09 13:40:16','2023-12-09 13:40:16'),(2982,'default','added',1933,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-12-09 13:43:37','2023-12-09 13:43:37'),(2983,'default','payment_edited',1286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-09 13:59:51','2023-12-09 13:59:51'),(2984,'default','payment_edited',1887,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7200.0000\"}}',NULL,'2023-12-09 13:59:51','2023-12-09 13:59:51'),(2985,'default','added',1934,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5150}}',NULL,'2023-12-09 14:10:02','2023-12-09 14:10:02'),(2986,'default','added',1935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-09 14:11:40','2023-12-09 14:11:40'),(2987,'default','added',1936,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-12-09 14:23:09','2023-12-09 14:23:09'),(2988,'default','added',1937,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-09 14:34:46','2023-12-09 14:34:46'),(2989,'default','added',1938,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-09 14:41:09','2023-12-09 14:41:09'),(2990,'default','added',1939,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-12-09 14:47:14','2023-12-09 14:47:14'),(2991,'default','added',1940,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-12-09 14:48:32','2023-12-09 14:48:32'),(2992,'default','added',1941,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-09 14:53:13','2023-12-09 14:53:13'),(2993,'default','added',1942,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":47200}}',NULL,'2023-12-09 14:54:03','2023-12-09 14:54:03'),(2994,'default','added',1943,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1670}}',NULL,'2023-12-09 15:07:15','2023-12-09 15:07:15'),(2995,'default','added',1944,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-09 15:12:27','2023-12-09 15:12:27'),(2996,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 15:27:40','2023-12-09 15:27:40'),(2997,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 16:55:59','2023-12-09 16:55:59'),(2998,'default','added',1945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-12-09 16:59:22','2023-12-09 16:59:22'),(2999,'default','payment_edited',1422,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3250.0000\"}}',NULL,'2023-12-09 17:00:14','2023-12-09 17:00:14'),(3000,'default','payment_edited',1446,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-09 17:00:14','2023-12-09 17:00:14'),(3001,'default','payment_edited',1508,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-09 17:00:14','2023-12-09 17:00:14'),(3002,'default','payment_edited',1516,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6000.0000\"}}',NULL,'2023-12-09 17:02:47','2023-12-09 17:02:47'),(3003,'default','added',1946,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17400}}',NULL,'2023-12-09 17:08:27','2023-12-09 17:08:27'),(3004,'default','added',121,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 17:12:59','2023-12-09 17:12:59'),(3005,'default','added',1947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-09 17:13:39','2023-12-09 17:13:39'),(3006,'default','added',1948,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13920}}',NULL,'2023-12-09 17:18:28','2023-12-09 17:18:28'),(3007,'default','added',1949,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-09 17:24:33','2023-12-09 17:24:33'),(3008,'default','added',1950,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10050}}',NULL,'2023-12-09 17:25:23','2023-12-09 17:25:23'),(3009,'default','added',1951,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-09 17:31:51','2023-12-09 17:31:51'),(3010,'default','added',1952,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25800}}',NULL,'2023-12-09 17:33:59','2023-12-09 17:33:59'),(3011,'default','added',1953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-09 17:40:20','2023-12-09 17:40:20'),(3012,'default','added',1954,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12620}}',NULL,'2023-12-09 17:50:48','2023-12-09 17:50:48'),(3013,'default','added',1955,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6300}}',NULL,'2023-12-09 17:52:32','2023-12-09 17:52:32'),(3014,'default','added',122,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 17:55:04','2023-12-09 17:55:04'),(3015,'default','added',1956,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2700}}',NULL,'2023-12-09 17:56:40','2023-12-09 17:56:40'),(3016,'default','added',1957,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-09 17:57:15','2023-12-09 17:57:15'),(3017,'default','added',1958,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":19800}}',NULL,'2023-12-09 18:01:48','2023-12-09 18:01:48'),(3018,'default','added',1959,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-09 18:04:36','2023-12-09 18:04:36'),(3019,'default','added',1960,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":96480}}',NULL,'2023-12-09 18:11:27','2023-12-09 18:11:27'),(3020,'default','added',1961,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-09 18:12:38','2023-12-09 18:12:38'),(3021,'default','added',1962,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-09 18:13:39','2023-12-09 18:13:39'),(3022,'default','added',1963,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":14348}}',NULL,'2023-12-09 18:16:01','2023-12-09 18:16:01'),(3023,'default','added',1964,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3190}}',NULL,'2023-12-09 18:19:47','2023-12-09 18:19:47'),(3024,'default','added',1965,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":63105}}',NULL,'2023-12-09 18:20:34','2023-12-09 18:20:34'),(3025,'default','added',1966,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-09 18:21:09','2023-12-09 18:21:09'),(3026,'default','added',1967,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-09 18:21:59','2023-12-09 18:21:59'),(3027,'default','added',1968,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11570}}',NULL,'2023-12-09 18:23:18','2023-12-09 18:23:18'),(3028,'default','added',1969,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16965}}',NULL,'2023-12-09 18:26:26','2023-12-09 18:26:26'),(3029,'default','added',1970,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8400}}',NULL,'2023-12-09 18:28:01','2023-12-09 18:28:01'),(3030,'default','added',1971,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-09 18:31:52','2023-12-09 18:31:52'),(3031,'default','added',1972,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-09 18:32:38','2023-12-09 18:32:38'),(3032,'default','added',1973,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2530}}',NULL,'2023-12-09 18:36:00','2023-12-09 18:36:00'),(3033,'default','added',1974,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-09 18:36:44','2023-12-09 18:36:44'),(3034,'default','added',1975,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-09 18:45:23','2023-12-09 18:45:23'),(3035,'default','edited',1975,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-09 18:46:29','2023-12-09 18:46:29'),(3036,'default','added',1976,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-09 18:48:56','2023-12-09 18:48:56'),(3037,'default','added',1977,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-09 18:49:30','2023-12-09 18:49:30'),(3038,'default','payment_edited',1917,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-12-09 19:08:10','2023-12-09 19:08:10'),(3039,'default','added',1978,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-09 19:25:19','2023-12-09 19:25:19'),(3040,'default','added',1979,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13000}}',NULL,'2023-12-09 19:31:42','2023-12-09 19:31:42'),(3041,'default','added',1980,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-09 19:32:04','2023-12-09 19:32:04'),(3042,'default','added',1981,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-09 19:33:37','2023-12-09 19:33:37'),(3043,'default','payment_edited',48,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 19:38:01','2023-12-09 19:38:01'),(3044,'default','added',1982,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5800}}',NULL,'2023-12-09 19:50:55','2023-12-09 19:50:55'),(3045,'default','added',1983,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-09 19:51:46','2023-12-09 19:51:46'),(3046,'default','added',1984,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-09 19:54:11','2023-12-09 19:54:11'),(3047,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 19:57:56','2023-12-09 19:57:56'),(3048,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-09 19:59:20','2023-12-09 19:59:20'),(3049,'default','payment_edited',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"}}',NULL,'2023-12-09 20:00:27','2023-12-09 20:00:27'),(3050,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 11:24:18','2023-12-10 11:24:18'),(3051,'default','added',1985,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-10 11:32:33','2023-12-10 11:32:33'),(3052,'default','added',1986,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":111359.240000000005238689482212066650390625}}',NULL,'2023-12-10 11:42:26','2023-12-10 11:42:26'),(3053,'default','added',1987,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2640}}',NULL,'2023-12-10 11:43:40','2023-12-10 11:43:40'),(3054,'default','payment_edited',1573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11800.0000\"}}',NULL,'2023-12-10 11:45:52','2023-12-10 11:45:52'),(3055,'default','payment_edited',1647,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12000.0000\"}}',NULL,'2023-12-10 11:45:52','2023-12-10 11:45:52'),(3056,'default','payment_edited',1508,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-10 11:47:33','2023-12-10 11:47:33'),(3057,'default','payment_edited',1548,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-10 11:47:33','2023-12-10 11:47:33'),(3058,'default','added',1988,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-12-10 11:50:36','2023-12-10 11:50:36'),(3059,'default','added',1989,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-10 11:52:42','2023-12-10 11:52:42'),(3060,'default','payment_edited',1601,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"30250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"30250.0000\"}}',NULL,'2023-12-10 11:54:55','2023-12-10 11:54:55'),(3061,'default','added',1990,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10450}}',NULL,'2023-12-10 11:56:31','2023-12-10 11:56:31'),(3062,'default','added',1991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2150}}',NULL,'2023-12-10 12:34:36','2023-12-10 12:34:36'),(3063,'default','added',1992,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-12-10 12:42:41','2023-12-10 12:42:41'),(3064,'default','added',1993,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-12-10 12:43:45','2023-12-10 12:43:45'),(3065,'default','edited',118,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 12:44:26','2023-12-10 12:44:26'),(3066,'default','payment_edited',1746,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"842800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"842800.0000\"}}',NULL,'2023-12-10 12:44:41','2023-12-10 12:44:41'),(3067,'default','payment_edited',1678,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"275635.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"275635.0000\"}}',NULL,'2023-12-10 12:48:27','2023-12-10 12:48:27'),(3068,'default','added',1994,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-10 12:52:52','2023-12-10 12:52:52'),(3069,'default','added',1995,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":10400}}',NULL,'2023-12-10 12:54:22','2023-12-10 12:54:22'),(3070,'default','payment_edited',398,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12500.0000\"}}',NULL,'2023-12-10 13:21:54','2023-12-10 13:21:54'),(3071,'default','added',1996,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-10 13:23:56','2023-12-10 13:23:56'),(3072,'default','payment_edited',1995,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10400.0000\"}}',NULL,'2023-12-10 13:33:29','2023-12-10 13:33:29'),(3073,'default','added',1997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1875}}',NULL,'2023-12-10 13:40:57','2023-12-10 13:40:57'),(3074,'default','added',1998,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10320}}',NULL,'2023-12-10 13:45:58','2023-12-10 13:45:58'),(3075,'default','added',1999,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8230}}',NULL,'2023-12-10 13:48:04','2023-12-10 13:48:04'),(3076,'default','added',2000,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5710}}',NULL,'2023-12-10 13:48:54','2023-12-10 13:48:54'),(3077,'default','added',2001,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6250}}',NULL,'2023-12-10 13:51:26','2023-12-10 13:51:26'),(3078,'default','added',2002,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9120}}',NULL,'2023-12-10 13:59:16','2023-12-10 13:59:16'),(3079,'default','added',2003,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17780}}',NULL,'2023-12-10 14:04:37','2023-12-10 14:04:37'),(3080,'default','added',2004,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-10 14:05:33','2023-12-10 14:05:33'),(3081,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 14:09:01','2023-12-10 14:09:01'),(3082,'default','added',2005,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-10 14:23:22','2023-12-10 14:23:22'),(3083,'default','added',2006,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-10 14:38:55','2023-12-10 14:38:55'),(3084,'default','added',2007,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-10 14:41:11','2023-12-10 14:41:11'),(3085,'default','added',2008,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4950}}',NULL,'2023-12-10 14:46:19','2023-12-10 14:46:19'),(3086,'default','added',2009,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-10 14:51:15','2023-12-10 14:51:15'),(3087,'default','added',2010,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-10 14:54:17','2023-12-10 14:54:17'),(3088,'default','added',2011,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-10 14:59:01','2023-12-10 14:59:01'),(3089,'default','added',2012,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-12-10 15:03:43','2023-12-10 15:03:43'),(3090,'default','added',2013,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-10 15:07:09','2023-12-10 15:07:09'),(3091,'default','added',2014,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11780}}',NULL,'2023-12-10 15:08:54','2023-12-10 15:08:54'),(3092,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 17:23:50','2023-12-10 17:23:50'),(3093,'default','added',2015,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":39640}}',NULL,'2023-12-10 17:26:16','2023-12-10 17:26:16'),(3094,'default','added',2016,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":18900}}',NULL,'2023-12-10 17:27:46','2023-12-10 17:27:46'),(3095,'default','added',2017,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-10 17:29:05','2023-12-10 17:29:05'),(3096,'default','added',2018,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-12-10 17:30:48','2023-12-10 17:30:48'),(3097,'default','added',2019,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11520}}',NULL,'2023-12-10 17:31:55','2023-12-10 17:31:55'),(3098,'default','added',2020,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23200}}',NULL,'2023-12-10 17:34:00','2023-12-10 17:34:00'),(3099,'default','payment_edited',1265,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 17:44:45','2023-12-10 17:44:45'),(3100,'default','payment_edited',1266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-10 17:44:45','2023-12-10 17:44:45'),(3101,'default','added',2021,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15750}}',NULL,'2023-12-10 17:48:41','2023-12-10 17:48:41'),(3102,'default','added',2022,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8640}}',NULL,'2023-12-10 17:52:32','2023-12-10 17:52:32'),(3103,'default','added',123,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 17:55:41','2023-12-10 17:55:41'),(3104,'default','added',2023,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-12-10 17:56:47','2023-12-10 17:56:47'),(3105,'default','payment_edited',1659,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2650.0000\"}}',NULL,'2023-12-10 17:57:20','2023-12-10 17:57:20'),(3106,'default','added',2024,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2950}}',NULL,'2023-12-10 17:58:02','2023-12-10 17:58:02'),(3107,'default','added',2025,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-10 17:59:05','2023-12-10 17:59:05'),(3108,'default','added',2026,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-10 18:00:14','2023-12-10 18:00:14'),(3109,'default','added',2027,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-10 18:00:50','2023-12-10 18:00:50'),(3110,'default','payment_edited',1719,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-12-10 18:01:34','2023-12-10 18:01:34'),(3111,'default','payment_edited',1199,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"109400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"109400.0000\"}}',NULL,'2023-12-10 18:16:24','2023-12-10 18:16:24'),(3112,'default','payment_edited',1960,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"96480.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"96480.0000\"}}',NULL,'2023-12-10 18:16:24','2023-12-10 18:16:24'),(3113,'default','added',2028,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4590}}',NULL,'2023-12-10 18:26:44','2023-12-10 18:26:44'),(3114,'default','added',2029,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-10 18:30:51','2023-12-10 18:30:51'),(3115,'default','added',2030,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-10 18:32:54','2023-12-10 18:32:54'),(3116,'default','added',2031,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-12-10 18:33:45','2023-12-10 18:33:45'),(3117,'default','added',2032,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-12-10 18:45:09','2023-12-10 18:45:09'),(3118,'default','added',2033,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-12-10 18:47:01','2023-12-10 18:47:01'),(3119,'default','added',2034,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6750}}',NULL,'2023-12-10 18:47:39','2023-12-10 18:47:39'),(3120,'default','added',2035,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7600}}',NULL,'2023-12-10 18:48:11','2023-12-10 18:48:11'),(3121,'default','added',2036,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9048}}',NULL,'2023-12-10 19:08:44','2023-12-10 19:08:44'),(3122,'default','added',2037,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-10 19:09:43','2023-12-10 19:09:43'),(3123,'default','added',2038,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-10 19:11:13','2023-12-10 19:11:13'),(3124,'default','added',2039,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-10 19:15:54','2023-12-10 19:15:54'),(3125,'default','added',2040,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-10 19:18:41','2023-12-10 19:18:41'),(3126,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 19:23:53','2023-12-10 19:23:53'),(3127,'default','added',2041,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4250}}',NULL,'2023-12-10 19:51:51','2023-12-10 19:51:51'),(3128,'default','added',2042,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 19:52:41','2023-12-10 19:52:41'),(3129,'default','added',2043,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-10 19:57:11','2023-12-10 19:57:11'),(3130,'default','added',2044,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-10 20:02:01','2023-12-10 20:02:01'),(3131,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-10 20:02:11','2023-12-10 20:02:11'),(3132,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-11 19:42:21','2023-12-11 19:42:21'),(3133,'default','added',2045,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-11 19:43:01','2023-12-11 19:43:01'),(3134,'default','payment_edited',1705,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"63825.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"63825.0000\"}}',NULL,'2023-12-11 19:45:49','2023-12-11 19:45:49'),(3135,'default','payment_edited',1792,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"46740.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"46740.0000\"}}',NULL,'2023-12-11 19:45:49','2023-12-11 19:45:49'),(3136,'default','payment_edited',1965,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"63105.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"63105.0000\"}}',NULL,'2023-12-11 19:45:49','2023-12-11 19:45:49'),(3137,'default','added',2046,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-11 19:47:00','2023-12-11 19:47:00'),(3138,'default','payment_edited',1887,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7200.0000\"}}',NULL,'2023-12-11 19:47:46','2023-12-11 19:47:46'),(3139,'default','payment_edited',1548,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-11 19:48:11','2023-12-11 19:48:11'),(3140,'default','payment_edited',1644,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-11 19:48:11','2023-12-11 19:48:11'),(3141,'default','payment_edited',1685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-11 19:48:11','2023-12-11 19:48:11'),(3142,'default','payment_edited',1560,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-12-11 19:48:35','2023-12-11 19:48:35'),(3143,'default','payment_edited',1947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-11 19:49:00','2023-12-11 19:49:00'),(3144,'default','payment_edited',1522,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2700.0000\"}}',NULL,'2023-12-11 19:49:17','2023-12-11 19:49:17'),(3145,'default','added',2047,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":41740}}',NULL,'2023-12-11 19:51:14','2023-12-11 19:51:14'),(3146,'default','added',2048,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":51560}}',NULL,'2023-12-11 19:52:40','2023-12-11 19:52:40'),(3147,'default','added',2049,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":195090}}',NULL,'2023-12-11 19:56:32','2023-12-11 19:56:32'),(3148,'default','added',2050,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-11 19:59:10','2023-12-11 19:59:10'),(3149,'default','added',2051,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-11 19:59:36','2023-12-11 19:59:36'),(3150,'default','added',2052,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-12-11 20:00:33','2023-12-11 20:00:33'),(3151,'default','added',2053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550}}',NULL,'2023-12-11 20:00:56','2023-12-11 20:00:56'),(3152,'default','added',2054,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5650}}',NULL,'2023-12-11 20:02:28','2023-12-11 20:02:28'),(3153,'default','added',2055,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-12-11 20:03:04','2023-12-11 20:03:04'),(3154,'default','added',2056,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3260}}',NULL,'2023-12-11 20:03:52','2023-12-11 20:03:52'),(3155,'default','added',2057,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-11 20:04:18','2023-12-11 20:04:18'),(3156,'default','added',2058,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-11 20:05:33','2023-12-11 20:05:33'),(3157,'default','added',2059,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-12-11 20:06:14','2023-12-11 20:06:14'),(3158,'default','added',2060,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7250}}',NULL,'2023-12-11 20:07:05','2023-12-11 20:07:05'),(3159,'default','added',2061,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7710}}',NULL,'2023-12-11 20:08:06','2023-12-11 20:08:06'),(3160,'default','added',2062,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9330}}',NULL,'2023-12-11 20:10:44','2023-12-11 20:10:44'),(3161,'default','added',2063,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6900}}',NULL,'2023-12-11 20:11:21','2023-12-11 20:11:21'),(3162,'default','added',2064,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15600}}',NULL,'2023-12-11 20:12:11','2023-12-11 20:12:11'),(3163,'default','added',2065,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-11 20:13:12','2023-12-11 20:13:12'),(3164,'default','added',2066,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7700}}',NULL,'2023-12-11 20:15:06','2023-12-11 20:15:06'),(3165,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-11 20:18:04','2023-12-11 20:18:04'),(3166,'default','added',124,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-11 20:24:25','2023-12-11 20:24:25'),(3167,'default','added',2067,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550}}',NULL,'2023-12-11 20:25:02','2023-12-11 20:25:02'),(3168,'default','added',2068,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2607}}',NULL,'2023-12-11 20:29:00','2023-12-11 20:29:00'),(3169,'default','added',2069,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10150}}',NULL,'2023-12-11 20:31:02','2023-12-11 20:31:02'),(3170,'default','added',2070,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8210}}',NULL,'2023-12-11 20:32:24','2023-12-11 20:32:24'),(3171,'default','added',2071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10530}}',NULL,'2023-12-11 20:33:41','2023-12-11 20:33:41'),(3172,'default','added',2072,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-11 20:34:19','2023-12-11 20:34:19'),(3173,'default','added',2073,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-11 20:36:00','2023-12-11 20:36:00'),(3174,'default','payment_edited',2067,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-11 20:37:18','2023-12-11 20:37:18'),(3175,'default','added',2074,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70517.490000000005238689482212066650390625}}',NULL,'2023-12-11 20:41:35','2023-12-11 20:41:35'),(3176,'default','payment_edited',1863,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7200.0000\"}}',NULL,'2023-12-11 20:43:18','2023-12-11 20:43:18'),(3177,'default','added',2075,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-11 20:43:48','2023-12-11 20:43:48'),(3178,'default','added',2076,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-12-11 20:45:04','2023-12-11 20:45:04'),(3179,'default','added',2077,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24718.04999999999927240423858165740966796875}}',NULL,'2023-12-11 20:46:10','2023-12-11 20:46:10'),(3180,'default','added',2078,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5800}}',NULL,'2023-12-11 20:47:07','2023-12-11 20:47:07'),(3181,'default','added',2079,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-11 20:50:08','2023-12-11 20:50:08'),(3182,'default','added',2080,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":64722.83999999999650754034519195556640625}}',NULL,'2023-12-11 20:51:42','2023-12-11 20:51:42'),(3183,'default','added',2081,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-11 20:58:10','2023-12-11 20:58:10'),(3184,'default','payment_edited',2064,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"15600.0000\"}}',NULL,'2023-12-11 21:09:06','2023-12-11 21:09:06'),(3185,'default','added',2082,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-11 21:09:41','2023-12-11 21:09:41'),(3186,'default','added',2083,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-11 21:11:48','2023-12-11 21:11:48'),(3187,'default','added',2084,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-11 21:22:11','2023-12-11 21:22:11'),(3188,'default','added',2085,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-12-11 21:22:55','2023-12-11 21:22:55'),(3189,'default','added',2086,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-11 21:25:17','2023-12-11 21:25:17'),(3190,'default','added',2087,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-11 21:35:54','2023-12-11 21:35:54'),(3191,'default','added',2088,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3340}}',NULL,'2023-12-11 21:54:51','2023-12-11 21:54:51'),(3192,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-11 21:57:53','2023-12-11 21:57:53'),(3193,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-12 10:57:49','2023-12-12 10:57:49'),(3194,'default','added',2089,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-12 11:00:52','2023-12-12 11:00:52'),(3195,'default','added',2096,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-12 11:20:52','2023-12-12 11:20:52'),(3196,'default','added',2097,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37002}}',NULL,'2023-12-12 11:25:29','2023-12-12 11:25:29'),(3197,'default','payment_edited',1815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"51900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"51900.0000\"}}',NULL,'2023-12-12 11:26:05','2023-12-12 11:26:05'),(3198,'default','payment_edited',1813,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"746000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"746000.0000\"}}',NULL,'2023-12-12 12:01:51','2023-12-12 12:01:51'),(3199,'default','added',2098,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-12-12 12:05:35','2023-12-12 12:05:35'),(3200,'default','added',2099,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2700}}',NULL,'2023-12-12 12:23:50','2023-12-12 12:23:50'),(3201,'default','payment_edited',1647,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"}}',NULL,'2023-12-12 12:29:46','2023-12-12 12:29:46'),(3202,'default','payment_edited',1720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6480.0000\"}}',NULL,'2023-12-12 12:29:46','2023-12-12 12:29:46'),(3203,'default','payment_edited',1685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-12 12:32:09','2023-12-12 12:32:09'),(3204,'default','payment_edited',1713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3250.0000\"}}',NULL,'2023-12-12 12:32:09','2023-12-12 12:32:09'),(3205,'default','added',2100,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-12 12:33:07','2023-12-12 12:33:07'),(3206,'default','payment_edited',1401,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-12 12:35:35','2023-12-12 12:35:35'),(3207,'default','added',2101,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-12 12:36:56','2023-12-12 12:36:56'),(3208,'default','added',2102,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-12 12:37:56','2023-12-12 12:37:56'),(3209,'default','added',125,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-12 12:39:22','2023-12-12 12:39:22'),(3210,'default','added',2103,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3400}}',NULL,'2023-12-12 12:39:43','2023-12-12 12:39:43'),(3211,'default','added',2104,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1560}}',NULL,'2023-12-12 12:40:37','2023-12-12 12:40:37'),(3212,'default','added',2105,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-12 12:42:57','2023-12-12 12:42:57'),(3213,'default','added',2106,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-12 12:43:33','2023-12-12 12:43:33'),(3214,'default','added',2107,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-12 12:44:10','2023-12-12 12:44:10'),(3215,'default','added',2108,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-12 12:46:49','2023-12-12 12:46:49'),(3216,'default','added',2109,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2000}}',NULL,'2023-12-12 12:49:28','2023-12-12 12:49:28'),(3217,'default','payment_edited',2109,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2023-12-12 12:49:50','2023-12-12 12:49:50'),(3218,'default','added',2110,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1180}}',NULL,'2023-12-12 12:50:24','2023-12-12 12:50:24'),(3219,'default','added',2111,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-12 13:24:20','2023-12-12 13:24:20'),(3220,'default','payment_edited',1568,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1900.0000\"}}',NULL,'2023-12-12 13:32:18','2023-12-12 13:32:18'),(3221,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-12 13:33:04','2023-12-12 13:33:04'),(3222,'default','added',2112,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-12 13:33:41','2023-12-12 13:33:41'),(3223,'default','added',2113,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-12 13:35:04','2023-12-12 13:35:04'),(3224,'default','added',2114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":580}}',NULL,'2023-12-12 13:39:14','2023-12-12 13:39:14'),(3225,'default','added',2115,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-12 13:40:41','2023-12-12 13:40:41'),(3226,'default','payment_edited',2049,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"195090.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"195090.0000\"}}',NULL,'2023-12-12 13:46:49','2023-12-12 13:46:49'),(3227,'default','added',2119,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-12 13:49:26','2023-12-12 13:49:26'),(3228,'default','added',2120,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":164708.85000000000582076609134674072265625}}',NULL,'2023-12-12 13:56:13','2023-12-12 13:56:13'),(3229,'default','added',2122,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5749}}',NULL,'2023-12-12 14:03:58','2023-12-12 14:03:58'),(3230,'default','added',2124,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-12 14:08:01','2023-12-12 14:08:01'),(3231,'default','added',2125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":840000}}',NULL,'2023-12-12 14:17:15','2023-12-12 14:17:15'),(3232,'default','added',2126,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8640}}',NULL,'2023-12-12 14:19:54','2023-12-12 14:19:54'),(3233,'default','added',2127,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-12 14:35:07','2023-12-12 14:35:07'),(3234,'default','added',2128,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-12 14:35:20','2023-12-12 14:35:20'),(3235,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-12 17:29:05','2023-12-12 17:29:05'),(3236,'default','added',2129,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26041.5}}',NULL,'2023-12-12 17:36:29','2023-12-12 17:36:29'),(3237,'default','added',2130,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20020.3499999999985448084771633148193359375}}',NULL,'2023-12-12 17:38:41','2023-12-12 17:38:41'),(3238,'default','added',2131,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":124855}}',NULL,'2023-12-12 17:44:25','2023-12-12 17:44:25'),(3239,'default','added',2132,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22450}}',NULL,'2023-12-12 17:47:42','2023-12-12 17:47:42'),(3240,'default','added',2133,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-12 17:49:50','2023-12-12 17:49:50'),(3241,'default','payment_edited',1947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-12 17:51:27','2023-12-12 17:51:27'),(3242,'default','payment_edited',1299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-12 17:55:09','2023-12-12 17:55:09'),(3243,'default','payment_edited',1916,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"}}',NULL,'2023-12-12 17:55:09','2023-12-12 17:55:09'),(3244,'default','payment_edited',51,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-12 17:55:40','2023-12-12 17:55:40'),(3245,'default','payment_edited',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"251954.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"}}',NULL,'2023-12-12 18:01:03','2023-12-12 18:01:03'),(3246,'default','payment_edited',1614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"54060.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"54060.0000\"}}',NULL,'2023-12-12 18:01:03','2023-12-12 18:01:03'),(3247,'default','payment_edited',1701,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"48154.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"48154.0000\"}}',NULL,'2023-12-12 18:01:03','2023-12-12 18:01:03'),(3248,'default','payment_edited',1875,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"27170.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"27170.0000\"}}',NULL,'2023-12-12 18:01:03','2023-12-12 18:01:03'),(3249,'default','added',2134,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-12 18:07:23','2023-12-12 18:07:23'),(3250,'default','added',2135,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-12 18:33:42','2023-12-12 18:33:42'),(3251,'default','added',2136,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-12 19:46:22','2023-12-12 19:46:22'),(3252,'default','added',2137,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-12 19:47:34','2023-12-12 19:47:34'),(3253,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-12 19:50:53','2023-12-12 19:50:53'),(3254,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 10:26:44','2023-12-13 10:26:44'),(3255,'default','added',2138,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21020.15999999999985448084771633148193359375}}',NULL,'2023-12-13 10:34:55','2023-12-13 10:34:55'),(3256,'default','added',2139,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-13 10:37:23','2023-12-13 10:37:23'),(3257,'default','added',2140,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-12-13 10:39:40','2023-12-13 10:39:40'),(3258,'default','added',2141,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-13 10:43:09','2023-12-13 10:43:09'),(3259,'default','added',2142,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17800}}',NULL,'2023-12-13 10:48:16','2023-12-13 10:48:16'),(3260,'default','payment_edited',1720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6480.0000\"}}',NULL,'2023-12-13 10:54:14','2023-12-13 10:54:14'),(3261,'default','payment_edited',1761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4550.0000\"}}',NULL,'2023-12-13 10:54:14','2023-12-13 10:54:14'),(3262,'default','payment_edited',1713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3250.0000\"}}',NULL,'2023-12-13 10:55:14','2023-12-13 10:55:14'),(3263,'default','payment_edited',2103,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-12-13 10:55:31','2023-12-13 10:55:31'),(3264,'default','added',2143,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":86145}}',NULL,'2023-12-13 11:23:55','2023-12-13 11:23:55'),(3265,'default','added',2144,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-12-13 11:36:07','2023-12-13 11:36:07'),(3266,'default','added',2145,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6750}}',NULL,'2023-12-13 11:38:02','2023-12-13 11:38:02'),(3267,'default','added',2146,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10750}}',NULL,'2023-12-13 11:39:22','2023-12-13 11:39:22'),(3268,'default','added',2147,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-12-13 11:48:27','2023-12-13 11:48:27'),(3269,'default','added',2148,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-13 11:54:37','2023-12-13 11:54:37'),(3270,'default','payment_edited',1699,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"76725.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"76725.0000\"}}',NULL,'2023-12-13 12:19:37','2023-12-13 12:19:37'),(3271,'default','payment_edited',2048,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"51560.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"51560.0000\"}}',NULL,'2023-12-13 12:19:37','2023-12-13 12:19:37'),(3272,'default','added',2149,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-13 12:28:37','2023-12-13 12:28:37'),(3273,'default','added',2150,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-13 12:40:27','2023-12-13 12:40:27'),(3274,'default','added',2151,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-12-13 12:43:27','2023-12-13 12:43:27'),(3275,'default','added',2152,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-12-13 12:54:13','2023-12-13 12:54:13'),(3276,'default','added',2153,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-13 13:16:58','2023-12-13 13:16:58'),(3277,'default','added',126,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 13:18:00','2023-12-13 13:18:00'),(3278,'default','added',2154,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-13 13:18:14','2023-12-13 13:18:14'),(3279,'default','added',2155,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-13 13:31:13','2023-12-13 13:31:13'),(3280,'default','added',2156,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2250}}',NULL,'2023-12-13 13:47:58','2023-12-13 13:47:58'),(3281,'default','added',2157,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-12-13 14:15:03','2023-12-13 14:15:03'),(3282,'default','added',2158,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-13 14:23:03','2023-12-13 14:23:03'),(3283,'default','added',2159,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3220}}',NULL,'2023-12-13 14:26:01','2023-12-13 14:26:01'),(3284,'default','added',2160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":10836}}',NULL,'2023-12-13 14:28:35','2023-12-13 14:28:35'),(3285,'default','payment_edited',1536,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"107590.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"107590.0000\"}}',NULL,'2023-12-13 14:28:58','2023-12-13 14:28:58'),(3286,'default','payment_edited',1876,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"43000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"43000.0000\"}}',NULL,'2023-12-13 14:28:58','2023-12-13 14:28:58'),(3287,'default','added',2161,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-12-13 14:32:10','2023-12-13 14:32:10'),(3288,'default','added',2162,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-13 14:38:27','2023-12-13 14:38:27'),(3289,'default','added',2163,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":51790}}',NULL,'2023-12-13 14:44:10','2023-12-13 14:44:10'),(3290,'default','added',2164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2280}}',NULL,'2023-12-13 14:45:08','2023-12-13 14:45:08'),(3291,'default','added',2165,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1270}}',NULL,'2023-12-13 14:45:54','2023-12-13 14:45:54'),(3292,'default','added',2166,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-13 14:47:31','2023-12-13 14:47:31'),(3293,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 14:53:54','2023-12-13 14:53:54'),(3294,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 14:54:16','2023-12-13 14:54:16'),(3295,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 14:54:20','2023-12-13 14:54:20'),(3296,'default','added',2167,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-13 14:54:43','2023-12-13 14:54:43'),(3297,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 14:54:54','2023-12-13 14:54:54'),(3298,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 17:35:56','2023-12-13 17:35:56'),(3299,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 17:42:59','2023-12-13 17:42:59'),(3300,'default','added',2168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25189.360000000000582076609134674072265625}}',NULL,'2023-12-13 17:56:46','2023-12-13 17:56:46'),(3301,'default','payment_edited',1863,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7200.0000\"}}',NULL,'2023-12-13 17:57:40','2023-12-13 17:57:40'),(3302,'default','payment_edited',2075,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-13 17:57:40','2023-12-13 17:57:40'),(3303,'default','added',2169,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-13 18:00:57','2023-12-13 18:00:58'),(3304,'default','added',2170,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-13 18:02:42','2023-12-13 18:02:42'),(3305,'default','added',2171,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5800}}',NULL,'2023-12-13 18:03:36','2023-12-13 18:03:36'),(3306,'default','payment_edited',2154,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-13 18:15:12','2023-12-13 18:15:12'),(3307,'default','payment_edited',2024,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2950.0000\"}}',NULL,'2023-12-13 18:15:43','2023-12-13 18:15:43'),(3308,'default','added',2172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2950}}',NULL,'2023-12-13 18:16:31','2023-12-13 18:16:31'),(3309,'default','added',2173,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28248}}',NULL,'2023-12-13 18:18:31','2023-12-13 18:18:31'),(3310,'default','added',2174,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28248}}',NULL,'2023-12-13 18:18:39','2023-12-13 18:18:39'),(3311,'default','added',2175,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-13 18:19:59','2023-12-13 18:19:59'),(3312,'default','added',2176,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-12-13 18:21:32','2023-12-13 18:21:32'),(3313,'default','added',2177,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-13 18:28:01','2023-12-13 18:28:01'),(3314,'default','added',2178,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7920}}',NULL,'2023-12-13 18:35:22','2023-12-13 18:35:22'),(3315,'default','added',2179,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13990}}',NULL,'2023-12-13 18:44:47','2023-12-13 18:44:47'),(3316,'default','added',2180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10010}}',NULL,'2023-12-13 18:49:00','2023-12-13 18:49:00'),(3317,'default','added',2181,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-13 18:49:26','2023-12-13 18:49:26'),(3318,'default','added',2182,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8300}}',NULL,'2023-12-13 18:50:56','2023-12-13 18:50:56'),(3319,'default','added',2183,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4970}}',NULL,'2023-12-13 18:51:43','2023-12-13 18:51:43'),(3320,'default','added',2184,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-12-13 18:52:37','2023-12-13 18:52:37'),(3321,'default','added',2185,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-13 18:57:40','2023-12-13 18:57:40'),(3322,'default','added',2186,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-12-13 19:43:46','2023-12-13 19:43:46'),(3323,'default','added',2187,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4300}}',NULL,'2023-12-13 19:49:06','2023-12-13 19:49:06'),(3324,'default','payment_edited',1329,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4340.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4340.0000\"}}',NULL,'2023-12-13 19:49:19','2023-12-13 19:49:19'),(3325,'default','payment_edited',1950,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10050.0000\"}}',NULL,'2023-12-13 19:49:19','2023-12-13 19:49:19'),(3326,'default','added',2188,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1740}}',NULL,'2023-12-13 19:56:18','2023-12-13 19:56:18'),(3327,'default','added',2189,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-13 20:08:01','2023-12-13 20:08:01'),(3328,'default','added',2190,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-13 20:23:50','2023-12-13 20:23:50'),(3329,'default','added',2191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2230}}',NULL,'2023-12-13 20:25:58','2023-12-13 20:25:58'),(3330,'default','added',2192,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":260000}}',NULL,'2023-12-13 20:29:11','2023-12-13 20:29:11'),(3331,'default','added',2193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-13 20:35:06','2023-12-13 20:35:06'),(3332,'default','added',2194,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-13 20:36:03','2023-12-13 20:36:03'),(3333,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 20:36:41','2023-12-13 20:36:41'),(3334,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-13 22:49:15','2023-12-13 22:49:15'),(3335,'default','added',2195,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-13 22:52:22','2023-12-13 22:52:22'),(3336,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 10:46:50','2023-12-14 10:46:50'),(3337,'default','added',2196,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-14 10:47:41','2023-12-14 10:47:41'),(3338,'default','added',2197,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-14 10:56:21','2023-12-14 10:56:21'),(3339,'default','added',2198,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20400}}',NULL,'2023-12-14 11:00:23','2023-12-14 11:00:23'),(3340,'default','payment_edited',1761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4550.0000\"}}',NULL,'2023-12-14 11:01:52','2023-12-14 11:01:52'),(3341,'default','payment_edited',1830,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-14 11:01:52','2023-12-14 11:01:52'),(3342,'default','payment_edited',1713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3250.0000\"}}',NULL,'2023-12-14 11:02:16','2023-12-14 11:02:16'),(3343,'default','payment_edited',1779,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-14 11:02:16','2023-12-14 11:02:16'),(3344,'default','added',127,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 11:39:40','2023-12-14 11:39:40'),(3345,'default','added',2199,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5500}}',NULL,'2023-12-14 11:40:09','2023-12-14 11:40:09'),(3346,'default','added',2200,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24360}}',NULL,'2023-12-14 11:42:43','2023-12-14 11:42:43'),(3347,'default','added',2201,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19440}}',NULL,'2023-12-14 11:43:56','2023-12-14 11:43:56'),(3348,'default','added',2202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10880}}',NULL,'2023-12-14 11:50:17','2023-12-14 11:50:17'),(3349,'default','added',128,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 11:52:15','2023-12-14 11:52:15'),(3350,'default','added',2203,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-12-14 11:52:39','2023-12-14 11:52:39'),(3351,'default','added',2204,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-12-14 11:55:16','2023-12-14 11:55:16'),(3352,'default','payment_edited',2049,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"195090.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"195090.0000\"}}',NULL,'2023-12-14 11:58:08','2023-12-14 11:58:08'),(3353,'default','added',2205,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11400}}',NULL,'2023-12-14 12:14:12','2023-12-14 12:14:12'),(3354,'default','added',2206,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4960}}',NULL,'2023-12-14 12:17:03','2023-12-14 12:17:03'),(3355,'default','added',2207,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-12-14 12:27:11','2023-12-14 12:27:11'),(3356,'default','added',2208,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5760}}',NULL,'2023-12-14 12:36:40','2023-12-14 12:36:40'),(3357,'default','added',2209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3350}}',NULL,'2023-12-14 12:37:42','2023-12-14 12:37:42'),(3358,'default','payment_edited',2209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3350.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3350.0000\"}}',NULL,'2023-12-14 12:38:03','2023-12-14 12:38:03'),(3359,'default','added',2210,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-14 12:38:50','2023-12-14 12:38:50'),(3360,'default','added',2211,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20880}}',NULL,'2023-12-14 12:44:44','2023-12-14 12:44:44'),(3361,'default','added',2212,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-14 12:45:15','2023-12-14 12:45:15'),(3362,'default','added',2213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4590}}',NULL,'2023-12-14 12:48:33','2023-12-14 12:48:33'),(3363,'default','added',2214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-14 12:51:51','2023-12-14 12:51:51'),(3364,'default','added',2215,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-12-14 13:24:42','2023-12-14 13:24:42'),(3365,'default','added',2216,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":143800}}',NULL,'2023-12-14 13:28:44','2023-12-14 13:28:44'),(3366,'default','added',2217,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-12-14 14:03:46','2023-12-14 14:03:46'),(3367,'default','added',2218,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-14 14:11:38','2023-12-14 14:11:38'),(3368,'default','added',2219,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3300}}',NULL,'2023-12-14 14:14:00','2023-12-14 14:14:00'),(3369,'default','payment_edited',2219,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-12-14 14:14:28','2023-12-14 14:14:28'),(3370,'default','payment_edited',1746,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"842800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"842800.0000\"}}',NULL,'2023-12-14 14:19:17','2023-12-14 14:19:17'),(3371,'default','payment_edited',2125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"840000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"840000.0000\"}}',NULL,'2023-12-14 14:19:17','2023-12-14 14:19:17'),(3372,'default','added',2220,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-14 14:23:09','2023-12-14 14:23:09'),(3373,'default','added',2221,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5100}}',NULL,'2023-12-14 14:45:18','2023-12-14 14:45:18'),(3374,'default','added',2222,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-14 14:48:40','2023-12-14 14:48:40'),(3375,'default','added',2223,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-14 14:50:38','2023-12-14 14:50:38'),(3376,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 14:50:59','2023-12-14 14:50:59'),(3377,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 14:53:10','2023-12-14 14:53:10'),(3378,'default','added',2224,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-14 14:53:26','2023-12-14 14:53:26'),(3379,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 17:28:11','2023-12-14 17:28:11'),(3380,'default','payment_edited',231,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 17:36:03','2023-12-14 17:36:03'),(3381,'default','added',2225,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15551.600000000000363797880709171295166015625}}',NULL,'2023-12-14 17:44:34','2023-12-14 17:44:34'),(3382,'default','added',2226,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-12-14 17:45:31','2023-12-14 17:45:31'),(3383,'default','added',2227,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13597.20000000000072759576141834259033203125}}',NULL,'2023-12-14 17:56:51','2023-12-14 17:56:51'),(3384,'default','payment_edited',1947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-14 17:57:19','2023-12-14 17:57:19'),(3385,'default','added',2228,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7182}}',NULL,'2023-12-14 18:00:04','2023-12-14 18:00:04'),(3386,'default','added',2229,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":8700}}',NULL,'2023-12-14 18:00:42','2023-12-14 18:00:42'),(3387,'default','added',2230,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18089.13000000000101863406598567962646484375}}',NULL,'2023-12-14 18:02:05','2023-12-14 18:02:05'),(3388,'default','added',2231,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":540}}',NULL,'2023-12-14 18:02:52','2023-12-14 18:02:52'),(3389,'default','added',2232,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":540}}',NULL,'2023-12-14 18:03:33','2023-12-14 18:03:33'),(3390,'default','added',2233,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":104400}}',NULL,'2023-12-14 18:07:13','2023-12-14 18:07:13'),(3391,'default','added',2234,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-12-14 18:09:48','2023-12-14 18:09:48'),(3392,'default','added',2235,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7580}}',NULL,'2023-12-14 18:11:52','2023-12-14 18:11:52'),(3393,'default','added',2236,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-14 18:13:41','2023-12-14 18:13:41'),(3394,'default','added',2237,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6480}}',NULL,'2023-12-14 18:18:14','2023-12-14 18:18:14'),(3395,'default','added',2238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-14 18:19:08','2023-12-14 18:19:08'),(3396,'default','added',2239,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8100}}',NULL,'2023-12-14 18:21:38','2023-12-14 18:21:38'),(3397,'default','added',2240,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-12-14 18:22:36','2023-12-14 18:22:36'),(3398,'default','added',2241,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4730}}',NULL,'2023-12-14 18:22:58','2023-12-14 18:22:58'),(3399,'default','added',2242,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-14 18:38:26','2023-12-14 18:38:26'),(3400,'default','added',2243,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1700}}',NULL,'2023-12-14 18:46:43','2023-12-14 18:46:43'),(3401,'default','payment_edited',2243,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-14 18:47:14','2023-12-14 18:47:14'),(3402,'default','added',2244,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-14 18:48:08','2023-12-14 18:48:08'),(3403,'default','payment_edited',418,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 18:50:31','2023-12-14 18:50:31'),(3404,'default','payment_edited',419,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-14 18:50:31','2023-12-14 18:50:31'),(3405,'default','added',2245,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-14 18:51:09','2023-12-14 18:51:09'),(3406,'default','added',2246,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-14 19:06:26','2023-12-14 19:06:26'),(3407,'default','added',2247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-14 19:07:48','2023-12-14 19:07:48'),(3408,'default','added',2248,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1440}}',NULL,'2023-12-14 19:09:53','2023-12-14 19:09:53'),(3409,'default','added',2249,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-14 19:11:32','2023-12-14 19:11:32'),(3410,'default','added',2250,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-14 19:13:28','2023-12-14 19:13:28'),(3411,'default','payment_edited',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"}}',NULL,'2023-12-14 19:17:04','2023-12-14 19:17:04'),(3412,'default','added',2251,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-14 19:21:36','2023-12-14 19:21:36'),(3413,'default','added',2252,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-14 19:28:59','2023-12-14 19:28:59'),(3414,'default','added',2253,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7600}}',NULL,'2023-12-14 19:38:51','2023-12-14 19:38:51'),(3415,'default','added',2254,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4320}}',NULL,'2023-12-14 19:40:51','2023-12-14 19:40:51'),(3416,'default','added',2255,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-12-14 19:43:13','2023-12-14 19:43:13'),(3417,'default','added',2256,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-14 19:45:01','2023-12-14 19:45:01'),(3418,'default','added',2257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22800}}',NULL,'2023-12-14 19:54:11','2023-12-14 19:54:11'),(3419,'default','added',2258,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-14 19:55:13','2023-12-14 19:55:13'),(3420,'default','added',2259,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5800}}',NULL,'2023-12-14 19:57:22','2023-12-14 19:57:22'),(3421,'default','added',2260,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-14 20:01:03','2023-12-14 20:01:03'),(3422,'default','added',2261,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-14 20:32:25','2023-12-14 20:32:25'),(3423,'default','added',2262,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-14 20:34:21','2023-12-14 20:34:21'),(3424,'default','added',2263,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-14 20:34:43','2023-12-14 20:34:43'),(3425,'default','added',2264,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-14 20:35:21','2023-12-14 20:35:21'),(3426,'default','added',2265,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-14 20:36:26','2023-12-14 20:36:26'),(3427,'default','added',2266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2230}}',NULL,'2023-12-14 20:37:02','2023-12-14 20:37:02'),(3428,'default','payment_edited',2266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2230.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2230.0000\"}}',NULL,'2023-12-14 20:37:20','2023-12-14 20:37:20'),(3429,'default','payment_edited',2203,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-14 20:47:23','2023-12-14 20:47:23'),(3430,'default','added',2267,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-14 20:52:50','2023-12-14 20:52:50'),(3431,'default','added',2268,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-14 20:54:22','2023-12-14 20:54:22'),(3432,'default','added',2269,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-12-14 21:05:31','2023-12-14 21:05:31'),(3433,'default','added',2270,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10850}}',NULL,'2023-12-14 21:17:35','2023-12-14 21:17:35'),(3434,'default','added',2271,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6450}}',NULL,'2023-12-14 21:18:10','2023-12-14 21:18:10'),(3435,'default','payment_edited',2269,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-12-14 21:20:09','2023-12-14 21:20:09'),(3436,'default','added',2272,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-12-14 21:20:42','2023-12-14 21:20:42'),(3437,'default','added',2273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2800}}',NULL,'2023-12-14 21:25:09','2023-12-14 21:25:09'),(3438,'default','payment_edited',2273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-12-14 21:25:31','2023-12-14 21:25:31'),(3439,'default','added',2274,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-14 21:39:45','2023-12-14 21:39:45'),(3440,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-14 21:45:03','2023-12-14 21:45:03'),(3441,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 00:19:02','2023-12-16 00:19:02'),(3442,'default','added',2275,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-16 00:19:40','2023-12-16 00:19:40'),(3443,'default','added',2276,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-16 00:20:10','2023-12-16 00:20:10'),(3444,'default','added',2277,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-16 00:20:34','2023-12-16 00:20:34'),(3445,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 10:37:47','2023-12-16 10:37:47'),(3446,'default','added',2278,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-12-16 10:40:05','2023-12-16 10:40:05'),(3447,'default','payment_edited',1956,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2700.0000\"}}',NULL,'2023-12-16 10:42:21','2023-12-16 10:42:21'),(3448,'default','payment_edited',2053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-16 10:42:38','2023-12-16 10:42:38'),(3449,'default','payment_edited',1779,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-16 10:42:55','2023-12-16 10:42:55'),(3450,'default','payment_edited',1881,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-16 10:42:55','2023-12-16 10:42:55'),(3451,'default','added',2279,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11400}}',NULL,'2023-12-16 10:53:06','2023-12-16 10:53:06'),(3452,'default','added',2280,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-12-16 10:54:21','2023-12-16 10:54:21'),(3453,'default','added',2281,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-12-16 11:18:23','2023-12-16 11:18:23'),(3454,'default','added',2282,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-16 11:20:11','2023-12-16 11:20:11'),(3455,'default','payment_edited',2229,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8700.0000\"}}',NULL,'2023-12-16 11:26:21','2023-12-16 11:26:21'),(3456,'default','added',2283,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":42440}}',NULL,'2023-12-16 11:30:08','2023-12-16 11:30:08'),(3457,'default','payment_edited',1830,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-16 11:45:40','2023-12-16 11:45:40'),(3458,'default','payment_edited',1857,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8750.0000\"}}',NULL,'2023-12-16 11:45:40','2023-12-16 11:45:40'),(3459,'default','added',2284,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5970.0399999999999636202119290828704833984375}}',NULL,'2023-12-16 11:48:07','2023-12-16 11:48:07'),(3460,'default','added',129,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 11:50:51','2023-12-16 11:50:51'),(3461,'default','added',2285,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2700}}',NULL,'2023-12-16 11:51:10','2023-12-16 11:51:10'),(3462,'default','added',2286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-12-16 11:52:00','2023-12-16 11:52:00'),(3463,'default','added',2287,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7150}}',NULL,'2023-12-16 11:54:44','2023-12-16 11:54:44'),(3464,'default','payment_edited',254,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 12:16:38','2023-12-16 12:16:38'),(3465,'default','payment_edited',255,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-16 12:16:38','2023-12-16 12:16:38'),(3466,'default','added',2288,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2050}}',NULL,'2023-12-16 12:22:11','2023-12-16 12:22:11'),(3467,'default','added',2289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12000}}',NULL,'2023-12-16 12:23:19','2023-12-16 12:23:19'),(3468,'default','added',130,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 12:24:30','2023-12-16 12:24:30'),(3469,'default','added',2290,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-12-16 12:24:49','2023-12-16 12:24:49'),(3470,'default','added',2291,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-16 12:34:17','2023-12-16 12:34:17'),(3471,'default','added',2292,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-16 12:35:14','2023-12-16 12:35:14'),(3472,'default','added',2293,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-16 12:35:50','2023-12-16 12:35:50'),(3473,'default','added',2294,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-16 12:48:49','2023-12-16 12:48:49'),(3474,'default','added',2295,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-16 12:49:33','2023-12-16 12:49:33'),(3475,'default','added',2296,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-16 12:50:50','2023-12-16 12:50:50'),(3476,'default','added',2297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-16 12:51:50','2023-12-16 12:51:50'),(3477,'default','added',2298,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-16 12:53:25','2023-12-16 12:53:25'),(3478,'default','added',2299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-12-16 13:16:58','2023-12-16 13:16:58'),(3479,'default','added',2300,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-12-16 13:17:50','2023-12-16 13:17:50'),(3480,'default','payment_edited',121,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-16 13:22:17','2023-12-16 13:22:17'),(3481,'default','added',2301,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":14400}}',NULL,'2023-12-16 13:23:06','2023-12-16 13:23:06'),(3482,'default','added',2302,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5760}}',NULL,'2023-12-16 13:27:35','2023-12-16 13:27:35'),(3483,'default','added',2303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":173255.39999999999417923390865325927734375}}',NULL,'2023-12-16 13:31:37','2023-12-16 13:31:37'),(3484,'default','payment_edited',1266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-16 13:32:44','2023-12-16 13:32:44'),(3485,'default','added',2304,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-12-16 13:34:01','2023-12-16 13:34:01'),(3486,'default','added',2305,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-12-16 13:35:08','2023-12-16 13:35:08'),(3487,'default','added',2306,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-12-16 13:36:40','2023-12-16 13:36:40'),(3488,'default','added',2307,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-12-16 13:37:52','2023-12-16 13:37:52'),(3489,'default','payment_edited',865,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-12-16 13:40:01','2023-12-16 13:40:01'),(3490,'default','added',2308,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-12-16 13:51:24','2023-12-16 13:51:24'),(3491,'default','added',2309,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-16 13:55:47','2023-12-16 13:55:47'),(3492,'default','added',2310,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1270}}',NULL,'2023-12-16 14:08:05','2023-12-16 14:08:05'),(3493,'default','payment_edited',1947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-16 14:17:11','2023-12-16 14:17:11'),(3494,'default','added',2311,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-12-16 14:22:29','2023-12-16 14:22:29'),(3495,'default','added',2312,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-12-16 14:24:48','2023-12-16 14:24:48'),(3496,'default','added',2313,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-12-16 14:30:57','2023-12-16 14:30:57'),(3497,'default','added',2314,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-12-16 14:50:53','2023-12-16 14:50:53'),(3498,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 14:56:00','2023-12-16 14:56:00'),(3499,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 16:04:49','2023-12-16 16:04:49'),(3500,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 17:06:17','2023-12-16 17:06:17'),(3501,'default','added',2315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":833100}}',NULL,'2023-12-16 17:15:34','2023-12-16 17:15:34'),(3502,'default','added',2316,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27638.4000000000014551915228366851806640625}}',NULL,'2023-12-16 17:17:51','2023-12-16 17:17:51'),(3503,'default','edited',2315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":831000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"833100.0000\"}}',NULL,'2023-12-16 17:23:52','2023-12-16 17:23:52'),(3504,'default','added',2317,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-16 17:27:50','2023-12-16 17:27:50'),(3505,'default','added',2318,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-16 17:56:06','2023-12-16 17:56:06'),(3506,'default','payment_edited',2315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"831000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"831000.0000\"}}',NULL,'2023-12-16 17:57:22','2023-12-16 17:57:22'),(3507,'default','payment_edited',1881,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-16 18:03:59','2023-12-16 18:03:59'),(3508,'default','payment_edited',1912,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-16 18:03:59','2023-12-16 18:03:59'),(3509,'default','added',2319,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":936}}',NULL,'2023-12-16 18:09:56','2023-12-16 18:09:56'),(3510,'default','added',2320,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11500}}',NULL,'2023-12-16 18:12:01','2023-12-16 18:12:01'),(3511,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 18:13:35','2023-12-16 18:13:35'),(3512,'default','added',131,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 18:14:35','2023-12-16 18:14:35'),(3513,'default','added',2322,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-16 18:19:32','2023-12-16 18:19:32'),(3514,'default','added',2323,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5510}}',NULL,'2023-12-16 18:42:09','2023-12-16 18:42:09'),(3515,'default','added',2324,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-16 18:44:05','2023-12-16 18:44:05'),(3516,'default','payment_edited',1965,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"63105.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"63105.0000\"}}',NULL,'2023-12-16 19:09:24','2023-12-16 19:09:24'),(3517,'default','payment_edited',2047,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"41740.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"41740.0000\"}}',NULL,'2023-12-16 19:09:24','2023-12-16 19:09:24'),(3518,'default','payment_edited',2172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2950.0000\"}}',NULL,'2023-12-16 19:13:19','2023-12-16 19:13:19'),(3519,'default','edited',51,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 19:18:11','2023-12-16 19:18:11'),(3520,'default','edited',51,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 19:19:47','2023-12-16 19:19:47'),(3521,'default','added',2325,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2950}}',NULL,'2023-12-16 19:20:16','2023-12-16 19:20:16'),(3522,'default','edited',129,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 19:35:12','2023-12-16 19:35:12'),(3523,'default','added',2326,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-12-16 19:36:42','2023-12-16 19:36:42'),(3524,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-16 19:57:02','2023-12-16 19:57:02'),(3525,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-17 10:24:33','2023-12-17 10:24:33'),(3526,'default','payment_edited',2169,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-17 10:28:38','2023-12-17 10:28:38'),(3527,'default','payment_edited',1912,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-17 10:29:27','2023-12-17 10:29:27'),(3528,'default','payment_edited',1945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-12-17 10:29:27','2023-12-17 10:29:27'),(3529,'default','payment_edited',2053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-17 10:29:49','2023-12-17 10:29:49'),(3530,'default','payment_edited',1857,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8750.0000\"}}',NULL,'2023-12-17 10:31:26','2023-12-17 10:31:26'),(3531,'default','payment_edited',1939,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-12-17 10:31:26','2023-12-17 10:31:26'),(3532,'default','added',2327,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-17 10:34:28','2023-12-17 10:34:28'),(3533,'default','added',2328,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-17 11:57:10','2023-12-17 11:57:10'),(3534,'default','added',2329,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-17 11:57:38','2023-12-17 11:57:38'),(3535,'default','added',2330,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-17 11:59:07','2023-12-17 11:59:07'),(3536,'default','added',2331,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-17 12:00:27','2023-12-17 12:00:27'),(3537,'default','added',2332,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6550}}',NULL,'2023-12-17 12:01:06','2023-12-17 12:01:06'),(3538,'default','added',2333,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-12-17 12:01:51','2023-12-17 12:01:51'),(3539,'default','added',2334,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11780}}',NULL,'2023-12-17 12:02:55','2023-12-17 12:02:55'),(3540,'default','added',2335,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12400}}',NULL,'2023-12-17 12:05:01','2023-12-17 12:05:01'),(3541,'default','added',2336,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-12-17 12:05:53','2023-12-17 12:05:53'),(3542,'default','added',2337,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7880}}',NULL,'2023-12-17 12:07:24','2023-12-17 12:07:24'),(3543,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-17 14:41:24','2023-12-17 14:41:24'),(3544,'default','payment_edited',2125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"840000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"840000.0000\"}}',NULL,'2023-12-17 14:42:51','2023-12-17 14:42:51'),(3545,'default','payment_edited',1696,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"35280.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"35280.0000\"}}',NULL,'2023-12-17 14:43:26','2023-12-17 14:43:26'),(3546,'default','added',2338,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12730}}',NULL,'2023-12-17 14:46:47','2023-12-17 14:46:47'),(3547,'default','added',2339,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-17 14:47:30','2023-12-17 14:47:30'),(3548,'default','edited',2339,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-17 14:47:51','2023-12-17 14:47:51'),(3549,'default','added',2340,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-17 14:48:21','2023-12-17 14:48:21'),(3550,'default','added',2341,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550}}',NULL,'2023-12-17 14:48:46','2023-12-17 14:48:46'),(3551,'default','added',2342,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-17 15:01:38','2023-12-17 15:01:38'),(3552,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-17 17:25:02','2023-12-17 17:25:02'),(3553,'default','payment_edited',1947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-17 17:31:09','2023-12-17 17:31:09'),(3554,'default','added',2343,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-17 17:43:26','2023-12-17 17:43:26'),(3555,'default','added',2344,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-17 17:43:58','2023-12-17 17:43:58'),(3556,'default','payment_edited',1875,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"27170.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"27170.0000\"}}',NULL,'2023-12-17 17:51:04','2023-12-17 17:51:04'),(3557,'default','payment_edited',1963,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"14348.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"14348.0000\"}}',NULL,'2023-12-17 17:51:04','2023-12-17 17:51:04'),(3558,'default','payment_edited',2131,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"124855.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"124855.0000\"}}',NULL,'2023-12-17 17:51:04','2023-12-17 17:51:04'),(3559,'default','added',2345,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":161140}}',NULL,'2023-12-17 17:53:12','2023-12-17 17:53:12'),(3560,'default','added',2346,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":58617}}',NULL,'2023-12-17 17:59:36','2023-12-17 17:59:36'),(3561,'default','added',2347,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-17 18:00:56','2023-12-17 18:00:56'),(3562,'default','added',2348,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-12-17 18:01:21','2023-12-17 18:01:21'),(3563,'default','added',2349,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":41540}}',NULL,'2023-12-17 18:05:40','2023-12-17 18:05:40'),(3564,'default','added',2350,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":18970}}',NULL,'2023-12-17 18:06:50','2023-12-17 18:06:50'),(3565,'default','added',2351,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-17 18:07:59','2023-12-17 18:07:59'),(3566,'default','added',2352,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-17 18:09:52','2023-12-17 18:09:52'),(3567,'default','added',2353,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16960}}',NULL,'2023-12-17 18:11:11','2023-12-17 18:11:11'),(3568,'default','added',2354,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5680}}',NULL,'2023-12-17 18:13:27','2023-12-17 18:13:27'),(3569,'default','added',2355,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-17 18:18:32','2023-12-17 18:18:32'),(3570,'default','added',2356,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":13432}}',NULL,'2023-12-17 18:29:35','2023-12-17 18:29:35'),(3571,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-17 18:42:38','2023-12-17 18:42:38'),(3572,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-17 23:37:46','2023-12-17 23:37:46'),(3573,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 09:50:59','2023-12-18 09:50:59'),(3574,'default','added',2357,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-18 09:57:40','2023-12-18 09:57:40'),(3575,'default','added',2358,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-18 10:03:33','2023-12-18 10:03:33'),(3576,'default','payment_edited',1939,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-12-18 10:19:08','2023-12-18 10:19:08'),(3577,'default','payment_edited',1990,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10450.0000\"}}',NULL,'2023-12-18 10:19:08','2023-12-18 10:19:08'),(3578,'default','added',2359,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-18 10:24:42','2023-12-18 10:24:42'),(3579,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 10:28:24','2023-12-18 10:28:24'),(3580,'default','added',2360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-18 10:36:59','2023-12-18 10:36:59'),(3581,'default','added',2361,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-18 10:39:20','2023-12-18 10:39:20'),(3582,'default','added',2362,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":23100}}',NULL,'2023-12-18 10:48:34','2023-12-18 10:48:34'),(3583,'default','payment_edited',2362,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"23100.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"23100.0000\"}}',NULL,'2023-12-18 10:48:55','2023-12-18 10:48:55'),(3584,'default','added',2363,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8000}}',NULL,'2023-12-18 11:01:10','2023-12-18 11:01:10'),(3585,'default','added',2364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-12-18 11:05:58','2023-12-18 11:05:58'),(3586,'default','added',2365,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-12-18 11:14:39','2023-12-18 11:14:39'),(3587,'default','payment_edited',2290,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-12-18 11:16:11','2023-12-18 11:16:11'),(3588,'default','payment_edited',2341,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-18 11:16:29','2023-12-18 11:16:29'),(3589,'default','payment_edited',1945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2250.0000\"}}',NULL,'2023-12-18 11:17:06','2023-12-18 11:17:06'),(3590,'default','added',2366,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8600}}',NULL,'2023-12-18 11:38:13','2023-12-18 11:38:13'),(3591,'default','added',2367,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-12-18 11:50:21','2023-12-18 11:50:21'),(3592,'default','added',2368,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-12-18 11:57:22','2023-12-18 11:57:22'),(3593,'default','edited',2368,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":3600},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"}}',NULL,'2023-12-18 11:59:41','2023-12-18 11:59:41'),(3594,'default','added',2369,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4800}}',NULL,'2023-12-18 12:01:24','2023-12-18 12:01:24'),(3595,'default','added',2370,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-18 12:16:00','2023-12-18 12:16:00'),(3596,'default','added',2371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-18 12:22:01','2023-12-18 12:22:01'),(3597,'default','added',2372,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-18 12:26:19','2023-12-18 12:26:19'),(3598,'default','added',2373,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16450}}',NULL,'2023-12-18 12:28:04','2023-12-18 12:28:04'),(3599,'default','added',2374,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-18 12:29:41','2023-12-18 12:29:41'),(3600,'default','added',2375,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-18 12:30:48','2023-12-18 12:30:48'),(3601,'default','added',132,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 12:44:08','2023-12-18 12:44:08'),(3602,'default','added',2376,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7900}}',NULL,'2023-12-18 12:45:33','2023-12-18 12:45:33'),(3603,'default','added',2377,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-18 13:23:58','2023-12-18 13:23:58'),(3604,'default','added',2378,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":812000}}',NULL,'2023-12-18 13:28:20','2023-12-18 13:28:20'),(3605,'default','payment_edited',2125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"840000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"840000.0000\"}}',NULL,'2023-12-18 13:32:41','2023-12-18 13:32:41'),(3606,'default','payment_edited',2378,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"812000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"812000.0000\"}}',NULL,'2023-12-18 13:32:41','2023-12-18 13:32:41'),(3607,'default','added',2379,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 13:33:50','2023-12-18 13:33:50'),(3608,'default','added',2380,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 13:35:15','2023-12-18 13:35:15'),(3609,'default','added',2381,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2375}}',NULL,'2023-12-18 13:36:37','2023-12-18 13:36:37'),(3610,'default','added',2382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 13:40:45','2023-12-18 13:40:45'),(3611,'default','edited',2380,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"}}',NULL,'2023-12-18 13:43:07','2023-12-18 13:43:07'),(3612,'default','added',2383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 13:44:08','2023-12-18 13:44:08'),(3613,'default','added',2384,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-18 13:44:40','2023-12-18 13:44:40'),(3614,'default','payment_edited',2315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"831000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"831000.0000\"}}',NULL,'2023-12-18 14:08:17','2023-12-18 14:08:17'),(3615,'default','added',2385,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9900}}',NULL,'2023-12-18 14:14:19','2023-12-18 14:14:19'),(3616,'default','added',2386,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-18 14:27:21','2023-12-18 14:27:21'),(3617,'default','added',2387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8200}}',NULL,'2023-12-18 14:34:42','2023-12-18 14:34:42'),(3618,'default','added',2388,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-18 14:47:23','2023-12-18 14:47:23'),(3619,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 18:00:12','2023-12-18 18:00:12'),(3620,'default','added',2389,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":61000}}',NULL,'2023-12-18 18:04:33','2023-12-18 18:04:33'),(3621,'default','added',2390,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":29550}}',NULL,'2023-12-18 18:15:03','2023-12-18 18:15:03'),(3622,'default','added',2391,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":53540}}',NULL,'2023-12-18 18:16:31','2023-12-18 18:16:31'),(3623,'default','added',2392,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 18:18:18','2023-12-18 18:18:18'),(3624,'default','added',2393,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 18:20:38','2023-12-18 18:20:38'),(3625,'default','added',2394,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2375}}',NULL,'2023-12-18 18:25:28','2023-12-18 18:25:28'),(3626,'default','added',2395,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1840}}',NULL,'2023-12-18 18:28:12','2023-12-18 18:28:12'),(3627,'default','added',2396,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-18 18:29:01','2023-12-18 18:29:01'),(3628,'default','payment_edited',2023,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-18 18:29:24','2023-12-18 18:29:24'),(3629,'default','added',2397,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":112200}}',NULL,'2023-12-18 18:31:15','2023-12-18 18:31:15'),(3630,'default','added',2398,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":666}}',NULL,'2023-12-18 18:32:30','2023-12-18 18:32:30'),(3631,'default','added',2399,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2880}}',NULL,'2023-12-18 18:33:37','2023-12-18 18:33:37'),(3632,'default','added',2400,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36540}}',NULL,'2023-12-18 18:37:45','2023-12-18 18:37:45'),(3633,'default','added',2401,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8007}}',NULL,'2023-12-18 18:41:13','2023-12-18 18:41:13'),(3634,'default','added',2402,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2023-12-18 18:44:06','2023-12-18 18:44:06'),(3635,'default','added',2403,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6880}}',NULL,'2023-12-18 18:45:16','2023-12-18 18:45:16'),(3636,'default','payment_edited',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"}}',NULL,'2023-12-18 18:45:56','2023-12-18 18:45:56'),(3637,'default','added',2404,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14980}}',NULL,'2023-12-18 18:48:11','2023-12-18 18:48:11'),(3638,'default','added',2405,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8450}}',NULL,'2023-12-18 18:48:48','2023-12-18 18:48:48'),(3639,'default','added',2406,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8200}}',NULL,'2023-12-18 18:49:44','2023-12-18 18:49:44'),(3640,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 18:57:23','2023-12-18 18:57:23'),(3641,'default','added',2407,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-18 19:35:41','2023-12-18 19:35:41'),(3642,'default','added',2408,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-18 19:42:25','2023-12-18 19:42:25'),(3643,'default','added',2409,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24550}}',NULL,'2023-12-18 19:49:02','2023-12-18 19:49:02'),(3644,'default','added',2410,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":11650}}',NULL,'2023-12-18 19:50:24','2023-12-18 19:50:24'),(3645,'default','added',2411,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-18 20:02:41','2023-12-18 20:02:41'),(3646,'default','edited',2411,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-18 20:03:16','2023-12-18 20:03:16'),(3647,'default','added',2412,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 20:06:50','2023-12-18 20:06:50'),(3648,'default','added',2413,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5850}}',NULL,'2023-12-18 20:11:18','2023-12-18 20:11:18'),(3649,'default','added',2414,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":57000}}',NULL,'2023-12-18 20:19:17','2023-12-18 20:19:17'),(3650,'default','added',2415,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7752}}',NULL,'2023-12-18 20:23:27','2023-12-18 20:23:27'),(3651,'default','added',2416,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-18 20:34:40','2023-12-18 20:34:40'),(3652,'default','added',2417,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-18 20:43:28','2023-12-18 20:43:28'),(3653,'default','added',2418,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":475}}',NULL,'2023-12-18 20:44:18','2023-12-18 20:44:18'),(3654,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 20:48:31','2023-12-18 20:48:31'),(3655,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 20:49:42','2023-12-18 20:49:42'),(3656,'default','added',2419,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-18 20:50:29','2023-12-18 20:50:29'),(3657,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 20:50:36','2023-12-18 20:50:36'),(3658,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-18 23:53:16','2023-12-18 23:53:16'),(3659,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-19 08:50:26','2023-12-19 08:50:26'),(3660,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-19 10:29:13','2023-12-19 10:29:13'),(3661,'default','added',2420,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-19 10:31:56','2023-12-19 10:31:56'),(3662,'default','added',2421,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7000}}',NULL,'2023-12-19 10:35:00','2023-12-19 10:35:00'),(3663,'default','added',2422,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-19 10:38:47','2023-12-19 10:38:47'),(3664,'default','added',2423,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-19 11:07:24','2023-12-19 11:07:24'),(3665,'default','added',2424,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-19 12:17:34','2023-12-19 12:17:34'),(3666,'default','payment_edited',1990,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10450.0000\"}}',NULL,'2023-12-19 12:24:47','2023-12-19 12:24:47'),(3667,'default','payment_edited',2071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10530.0000\"}}',NULL,'2023-12-19 12:24:47','2023-12-19 12:24:47'),(3668,'default','added',2425,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-19 12:30:07','2023-12-19 12:30:07'),(3669,'default','added',2426,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-19 12:34:30','2023-12-19 12:34:30'),(3670,'default','added',2427,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3570}}',NULL,'2023-12-19 12:40:28','2023-12-19 12:40:28'),(3671,'default','added',2428,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":137750}}',NULL,'2023-12-19 12:42:31','2023-12-19 12:42:31'),(3672,'default','added',2429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-12-19 12:45:17','2023-12-19 12:45:17'),(3673,'default','added',2430,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-19 12:46:32','2023-12-19 12:46:32'),(3674,'default','added',2431,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-19 13:43:53','2023-12-19 13:43:53'),(3675,'default','added',2432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-12-19 13:44:17','2023-12-19 13:44:17'),(3676,'default','added',2433,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-19 13:49:59','2023-12-19 13:49:59'),(3677,'default','payment_edited',2286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-12-19 13:52:13','2023-12-19 13:52:13'),(3678,'default','payment_edited',1945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2250.0000\"}}',NULL,'2023-12-19 13:52:30','2023-12-19 13:52:30'),(3679,'default','payment_edited',2013,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-19 13:52:30','2023-12-19 13:52:30'),(3680,'default','payment_edited',2053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-19 13:52:49','2023-12-19 13:52:49'),(3681,'default','added',2434,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-19 14:02:25','2023-12-19 14:02:25'),(3682,'default','added',133,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-19 14:10:20','2023-12-19 14:10:20'),(3683,'default','added',2435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-19 14:20:04','2023-12-19 14:20:04'),(3684,'default','edited',2435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3350.0000\"}}',NULL,'2023-12-19 14:21:52','2023-12-19 14:21:52'),(3685,'default','added',2436,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":55698}}',NULL,'2023-12-19 14:33:50','2023-12-19 14:33:50'),(3686,'default','added',2437,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-19 14:34:51','2023-12-19 14:34:51'),(3687,'default','added',2438,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":57240}}',NULL,'2023-12-19 14:38:43','2023-12-19 14:38:43'),(3688,'default','added',2439,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-19 14:58:34','2023-12-19 14:58:34'),(3689,'default','payment_edited',1266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-19 15:04:35','2023-12-19 15:04:35'),(3690,'default','payment_edited',1723,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-12-19 15:04:35','2023-12-19 15:04:35'),(3691,'default','added',2440,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13080}}',NULL,'2023-12-19 15:09:58','2023-12-19 15:09:58'),(3692,'default','added',2441,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-12-19 15:21:35','2023-12-19 15:21:35'),(3693,'default','added',2442,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-19 17:08:59','2023-12-19 17:08:59'),(3694,'default','added',2443,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-12-19 17:10:44','2023-12-19 17:10:44'),(3695,'default','added',2444,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-19 17:18:44','2023-12-19 17:18:44'),(3696,'default','added',2445,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10060}}',NULL,'2023-12-19 17:21:20','2023-12-19 17:21:20'),(3697,'default','added',2446,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6930}}',NULL,'2023-12-19 17:22:31','2023-12-19 17:22:31'),(3698,'default','added',2447,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-19 17:23:46','2023-12-19 17:23:46'),(3699,'default','added',134,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-19 17:25:07','2023-12-19 17:25:07'),(3700,'default','added',2448,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":8000}}',NULL,'2023-12-19 17:25:45','2023-12-19 17:25:45'),(3701,'default','added',2449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6070}}',NULL,'2023-12-19 17:27:09','2023-12-19 17:27:09'),(3702,'default','added',2450,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10200}}',NULL,'2023-12-19 17:31:55','2023-12-19 17:31:55'),(3703,'default','added',2451,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-19 17:34:42','2023-12-19 17:34:42'),(3704,'default','added',2452,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":192600.4500000000116415321826934814453125}}',NULL,'2023-12-19 17:59:31','2023-12-19 17:59:31'),(3705,'default','added',2453,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-12-19 18:05:56','2023-12-19 18:05:56'),(3706,'default','added',2454,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-19 18:06:14','2023-12-19 18:06:14'),(3707,'default','added',2455,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":23000}}',NULL,'2023-12-19 18:08:47','2023-12-19 18:08:47'),(3708,'default','added',2456,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22318}}',NULL,'2023-12-19 18:13:43','2023-12-19 18:13:43'),(3709,'default','added',2457,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-12-19 18:16:31','2023-12-19 18:16:31'),(3710,'default','added',2458,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-19 18:23:31','2023-12-19 18:23:31'),(3711,'default','payment_edited',2315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"831000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"831000.0000\"}}',NULL,'2023-12-19 18:43:41','2023-12-19 18:43:41'),(3712,'default','added',2459,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-19 18:53:28','2023-12-19 18:53:28'),(3713,'default','added',2460,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-19 19:03:15','2023-12-19 19:03:15'),(3714,'default','added',2461,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-19 19:07:52','2023-12-19 19:07:52'),(3715,'default','added',2462,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":102600}}',NULL,'2023-12-19 19:11:11','2023-12-19 19:11:11'),(3716,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-19 19:12:41','2023-12-19 19:12:41'),(3717,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 10:39:24','2023-12-20 10:39:24'),(3718,'default','payment_edited',2013,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-20 10:40:14','2023-12-20 10:40:14'),(3719,'default','payment_edited',2065,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-20 10:40:14','2023-12-20 10:40:14'),(3720,'default','payment_edited',2053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-20 10:40:47','2023-12-20 10:40:47'),(3721,'default','added',2463,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5980}}',NULL,'2023-12-20 10:42:16','2023-12-20 10:42:16'),(3722,'default','added',2464,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12450}}',NULL,'2023-12-20 10:44:29','2023-12-20 10:44:29'),(3723,'default','added',2465,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10740}}',NULL,'2023-12-20 10:45:52','2023-12-20 10:45:52'),(3724,'default','added',2466,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-12-20 10:46:24','2023-12-20 10:46:24'),(3725,'default','added',2467,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28500}}',NULL,'2023-12-20 10:51:25','2023-12-20 10:51:25'),(3726,'default','payment_edited',134,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 10:53:37','2023-12-20 10:53:37'),(3727,'default','added',2468,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-20 10:54:17','2023-12-20 10:54:17'),(3728,'default','payment_edited',2071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10530.0000\"}}',NULL,'2023-12-20 11:08:08','2023-12-20 11:08:08'),(3729,'default','added',2469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7530}}',NULL,'2023-12-20 11:11:29','2023-12-20 11:11:29'),(3730,'default','added',2470,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-20 11:12:23','2023-12-20 11:12:23'),(3731,'default','added',2471,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-12-20 11:13:33','2023-12-20 11:13:33'),(3732,'default','added',2472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8400}}',NULL,'2023-12-20 11:14:52','2023-12-20 11:14:52'),(3733,'default','added',2473,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2940}}',NULL,'2023-12-20 11:19:33','2023-12-20 11:19:33'),(3734,'default','added',2474,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2964}}',NULL,'2023-12-20 11:21:27','2023-12-20 11:21:27'),(3735,'default','added',2475,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53391}}',NULL,'2023-12-20 11:25:56','2023-12-20 11:25:56'),(3736,'default','added',2476,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-20 11:35:54','2023-12-20 11:35:54'),(3737,'default','added',2477,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-20 11:54:05','2023-12-20 11:54:05'),(3738,'default','payment_edited',2378,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"812000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"812000.0000\"}}',NULL,'2023-12-20 11:57:20','2023-12-20 11:57:20'),(3739,'default','payment_edited',2448,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8000.0000\"}}',NULL,'2023-12-20 12:15:06','2023-12-20 12:15:06'),(3740,'default','added',2478,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-20 12:53:02','2023-12-20 12:53:02'),(3741,'default','added',2479,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-20 12:53:17','2023-12-20 12:53:17'),(3742,'default','added',2480,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":56448}}',NULL,'2023-12-20 12:54:43','2023-12-20 12:54:43'),(3743,'default','payment_edited',2048,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"51560.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"51560.0000\"}}',NULL,'2023-12-20 12:55:42','2023-12-20 12:55:42'),(3744,'default','payment_edited',2480,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"56448.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"56448.0000\"}}',NULL,'2023-12-20 12:55:42','2023-12-20 12:55:42'),(3745,'default','added',2481,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-20 13:37:17','2023-12-20 13:37:17'),(3746,'default','added',2482,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1950}}',NULL,'2023-12-20 13:38:56','2023-12-20 13:38:56'),(3747,'default','added',2483,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-12-20 13:47:54','2023-12-20 13:47:54'),(3748,'default','added',2484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-20 14:03:48','2023-12-20 14:03:48'),(3749,'default','added',2485,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-20 14:23:27','2023-12-20 14:23:27'),(3750,'default','added',2486,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-20 14:25:49','2023-12-20 14:25:49'),(3751,'default','added',2487,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-20 14:29:11','2023-12-20 14:29:11'),(3752,'default','added',2488,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2530}}',NULL,'2023-12-20 14:35:59','2023-12-20 14:35:59'),(3753,'default','added',2489,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-20 14:36:44','2023-12-20 14:36:44'),(3754,'default','added',2490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-12-20 14:40:50','2023-12-20 14:40:50'),(3755,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 14:51:49','2023-12-20 14:51:49'),(3756,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 15:59:53','2023-12-20 15:59:53'),(3757,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 18:09:54','2023-12-20 18:09:54'),(3758,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 18:09:57','2023-12-20 18:09:57'),(3759,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 19:11:11','2023-12-20 19:11:11'),(3760,'default','added',135,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 19:12:31','2023-12-20 19:12:31'),(3761,'default','added',2491,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-12-20 19:13:15','2023-12-20 19:13:15'),(3762,'default','payment_edited',1942,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"47200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"47200.0000\"}}',NULL,'2023-12-20 19:33:03','2023-12-20 19:33:03'),(3763,'default','payment_edited',2436,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"55698.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"55698.0000\"}}',NULL,'2023-12-20 19:39:55','2023-12-20 19:39:55'),(3764,'default','payment_edited',2455,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"23000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"23000.0000\"}}',NULL,'2023-12-20 19:39:55','2023-12-20 19:39:55'),(3765,'default','added',136,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 19:43:08','2023-12-20 19:43:08'),(3766,'default','added',2492,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-12-20 19:43:48','2023-12-20 19:43:48'),(3767,'default','added',2493,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":101000}}',NULL,'2023-12-20 19:44:46','2023-12-20 19:44:46'),(3768,'default','added',2494,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-20 19:50:55','2023-12-20 19:50:55'),(3769,'default','added',2495,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-20 19:51:50','2023-12-20 19:51:50'),(3770,'default','added',2496,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2050}}',NULL,'2023-12-20 19:55:43','2023-12-20 19:55:43'),(3771,'default','added',2497,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7370}}',NULL,'2023-12-20 19:58:45','2023-12-20 19:58:45'),(3772,'default','edited',96,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 19:59:31','2023-12-20 19:59:31'),(3773,'default','added',137,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 20:00:50','2023-12-20 20:00:50'),(3774,'default','added',2498,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":220800}}',NULL,'2023-12-20 20:02:00','2023-12-20 20:02:00'),(3775,'default','added',2499,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-20 20:02:50','2023-12-20 20:02:50'),(3776,'default','added',2500,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-20 20:03:48','2023-12-20 20:03:48'),(3777,'default','added',2501,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-20 20:05:30','2023-12-20 20:05:30'),(3778,'default','added',2502,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35160}}',NULL,'2023-12-20 20:20:52','2023-12-20 20:20:52'),(3779,'default','added',2503,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11400}}',NULL,'2023-12-20 20:23:59','2023-12-20 20:23:59'),(3780,'default','added',2504,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7730}}',NULL,'2023-12-20 20:28:31','2023-12-20 20:28:31'),(3781,'default','added',2505,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14401}}',NULL,'2023-12-20 20:30:58','2023-12-20 20:30:58'),(3782,'default','added',2506,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-12-20 20:32:10','2023-12-20 20:32:10'),(3783,'default','added',2507,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-20 20:44:57','2023-12-20 20:44:57'),(3784,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 20:52:00','2023-12-20 20:52:00'),(3785,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-20 21:19:57','2023-12-20 21:19:57'),(3786,'default','added',2508,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-20 21:23:11','2023-12-20 21:23:11'),(3787,'default','added',2509,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-20 21:23:46','2023-12-20 21:23:46'),(3788,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 11:55:34','2023-12-21 11:55:34'),(3789,'default','added',2510,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-21 12:00:10','2023-12-21 12:00:10'),(3790,'default','added',2511,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2980}}',NULL,'2023-12-21 12:04:22','2023-12-21 12:04:22'),(3791,'default','added',2512,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-21 12:05:00','2023-12-21 12:05:00'),(3792,'default','added',2513,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-21 12:05:44','2023-12-21 12:05:44'),(3793,'default','added',2514,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8250}}',NULL,'2023-12-21 12:07:09','2023-12-21 12:07:09'),(3794,'default','added',2515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17050}}',NULL,'2023-12-21 12:08:29','2023-12-21 12:08:29'),(3795,'default','added',2516,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-21 12:11:43','2023-12-21 12:11:43'),(3796,'default','edited',2513,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"}}',NULL,'2023-12-21 12:12:28','2023-12-21 12:12:28'),(3797,'default','added',2517,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9500}}',NULL,'2023-12-21 12:14:01','2023-12-21 12:14:01'),(3798,'default','payment_edited',1913,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"23200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"23200.0000\"}}',NULL,'2023-12-21 12:14:36','2023-12-21 12:14:36'),(3799,'default','edited',96,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 12:16:21','2023-12-21 12:16:21'),(3800,'default','payment_edited',2071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10530.0000\"}}',NULL,'2023-12-21 12:17:04','2023-12-21 12:17:04'),(3801,'default','payment_edited',2099,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2700.0000\"}}',NULL,'2023-12-21 12:17:04','2023-12-21 12:17:04'),(3802,'default','payment_edited',2147,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-12-21 12:17:04','2023-12-21 12:17:04'),(3803,'default','payment_edited',2202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10880.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10880.0000\"}}',NULL,'2023-12-21 12:17:04','2023-12-21 12:17:04'),(3804,'default','added',2518,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-21 12:21:39','2023-12-21 12:21:39'),(3805,'default','edited',2469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7530},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7530.0000\"}}',NULL,'2023-12-21 12:25:53','2023-12-21 12:25:53'),(3806,'default','added',2519,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10000}}',NULL,'2023-12-21 12:27:42','2023-12-21 12:27:42'),(3807,'default','added',2520,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-21 12:28:23','2023-12-21 12:28:23'),(3808,'default','added',2521,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-21 13:33:20','2023-12-21 13:33:20'),(3809,'default','added',2522,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2470}}',NULL,'2023-12-21 13:37:00','2023-12-21 13:37:00'),(3810,'default','payment_edited',2452,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"192600.4500\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"192600.4500\"}}',NULL,'2023-12-21 13:38:25','2023-12-21 13:38:25'),(3811,'default','added',2523,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-12-21 13:39:38','2023-12-21 13:39:38'),(3812,'default','added',2524,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2150}}',NULL,'2023-12-21 13:41:52','2023-12-21 13:41:52'),(3813,'default','added',2525,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-21 13:53:00','2023-12-21 13:53:00'),(3814,'default','added',2526,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15700}}',NULL,'2023-12-21 13:54:58','2023-12-21 13:54:58'),(3815,'default','added',2527,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-21 14:08:01','2023-12-21 14:08:01'),(3816,'default','added',2528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-21 14:20:02','2023-12-21 14:20:02'),(3817,'default','added',2529,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-21 14:20:45','2023-12-21 14:20:45'),(3818,'default','edited',2529,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-21 14:21:20','2023-12-21 14:21:20'),(3819,'default','added',2530,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-12-21 14:24:37','2023-12-21 14:24:37'),(3820,'default','added',2531,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-21 14:26:48','2023-12-21 14:26:48'),(3821,'default','added',2532,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":80001}}',NULL,'2023-12-21 14:37:53','2023-12-21 14:37:53'),(3822,'default','added',2533,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10845.5}}',NULL,'2023-12-21 14:40:15','2023-12-21 14:40:15'),(3823,'default','added',2534,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6100}}',NULL,'2023-12-21 14:43:24','2023-12-21 14:43:24'),(3824,'default','added',2535,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94074.080000000001746229827404022216796875}}',NULL,'2023-12-21 14:46:19','2023-12-21 14:46:19'),(3825,'default','added',2536,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3950}}',NULL,'2023-12-21 14:46:51','2023-12-21 14:46:51'),(3826,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 14:53:26','2023-12-21 14:53:26'),(3827,'default','payment_edited',2350,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"18970.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"18970.0000\"}}',NULL,'2023-12-21 14:56:50','2023-12-21 14:56:50'),(3828,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 15:40:32','2023-12-21 15:40:32'),(3829,'default','added',2537,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-21 15:41:21','2023-12-21 15:41:21'),(3830,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 17:24:47','2023-12-21 17:24:47'),(3831,'default','added',2538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-12-21 17:29:48','2023-12-21 17:29:48'),(3832,'default','payment_edited',2023,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-12-21 17:30:29','2023-12-21 17:30:29'),(3833,'default','added',2539,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":57240}}',NULL,'2023-12-21 17:31:40','2023-12-21 17:31:40'),(3834,'default','added',2540,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-21 17:32:17','2023-12-21 17:32:17'),(3835,'default','added',2541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":414000}}',NULL,'2023-12-21 17:33:54','2023-12-21 17:33:54'),(3836,'default','added',2542,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-21 17:35:16','2023-12-21 17:35:16'),(3837,'default','added',2543,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-21 17:42:12','2023-12-21 17:42:12'),(3838,'default','payment_edited',2301,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"14400.0000\"}}',NULL,'2023-12-21 17:42:38','2023-12-21 17:42:38'),(3839,'default','added',2544,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28500}}',NULL,'2023-12-21 17:44:42','2023-12-21 17:44:42'),(3840,'default','added',2545,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7600}}',NULL,'2023-12-21 17:47:32','2023-12-21 17:47:32'),(3841,'default','added',2546,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-21 17:50:03','2023-12-21 17:50:03'),(3842,'default','added',2547,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-21 17:57:23','2023-12-21 17:57:23'),(3843,'default','added',2548,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31418.88000000000101863406598567962646484375}}',NULL,'2023-12-21 18:05:28','2023-12-21 18:05:28'),(3844,'default','added',2549,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-21 18:06:51','2023-12-21 18:06:51'),(3845,'default','added',2550,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-21 18:12:53','2023-12-21 18:12:53'),(3846,'default','added',2551,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-21 18:15:59','2023-12-21 18:15:59'),(3847,'default','added',2552,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23640.77999999999883584678173065185546875}}',NULL,'2023-12-21 18:16:22','2023-12-21 18:16:22'),(3848,'default','added',2553,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44006.4000000000014551915228366851806640625}}',NULL,'2023-12-21 18:19:12','2023-12-21 18:19:12'),(3849,'default','added',2554,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3388}}',NULL,'2023-12-21 18:20:01','2023-12-21 18:20:01'),(3850,'default','added',2555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5740}}',NULL,'2023-12-21 18:22:54','2023-12-21 18:22:54'),(3851,'default','added',2556,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-21 18:24:17','2023-12-21 18:24:17'),(3852,'default','payment_edited',2493,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"101000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"101000.0000\"}}',NULL,'2023-12-21 18:24:38','2023-12-21 18:24:38'),(3853,'default','added',2557,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-12-21 18:25:46','2023-12-21 18:25:46'),(3854,'default','added',2558,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-21 18:38:03','2023-12-21 18:38:03'),(3855,'default','added',2559,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5755}}',NULL,'2023-12-21 18:39:45','2023-12-21 18:39:45'),(3856,'default','added',2560,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1920}}',NULL,'2023-12-21 18:41:26','2023-12-21 18:41:26'),(3857,'default','edited',2560,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1920.0000\"}}',NULL,'2023-12-21 18:42:50','2023-12-21 18:42:50'),(3858,'default','added',2561,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-21 18:44:10','2023-12-21 18:44:10'),(3859,'default','added',2562,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":56350}}',NULL,'2023-12-21 18:47:12','2023-12-21 18:47:12'),(3860,'default','added',2563,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7250}}',NULL,'2023-12-21 18:49:13','2023-12-21 18:49:13'),(3861,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 18:51:39','2023-12-21 18:51:39'),(3862,'default','added',2564,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-21 18:52:22','2023-12-21 18:52:22'),(3863,'default','added',2565,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-12-21 18:56:31','2023-12-21 18:56:31'),(3864,'default','added',2566,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-21 18:57:24','2023-12-21 18:57:24'),(3865,'default','added',2567,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-12-21 19:07:26','2023-12-21 19:07:26'),(3866,'default','payment_edited',2325,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2950.0000\"}}',NULL,'2023-12-21 19:31:09','2023-12-21 19:31:09'),(3867,'default','added',2568,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-12-21 19:32:42','2023-12-21 19:32:42'),(3868,'default','added',2569,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-21 19:41:24','2023-12-21 19:41:24'),(3869,'default','added',2570,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-21 19:43:08','2023-12-21 19:43:08'),(3870,'default','added',2571,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-21 19:44:10','2023-12-21 19:44:10'),(3871,'default','added',2572,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-12-21 19:46:32','2023-12-21 19:46:32'),(3872,'default','added',2573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-21 19:59:14','2023-12-21 19:59:14'),(3873,'default','added',2574,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-21 20:00:25','2023-12-21 20:00:25'),(3874,'default','added',2575,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-21 20:04:37','2023-12-21 20:04:37'),(3875,'default','added',2576,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2023-12-21 20:07:56','2023-12-21 20:07:56'),(3876,'default','added',2577,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1440}}',NULL,'2023-12-21 20:13:34','2023-12-21 20:13:34'),(3877,'default','added',2578,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28500}}',NULL,'2023-12-21 20:13:49','2023-12-21 20:13:49'),(3878,'default','added',2579,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":960}}',NULL,'2023-12-21 20:16:03','2023-12-21 20:16:03'),(3879,'default','added',2580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17650}}',NULL,'2023-12-21 20:21:10','2023-12-21 20:21:10'),(3880,'default','added',2581,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7550}}',NULL,'2023-12-21 20:24:07','2023-12-21 20:24:07'),(3881,'default','added',2582,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5130}}',NULL,'2023-12-21 20:34:42','2023-12-21 20:34:42'),(3882,'default','added',2583,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-12-21 20:48:08','2023-12-21 20:48:08'),(3883,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 20:50:27','2023-12-21 20:50:27'),(3884,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 20:50:35','2023-12-21 20:50:35'),(3885,'default','added',2584,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-21 20:51:09','2023-12-21 20:51:09'),(3886,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 20:51:20','2023-12-21 20:51:20'),(3887,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-21 21:00:31','2023-12-21 21:00:31'),(3888,'default','added',2585,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-21 21:01:17','2023-12-21 21:01:17'),(3889,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-22 11:18:47','2023-12-22 11:18:47'),(3890,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 10:18:30','2023-12-23 10:18:30'),(3891,'default','payment_edited',2065,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-23 10:20:09','2023-12-23 10:20:09'),(3892,'default','payment_edited',2107,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-23 10:20:09','2023-12-23 10:20:09'),(3893,'default','payment_edited',2150,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-23 10:20:09','2023-12-23 10:20:09'),(3894,'default','payment_edited',2238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-23 10:20:09','2023-12-23 10:20:09'),(3895,'default','added',2586,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11400}}',NULL,'2023-12-23 10:26:54','2023-12-23 10:26:54'),(3896,'default','added',2587,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2725}}',NULL,'2023-12-23 10:39:15','2023-12-23 10:39:15'),(3897,'default','added',2588,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8425}}',NULL,'2023-12-23 10:40:38','2023-12-23 10:40:38'),(3898,'default','added',2589,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11400}}',NULL,'2023-12-23 10:41:42','2023-12-23 10:41:42'),(3899,'default','added',2590,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-12-23 10:42:44','2023-12-23 10:42:44'),(3900,'default','added',2591,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-12-23 10:44:01','2023-12-23 10:44:01'),(3901,'default','added',2592,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-23 10:44:40','2023-12-23 10:44:40'),(3902,'default','added',2593,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":24650}}',NULL,'2023-12-23 10:48:41','2023-12-23 10:48:41'),(3903,'default','added',2594,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4810}}',NULL,'2023-12-23 11:09:05','2023-12-23 11:09:05'),(3904,'default','payment_edited',2202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10880.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10880.0000\"}}',NULL,'2023-12-23 11:09:43','2023-12-23 11:09:43'),(3905,'default','added',2595,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1950}}',NULL,'2023-12-23 11:10:21','2023-12-23 11:10:21'),(3906,'default','added',2596,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-12-23 11:12:32','2023-12-23 11:12:32'),(3907,'default','added',2597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11130}}',NULL,'2023-12-23 11:13:38','2023-12-23 11:13:38'),(3908,'default','added',2598,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4200}}',NULL,'2023-12-23 11:21:36','2023-12-23 11:21:36'),(3909,'default','added',2599,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-23 11:36:02','2023-12-23 11:36:02'),(3910,'default','added',2600,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20594.0999999999985448084771633148193359375}}',NULL,'2023-12-23 11:39:28','2023-12-23 11:39:28'),(3911,'default','added',2601,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-23 11:48:58','2023-12-23 11:48:58'),(3912,'default','payment_edited',2545,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7600.0000\"}}',NULL,'2023-12-23 11:49:24','2023-12-23 11:49:24'),(3913,'default','added',2602,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11600}}',NULL,'2023-12-23 11:52:14','2023-12-23 11:52:14'),(3914,'default','added',2603,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10850}}',NULL,'2023-12-23 11:53:14','2023-12-23 11:53:14'),(3915,'default','added',2604,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-12-23 11:53:40','2023-12-23 11:53:40'),(3916,'default','added',2605,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1420}}',NULL,'2023-12-23 11:59:07','2023-12-23 11:59:07'),(3917,'default','added',138,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 12:05:07','2023-12-23 12:05:07'),(3918,'default','added',2606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5900}}',NULL,'2023-12-23 12:05:24','2023-12-23 12:05:24'),(3919,'default','added',2607,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-23 12:07:24','2023-12-23 12:07:24'),(3920,'default','added',2608,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-12-23 12:09:37','2023-12-23 12:09:37'),(3921,'default','added',2609,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-23 12:10:30','2023-12-23 12:10:30'),(3922,'default','added',2610,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":110576.199999999997089616954326629638671875}}',NULL,'2023-12-23 12:19:03','2023-12-23 12:19:03'),(3923,'default','added',2611,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-23 12:24:29','2023-12-23 12:24:29'),(3924,'default','payment_edited',2491,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2023-12-23 12:33:47','2023-12-23 12:33:47'),(3925,'default','added',2612,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-23 12:34:50','2023-12-23 12:34:50'),(3926,'default','added',2613,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-23 12:36:00','2023-12-23 12:36:00'),(3927,'default','added',139,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 12:37:00','2023-12-23 12:37:00'),(3928,'default','added',2614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":10400}}',NULL,'2023-12-23 12:38:14','2023-12-23 12:38:14'),(3929,'default','added',2615,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-23 12:55:58','2023-12-23 12:55:58'),(3930,'default','added',2616,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-23 12:56:43','2023-12-23 12:56:43'),(3931,'default','added',2617,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":47690}}',NULL,'2023-12-23 13:21:11','2023-12-23 13:21:11'),(3932,'default','added',2618,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-23 13:23:11','2023-12-23 13:23:11'),(3933,'default','added',2619,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-23 13:23:32','2023-12-23 13:23:32'),(3934,'default','added',2620,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-23 13:27:56','2023-12-23 13:27:56'),(3935,'default','added',2621,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-12-23 13:36:13','2023-12-23 13:36:13'),(3936,'default','added',2622,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-23 13:43:18','2023-12-23 13:43:18'),(3937,'default','added',2623,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-12-23 14:03:37','2023-12-23 14:03:37'),(3938,'default','payment_edited',2078,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5800.0000\"}}',NULL,'2023-12-23 14:26:25','2023-12-23 14:26:25'),(3939,'default','payment_edited',2554,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3388.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3388.0000\"}}',NULL,'2023-12-23 14:26:25','2023-12-23 14:26:25'),(3940,'default','edited',2610,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":109476.199999999997089616954326629638671875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"110576.2000\"}}',NULL,'2023-12-23 14:31:31','2023-12-23 14:31:31'),(3941,'default','added',2624,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-23 14:32:19','2023-12-23 14:32:19'),(3942,'default','added',140,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 14:34:36','2023-12-23 14:34:36'),(3943,'default','added',2625,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":27900}}',NULL,'2023-12-23 14:36:10','2023-12-23 14:36:10'),(3944,'default','added',2626,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-23 14:42:05','2023-12-23 14:42:05'),(3945,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 14:45:40','2023-12-23 14:45:40'),(3946,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 14:47:16','2023-12-23 14:47:16'),(3947,'default','added',2627,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5640}}',NULL,'2023-12-23 14:48:45','2023-12-23 14:48:45'),(3948,'default','added',2628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":56560}}',NULL,'2023-12-23 14:54:54','2023-12-23 14:54:54'),(3949,'default','added',2629,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-23 14:55:33','2023-12-23 14:55:33'),(3950,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 14:56:39','2023-12-23 14:56:39'),(3951,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 17:33:26','2023-12-23 17:33:26'),(3952,'default','payment_edited',755,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-12-23 17:34:34','2023-12-23 17:34:34'),(3953,'default','added',2630,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-23 17:35:28','2023-12-23 17:35:28'),(3954,'default','added',2631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-12-23 17:37:03','2023-12-23 17:37:03'),(3955,'default','added',2632,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-23 17:39:50','2023-12-23 17:39:50'),(3956,'default','added',2633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4300}}',NULL,'2023-12-23 17:42:24','2023-12-23 17:42:24'),(3957,'default','added',2634,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-23 17:42:40','2023-12-23 17:42:40'),(3958,'default','added',2635,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2050}}',NULL,'2023-12-23 17:46:40','2023-12-23 17:46:40'),(3959,'default','added',2636,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-12-23 17:48:31','2023-12-23 17:48:31'),(3960,'default','added',2637,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13570}}',NULL,'2023-12-23 17:50:01','2023-12-23 17:50:01'),(3961,'default','added',2638,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-12-23 17:50:42','2023-12-23 17:50:42'),(3962,'default','added',2639,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-23 17:53:05','2023-12-23 17:53:05'),(3963,'default','added',2640,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-23 17:53:27','2023-12-23 17:53:27'),(3964,'default','added',2641,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2023-12-23 17:55:01','2023-12-23 17:55:01'),(3965,'default','added',2642,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-23 17:56:15','2023-12-23 17:56:15'),(3966,'default','added',2643,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4555}}',NULL,'2023-12-23 18:02:13','2023-12-23 18:02:13'),(3967,'default','edited',99,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 18:04:19','2023-12-23 18:04:19'),(3968,'default','added',2644,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10599.84000000000014551915228366851806640625}}',NULL,'2023-12-23 18:06:50','2023-12-23 18:06:50'),(3969,'default','added',2645,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33419.83999999999650754034519195556640625}}',NULL,'2023-12-23 18:10:30','2023-12-23 18:10:30'),(3970,'default','added',2646,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1730}}',NULL,'2023-12-23 18:13:30','2023-12-23 18:13:30'),(3971,'default','added',141,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 18:30:17','2023-12-23 18:30:17'),(3972,'default','added',2647,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2850}}',NULL,'2023-12-23 18:30:57','2023-12-23 18:30:57'),(3973,'default','payment_edited',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"70000.0000\"}}',NULL,'2023-12-23 18:33:56','2023-12-23 18:33:56'),(3974,'default','added',2648,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-12-23 18:34:34','2023-12-23 18:34:34'),(3975,'default','added',2649,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":51360}}',NULL,'2023-12-23 18:38:21','2023-12-23 18:38:21'),(3976,'default','added',2650,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-23 18:38:59','2023-12-23 18:38:59'),(3977,'default','added',2651,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4275}}',NULL,'2023-12-23 19:05:18','2023-12-23 19:05:18'),(3978,'default','added',2652,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-12-23 19:18:25','2023-12-23 19:18:25'),(3979,'default','added',2653,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5450}}',NULL,'2023-12-23 19:26:07','2023-12-23 19:26:07'),(3980,'default','added',2654,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-23 19:26:52','2023-12-23 19:26:52'),(3981,'default','payment_edited',2283,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"42440.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"42440.0000\"}}',NULL,'2023-12-23 19:27:35','2023-12-23 19:27:35'),(3982,'default','added',2655,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":70903}}',NULL,'2023-12-23 19:48:44','2023-12-23 19:48:44'),(3983,'default','payment_edited',2655,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"70903.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"70903.0000\"}}',NULL,'2023-12-23 19:49:20','2023-12-23 19:49:20'),(3984,'default','added',2656,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-23 19:50:30','2023-12-23 19:50:30'),(3985,'default','added',2657,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-23 19:51:01','2023-12-23 19:51:01'),(3986,'default','added',2658,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-23 19:55:19','2023-12-23 19:55:19'),(3987,'default','added',142,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 19:56:23','2023-12-23 19:56:23'),(3988,'default','added',2659,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500}}',NULL,'2023-12-23 19:56:50','2023-12-23 19:56:50'),(3989,'default','added',2660,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-23 20:04:40','2023-12-23 20:04:40'),(3990,'default','added',2661,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":920}}',NULL,'2023-12-23 20:06:36','2023-12-23 20:06:36'),(3991,'default','added',2662,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-23 20:08:59','2023-12-23 20:08:59'),(3992,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 20:11:18','2023-12-23 20:11:18'),(3993,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 20:11:37','2023-12-23 20:11:37'),(3994,'default','added',2663,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-23 20:12:00','2023-12-23 20:12:00'),(3995,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 20:12:13','2023-12-23 20:12:13'),(3996,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-23 22:08:40','2023-12-23 22:08:40'),(3997,'default','added',2664,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-23 22:09:16','2023-12-23 22:09:16'),(3998,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-24 11:19:38','2023-12-24 11:19:38'),(3999,'default','added',2665,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-12-24 11:21:44','2023-12-24 11:21:44'),(4000,'default','added',2666,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-24 11:24:11','2023-12-24 11:24:11'),(4001,'default','payment_edited',2602,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11600.0000\"}}',NULL,'2023-12-24 11:29:12','2023-12-24 11:29:12'),(4002,'default','added',2667,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":9700}}',NULL,'2023-12-24 11:30:26','2023-12-24 11:30:26'),(4003,'default','added',2668,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8700}}',NULL,'2023-12-24 11:32:45','2023-12-24 11:32:45'),(4004,'default','added',2669,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":176395}}',NULL,'2023-12-24 11:49:55','2023-12-24 11:49:55'),(4005,'default','added',2670,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-12-24 12:01:44','2023-12-24 12:01:44'),(4006,'default','payment_edited',2238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-24 12:04:31','2023-12-24 12:04:31'),(4007,'default','payment_edited',2297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-24 12:04:31','2023-12-24 12:04:31'),(4008,'default','payment_edited',2635,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2050.0000\"}}',NULL,'2023-12-24 12:04:51','2023-12-24 12:04:51'),(4009,'default','added',2671,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":21250}}',NULL,'2023-12-24 12:07:08','2023-12-24 12:07:08'),(4010,'default','added',2672,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1320}}',NULL,'2023-12-24 12:14:49','2023-12-24 12:14:49'),(4011,'default','added',2673,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1260}}',NULL,'2023-12-24 12:23:51','2023-12-24 12:23:51'),(4012,'default','payment_edited',2202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10880.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10880.0000\"}}',NULL,'2023-12-24 12:25:15','2023-12-24 12:25:15'),(4013,'default','payment_edited',2284,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5970.0400\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5970.0400\"}}',NULL,'2023-12-24 12:25:15','2023-12-24 12:25:15'),(4014,'default','added',2674,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-24 12:28:29','2023-12-24 12:28:29'),(4015,'default','added',2675,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-24 12:41:41','2023-12-24 12:41:41'),(4016,'default','added',2676,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-24 12:49:27','2023-12-24 12:49:27'),(4017,'default','added',2677,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-24 12:50:26','2023-12-24 12:50:26'),(4018,'default','payment_edited',2315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"831000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"831000.0000\"}}',NULL,'2023-12-24 13:16:09','2023-12-24 13:16:09'),(4019,'default','payment_edited',2541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"}}',NULL,'2023-12-24 13:16:09','2023-12-24 13:16:09'),(4020,'default','added',2678,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-12-24 13:19:45','2023-12-24 13:19:45'),(4021,'default','added',2679,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":330}}',NULL,'2023-12-24 13:22:12','2023-12-24 13:22:12'),(4022,'default','added',2680,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13660}}',NULL,'2023-12-24 13:24:48','2023-12-24 13:24:48'),(4023,'default','added',2681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17450}}',NULL,'2023-12-24 13:26:48','2023-12-24 13:26:48'),(4024,'default','added',2682,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15150}}',NULL,'2023-12-24 13:33:33','2023-12-24 13:33:33'),(4025,'default','added',2683,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":70000}}',NULL,'2023-12-24 13:34:16','2023-12-24 13:34:16'),(4026,'default','added',143,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-24 13:39:32','2023-12-24 13:39:32'),(4027,'default','added',2684,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5500}}',NULL,'2023-12-24 13:39:52','2023-12-24 13:39:52'),(4028,'default','added',2685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-24 13:43:49','2023-12-24 13:43:49'),(4029,'default','added',2686,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-24 13:45:36','2023-12-24 13:45:36'),(4030,'default','added',2687,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-24 13:47:20','2023-12-24 13:47:20'),(4031,'default','added',2688,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-24 13:53:19','2023-12-24 13:53:19'),(4032,'default','added',2689,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2525}}',NULL,'2023-12-24 14:04:44','2023-12-24 14:04:44'),(4033,'default','added',2690,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-24 14:14:52','2023-12-24 14:14:52'),(4034,'default','added',144,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-24 14:19:15','2023-12-24 14:19:15'),(4035,'default','added',2691,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11000}}',NULL,'2023-12-24 14:21:16','2023-12-24 14:21:16'),(4036,'default','added',2692,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-24 14:28:17','2023-12-24 14:28:17'),(4037,'default','added',2693,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-12-24 14:31:46','2023-12-24 14:31:46'),(4038,'default','payment_edited',2480,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"56448.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"56448.0000\"}}',NULL,'2023-12-24 14:35:25','2023-12-24 14:35:25'),(4039,'default','added',2694,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-12-24 14:36:00','2023-12-24 14:36:00'),(4040,'default','added',2695,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":199950}}',NULL,'2023-12-24 15:25:34','2023-12-24 15:25:34'),(4041,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-24 16:15:44','2023-12-24 16:15:44'),(4042,'default','added',2696,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4275}}',NULL,'2023-12-24 17:15:48','2023-12-24 17:15:48'),(4043,'default','added',2697,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4440}}',NULL,'2023-12-24 17:19:10','2023-12-24 17:19:10'),(4044,'default','added',2698,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-24 17:24:29','2023-12-24 17:24:29'),(4045,'default','added',2699,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-12-24 17:30:59','2023-12-24 17:30:59'),(4046,'default','added',2700,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":49321.52999999999883584678173065185546875}}',NULL,'2023-12-24 17:37:06','2023-12-24 17:37:06'),(4047,'default','added',2701,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4850}}',NULL,'2023-12-24 17:51:30','2023-12-24 17:51:30'),(4048,'default','added',2702,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-24 17:52:42','2023-12-24 17:52:42'),(4049,'default','added',2703,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10080}}',NULL,'2023-12-24 17:53:29','2023-12-24 17:53:29'),(4050,'default','added',2704,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10920}}',NULL,'2023-12-24 17:54:46','2023-12-24 17:54:46'),(4051,'default','added',2705,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8380}}',NULL,'2023-12-24 17:55:48','2023-12-24 17:55:48'),(4052,'default','added',2706,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10050}}',NULL,'2023-12-24 17:58:05','2023-12-24 17:58:05'),(4053,'default','added',2707,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-12-24 18:03:01','2023-12-24 18:03:01'),(4054,'default','added',2708,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-24 18:03:44','2023-12-24 18:03:44'),(4055,'default','added',2709,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-24 18:05:17','2023-12-24 18:05:17'),(4056,'default','payment_edited',2544,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"28500.0000\"}}',NULL,'2023-12-24 18:09:09','2023-12-24 18:09:09'),(4057,'default','added',2710,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-24 18:19:31','2023-12-24 18:19:31'),(4058,'default','added',2711,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-24 18:27:39','2023-12-24 18:27:39'),(4059,'default','added',2712,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5900}}',NULL,'2023-12-24 18:29:15','2023-12-24 18:29:15'),(4060,'default','edited',2708,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"}}',NULL,'2023-12-24 18:29:49','2023-12-24 18:29:49'),(4061,'default','added',2713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-24 18:35:33','2023-12-24 18:35:33'),(4062,'default','payment_edited',1960,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"96480.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"96480.0000\"}}',NULL,'2023-12-24 18:43:30','2023-12-24 18:43:30'),(4063,'default','payment_edited',2539,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"57240.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"57240.0000\"}}',NULL,'2023-12-24 18:43:30','2023-12-24 18:43:30'),(4064,'default','added',2714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-24 19:06:18','2023-12-24 19:06:18'),(4065,'default','payment_edited',2631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-12-24 19:08:47','2023-12-24 19:08:47'),(4066,'default','added',2715,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-24 19:12:11','2023-12-24 19:12:11'),(4067,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-24 19:13:17','2023-12-24 19:13:17'),(4068,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-24 21:22:50','2023-12-24 21:22:50'),(4069,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 06:40:19','2023-12-25 06:40:19'),(4070,'default','payment_edited',2285,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2700.0000\"}}',NULL,'2023-12-25 06:40:49','2023-12-25 06:40:49'),(4071,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 10:26:39','2023-12-25 10:26:39'),(4072,'default','added',2716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-12-25 10:28:42','2023-12-25 10:28:42'),(4073,'default','payment_edited',2297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-25 10:29:59','2023-12-25 10:29:59'),(4074,'default','payment_edited',2339,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-25 10:29:59','2023-12-25 10:29:59'),(4075,'default','payment_edited',2533,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10845.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10845.5000\"}}',NULL,'2023-12-25 10:30:32','2023-12-25 10:30:32'),(4076,'default','payment_edited',2349,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"41540.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"41540.0000\"}}',NULL,'2023-12-25 10:32:26','2023-12-25 10:32:26'),(4077,'default','payment_edited',2391,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"53540.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"53540.0000\"}}',NULL,'2023-12-25 10:32:26','2023-12-25 10:32:26'),(4078,'default','payment_edited',2562,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"56350.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"56350.0000\"}}',NULL,'2023-12-25 10:32:26','2023-12-25 10:32:26'),(4079,'default','added',2717,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-25 10:33:18','2023-12-25 10:33:18'),(4080,'default','added',2718,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-25 10:35:00','2023-12-25 10:35:00'),(4081,'default','added',2719,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-12-25 10:35:42','2023-12-25 10:35:42'),(4082,'default','added',2720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-12-25 10:36:30','2023-12-25 10:36:30'),(4083,'default','added',2721,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-12-25 10:38:11','2023-12-25 10:38:11'),(4084,'default','added',2722,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14650}}',NULL,'2023-12-25 10:40:07','2023-12-25 10:40:07'),(4085,'default','added',2723,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8350}}',NULL,'2023-12-25 10:40:58','2023-12-25 10:40:58'),(4086,'default','added',2724,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8480}}',NULL,'2023-12-25 10:41:53','2023-12-25 10:41:53'),(4087,'default','added',2725,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6100}}',NULL,'2023-12-25 10:43:32','2023-12-25 10:43:32'),(4088,'default','added',2726,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-25 11:07:16','2023-12-25 11:07:16'),(4089,'default','added',2727,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6050}}',NULL,'2023-12-25 11:10:37','2023-12-25 11:10:37'),(4090,'default','added',2728,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-25 11:11:48','2023-12-25 11:11:48'),(4091,'default','added',2729,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1080}}',NULL,'2023-12-25 11:13:40','2023-12-25 11:13:40'),(4092,'default','added',2730,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-25 11:32:51','2023-12-25 11:32:51'),(4093,'default','payment_edited',2606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5900.0000\"}}',NULL,'2023-12-25 11:36:24','2023-12-25 11:36:24'),(4094,'default','payment_edited',2684,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5500.0000\"}}',NULL,'2023-12-25 11:37:52','2023-12-25 11:37:52'),(4095,'default','payment_edited',2284,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5970.0400\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5970.0400\"}}',NULL,'2023-12-25 11:38:19','2023-12-25 11:38:19'),(4096,'default','payment_edited',2337,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7880.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7880.0000\"}}',NULL,'2023-12-25 11:38:19','2023-12-25 11:38:19'),(4097,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 11:45:51','2023-12-25 11:45:51'),(4098,'default','added',2731,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":98088}}',NULL,'2023-12-25 11:48:41','2023-12-25 11:48:41'),(4099,'default','added',2732,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-25 12:00:35','2023-12-25 12:00:35'),(4100,'default','added',2733,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-25 12:14:25','2023-12-25 12:14:25'),(4101,'default','added',2734,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3260}}',NULL,'2023-12-25 12:33:23','2023-12-25 12:33:23'),(4102,'default','added',2735,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-12-25 12:41:49','2023-12-25 12:41:49'),(4103,'default','added',2736,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-25 12:42:29','2023-12-25 12:42:29'),(4104,'default','added',2737,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-25 12:42:46','2023-12-25 12:42:46'),(4105,'default','added',2738,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-12-25 13:20:53','2023-12-25 13:20:53'),(4106,'default','added',2739,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-25 13:29:30','2023-12-25 13:29:30'),(4107,'default','added',2740,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-12-25 13:30:43','2023-12-25 13:30:43'),(4108,'default','payment_edited',2101,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-25 14:05:29','2023-12-25 14:05:29'),(4109,'default','added',2741,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750}}',NULL,'2023-12-25 14:06:05','2023-12-25 14:06:05'),(4110,'default','added',2742,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17210}}',NULL,'2023-12-25 14:08:16','2023-12-25 14:08:16'),(4111,'default','added',2743,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-12-25 14:08:58','2023-12-25 14:08:58'),(4112,'default','added',2744,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-25 14:10:30','2023-12-25 14:10:30'),(4113,'default','added',2745,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6030}}',NULL,'2023-12-25 14:16:17','2023-12-25 14:16:17'),(4114,'default','added',2746,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-25 14:16:58','2023-12-25 14:16:58'),(4115,'default','added',2747,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-25 14:26:57','2023-12-25 14:26:57'),(4116,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 14:57:24','2023-12-25 14:57:24'),(4117,'default','added',2748,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-12-25 14:59:30','2023-12-25 14:59:30'),(4118,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 17:25:44','2023-12-25 17:25:44'),(4119,'default','added',145,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 17:29:38','2023-12-25 17:29:38'),(4120,'default','added',2749,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":219020}}',NULL,'2023-12-25 17:31:16','2023-12-25 17:31:16'),(4121,'default','added',2750,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":46740}}',NULL,'2023-12-25 17:33:12','2023-12-25 17:33:12'),(4122,'default','added',2751,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-25 17:35:36','2023-12-25 17:35:36'),(4123,'default','added',2752,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":55873.4000000000014551915228366851806640625}}',NULL,'2023-12-25 17:48:16','2023-12-25 17:48:16'),(4124,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 18:49:25','2023-12-25 18:49:25'),(4125,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-25 21:30:47','2023-12-25 21:30:47'),(4126,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-26 10:28:44','2023-12-26 10:28:44'),(4127,'default','payment_edited',2559,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5755.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5755.0000\"}}',NULL,'2023-12-26 10:29:50','2023-12-26 10:29:50'),(4128,'default','payment_edited',2636,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-12-26 10:29:50','2023-12-26 10:29:50'),(4129,'default','payment_edited',2719,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-12-26 10:31:09','2023-12-26 10:31:09'),(4130,'default','added',2753,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19730}}',NULL,'2023-12-26 10:42:54','2023-12-26 10:42:54'),(4131,'default','added',2754,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19300}}',NULL,'2023-12-26 10:44:48','2023-12-26 10:44:48'),(4132,'default','added',2755,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4550}}',NULL,'2023-12-26 10:45:14','2023-12-26 10:45:14'),(4133,'default','added',2756,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2750}}',NULL,'2023-12-26 10:45:32','2023-12-26 10:45:32'),(4134,'default','added',2757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-12-26 10:47:02','2023-12-26 10:47:02'),(4135,'default','payment_edited',2376,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7900.0000\"}}',NULL,'2023-12-26 10:48:33','2023-12-26 10:48:33'),(4136,'default','added',2758,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2023-12-26 10:50:26','2023-12-26 10:50:26'),(4137,'default','added',2759,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10450}}',NULL,'2023-12-26 10:53:05','2023-12-26 10:53:05'),(4138,'default','added',2760,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7150}}',NULL,'2023-12-26 10:53:58','2023-12-26 10:53:58'),(4139,'default','payment_edited',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"}}',NULL,'2023-12-26 10:54:23','2023-12-26 10:54:23'),(4140,'default','added',2761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-26 10:57:06','2023-12-26 10:57:06'),(4141,'default','added',2762,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7130}}',NULL,'2023-12-26 11:00:19','2023-12-26 11:00:19'),(4142,'default','added',2763,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3270}}',NULL,'2023-12-26 11:03:34','2023-12-26 11:03:34'),(4143,'default','added',2764,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-12-26 11:09:58','2023-12-26 11:09:58'),(4144,'default','added',2765,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":254730}}',NULL,'2023-12-26 11:13:01','2023-12-26 11:13:01'),(4145,'default','added',2766,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1425}}',NULL,'2023-12-26 11:14:17','2023-12-26 11:14:17'),(4146,'default','added',2767,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1160}}',NULL,'2023-12-26 11:21:06','2023-12-26 11:21:06'),(4147,'default','added',2768,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-26 11:23:46','2023-12-26 11:23:46'),(4148,'default','added',2769,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-12-26 11:24:30','2023-12-26 11:24:30'),(4149,'default','added',2770,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-26 11:44:57','2023-12-26 11:44:57'),(4150,'default','payment_edited',2378,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"812000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"812000.0000\"}}',NULL,'2023-12-26 11:46:32','2023-12-26 11:46:32'),(4151,'default','payment_edited',2337,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7880.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7880.0000\"}}',NULL,'2023-12-26 13:25:58','2023-12-26 13:25:58'),(4152,'default','payment_edited',2387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8200.0000\"}}',NULL,'2023-12-26 13:25:58','2023-12-26 13:25:58'),(4153,'default','added',2771,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":73649.75}}',NULL,'2023-12-26 13:29:22','2023-12-26 13:29:22'),(4154,'default','added',2772,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-12-26 13:33:47','2023-12-26 13:33:47'),(4155,'default','added',2773,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10950}}',NULL,'2023-12-26 13:50:16','2023-12-26 13:50:16'),(4156,'default','added',2774,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4890}}',NULL,'2023-12-26 13:58:24','2023-12-26 13:58:24'),(4157,'default','added',2775,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":13650}}',NULL,'2023-12-26 14:09:18','2023-12-26 14:09:18'),(4158,'default','payment_edited',2775,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"13650.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"13650.0000\"}}',NULL,'2023-12-26 14:10:04','2023-12-26 14:10:04'),(4159,'default','payment_edited',2541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"}}',NULL,'2023-12-26 14:11:10','2023-12-26 14:11:10'),(4160,'default','added',2776,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-12-26 14:11:32','2023-12-26 14:11:32'),(4161,'default','added',2777,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":117380}}',NULL,'2023-12-26 14:45:01','2023-12-26 14:45:01'),(4162,'default','added',2778,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":102708}}',NULL,'2023-12-26 14:49:16','2023-12-26 14:49:16'),(4163,'default','added',2779,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-26 14:50:28','2023-12-26 14:50:28'),(4164,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-26 14:50:52','2023-12-26 14:50:52'),(4165,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-26 17:43:04','2023-12-26 17:43:04'),(4166,'default','added',2780,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7300}}',NULL,'2023-12-26 17:49:01','2023-12-26 17:49:01'),(4167,'default','added',2781,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8600}}',NULL,'2023-12-26 17:50:53','2023-12-26 17:50:53'),(4168,'default','added',2782,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17244}}',NULL,'2023-12-26 18:11:15','2023-12-26 18:11:15'),(4169,'default','added',2783,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-26 18:13:17','2023-12-26 18:13:17'),(4170,'default','payment_edited',2131,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"124855.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"124855.0000\"}}',NULL,'2023-12-26 18:23:09','2023-12-26 18:23:09'),(4171,'default','payment_edited',2163,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"51790.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"51790.0000\"}}',NULL,'2023-12-26 18:23:09','2023-12-26 18:23:09'),(4172,'default','payment_edited',2438,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"57240.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"57240.0000\"}}',NULL,'2023-12-26 18:23:09','2023-12-26 18:23:09'),(4173,'default','added',2784,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-26 18:26:21','2023-12-26 18:26:21'),(4174,'default','added',2785,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-26 18:34:19','2023-12-26 18:34:19'),(4175,'default','added',2786,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550}}',NULL,'2023-12-26 18:42:15','2023-12-26 18:42:15'),(4176,'default','payment_edited',2786,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-26 18:43:09','2023-12-26 18:43:09'),(4177,'default','added',2787,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3450}}',NULL,'2023-12-26 19:17:26','2023-12-26 19:17:26'),(4178,'default','added',2788,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3130}}',NULL,'2023-12-26 20:00:01','2023-12-26 20:00:01'),(4179,'default','added',2789,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-26 20:03:20','2023-12-26 20:03:20'),(4180,'default','added',2790,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-26 20:16:43','2023-12-26 20:16:43'),(4181,'default','added',2791,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-26 20:19:08','2023-12-26 20:19:08'),(4182,'default','added',2792,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-12-26 20:22:01','2023-12-26 20:22:01'),(4183,'default','added',2793,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1160}}',NULL,'2023-12-26 20:23:57','2023-12-26 20:23:57'),(4184,'default','added',2794,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1060}}',NULL,'2023-12-26 20:25:30','2023-12-26 20:25:30'),(4185,'default','added',2795,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1830}}',NULL,'2023-12-26 20:32:42','2023-12-26 20:32:42'),(4186,'default','added',2796,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28500}}',NULL,'2023-12-26 20:34:36','2023-12-26 20:34:36'),(4187,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-26 20:35:24','2023-12-26 20:35:24'),(4188,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 10:20:36','2023-12-27 10:20:36'),(4189,'default','added',2797,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-27 10:25:03','2023-12-27 10:25:03'),(4190,'default','payment_edited',2387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8200.0000\"}}',NULL,'2023-12-27 10:34:22','2023-12-27 10:34:22'),(4191,'default','payment_edited',2429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-12-27 10:34:22','2023-12-27 10:34:22'),(4192,'default','payment_edited',2469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7530.0000\"}}',NULL,'2023-12-27 10:34:22','2023-12-27 10:34:22'),(4193,'default','added',2798,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7300}}',NULL,'2023-12-27 10:37:42','2023-12-27 10:37:42'),(4194,'default','added',2799,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15190}}',NULL,'2023-12-27 10:41:50','2023-12-27 10:41:50'),(4195,'default','added',2800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5000}}',NULL,'2023-12-27 10:43:04','2023-12-27 10:43:04'),(4196,'default','added',2801,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4470}}',NULL,'2023-12-27 10:43:29','2023-12-27 10:43:29'),(4197,'default','added',2802,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":57000}}',NULL,'2023-12-27 10:58:04','2023-12-27 10:58:04'),(4198,'default','added',2803,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-27 11:01:10','2023-12-27 11:01:10'),(4199,'default','added',2804,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26800}}',NULL,'2023-12-27 11:02:24','2023-12-27 11:02:24'),(4200,'default','added',2805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1425}}',NULL,'2023-12-27 11:02:49','2023-12-27 11:02:49'),(4201,'default','payment_edited',2667,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"9700.0000\"}}',NULL,'2023-12-27 11:03:25','2023-12-27 11:03:25'),(4202,'default','added',2806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7850}}',NULL,'2023-12-27 11:04:19','2023-12-27 11:04:19'),(4203,'default','edited',2806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7850.0000\"}}',NULL,'2023-12-27 11:04:55','2023-12-27 11:04:55'),(4204,'default','added',2807,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-12-27 11:11:01','2023-12-27 11:11:01'),(4205,'default','added',2808,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-27 11:18:30','2023-12-27 11:18:30'),(4206,'default','added',2809,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5300}}',NULL,'2023-12-27 11:23:19','2023-12-27 11:23:19'),(4207,'default','added',2810,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-27 11:29:49','2023-12-27 11:29:49'),(4208,'default','added',2811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-12-27 11:42:25','2023-12-27 11:42:25'),(4209,'default','added',2812,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":630}}',NULL,'2023-12-27 11:48:04','2023-12-27 11:48:04'),(4210,'default','added',2813,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-12-27 13:32:57','2023-12-27 13:32:57'),(4211,'default','added',2814,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-27 13:33:38','2023-12-27 13:33:38'),(4212,'default','added',2815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14500}}',NULL,'2023-12-27 13:34:18','2023-12-27 13:34:18'),(4213,'default','added',2816,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-27 13:38:52','2023-12-27 13:38:52'),(4214,'default','payment_edited',2541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"}}',NULL,'2023-12-27 13:40:44','2023-12-27 13:40:44'),(4215,'default','added',2817,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1050}}',NULL,'2023-12-27 13:45:02','2023-12-27 13:45:02'),(4216,'default','added',2818,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-27 13:48:55','2023-12-27 13:48:55'),(4217,'default','payment_edited',2749,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"219020.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"219020.0000\"}}',NULL,'2023-12-27 13:51:16','2023-12-27 13:51:16'),(4218,'default','added',2819,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-27 13:53:27','2023-12-27 13:53:27'),(4219,'default','payment_edited',2628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"56560.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"56560.0000\"}}',NULL,'2023-12-27 14:01:22','2023-12-27 14:01:22'),(4220,'default','payment_edited',1942,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"47200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"47200.0000\"}}',NULL,'2023-12-27 14:03:37','2023-12-27 14:03:37'),(4221,'default','payment_edited',2389,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"61000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"61000.0000\"}}',NULL,'2023-12-27 14:03:37','2023-12-27 14:03:37'),(4222,'default','added',2820,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-12-27 14:06:09','2023-12-27 14:06:09'),(4223,'default','added',2821,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4950}}',NULL,'2023-12-27 14:26:02','2023-12-27 14:26:02'),(4224,'default','edited',121,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 14:27:41','2023-12-27 14:27:41'),(4225,'default','added',146,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 14:43:40','2023-12-27 14:43:40'),(4226,'default','added',2822,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7600}}',NULL,'2023-12-27 14:44:59','2023-12-27 14:44:59'),(4227,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 14:46:30','2023-12-27 14:46:30'),(4228,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 17:40:34','2023-12-27 17:40:34'),(4229,'default','added',2823,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-12-27 17:40:51','2023-12-27 17:40:51'),(4230,'default','payment_edited',2765,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"254730.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"254730.0000\"}}',NULL,'2023-12-27 17:41:36','2023-12-27 17:41:36'),(4231,'default','added',2824,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":88000}}',NULL,'2023-12-27 17:49:40','2023-12-27 17:49:40'),(4232,'default','edited',2824,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":88000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"88000.0000\"}}',NULL,'2023-12-27 17:50:20','2023-12-27 17:50:20'),(4233,'default','added',2825,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4275}}',NULL,'2023-12-27 17:56:59','2023-12-27 17:56:59'),(4234,'default','added',2826,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-27 17:58:43','2023-12-27 17:58:43'),(4235,'default','added',2827,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-12-27 17:59:39','2023-12-27 17:59:39'),(4236,'default','added',2828,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12510}}',NULL,'2023-12-27 18:03:04','2023-12-27 18:03:04'),(4237,'default','added',2829,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13450}}',NULL,'2023-12-27 18:04:33','2023-12-27 18:04:33'),(4238,'default','added',2830,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1900}}',NULL,'2023-12-27 18:05:59','2023-12-27 18:05:59'),(4239,'default','added',2831,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8900}}',NULL,'2023-12-27 18:08:41','2023-12-27 18:08:41'),(4240,'default','added',2832,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-12-27 18:09:01','2023-12-27 18:09:01'),(4241,'default','added',147,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 18:10:20','2023-12-27 18:10:20'),(4242,'default','added',2833,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550}}',NULL,'2023-12-27 18:11:09','2023-12-27 18:11:09'),(4243,'default','added',2834,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5010}}',NULL,'2023-12-27 18:11:50','2023-12-27 18:11:50'),(4244,'default','added',2835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":424800}}',NULL,'2023-12-27 18:17:27','2023-12-27 18:17:27'),(4245,'default','added',2836,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17821.04999999999927240423858165740966796875}}',NULL,'2023-12-27 18:21:58','2023-12-27 18:21:58'),(4246,'default','added',2837,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29552.4000000000014551915228366851806640625}}',NULL,'2023-12-27 18:26:10','2023-12-27 18:26:10'),(4247,'default','added',2838,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-12-27 18:40:43','2023-12-27 18:40:43'),(4248,'default','added',2839,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-27 18:41:45','2023-12-27 18:41:45'),(4249,'default','added',2840,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-12-27 18:46:08','2023-12-27 18:46:08'),(4250,'default','added',2841,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-12-27 19:08:49','2023-12-27 19:08:49'),(4251,'default','edited',2835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":421050},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"424800.0000\"}}',NULL,'2023-12-27 19:20:09','2023-12-27 19:20:09'),(4252,'default','payment_edited',2541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"414000.0000\"}}',NULL,'2023-12-27 19:26:20','2023-12-27 19:26:20'),(4253,'default','added',2842,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-27 19:49:26','2023-12-27 19:49:26'),(4254,'default','added',2843,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-27 19:50:47','2023-12-27 19:50:47'),(4255,'default','added',2844,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-27 19:51:51','2023-12-27 19:51:51'),(4256,'default','added',2845,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-12-27 19:57:35','2023-12-27 19:57:35'),(4257,'default','added',2846,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-27 19:57:56','2023-12-27 19:57:56'),(4258,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 20:03:10','2023-12-27 20:03:10'),(4259,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-27 20:04:55','2023-12-27 20:04:55'),(4260,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 10:19:54','2023-12-28 10:19:54'),(4261,'default','added',2847,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-28 10:20:27','2023-12-28 10:20:27'),(4262,'default','added',2848,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-28 10:24:26','2023-12-28 10:24:26'),(4263,'default','payment_edited',2833,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-12-28 10:25:26','2023-12-28 10:25:26'),(4264,'default','payment_edited',1916,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"}}',NULL,'2023-12-28 10:26:16','2023-12-28 10:26:16'),(4265,'default','payment_edited',2055,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-12-28 10:26:16','2023-12-28 10:26:16'),(4266,'default','added',2849,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-12-28 10:35:32','2023-12-28 10:35:32'),(4267,'default','added',2850,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-12-28 10:37:33','2023-12-28 10:37:33'),(4268,'default','added',2851,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":472}}',NULL,'2023-12-28 10:41:08','2023-12-28 10:41:08'),(4269,'default','added',2852,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-12-28 10:48:04','2023-12-28 10:48:04'),(4270,'default','payment_edited',134,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 10:48:32','2023-12-28 10:48:32'),(4271,'default','added',2853,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":17000}}',NULL,'2023-12-28 10:54:01','2023-12-28 10:54:01'),(4272,'default','added',2854,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-28 11:02:40','2023-12-28 11:02:40'),(4273,'default','added',2855,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-12-28 11:04:09','2023-12-28 11:04:09'),(4274,'default','added',2856,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-12-28 11:08:36','2023-12-28 11:08:36'),(4275,'default','added',2857,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13300}}',NULL,'2023-12-28 11:09:42','2023-12-28 11:09:42'),(4276,'default','added',2858,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10540}}',NULL,'2023-12-28 11:10:47','2023-12-28 11:10:47'),(4277,'default','added',2859,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5300}}',NULL,'2023-12-28 11:11:20','2023-12-28 11:11:20'),(4278,'default','payment_edited',2764,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-12-28 11:13:46','2023-12-28 11:13:46'),(4279,'default','payment_edited',2469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7530.0000\"}}',NULL,'2023-12-28 11:14:21','2023-12-28 11:14:21'),(4280,'default','added',2860,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-12-28 11:15:11','2023-12-28 11:15:11'),(4281,'default','added',2861,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-28 11:17:50','2023-12-28 11:17:50'),(4282,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 13:51:56','2023-12-28 13:51:56'),(4283,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 14:06:56','2023-12-28 14:06:56'),(4284,'default','added',2862,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2110}}',NULL,'2023-12-28 14:20:05','2023-12-28 14:20:05'),(4285,'default','added',2863,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20790}}',NULL,'2023-12-28 14:22:17','2023-12-28 14:22:17'),(4286,'default','payment_edited',2339,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-28 14:23:47','2023-12-28 14:23:47'),(4287,'default','payment_edited',2372,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-28 14:23:47','2023-12-28 14:23:47'),(4288,'default','payment_edited',2447,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-28 14:23:47','2023-12-28 14:23:47'),(4289,'default','payment_edited',2806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10700.0000\"}}',NULL,'2023-12-28 14:24:20','2023-12-28 14:24:20'),(4290,'default','added',2864,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-12-28 14:27:22','2023-12-28 14:27:22'),(4291,'default','added',2865,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-12-28 14:27:56','2023-12-28 14:27:56'),(4292,'default','added',2866,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-28 14:28:16','2023-12-28 14:28:16'),(4293,'default','added',2867,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17300}}',NULL,'2023-12-28 14:29:33','2023-12-28 14:29:33'),(4294,'default','added',2868,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4930}}',NULL,'2023-12-28 14:33:24','2023-12-28 14:33:24'),(4295,'default','edited',2868,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7380},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4930.0000\"}}',NULL,'2023-12-28 14:34:11','2023-12-28 14:34:11'),(4296,'default','edited',2868,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4930},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7380.0000\"}}',NULL,'2023-12-28 14:36:59','2023-12-28 14:36:59'),(4297,'default','added',2869,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-12-28 14:37:33','2023-12-28 14:37:33'),(4298,'default','added',2870,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3700}}',NULL,'2023-12-28 14:42:16','2023-12-28 14:42:16'),(4299,'default','added',2871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12750}}',NULL,'2023-12-28 14:43:00','2023-12-28 14:43:00'),(4300,'default','added',2872,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-12-28 14:43:31','2023-12-28 14:43:31'),(4301,'default','added',2873,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-12-28 14:46:49','2023-12-28 14:46:49'),(4302,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 14:58:47','2023-12-28 14:58:47'),(4303,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 16:16:29','2023-12-28 16:16:29'),(4304,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 18:08:13','2023-12-28 18:08:13'),(4305,'default','added',2874,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6498}}',NULL,'2023-12-28 18:09:53','2023-12-28 18:09:53'),(4306,'default','added',2875,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5950}}',NULL,'2023-12-28 18:12:14','2023-12-28 18:12:14'),(4307,'default','added',2876,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11650}}',NULL,'2023-12-28 18:14:53','2023-12-28 18:14:53'),(4308,'default','added',2877,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":94050}}',NULL,'2023-12-28 18:17:42','2023-12-28 18:17:42'),(4309,'default','added',2878,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1925}}',NULL,'2023-12-28 18:20:49','2023-12-28 18:20:49'),(4310,'default','added',2879,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-28 18:22:31','2023-12-28 18:22:31'),(4311,'default','added',2880,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14124.9599999999991268850862979888916015625}}',NULL,'2023-12-28 18:23:50','2023-12-28 18:23:50'),(4312,'default','added',2881,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69831}}',NULL,'2023-12-28 18:37:26','2023-12-28 18:37:26'),(4313,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 18:40:12','2023-12-28 18:40:12'),(4314,'default','added',2882,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-28 18:46:50','2023-12-28 18:46:50'),(4315,'default','payment_edited',2192,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"260000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"260000.0000\"}}',NULL,'2023-12-28 19:03:48','2023-12-28 19:03:48'),(4316,'default','added',2883,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-28 19:10:29','2023-12-28 19:10:29'),(4317,'default','added',2884,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2970}}',NULL,'2023-12-28 19:36:34','2023-12-28 19:36:34'),(4318,'default','added',2885,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-28 19:37:17','2023-12-28 19:37:17'),(4319,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 20:08:19','2023-12-28 20:08:19'),(4320,'default','added',2886,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-12-28 20:22:02','2023-12-28 20:22:02'),(4321,'default','added',2887,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8500}}',NULL,'2023-12-28 20:28:39','2023-12-28 20:28:39'),(4322,'default','added',2888,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11650}}',NULL,'2023-12-28 20:32:36','2023-12-28 20:32:36'),(4323,'default','added',2889,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":4950}}',NULL,'2023-12-28 20:37:14','2023-12-28 20:37:14'),(4324,'default','added',2890,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-12-28 21:07:57','2023-12-28 21:07:57'),(4325,'default','sell_deleted',2890,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":2890,\"invoice_no\":\"2370\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"}}',NULL,'2023-12-28 21:09:54','2023-12-28 21:09:54'),(4326,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 21:22:33','2023-12-28 21:22:33'),(4327,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-28 21:54:26','2023-12-28 21:54:26'),(4328,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-29 02:56:17','2023-12-29 02:56:17'),(4329,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-12-30 11:19:20','2023-12-30 11:19:20'),(4330,'default','added',2891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-12-30 11:20:48','2023-12-30 11:20:48'),(4331,'default','added',2892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5350}}',NULL,'2023-12-30 11:26:33','2023-12-30 11:26:33'),(4332,'default','added',2893,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-12-30 11:26:52','2023-12-30 11:26:52'),(4333,'default','payment_edited',2447,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-30 11:31:53','2023-12-30 11:31:53'),(4334,'default','payment_edited',2471,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-12-30 11:31:53','2023-12-30 11:31:53'),(4335,'default','added',2894,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-12-30 11:39:45','2023-12-30 11:39:45'),(4336,'default','added',2895,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-12-30 11:47:11','2023-12-30 11:47:11'),(4337,'default','added',2896,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20600}}',NULL,'2023-12-30 11:52:33','2023-12-30 11:52:33'),(4338,'default','added',2897,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8750}}',NULL,'2023-12-30 11:54:41','2023-12-30 11:54:41'),(4339,'default','added',2898,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25071}}',NULL,'2023-12-30 11:57:13','2023-12-30 11:57:13'),(4340,'default','added',148,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-12-30 11:58:14','2023-12-30 11:58:14'),(4341,'default','added',2899,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5100}}',NULL,'2023-12-30 12:03:02','2023-12-30 12:03:02'),(4342,'default','added',2900,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-30 12:04:37','2023-12-30 12:04:37'),(4343,'default','added',2901,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-30 12:05:14','2023-12-30 12:05:14'),(4344,'default','added',2902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7700}}',NULL,'2023-12-30 12:07:18','2023-12-30 12:07:18'),(4345,'default','added',2903,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-30 12:07:34','2023-12-30 12:07:34'),(4346,'default','payment_edited',2756,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-12-30 12:08:00','2023-12-30 12:08:00'),(4347,'default','added',2904,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10950}}',NULL,'2023-12-30 12:17:02','2023-12-30 12:17:02'),(4348,'default','payment_edited',2469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7530.0000\"}}',NULL,'2023-12-30 12:17:26','2023-12-30 12:17:26'),(4349,'default','payment_edited',2519,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"f