
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text COLLATE utf8mb4_unicode_ci,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `batch_uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2004 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 17:32:22','2023-10-15 17:32:22'),(2,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 17:59:17','2023-10-15 17:59:17'),(3,'default','added',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 18:23:51','2023-10-15 18:23:51'),(4,'default','added',1,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7507650}}',NULL,'2023-10-15 18:24:30','2023-10-15 18:24:30'),(5,'default','added',2,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41075}}',NULL,'2023-10-15 18:28:40','2023-10-15 18:28:40'),(6,'default','added',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 18:30:44','2023-10-15 18:30:44'),(7,'default','added',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17280}}',NULL,'2023-10-15 18:31:53','2023-10-15 18:31:53'),(8,'default','added',4,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":421.3999999999999772626324556767940521240234375}}',NULL,'2023-10-15 18:59:04','2023-10-15 18:59:04'),(9,'default','edited',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17280.0000\"}}',NULL,'2023-10-15 19:00:11','2023-10-15 19:00:11'),(10,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:04','2023-10-15 19:04:04'),(11,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:09','2023-10-15 19:04:09'),(12,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:31','2023-10-15 19:04:31'),(13,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 19:04:35','2023-10-15 19:04:35'),(14,'default','edited',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17280.0000\"}}',NULL,'2023-10-15 19:11:44','2023-10-15 19:11:44'),(15,'default','added',5,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4437}}',NULL,'2023-10-15 19:24:34','2023-10-15 19:24:34'),(16,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 01:02:01','2023-10-16 01:02:01'),(17,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-17 17:27:10','2023-10-17 17:27:10'),(18,'default','added',6,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":442}}',NULL,'2023-10-17 17:28:45','2023-10-17 17:28:45'),(19,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-18 13:38:23','2023-10-18 13:38:23'),(20,'default','sell_deleted',6,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":6,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"442.0000\"}}',NULL,'2023-10-18 16:56:51','2023-10-18 16:56:51'),(21,'default','sell_deleted',5,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":5,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4437.0000\"}}',NULL,'2023-10-18 16:56:55','2023-10-18 16:56:55'),(22,'default','sell_deleted',4,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":4,\"invoice_no\":\"0003\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"421.4000\"}}',NULL,'2023-10-18 16:57:01','2023-10-18 16:57:01'),(23,'default','sell_deleted',3,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":3,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17280.0000\"}}',NULL,'2023-10-18 16:57:05','2023-10-18 16:57:05'),(24,'default','sell_deleted',2,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":2,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"41075.0000\"}}',NULL,'2023-10-18 16:57:14','2023-10-18 16:57:14'),(25,'default','purchase_deleted',1,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"7507650.0000\"}}',NULL,'2023-10-18 17:00:12','2023-10-18 17:00:12'),(26,'default','added',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-18 17:03:45','2023-10-18 17:03:45'),(27,'default','added',7,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":133500}}',NULL,'2023-10-18 17:04:37','2023-10-18 17:04:37'),(28,'default','added',8,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-10-18 17:06:54','2023-10-18 17:06:54'),(29,'default','added',9,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":80000}}',NULL,'2023-10-18 17:24:40','2023-10-18 17:24:40'),(30,'default','added',10,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4700}}',NULL,'2023-10-18 17:29:46','2023-10-18 17:29:46'),(31,'default','added',11,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":0}}',NULL,'2023-10-18 17:39:54','2023-10-18 17:39:54'),(32,'default','added',12,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1450}}',NULL,'2023-10-18 17:42:39','2023-10-18 17:42:39'),(33,'default','payment_edited',12,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2023-10-18 17:43:46','2023-10-18 17:43:46'),(34,'default','added',13,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":0}}',NULL,'2023-10-18 17:51:57','2023-10-18 17:51:57'),(35,'default','added',14,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":2800}}',NULL,'2023-10-18 17:53:37','2023-10-18 17:53:37'),(36,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 01:25:17','2023-10-19 01:25:17'),(37,'default','added',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 02:06:24','2023-10-19 02:06:24'),(38,'default','added',15,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":16950}}',NULL,'2023-10-19 02:07:00','2023-10-19 02:07:00'),(39,'default','edited',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 02:09:07','2023-10-19 02:09:07'),(40,'default','contact_deleted',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 02:09:19','2023-10-19 02:09:19'),(41,'default','added',16,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1525}}',NULL,'2023-10-19 02:20:33','2023-10-19 02:20:33'),(42,'default','added',17,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-10-19 14:27:35','2023-10-19 14:27:35'),(43,'default','added',18,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-10-19 14:28:15','2023-10-19 14:28:15'),(44,'default','added',19,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":208000}}',NULL,'2023-10-19 14:35:00','2023-10-19 14:35:00'),(45,'default','added',20,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4700}}',NULL,'2023-10-19 14:38:14','2023-10-19 14:38:14'),(46,'default','added',21,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":70}}',NULL,'2023-10-19 14:38:44','2023-10-19 14:38:44'),(47,'default','added',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:25:55','2023-10-19 16:25:55'),(48,'default','added',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:29:34','2023-10-19 16:29:34'),(49,'default','edited',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:30:09','2023-10-19 16:30:09'),(50,'default','edited',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:30:25','2023-10-19 16:30:25'),(51,'default','added',8,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:34:28','2023-10-19 16:34:28'),(52,'default','added',9,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:36:27','2023-10-19 16:36:27'),(53,'default','added',10,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:39:12','2023-10-19 16:39:12'),(54,'default','added',11,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:41:22','2023-10-19 16:41:22'),(55,'default','edited',11,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:41:42','2023-10-19 16:41:42'),(56,'default','added',12,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:47:47','2023-10-19 16:47:47'),(57,'default','added',13,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:50:51','2023-10-19 16:50:51'),(58,'default','added',14,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:52:11','2023-10-19 16:52:11'),(59,'default','added',15,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:53:37','2023-10-19 16:53:37'),(60,'default','added',16,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:54:46','2023-10-19 16:54:46'),(61,'default','edited',16,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:55:05','2023-10-19 16:55:05'),(62,'default','added',17,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:56:37','2023-10-19 16:56:37'),(63,'default','added',18,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 16:57:41','2023-10-19 16:57:41'),(64,'default','added',19,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:01:48','2023-10-19 17:01:48'),(65,'default','added',20,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:02:40','2023-10-19 17:02:40'),(66,'default','added',21,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:04:13','2023-10-19 17:04:13'),(67,'default','added',22,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:05:48','2023-10-19 17:05:48'),(68,'default','added',23,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:07:23','2023-10-19 17:07:23'),(69,'default','added',24,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:10:38','2023-10-19 17:10:38'),(70,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:17:55','2023-10-19 17:17:55'),(71,'default','edited',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:19:52','2023-10-19 17:19:52'),(72,'default','edited',24,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:21:50','2023-10-19 17:21:50'),(73,'default','edited',24,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 17:22:47','2023-10-19 17:22:47'),(75,'default','sell_deleted',15,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":15,\"invoice_no\":\"0007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16950.0000\"}}',NULL,'2023-10-19 18:01:46','2023-10-19 18:01:46'),(76,'default','sell_deleted',16,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":16,\"invoice_no\":\"0008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1525.0000\"}}',NULL,'2023-10-19 18:01:53','2023-10-19 18:01:53'),(77,'default','sell_deleted',17,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":17,\"invoice_no\":\"0009\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"70.0000\"}}',NULL,'2023-10-19 18:01:58','2023-10-19 18:01:58'),(78,'default','sell_deleted',21,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":21,\"invoice_no\":\"0012\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"70.0000\"}}',NULL,'2023-10-19 18:02:06','2023-10-19 18:02:06'),(79,'default','sell_deleted',20,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":20,\"invoice_no\":\"0011\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-19 18:02:10','2023-10-19 18:02:10'),(80,'default','sell_deleted',18,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":18,\"invoice_no\":\"0010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-19 18:02:14','2023-10-19 18:02:14'),(81,'default','sell_deleted',10,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":10,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-19 18:02:46','2023-10-19 18:02:46'),(82,'default','purchase_deleted',19,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"208000.0000\"}}',NULL,'2023-10-19 18:03:02','2023-10-19 18:03:02'),(83,'default','purchase_deleted',11,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-10-19 18:03:57','2023-10-19 18:03:57'),(84,'default','purchase_deleted',9,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"80000.0000\"}}',NULL,'2023-10-19 18:04:06','2023-10-19 18:04:06'),(85,'default','purchase_deleted',7,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"133500.0000\"}}',NULL,'2023-10-19 18:04:10','2023-10-19 18:04:10'),(86,'default','purchase_deleted',8,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-10-19 18:04:14','2023-10-19 18:04:14'),(87,'default','added',24,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":560500}}',NULL,'2023-10-19 18:12:30','2023-10-19 18:12:30'),(88,'default','added',25,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":22870}}',NULL,'2023-10-19 18:18:23','2023-10-19 18:18:23'),(89,'default','added',26,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4840}}',NULL,'2023-10-19 18:33:39','2023-10-19 18:33:39'),(90,'default','added',27,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7040}}',NULL,'2023-10-21 14:27:58','2023-10-21 14:27:58'),(91,'default','added',28,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1540}}',NULL,'2023-10-21 14:31:39','2023-10-21 14:31:39'),(92,'default','added',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":770}}',NULL,'2023-10-21 14:32:36','2023-10-21 14:32:36'),(93,'default','edited',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":-154},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"770.0000\"}}',NULL,'2023-10-21 14:35:36','2023-10-21 14:35:36'),(94,'default','added',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3168}}',NULL,'2023-10-21 14:41:28','2023-10-21 14:41:28'),(95,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:41:55','2023-10-21 14:41:55'),(96,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:42:05','2023-10-21 14:42:05'),(97,'default','payment_edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:42:50','2023-10-21 14:42:50'),(98,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:43:19','2023-10-21 14:43:19'),(99,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:44:21','2023-10-21 14:44:21'),(100,'default','added',31,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":30000}}',NULL,'2023-10-21 14:45:05','2023-10-21 14:45:05'),(101,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:45:22','2023-10-21 14:45:22'),(102,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:46:08','2023-10-21 14:46:08'),(103,'default','edited',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":3168},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3168.0000\"}}',NULL,'2023-10-21 14:46:52','2023-10-21 14:46:52'),(104,'default','added',32,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3190}}',NULL,'2023-10-21 14:48:14','2023-10-21 14:48:14'),(105,'default','payment_edited',32,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3190.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3190.0000\"}}',NULL,'2023-10-21 14:49:00','2023-10-21 14:49:00'),(106,'default','payment_edited',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-154.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-154.0000\"}}',NULL,'2023-10-21 14:49:10','2023-10-21 14:49:10'),(107,'default','edited',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":308},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"-154.0000\"}}',NULL,'2023-10-21 14:50:07','2023-10-21 14:50:07'),(108,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:53:16','2023-10-21 14:53:16'),(109,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:59:05','2023-10-21 14:59:05'),(110,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:29:43','2023-10-21 15:29:43'),(111,'default','added',33,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5170}}',NULL,'2023-10-21 15:31:32','2023-10-21 15:31:32'),(112,'default','added',25,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:32:48','2023-10-21 15:32:48'),(113,'default','added',34,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3300}}',NULL,'2023-10-21 15:33:00','2023-10-21 15:33:00'),(114,'default','sell_deleted',34,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":34,\"invoice_no\":\"0018\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-21 15:40:46','2023-10-21 15:40:46'),(115,'default','sell_deleted',33,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":33,\"invoice_no\":\"0017\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5170.0000\"}}',NULL,'2023-10-21 15:41:00','2023-10-21 15:41:00'),(116,'default','sell_deleted',28,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":28,\"invoice_no\":\"0016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1540.0000\"}}',NULL,'2023-10-21 15:41:39','2023-10-21 15:41:39'),(117,'default','sell_deleted',27,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":27,\"invoice_no\":\"0015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7040.0000\"}}',NULL,'2023-10-21 15:41:43','2023-10-21 15:41:43'),(118,'default','sell_deleted',26,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":26,\"invoice_no\":\"0014\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4840.0000\"}}',NULL,'2023-10-21 15:41:46','2023-10-21 15:41:46'),(119,'default','sell_deleted',25,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":25,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"22870.0000\"}}',NULL,'2023-10-21 15:41:51','2023-10-21 15:41:51'),(120,'default','purchase_deleted',24,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"560500.0000\"}}',NULL,'2023-10-21 15:42:25','2023-10-21 15:42:25'),(121,'default','contact_deleted',25,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:44:01','2023-10-21 15:44:01'),(122,'default','contact_deleted',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:45:11','2023-10-21 15:45:11'),(123,'default','contact_deleted',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:45:19','2023-10-21 15:45:19'),(124,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:09:17','2023-10-21 19:09:17'),(125,'default','added',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" \\u0986\\u0995\\u09b0\\u09be\\u09ae \\u0986\\u09b2\\u09c0 \\u0985\\u09cd\\u09af\\u09be\\u09a8\\u09cd\\u09a1 \\u09b8\\u09a8\\u09cd\\u09b8\"}',NULL,'2023-10-21 19:12:28','2023-10-21 19:12:28'),(126,'default','edited',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Abdus Subahan Manna\"}',NULL,'2023-10-21 19:13:25','2023-10-21 19:13:25'),(127,'default','added',3,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Abdus Subahan Manna\"}',NULL,'2023-10-21 19:15:29','2023-10-21 19:15:29'),(128,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:16:32','2023-10-21 19:16:32'),(129,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:16:42','2023-10-21 19:16:42'),(130,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 19:16:55','2023-10-21 19:16:55'),(131,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-21 19:17:00','2023-10-21 19:17:00'),(132,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-21 19:17:06','2023-10-21 19:17:06'),(133,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 19:43:04','2023-10-21 19:43:04'),(134,'default','added',26,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 19:46:50','2023-10-21 19:46:50'),(135,'default','added',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191460}}',NULL,'2023-10-21 19:51:58','2023-10-21 19:51:58'),(136,'default','edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191810},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191460.0000\"}}',NULL,'2023-10-21 19:56:07','2023-10-21 19:56:07'),(137,'default','edited',26,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 19:58:33','2023-10-21 19:58:33'),(138,'default','edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191820},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191810.0000\"}}',NULL,'2023-10-21 20:00:42','2023-10-21 20:00:42'),(139,'default','edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":191490},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191820.0000\"}}',NULL,'2023-10-21 20:03:03','2023-10-21 20:03:03'),(140,'default','payment_edited',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"191490.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"191490.0000\"}}',NULL,'2023-10-21 20:04:10','2023-10-21 20:04:10'),(141,'default','payment_edited',36,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 20:04:10','2023-10-21 20:04:10'),(142,'default','added',37,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-21 20:05:52','2023-10-21 20:05:52'),(143,'default','payment_edited',37,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-21 20:06:23','2023-10-21 20:06:23'),(144,'default','added',38,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-10-21 20:20:13','2023-10-21 20:20:13'),(145,'default','added',39,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":2200}}',NULL,'2023-10-21 20:25:26','2023-10-21 20:25:26'),(146,'default','added',27,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 20:32:03','2023-10-21 20:32:03'),(147,'default','added',40,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-10-21 20:32:09','2023-10-21 20:32:09'),(148,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 20:38:06','2023-10-21 20:38:06'),(149,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 21:40:58','2023-10-21 21:40:58'),(150,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 21:45:53','2023-10-21 21:45:53'),(151,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-21 21:46:53','2023-10-21 21:46:53'),(152,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-22 11:53:44','2023-10-22 11:53:44'),(153,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-22 11:55:59','2023-10-22 11:55:59'),(154,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 11:56:52','2023-10-22 11:56:52'),(155,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:13:39','2023-10-22 12:13:39'),(156,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:31:23','2023-10-22 12:31:23'),(157,'default','edited',7,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:37:40','2023-10-22 12:37:40'),(158,'default','edited',8,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:39:00','2023-10-22 12:39:00'),(159,'default','edited',9,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:40:23','2023-10-22 12:40:23'),(160,'default','edited',10,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:41:43','2023-10-22 12:41:43'),(161,'default','edited',11,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:42:45','2023-10-22 12:42:45'),(162,'default','edited',5,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:44:12','2023-10-22 12:44:12'),(163,'default','edited',13,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:48:33','2023-10-22 12:48:33'),(164,'default','edited',14,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:51:15','2023-10-22 12:51:15'),(165,'default','edited',16,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 12:55:15','2023-10-22 12:55:15'),(166,'default','edited',17,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:21:44','2023-10-22 13:21:44'),(167,'default','edited',18,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:23:53','2023-10-22 13:23:53'),(168,'default','edited',20,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:26:14','2023-10-22 13:26:14'),(169,'default','edited',21,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:27:42','2023-10-22 13:27:42'),(170,'default','edited',22,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:31:04','2023-10-22 13:31:04'),(171,'default','edited',23,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:32:54','2023-10-22 13:32:54'),(172,'default','edited',15,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:35:16','2023-10-22 13:35:16'),(173,'default','edited',19,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:37:16','2023-10-22 13:37:16'),(174,'default','edited',6,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:38:58','2023-10-22 13:38:58'),(175,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:40:06','2023-10-22 13:40:06'),(176,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:40:30','2023-10-22 13:40:30'),(177,'default','added',28,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:46:43','2023-10-22 13:46:43'),(178,'default','added',29,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:49:21','2023-10-22 13:49:21'),(179,'default','added',30,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:50:52','2023-10-22 13:50:52'),(180,'default','added',31,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:55:18','2023-10-22 13:55:18'),(181,'default','added',32,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 13:56:36','2023-10-22 13:56:36'),(182,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:00:23','2023-10-22 14:00:23'),(183,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:00:40','2023-10-22 14:00:40'),(184,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:00:59','2023-10-22 14:00:59'),(185,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:02:43','2023-10-22 14:02:43'),(186,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-22 14:03:25','2023-10-22 14:03:25'),(187,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-22 14:08:30','2023-10-22 14:08:30'),(188,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-22 14:11:18','2023-10-22 14:11:18'),(189,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 14:12:01','2023-10-22 14:12:01'),(190,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 17:35:44','2023-10-22 17:35:44'),(191,'default','sell_deleted',38,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":38,\"invoice_no\":\"0019\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-22 17:41:52','2023-10-22 17:41:52'),(192,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 17:52:25','2023-10-22 17:52:25'),(193,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-22 17:53:56','2023-10-22 17:53:56'),(194,'default','purchase_deleted',40,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-10-22 18:10:27','2023-10-22 18:10:27'),(195,'default','sell_deleted',39,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":39,\"invoice_no\":\"2023\\/0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-22 18:15:39','2023-10-22 18:15:39'),(196,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 00:39:23','2023-10-23 00:39:23'),(197,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 00:40:04','2023-10-23 00:40:04'),(198,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 00:40:29','2023-10-23 00:40:29'),(199,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 00:49:07','2023-10-23 00:49:07'),(200,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 00:49:14','2023-10-23 00:49:14'),(201,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:08:03','2023-10-23 13:08:03'),(202,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:08:32','2023-10-23 13:08:32'),(203,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:51:36','2023-10-23 13:51:36'),(204,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 13:59:14','2023-10-23 13:59:14'),(205,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 13:59:26','2023-10-23 13:59:26'),(206,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-23 16:42:06','2023-10-23 16:42:06'),(207,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-23 16:42:12','2023-10-23 16:42:12'),(208,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 18:49:23','2023-10-24 18:49:24'),(209,'default','added',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":61940}}',NULL,'2023-10-24 19:38:50','2023-10-24 19:38:50'),(210,'default','added',33,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:42:16','2023-10-24 19:42:16'),(211,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:47:21','2023-10-24 19:47:21'),(212,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:53:13','2023-10-24 19:53:13'),(213,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 19:59:28','2023-10-24 19:59:28'),(214,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-24 20:01:23','2023-10-24 20:01:23'),(215,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 10:28:16','2023-10-25 10:28:16'),(216,'default','added',34,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 11:27:03','2023-10-25 11:27:03'),(217,'default','added',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":377400}}',NULL,'2023-10-25 11:34:03','2023-10-25 11:34:03'),(218,'default','edited',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":341880},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"377400.0000\"}}',NULL,'2023-10-25 11:38:29','2023-10-25 11:38:29'),(219,'default','added',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50160}}',NULL,'2023-10-25 11:40:10','2023-10-25 11:40:10'),(220,'default','added',61,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":16020}}',NULL,'2023-10-25 11:43:37','2023-10-25 11:43:37'),(221,'default','added',62,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":18690}}',NULL,'2023-10-25 11:45:01','2023-10-25 11:45:01'),(222,'default','added',63,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":55944}}',NULL,'2023-10-25 11:50:47','2023-10-25 11:50:47'),(223,'default','added',64,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1192759}}',NULL,'2023-10-25 12:30:38','2023-10-25 12:30:38'),(224,'default','payment_edited',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"341880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"341880.0000\"}}',NULL,'2023-10-25 12:32:18','2023-10-25 12:32:18'),(225,'default','payment_edited',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"61940.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"61940.0000\"}}',NULL,'2023-10-25 12:33:02','2023-10-25 12:33:02'),(226,'default','added',65,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":338965}}',NULL,'2023-10-25 12:35:17','2023-10-25 12:35:17'),(227,'default','added',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":295394}}',NULL,'2023-10-25 13:01:34','2023-10-25 13:01:34'),(228,'default','edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":295394},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"295394.0000\"}}',NULL,'2023-10-25 13:30:03','2023-10-25 13:30:03'),(229,'default','added',67,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase_return\",\"final_total\":149350}}',NULL,'2023-10-25 13:52:01','2023-10-25 13:52:01'),(230,'default','edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":366058},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"295394.0000\"}}',NULL,'2023-10-25 14:05:16','2023-10-25 14:05:16'),(231,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"366058.0000\"}}',NULL,'2023-10-25 14:05:49','2023-10-25 14:05:49'),(232,'default','added',68,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":211250}}',NULL,'2023-10-25 14:17:21','2023-10-25 14:17:21'),(233,'default','added',69,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":87080}}',NULL,'2023-10-25 14:20:38','2023-10-25 14:20:38'),(234,'default','purchase_deleted',59,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"341880.0000\"}}',NULL,'2023-10-25 14:23:00','2023-10-25 14:23:00'),(235,'default','edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":392040},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50160.0000\"}}',NULL,'2023-10-25 14:24:09','2023-10-25 14:24:09'),(236,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"392040.0000\"}}',NULL,'2023-10-25 14:25:06','2023-10-25 14:25:06'),(237,'default','added',70,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50305}}',NULL,'2023-10-25 14:32:19','2023-10-25 14:32:19'),(238,'default','added',71,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":272320}}',NULL,'2023-10-25 14:35:37','2023-10-25 14:35:37'),(239,'default','added',72,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":93779}}',NULL,'2023-10-25 14:47:24','2023-10-25 14:47:24'),(240,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 14:56:07','2023-10-25 14:56:07'),(241,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 14:56:33','2023-10-25 14:56:33'),(242,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 14:58:48','2023-10-25 14:58:48'),(243,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 14:58:57','2023-10-25 14:58:57'),(244,'default','added',73,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6060}}',NULL,'2023-10-25 15:02:43','2023-10-25 15:02:43'),(245,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:08:37','2023-10-25 15:08:37'),(246,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:09:20','2023-10-25 15:09:20'),(247,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:09:25','2023-10-25 15:09:25'),(248,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:09:45','2023-10-25 15:09:45'),(249,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:09:50','2023-10-25 15:09:50'),(250,'default','added',74,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":25850}}',NULL,'2023-10-25 15:10:36','2023-10-25 15:10:36'),(251,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:11:40','2023-10-25 15:11:40'),(252,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:11:47','2023-10-25 15:11:47'),(253,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:12:27','2023-10-25 15:12:27'),(254,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:12:34','2023-10-25 15:12:34'),(255,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:13:52','2023-10-25 15:13:52'),(256,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:13:57','2023-10-25 15:13:57'),(257,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:14:46','2023-10-25 15:14:46'),(258,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:14:51','2023-10-25 15:14:51'),(259,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:15:43','2023-10-25 15:15:43'),(260,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:15:56','2023-10-25 15:15:56'),(261,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:16:40','2023-10-25 15:16:40'),(262,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:16:46','2023-10-25 15:16:46'),(263,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:16:57','2023-10-25 15:16:57'),(264,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:17:03','2023-10-25 15:17:03'),(265,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:20:33','2023-10-25 15:20:33'),(266,'default','purchase_deleted',35,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"pending\",\"payment_status\":\"paid\",\"final_total\":\"191490.0000\"}}',NULL,'2023-10-25 15:31:18','2023-10-25 15:31:18'),(267,'default','edited',72,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":27625},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"93779.0000\"}}',NULL,'2023-10-25 15:40:55','2023-10-25 15:40:55'),(268,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:44:16','2023-10-25 15:44:16'),(269,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 15:44:21','2023-10-25 15:44:21'),(270,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:44:25','2023-10-25 15:44:25'),(271,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 15:49:54','2023-10-25 15:49:54'),(272,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 15:49:58','2023-10-25 15:49:58'),(273,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 17:37:29','2023-10-25 17:37:29'),(274,'default','edited',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":80522},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"61940.0000\"}}',NULL,'2023-10-25 18:17:30','2023-10-25 18:17:30'),(275,'default','payment_edited',62,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"18690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"18690.0000\"}}',NULL,'2023-10-25 18:21:31','2023-10-25 18:21:31'),(276,'default','payment_edited',61,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"16020.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"16020.0000\"}}',NULL,'2023-10-25 18:22:04','2023-10-25 18:22:04'),(277,'default','payment_edited',58,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"80522.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"80522.0000\"}}',NULL,'2023-10-25 18:22:36','2023-10-25 18:22:36'),(278,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 18:55:55','2023-10-25 18:55:55'),(279,'default','added',75,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":40480}}',NULL,'2023-10-25 19:02:11','2023-10-25 19:02:11'),(280,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 19:56:57','2023-10-25 19:56:57'),(281,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 19:57:04','2023-10-25 19:57:04'),(282,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-25 19:57:26','2023-10-25 19:57:26'),(283,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 19:57:31','2023-10-25 19:57:31'),(284,'default','added',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":502690}}',NULL,'2023-10-25 20:27:43','2023-10-25 20:27:43'),(285,'default','payment_edited',71,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"272320.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"272320.0000\"}}',NULL,'2023-10-25 20:29:45','2023-10-25 20:29:45'),(286,'default','added',77,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5370}}',NULL,'2023-10-25 20:34:15','2023-10-25 20:34:15'),(287,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-25 20:53:38','2023-10-25 20:53:38'),(288,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 12:23:41','2023-10-26 12:23:41'),(289,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-10-26 12:43:23','2023-10-26 12:43:23'),(290,'default','added',78,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36440}}',NULL,'2023-10-26 13:00:03','2023-10-26 13:00:03'),(291,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 13:00:24','2023-10-26 13:00:24'),(292,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 13:16:38','2023-10-26 13:16:38'),(293,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-26 13:19:45','2023-10-26 13:19:45'),(294,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-26 13:19:51','2023-10-26 13:19:51'),(295,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 13:19:55','2023-10-26 13:19:55'),(296,'default','edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":502690},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"502690.0000\"}}',NULL,'2023-10-26 14:52:36','2023-10-26 14:52:36'),(297,'default','edited',64,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":1192759},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"1192759.0000\"}}',NULL,'2023-10-26 14:54:15','2023-10-26 14:54:15'),(298,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 17:33:03','2023-10-26 17:33:03'),(299,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-26 17:33:06','2023-10-26 17:33:06'),(300,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 13:58:24','2023-10-27 13:58:24'),(301,'default','added',79,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15110}}',NULL,'2023-10-27 14:05:25','2023-10-27 14:05:25'),(302,'default','added',80,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":129930}}',NULL,'2023-10-27 14:29:48','2023-10-27 14:29:48'),(303,'default','added',81,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21330}}',NULL,'2023-10-27 14:47:33','2023-10-27 14:47:33'),(304,'default','added',82,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":79192}}',NULL,'2023-10-27 15:01:40','2023-10-27 15:01:40'),(305,'default','added',83,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1040}}',NULL,'2023-10-27 15:04:16','2023-10-27 15:04:16'),(306,'default','added',84,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7600}}',NULL,'2023-10-27 15:07:34','2023-10-27 15:07:34'),(307,'default','added',85,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9120}}',NULL,'2023-10-27 15:08:14','2023-10-27 15:08:14'),(308,'default','added',86,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18370}}',NULL,'2023-10-27 15:13:43','2023-10-27 15:13:43'),(309,'default','added',87,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76000}}',NULL,'2023-10-27 15:16:47','2023-10-27 15:16:47'),(310,'default','added',88,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-10-27 15:18:48','2023-10-27 15:18:48'),(311,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 15:23:16','2023-10-27 15:23:16'),(312,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 19:17:00','2023-10-27 19:17:00'),(313,'default','added',89,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:22:30','2023-10-27 19:22:30'),(314,'default','added',90,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:27:04','2023-10-27 19:27:04'),(315,'default','added',91,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:36:44','2023-10-27 19:36:44'),(316,'default','added',92,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:37:39','2023-10-27 19:37:39'),(317,'default','added',93,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:38:22','2023-10-27 19:38:22'),(318,'default','added',94,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:38:56','2023-10-27 19:38:56'),(319,'default','added',95,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-27 19:40:26','2023-10-27 19:40:26'),(320,'default','edited',27,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:05:15','2023-10-27 20:05:15'),(321,'default','contact_deleted',27,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:05:36','2023-10-27 20:05:36'),(322,'default','added',35,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:07:14','2023-10-27 20:07:14'),(323,'default','edited',12,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:12:38','2023-10-27 20:12:38'),(324,'default','added',36,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:14:00','2023-10-27 20:14:00'),(325,'default','edited',36,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:16:18','2023-10-27 20:16:18'),(326,'default','added',37,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-27 20:18:39','2023-10-27 20:18:39'),(327,'default','added',99,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":169075}}',NULL,'2023-10-27 20:26:57','2023-10-27 20:26:57'),(328,'default','added',100,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":35250}}',NULL,'2023-10-27 20:32:56','2023-10-27 20:32:56'),(329,'default','edited',77,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5370},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5370.0000\"}}',NULL,'2023-10-27 23:28:21','2023-10-27 23:28:21'),(330,'default','edited',78,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36440},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"36440.0000\"}}',NULL,'2023-10-27 23:38:12','2023-10-27 23:38:12'),(331,'default','added',101,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-10-27 23:49:40','2023-10-27 23:49:40'),(332,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 01:04:47','2023-10-28 01:04:47'),(333,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 10:46:29','2023-10-28 10:46:29'),(334,'default','added',38,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:17:36','2023-10-28 11:17:36'),(335,'default','added',39,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:18:49','2023-10-28 11:18:49'),(336,'default','added',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:28:53','2023-10-28 11:28:53'),(337,'default','edited',35,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:30:59','2023-10-28 11:30:59'),(338,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 11:33:02','2023-10-28 11:33:02'),(339,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 12:08:14','2023-10-28 12:08:14'),(340,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 14:33:27','2023-10-28 14:33:27'),(341,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 17:29:16','2023-10-28 17:29:16'),(342,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 17:46:52','2023-10-28 17:46:52'),(343,'default','payment_edited',98,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 17:49:29','2023-10-28 17:49:29'),(344,'default','added',106,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25950}}',NULL,'2023-10-28 17:58:57','2023-10-28 17:58:57'),(345,'default','added',107,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9640}}',NULL,'2023-10-28 18:12:44','2023-10-28 18:12:44'),(346,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 18:14:22','2023-10-28 18:14:22'),(347,'default','added',108,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-10-28 18:20:17','2023-10-28 18:20:17'),(348,'default','sell_deleted',108,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":108,\"invoice_no\":\"0036\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-28 18:26:26','2023-10-28 18:26:26'),(349,'default','added',109,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12600}}',NULL,'2023-10-28 18:38:17','2023-10-28 18:38:17'),(350,'default','added',110,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35180}}',NULL,'2023-10-28 18:51:27','2023-10-28 18:51:27'),(351,'default','added',111,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40620}}',NULL,'2023-10-28 18:57:11','2023-10-28 18:57:11'),(352,'default','added',112,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-28 19:56:04','2023-10-28 19:56:04'),(353,'default','added',41,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 20:12:03','2023-10-28 20:12:03'),(354,'default','added',113,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":173140}}',NULL,'2023-10-28 20:15:10','2023-10-28 20:15:10'),(355,'default','added',114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":49860}}',NULL,'2023-10-28 20:17:16','2023-10-28 20:17:16'),(356,'default','payment_edited',71,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"272320.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"272320.0000\"}}',NULL,'2023-10-28 20:19:37','2023-10-28 20:19:37'),(357,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"502690.0000\"}}',NULL,'2023-10-28 20:19:37','2023-10-28 20:19:37'),(358,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-28 20:30:36','2023-10-28 20:30:36'),(359,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 12:41:14','2023-10-29 12:41:14'),(360,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 13:07:55','2023-10-29 13:07:55'),(361,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 13:07:59','2023-10-29 13:07:59'),(362,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 17:25:28','2023-10-29 17:25:28'),(363,'default','added',115,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3300}}',NULL,'2023-10-29 17:38:54','2023-10-29 17:38:54'),(364,'default','added',116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56561.0400000000008731149137020111083984375}}',NULL,'2023-10-29 17:45:19','2023-10-29 17:45:19'),(365,'default','added',117,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33068.949999999997089616954326629638671875}}',NULL,'2023-10-29 18:13:27','2023-10-29 18:13:27'),(366,'default','added',118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30660.02000000000043655745685100555419921875}}',NULL,'2023-10-29 18:20:12','2023-10-29 18:20:12'),(367,'default','added',119,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26150}}',NULL,'2023-10-29 18:25:17','2023-10-29 18:25:17'),(368,'default','added',120,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-10-29 18:28:13','2023-10-29 18:28:13'),(369,'default','added',42,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:31:37','2023-10-29 18:31:37'),(370,'default','added',121,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-10-29 18:32:36','2023-10-29 18:32:36'),(371,'default','added',122,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-10-29 18:35:11','2023-10-29 18:35:11'),(372,'default','added',123,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":97600}}',NULL,'2023-10-29 18:36:30','2023-10-29 18:36:30'),(373,'default','edited',123,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":115200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"97600.0000\"}}',NULL,'2023-10-29 18:37:39','2023-10-29 18:37:39'),(374,'default','added',43,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:38:26','2023-10-29 18:38:26'),(375,'default','added',124,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2400}}',NULL,'2023-10-29 18:39:13','2023-10-29 18:39:13'),(376,'default','added',125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-10-29 18:40:30','2023-10-29 18:40:30'),(377,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:42:55','2023-10-29 18:42:55'),(378,'default','added',126,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4770}}',NULL,'2023-10-29 18:44:44','2023-10-29 18:44:44'),(379,'default','payment_edited',42,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 18:45:33','2023-10-29 18:45:33'),(380,'default','added',127,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:49:00','2023-10-29 18:49:00'),(381,'default','added',128,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:50:23','2023-10-29 18:50:23'),(382,'default','payment_edited',68,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"211250.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"211250.0000\"}}',NULL,'2023-10-29 18:55:40','2023-10-29 18:55:40'),(383,'default','payment_edited',68,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"211250.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"211250.0000\"}}',NULL,'2023-10-29 18:56:17','2023-10-29 18:56:17'),(384,'default','payment_edited',99,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"169075.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"169075.0000\"}}',NULL,'2023-10-29 18:56:17','2023-10-29 18:56:17'),(385,'default','added',129,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:57:28','2023-10-29 18:57:28'),(386,'default','payment_edited',91,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:57:59','2023-10-29 18:57:59'),(387,'default','payment_edited',95,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:17','2023-10-29 18:58:17'),(388,'default','payment_edited',94,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:28','2023-10-29 18:58:28'),(389,'default','payment_edited',93,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:39','2023-10-29 18:58:39'),(390,'default','payment_edited',92,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-10-29 18:58:50','2023-10-29 18:58:50'),(391,'default','added',130,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-10-29 19:07:43','2023-10-29 19:07:43'),(392,'default','added',44,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:11:46','2023-10-29 19:11:46'),(393,'default','added',45,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:12:45','2023-10-29 19:12:45'),(394,'default','added',46,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:13:59','2023-10-29 19:13:59'),(395,'default','added',47,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:15:16','2023-10-29 19:15:16'),(396,'default','edited',38,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:17:12','2023-10-29 19:17:12'),(397,'default','payment_edited',103,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:19:10','2023-10-29 19:19:10'),(398,'default','payment_edited',36,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:30:27','2023-10-29 19:30:27'),(399,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"}}',NULL,'2023-10-29 19:30:27','2023-10-29 19:30:27'),(400,'default','added',135,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-10-29 19:44:55','2023-10-29 19:44:55'),(401,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 19:56:01','2023-10-29 19:56:01'),(402,'default','added',136,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-10-29 20:07:08','2023-10-29 20:07:08'),(403,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 20:22:44','2023-10-29 20:22:44'),(404,'default','added',137,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-10-29 20:52:09','2023-10-29 20:52:09'),(405,'default','added',138,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7830}}',NULL,'2023-10-29 20:59:34','2023-10-29 20:59:34'),(406,'default','added',140,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-10-29 21:04:43','2023-10-29 21:04:43'),(407,'default','added',141,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250}}',NULL,'2023-10-29 21:18:53','2023-10-29 21:18:53'),(408,'default','added',142,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5950}}',NULL,'2023-10-29 21:24:37','2023-10-29 21:24:37'),(409,'default','added',147,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-10-29 21:33:35','2023-10-29 21:33:35'),(410,'default','added',148,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4950}}',NULL,'2023-10-29 21:36:02','2023-10-29 21:36:02'),(411,'default','added',150,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-10-29 21:39:08','2023-10-29 21:39:08'),(412,'default','added',153,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-10-29 21:42:12','2023-10-29 21:42:12'),(413,'default','added',156,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-10-29 21:45:11','2023-10-29 21:45:11'),(414,'default','added',158,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-29 21:51:13','2023-10-29 21:51:13'),(415,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-29 22:01:38','2023-10-29 22:01:38'),(416,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 12:43:56','2023-10-30 12:43:56'),(417,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 12:53:20','2023-10-30 12:53:20'),(418,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 12:53:41','2023-10-30 12:53:41'),(419,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:07:49','2023-10-30 13:07:49'),(420,'default','edited',1,'App\\User',NULL,1,3,'App\\User','{\"name\":\" Super Admin\"}',NULL,'2023-10-30 13:22:40','2023-10-30 13:22:40'),(421,'default','edited',2,'App\\User',NULL,1,3,'App\\User','{\"name\":\" Salam Enterprise Staff\"}',NULL,'2023-10-30 13:23:14','2023-10-30 13:23:14'),(422,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:23:48','2023-10-30 13:23:48'),(423,'default','added',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:30:02','2023-10-30 13:30:02'),(424,'default','payment_edited',124,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2400.0000\"}}',NULL,'2023-10-30 13:33:46','2023-10-30 13:33:46'),(425,'default','added',159,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-10-30 13:36:25','2023-10-30 13:36:25'),(426,'default','edited',43,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 13:37:35','2023-10-30 13:37:35'),(427,'default','added',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":165900}}',NULL,'2023-10-30 13:53:55','2023-10-30 13:53:55'),(428,'default','added',161,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-10-30 13:55:18','2023-10-30 13:55:18'),(429,'default','added',162,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-10-30 13:56:22','2023-10-30 13:56:22'),(430,'default','added',163,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-10-30 13:58:18','2023-10-30 13:58:18'),(431,'default','added',49,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 14:06:27','2023-10-30 14:06:27'),(432,'default','added',164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-10-30 14:07:58','2023-10-30 14:07:58'),(433,'default','added',165,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1580}}',NULL,'2023-10-30 14:08:57','2023-10-30 14:08:57'),(434,'default','added',166,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7400}}',NULL,'2023-10-30 14:12:02','2023-10-30 14:12:02'),(435,'default','added',167,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-10-30 14:13:21','2023-10-30 14:13:21'),(436,'default','added',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-10-30 14:19:38','2023-10-30 14:19:38'),(437,'default','added',169,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11900}}',NULL,'2023-10-30 14:29:12','2023-10-30 14:29:12'),(438,'default','added',170,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33000}}',NULL,'2023-10-30 14:34:24','2023-10-30 14:34:24'),(439,'default','added',50,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 14:36:05','2023-10-30 14:36:05'),(440,'default','added',171,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3130}}',NULL,'2023-10-30 14:37:51','2023-10-30 14:37:51'),(441,'default','added',172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-10-30 14:38:24','2023-10-30 14:38:24'),(442,'default','added',173,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-10-30 14:42:47','2023-10-30 14:42:47'),(443,'default','added',174,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5380}}',NULL,'2023-10-30 14:44:07','2023-10-30 14:44:07'),(444,'default','added',175,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-10-30 14:44:49','2023-10-30 14:44:49'),(445,'default','added',176,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15169.5}}',NULL,'2023-10-30 14:59:23','2023-10-30 14:59:23'),(446,'default','added',177,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-10-30 15:02:42','2023-10-30 15:02:42'),(447,'default','added',178,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11434.600000000000363797880709171295166015625}}',NULL,'2023-10-30 15:11:34','2023-10-30 15:11:34'),(448,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 16:07:37','2023-10-30 16:07:37'),(449,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 16:07:40','2023-10-30 16:07:40'),(450,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 17:17:17','2023-10-30 17:17:17'),(451,'default','added',179,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-10-30 17:19:11','2023-10-30 17:19:11'),(452,'default','edited',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 17:21:49','2023-10-30 17:21:49'),(453,'default','payment_edited',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"165900.0000\"}}',NULL,'2023-10-30 17:22:21','2023-10-30 17:22:21'),(454,'default','payment_edited',164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-30 17:44:45','2023-10-30 17:44:45'),(455,'default','added',180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":192160}}',NULL,'2023-10-30 17:58:44','2023-10-30 17:58:44'),(456,'default','added',181,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3450}}',NULL,'2023-10-30 17:59:21','2023-10-30 17:59:21'),(457,'default','added',182,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-10-30 18:01:05','2023-10-30 18:01:05'),(458,'default','added',183,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-10-30 18:02:34','2023-10-30 18:02:34'),(459,'default','added',184,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-10-30 18:04:51','2023-10-30 18:04:51'),(460,'default','added',185,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-10-30 18:06:33','2023-10-30 18:06:33'),(461,'default','added',186,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25280}}',NULL,'2023-10-30 18:13:50','2023-10-30 18:13:50'),(462,'default','added',187,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-10-30 18:19:12','2023-10-30 18:19:12'),(463,'default','added',188,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16750}}',NULL,'2023-10-30 18:23:58','2023-10-30 18:23:58'),(464,'default','added',189,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5550}}',NULL,'2023-10-30 18:28:40','2023-10-30 18:28:40'),(465,'default','added',190,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-10-30 18:32:16','2023-10-30 18:32:16'),(466,'default','added',191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50070}}',NULL,'2023-10-30 18:34:50','2023-10-30 18:34:50'),(467,'default','added',51,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 18:40:16','2023-10-30 18:40:16'),(468,'default','added',192,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-10-30 18:41:34','2023-10-30 18:41:34'),(469,'default','added',193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6200}}',NULL,'2023-10-30 18:43:03','2023-10-30 18:43:03'),(470,'default','added',194,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16459.20000000000072759576141834259033203125}}',NULL,'2023-10-30 18:45:15','2023-10-30 18:45:15'),(471,'default','added',195,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7700}}',NULL,'2023-10-30 18:48:05','2023-10-30 18:48:05'),(472,'default','added',196,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-10-30 18:51:20','2023-10-30 18:51:20'),(473,'default','added',197,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-10-30 18:52:41','2023-10-30 18:52:41'),(474,'default','added',198,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-10-30 18:57:12','2023-10-30 18:57:12'),(475,'default','added',199,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-30 19:02:05','2023-10-30 19:02:05'),(476,'default','added',200,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-10-30 19:23:47','2023-10-30 19:23:47'),(477,'default','added',201,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-30 19:24:35','2023-10-30 19:24:35'),(478,'default','added',202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4550}}',NULL,'2023-10-30 19:28:56','2023-10-30 19:28:56'),(479,'default','added',52,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:31:43','2023-10-30 19:31:43'),(480,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:32:01','2023-10-30 19:32:01'),(481,'default','added',204,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-10-30 19:33:50','2023-10-30 19:33:50'),(482,'default','added',205,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-10-30 19:34:10','2023-10-30 19:34:10'),(483,'default','added',206,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-10-30 19:37:30','2023-10-30 19:37:30'),(484,'default','added',53,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:41:31','2023-10-30 19:41:31'),(485,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-30 19:42:25','2023-10-30 19:42:25'),(486,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:08:07','2023-10-31 11:08:07'),(487,'default','payment_edited',132,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:10:14','2023-10-31 11:10:14'),(488,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:10:46','2023-10-31 11:10:46'),(489,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 11:11:16','2023-10-31 11:11:16'),(490,'default','added',208,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29049.5999999999985448084771633148193359375}}',NULL,'2023-10-31 11:19:21','2023-10-31 11:19:21'),(491,'default','added',209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-10-31 11:24:33','2023-10-31 11:24:33'),(492,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-10-31 11:30:38','2023-10-31 11:30:38'),(493,'default','added',210,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25200}}',NULL,'2023-10-31 11:44:45','2023-10-31 11:44:45'),(494,'default','added',211,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-10-31 11:46:20','2023-10-31 11:46:20'),(495,'default','added',212,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-10-31 11:52:27','2023-10-31 11:52:27'),(496,'default','added',213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":15020}}',NULL,'2023-10-31 11:57:23','2023-10-31 11:57:23'),(497,'default','added',214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2023-10-31 12:00:00','2023-10-31 12:00:00'),(498,'default','added',215,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 12:01:09','2023-10-31 12:01:09'),(499,'default','added',216,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 12:01:58','2023-10-31 12:01:58'),(500,'default','added',217,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 12:03:40','2023-10-31 12:03:40'),(501,'default','added',54,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:04:58','2023-10-31 12:04:58'),(502,'default','edited',54,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:06:10','2023-10-31 12:06:10'),(503,'default','edited',54,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:06:19','2023-10-31 12:06:19'),(504,'default','payment_edited',172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-10-31 12:12:59','2023-10-31 12:12:59'),(505,'default','payment_edited',218,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:13:53','2023-10-31 12:13:53'),(506,'default','added',219,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12090}}',NULL,'2023-10-31 12:18:16','2023-10-31 12:18:16'),(507,'default','added',220,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-10-31 12:25:13','2023-10-31 12:25:13'),(508,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:38:54','2023-10-31 12:38:54'),(509,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:38:58','2023-10-31 12:38:58'),(510,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:40:29','2023-10-31 12:40:29'),(511,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:53:42','2023-10-31 12:53:42'),(512,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:53:46','2023-10-31 12:53:46'),(513,'default','added',55,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 12:55:34','2023-10-31 12:55:34'),(514,'default','added',222,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":15150}}',NULL,'2023-10-31 12:58:52','2023-10-31 12:58:52'),(515,'default','added',223,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-10-31 13:45:39','2023-10-31 13:45:39'),(516,'default','added',224,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-10-31 14:20:49','2023-10-31 14:20:49'),(517,'default','added',225,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12160}}',NULL,'2023-10-31 14:36:07','2023-10-31 14:36:07'),(518,'default','added',226,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-10-31 14:39:53','2023-10-31 14:39:53'),(519,'default','added',227,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-31 14:41:45','2023-10-31 14:41:45'),(520,'default','added',228,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 14:44:34','2023-10-31 14:44:34'),(521,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 15:17:38','2023-10-31 15:17:38'),(522,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 17:35:26','2023-10-31 17:35:26'),(523,'default','payment_edited',164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-31 17:41:55','2023-10-31 17:41:55'),(524,'default','added',229,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11500}}',NULL,'2023-10-31 17:47:28','2023-10-31 17:47:28'),(525,'default','added',230,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-10-31 17:48:32','2023-10-31 17:48:32'),(526,'default','added',56,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 17:52:03','2023-10-31 17:52:03'),(527,'default','payment_edited',231,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 17:55:07','2023-10-31 17:55:07'),(528,'default','added',232,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-10-31 17:57:23','2023-10-31 17:57:23'),(529,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:17:59','2023-10-31 18:17:59'),(530,'default','added',57,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:48:47','2023-10-31 18:48:47'),(531,'default','added',233,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-10-31 18:49:14','2023-10-31 18:49:14'),(532,'default','added',234,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-10-31 18:52:01','2023-10-31 18:52:01'),(533,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:54:09','2023-10-31 18:54:09'),(534,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 18:54:12','2023-10-31 18:54:13'),(535,'default','payment_edited',193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6200.0000\"}}',NULL,'2023-10-31 18:55:26','2023-10-31 18:55:26'),(536,'default','added',235,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-10-31 18:57:02','2023-10-31 18:57:02'),(537,'default','added',236,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4650}}',NULL,'2023-10-31 18:58:30','2023-10-31 18:58:30'),(538,'default','added',237,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-10-31 19:39:23','2023-10-31 19:39:23'),(539,'default','added',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":187880}}',NULL,'2023-10-31 20:02:52','2023-10-31 20:02:52'),(540,'default','payment_edited',64,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"1192759.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"1192759.0000\"}}',NULL,'2023-10-31 20:04:33','2023-10-31 20:04:33'),(541,'default','payment_edited',180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"192160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"192160.0000\"}}',NULL,'2023-10-31 20:04:33','2023-10-31 20:04:33'),(542,'default','added',239,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":46800}}',NULL,'2023-10-31 20:12:40','2023-10-31 20:12:40'),(543,'default','added',240,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 20:14:24','2023-10-31 20:14:24'),(544,'default','added',241,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 20:15:39','2023-10-31 20:15:39'),(545,'default','added',242,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-10-31 20:16:02','2023-10-31 20:16:02'),(546,'default','added',243,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6270}}',NULL,'2023-10-31 20:18:04','2023-10-31 20:18:04'),(547,'default','added',244,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1500}}',NULL,'2023-10-31 20:30:59','2023-10-31 20:30:59'),(548,'default','payment_edited',244,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-10-31 20:38:09','2023-10-31 20:38:09'),(549,'default','added',245,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-10-31 20:40:47','2023-10-31 20:40:47'),(550,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-10-31 20:43:15','2023-10-31 20:43:15'),(551,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 11:15:19','2023-11-01 11:15:19'),(552,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:11:57','2023-11-01 17:11:57'),(553,'default','added',246,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-01 17:14:11','2023-11-01 17:14:11'),(554,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:16:08','2023-11-01 17:16:08'),(555,'default','payment_edited',233,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-01 17:23:15','2023-11-01 17:23:15'),(556,'default','added',247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-01 17:26:40','2023-11-01 17:26:40'),(557,'default','edited',247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-01 17:28:07','2023-11-01 17:28:07'),(558,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:29:11','2023-11-01 17:29:11'),(559,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:32:13','2023-11-01 17:32:13'),(560,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:32:18','2023-11-01 17:32:18'),(561,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:33:10','2023-11-01 17:33:10'),(562,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:33:12','2023-11-01 17:33:12'),(563,'default','added',248,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29000}}',NULL,'2023-11-01 17:44:15','2023-11-01 17:44:15'),(564,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:46:33','2023-11-01 17:46:33'),(565,'default','added',249,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31730}}',NULL,'2023-11-01 17:51:23','2023-11-01 17:51:23'),(566,'default','added',250,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9080}}',NULL,'2023-11-01 17:53:29','2023-11-01 17:53:29'),(567,'default','added',58,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:54:31','2023-11-01 17:54:31'),(568,'default','added',251,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-01 17:55:12','2023-11-01 17:55:12'),(569,'default','added',59,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 17:56:52','2023-11-01 17:56:52'),(570,'default','added',252,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750}}',NULL,'2023-11-01 17:57:12','2023-11-01 17:57:12'),(571,'default','added',60,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:02:56','2023-11-01 18:02:56'),(572,'default','added',253,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-01 18:05:09','2023-11-01 18:05:09'),(573,'default','edited',60,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:07:18','2023-11-01 18:07:18'),(574,'default','added',255,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-11-01 18:08:15','2023-11-01 18:08:15'),(575,'default','added',256,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-01 18:33:40','2023-11-01 18:33:40'),(576,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:35:43','2023-11-01 18:35:43'),(577,'default','added',257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":53400}}',NULL,'2023-11-01 18:44:42','2023-11-01 18:44:42'),(578,'default','payment_edited',99,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"169075.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"169075.0000\"}}',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(579,'default','payment_edited',239,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"46800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"46800.0000\"}}',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(580,'default','payment_edited',257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"53400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"53400.0000\"}}',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(581,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:53:16','2023-11-01 18:53:16'),(582,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 18:54:00','2023-11-01 18:54:00'),(583,'default','added',258,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-01 18:55:44','2023-11-01 18:55:44'),(584,'default','added',61,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 19:21:42','2023-11-01 19:21:42'),(585,'default','added',259,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750}}',NULL,'2023-11-01 19:22:27','2023-11-01 19:22:27'),(586,'default','added',260,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-01 19:23:25','2023-11-01 19:23:25'),(587,'default','added',261,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-01 19:27:52','2023-11-01 19:27:52'),(588,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 19:31:32','2023-11-01 19:31:32'),(589,'default','edited',40,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 19:32:44','2023-11-01 19:32:44'),(590,'default','added',262,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1530}}',NULL,'2023-11-01 19:36:35','2023-11-01 19:36:35'),(591,'default','added',263,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-01 19:48:27','2023-11-01 19:48:27'),(592,'default','added',264,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-01 19:50:37','2023-11-01 19:50:37'),(593,'default','added',265,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-01 19:55:44','2023-11-01 19:55:44'),(594,'default','added',266,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-01 20:01:42','2023-11-01 20:01:42'),(595,'default','added',267,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-01 20:07:04','2023-11-01 20:07:04'),(596,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-01 20:19:58','2023-11-01 20:19:58'),(597,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 10:14:50','2023-11-02 10:14:50'),(598,'default','added',268,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-02 10:23:57','2023-11-02 10:23:57'),(599,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 10:25:57','2023-11-02 10:25:57'),(600,'default','added',269,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-02 10:33:07','2023-11-02 10:33:07'),(601,'default','added',270,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4480}}',NULL,'2023-11-02 10:34:26','2023-11-02 10:34:26'),(602,'default','payment_edited',252,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1750.0000\"}}',NULL,'2023-11-02 10:39:07','2023-11-02 10:39:07'),(603,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 10:41:14','2023-11-02 10:41:14'),(604,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-02 10:43:54','2023-11-02 10:43:54'),(605,'default','added',271,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 10:45:46','2023-11-02 10:45:46'),(606,'default','added',272,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 10:46:16','2023-11-02 10:46:16'),(607,'default','added',273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-02 10:47:55','2023-11-02 10:47:55'),(608,'default','added',274,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24350}}',NULL,'2023-11-02 10:51:44','2023-11-02 10:51:44'),(609,'default','added',275,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8290}}',NULL,'2023-11-02 10:54:55','2023-11-02 10:54:55'),(610,'default','added',276,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-02 10:55:16','2023-11-02 10:55:16'),(611,'default','added',62,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 11:00:20','2023-11-02 11:00:20'),(612,'default','added',278,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-11-02 11:01:36','2023-11-02 11:01:36'),(613,'default','payment_edited',56,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 11:19:14','2023-11-02 11:19:14'),(614,'default','added',279,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-02 11:32:35','2023-11-02 11:32:35'),(615,'default','added',280,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-02 11:37:22','2023-11-02 11:37:22'),(616,'default','added',281,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-02 11:48:53','2023-11-02 11:48:53'),(617,'default','added',282,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-02 11:55:41','2023-11-02 11:55:41'),(618,'default','added',283,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-02 12:02:20','2023-11-02 12:02:20'),(619,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"}}',NULL,'2023-11-02 12:20:01','2023-11-02 12:20:01'),(620,'default','added',284,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3650}}',NULL,'2023-11-02 12:25:11','2023-11-02 12:25:11'),(621,'default','added',285,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-11-02 12:26:51','2023-11-02 12:26:51'),(622,'default','added',286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3100}}',NULL,'2023-11-02 12:33:44','2023-11-02 12:33:44'),(623,'default','added',287,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-02 12:41:50','2023-11-02 12:41:50'),(624,'default','added',288,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-02 12:50:29','2023-11-02 12:50:29'),(625,'default','added',289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-11-02 13:17:27','2023-11-02 13:17:27'),(626,'default','added',290,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-02 13:21:43','2023-11-02 13:21:43'),(627,'default','added',291,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-02 13:32:44','2023-11-02 13:32:44'),(628,'default','added',292,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2023-11-02 14:02:13','2023-11-02 14:02:13'),(629,'default','added',293,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-11-02 14:03:55','2023-11-02 14:03:55'),(630,'default','payment_edited',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"}}',NULL,'2023-11-02 14:15:11','2023-11-02 14:15:11'),(631,'default','added',294,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-02 14:17:52','2023-11-02 14:17:52'),(632,'default','added',295,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11900}}',NULL,'2023-11-02 14:34:48','2023-11-02 14:34:48'),(633,'default','added',296,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":42140}}',NULL,'2023-11-02 14:39:04','2023-11-02 14:39:04'),(634,'default','added',297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":69360}}',NULL,'2023-11-02 14:43:00','2023-11-02 14:43:00'),(635,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 14:57:20','2023-11-02 14:57:20'),(636,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:24:15','2023-11-02 17:24:15'),(637,'default','added',298,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-02 17:34:07','2023-11-02 17:34:07'),(638,'default','added',299,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-02 17:36:44','2023-11-02 17:36:44'),(639,'default','added',300,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-02 17:38:07','2023-11-02 17:38:07'),(640,'default','added',301,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-02 17:38:46','2023-11-02 17:38:46'),(641,'default','added',63,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:40:54','2023-11-02 17:40:54'),(642,'default','edited',63,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:42:09','2023-11-02 17:42:09'),(643,'default','added',303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5250}}',NULL,'2023-11-02 17:43:52','2023-11-02 17:43:52'),(644,'default','added',304,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29380}}',NULL,'2023-11-02 17:48:49','2023-11-02 17:48:49'),(645,'default','added',305,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-02 17:49:47','2023-11-02 17:49:47'),(646,'default','payment_edited',43,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 17:51:32','2023-11-02 17:51:32'),(647,'default','added',306,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10900}}',NULL,'2023-11-02 17:53:30','2023-11-02 17:53:30'),(648,'default','added',307,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-02 17:55:53','2023-11-02 17:55:53'),(649,'default','payment_edited',113,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"173140.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"173140.0000\"}}',NULL,'2023-11-02 17:56:42','2023-11-02 17:56:42'),(650,'default','payment_edited',69,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"87080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87080.0000\"}}',NULL,'2023-11-02 17:57:03','2023-11-02 17:57:03'),(651,'default','payment_edited',191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"50070.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50070.0000\"}}',NULL,'2023-11-02 17:57:03','2023-11-02 17:57:03'),(652,'default','added',308,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5630}}',NULL,'2023-11-02 18:21:08','2023-11-02 18:21:08'),(653,'default','added',309,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-02 18:30:10','2023-11-02 18:30:10'),(654,'default','added',310,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 18:42:04','2023-11-02 18:42:04'),(655,'default','added',311,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-02 18:42:37','2023-11-02 18:42:37'),(656,'default','added',312,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-02 18:44:07','2023-11-02 18:44:07'),(657,'default','added',313,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-02 18:48:25','2023-11-02 18:48:25'),(658,'default','added',314,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-02 18:48:39','2023-11-02 18:48:39'),(659,'default','added',315,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-02 19:01:05','2023-11-02 19:01:05'),(660,'default','added',316,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-02 19:46:51','2023-11-02 19:46:51'),(661,'default','added',64,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 19:57:50','2023-11-02 19:57:50'),(662,'default','edited',64,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 19:58:24','2023-11-02 19:58:24'),(663,'default','added',317,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5430}}',NULL,'2023-11-02 19:59:08','2023-11-02 19:59:08'),(664,'default','added',318,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7900}}',NULL,'2023-11-02 20:11:26','2023-11-02 20:11:26'),(665,'default','added',319,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-02 20:16:55','2023-11-02 20:16:55'),(666,'default','added',320,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-02 20:18:48','2023-11-02 20:18:48'),(667,'default','added',321,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23367.70000000000072759576141834259033203125}}',NULL,'2023-11-02 20:21:47','2023-11-02 20:21:47'),(668,'default','added',65,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 20:29:06','2023-11-02 20:29:06'),(669,'default','added',322,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-11-02 20:29:24','2023-11-02 20:29:24'),(670,'default','added',323,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-02 20:45:11','2023-11-02 20:45:11'),(671,'default','added',324,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-02 20:48:35','2023-11-02 20:48:35'),(672,'default','added',325,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-02 20:56:54','2023-11-02 20:56:54'),(673,'default','added',326,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32250}}',NULL,'2023-11-02 21:18:10','2023-11-02 21:18:10'),(674,'default','added',327,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-02 21:18:50','2023-11-02 21:18:50'),(675,'default','added',328,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9350}}',NULL,'2023-11-02 21:22:28','2023-11-02 21:22:28'),(676,'default','added',329,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-02 21:26:11','2023-11-02 21:26:11'),(677,'default','added',330,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3030}}',NULL,'2023-11-02 21:27:11','2023-11-02 21:27:11'),(678,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-02 21:27:31','2023-11-02 21:27:31'),(679,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-03 14:13:51','2023-11-03 14:13:51'),(680,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 10:14:31','2023-11-04 10:14:31'),(681,'default','added',331,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-04 10:15:17','2023-11-04 10:15:17'),(682,'default','payment_edited',251,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-04 10:21:45','2023-11-04 10:21:45'),(683,'default','payment_edited',295,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11900.0000\"}}',NULL,'2023-11-04 10:22:26','2023-11-04 10:22:26'),(684,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 10:29:53','2023-11-04 10:29:53'),(685,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 10:36:28','2023-11-04 10:36:28'),(686,'default','added',332,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-04 10:38:49','2023-11-04 10:38:49'),(687,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-11-04 10:43:51','2023-11-04 10:43:51'),(688,'default','added',333,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-11-04 10:49:19','2023-11-04 10:49:19'),(689,'default','added',334,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8950}}',NULL,'2023-11-04 10:56:46','2023-11-04 10:56:46'),(690,'default','added',335,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-04 10:59:25','2023-11-04 10:59:25'),(691,'default','added',336,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1490}}',NULL,'2023-11-04 11:23:57','2023-11-04 11:23:57'),(692,'default','added',337,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9650}}',NULL,'2023-11-04 11:25:55','2023-11-04 11:25:55'),(693,'default','added',338,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-04 11:28:17','2023-11-04 11:28:17'),(694,'default','added',339,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2180}}',NULL,'2023-11-04 11:43:17','2023-11-04 11:43:17'),(695,'default','added',340,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3780}}',NULL,'2023-11-04 11:47:05','2023-11-04 11:47:05'),(696,'default','added',341,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-04 11:48:48','2023-11-04 11:48:48'),(697,'default','added',342,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-04 11:51:04','2023-11-04 11:51:04'),(698,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 11:57:46','2023-11-04 11:57:46'),(699,'default','added',343,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-04 12:01:02','2023-11-04 12:01:02'),(700,'default','added',344,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900}}',NULL,'2023-11-04 12:01:59','2023-11-04 12:01:59'),(701,'default','added',345,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-04 12:04:53','2023-11-04 12:04:53'),(702,'default','added',346,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-11-04 12:14:33','2023-11-04 12:14:33'),(703,'default','added',347,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-04 12:18:05','2023-11-04 12:18:05'),(704,'default','added',348,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5130}}',NULL,'2023-11-04 12:29:45','2023-11-04 12:29:45'),(705,'default','added',349,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-04 12:32:13','2023-11-04 12:32:13'),(706,'default','added',350,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-04 12:36:02','2023-11-04 12:36:02'),(707,'default','added',351,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-04 12:41:53','2023-11-04 12:41:53'),(708,'default','added',352,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3030}}',NULL,'2023-11-04 12:43:51','2023-11-04 12:43:51'),(709,'default','added',353,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-04 12:44:33','2023-11-04 12:44:33'),(710,'default','added',354,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-11-04 12:46:11','2023-11-04 12:46:11'),(711,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 12:59:35','2023-11-04 12:59:35'),(712,'default','added',355,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-04 13:21:02','2023-11-04 13:21:02'),(713,'default','added',356,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-04 13:23:37','2023-11-04 13:23:37'),(714,'default','added',357,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-04 13:24:01','2023-11-04 13:24:01'),(715,'default','added',358,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 13:26:55','2023-11-04 13:26:55'),(716,'default','added',359,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 13:27:37','2023-11-04 13:27:37'),(717,'default','added',360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-04 13:28:57','2023-11-04 13:28:57'),(718,'default','added',361,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8590}}',NULL,'2023-11-04 13:32:12','2023-11-04 13:32:12'),(719,'default','added',362,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4930}}',NULL,'2023-11-04 13:35:06','2023-11-04 13:35:06'),(720,'default','added',363,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6050}}',NULL,'2023-11-04 13:37:38','2023-11-04 13:37:38'),(721,'default','added',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12670}}',NULL,'2023-11-04 13:41:24','2023-11-04 13:41:24'),(722,'default','added',365,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-04 13:45:44','2023-11-04 13:45:44'),(723,'default','added',366,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-04 13:48:16','2023-11-04 13:48:16'),(724,'default','added',367,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-11-04 13:52:38','2023-11-04 13:52:38'),(725,'default','added',368,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6700}}',NULL,'2023-11-04 14:00:18','2023-11-04 14:00:18'),(726,'default','added',369,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-04 14:04:06','2023-11-04 14:04:06'),(727,'default','added',370,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-04 14:09:00','2023-11-04 14:09:00'),(728,'default','added',371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":308000}}',NULL,'2023-11-04 14:11:45','2023-11-04 14:11:45'),(729,'default','added',372,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12950}}',NULL,'2023-11-04 14:15:26','2023-11-04 14:15:26'),(730,'default','added',373,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2440}}',NULL,'2023-11-04 14:24:30','2023-11-04 14:24:30'),(731,'default','added',374,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-04 14:31:30','2023-11-04 14:31:30'),(732,'default','added',375,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1364}}',NULL,'2023-11-04 16:30:10','2023-11-04 16:30:10'),(733,'default','purchase_deleted',375,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1364.0000\"}}',NULL,'2023-11-04 16:30:48','2023-11-04 16:30:48'),(734,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:04:20','2023-11-04 17:04:20'),(735,'default','added',376,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-04 17:04:49','2023-11-04 17:04:49'),(736,'default','added',377,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 17:06:16','2023-11-04 17:06:16'),(737,'default','payment_edited',221,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:15:06','2023-11-04 17:15:06'),(738,'default','payment_edited',222,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15150.0000\"}}',NULL,'2023-11-04 17:15:06','2023-11-04 17:15:06'),(739,'default','payment_edited',236,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4650.0000\"}}',NULL,'2023-11-04 17:16:36','2023-11-04 17:16:36'),(740,'default','payment_edited',286,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-04 17:16:36','2023-11-04 17:16:36'),(741,'default','payment_edited',160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"165900.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"165900.0000\"}}',NULL,'2023-11-04 17:25:05','2023-11-04 17:25:05'),(742,'default','added',378,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-04 17:28:32','2023-11-04 17:28:32'),(743,'default','added',379,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":42460}}',NULL,'2023-11-04 17:34:48','2023-11-04 17:34:48'),(744,'default','added',380,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23780}}',NULL,'2023-11-04 17:43:35','2023-11-04 17:43:35'),(745,'default','added',381,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8222}}',NULL,'2023-11-04 17:45:53','2023-11-04 17:45:53'),(746,'default','added',382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-11-04 17:46:41','2023-11-04 17:46:41'),(747,'default','added',383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":151635}}',NULL,'2023-11-04 17:48:23','2023-11-04 17:48:23'),(748,'default','added',384,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":181120}}',NULL,'2023-11-04 17:49:29','2023-11-04 17:49:29'),(749,'default','added',66,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:55:25','2023-11-04 17:55:25'),(750,'default','payment_edited',385,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 17:57:06','2023-11-04 17:57:06'),(751,'default','added',386,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6100}}',NULL,'2023-11-04 17:57:57','2023-11-04 17:57:57'),(752,'default','added',387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4650}}',NULL,'2023-11-04 18:01:38','2023-11-04 18:01:38'),(753,'default','added',388,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-04 18:02:53','2023-11-04 18:02:53'),(754,'default','added',389,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-04 18:13:34','2023-11-04 18:13:34'),(755,'default','edited',37,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 18:52:49','2023-11-04 18:52:49'),(756,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:17:32','2023-11-04 19:17:32'),(757,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:17:35','2023-11-04 19:17:35'),(758,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:17:47','2023-11-04 19:17:47'),(759,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:25:43','2023-11-04 19:25:43'),(760,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:31:43','2023-11-04 19:31:43'),(761,'default','added',390,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25040}}',NULL,'2023-11-04 19:56:25','2023-11-04 19:56:25'),(762,'default','added',67,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:56:26','2023-11-04 19:56:26'),(763,'default','payment_edited',391,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 19:56:40','2023-11-04 19:56:40'),(764,'default','added',392,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-04 20:01:58','2023-11-04 20:01:58'),(765,'default','added',393,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2620}}',NULL,'2023-11-04 20:05:02','2023-11-04 20:05:02'),(766,'default','added',394,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-04 20:07:09','2023-11-04 20:07:09'),(767,'default','payment_edited',66,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"366058.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"366058.0000\"}}',NULL,'2023-11-04 20:19:38','2023-11-04 20:19:38'),(768,'default','payment_edited',100,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"35250.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"35250.0000\"}}',NULL,'2023-11-04 20:19:38','2023-11-04 20:19:38'),(769,'default','added',395,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22860}}',NULL,'2023-11-04 20:37:19','2023-11-04 20:37:19'),(770,'default','added',396,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6700}}',NULL,'2023-11-04 20:39:48','2023-11-04 20:39:48'),(771,'default','added',397,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-04 20:40:10','2023-11-04 20:40:10'),(772,'default','payment_edited',277,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 20:45:04','2023-11-04 20:45:04'),(773,'default','payment_edited',278,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-11-04 20:45:04','2023-11-04 20:45:04'),(774,'default','added',398,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":12500}}',NULL,'2023-11-04 20:49:06','2023-11-04 20:49:06'),(775,'default','payment_edited',70,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50305.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"50305.0000\"}}',NULL,'2023-11-04 20:51:41','2023-11-04 20:51:41'),(776,'default','payment_edited',114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"49860.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"49860.0000\"}}',NULL,'2023-11-04 20:51:41','2023-11-04 20:51:41'),(777,'default','added',399,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-04 21:01:09','2023-11-04 21:01:09'),(778,'default','added',400,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16036.20000000000072759576141834259033203125}}',NULL,'2023-11-04 21:03:30','2023-11-04 21:03:30'),(779,'default','added',401,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5880}}',NULL,'2023-11-04 21:05:16','2023-11-04 21:05:16'),(780,'default','added',402,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":130380}}',NULL,'2023-11-04 21:07:21','2023-11-04 21:07:21'),(781,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 21:13:09','2023-11-04 21:13:09'),(782,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 21:13:13','2023-11-04 21:13:13'),(783,'default','added',403,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 21:14:15','2023-11-04 21:14:15'),(784,'default','added',404,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-04 21:14:48','2023-11-04 21:14:48'),(785,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 21:14:57','2023-11-04 21:14:57'),(786,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-04 22:59:47','2023-11-04 22:59:47'),(787,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:26:51','2023-11-05 10:26:51'),(788,'default','added',405,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-05 10:28:31','2023-11-05 10:28:31'),(789,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:29:39','2023-11-05 10:29:39'),(790,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:31:27','2023-11-05 10:31:27'),(791,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:32:07','2023-11-05 10:32:07'),(792,'default','added',406,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 10:32:33','2023-11-05 10:32:33'),(793,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:37:40','2023-11-05 10:37:40'),(794,'default','added',407,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18480}}',NULL,'2023-11-05 10:40:26','2023-11-05 10:40:26'),(795,'default','added',68,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:41:28','2023-11-05 10:41:28'),(796,'default','added',408,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-11-05 10:42:12','2023-11-05 10:42:12'),(797,'default','added',409,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-05 10:43:39','2023-11-05 10:43:39'),(798,'default','added',410,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11800}}',NULL,'2023-11-05 10:46:29','2023-11-05 10:46:29'),(799,'default','added',411,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8150}}',NULL,'2023-11-05 10:47:35','2023-11-05 10:47:35'),(800,'default','added',412,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4480}}',NULL,'2023-11-05 10:48:43','2023-11-05 10:48:43'),(801,'default','added',69,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 10:49:55','2023-11-05 10:49:55'),(802,'default','added',413,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-11-05 10:50:55','2023-11-05 10:50:55'),(803,'default','added',414,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3400}}',NULL,'2023-11-05 10:53:17','2023-11-05 10:53:17'),(804,'default','added',415,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14840}}',NULL,'2023-11-05 10:56:51','2023-11-05 10:56:51'),(805,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 11:09:19','2023-11-05 11:09:19'),(806,'default','added',416,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 11:09:54','2023-11-05 11:09:54'),(807,'default','added',417,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 11:14:43','2023-11-05 11:14:43'),(808,'default','added',70,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 11:27:34','2023-11-05 11:27:34'),(809,'default','added',419,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-11-05 11:29:16','2023-11-05 11:29:16'),(810,'default','payment_edited',418,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 11:30:22','2023-11-05 11:30:22'),(811,'default','added',420,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-05 11:32:58','2023-11-05 11:32:58'),(812,'default','added',421,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-05 11:48:06','2023-11-05 11:48:06'),(813,'default','added',422,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3950}}',NULL,'2023-11-05 11:49:02','2023-11-05 11:49:02'),(814,'default','added',423,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-05 11:50:39','2023-11-05 11:50:39'),(815,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 12:49:12','2023-11-05 12:49:12'),(816,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 14:35:01','2023-11-05 14:35:01'),(817,'default','added',424,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-05 14:35:25','2023-11-05 14:35:25'),(818,'default','added',425,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2900}}',NULL,'2023-11-05 14:47:06','2023-11-05 14:47:06'),(819,'default','payment_edited',425,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-05 14:50:27','2023-11-05 14:50:27'),(820,'default','added',426,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-05 14:51:07','2023-11-05 14:51:07'),(821,'default','edited',426,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-05 14:55:15','2023-11-05 14:55:15'),(822,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 15:24:13','2023-11-05 15:24:13'),(823,'default','added',71,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 16:46:08','2023-11-05 16:46:08'),(824,'default','added',428,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-05 16:46:56','2023-11-05 16:46:56'),(825,'default','added',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7150}}',NULL,'2023-11-05 17:06:15','2023-11-05 17:06:15'),(826,'default','edited',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7180},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7150.0000\"}}',NULL,'2023-11-05 17:08:19','2023-11-05 17:08:19'),(827,'default','payment_edited',302,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:10:34','2023-11-05 17:10:34'),(828,'default','payment_edited',303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5250.0000\"}}',NULL,'2023-11-05 17:10:34','2023-11-05 17:10:34'),(829,'default','added',430,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-05 17:12:08','2023-11-05 17:12:08'),(830,'default','added',72,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:13:11','2023-11-05 17:13:11'),(831,'default','payment_edited',431,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:13:44','2023-11-05 17:13:44'),(832,'default','payment_edited',405,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-05 17:14:23','2023-11-05 17:14:23'),(833,'default','added',432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-05 17:16:22','2023-11-05 17:16:22'),(834,'default','added',433,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24820}}',NULL,'2023-11-05 17:19:16','2023-11-05 17:19:16'),(835,'default','added',434,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21000}}',NULL,'2023-11-05 17:21:22','2023-11-05 17:21:22'),(836,'default','added',73,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:37:44','2023-11-05 17:37:44'),(837,'default','added',435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":156978}}',NULL,'2023-11-05 17:40:41','2023-11-05 17:40:41'),(838,'default','added',436,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-05 17:41:32','2023-11-05 17:41:32'),(839,'default','added',74,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 17:42:29','2023-11-05 17:42:29'),(840,'default','added',437,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-05 17:42:58','2023-11-05 17:42:58'),(841,'default','added',441,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":4400}}',NULL,'2023-11-05 17:48:19','2023-11-05 17:48:19'),(842,'default','added',443,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36450}}',NULL,'2023-11-05 17:53:28','2023-11-05 17:53:28'),(843,'default','added',444,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-05 17:55:31','2023-11-05 17:55:31'),(844,'default','added',445,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":769.950000000000045474735088646411895751953125}}',NULL,'2023-11-05 17:56:43','2023-11-05 17:56:43'),(845,'default','added',446,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7200}}',NULL,'2023-11-05 18:00:11','2023-11-05 18:00:11'),(846,'default','added',447,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4550}}',NULL,'2023-11-05 18:21:30','2023-11-05 18:21:30'),(847,'default','added',448,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1302}}',NULL,'2023-11-05 18:29:28','2023-11-05 18:29:28'),(848,'default','added',449,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":121.2000000000000028421709430404007434844970703125}}',NULL,'2023-11-05 18:31:42','2023-11-05 18:31:42'),(849,'default','added',450,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-05 18:32:31','2023-11-05 18:32:31'),(850,'default','added',451,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2880}}',NULL,'2023-11-05 18:34:07','2023-11-05 18:34:07'),(851,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-11-05 18:52:35','2023-11-05 18:52:35'),(852,'default','payment_edited',180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"192160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"192160.0000\"}}',NULL,'2023-11-05 19:20:26','2023-11-05 19:20:26'),(853,'default','payment_edited',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"187880.0000\"}}',NULL,'2023-11-05 19:20:26','2023-11-05 19:20:26'),(854,'default','added',452,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-05 19:28:36','2023-11-05 19:28:36'),(855,'default','added',458,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-05 19:48:57','2023-11-05 19:48:57'),(856,'default','added',459,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-05 19:53:41','2023-11-05 19:53:41'),(857,'default','added',460,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-05 19:56:43','2023-11-05 19:56:43'),(858,'default','payment_edited',257,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"53400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"53400.0000\"}}',NULL,'2023-11-05 20:02:59','2023-11-05 20:02:59'),(859,'default','payment_edited',371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"308000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"308000.0000\"}}',NULL,'2023-11-05 20:02:59','2023-11-05 20:02:59'),(860,'default','edited',459,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"}}',NULL,'2023-11-05 20:05:19','2023-11-05 20:05:19'),(861,'default','added',461,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":352}}',NULL,'2023-11-05 20:14:47','2023-11-05 20:14:47'),(862,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-05 20:20:23','2023-11-05 20:20:23'),(863,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:08:05','2023-11-06 10:08:05'),(864,'default','payment_edited',105,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(865,'default','payment_edited',126,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4770.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4770.0000\"}}',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(866,'default','payment_edited',213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15020.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15020.0000\"}}',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(867,'default','payment_edited',97,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(868,'default','payment_edited',115,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(869,'default','payment_edited',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(870,'default','added',462,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 10:10:48','2023-11-06 10:10:48'),(871,'default','added',463,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":24250}}',NULL,'2023-11-06 10:16:21','2023-11-06 10:16:21'),(872,'default','added',464,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12830}}',NULL,'2023-11-06 10:18:18','2023-11-06 10:18:18'),(873,'default','added',465,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-06 10:23:33','2023-11-06 10:23:33'),(874,'default','added',75,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 10:30:08','2023-11-06 10:30:08'),(875,'default','added',466,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500}}',NULL,'2023-11-06 10:31:25','2023-11-06 10:31:25'),(876,'default','payment_edited',133,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 11:12:04','2023-11-06 11:12:04'),(877,'default','added',467,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-06 11:29:21','2023-11-06 11:29:21'),(878,'default','added',468,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-11-06 11:30:45','2023-11-06 11:30:45'),(879,'default','added',469,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7520}}',NULL,'2023-11-06 11:32:56','2023-11-06 11:32:56'),(880,'default','added',470,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-06 11:41:45','2023-11-06 11:41:45'),(881,'default','added',471,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-06 11:42:39','2023-11-06 11:42:39'),(882,'default','added',472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":111100}}',NULL,'2023-11-06 11:45:22','2023-11-06 11:45:22'),(883,'default','added',473,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-06 11:49:13','2023-11-06 11:49:13'),(884,'default','added',474,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":32300}}',NULL,'2023-11-06 12:05:19','2023-11-06 12:05:19'),(885,'default','added',475,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-06 12:18:06','2023-11-06 12:18:06'),(886,'default','payment_edited',102,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 12:20:53','2023-11-06 12:20:53'),(887,'default','added',476,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1240}}',NULL,'2023-11-06 12:34:05','2023-11-06 12:34:05'),(888,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 13:46:57','2023-11-06 13:46:57'),(889,'default','added',477,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4150}}',NULL,'2023-11-06 13:48:39','2023-11-06 13:48:39'),(890,'default','added',481,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8490}}',NULL,'2023-11-06 13:52:37','2023-11-06 13:52:37'),(891,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 13:53:23','2023-11-06 13:53:23'),(892,'default','added',482,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-06 13:56:49','2023-11-06 13:56:49'),(893,'default','added',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":241965}}',NULL,'2023-11-06 14:01:13','2023-11-06 14:01:13'),(894,'default','edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":242465},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"241965.0000\"}}',NULL,'2023-11-06 14:06:55','2023-11-06 14:06:55'),(895,'default','payment_edited',383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"151635.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"151635.0000\"}}',NULL,'2023-11-06 14:08:38','2023-11-06 14:08:38'),(896,'default','added',486,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 14:16:11','2023-11-06 14:16:11'),(897,'default','added',489,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2023-11-06 14:18:07','2023-11-06 14:18:07'),(898,'default','added',490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":51800}}',NULL,'2023-11-06 14:20:57','2023-11-06 14:20:57'),(899,'default','edited',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:25:41','2023-11-06 14:25:41'),(900,'default','edited',48,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:26:26','2023-11-06 14:26:26'),(901,'default','added',491,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-06 14:33:14','2023-11-06 14:33:14'),(902,'default','added',492,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 14:45:30','2023-11-06 14:45:30'),(903,'default','added',493,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4560}}',NULL,'2023-11-06 14:50:50','2023-11-06 14:50:50'),(904,'default','added',76,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:53:32','2023-11-06 14:53:32'),(905,'default','added',494,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":149760}}',NULL,'2023-11-06 14:54:14','2023-11-06 14:54:14'),(906,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 14:54:24','2023-11-06 14:54:24'),(907,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 17:05:24','2023-11-06 17:05:24'),(908,'default','payment_edited',474,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"32300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"32300.0000\"}}',NULL,'2023-11-06 17:05:47','2023-11-06 17:05:47'),(909,'default','payment_edited',386,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6100.0000\"}}',NULL,'2023-11-06 17:06:36','2023-11-06 17:06:36'),(910,'default','added',495,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-06 17:07:27','2023-11-06 17:07:27'),(911,'default','added',496,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15850}}',NULL,'2023-11-06 17:09:50','2023-11-06 17:09:50'),(912,'default','added',497,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5900}}',NULL,'2023-11-06 17:11:02','2023-11-06 17:11:02'),(913,'default','added',498,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-06 17:32:57','2023-11-06 17:32:57'),(914,'default','added',499,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-06 17:33:18','2023-11-06 17:33:18'),(915,'default','added',500,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-06 17:36:59','2023-11-06 17:36:59'),(916,'default','added',501,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-06 17:57:53','2023-11-06 17:57:53'),(917,'default','payment_edited',317,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5430.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5430.0000\"}}',NULL,'2023-11-06 17:58:42','2023-11-06 17:58:42'),(918,'default','added',502,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-06 18:03:19','2023-11-06 18:03:19'),(919,'default','added',503,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-06 18:05:24','2023-11-06 18:05:24'),(920,'default','added',504,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-06 18:31:44','2023-11-06 18:31:44'),(921,'default','added',505,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-06 18:40:59','2023-11-06 18:40:59'),(922,'default','added',506,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-06 18:41:42','2023-11-06 18:41:42'),(923,'default','added',507,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-06 18:45:31','2023-11-06 18:45:31'),(924,'default','added',508,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-06 18:47:18','2023-11-06 18:47:18'),(925,'default','edited',56,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 19:00:45','2023-11-06 19:00:45'),(926,'default','added',509,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15538.879999999999199644662439823150634765625}}',NULL,'2023-11-06 19:18:06','2023-11-06 19:18:06'),(927,'default','added',510,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-06 19:26:52','2023-11-06 19:26:52'),(928,'default','added',511,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-06 19:32:18','2023-11-06 19:32:18'),(929,'default','added',512,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-06 19:36:43','2023-11-06 19:36:43'),(930,'default','added',513,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-06 19:37:13','2023-11-06 19:37:13'),(931,'default','added',514,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3030}}',NULL,'2023-11-06 19:44:03','2023-11-06 19:44:03'),(932,'default','added',515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3400}}',NULL,'2023-11-06 19:44:21','2023-11-06 19:44:21'),(933,'default','edited',515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":3400},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-06 19:45:16','2023-11-06 19:45:16'),(934,'default','payment_edited',515,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-06 19:46:03','2023-11-06 19:46:03'),(935,'default','added',516,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-06 19:46:35','2023-11-06 19:46:35'),(936,'default','added',517,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1650}}',NULL,'2023-11-06 19:50:08','2023-11-06 19:50:08'),(937,'default','payment_edited',517,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-06 19:50:36','2023-11-06 19:50:36'),(938,'default','added',518,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-06 19:50:51','2023-11-06 19:50:51'),(939,'default','added',519,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3050}}',NULL,'2023-11-06 19:52:08','2023-11-06 19:52:08'),(940,'default','payment_edited',519,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-06 19:52:26','2023-11-06 19:52:26'),(941,'default','added',520,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-06 19:53:25','2023-11-06 19:53:25'),(942,'default','added',521,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2600}}',NULL,'2023-11-06 19:54:33','2023-11-06 19:54:33'),(943,'default','payment_edited',521,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-06 19:54:56','2023-11-06 19:54:56'),(944,'default','added',522,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-06 20:10:31','2023-11-06 20:10:31'),(945,'default','added',523,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-06 20:10:57','2023-11-06 20:10:57'),(946,'default','payment_edited',387,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4650.0000\"}}',NULL,'2023-11-06 20:13:51','2023-11-06 20:13:51'),(947,'default','added',524,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-06 20:17:05','2023-11-06 20:17:05'),(948,'default','added',525,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3100}}',NULL,'2023-11-06 20:21:29','2023-11-06 20:21:29'),(949,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-06 20:22:01','2023-11-06 20:22:01'),(950,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 10:10:24','2023-11-07 10:10:24'),(951,'default','payment_edited',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-07 10:12:20','2023-11-07 10:12:20'),(952,'default','added',526,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-07 10:16:34','2023-11-07 10:16:34'),(953,'default','added',527,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2023-11-07 10:18:23','2023-11-07 10:18:23'),(954,'default','added',528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-07 10:19:26','2023-11-07 10:19:26'),(955,'default','added',529,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-07 10:20:10','2023-11-07 10:20:10'),(956,'default','added',530,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-07 10:20:37','2023-11-07 10:20:37'),(957,'default','added',531,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-07 10:27:02','2023-11-07 10:27:02'),(958,'default','added',532,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5750}}',NULL,'2023-11-07 10:28:45','2023-11-07 10:28:45'),(959,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 10:30:37','2023-11-07 10:30:37'),(960,'default','added',535,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5970}}',NULL,'2023-11-07 10:44:26','2023-11-07 10:44:26'),(961,'default','added',536,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-07 11:00:58','2023-11-07 11:00:58'),(962,'default','added',77,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 11:02:08','2023-11-07 11:02:08'),(963,'default','added',537,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-11-07 11:02:38','2023-11-07 11:02:38'),(964,'default','added',538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-11-07 11:08:27','2023-11-07 11:08:27'),(965,'default','added',539,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-07 11:18:27','2023-11-07 11:18:27'),(966,'default','added',540,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2023-11-07 11:19:00','2023-11-07 11:19:00'),(967,'default','added',541,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-07 11:45:26','2023-11-07 11:45:26'),(968,'default','added',542,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12250}}',NULL,'2023-11-07 11:48:50','2023-11-07 11:48:50'),(969,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 14:14:39','2023-11-07 14:14:39'),(970,'default','added',543,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-11-07 14:18:53','2023-11-07 14:18:53'),(971,'default','added',544,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20030}}',NULL,'2023-11-07 14:25:51','2023-11-07 14:25:51'),(972,'default','added',545,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5150}}',NULL,'2023-11-07 14:27:24','2023-11-07 14:27:24'),(973,'default','added',546,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-07 14:29:19','2023-11-07 14:29:19'),(974,'default','added',547,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6200}}',NULL,'2023-11-07 14:30:45','2023-11-07 14:30:45'),(975,'default','payment_edited',494,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"149760.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"149760.0000\"}}',NULL,'2023-11-07 14:32:37','2023-11-07 14:32:37'),(976,'default','added',548,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-07 14:59:06','2023-11-07 14:59:06'),(977,'default','added',78,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 14:59:34','2023-11-07 14:59:34'),(978,'default','added',549,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":33904}}',NULL,'2023-11-07 15:05:43','2023-11-07 15:05:43'),(979,'default','added',550,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-07 15:06:31','2023-11-07 15:06:31'),(980,'default','added',551,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3240}}',NULL,'2023-11-07 15:08:39','2023-11-07 15:08:39'),(981,'default','added',552,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-07 15:15:32','2023-11-07 15:15:32'),(982,'default','added',553,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-07 16:45:07','2023-11-07 16:45:07'),(983,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 16:46:32','2023-11-07 16:46:32'),(984,'default','added',554,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10640}}',NULL,'2023-11-07 17:07:49','2023-11-07 17:07:49'),(985,'default','added',555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-07 17:08:36','2023-11-07 17:08:36'),(986,'default','added',556,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16690}}',NULL,'2023-11-07 17:11:52','2023-11-07 17:11:52'),(987,'default','added',557,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-07 17:12:53','2023-11-07 17:12:53'),(988,'default','added',558,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-07 17:14:32','2023-11-07 17:14:32'),(989,'default','added',559,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-07 17:21:46','2023-11-07 17:21:46'),(990,'default','added',560,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2125}}',NULL,'2023-11-07 17:22:23','2023-11-07 17:22:23'),(991,'default','added',561,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3850}}',NULL,'2023-11-07 17:27:29','2023-11-07 17:27:29'),(992,'default','added',562,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-07 17:34:48','2023-11-07 17:34:48'),(993,'default','edited',562,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"}}',NULL,'2023-11-07 17:40:19','2023-11-07 17:40:19'),(994,'default','added',563,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-07 17:54:16','2023-11-07 17:54:16'),(995,'default','added',564,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-07 17:56:06','2023-11-07 17:56:06'),(996,'default','added',565,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-07 17:58:20','2023-11-07 17:58:20'),(997,'default','payment_edited',132,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 18:07:27','2023-11-07 18:07:27'),(998,'default','added',566,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-07 18:08:06','2023-11-07 18:08:06'),(999,'default','added',567,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3040}}',NULL,'2023-11-07 18:11:09','2023-11-07 18:11:09'),(1000,'default','added',568,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":65000}}',NULL,'2023-11-07 18:17:13','2023-11-07 18:17:13'),(1001,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-07 18:48:33','2023-11-07 18:48:33'),(1002,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 10:07:40','2023-11-08 10:07:40'),(1003,'default','added',569,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-08 10:08:06','2023-11-08 10:08:06'),(1004,'default','payment_edited',537,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-11-08 10:11:26','2023-11-08 10:11:26'),(1005,'default','payment_edited',168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-08 10:12:30','2023-11-08 10:12:30'),(1006,'default','payment_edited',185,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-08 10:12:30','2023-11-08 10:12:30'),(1007,'default','payment_edited',525,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-08 10:12:57','2023-11-08 10:12:57'),(1008,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 10:13:28','2023-11-08 10:13:28'),(1009,'default','payment_edited',213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15020.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15020.0000\"}}',NULL,'2023-11-08 10:13:50','2023-11-08 10:13:50'),(1010,'default','payment_edited',214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-11-08 10:13:50','2023-11-08 10:13:50'),(1011,'default','payment_edited',427,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 10:15:16','2023-11-08 10:15:16'),(1012,'default','payment_edited',428,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-08 10:15:16','2023-11-08 10:15:16'),(1013,'default','added',570,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20469.79999999999927240423858165740966796875}}',NULL,'2023-11-08 10:20:29','2023-11-08 10:20:29'),(1014,'default','added',571,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1830}}',NULL,'2023-11-08 10:21:32','2023-11-08 10:21:32'),(1015,'default','added',572,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19120}}',NULL,'2023-11-08 10:23:29','2023-11-08 10:23:29'),(1016,'default','added',573,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-08 10:26:11','2023-11-08 10:26:11'),(1017,'default','added',574,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12490}}',NULL,'2023-11-08 10:28:49','2023-11-08 10:28:49'),(1018,'default','added',575,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-08 10:35:02','2023-11-08 10:35:02'),(1019,'default','added',576,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4630}}',NULL,'2023-11-08 11:03:14','2023-11-08 11:03:14'),(1020,'default','payment_edited',134,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 11:05:08','2023-11-08 11:05:08'),(1021,'default','added',577,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-08 11:05:52','2023-11-08 11:05:52'),(1022,'default','added',578,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-08 11:11:27','2023-11-08 11:11:27'),(1023,'default','added',579,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11000}}',NULL,'2023-11-08 11:34:21','2023-11-08 11:34:21'),(1024,'default','payment_edited',444,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-08 11:37:26','2023-11-08 11:37:26'),(1025,'default','added',580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-08 11:41:44','2023-11-08 11:41:44'),(1026,'default','payment_edited',383,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"151635.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"151635.0000\"}}',NULL,'2023-11-08 11:45:30','2023-11-08 11:45:30'),(1027,'default','payment_edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"242465.0000\"}}',NULL,'2023-11-08 11:45:30','2023-11-08 11:45:30'),(1028,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 11:59:29','2023-11-08 11:59:29'),(1029,'default','added',581,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3130}}',NULL,'2023-11-08 12:01:15','2023-11-08 12:01:15'),(1030,'default','payment_edited',435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"156978.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"156978.0000\"}}',NULL,'2023-11-08 13:33:10','2023-11-08 13:33:10'),(1031,'default','added',582,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":15000}}',NULL,'2023-11-08 13:35:14','2023-11-08 13:35:14'),(1032,'default','added',584,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9540}}',NULL,'2023-11-08 13:41:58','2023-11-08 13:41:58'),(1033,'default','added',586,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-11-08 13:50:07','2023-11-08 13:50:07'),(1034,'default','added',587,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900}}',NULL,'2023-11-08 13:50:36','2023-11-08 13:50:36'),(1035,'default','added',588,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1530}}',NULL,'2023-11-08 14:01:11','2023-11-08 14:01:11'),(1036,'default','added',589,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-08 14:18:19','2023-11-08 14:18:19'),(1037,'default','added',590,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4520}}',NULL,'2023-11-08 14:21:30','2023-11-08 14:21:30'),(1038,'default','edited',579,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11000.0000\"}}',NULL,'2023-11-08 14:22:38','2023-11-08 14:22:38'),(1039,'default','added',591,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2980}}',NULL,'2023-11-08 14:38:37','2023-11-08 14:38:37'),(1040,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 16:50:47','2023-11-08 16:50:47'),(1041,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 17:27:14','2023-11-08 17:27:14'),(1042,'default','added',592,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-08 17:31:03','2023-11-08 17:31:03'),(1043,'default','added',593,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-08 17:38:23','2023-11-08 17:38:23'),(1044,'default','edited',36,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 17:42:56','2023-11-08 17:42:56'),(1045,'default','added',594,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-08 17:43:35','2023-11-08 17:43:35'),(1046,'default','added',595,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-08 17:44:28','2023-11-08 17:44:28'),(1047,'default','added',596,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-08 17:45:08','2023-11-08 17:45:08'),(1048,'default','added',597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2830}}',NULL,'2023-11-08 17:46:30','2023-11-08 17:46:30'),(1049,'default','added',598,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11700}}',NULL,'2023-11-08 17:47:56','2023-11-08 17:47:56'),(1050,'default','added',599,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2280}}',NULL,'2023-11-08 17:50:52','2023-11-08 17:50:52'),(1051,'default','added',600,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":45547}}',NULL,'2023-11-08 17:51:23','2023-11-08 17:51:23'),(1052,'default','added',601,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-08 18:03:15','2023-11-08 18:03:15'),(1053,'default','added',602,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7580}}',NULL,'2023-11-08 18:09:30','2023-11-08 18:09:30'),(1054,'default','added',603,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2650}}',NULL,'2023-11-08 18:15:45','2023-11-08 18:15:45'),(1055,'default','added',604,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-08 18:16:40','2023-11-08 18:16:40'),(1056,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 18:17:00','2023-11-08 18:17:00'),(1057,'default','added',605,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-08 18:32:42','2023-11-08 18:32:42'),(1058,'default','added',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2480}}',NULL,'2023-11-08 18:33:31','2023-11-08 18:33:31'),(1059,'default','added',79,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 18:42:56','2023-11-08 18:42:56'),(1060,'default','added',607,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-11-08 18:44:24','2023-11-08 18:44:24'),(1061,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 18:45:35','2023-11-08 18:45:35'),(1062,'default','added',608,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-08 18:47:44','2023-11-08 18:47:44'),(1063,'default','added',609,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1520}}',NULL,'2023-11-08 18:54:48','2023-11-08 18:54:48'),(1064,'default','payment_edited',580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-08 19:26:15','2023-11-08 19:26:15'),(1065,'default','added',610,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-08 19:27:09','2023-11-08 19:27:09'),(1066,'default','added',611,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-08 19:41:50','2023-11-08 19:41:50'),(1067,'default','added',612,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-08 19:50:37','2023-11-08 19:50:37'),(1068,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-08 19:51:41','2023-11-08 19:51:41'),(1069,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 10:03:45','2023-11-09 10:03:45'),(1070,'default','added',613,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-09 10:05:51','2023-11-09 10:05:51'),(1071,'default','payment_edited',580,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-09 10:06:57','2023-11-09 10:06:57'),(1072,'default','payment_edited',207,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 10:07:37','2023-11-09 10:07:37'),(1073,'default','payment_edited',230,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-09 10:07:57','2023-11-09 10:07:57'),(1074,'default','payment_edited',273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-09 10:07:57','2023-11-09 10:07:57'),(1075,'default','payment_edited',597,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2830.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2830.0000\"}}',NULL,'2023-11-09 10:08:17','2023-11-09 10:08:17'),(1076,'default','payment_edited',214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"}}',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(1077,'default','payment_edited',247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(1078,'default','payment_edited',289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(1079,'default','payment_edited',303,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5250.0000\"}}',NULL,'2023-11-09 10:09:29','2023-11-09 10:09:29'),(1080,'default','payment_edited',603,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2650.0000\"}}',NULL,'2023-11-09 10:09:29','2023-11-09 10:09:29'),(1081,'default','added',614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7650}}',NULL,'2023-11-09 10:13:09','2023-11-09 10:13:09'),(1082,'default','added',615,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23090}}',NULL,'2023-11-09 10:20:40','2023-11-09 10:20:40'),(1083,'default','added',616,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-09 10:21:28','2023-11-09 10:21:28'),(1084,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-09 10:22:29','2023-11-09 10:22:29'),(1085,'default','added',617,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-09 10:26:14','2023-11-09 10:26:14'),(1086,'default','added',618,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 10:31:32','2023-11-09 10:31:32'),(1087,'default','payment_edited',618,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"paid\"},\"old\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 10:31:53','2023-11-09 10:31:53'),(1088,'default','added',619,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7510}}',NULL,'2023-11-09 10:36:50','2023-11-09 10:36:50'),(1089,'default','added',620,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-09 10:41:40','2023-11-09 10:41:40'),(1090,'default','added',621,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-09 10:56:31','2023-11-09 10:56:31'),(1091,'default','added',622,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-09 10:57:47','2023-11-09 10:57:47'),(1092,'default','payment_edited',134,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 11:02:24','2023-11-09 11:02:24'),(1093,'default','added',623,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8350}}',NULL,'2023-11-09 11:03:39','2023-11-09 11:03:39'),(1094,'default','added',624,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-09 12:13:53','2023-11-09 12:13:53'),(1095,'default','added',625,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11880}}',NULL,'2023-11-09 12:15:48','2023-11-09 12:15:48'),(1096,'default','added',626,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-09 12:21:19','2023-11-09 12:21:19'),(1097,'default','added',80,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 12:31:05','2023-11-09 12:31:05'),(1098,'default','added',627,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4950}}',NULL,'2023-11-09 12:31:41','2023-11-09 12:31:41'),(1099,'default','added',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":581400}}',NULL,'2023-11-09 12:40:31','2023-11-09 12:40:31'),(1100,'default','payment_edited',76,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"502690.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"502690.0000\"}}',NULL,'2023-11-09 12:42:01','2023-11-09 12:42:01'),(1101,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-09 12:42:01','2023-11-09 12:42:01'),(1102,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-09 12:42:33','2023-11-09 12:42:33'),(1103,'default','payment_edited',571,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1830.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1830.0000\"}}',NULL,'2023-11-09 12:44:40','2023-11-09 12:44:40'),(1104,'default','added',629,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-09 12:46:22','2023-11-09 12:46:22'),(1105,'default','added',630,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-09 12:47:02','2023-11-09 12:47:02'),(1106,'default','added',631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-09 12:52:43','2023-11-09 12:52:43'),(1107,'default','payment_edited',627,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4950.0000\"}}',NULL,'2023-11-09 13:15:48','2023-11-09 13:15:48'),(1108,'default','added',632,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":64500}}',NULL,'2023-11-09 13:33:13','2023-11-09 13:33:13'),(1109,'default','added',633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-09 13:40:35','2023-11-09 13:40:35'),(1110,'default','added',634,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5900}}',NULL,'2023-11-09 13:41:37','2023-11-09 13:41:37'),(1111,'default','added',635,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-09 13:42:15','2023-11-09 13:42:15'),(1112,'default','payment_edited',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"}}',NULL,'2023-11-09 13:50:28','2023-11-09 13:50:28'),(1113,'default','added',636,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 13:55:21','2023-11-09 13:55:21'),(1114,'default','added',637,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-09 13:59:50','2023-11-09 13:59:50'),(1115,'default','added',638,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7520}}',NULL,'2023-11-09 14:09:59','2023-11-09 14:09:59'),(1116,'default','added',639,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 14:30:13','2023-11-09 14:30:13'),(1117,'default','added',640,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4900}}',NULL,'2023-11-09 14:36:42','2023-11-09 14:36:42'),(1118,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 14:38:28','2023-11-09 14:38:28'),(1119,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 17:04:43','2023-11-09 17:04:43'),(1120,'default','payment_edited',607,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-11-09 17:07:59','2023-11-09 17:07:59'),(1121,'default','added',641,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29170}}',NULL,'2023-11-09 17:11:52','2023-11-09 17:11:52'),(1122,'default','added',642,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":36120}}',NULL,'2023-11-09 17:14:12','2023-11-09 17:14:12'),(1123,'default','added',81,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 17:16:08','2023-11-09 17:16:08'),(1124,'default','added',643,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-11-09 17:16:40','2023-11-09 17:16:40'),(1125,'default','added',644,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-09 17:16:58','2023-11-09 17:16:58'),(1126,'default','added',645,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-09 17:40:51','2023-11-09 17:40:51'),(1127,'default','added',646,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-09 17:43:25','2023-11-09 17:43:25'),(1128,'default','added',647,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-09 17:48:46','2023-11-09 17:48:46'),(1129,'default','payment_edited',437,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-09 17:55:24','2023-11-09 17:55:24'),(1130,'default','added',648,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-09 18:01:23','2023-11-09 18:01:23'),(1131,'default','added',649,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-09 18:05:06','2023-11-09 18:05:06'),(1132,'default','added',82,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 18:05:58','2023-11-09 18:05:58'),(1133,'default','added',650,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450}}',NULL,'2023-11-09 18:06:31','2023-11-09 18:06:31'),(1134,'default','added',651,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-09 18:29:11','2023-11-09 18:29:11'),(1135,'default','added',652,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6220}}',NULL,'2023-11-09 18:42:10','2023-11-09 18:42:10'),(1136,'default','added',653,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1380}}',NULL,'2023-11-09 18:43:58','2023-11-09 18:43:58'),(1137,'default','payment_edited',653,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1380.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1380.0000\"}}',NULL,'2023-11-09 18:44:18','2023-11-09 18:44:18'),(1138,'default','added',654,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1680}}',NULL,'2023-11-09 18:52:57','2023-11-09 18:52:57'),(1139,'default','payment_edited',654,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1680.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1680.0000\"}}',NULL,'2023-11-09 18:53:28','2023-11-09 18:53:28'),(1140,'default','added',655,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-09 19:05:01','2023-11-09 19:05:01'),(1141,'default','added',656,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-09 19:21:05','2023-11-09 19:21:05'),(1142,'default','added',657,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1500}}',NULL,'2023-11-09 19:26:10','2023-11-09 19:26:10'),(1143,'default','payment_edited',657,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-09 19:26:34','2023-11-09 19:26:34'),(1144,'default','added',658,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-09 19:27:05','2023-11-09 19:27:05'),(1145,'default','added',659,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3080}}',NULL,'2023-11-09 19:28:57','2023-11-09 19:28:57'),(1146,'default','added',660,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-09 19:31:45','2023-11-09 19:31:45'),(1147,'default','added',661,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-11-09 19:33:17','2023-11-09 19:33:17'),(1148,'default','added',662,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-09 19:36:58','2023-11-09 19:36:58'),(1149,'default','added',663,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-11-09 19:43:09','2023-11-09 19:43:09'),(1150,'default','added',664,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 19:48:31','2023-11-09 19:48:31'),(1151,'default','added',665,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":60}}',NULL,'2023-11-09 19:51:27','2023-11-09 19:51:27'),(1152,'default','added',666,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-09 19:51:42','2023-11-09 19:51:42'),(1153,'default','added',667,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-09 19:52:16','2023-11-09 19:52:16'),(1154,'default','added',668,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2530}}',NULL,'2023-11-09 19:52:55','2023-11-09 19:52:55'),(1155,'default','added',669,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2023-11-09 19:54:10','2023-11-09 19:54:10'),(1156,'default','added',670,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-09 19:57:17','2023-11-09 19:57:17'),(1157,'default','added',671,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 20:01:00','2023-11-09 20:01:00'),(1158,'default','added',672,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-09 20:01:49','2023-11-09 20:01:49'),(1159,'default','added',673,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-09 20:02:40','2023-11-09 20:02:40'),(1160,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-09 20:06:55','2023-11-09 20:06:55'),(1161,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 10:17:00','2023-11-11 10:17:00'),(1162,'default','added',674,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-11 10:17:30','2023-11-11 10:17:30'),(1163,'default','payment_edited',273,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-11 10:19:13','2023-11-11 10:19:13'),(1164,'default','payment_edited',360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-11 10:19:13','2023-11-11 10:19:13'),(1165,'default','payment_edited',643,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-11-11 10:19:26','2023-11-11 10:19:26'),(1166,'default','payment_edited',659,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3080.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3080.0000\"}}',NULL,'2023-11-11 10:19:41','2023-11-11 10:19:41'),(1167,'default','added',675,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 10:20:45','2023-11-11 10:20:45'),(1168,'default','added',676,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12020}}',NULL,'2023-11-11 10:23:18','2023-11-11 10:23:18'),(1169,'default','added',677,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22310}}',NULL,'2023-11-11 10:27:25','2023-11-11 10:27:25'),(1170,'default','added',678,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8500}}',NULL,'2023-11-11 10:28:26','2023-11-11 10:28:26'),(1171,'default','payment_edited',51,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 10:29:14','2023-11-11 10:29:14'),(1172,'default','added',679,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-11-11 10:31:18','2023-11-11 10:31:18'),(1173,'default','added',680,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-11-11 10:32:39','2023-11-11 10:32:39'),(1174,'default','added',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-11-11 10:33:32','2023-11-11 10:33:32'),(1175,'default','added',682,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3570}}',NULL,'2023-11-11 10:35:22','2023-11-11 10:35:22'),(1176,'default','added',683,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-11 10:40:01','2023-11-11 10:40:01'),(1177,'default','added',83,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 10:41:27','2023-11-11 10:41:27'),(1178,'default','added',684,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2040}}',NULL,'2023-11-11 10:43:01','2023-11-11 10:43:01'),(1179,'default','added',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":15650}}',NULL,'2023-11-11 10:46:06','2023-11-11 10:46:06'),(1180,'default','added',686,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-11 10:59:18','2023-11-11 10:59:18'),(1181,'default','added',687,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-11 11:12:04','2023-11-11 11:12:04'),(1182,'default','added',688,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-11 11:12:40','2023-11-11 11:12:40'),(1183,'default','added',689,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-11-11 11:16:58','2023-11-11 11:16:58'),(1184,'default','added',690,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-11 11:23:45','2023-11-11 11:23:45'),(1185,'default','added',691,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5050}}',NULL,'2023-11-11 11:30:56','2023-11-11 11:30:56'),(1186,'default','added',692,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3480}}',NULL,'2023-11-11 11:39:02','2023-11-11 11:39:02'),(1187,'default','added',693,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-11 11:43:38','2023-11-11 11:43:38'),(1188,'default','payment_edited',692,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3480.0000\"}}',NULL,'2023-11-11 11:48:24','2023-11-11 11:48:24'),(1189,'default','added',84,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 11:52:57','2023-11-11 11:52:57'),(1190,'default','added',694,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2700}}',NULL,'2023-11-11 11:53:37','2023-11-11 11:53:37'),(1191,'default','added',695,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-11 11:55:11','2023-11-11 11:55:11'),(1192,'default','added',696,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-11 12:06:54','2023-11-11 12:06:54'),(1193,'default','payment_edited',402,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"130380.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"130380.0000\"}}',NULL,'2023-11-11 12:17:47','2023-11-11 12:17:47'),(1194,'default','added',697,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":114120}}',NULL,'2023-11-11 12:20:43','2023-11-11 12:20:43'),(1195,'default','added',698,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-11 12:33:50','2023-11-11 12:33:50'),(1196,'default','added',699,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-11 12:36:53','2023-11-11 12:36:53'),(1197,'default','payment_edited',360,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-11 13:24:13','2023-11-11 13:24:13'),(1198,'default','payment_edited',382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-11 13:24:13','2023-11-11 13:24:13'),(1199,'default','added',700,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 13:25:13','2023-11-11 13:25:13'),(1200,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 13:31:22','2023-11-11 13:31:22'),(1201,'default','added',701,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-11 13:35:04','2023-11-11 13:35:04'),(1202,'default','added',702,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-11 13:52:26','2023-11-11 13:52:26'),(1203,'default','added',703,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-11 13:54:28','2023-11-11 13:54:28'),(1204,'default','added',704,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1780}}',NULL,'2023-11-11 14:07:40','2023-11-11 14:07:40'),(1205,'default','payment_edited',640,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-11 14:08:13','2023-11-11 14:08:13'),(1206,'default','added',705,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5350}}',NULL,'2023-11-11 14:09:38','2023-11-11 14:09:38'),(1207,'default','added',706,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-11 14:15:58','2023-11-11 14:15:58'),(1208,'default','added',707,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-11 14:16:33','2023-11-11 14:16:33'),(1209,'default','added',708,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14800}}',NULL,'2023-11-11 14:22:21','2023-11-11 14:22:21'),(1210,'default','added',709,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4350}}',NULL,'2023-11-11 14:26:52','2023-11-11 14:26:52'),(1211,'default','added',710,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-11 14:27:06','2023-11-11 14:27:06'),(1212,'default','added',711,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-11 14:29:53','2023-11-11 14:29:53'),(1213,'default','added',712,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-11-11 14:36:14','2023-11-11 14:36:14'),(1214,'default','added',713,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-11 14:39:29','2023-11-11 14:39:29'),(1215,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 17:14:14','2023-11-11 17:14:14'),(1216,'default','added',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":37080}}',NULL,'2023-11-11 17:35:54','2023-11-11 17:35:54'),(1217,'default','payment_edited',191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50070.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"50070.0000\"}}',NULL,'2023-11-11 17:36:44','2023-11-11 17:36:44'),(1218,'default','payment_edited',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"37080.0000\"}}',NULL,'2023-11-11 17:36:44','2023-11-11 17:36:44'),(1219,'default','added',715,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31590}}',NULL,'2023-11-11 17:41:10','2023-11-11 17:41:10'),(1220,'default','payment_edited',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"}}',NULL,'2023-11-11 17:42:46','2023-11-11 17:42:46'),(1221,'default','added',716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":207615}}',NULL,'2023-11-11 17:48:49','2023-11-11 17:48:49'),(1222,'default','added',717,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 17:49:52','2023-11-11 17:49:52'),(1223,'default','added',718,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-11-11 17:51:34','2023-11-11 17:51:34'),(1224,'default','added',719,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-11 17:54:02','2023-11-11 17:54:02'),(1225,'default','payment_edited',582,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15000.0000\"}}',NULL,'2023-11-11 17:55:06','2023-11-11 17:55:06'),(1226,'default','added',720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-11-11 17:57:51','2023-11-11 17:57:51'),(1227,'default','added',721,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":91163.25}}',NULL,'2023-11-11 18:02:45','2023-11-11 18:02:45'),(1228,'default','added',722,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12780}}',NULL,'2023-11-11 18:04:20','2023-11-11 18:04:20'),(1229,'default','added',723,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6160}}',NULL,'2023-11-11 18:06:03','2023-11-11 18:06:03'),(1230,'default','payment_edited',631,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-11 18:06:54','2023-11-11 18:06:54'),(1231,'default','added',724,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1830}}',NULL,'2023-11-11 18:08:28','2023-11-11 18:08:28'),(1232,'default','added',725,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21660}}',NULL,'2023-11-11 18:11:51','2023-11-11 18:11:51'),(1233,'default','added',726,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-11-11 18:13:27','2023-11-11 18:13:27'),(1234,'default','added',727,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-11-11 18:14:00','2023-11-11 18:14:00'),(1235,'default','payment_edited',578,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-11 18:14:59','2023-11-11 18:14:59'),(1236,'default','added',728,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-11 18:24:23','2023-11-11 18:24:23'),(1237,'default','payment_edited',435,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"156978.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"156978.0000\"}}',NULL,'2023-11-11 18:42:55','2023-11-11 18:42:55'),(1238,'default','added',729,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-11 18:43:11','2023-11-11 18:43:11'),(1239,'default','added',730,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 19:07:12','2023-11-11 19:07:12'),(1240,'default','added',731,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-11 19:08:29','2023-11-11 19:08:29'),(1241,'default','added',732,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-11 19:09:49','2023-11-11 19:09:49'),(1242,'default','added',733,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380}}',NULL,'2023-11-11 19:18:05','2023-11-11 19:18:05'),(1243,'default','added',734,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1620}}',NULL,'2023-11-11 19:22:43','2023-11-11 19:22:43'),(1244,'default','payment_edited',371,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"308000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"308000.0000\"}}',NULL,'2023-11-11 19:24:36','2023-11-11 19:24:36'),(1245,'default','payment_edited',490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"51800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"51800.0000\"}}',NULL,'2023-11-11 19:24:36','2023-11-11 19:24:36'),(1246,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-11 19:24:59','2023-11-11 19:24:59'),(1247,'default','added',735,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-11 19:33:30','2023-11-11 19:33:30'),(1248,'default','added',736,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-11 19:35:28','2023-11-11 19:35:28'),(1249,'default','added',737,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-11 19:36:29','2023-11-11 19:36:29'),(1250,'default','added',738,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-11 19:51:42','2023-11-11 19:51:42'),(1251,'default','added',739,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-11 19:56:19','2023-11-11 19:56:19'),(1252,'default','added',740,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13670}}',NULL,'2023-11-11 20:27:33','2023-11-11 20:27:33'),(1253,'default','added',741,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-11 20:28:30','2023-11-11 20:28:30'),(1254,'default','payment_edited',679,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-11 20:28:55','2023-11-11 20:28:55'),(1255,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-11 20:30:18','2023-11-11 20:30:18'),(1256,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 10:10:57','2023-11-12 10:10:57'),(1257,'default','payment_edited',723,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6160.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6160.0000\"}}',NULL,'2023-11-12 10:12:53','2023-11-12 10:12:53'),(1258,'default','payment_edited',289,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-12 10:13:18','2023-11-12 10:13:18'),(1259,'default','payment_edited',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12670.0000\"}}',NULL,'2023-11-12 10:13:18','2023-11-12 10:13:18'),(1260,'default','payment_edited',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2480.0000\"}}',NULL,'2023-11-12 10:16:01','2023-11-12 10:16:01'),(1261,'default','added',742,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-12 10:29:32','2023-11-12 10:29:32'),(1262,'default','added',743,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-12 10:33:00','2023-11-12 10:33:00'),(1263,'default','added',744,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-12 10:48:42','2023-11-12 10:48:42'),(1264,'default','added',745,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5840}}',NULL,'2023-11-12 10:51:55','2023-11-12 10:51:55'),(1265,'default','added',746,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5015}}',NULL,'2023-11-12 10:54:39','2023-11-12 10:54:39'),(1266,'default','added',747,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-11-12 10:54:56','2023-11-12 10:54:56'),(1267,'default','added',748,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9800}}',NULL,'2023-11-12 10:56:34','2023-11-12 10:56:34'),(1268,'default','added',749,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-12 10:56:55','2023-11-12 10:56:55'),(1269,'default','added',750,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4900}}',NULL,'2023-11-12 10:57:25','2023-11-12 10:57:25'),(1270,'default','added',751,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3380}}',NULL,'2023-11-12 11:01:50','2023-11-12 11:01:50'),(1271,'default','added',752,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-12 11:07:58','2023-11-12 11:07:58'),(1272,'default','added',753,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-12 11:29:27','2023-11-12 11:29:27'),(1273,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 11:30:13','2023-11-12 11:30:13'),(1274,'default','added',754,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-12 11:31:13','2023-11-12 11:31:13'),(1275,'default','added',85,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 12:01:05','2023-11-12 12:01:05'),(1276,'default','added',755,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1650}}',NULL,'2023-11-12 12:01:37','2023-11-12 12:01:37'),(1277,'default','added',756,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-12 12:02:44','2023-11-12 12:02:44'),(1278,'default','added',757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-12 12:03:44','2023-11-12 12:03:44'),(1279,'default','added',758,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-12 12:05:49','2023-11-12 12:05:49'),(1280,'default','added',86,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 12:09:13','2023-11-12 12:09:13'),(1281,'default','edited',757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"}}',NULL,'2023-11-12 12:09:22','2023-11-12 12:09:22'),(1282,'default','added',759,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 12:12:26','2023-11-12 12:12:26'),(1283,'default','added',760,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 12:12:49','2023-11-12 12:12:49'),(1284,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 14:13:16','2023-11-12 14:13:16'),(1285,'default','added',761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-12 14:14:50','2023-11-12 14:14:50'),(1286,'default','added',762,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-12 14:15:30','2023-11-12 14:15:30'),(1287,'default','added',763,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-12 14:29:29','2023-11-12 14:29:29'),(1288,'default','payment_edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"}}',NULL,'2023-11-12 14:30:35','2023-11-12 14:30:35'),(1289,'default','added',764,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-12 14:54:01','2023-11-12 14:54:01'),(1290,'default','added',765,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":240}}',NULL,'2023-11-12 14:56:03','2023-11-12 14:56:03'),(1291,'default','added',766,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-12 14:56:28','2023-11-12 14:56:28'),(1292,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 17:30:42','2023-11-12 17:30:42'),(1293,'default','added',767,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14680}}',NULL,'2023-11-12 17:35:27','2023-11-12 17:35:27'),(1294,'default','added',768,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4950}}',NULL,'2023-11-12 17:36:12','2023-11-12 17:36:12'),(1295,'default','added',769,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-12 17:42:10','2023-11-12 17:42:10'),(1296,'default','added',770,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":57900}}',NULL,'2023-11-12 17:53:01','2023-11-12 17:53:01'),(1297,'default','added',771,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-12 17:59:49','2023-11-12 17:59:49'),(1298,'default','added',772,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-12 18:00:33','2023-11-12 18:00:33'),(1299,'default','added',773,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-12 18:04:31','2023-11-12 18:04:31'),(1300,'default','added',774,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 18:06:19','2023-11-12 18:06:19'),(1301,'default','added',775,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 18:13:11','2023-11-12 18:13:11'),(1302,'default','added',776,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3080}}',NULL,'2023-11-12 18:22:08','2023-11-12 18:22:08'),(1303,'default','payment_edited',650,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2023-11-12 18:32:17','2023-11-12 18:32:17'),(1304,'default','added',777,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-12 18:42:48','2023-11-12 18:42:48'),(1305,'default','added',778,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-11-12 18:46:25','2023-11-12 18:46:25'),(1306,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 18:57:21','2023-11-12 18:57:21'),(1307,'default','added',779,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2023-11-12 19:07:57','2023-11-12 19:07:57'),(1308,'default','edited',21,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 19:11:46','2023-11-12 19:11:46'),(1309,'default','added',780,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1480}}',NULL,'2023-11-12 19:20:32','2023-11-12 19:20:32'),(1310,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 19:26:25','2023-11-12 19:26:25'),(1311,'default','added',781,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-12 19:28:49','2023-11-12 19:28:49'),(1312,'default','added',782,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-12 19:56:34','2023-11-12 19:56:34'),(1313,'default','added',783,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2580}}',NULL,'2023-11-12 19:59:20','2023-11-12 19:59:20'),(1314,'default','added',784,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-12 20:11:52','2023-11-12 20:11:52'),(1315,'default','added',785,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-12 20:13:56','2023-11-12 20:13:56'),(1316,'default','added',786,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-12 20:18:48','2023-11-12 20:18:48'),(1317,'default','added',87,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 20:33:03','2023-11-12 20:33:03'),(1318,'default','added',787,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1500}}',NULL,'2023-11-12 20:33:36','2023-11-12 20:33:36'),(1319,'default','added',788,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-12 20:39:20','2023-11-12 20:39:20'),(1320,'default','added',789,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3550}}',NULL,'2023-11-12 20:45:43','2023-11-12 20:45:43'),(1321,'default','added',790,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-12 20:47:11','2023-11-12 20:47:11'),(1322,'default','added',791,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}',NULL,'2023-11-12 20:58:26','2023-11-12 20:58:26'),(1323,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 21:07:16','2023-11-12 21:07:16'),(1324,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 21:07:20','2023-11-12 21:07:20'),(1325,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 21:07:26','2023-11-12 21:07:26'),(1326,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-12 22:27:19','2023-11-12 22:27:19'),(1327,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 10:29:32','2023-11-13 10:29:32'),(1328,'default','added',792,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-13 10:30:01','2023-11-13 10:30:01'),(1329,'default','payment_edited',787,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-13 10:33:19','2023-11-13 10:33:19'),(1330,'default','payment_edited',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"}}',NULL,'2023-11-13 10:33:49','2023-11-13 10:33:49'),(1331,'default','payment_edited',382,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-13 10:34:06','2023-11-13 10:34:06'),(1332,'default','payment_edited',432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-13 10:34:06','2023-11-13 10:34:06'),(1333,'default','added',793,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3330}}',NULL,'2023-11-13 10:38:16','2023-11-13 10:38:16'),(1334,'default','added',794,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-13 10:43:09','2023-11-13 10:43:09'),(1335,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 11:00:59','2023-11-13 11:00:59'),(1336,'default','added',795,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":48360}}',NULL,'2023-11-13 11:11:49','2023-11-13 11:11:49'),(1337,'default','added',796,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 11:13:19','2023-11-13 11:13:19'),(1338,'default','added',797,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-13 11:15:40','2023-11-13 11:15:40'),(1339,'default','added',798,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-13 11:37:10','2023-11-13 11:37:10'),(1340,'default','added',799,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-11-13 11:43:56','2023-11-13 11:43:56'),(1341,'default','added',800,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-13 12:13:36','2023-11-13 12:13:36'),(1342,'default','added',801,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4120}}',NULL,'2023-11-13 12:35:30','2023-11-13 12:35:30'),(1343,'default','added',802,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-13 12:44:14','2023-11-13 12:44:14'),(1344,'default','added',803,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-13 12:45:59','2023-11-13 12:45:59'),(1345,'default','added',88,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 12:55:22','2023-11-13 12:55:22'),(1346,'default','edited',88,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 12:57:39','2023-11-13 12:57:39'),(1347,'default','payment_edited',804,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 13:00:03','2023-11-13 13:00:03'),(1348,'default','added',805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-11-13 13:00:03','2023-11-13 13:00:03'),(1349,'default','added',806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-13 13:38:36','2023-11-13 13:38:36'),(1350,'default','added',807,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-13 13:44:10','2023-11-13 13:44:10'),(1351,'default','added',808,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-13 14:05:34','2023-11-13 14:05:34'),(1352,'default','added',809,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-13 14:14:22','2023-11-13 14:14:22'),(1353,'default','added',810,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-13 14:37:38','2023-11-13 14:37:38'),(1354,'default','added',811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":86310}}',NULL,'2023-11-13 14:40:25','2023-11-13 14:40:25'),(1355,'default','payment_edited',238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"187880.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"187880.0000\"}}',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(1356,'default','payment_edited',297,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"69360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"69360.0000\"}}',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(1357,'default','payment_edited',472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"111100.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"111100.0000\"}}',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(1358,'default','added',812,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7750}}',NULL,'2023-11-13 14:53:58','2023-11-13 14:53:58'),(1359,'default','added',813,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-13 14:54:32','2023-11-13 14:54:32'),(1360,'default','payment_edited',724,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1830.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1830.0000\"}}',NULL,'2023-11-13 14:57:16','2023-11-13 14:57:16'),(1361,'default','added',814,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-13 14:58:09','2023-11-13 14:58:09'),(1362,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 18:39:30','2023-11-13 18:39:30'),(1363,'default','added',815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":34160}}',NULL,'2023-11-13 19:05:05','2023-11-13 19:05:05'),(1364,'default','payment_edited',46,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 19:07:34','2023-11-13 19:07:34'),(1365,'default','payment_edited',237,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-11-13 19:07:34','2023-11-13 19:07:34'),(1366,'default','payment_edited',795,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"48360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"48360.0000\"}}',NULL,'2023-11-13 19:11:49','2023-11-13 19:11:49'),(1367,'default','payment_edited',815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"34160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"34160.0000\"}}',NULL,'2023-11-13 19:11:49','2023-11-13 19:11:49'),(1368,'default','added',816,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400}}',NULL,'2023-11-13 19:13:25','2023-11-13 19:13:25'),(1369,'default','added',817,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-13 19:19:59','2023-11-13 19:19:59'),(1370,'default','added',818,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 19:20:59','2023-11-13 19:20:59'),(1371,'default','added',819,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15950}}',NULL,'2023-11-13 19:26:16','2023-11-13 19:26:16'),(1372,'default','added',820,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":53200}}',NULL,'2023-11-13 19:29:12','2023-11-13 19:29:12'),(1373,'default','added',821,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12289.920000000000072759576141834259033203125}}',NULL,'2023-11-13 19:34:07','2023-11-13 19:34:07'),(1374,'default','added',822,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5950}}',NULL,'2023-11-13 19:36:43','2023-11-13 19:36:43'),(1375,'default','added',823,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6150}}',NULL,'2023-11-13 19:47:54','2023-11-13 19:47:54'),(1376,'default','added',824,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-13 19:53:40','2023-11-13 19:53:40'),(1377,'default','added',825,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4600}}',NULL,'2023-11-13 20:01:37','2023-11-13 20:01:37'),(1378,'default','added',826,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 20:08:21','2023-11-13 20:08:21'),(1379,'default','added',827,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-13 20:10:06','2023-11-13 20:10:06'),(1380,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 20:10:44','2023-11-13 20:10:44'),(1381,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:10:56','2023-11-13 20:10:56'),(1382,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:11:16','2023-11-13 20:11:16'),(1383,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:11:29','2023-11-13 20:11:29'),(1384,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-13 20:11:40','2023-11-13 20:11:40'),(1385,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 20:14:57','2023-11-13 20:14:57'),(1386,'default','added',828,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-13 20:15:36','2023-11-13 20:15:36'),(1387,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-13 20:16:06','2023-11-13 20:16:06'),(1388,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 10:18:41','2023-11-14 10:18:41'),(1389,'default','added',829,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12259.97999999999956344254314899444580078125}}',NULL,'2023-11-14 10:22:55','2023-11-14 10:22:55'),(1390,'default','added',830,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3930}}',NULL,'2023-11-14 10:24:14','2023-11-14 10:24:14'),(1391,'default','added',831,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11500}}',NULL,'2023-11-14 10:26:14','2023-11-14 10:26:14'),(1392,'default','added',832,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-14 10:26:49','2023-11-14 10:26:49'),(1393,'default','added',833,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-14 10:32:41','2023-11-14 10:32:41'),(1394,'default','added',834,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-14 10:35:19','2023-11-14 10:35:19'),(1395,'default','payment_edited',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"}}',NULL,'2023-11-14 10:46:35','2023-11-14 10:46:35'),(1396,'default','payment_edited',720,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-11-14 10:46:54','2023-11-14 10:46:54'),(1397,'default','payment_edited',432,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1398,'default','payment_edited',495,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1399,'default','payment_edited',528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1400,'default','added',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":21210}}',NULL,'2023-11-14 10:51:22','2023-11-14 10:51:22'),(1401,'default','added',836,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-14 10:53:53','2023-11-14 10:53:53'),(1402,'default','added',837,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-14 11:05:44','2023-11-14 11:05:44'),(1403,'default','payment_edited',816,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-14 11:32:04','2023-11-14 11:32:04'),(1404,'default','added',838,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4650}}',NULL,'2023-11-14 12:19:48','2023-11-14 12:19:48'),(1405,'default','added',839,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-14 12:34:22','2023-11-14 12:34:22'),(1406,'default','added',840,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-14 12:36:22','2023-11-14 12:36:22'),(1407,'default','added',841,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":28340}}',NULL,'2023-11-14 12:46:28','2023-11-14 12:46:28'),(1408,'default','added',842,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7420}}',NULL,'2023-11-14 13:22:02','2023-11-14 13:22:02'),(1409,'default','added',843,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-11-14 13:23:24','2023-11-14 13:23:24'),(1410,'default','added',844,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-14 13:24:34','2023-11-14 13:24:34'),(1411,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 13:40:31','2023-11-14 13:40:31'),(1412,'default','added',845,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-14 13:40:53','2023-11-14 13:40:53'),(1413,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-14 13:51:04','2023-11-14 13:51:04'),(1414,'default','added',846,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1770}}',NULL,'2023-11-14 13:56:37','2023-11-14 13:56:37'),(1415,'default','added',847,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-11-14 13:59:01','2023-11-14 13:59:01'),(1416,'default','added',848,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2023-11-14 14:00:17','2023-11-14 14:00:17'),(1417,'default','added',849,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-14 14:02:00','2023-11-14 14:02:00'),(1418,'default','added',850,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-14 14:12:38','2023-11-14 14:12:38'),(1419,'default','added',851,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 14:16:53','2023-11-14 14:16:53'),(1420,'default','added',852,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4650}}',NULL,'2023-11-14 14:24:38','2023-11-14 14:24:38'),(1421,'default','added',853,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1775}}',NULL,'2023-11-14 14:54:05','2023-11-14 14:54:05'),(1422,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 17:40:07','2023-11-14 17:40:07'),(1423,'default','added',854,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1525}}',NULL,'2023-11-14 17:43:29','2023-11-14 17:43:29'),(1424,'default','added',855,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":128320}}',NULL,'2023-11-14 17:46:52','2023-11-14 17:46:52'),(1425,'default','added',856,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 17:48:53','2023-11-14 17:48:53'),(1426,'default','added',857,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26160}}',NULL,'2023-11-14 17:53:44','2023-11-14 17:53:44'),(1427,'default','added',858,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22500}}',NULL,'2023-11-14 17:57:38','2023-11-14 17:57:38'),(1428,'default','added',859,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3639.510000000000218278728425502777099609375}}',NULL,'2023-11-14 17:58:25','2023-11-14 17:58:25'),(1429,'default','added',860,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6000}}',NULL,'2023-11-14 18:01:16','2023-11-14 18:01:16'),(1430,'default','added',861,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-11-14 18:07:15','2023-11-14 18:07:15'),(1431,'default','added',862,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2930}}',NULL,'2023-11-14 18:09:36','2023-11-14 18:09:36'),(1432,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 18:23:10','2023-11-14 18:23:10'),(1433,'default','added',863,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3180}}',NULL,'2023-11-14 18:25:47','2023-11-14 18:25:47'),(1434,'default','added',89,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 18:28:59','2023-11-14 18:28:59'),(1435,'default','added',864,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-14 18:29:39','2023-11-14 18:29:39'),(1436,'default','added',865,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-11-14 18:30:23','2023-11-14 18:30:23'),(1437,'default','added',866,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-11-14 18:32:52','2023-11-14 18:32:52'),(1438,'default','added',867,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-14 18:45:45','2023-11-14 18:45:45'),(1439,'default','added',868,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-14 18:48:55','2023-11-14 18:48:55'),(1440,'default','added',869,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-14 18:50:29','2023-11-14 18:50:29'),(1441,'default','added',870,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-11-14 19:36:46','2023-11-14 19:36:46'),(1442,'default','added',90,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 19:45:26','2023-11-14 19:45:26'),(1443,'default','added',871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":200000}}',NULL,'2023-11-14 19:49:38','2023-11-14 19:49:38'),(1444,'default','added',872,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-14 20:08:38','2023-11-14 20:08:38'),(1445,'default','added',873,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 20:15:27','2023-11-14 20:15:27'),(1446,'default','added',874,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-14 20:15:53','2023-11-14 20:15:53'),(1447,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 20:15:58','2023-11-14 20:15:58'),(1448,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-14 22:16:24','2023-11-14 22:16:24'),(1449,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 10:18:10','2023-11-15 10:18:10'),(1450,'default','payment_edited',865,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-15 10:20:37','2023-11-15 10:20:37'),(1451,'default','payment_edited',749,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-15 10:21:18','2023-11-15 10:21:18'),(1452,'default','payment_edited',528,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 10:21:45','2023-11-15 10:21:45'),(1453,'default','payment_edited',555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 10:21:45','2023-11-15 10:21:45'),(1454,'default','added',875,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-15 10:27:50','2023-11-15 10:27:50'),(1455,'default','added',876,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-15 10:29:46','2023-11-15 10:29:46'),(1456,'default','added',877,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2730}}',NULL,'2023-11-15 10:31:23','2023-11-15 10:31:23'),(1457,'default','added',878,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15600}}',NULL,'2023-11-15 10:35:53','2023-11-15 10:35:53'),(1458,'default','added',879,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-15 10:38:37','2023-11-15 10:38:37'),(1459,'default','added',880,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-15 10:40:45','2023-11-15 10:40:45'),(1460,'default','added',881,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-15 10:49:01','2023-11-15 10:49:01'),(1461,'default','added',882,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-11-15 10:50:07','2023-11-15 10:50:07'),(1462,'default','added',883,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-15 10:51:25','2023-11-15 10:51:25'),(1463,'default','added',884,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17030}}',NULL,'2023-11-15 10:55:53','2023-11-15 10:55:53'),(1464,'default','edited',871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":200000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"200000.0000\"}}',NULL,'2023-11-15 11:05:24','2023-11-15 11:05:24'),(1465,'default','edited',871,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":200000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"200000.0000\"}}',NULL,'2023-11-15 11:12:32','2023-11-15 11:12:32'),(1466,'default','added',885,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":43371.330000000001746229827404022216796875}}',NULL,'2023-11-15 11:18:45','2023-11-15 11:18:45'),(1467,'default','added',886,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-15 11:21:21','2023-11-15 11:21:21'),(1468,'default','added',887,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2970}}',NULL,'2023-11-15 11:24:15','2023-11-15 11:24:15'),(1469,'default','added',888,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-15 12:16:10','2023-11-15 12:16:10'),(1470,'default','payment_edited',814,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-15 12:21:17','2023-11-15 12:21:17'),(1471,'default','payment_edited',854,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1525.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1525.0000\"}}',NULL,'2023-11-15 12:21:17','2023-11-15 12:21:17'),(1472,'default','added',889,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4300}}',NULL,'2023-11-15 12:24:47','2023-11-15 12:24:47'),(1473,'default','added',890,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-15 12:25:39','2023-11-15 12:25:39'),(1474,'default','added',891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-11-15 12:26:41','2023-11-15 12:26:41'),(1475,'default','edited',891,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-15 12:27:13','2023-11-15 12:27:13'),(1476,'default','added',892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6500}}',NULL,'2023-11-15 12:29:43','2023-11-15 12:29:43'),(1477,'default','added',893,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5960}}',NULL,'2023-11-15 12:35:23','2023-11-15 12:35:23'),(1478,'default','added',894,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-15 12:41:34','2023-11-15 12:41:34'),(1479,'default','added',895,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3070}}',NULL,'2023-11-15 12:49:14','2023-11-15 12:49:14'),(1480,'default','added',896,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-15 12:50:06','2023-11-15 12:50:06'),(1481,'default','payment_edited',555,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1482,'default','payment_edited',594,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1483,'default','payment_edited',633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1484,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 13:33:55','2023-11-15 13:33:55'),(1485,'default','added',897,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5050}}',NULL,'2023-11-15 14:00:53','2023-11-15 14:00:53'),(1486,'default','added',898,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7860}}',NULL,'2023-11-15 14:01:54','2023-11-15 14:01:54'),(1487,'default','added',899,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":50195}}',NULL,'2023-11-15 14:12:47','2023-11-15 14:12:47'),(1488,'default','added',900,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-15 14:13:15','2023-11-15 14:13:15'),(1489,'default','added',901,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-11-15 14:15:39','2023-11-15 14:15:39'),(1490,'default','added',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":551500}}',NULL,'2023-11-15 14:21:46','2023-11-15 14:21:46'),(1491,'default','added',903,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-11-15 14:22:19','2023-11-15 14:22:19'),(1492,'default','added',904,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2023-11-15 14:45:46','2023-11-15 14:45:46'),(1493,'default','added',905,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-15 14:52:00','2023-11-15 14:52:00'),(1494,'default','added',906,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-11-15 14:55:33','2023-11-15 14:55:33'),(1495,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 16:54:03','2023-11-15 16:54:03'),(1496,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 17:04:22','2023-11-15 17:04:22'),(1497,'default','payment_edited',96,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1498,'default','payment_edited',122,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5700.0000\"}}',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1499,'default','payment_edited',179,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1500,'default','payment_edited',423,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1501,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-15 17:32:39','2023-11-15 17:32:39'),(1502,'default','added',907,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-15 17:34:12','2023-11-15 17:34:12'),(1503,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 17:36:50','2023-11-15 17:36:50'),(1504,'default','added',908,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10630}}',NULL,'2023-11-15 18:05:21','2023-11-15 18:05:21'),(1505,'default','added',909,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14400}}',NULL,'2023-11-15 18:07:02','2023-11-15 18:07:02'),(1506,'default','added',910,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-15 18:26:39','2023-11-15 18:26:39'),(1507,'default','added',911,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-15 18:36:07','2023-11-15 18:36:07'),(1508,'default','added',912,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2023-11-15 18:37:21','2023-11-15 18:37:21'),(1509,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 18:39:22','2023-11-15 18:39:22'),(1510,'default','added',913,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-15 18:40:57','2023-11-15 18:40:57'),(1511,'default','payment_edited',408,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-11-15 18:45:42','2023-11-15 18:45:42'),(1512,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-15 19:19:36','2023-11-15 19:19:36'),(1513,'default','added',914,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-15 19:24:24','2023-11-15 19:24:24'),(1514,'default','payment_edited',322,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-11-15 19:41:39','2023-11-15 19:41:39'),(1515,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 19:49:46','2023-11-15 19:49:46'),(1516,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-15 19:53:30','2023-11-15 19:53:30'),(1517,'default','payment_edited',757,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2950.0000\"}}',NULL,'2023-11-15 19:53:59','2023-11-15 19:53:59'),(1518,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 11:08:30','2023-11-16 11:08:30'),(1519,'default','added',915,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6450}}',NULL,'2023-11-16 11:09:38','2023-11-16 11:09:38'),(1520,'default','payment_edited',60,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"392040.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"392040.0000\"}}',NULL,'2023-11-16 11:19:53','2023-11-16 11:19:53'),(1521,'default','payment_edited',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"551500.0000\"}}',NULL,'2023-11-16 11:19:53','2023-11-16 11:19:53'),(1522,'default','added',916,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-16 11:21:13','2023-11-16 11:21:13'),(1523,'default','added',917,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-16 11:21:45','2023-11-16 11:21:45'),(1524,'default','payment_edited',805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-16 11:25:05','2023-11-16 11:25:05'),(1525,'default','payment_edited',364,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12670.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12670.0000\"}}',NULL,'2023-11-16 11:31:43','2023-11-16 11:31:43'),(1526,'default','payment_edited',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7180.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7180.0000\"}}',NULL,'2023-11-16 11:31:43','2023-11-16 11:31:43'),(1527,'default','payment_edited',429,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7180.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7180.0000\"}}',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1528,'default','payment_edited',497,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5900.0000\"}}',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1529,'default','payment_edited',538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1530,'default','payment_edited',882,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-11-16 11:32:30','2023-11-16 11:32:30'),(1531,'default','added',918,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-16 11:33:36','2023-11-16 11:33:36'),(1532,'default','added',919,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-11-16 11:52:28','2023-11-16 11:52:28'),(1533,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-16 12:00:01','2023-11-16 12:00:01'),(1534,'default','payment_edited',855,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"128320.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"128320.0000\"}}',NULL,'2023-11-16 12:00:43','2023-11-16 12:00:43'),(1535,'default','added',920,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18450}}',NULL,'2023-11-16 12:09:23','2023-11-16 12:09:23'),(1536,'default','added',91,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 12:10:32','2023-11-16 12:10:32'),(1537,'default','added',921,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-11-16 12:10:56','2023-11-16 12:10:56'),(1538,'default','added',922,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13350}}',NULL,'2023-11-16 12:13:13','2023-11-16 12:13:13'),(1539,'default','added',923,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34500}}',NULL,'2023-11-16 12:14:37','2023-11-16 12:14:37'),(1540,'default','added',924,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13400}}',NULL,'2023-11-16 12:16:45','2023-11-16 12:16:45'),(1541,'default','added',925,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-16 12:17:27','2023-11-16 12:17:27'),(1542,'default','added',926,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-16 12:18:10','2023-11-16 12:18:10'),(1543,'default','added',927,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-16 12:29:03','2023-11-16 12:29:03'),(1544,'default','added',92,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 12:31:42','2023-11-16 12:31:42'),(1545,'default','added',928,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":54900}}',NULL,'2023-11-16 12:32:41','2023-11-16 12:32:41'),(1546,'default','added',929,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-16 12:53:33','2023-11-16 12:53:33'),(1547,'default','added',930,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10270}}',NULL,'2023-11-16 13:24:12','2023-11-16 13:24:12'),(1548,'default','payment_edited',50,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 13:39:10','2023-11-16 13:39:10'),(1549,'default','added',931,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-16 13:46:12','2023-11-16 13:46:12'),(1550,'default','added',932,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500}}',NULL,'2023-11-16 13:58:46','2023-11-16 13:58:46'),(1551,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 16:58:32','2023-11-16 16:58:32'),(1552,'default','payment_edited',694,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2700.0000\"}}',NULL,'2023-11-16 16:59:56','2023-11-16 16:59:56'),(1553,'default','added',933,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 17:01:40','2023-11-16 17:01:40'),(1554,'default','added',934,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-16 17:04:10','2023-11-16 17:04:10'),(1555,'default','added',935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":87210}}',NULL,'2023-11-16 17:06:52','2023-11-16 17:06:52'),(1556,'default','added',936,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 17:07:22','2023-11-16 17:07:22'),(1557,'default','added',93,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 17:10:29','2023-11-16 17:10:29'),(1558,'default','added',937,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-16 17:11:03','2023-11-16 17:11:03'),(1559,'default','added',938,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6000}}',NULL,'2023-11-16 17:11:37','2023-11-16 17:11:37'),(1560,'default','added',939,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15600}}',NULL,'2023-11-16 17:12:27','2023-11-16 17:12:27'),(1561,'default','added',940,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-16 17:13:00','2023-11-16 17:13:00'),(1562,'default','added',941,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10350}}',NULL,'2023-11-16 17:14:29','2023-11-16 17:14:29'),(1563,'default','added',942,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-16 17:15:00','2023-11-16 17:15:00'),(1564,'default','payment_edited',815,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"34160.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"34160.0000\"}}',NULL,'2023-11-16 17:16:00','2023-11-16 17:16:00'),(1565,'default','payment_edited',935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87210.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"87210.0000\"}}',NULL,'2023-11-16 17:16:00','2023-11-16 17:16:00'),(1566,'default','added',943,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 17:18:25','2023-11-16 17:18:25'),(1567,'default','added',944,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-16 17:21:37','2023-11-16 17:21:37'),(1568,'default','added',945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-16 17:28:02','2023-11-16 17:28:02'),(1569,'default','edited',945,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-16 17:33:07','2023-11-16 17:33:07'),(1570,'default','added',946,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-16 17:49:36','2023-11-16 17:49:36'),(1571,'default','added',947,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2023-11-16 18:02:49','2023-11-16 18:02:49'),(1572,'default','added',948,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 18:06:23','2023-11-16 18:06:23'),(1573,'default','added',949,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-16 18:14:57','2023-11-16 18:14:57'),(1574,'default','added',950,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-16 18:24:49','2023-11-16 18:24:49'),(1575,'default','added',951,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5550}}',NULL,'2023-11-16 18:33:54','2023-11-16 18:33:54'),(1576,'default','added',952,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1750}}',NULL,'2023-11-16 18:35:40','2023-11-16 18:35:40'),(1577,'default','payment_edited',952,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1750.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1750.0000\"}}',NULL,'2023-11-16 18:36:33','2023-11-16 18:36:33'),(1578,'default','added',953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1500}}',NULL,'2023-11-16 18:41:18','2023-11-16 18:41:18'),(1579,'default','payment_edited',953,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-16 18:41:39','2023-11-16 18:41:39'),(1580,'default','added',954,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-16 19:17:13','2023-11-16 19:17:13'),(1581,'default','added',955,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":33000}}',NULL,'2023-11-16 19:19:37','2023-11-16 19:19:37'),(1582,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:22:32','2023-11-16 19:22:32'),(1583,'default','added',956,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-16 19:29:02','2023-11-16 19:29:02'),(1584,'default','added',957,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-16 19:34:30','2023-11-16 19:34:30'),(1585,'default','added',958,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-16 19:41:12','2023-11-16 19:41:12'),(1586,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:47:30','2023-11-16 19:47:30'),(1587,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:48:08','2023-11-16 19:48:08'),(1588,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 19:49:41','2023-11-16 19:49:41'),(1589,'default','added',959,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-16 19:53:39','2023-11-16 19:53:39'),(1590,'default','added',960,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-16 19:59:42','2023-11-16 19:59:42'),(1591,'default','added',961,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:00:16','2023-11-16 20:00:16'),(1592,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 20:02:50','2023-11-16 20:02:50'),(1593,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 20:04:46','2023-11-16 20:04:46'),(1594,'default','added',962,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:05:45','2023-11-16 20:05:45'),(1595,'default','added',963,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:06:19','2023-11-16 20:06:19'),(1596,'default','added',964,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:06:38','2023-11-16 20:06:38'),(1597,'default','added',965,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-16 20:07:12','2023-11-16 20:07:12'),(1598,'default','added',966,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-16 20:09:08','2023-11-16 20:09:08'),(1599,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-16 20:09:39','2023-11-16 20:09:39'),(1600,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 14:43:11','2023-11-18 14:43:11'),(1601,'default','added',967,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 14:45:02','2023-11-18 14:45:02'),(1602,'default','added',968,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 14:45:59','2023-11-18 14:45:59'),(1603,'default','added',969,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 14:46:28','2023-11-18 14:46:28'),(1604,'default','payment_edited',938,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6000.0000\"}}',NULL,'2023-11-18 14:46:56','2023-11-18 14:46:56'),(1605,'default','payment_edited',932,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}',NULL,'2023-11-18 14:47:14','2023-11-18 14:47:14'),(1606,'default','payment_edited',633,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-18 14:47:33','2023-11-18 14:47:33'),(1607,'default','payment_edited',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-18 14:47:33','2023-11-18 14:47:33'),(1608,'default','payment_edited',538,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-18 14:47:55','2023-11-18 14:47:55'),(1609,'default','payment_edited',614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7650.0000\"}}',NULL,'2023-11-18 14:47:55','2023-11-18 14:47:55'),(1610,'default','added',970,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-18 14:49:37','2023-11-18 14:49:37'),(1611,'default','added',971,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9660}}',NULL,'2023-11-18 14:50:59','2023-11-18 14:50:59'),(1612,'default','added',972,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21010}}',NULL,'2023-11-18 14:53:38','2023-11-18 14:53:38'),(1613,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 14:55:31','2023-11-18 14:55:31'),(1614,'default','added',973,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20120}}',NULL,'2023-11-18 14:59:46','2023-11-18 14:59:46'),(1615,'default','added',974,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2750}}',NULL,'2023-11-18 15:01:58','2023-11-18 15:01:58'),(1616,'default','payment_edited',974,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-11-18 15:02:19','2023-11-18 15:02:19'),(1617,'default','added',975,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":41080}}',NULL,'2023-11-18 15:05:41','2023-11-18 15:05:41'),(1618,'default','added',976,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200}}',NULL,'2023-11-18 15:06:13','2023-11-18 15:06:13'),(1619,'default','added',977,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18650}}',NULL,'2023-11-18 15:08:48','2023-11-18 15:08:48'),(1620,'default','added',978,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9680}}',NULL,'2023-11-18 15:14:54','2023-11-18 15:14:54'),(1621,'default','edited',978,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9680.0000\"}}',NULL,'2023-11-18 15:16:38','2023-11-18 15:16:38'),(1622,'default','added',979,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8030}}',NULL,'2023-11-18 15:17:51','2023-11-18 15:17:51'),(1623,'default','added',980,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18230}}',NULL,'2023-11-18 15:19:55','2023-11-18 15:19:55'),(1624,'default','added',981,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10950}}',NULL,'2023-11-18 15:22:47','2023-11-18 15:22:47'),(1625,'default','added',982,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-18 15:23:27','2023-11-18 15:23:27'),(1626,'default','added',983,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-11-18 15:45:08','2023-11-18 15:45:08'),(1627,'default','added',984,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-18 15:46:48','2023-11-18 15:46:48'),(1628,'default','added',985,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":3400}}',NULL,'2023-11-18 15:49:05','2023-11-18 15:49:05'),(1629,'default','payment_edited',985,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-18 15:49:46','2023-11-18 15:49:46'),(1630,'default','added',986,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-18 15:50:06','2023-11-18 15:50:06'),(1631,'default','added',987,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1780}}',NULL,'2023-11-18 15:50:32','2023-11-18 15:50:32'),(1632,'default','added',988,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-18 15:53:50','2023-11-18 15:53:50'),(1633,'default','added',989,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-11-18 15:56:09','2023-11-18 15:56:09'),(1634,'default','added',990,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-18 15:57:54','2023-11-18 15:57:54'),(1635,'default','added',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":145350}}',NULL,'2023-11-18 16:08:36','2023-11-18 16:08:36'),(1636,'default','added',992,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-18 16:17:36','2023-11-18 16:17:36'),(1637,'default','added',993,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-11-18 16:26:44','2023-11-18 16:26:44'),(1638,'default','added',994,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-11-18 16:59:44','2023-11-18 16:59:44'),(1639,'default','added',995,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-18 17:34:54','2023-11-18 17:34:54'),(1640,'default','added',996,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3180}}',NULL,'2023-11-18 17:44:02','2023-11-18 17:44:02'),(1641,'default','added',997,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-18 17:50:52','2023-11-18 17:50:52'),(1642,'default','added',998,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-18 18:00:15','2023-11-18 18:00:15'),(1643,'default','added',999,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1630}}',NULL,'2023-11-18 18:04:28','2023-11-18 18:04:28'),(1644,'default','added',1000,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-18 18:15:24','2023-11-18 18:15:24'),(1645,'default','added',1001,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-18 18:16:44','2023-11-18 18:16:44'),(1646,'default','added',1002,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-18 18:20:29','2023-11-18 18:20:29'),(1647,'default','added',1003,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-18 18:38:08','2023-11-18 18:38:08'),(1648,'default','added',1004,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-18 18:41:56','2023-11-18 18:41:56'),(1649,'default','added',1005,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-18 18:44:58','2023-11-18 18:44:58'),(1650,'default','added',1006,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-18 18:48:25','2023-11-18 18:48:25'),(1651,'default','added',1007,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-18 18:48:45','2023-11-18 18:48:45'),(1652,'default','added',1008,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1430}}',NULL,'2023-11-18 19:15:09','2023-11-18 19:15:09'),(1653,'default','added',1009,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-18 19:18:34','2023-11-18 19:18:34'),(1654,'default','added',1010,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3170}}',NULL,'2023-11-18 19:20:16','2023-11-18 19:20:16'),(1655,'default','added',1011,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-18 19:34:29','2023-11-18 19:34:29'),(1656,'default','added',1012,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-18 19:36:17','2023-11-18 19:36:17'),(1657,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 19:42:41','2023-11-18 19:42:41'),(1658,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 19:42:45','2023-11-18 19:42:45'),(1659,'default','added',1013,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-18 19:43:16','2023-11-18 19:43:16'),(1660,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-18 19:43:37','2023-11-18 19:43:37'),(1661,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 00:30:32','2023-11-19 00:30:32'),(1662,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 10:54:07','2023-11-19 10:54:07'),(1663,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 12:33:35','2023-11-19 12:33:35'),(1664,'default','payment_edited',628,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"581400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"581400.0000\"}}',NULL,'2023-11-19 12:36:48','2023-11-19 12:36:48'),(1665,'default','payment_edited',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"145350.0000\"}}',NULL,'2023-11-19 12:36:48','2023-11-19 12:36:48'),(1666,'default','payment_edited',935,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87210.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"87210.0000\"}}',NULL,'2023-11-19 12:37:01','2023-11-19 12:37:01'),(1667,'default','payment_edited',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-19 12:37:32','2023-11-19 12:37:32'),(1668,'default','payment_edited',614,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7650.0000\"}}',NULL,'2023-11-19 12:39:03','2023-11-19 12:39:03'),(1669,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-19 12:39:03','2023-11-19 12:39:03'),(1670,'default','added',1014,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600}}',NULL,'2023-11-19 12:41:58','2023-11-19 12:41:58'),(1671,'default','added',1015,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16400}}',NULL,'2023-11-19 12:47:03','2023-11-19 12:47:03'),(1672,'default','added',1016,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":26973}}',NULL,'2023-11-19 12:48:35','2023-11-19 12:48:35'),(1673,'default','added',1017,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-19 12:49:09','2023-11-19 12:49:09'),(1674,'default','added',1018,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21130}}',NULL,'2023-11-19 12:53:40','2023-11-19 12:53:40'),(1675,'default','added',1019,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-19 12:54:06','2023-11-19 12:54:06'),(1676,'default','added',1020,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12550}}',NULL,'2023-11-19 13:16:47','2023-11-19 13:16:47'),(1677,'default','added',1021,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8260}}',NULL,'2023-11-19 13:17:32','2023-11-19 13:17:32'),(1678,'default','added',1022,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8600}}',NULL,'2023-11-19 13:18:38','2023-11-19 13:18:38'),(1679,'default','added',1023,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7400}}',NULL,'2023-11-19 13:20:19','2023-11-19 13:20:19'),(1680,'default','added',1024,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":142500}}',NULL,'2023-11-19 13:21:35','2023-11-19 13:21:35'),(1681,'default','added',1025,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-19 13:24:05','2023-11-19 13:24:05'),(1682,'default','added',1026,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-19 13:31:38','2023-11-19 13:31:38'),(1683,'default','added',1027,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-19 13:41:07','2023-11-19 13:41:07'),(1684,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-19 16:58:20','2023-11-19 16:58:20'),(1685,'default','added',1028,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-19 17:01:12','2023-11-19 17:01:12'),(1686,'default','added',1029,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-19 17:12:21','2023-11-19 17:12:21'),(1687,'default','added',1030,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15250}}',NULL,'2023-11-19 17:14:31','2023-11-19 17:14:31'),(1688,'default','added',1031,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-19 17:18:20','2023-11-19 17:18:20'),(1689,'default','added',1032,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11050}}',NULL,'2023-11-19 17:20:50','2023-11-19 17:20:50'),(1690,'default','added',1033,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":2850}}',NULL,'2023-11-19 17:25:44','2023-11-19 17:25:44'),(1691,'default','payment_edited',1033,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2850.0000\"}}',NULL,'2023-11-19 17:26:26','2023-11-19 17:26:26'),(1692,'default','added',1034,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-19 17:30:49','2023-11-19 17:30:49'),(1693,'default','payment_edited',697,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"114120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"114120.0000\"}}',NULL,'2023-11-19 18:00:54','2023-11-19 18:00:54'),(1694,'default','added',1035,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-19 18:01:32','2023-11-19 18:01:32'),(1695,'default','added',1036,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-19 18:05:21','2023-11-19 18:05:21'),(1696,'default','added',1037,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-11-19 18:32:55','2023-11-19 18:32:55'),(1697,'default','added',1038,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10350}}',NULL,'2023-11-19 18:42:04','2023-11-19 18:42:04'),(1698,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 10:41:05','2023-11-20 10:41:05'),(1699,'default','payment_edited',681,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1700,'default','payment_edited',695,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1701,'default','payment_edited',761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1702,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-20 10:42:54','2023-11-20 10:42:54'),(1703,'default','payment_edited',472,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"111100.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"111100.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1704,'default','payment_edited',600,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"45547.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"45547.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1705,'default','payment_edited',715,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"31590.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"31590.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1706,'default','payment_edited',811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"86310.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"86310.0000\"}}',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1707,'default','payment_edited',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"}}',NULL,'2023-11-20 10:44:54','2023-11-20 10:44:54'),(1708,'default','added',1039,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-11-20 10:46:35','2023-11-20 10:46:35'),(1709,'default','added',1040,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16720}}',NULL,'2023-11-20 10:52:08','2023-11-20 10:52:08'),(1710,'default','added',1041,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-20 10:54:31','2023-11-20 10:54:31'),(1711,'default','added',1042,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-20 10:55:52','2023-11-20 10:55:52'),(1712,'default','added',1043,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9050}}',NULL,'2023-11-20 10:59:13','2023-11-20 10:59:13'),(1713,'default','added',1044,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29860}}',NULL,'2023-11-20 11:01:14','2023-11-20 11:01:14'),(1714,'default','added',1045,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1640}}',NULL,'2023-11-20 11:03:40','2023-11-20 11:03:40'),(1715,'default','added',1046,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 11:06:03','2023-11-20 11:06:03'),(1716,'default','added',1047,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1830}}',NULL,'2023-11-20 11:06:41','2023-11-20 11:06:41'),(1717,'default','added',1048,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-20 11:12:09','2023-11-20 11:12:09'),(1718,'default','added',1049,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":36080}}',NULL,'2023-11-20 11:33:30','2023-11-20 11:33:30'),(1719,'default','added',1050,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-11-20 11:35:34','2023-11-20 11:35:34'),(1720,'default','added',1051,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-20 11:39:50','2023-11-20 11:39:50'),(1721,'default','edited',1051,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"}}',NULL,'2023-11-20 11:44:38','2023-11-20 11:44:38'),(1722,'default','added',1052,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-20 11:58:35','2023-11-20 11:58:35'),(1723,'default','added',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5800000}}',NULL,'2023-11-20 12:04:51','2023-11-20 12:04:51'),(1724,'default','added',1054,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-20 12:15:20','2023-11-20 12:15:20'),(1725,'default','added',1055,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 12:19:28','2023-11-20 12:19:28'),(1726,'default','added',1056,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 12:19:46','2023-11-20 12:19:46'),(1727,'default','edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":580000},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5800000.0000\"}}',NULL,'2023-11-20 12:22:55','2023-11-20 12:22:55'),(1728,'default','added',1057,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-20 12:37:31','2023-11-20 12:37:31'),(1729,'default','added',1058,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-20 13:24:48','2023-11-20 13:24:48'),(1730,'default','added',1059,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 13:25:40','2023-11-20 13:25:40'),(1731,'default','added',1060,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-11-20 13:29:24','2023-11-20 13:29:24'),(1732,'default','added',1061,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-20 13:31:50','2023-11-20 13:31:50'),(1733,'default','added',1062,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-20 13:32:08','2023-11-20 13:32:08'),(1734,'default','added',1063,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-20 13:58:58','2023-11-20 13:58:58'),(1735,'default','added',1064,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-20 14:11:16','2023-11-20 14:11:16'),(1736,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 14:48:11','2023-11-20 14:48:11'),(1737,'default','payment_edited',890,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-20 14:52:56','2023-11-20 14:52:56'),(1738,'default','added',1065,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-20 14:53:59','2023-11-20 14:53:59'),(1739,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 17:18:24','2023-11-20 17:18:24'),(1740,'default','added',1066,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":38798.5}}',NULL,'2023-11-20 17:34:09','2023-11-20 17:34:09'),(1741,'default','added',1067,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1650}}',NULL,'2023-11-20 17:35:26','2023-11-20 17:35:26'),(1742,'default','added',1068,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5780}}',NULL,'2023-11-20 17:36:55','2023-11-20 17:36:55'),(1743,'default','added',1069,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-11-20 17:55:46','2023-11-20 17:55:46'),(1744,'default','added',1070,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-20 18:08:28','2023-11-20 18:08:28'),(1745,'default','added',1071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-20 18:20:49','2023-11-20 18:20:49'),(1746,'default','added',1072,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-20 18:27:12','2023-11-20 18:27:12'),(1747,'default','added',1073,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6050}}',NULL,'2023-11-20 18:49:18','2023-11-20 18:49:18'),(1748,'default','added',1074,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-20 19:07:11','2023-11-20 19:07:11'),(1749,'default','edited',1071,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3840},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"}}',NULL,'2023-11-20 19:10:31','2023-11-20 19:10:31'),(1750,'default','added',1075,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-20 19:12:09','2023-11-20 19:12:09'),(1751,'default','added',1076,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1320}}',NULL,'2023-11-20 19:29:56','2023-11-20 19:29:56'),(1752,'default','added',1077,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-20 19:49:04','2023-11-20 19:49:04'),(1753,'default','payment_edited',490,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"51800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"51800.0000\"}}',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1754,'default','payment_edited',632,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"64500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"64500.0000\"}}',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1755,'default','payment_edited',716,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"207615.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"207615.0000\"}}',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1756,'default','added',1078,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-20 19:59:06','2023-11-20 19:59:06'),(1757,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-20 20:01:22','2023-11-20 20:01:22'),(1758,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 10:31:42','2023-11-21 10:31:42'),(1759,'default','added',1079,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 10:33:09','2023-11-21 10:33:09'),(1760,'default','payment_edited',606,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2480.0000\"}}',NULL,'2023-11-21 10:34:40','2023-11-21 10:34:40'),(1761,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-21 10:35:13','2023-11-21 10:35:13'),(1762,'default','added',1080,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14870}}',NULL,'2023-11-21 10:38:04','2023-11-21 10:38:04'),(1763,'default','added',1081,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9250}}',NULL,'2023-11-21 10:39:44','2023-11-21 10:39:44'),(1764,'default','added',1082,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12380}}',NULL,'2023-11-21 10:41:23','2023-11-21 10:41:23'),(1765,'default','added',1083,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4380}}',NULL,'2023-11-21 10:42:51','2023-11-21 10:42:51'),(1766,'default','edited',81,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 10:48:01','2023-11-21 10:48:01'),(1767,'default','added',1084,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-21 10:53:20','2023-11-21 10:53:20'),(1768,'default','added',94,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 11:09:43','2023-11-21 11:09:43'),(1769,'default','edited',94,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 11:10:53','2023-11-21 11:10:53'),(1770,'default','added',1085,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-11-21 11:13:27','2023-11-21 11:13:27'),(1771,'default','added',1086,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1940}}',NULL,'2023-11-21 11:22:16','2023-11-21 11:22:16'),(1772,'default','added',1087,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-21 11:24:40','2023-11-21 11:24:40'),(1773,'default','added',1088,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1700}}',NULL,'2023-11-21 11:26:13','2023-11-21 11:26:13'),(1774,'default','payment_edited',1088,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-11-21 11:26:35','2023-11-21 11:26:35'),(1775,'default','payment_edited',384,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"181120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"181120.0000\"}}',NULL,'2023-11-21 11:28:44','2023-11-21 11:28:44'),(1776,'default','payment_edited',1024,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"142500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"142500.0000\"}}',NULL,'2023-11-21 11:28:44','2023-11-21 11:28:44'),(1777,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 11:29:33','2023-11-21 11:29:33'),(1778,'default','payment_edited',484,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"242465.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"242465.0000\"}}',NULL,'2023-11-21 11:47:32','2023-11-21 11:47:32'),(1779,'default','added',1089,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 11:51:49','2023-11-21 11:51:49'),(1780,'default','payment_edited',928,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"54900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"54900.0000\"}}',NULL,'2023-11-21 13:29:40','2023-11-21 13:29:40'),(1781,'default','payment_edited',805,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"}}',NULL,'2023-11-21 13:29:59','2023-11-21 13:29:59'),(1782,'default','payment_edited',892,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6500.0000\"}}',NULL,'2023-11-21 13:29:59','2023-11-21 13:29:59'),(1783,'default','payment_edited',991,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"145350.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"145350.0000\"}}',NULL,'2023-11-21 13:34:25','2023-11-21 13:34:25'),(1784,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-21 13:34:25','2023-11-21 13:34:25'),(1785,'default','added',1090,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-21 13:40:50','2023-11-21 13:40:50'),(1786,'default','added',95,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 13:52:04','2023-11-21 13:52:04'),(1787,'default','added',1091,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2480}}',NULL,'2023-11-21 13:53:26','2023-11-21 13:53:26'),(1788,'default','added',1092,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-21 14:02:00','2023-11-21 14:02:00'),(1789,'default','added',1093,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-21 14:13:49','2023-11-21 14:13:49'),(1790,'default','added',1094,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2580}}',NULL,'2023-11-21 14:20:19','2023-11-21 14:20:19'),(1791,'default','added',1095,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11550}}',NULL,'2023-11-21 14:27:45','2023-11-21 14:27:45'),(1792,'default','added',1096,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7100}}',NULL,'2023-11-21 14:37:10','2023-11-21 14:37:10'),(1793,'default','added',1097,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29400}}',NULL,'2023-11-21 14:43:10','2023-11-21 14:43:10'),(1794,'default','added',1098,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-21 14:48:22','2023-11-21 14:48:22'),(1795,'default','added',1099,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5980}}',NULL,'2023-11-21 14:55:17','2023-11-21 14:55:17'),(1796,'default','added',1100,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-21 14:55:56','2023-11-21 14:55:56'),(1797,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 14:59:41','2023-11-21 14:59:41'),(1798,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 17:23:48','2023-11-21 17:23:48'),(1799,'default','contact_deleted',95,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 17:24:25','2023-11-21 17:24:25'),(1800,'default','added',96,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 17:26:14','2023-11-21 17:26:14'),(1801,'default','added',1101,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":175000}}',NULL,'2023-11-21 17:27:50','2023-11-21 17:27:50'),(1802,'default','added',1102,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-21 17:35:00','2023-11-21 17:35:00'),(1803,'default','added',1103,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12590}}',NULL,'2023-11-21 17:39:56','2023-11-21 17:39:56'),(1804,'default','added',1104,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20435}}',NULL,'2023-11-21 17:41:00','2023-11-21 17:41:00'),(1805,'default','added',1105,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3950}}',NULL,'2023-11-21 17:42:13','2023-11-21 17:42:13'),(1806,'default','added',1106,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20640}}',NULL,'2023-11-21 17:46:23','2023-11-21 17:46:23'),(1807,'default','added',1107,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-21 17:47:45','2023-11-21 17:47:45'),(1808,'default','added',1108,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-21 17:54:52','2023-11-21 17:54:52'),(1809,'default','added',1109,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 18:02:29','2023-11-21 18:02:29'),(1810,'default','added',1110,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-21 18:05:25','2023-11-21 18:05:25'),(1811,'default','added',1111,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 18:11:56','2023-11-21 18:11:56'),(1812,'default','added',1112,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-21 18:28:13','2023-11-21 18:28:13'),(1813,'default','added',1113,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3070}}',NULL,'2023-11-21 18:29:48','2023-11-21 18:29:48'),(1814,'default','added',1114,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-21 18:38:30','2023-11-21 18:38:30'),(1815,'default','added',1115,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10250}}',NULL,'2023-11-21 18:39:13','2023-11-21 18:39:13'),(1816,'default','added',1116,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":70000}}',NULL,'2023-11-21 18:47:52','2023-11-21 18:47:52'),(1817,'default','added',1117,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-11-21 19:27:20','2023-11-21 19:27:20'),(1818,'default','added',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"ordered\",\"payment_status\":\"due\",\"final_total\":251954}}',NULL,'2023-11-21 19:28:45','2023-11-21 19:28:45'),(1819,'default','added',1119,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-21 19:39:07','2023-11-21 19:39:07'),(1820,'default','payment_edited',131,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 19:40:05','2023-11-21 19:40:05'),(1821,'default','added',1120,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2470}}',NULL,'2023-11-21 19:46:46','2023-11-21 19:46:46'),(1822,'default','added',1121,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":44800}}',NULL,'2023-11-21 20:00:41','2023-11-21 20:00:41'),(1823,'default','added',1122,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-21 20:04:04','2023-11-21 20:04:04'),(1824,'default','added',1123,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":76230}}',NULL,'2023-11-21 20:07:12','2023-11-21 20:07:12'),(1825,'default','added',1124,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-21 20:16:26','2023-11-21 20:16:26'),(1826,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-21 20:16:58','2023-11-21 20:16:58'),(1827,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 10:28:22','2023-11-22 10:28:22'),(1828,'default','payment_edited',761,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-22 10:29:23','2023-11-22 10:29:23'),(1829,'default','payment_edited',806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-22 10:29:23','2023-11-22 10:29:23'),(1830,'default','payment_edited',685,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"15650.0000\"}}',NULL,'2023-11-22 10:29:50','2023-11-22 10:29:50'),(1831,'default','payment_edited',751,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3380.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3380.0000\"}}',NULL,'2023-11-22 10:29:50','2023-11-22 10:29:50'),(1832,'default','payment_edited',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"}}',NULL,'2023-11-22 10:29:50','2023-11-22 10:29:50'),(1833,'default','added',1125,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10190}}',NULL,'2023-11-22 10:32:18','2023-11-22 10:32:18'),(1834,'default','added',1126,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10010}}',NULL,'2023-11-22 10:34:32','2023-11-22 10:34:32'),(1835,'default','added',1127,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-11-22 10:35:03','2023-11-22 10:35:03'),(1836,'default','added',1128,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8100}}',NULL,'2023-11-22 10:39:48','2023-11-22 10:39:48'),(1837,'default','added',1129,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-22 10:45:47','2023-11-22 10:45:47'),(1838,'default','added',1130,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-11-22 10:52:10','2023-11-22 10:52:10'),(1839,'default','added',1131,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8550}}',NULL,'2023-11-22 10:55:11','2023-11-22 10:55:11'),(1840,'default','payment_edited',1127,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-11-22 10:56:37','2023-11-22 10:56:37'),(1841,'default','added',1132,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-22 10:58:25','2023-11-22 10:58:25'),(1842,'default','added',1133,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-22 11:09:23','2023-11-22 11:09:23'),(1843,'default','added',1134,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":164000}}',NULL,'2023-11-22 11:21:41','2023-11-22 11:21:41'),(1844,'default','added',97,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 11:34:33','2023-11-22 11:34:33'),(1845,'default','added',1135,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-11-22 11:35:24','2023-11-22 11:35:24'),(1846,'default','added',1136,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-22 11:38:23','2023-11-22 11:38:23'),(1847,'default','added',1137,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3280}}',NULL,'2023-11-22 11:41:32','2023-11-22 11:41:32'),(1848,'default','added',1138,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-22 11:42:04','2023-11-22 11:42:04'),(1849,'default','added',1139,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2190}}',NULL,'2023-11-22 12:16:50','2023-11-22 12:16:50'),(1850,'default','edited',97,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 12:17:49','2023-11-22 12:17:49'),(1851,'default','added',1140,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-22 12:34:40','2023-11-22 12:34:40'),(1852,'default','added',1141,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-22 12:43:38','2023-11-22 12:43:38'),(1853,'default','added',1142,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-22 12:44:29','2023-11-22 12:44:29'),(1854,'default','added',1143,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":28677}}',NULL,'2023-11-22 12:54:10','2023-11-22 12:54:10'),(1855,'default','payment_edited',714,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"37080.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"37080.0000\"}}',NULL,'2023-11-22 13:19:21','2023-11-22 13:19:21'),(1856,'default','payment_edited',1134,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"164000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"164000.0000\"}}',NULL,'2023-11-22 13:19:21','2023-11-22 13:19:21'),(1857,'default','added',1144,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-22 13:38:44','2023-11-22 13:38:44'),(1858,'default','added',1145,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2530}}',NULL,'2023-11-22 13:39:35','2023-11-22 13:39:35'),(1859,'default','added',98,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 13:41:09','2023-11-22 13:41:09'),(1860,'default','added',1146,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":42500}}',NULL,'2023-11-22 13:48:15','2023-11-22 13:48:15'),(1861,'default','added',1147,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-22 13:53:50','2023-11-22 13:53:50'),(1862,'default','added',1148,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4350}}',NULL,'2023-11-22 14:30:05','2023-11-22 14:30:05'),(1863,'default','added',1149,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":48815.25}}',NULL,'2023-11-22 14:35:02','2023-11-22 14:35:02'),(1864,'default','added',1150,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 14:37:18','2023-11-22 14:37:18'),(1865,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 17:18:09','2023-11-22 17:18:09'),(1866,'default','payment_edited',203,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 17:20:46','2023-11-22 17:20:46'),(1867,'default','added',1151,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3050}}',NULL,'2023-11-22 17:23:17','2023-11-22 17:23:17'),(1868,'default','added',1152,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10150}}',NULL,'2023-11-22 17:27:21','2023-11-22 17:27:21'),(1869,'default','added',1153,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-22 17:28:14','2023-11-22 17:28:14'),(1870,'default','edited',1153,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"}}',NULL,'2023-11-22 17:33:09','2023-11-22 17:33:09'),(1871,'default','sell_deleted',1153,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":1153,\"invoice_no\":\"0888\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"}}',NULL,'2023-11-22 17:36:14','2023-11-22 17:36:14'),(1872,'default','added',1154,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-22 17:37:55','2023-11-22 17:37:55'),(1873,'default','payment_edited',806,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-11-22 17:38:35','2023-11-22 17:38:35'),(1874,'default','added',1155,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-11-22 17:38:35','2023-11-22 17:38:35'),(1875,'default','added',1156,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9650}}',NULL,'2023-11-22 17:40:57','2023-11-22 17:40:57'),(1876,'default','added',1157,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 17:45:58','2023-11-22 17:45:58'),(1877,'default','added',1158,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-22 17:46:41','2023-11-22 17:46:41'),(1878,'default','added',1159,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34920}}',NULL,'2023-11-22 18:17:56','2023-11-22 18:17:56'),(1879,'default','added',1160,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-22 18:18:53','2023-11-22 18:18:53'),(1880,'default','added',1161,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-22 18:24:26','2023-11-22 18:24:26'),(1881,'default','added',1162,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-11-22 18:26:23','2023-11-22 18:26:23'),(1882,'default','added',1163,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 18:33:14','2023-11-22 18:33:14'),(1883,'default','added',1164,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 18:37:38','2023-11-22 18:37:38'),(1884,'default','added',1165,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-22 19:12:39','2023-11-22 19:12:39'),(1885,'default','added',1166,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-22 19:15:03','2023-11-22 19:15:03'),(1886,'default','added',1167,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-22 19:15:57','2023-11-22 19:15:57'),(1887,'default','added',1168,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-22 19:18:01','2023-11-22 19:18:01'),(1888,'default','added',1169,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-11-22 19:22:58','2023-11-22 19:22:58'),(1889,'default','added',1170,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-22 19:23:31','2023-11-22 19:23:31'),(1890,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-22 19:41:46','2023-11-22 19:41:46'),(1891,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 10:23:36','2023-11-23 10:23:36'),(1892,'default','payment_edited',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"}}',NULL,'2023-11-23 10:27:21','2023-11-23 10:27:21'),(1893,'default','added',1171,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-11-23 10:28:25','2023-11-23 10:28:25'),(1894,'default','added',1172,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15290}}',NULL,'2023-11-23 10:30:26','2023-11-23 10:30:26'),(1895,'default','payment_edited',983,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-11-23 10:37:57','2023-11-23 10:37:57'),(1896,'default','added',1173,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-11-23 10:43:34','2023-11-23 10:43:34'),(1897,'default','payment_edited',902,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"551500.0000\"}}',NULL,'2023-11-23 10:44:28','2023-11-23 10:44:28'),(1898,'default','added',1174,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-23 10:48:03','2023-11-23 10:48:03'),(1899,'default','added',1175,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-23 10:51:13','2023-11-23 10:51:13'),(1900,'default','added',1176,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-23 11:00:49','2023-11-23 11:00:49'),(1901,'default','added',1177,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10630}}',NULL,'2023-11-23 11:03:58','2023-11-23 11:03:58'),(1902,'default','added',1178,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12820}}',NULL,'2023-11-23 11:05:01','2023-11-23 11:05:01'),(1903,'default','added',1179,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":44355}}',NULL,'2023-11-23 11:07:16','2023-11-23 11:07:16'),(1904,'default','added',1180,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-23 11:15:18','2023-11-23 11:15:18'),(1905,'default','added',1181,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-23 11:27:51','2023-11-23 11:27:51'),(1906,'default','added',1182,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2023-11-23 11:40:33','2023-11-23 11:40:33'),(1907,'default','added',1183,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 11:41:25','2023-11-23 11:41:25'),(1908,'default','added',1184,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-11-23 11:44:00','2023-11-23 11:44:00'),(1909,'default','payment_edited',1053,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"580000.0000\"}}',NULL,'2023-11-23 12:01:52','2023-11-23 12:01:52'),(1910,'default','added',1185,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-23 12:14:44','2023-11-23 12:14:44'),(1911,'default','added',1186,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-11-23 12:30:25','2023-11-23 12:30:25'),(1912,'default','added',1187,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-23 12:32:04','2023-11-23 12:32:04'),(1913,'default','added',1188,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-11-23 12:36:56','2023-11-23 12:36:56'),(1914,'default','added',1189,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3580}}',NULL,'2023-11-23 12:43:37','2023-11-23 12:43:37'),(1915,'default','added',1190,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-23 13:36:51','2023-11-23 13:36:51'),(1916,'default','added',99,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 13:38:02','2023-11-23 13:38:02'),(1917,'default','added',1191,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-11-23 13:38:28','2023-11-23 13:38:28'),(1918,'default','added',1192,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4750}}',NULL,'2023-11-23 13:39:52','2023-11-23 13:39:52'),(1919,'default','added',1193,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31200}}',NULL,'2023-11-23 13:42:39','2023-11-23 13:42:39'),(1920,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 13:44:51','2023-11-23 13:44:51'),(1921,'default','added',1194,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-11-23 13:48:58','2023-11-23 13:48:58'),(1922,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-11-23 13:49:16','2023-11-23 13:49:16'),(1923,'default','added',1195,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4800}}',NULL,'2023-11-23 13:54:14','2023-11-23 13:54:14'),(1924,'default','added',1196,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}',NULL,'2023-11-23 13:55:07','2023-11-23 13:55:07'),(1925,'default','added',1197,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":320}}',NULL,'2023-11-23 14:05:16','2023-11-23 14:05:16'),(1926,'default','added',1198,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5250}}',NULL,'2023-11-23 14:41:12','2023-11-23 14:41:12'),(1927,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 17:29:16','2023-11-23 17:29:16'),(1928,'default','added',1199,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":109400}}',NULL,'2023-11-23 17:34:17','2023-11-23 17:34:17'),(1929,'default','added',1200,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":57240}}',NULL,'2023-11-23 17:38:29','2023-11-23 17:38:29'),(1930,'default','added',1201,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8850}}',NULL,'2023-11-23 17:42:38','2023-11-23 17:42:38'),(1931,'default','added',1202,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34245.5999999999985448084771633148193359375}}',NULL,'2023-11-23 17:49:04','2023-11-23 17:49:04'),(1932,'default','added',1203,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-11-23 17:50:51','2023-11-23 17:50:51'),(1933,'default','added',1204,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4630}}',NULL,'2023-11-23 17:53:08','2023-11-23 17:53:08'),(1934,'default','added',1205,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13320}}',NULL,'2023-11-23 17:55:29','2023-11-23 17:55:29'),(1935,'default','added',1206,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13000}}',NULL,'2023-11-23 17:56:14','2023-11-23 17:56:14'),(1936,'default','added',100,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 18:00:20','2023-11-23 18:00:20'),(1937,'default','added',1207,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-23 18:01:28','2023-11-23 18:01:28'),(1938,'default','added',1208,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-23 18:14:17','2023-11-23 18:14:17'),(1939,'default','added',1209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8850}}',NULL,'2023-11-23 18:29:11','2023-11-23 18:29:11'),(1940,'default','added',1210,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 18:35:41','2023-11-23 18:35:41'),(1941,'default','payment_edited',811,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"86310.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"86310.0000\"}}',NULL,'2023-11-23 18:38:28','2023-11-23 18:38:28'),(1942,'default','payment_edited',899,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"50195.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"50195.0000\"}}',NULL,'2023-11-23 18:38:28','2023-11-23 18:38:28'),(1943,'default','payment_edited',1118,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"251954.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"251954.0000\"}}',NULL,'2023-11-23 18:38:28','2023-11-23 18:38:28'),(1944,'default','added',1211,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4330}}',NULL,'2023-11-23 19:08:08','2023-11-23 19:08:08'),(1945,'default','edited',1209,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3481},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8850.0000\"}}',NULL,'2023-11-23 19:09:50','2023-11-23 19:09:50'),(1946,'default','sell_deleted',1209,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":1209,\"invoice_no\":\"0936\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3481.0000\"}}',NULL,'2023-11-23 19:10:31','2023-11-23 19:10:31'),(1947,'default','added',1212,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3481}}',NULL,'2023-11-23 19:14:03','2023-11-23 19:14:03'),(1948,'default','added',1213,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4560}}',NULL,'2023-11-23 19:17:52','2023-11-23 19:17:52'),(1949,'default','added',1214,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2023-11-23 19:28:13','2023-11-23 19:28:13'),(1950,'default','added',1215,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1380}}',NULL,'2023-11-23 19:31:33','2023-11-23 19:31:33'),(1951,'default','added',1216,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1930}}',NULL,'2023-11-23 19:31:48','2023-11-23 19:31:48'),(1952,'default','added',1217,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:40:59','2023-11-23 19:40:59'),(1953,'default','added',1218,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:43:37','2023-11-23 19:43:37'),(1954,'default','added',1219,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:45:23','2023-11-23 19:45:23'),(1955,'default','added',1220,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-23 19:47:01','2023-11-23 19:47:01'),(1956,'default','added',1221,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-11-23 19:47:56','2023-11-23 19:47:56'),(1957,'default','added',1222,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2023-11-23 19:50:42','2023-11-23 19:50:42'),(1958,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:51:59','2023-11-23 19:51:59'),(1959,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:52:07','2023-11-23 19:52:07'),(1960,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:52:15','2023-11-23 19:52:15'),(1961,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:52:44','2023-11-23 19:52:44'),(1962,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-23 19:53:33','2023-11-23 19:53:33'),(1963,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-24 01:24:15','2023-11-24 01:24:15'),(1964,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 10:38:57','2023-11-25 10:38:57'),(1965,'default','added',1223,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-11-25 10:39:55','2023-11-25 10:39:55'),(1966,'default','added',1224,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-11-25 10:40:33','2023-11-25 10:40:33'),(1967,'default','payment_edited',835,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21210.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21210.0000\"}}',NULL,'2023-11-25 10:42:38','2023-11-25 10:42:38'),(1968,'default','payment_edited',981,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10950.0000\"}}',NULL,'2023-11-25 10:42:38','2023-11-25 10:42:38'),(1969,'default','added',1225,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8930}}',NULL,'2023-11-25 10:43:56','2023-11-25 10:43:56'),(1970,'default','added',1226,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9860}}',NULL,'2023-11-25 10:45:37','2023-11-25 10:45:37'),(1971,'default','added',1227,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9700}}',NULL,'2023-11-25 10:47:57','2023-11-25 10:47:57'),(1972,'default','added',1228,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5400}}',NULL,'2023-11-25 10:48:36','2023-11-25 10:48:36'),(1973,'default','added',1229,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8420}}',NULL,'2023-11-25 10:50:24','2023-11-25 10:50:24'),(1974,'default','added',1230,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-25 10:52:53','2023-11-25 10:52:53'),(1975,'default','added',1231,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":51695}}',NULL,'2023-11-25 10:54:56','2023-11-25 10:54:56'),(1976,'default','added',1232,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-11-25 10:58:00','2023-11-25 10:58:00'),(1977,'default','added',1233,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10230}}',NULL,'2023-11-25 11:00:47','2023-11-25 11:00:47'),(1978,'default','added',1234,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3300}}',NULL,'2023-11-25 11:03:40','2023-11-25 11:03:40'),(1979,'default','added',1235,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-11-25 11:04:44','2023-11-25 11:04:44'),(1980,'default','added',1236,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-11-25 11:04:58','2023-11-25 11:04:58'),(1981,'default','added',1237,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-25 11:07:05','2023-11-25 11:07:05'),(1982,'default','added',1238,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-11-25 11:08:11','2023-11-25 11:08:11'),(1983,'default','added',1239,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-11-25 11:15:27','2023-11-25 11:15:27'),(1984,'default','added',101,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 11:27:01','2023-11-25 11:27:01'),(1985,'default','added',1240,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":21450}}',NULL,'2023-11-25 11:28:26','2023-11-25 11:28:26'),(1986,'default','added',1241,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-25 11:32:40','2023-11-25 11:32:40'),(1987,'default','added',1242,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2680}}',NULL,'2023-11-25 11:40:32','2023-11-25 11:40:32'),(1988,'default','added',1243,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-11-25 11:57:21','2023-11-25 11:57:21'),(1989,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 12:06:35','2023-11-25 12:06:35'),(1990,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 12:07:06','2023-11-25 12:07:06'),(1991,'default','added',1244,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-25 12:07:59','2023-11-25 12:08:00'),(1992,'default','added',1245,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2023-11-25 12:10:59','2023-11-25 12:10:59'),(1993,'default','added',1246,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-11-25 12:12:19','2023-11-25 12:12:19'),(1994,'default','added',1247,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-25 12:20:55','2023-11-25 12:20:55'),(1995,'default','added',1248,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4650}}',NULL,'2023-11-25 12:36:32','2023-11-25 12:36:32'),(1996,'default','added',1249,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1680}}',NULL,'2023-11-25 12:39:48','2023-11-25 12:39:48'),(1997,'default','payment_edited',1240,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"21450.0000\"}}',NULL,'2023-11-25 12:46:57','2023-11-25 12:46:57'),(1998,'default','added',1250,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-25 13:30:07','2023-11-25 13:30:07'),(1999,'default','added',1251,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-25 13:55:27','2023-11-25 13:55:27'),(2000,'default','added',1252,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2650}}',NULL,'2023-11-25 13:57:24','2023-11-25 13:57:24'),(2001,'default','added',1253,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-11-25 13:58:03','2023-11-25 13:58:03'),(2002,'default','added',1254,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2023-11-25 13:59:44','2023-11-25 13:59:44'),(2003,'default','payment_edited',104,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2023-11-25 14:02:26','2023-11-25 14:02:26');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_continuous` tinyint(1) NOT NULL DEFAULT '0',
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 00:13:44','2017-12-18 00:13:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 00:04:39','2017-12-18 00:10:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-17 23:55:40','2017-12-17 23:55:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-17 23:58:40','2017-12-17 23:58:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-17 23:51:10','2017-12-17 23:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-17 23:51:10','2017-12-17 23:51:10'),(7,'Settings one',NULL,2.5000,2.0000,3.0000,2.5000,0.5000,1.0000,0.5000,0.5000,4,0,0,8,1,'2023-10-21 15:53:37','2023-10-21 15:53:37');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'এ সি আই লিমিটেড কোং',NULL,1,'2023-10-28 11:50:02','2023-10-18 17:01:16','2023-10-28 11:50:02');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_label_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT '0.00',
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT '1',
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT '1',
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT '1.000',
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT '30',
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT '30',
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci,
  `pos_settings` text COLLATE utf8mb4_unicode_ci,
  `weighing_scale_setting` text COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT '1',
  `enable_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT '1',
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT '1',
  `enable_purchase_status` tinyint(1) DEFAULT '1',
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT '0',
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT '0',
  `enable_racks` tinyint(1) NOT NULL DEFAULT '0',
  `enable_row` tinyint(1) NOT NULL DEFAULT '0',
  `enable_position` tinyint(1) NOT NULL DEFAULT '0',
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT '1',
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT '1',
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT '1',
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT '2',
  `quantity_precision` tinyint(4) NOT NULL DEFAULT '2',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT '1.0000' COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text COLLATE utf8mb4_unicode_ci,
  `sms_settings` text COLLATE utf8mb4_unicode_ci,
  `custom_labels` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_transport_active` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'M/S Salam Enterprise',134,'2023-10-15',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Asia/Kolkata',7,'fifo',0.00,'includes','1697892508_salam-enterprise-invoice.png',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"disable_draft\":\"1\",\"disable_express_checkout\":\"1\",\"disable_order_tax\":\"1\",\"is_pos_subtotal_editable\":\"1\",\"disable_suspend\":\"1\",\"disable_credit_sale_button\":\"1\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0}','{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,1,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','d-m-Y','12',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SE\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"salamadmin\",\"mail_password\":\"*AH$y@NBG\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"-1\"}',1,0,'2023-10-15 17:32:12','2023-11-23 17:38:29');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT '1',
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `featured_products` text COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `default_payment_accounts` text COLLATE utf8mb4_unicode_ci,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','মেসার্স সালাম এন্টারপ্রাইজ','জেল রোড, বন্দর বাজার','বাংলাদেশ','সিলেট','সিলেট','৩১০০',1,1,1,NULL,1,'browser',NULL,'০১৭১৭২৫৮০৫০','০১৭৭৫৪৭৯৯০২',NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"},\"custom_pay_3\":{\"is_enabled\":\"1\"},\"custom_pay_4\":{\"is_enabled\":\"1\"},\"custom_pay_5\":{\"is_enabled\":\"1\"},\"custom_pay_6\":{\"is_enabled\":\"1\"},\"custom_pay_7\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,'2023-10-15 17:32:12','2023-10-19 01:44:54');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pay_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (20,3,100000.0000,'cash','credit','initial',NULL,'2023-10-25 14:57:37','2023-10-25 14:57:37'),(21,2,6060.0000,'cash','credit','sell',73,'2023-10-25 15:02:43','2023-10-25 15:02:43'),(22,4,106060.0000,'cash','credit','initial',NULL,'2023-10-25 19:58:40','2023-10-25 19:58:40'),(23,5,106060.0000,'cash','credit','initial',NULL,'2023-10-25 20:24:17','2023-10-25 20:24:17'),(24,5,5370.0000,'cash','credit','sell',77,'2023-10-25 20:34:15','2023-10-25 20:34:15'),(25,5,36440.0000,'cash','credit','sell',78,'2023-10-26 13:00:03','2023-10-26 13:00:03'),(26,5,15110.0000,'cash','credit','sell',79,'2023-10-27 14:05:25','2023-10-27 14:05:25'),(27,5,129930.0000,'cash','credit','sell',80,'2023-10-27 14:29:48','2023-10-27 14:29:48'),(28,5,21330.0000,'cash','credit','sell',81,'2023-10-27 14:47:33','2023-10-27 14:47:33'),(29,5,79192.0000,'cash','credit','sell',82,'2023-10-27 15:01:40','2023-10-27 15:01:40'),(30,5,1040.0000,'cash','credit','sell',83,'2023-10-27 15:04:16','2023-10-27 15:04:16'),(31,5,7600.0000,'cash','credit','sell',84,'2023-10-27 15:07:34','2023-10-27 15:07:34'),(32,5,9120.0000,'cash','credit','sell',85,'2023-10-27 15:08:14','2023-10-27 15:08:14'),(33,5,18370.0000,'cash','credit','sell',86,'2023-10-27 15:13:43','2023-10-27 15:13:43'),(34,5,76000.0000,'cash','credit','sell',87,'2023-10-27 15:16:47','2023-10-27 15:16:47'),(35,5,2400.0000,'cash','credit','sell',88,'2023-10-27 15:18:48','2023-10-27 15:18:48'),(36,5,1800.0000,'cash','credit','sell',101,'2023-10-27 23:49:40','2023-10-27 23:49:40'),(37,5,25950.0000,'cash','credit','sell',106,'2023-10-28 17:58:57','2023-10-28 17:58:57'),(38,5,9640.0000,'cash','credit','sell',107,'2023-10-28 18:12:44','2023-10-28 18:12:44'),(40,5,12600.0000,'cash','credit','sell',109,'2023-10-28 18:38:17','2023-10-28 18:38:17'),(41,5,35180.0000,'cash','credit','sell',110,'2023-10-28 18:51:27','2023-10-28 18:51:27'),(42,5,40620.0000,'cash','credit','sell',111,'2023-10-28 18:57:11','2023-10-28 18:57:11'),(43,5,3000.0000,'cash','credit','sell',115,'2023-10-29 17:38:54','2023-10-29 17:38:54'),(44,5,56561.0400,'cash','credit','sell',116,'2023-10-29 17:45:19','2023-10-29 17:45:19'),(45,5,33068.9500,'cash','credit','sell',117,'2023-10-29 18:13:27','2023-10-29 18:13:27'),(46,5,30660.0200,'cash','credit','sell',118,'2023-10-29 18:20:12','2023-10-29 18:20:12'),(47,5,26150.0000,'cash','credit','sell',119,'2023-10-29 18:25:17','2023-10-29 18:25:17'),(48,5,2200.0000,'cash','credit','sell',124,'2023-10-29 18:39:13','2023-10-29 18:39:13'),(49,5,1650.0000,'cash','credit','sell',125,'2023-10-29 18:40:30','2023-10-29 18:40:30'),(50,5,1300.0000,'cash','debit','expense',127,'2023-10-29 18:49:00','2023-10-29 18:49:00'),(51,5,25000.0000,'cash','debit','expense',128,'2023-10-29 18:50:23','2023-10-29 18:50:23'),(52,5,750.0000,'cash','debit','expense',129,'2023-10-29 18:57:28','2023-10-29 18:57:28'),(53,5,2700.0000,'cash','credit','sell',130,'2023-10-29 19:07:43','2023-10-29 19:07:43'),(54,5,1300.0000,'cash','credit','sell',135,'2023-10-29 19:44:55','2023-10-29 19:44:55'),(55,5,1280.0000,'cash','credit','sell',136,'2023-10-29 20:07:08','2023-10-29 20:07:08'),(56,5,3250.0000,'cash','credit','sell',137,'2023-10-29 20:52:09','2023-10-29 20:52:09'),(57,5,7830.0000,'cash','credit','sell',138,'2023-10-29 20:59:34','2023-10-29 20:59:34'),(58,5,5000.0000,'cash','credit','sell',140,'2023-10-29 21:04:43','2023-10-29 21:04:43'),(59,5,5250.0000,'cash','credit','sell',141,'2023-10-29 21:18:53','2023-10-29 21:18:53'),(60,5,5950.0000,'cash','credit','sell',142,'2023-10-29 21:24:37','2023-10-29 21:24:37'),(61,5,3300.0000,'cash','credit','sell',147,'2023-10-29 21:33:35','2023-10-29 21:33:35'),(62,5,4950.0000,'cash','credit','sell',148,'2023-10-29 21:36:02','2023-10-29 21:36:02'),(63,5,1300.0000,'cash','credit','sell',150,'2023-10-29 21:39:08','2023-10-29 21:39:08'),(64,5,1350.0000,'cash','credit','sell',153,'2023-10-29 21:42:12','2023-10-29 21:42:12'),(65,5,3150.0000,'cash','credit','sell',156,'2023-10-29 21:45:11','2023-10-29 21:45:11'),(66,5,1500.0000,'cash','credit','sell',158,'2023-10-29 21:51:13','2023-10-29 21:51:13'),(67,6,206850.0000,'cash','credit','initial',NULL,'2023-10-29 21:59:00','2023-10-29 21:59:00'),(68,6,4900.0000,'cash','credit','sell',159,'2023-10-30 13:36:25','2023-10-30 13:36:25'),(69,6,2880.0000,'cash','credit','sell',161,'2023-10-30 13:55:18','2023-10-30 13:55:18'),(70,6,1650.0000,'cash','credit','sell',162,'2023-10-30 13:56:22','2023-10-30 13:56:22'),(71,6,3200.0000,'cash','credit','sell',163,'2023-10-30 13:58:18','2023-10-30 13:58:18'),(72,6,1580.0000,'cash','credit','sell',165,'2023-10-30 14:08:57','2023-10-30 14:08:57'),(73,6,7400.0000,'cash','credit','sell',166,'2023-10-30 14:12:02','2023-10-30 14:12:02'),(74,6,2850.0000,'cash','credit','sell',167,'2023-10-30 14:13:21','2023-10-30 14:13:21'),(75,6,11900.0000,'cash','credit','sell',169,'2023-10-30 14:29:12','2023-10-30 14:29:12'),(76,6,33000.0000,'cash','credit','sell',170,'2023-10-30 14:34:24','2023-10-30 14:34:24'),(77,6,3130.0000,'cash','credit','sell',171,'2023-10-30 14:37:51','2023-10-30 14:37:51'),(78,6,5200.0000,'cash','credit','sell',173,'2023-10-30 14:42:47','2023-10-30 14:42:47'),(79,6,5380.0000,'cash','credit','sell',174,'2023-10-30 14:44:07','2023-10-30 14:44:07'),(80,6,3400.0000,'cash','credit','sell',175,'2023-10-30 14:44:49','2023-10-30 14:44:49'),(81,6,15169.5000,'cash','credit','sell',176,'2023-10-30 14:59:23','2023-10-30 14:59:23'),(82,6,1450.0000,'cash','credit','sell',177,'2023-10-30 15:02:42','2023-10-30 15:02:42'),(83,6,11434.6000,'cash','credit','sell',178,'2023-10-30 15:11:34','2023-10-30 15:11:34'),(84,6,3450.0000,'cash','credit','sell',181,'2023-10-30 17:59:21','2023-10-30 17:59:21'),(85,6,1650.0000,'cash','credit','sell',182,'2023-10-30 18:01:05','2023-10-30 18:01:05'),(86,6,2500.0000,'cash','credit','sell',183,'2023-10-30 18:02:34','2023-10-30 18:02:34'),(87,6,1250.0000,'cash','credit','sell',184,'2023-10-30 18:04:51','2023-10-30 18:04:51'),(88,6,25280.0000,'cash','credit','sell',186,'2023-10-30 18:13:50','2023-10-30 18:13:50'),(89,6,1750.0000,'cash','credit','sell',187,'2023-10-30 18:19:12','2023-10-30 18:19:12'),(90,6,16750.0000,'cash','credit','sell',188,'2023-10-30 18:23:58','2023-10-30 18:23:58'),(91,6,5550.0000,'cash','credit','sell',189,'2023-10-30 18:28:40','2023-10-30 18:28:40'),(92,6,2550.0000,'cash','credit','sell',190,'2023-10-30 18:32:16','2023-10-30 18:32:16'),(93,6,3600.0000,'cash','credit','sell',192,'2023-10-30 18:41:34','2023-10-30 18:41:34'),(94,6,3700.0000,'cash','credit','sell',193,'2023-10-30 18:43:03','2023-10-30 18:43:03'),(95,6,16459.2000,'cash','credit','sell',194,'2023-10-30 18:45:15','2023-10-30 18:45:15'),(96,6,7700.0000,'cash','credit','sell',195,'2023-10-30 18:48:05','2023-10-30 18:48:05'),(97,6,5500.0000,'cash','credit','sell',196,'2023-10-30 18:51:20','2023-10-30 18:51:20'),(98,6,2650.0000,'cash','credit','sell',197,'2023-10-30 18:52:41','2023-10-30 18:52:41'),(99,6,2900.0000,'cash','credit','sell',198,'2023-10-30 18:57:12','2023-10-30 18:57:12'),(100,6,1380.0000,'cash','debit','expense',199,'2023-10-30 19:02:05','2023-10-30 19:02:05'),(101,6,9000.0000,'cash','credit','sell',200,'2023-10-30 19:23:47','2023-10-30 19:23:47'),(102,6,600.0000,'cash','debit','expense',201,'2023-10-30 19:24:35','2023-10-30 19:24:35'),(103,6,4550.0000,'cash','credit','sell',202,'2023-10-30 19:28:56','2023-10-30 19:28:56'),(104,6,2200.0000,'cash','credit','sell',204,'2023-10-30 19:33:50','2023-10-30 19:33:50'),(105,6,1400.0000,'cash','credit','sell',205,'2023-10-30 19:34:10','2023-10-30 19:34:10'),(106,6,1350.0000,'cash','credit','sell',206,'2023-10-30 19:37:30','2023-10-30 19:37:30'),(107,6,29049.6000,'cash','credit','sell',208,'2023-10-31 11:19:21','2023-10-31 11:19:21'),(108,6,2600.0000,'cash','credit','sell',209,'2023-10-31 11:24:33','2023-10-31 11:24:33'),(109,6,25200.0000,'cash','credit','sell',210,'2023-10-31 11:44:45','2023-10-31 11:44:45'),(110,6,1850.0000,'cash','credit','sell',211,'2023-10-31 11:46:20','2023-10-31 11:46:20'),(111,6,2600.0000,'cash','credit','sell',212,'2023-10-31 11:52:27','2023-10-31 11:52:27'),(112,6,10000.0000,'cash','credit','sell',213,'2023-10-31 11:57:23','2023-10-31 11:57:23'),(113,6,100.0000,'cash','debit','expense',215,'2023-10-31 12:01:09','2023-10-31 12:01:09'),(114,6,700.0000,'cash','debit','expense',216,'2023-10-31 12:01:58','2023-10-31 12:01:58'),(115,6,2000.0000,'cash','debit','expense',217,'2023-10-31 12:03:40','2023-10-31 12:03:40'),(116,6,12090.0000,'cash','credit','sell',219,'2023-10-31 12:18:16','2023-10-31 12:18:16'),(117,6,1900.0000,'cash','credit','sell',220,'2023-10-31 12:25:13','2023-10-31 12:25:13'),(118,6,6000.0000,'cash','credit','sell',222,'2023-10-31 12:58:52','2023-10-31 12:58:52'),(119,6,3150.0000,'cash','credit','sell',223,'2023-10-31 13:45:39','2023-10-31 13:45:39'),(120,6,2800.0000,'cash','credit','sell',224,'2023-10-31 14:20:49','2023-10-31 14:20:49'),(121,6,12160.0000,'cash','credit','sell',225,'2023-10-31 14:36:07','2023-10-31 14:36:07'),(122,6,3050.0000,'cash','credit','sell',226,'2023-10-31 14:39:53','2023-10-31 14:39:53'),(123,6,1500.0000,'cash','credit','sell',227,'2023-10-31 14:41:45','2023-10-31 14:41:45'),(124,6,1020.0000,'cash','debit','expense',228,'2023-10-31 14:44:34','2023-10-31 14:44:34'),(125,6,11500.0000,'cash','credit','sell',229,'2023-10-31 17:47:28','2023-10-31 17:47:28'),(126,6,1630.0000,'cash','credit','sell',232,'2023-10-31 17:57:23','2023-10-31 17:57:23'),(127,6,1480.0000,'cash','credit','sell',234,'2023-10-31 18:52:01','2023-10-31 18:52:01'),(128,6,2880.0000,'cash','credit','sell',235,'2023-10-31 18:57:02','2023-10-31 18:57:02'),(129,6,2650.0000,'cash','credit','sell',236,'2023-10-31 18:58:30','2023-10-31 18:58:30'),(130,6,500.0000,'cash','debit','expense',240,'2023-10-31 20:14:24','2023-10-31 20:14:24'),(131,6,600.0000,'cash','debit','expense',241,'2023-10-31 20:15:39','2023-10-31 20:15:39'),(132,6,100.0000,'cash','debit','expense',242,'2023-10-31 20:16:02','2023-10-31 20:16:02'),(133,6,6270.0000,'cash','credit','sell',243,'2023-10-31 20:18:04','2023-10-31 20:18:04'),(134,6,3400.0000,'cash','credit','sell',245,'2023-10-31 20:40:47','2023-10-31 20:40:47'),(135,6,700.0000,'cash','debit','expense',246,'2023-11-01 17:14:11','2023-11-01 17:14:11'),(136,6,6000.0000,'cash','credit','sell',247,'2023-11-01 17:26:40','2023-11-01 17:26:40'),(137,6,-3550.0000,'cash','credit','sell',247,'2023-11-01 17:26:40','2023-11-01 17:26:40'),(138,6,2450.0000,'cash','debit','refund',247,'2023-11-01 17:28:07','2023-11-01 17:28:07'),(139,6,29000.0000,'cash','credit','sell',248,'2023-11-01 17:44:15','2023-11-01 17:44:15'),(140,6,31730.0000,'cash','credit','sell',249,'2023-11-01 17:51:23','2023-11-01 17:51:23'),(141,6,9080.0000,'cash','credit','sell',250,'2023-11-01 17:53:29','2023-11-01 17:53:29'),(142,6,3500.0000,'cash','credit','sell',251,'2023-11-01 17:55:12','2023-11-01 17:55:12'),(143,6,1700.0000,'cash','credit','sell',253,'2023-11-01 18:05:09','2023-11-01 18:05:09'),(144,6,2700.0000,'cash','credit','sell',256,'2023-11-01 18:33:40','2023-11-01 18:33:40'),(145,7,151700.0000,'cash','credit','initial',NULL,'2023-11-01 18:54:00','2023-11-01 18:54:00'),(146,7,2600.0000,'cash','credit','sell',258,'2023-11-01 18:55:44','2023-11-01 18:55:44'),(147,7,1900.0000,'cash','credit','sell',260,'2023-11-01 19:23:25','2023-11-01 19:23:25'),(148,7,1680.0000,'cash','credit','sell',261,'2023-11-01 19:27:52','2023-11-01 19:27:52'),(149,7,1530.0000,'cash','credit','sell',262,'2023-11-01 19:36:35','2023-11-01 19:36:35'),(150,7,2680.0000,'cash','credit','sell',263,'2023-11-01 19:48:27','2023-11-01 19:48:27'),(151,7,3000.0000,'cash','credit','sell',264,'2023-11-01 19:50:37','2023-11-01 19:50:37'),(152,7,1400.0000,'cash','credit','sell',265,'2023-11-01 19:55:44','2023-11-01 19:55:44'),(153,7,2900.0000,'cash','credit','sell',266,'2023-11-01 20:01:42','2023-11-01 20:01:42'),(154,7,2480.0000,'cash','credit','sell',267,'2023-11-01 20:07:04','2023-11-01 20:07:04'),(155,7,4900.0000,'cash','credit','sell',268,'2023-11-02 10:23:57','2023-11-02 10:23:57'),(156,7,2700.0000,'cash','credit','sell',269,'2023-11-02 10:33:07','2023-11-02 10:33:07'),(157,7,4480.0000,'cash','credit','sell',270,'2023-11-02 10:34:26','2023-11-02 10:34:26'),(158,7,500.0000,'cash','debit','expense',271,'2023-11-02 10:45:46','2023-11-02 10:45:46'),(159,7,50.0000,'cash','debit','expense',272,'2023-11-02 10:46:16','2023-11-02 10:46:16'),(160,7,24350.0000,'cash','credit','sell',274,'2023-11-02 10:51:44','2023-11-02 10:51:44'),(161,7,8290.0000,'cash','credit','sell',275,'2023-11-02 10:54:55','2023-11-02 10:54:55'),(162,7,2200.0000,'cash','credit','sell',276,'2023-11-02 10:55:16','2023-11-02 10:55:16'),(163,7,1300.0000,'cash','credit','sell',279,'2023-11-02 11:32:35','2023-11-02 11:32:35'),(164,7,2950.0000,'cash','credit','sell',280,'2023-11-02 11:37:22','2023-11-02 11:37:22'),(165,7,2900.0000,'cash','credit','sell',281,'2023-11-02 11:48:53','2023-11-02 11:48:53'),(166,7,2850.0000,'cash','credit','sell',282,'2023-11-02 11:55:41','2023-11-02 11:55:41'),(167,7,2600.0000,'cash','credit','sell',283,'2023-11-02 12:02:20','2023-11-02 12:02:20'),(168,7,3650.0000,'cash','credit','sell',284,'2023-11-02 12:25:11','2023-11-02 12:25:11'),(169,7,400.0000,'cash','credit','sell',285,'2023-11-02 12:26:51','2023-11-02 12:26:51'),(170,7,3000.0000,'cash','credit','sell',286,'2023-11-02 12:33:44','2023-11-02 12:33:44'),(171,7,1400.0000,'cash','credit','sell',287,'2023-11-02 12:41:50','2023-11-02 12:41:50'),(172,7,1800.0000,'cash','credit','sell',288,'2023-11-02 12:50:29','2023-11-02 12:50:29'),(173,7,4900.0000,'cash','credit','sell',290,'2023-11-02 13:21:43','2023-11-02 13:21:43'),(174,7,1400.0000,'cash','credit','sell',291,'2023-11-02 13:32:44','2023-11-02 13:32:44'),(175,7,7500.0000,'cash','credit','sell',292,'2023-11-02 14:02:13','2023-11-02 14:02:13'),(176,7,3700.0000,'cash','credit','sell',293,'2023-11-02 14:03:55','2023-11-02 14:03:55'),(177,7,1250.0000,'cash','credit','sell',294,'2023-11-02 14:17:52','2023-11-02 14:17:52'),(178,7,2650.0000,'cash','credit','sell',298,'2023-11-02 17:34:07','2023-11-02 17:34:07'),(179,7,3300.0000,'cash','credit','sell',299,'2023-11-02 17:36:44','2023-11-02 17:36:44'),(180,7,2450.0000,'cash','credit','sell',300,'2023-11-02 17:38:07','2023-11-02 17:38:07'),(181,7,2500.0000,'cash','credit','sell',301,'2023-11-02 17:38:46','2023-11-02 17:38:46'),(182,7,29380.0000,'cash','credit','sell',304,'2023-11-02 17:48:49','2023-11-02 17:48:49'),(183,7,1650.0000,'cash','credit','sell',305,'2023-11-02 17:49:47','2023-11-02 17:49:47'),(184,7,2850.0000,'cash','credit','sell',307,'2023-11-02 17:55:53','2023-11-02 17:55:53'),(185,7,5630.0000,'cash','credit','sell',308,'2023-11-02 18:21:08','2023-11-02 18:21:08'),(186,7,3400.0000,'cash','credit','sell',309,'2023-11-02 18:30:10','2023-11-02 18:30:10'),(187,7,1000.0000,'cash','debit','expense',310,'2023-11-02 18:42:04','2023-11-02 18:42:04'),(188,7,100.0000,'cash','debit','expense',311,'2023-11-02 18:42:37','2023-11-02 18:42:37'),(189,7,2650.0000,'cash','credit','sell',312,'2023-11-02 18:44:07','2023-11-02 18:44:07'),(190,7,2450.0000,'cash','credit','sell',313,'2023-11-02 18:48:25','2023-11-02 18:48:25'),(191,7,2500.0000,'cash','credit','sell',314,'2023-11-02 18:48:39','2023-11-02 18:48:39'),(192,7,1650.0000,'cash','credit','sell',315,'2023-11-02 19:01:05','2023-11-02 19:01:05'),(193,7,1250.0000,'cash','credit','sell',316,'2023-11-02 19:46:51','2023-11-02 19:46:51'),(194,7,5030.0000,'cash','credit','sell',317,'2023-11-02 19:59:08','2023-11-02 19:59:08'),(195,7,7900.0000,'cash','credit','sell',318,'2023-11-02 20:11:26','2023-11-02 20:11:26'),(196,7,1600.0000,'cash','credit','sell',319,'2023-11-02 20:16:55','2023-11-02 20:16:55'),(197,7,2900.0000,'cash','credit','sell',320,'2023-11-02 20:18:48','2023-11-02 20:18:48'),(198,7,23367.7000,'cash','credit','sell',321,'2023-11-02 20:21:47','2023-11-02 20:21:47'),(199,7,2500.0000,'cash','credit','sell',323,'2023-11-02 20:45:11','2023-11-02 20:45:11'),(200,7,1700.0000,'cash','credit','sell',324,'2023-11-02 20:48:35','2023-11-02 20:48:35'),(201,7,1250.0000,'cash','credit','sell',325,'2023-11-02 20:56:54','2023-11-02 20:56:54'),(202,7,32250.0000,'cash','credit','sell',326,'2023-11-02 21:18:10','2023-11-02 21:18:10'),(203,7,1550.0000,'cash','credit','sell',327,'2023-11-02 21:18:50','2023-11-02 21:18:50'),(204,7,9350.0000,'cash','credit','sell',328,'2023-11-02 21:22:27','2023-11-02 21:22:27'),(205,7,1400.0000,'cash','credit','sell',329,'2023-11-02 21:26:11','2023-11-02 21:26:11'),(206,7,3030.0000,'cash','credit','sell',330,'2023-11-02 21:27:11','2023-11-02 21:27:11'),(207,7,2600.0000,'cash','credit','sell',331,'2023-11-04 10:15:17','2023-11-04 10:15:17'),(208,7,1700.0000,'cash','credit','sell',332,'2023-11-04 10:38:49','2023-11-04 10:38:49'),(209,7,1750.0000,'cash','credit','sell',333,'2023-11-04 10:49:19','2023-11-04 10:49:19'),(210,7,8950.0000,'cash','credit','sell',334,'2023-11-04 10:56:46','2023-11-04 10:56:46'),(211,7,2450.0000,'cash','credit','sell',335,'2023-11-04 10:59:25','2023-11-04 10:59:25'),(212,7,1490.0000,'cash','credit','sell',336,'2023-11-04 11:23:57','2023-11-04 11:23:57'),(213,7,9650.0000,'cash','credit','sell',337,'2023-11-04 11:25:55','2023-11-04 11:25:55'),(214,7,3600.0000,'cash','credit','sell',338,'2023-11-04 11:28:17','2023-11-04 11:28:17'),(215,7,2180.0000,'cash','credit','sell',339,'2023-11-04 11:43:17','2023-11-04 11:43:17'),(216,7,3780.0000,'cash','credit','sell',340,'2023-11-04 11:47:05','2023-11-04 11:47:05'),(217,7,3300.0000,'cash','credit','sell',341,'2023-11-04 11:48:48','2023-11-04 11:48:48'),(218,7,1680.0000,'cash','credit','sell',342,'2023-11-04 11:51:04','2023-11-04 11:51:04'),(219,7,2600.0000,'cash','credit','sell',343,'2023-11-04 12:01:02','2023-11-04 12:01:02'),(220,7,3900.0000,'cash','credit','sell',344,'2023-11-04 12:01:59','2023-11-04 12:01:59'),(221,7,2700.0000,'cash','credit','sell',345,'2023-11-04 12:04:53','2023-11-04 12:04:53'),(222,7,2880.0000,'cash','credit','sell',346,'2023-11-04 12:14:33','2023-11-04 12:14:33'),(223,7,3150.0000,'cash','credit','sell',347,'2023-11-04 12:18:05','2023-11-04 12:18:05'),(224,7,5130.0000,'cash','credit','sell',348,'2023-11-04 12:29:45','2023-11-04 12:29:45'),(225,7,2900.0000,'cash','credit','sell',349,'2023-11-04 12:32:13','2023-11-04 12:32:13'),(226,7,1600.0000,'cash','credit','sell',350,'2023-11-04 12:36:02','2023-11-04 12:36:02'),(227,7,3100.0000,'cash','credit','sell',351,'2023-11-04 12:41:53','2023-11-04 12:41:53'),(228,7,3030.0000,'cash','credit','sell',352,'2023-11-04 12:43:51','2023-11-04 12:43:51'),(229,7,2850.0000,'cash','credit','sell',353,'2023-11-04 12:44:33','2023-11-04 12:44:33'),(230,7,450.0000,'cash','credit','sell',354,'2023-11-04 12:46:11','2023-11-04 12:46:11'),(231,7,1250.0000,'cash','credit','sell',355,'2023-11-04 13:21:02','2023-11-04 13:21:02'),(232,7,200.0000,'cash','credit','sell',356,'2023-11-04 13:23:37','2023-11-04 13:23:37'),(233,7,2450.0000,'cash','credit','sell',357,'2023-11-04 13:24:01','2023-11-04 13:24:01'),(234,7,4000.0000,'cash','debit','expense',358,'2023-11-04 13:26:55','2023-11-04 13:26:55'),(235,7,700.0000,'cash','debit','expense',359,'2023-11-04 13:27:37','2023-11-04 13:27:37'),(236,7,8590.0000,'cash','credit','sell',361,'2023-11-04 13:32:12','2023-11-04 13:32:12'),(237,7,4930.0000,'cash','credit','sell',362,'2023-11-04 13:35:06','2023-11-04 13:35:06'),(238,7,6050.0000,'cash','credit','sell',363,'2023-11-04 13:37:38','2023-11-04 13:37:38'),(239,7,1450.0000,'cash','credit','sell',365,'2023-11-04 13:45:44','2023-11-04 13:45:44'),(240,7,3150.0000,'cash','credit','sell',366,'2023-11-04 13:48:16','2023-11-04 13:48:16'),(241,7,3500.0000,'cash','credit','sell',367,'2023-11-04 13:52:38','2023-11-04 13:52:38'),(242,7,6700.0000,'cash','credit','sell',368,'2023-11-04 14:00:18','2023-11-04 14:00:18'),(243,7,2500.0000,'cash','credit','sell',369,'2023-11-04 14:04:06','2023-11-04 14:04:06'),(244,7,1650.0000,'cash','credit','sell',370,'2023-11-04 14:09:00','2023-11-04 14:09:00'),(245,7,12950.0000,'cash','credit','sell',372,'2023-11-04 14:15:26','2023-11-04 14:15:26'),(246,7,2440.0000,'cash','credit','sell',373,'2023-11-04 14:24:30','2023-11-04 14:24:30'),(247,7,1650.0000,'cash','credit','sell',374,'2023-11-04 14:31:30','2023-11-04 14:31:30'),(248,7,1640.0000,'cash','credit','sell',376,'2023-11-04 17:04:49','2023-11-04 17:04:49'),(249,7,2900.0000,'cash','debit','expense',377,'2023-11-04 17:06:16','2023-11-04 17:06:16'),(250,7,1650.0000,'cash','credit','sell',378,'2023-11-04 17:28:32','2023-11-04 17:28:32'),(251,7,42460.0000,'cash','credit','sell',379,'2023-11-04 17:34:48','2023-11-04 17:34:48'),(252,7,23780.0000,'cash','credit','sell',380,'2023-11-04 17:43:35','2023-11-04 17:43:35'),(253,7,8222.0000,'cash','credit','sell',381,'2023-11-04 17:45:53','2023-11-04 17:45:53'),(254,7,1600.0000,'cash','credit','sell',387,'2023-11-04 18:01:38','2023-11-04 18:01:38'),(255,7,1680.0000,'cash','credit','sell',388,'2023-11-04 18:02:53','2023-11-04 18:02:53'),(256,7,2700.0000,'cash','credit','sell',389,'2023-11-04 18:13:34','2023-11-04 18:13:34'),(257,7,25040.0000,'cash','credit','sell',390,'2023-11-04 19:56:25','2023-11-04 19:56:25'),(258,7,3400.0000,'cash','credit','sell',392,'2023-11-04 20:01:58','2023-11-04 20:01:58'),(259,7,2620.0000,'cash','credit','sell',393,'2023-11-04 20:05:02','2023-11-04 20:05:02'),(260,7,2450.0000,'cash','credit','sell',394,'2023-11-04 20:07:09','2023-11-04 20:07:09'),(261,7,22860.0000,'cash','credit','sell',395,'2023-11-04 20:37:19','2023-11-04 20:37:19'),(262,7,6700.0000,'cash','credit','sell',396,'2023-11-04 20:39:47','2023-11-04 20:39:47'),(263,7,2900.0000,'cash','credit','sell',397,'2023-11-04 20:40:09','2023-11-04 20:40:09'),(264,7,3500.0000,'cash','credit','sell',398,'2023-11-04 20:49:06','2023-11-04 20:49:06'),(265,7,2600.0000,'cash','credit','sell',399,'2023-11-04 21:01:09','2023-11-04 21:01:09'),(266,7,16036.2000,'cash','credit','sell',400,'2023-11-04 21:03:30','2023-11-04 21:03:30'),(267,7,5880.0000,'cash','credit','sell',401,'2023-11-04 21:05:16','2023-11-04 21:05:16'),(268,7,750.0000,'cash','debit','expense',403,'2023-11-04 21:14:15','2023-11-04 21:14:15'),(269,7,2000.0000,'cash','debit','expense',404,'2023-11-04 21:14:48','2023-11-04 21:14:48'),(270,7,1200.0000,'cash','credit','sell',405,'2023-11-05 10:28:31','2023-11-05 10:28:31'),(271,7,700.0000,'cash','debit','expense',406,'2023-11-05 10:32:33','2023-11-05 10:32:33'),(272,7,18480.0000,'cash','credit','sell',407,'2023-11-05 10:40:26','2023-11-05 10:40:26'),(273,7,3040.0000,'cash','credit','sell',409,'2023-11-05 10:43:39','2023-11-05 10:43:39'),(274,7,11800.0000,'cash','credit','sell',410,'2023-11-05 10:46:29','2023-11-05 10:46:29'),(275,7,8150.0000,'cash','credit','sell',411,'2023-11-05 10:47:35','2023-11-05 10:47:35'),(276,7,4480.0000,'cash','credit','sell',412,'2023-11-05 10:48:43','2023-11-05 10:48:43'),(277,7,1900.0000,'cash','credit','sell',413,'2023-11-05 10:50:55','2023-11-05 10:50:55'),(278,7,3000.0000,'cash','credit','sell',414,'2023-11-05 10:53:17','2023-11-05 10:53:17'),(279,7,14840.0000,'cash','credit','sell',415,'2023-11-05 10:56:51','2023-11-05 10:56:51'),(280,7,1000.0000,'cash','debit','expense',416,'2023-11-05 11:09:54','2023-11-05 11:09:54'),(281,7,200.0000,'cash','debit','expense',417,'2023-11-05 11:14:43','2023-11-05 11:14:43'),(282,7,2680.0000,'cash','credit','sell',420,'2023-11-05 11:32:58','2023-11-05 11:32:58'),(283,7,1300.0000,'cash','credit','sell',421,'2023-11-05 11:48:06','2023-11-05 11:48:06'),(284,7,3950.0000,'cash','credit','sell',422,'2023-11-05 11:49:02','2023-11-05 11:49:02'),(285,7,3150.0000,'cash','credit','sell',424,'2023-11-05 14:35:25','2023-11-05 14:35:25'),(286,7,2900.0000,'cash','credit','sell',426,'2023-11-05 14:51:07','2023-11-05 14:51:07'),(287,7,1450.0000,'cash','debit','refund',426,'2023-11-05 14:55:15','2023-11-05 14:55:15'),(288,7,1550.0000,'cash','credit','sell',428,'2023-11-05 16:46:56','2023-11-05 16:46:56'),(289,7,3150.0000,'cash','credit','sell',430,'2023-11-05 17:12:08','2023-11-05 17:12:08'),(290,7,24820.0000,'cash','credit','sell',433,'2023-11-05 17:19:16','2023-11-05 17:19:16'),(291,7,21000.0000,'cash','credit','sell',434,'2023-11-05 17:21:22','2023-11-05 17:21:22'),(292,8,488930.0000,'cash','credit','initial',NULL,'2023-11-05 17:33:47','2023-11-05 17:33:47'),(293,8,580.0000,'cash','debit','expense',436,'2023-11-05 17:41:32','2023-11-05 17:41:32'),(299,8,36450.0000,'cash','credit','sell',443,'2023-11-05 17:53:28','2023-11-05 17:53:28'),(300,8,3400.0000,'cash','credit','sell',444,'2023-11-05 17:55:31','2023-11-05 17:55:31'),(301,8,769.9500,'cash','credit','sell',445,'2023-11-05 17:56:43','2023-11-05 17:56:43'),(302,8,7200.0000,'cash','credit','sell',446,'2023-11-05 18:00:11','2023-11-05 18:00:11'),(303,8,4550.0000,'cash','credit','sell',447,'2023-11-05 18:21:30','2023-11-05 18:21:30'),(304,8,1302.0000,'cash','credit','sell',448,'2023-11-05 18:29:28','2023-11-05 18:29:28'),(305,8,121.2000,'cash','credit','sell',449,'2023-11-05 18:31:42','2023-11-05 18:31:42'),(306,8,2900.0000,'cash','credit','sell',450,'2023-11-05 18:32:31','2023-11-05 18:32:31'),(307,8,2880.0000,'cash','credit','sell',451,'2023-11-05 18:34:07','2023-11-05 18:34:07'),(308,8,2700.0000,'cash','credit','sell',452,'2023-11-05 19:28:36','2023-11-05 19:28:36'),(313,8,1500.0000,'cash','credit','sell',458,'2023-11-05 19:48:57','2023-11-05 19:48:57'),(314,8,1400.0000,'cash','credit','sell',459,'2023-11-05 19:53:41','2023-11-05 19:53:41'),(315,8,2450.0000,'cash','credit','sell',460,'2023-11-05 19:56:43','2023-11-05 19:56:43'),(316,8,352.0000,'cash','credit','sell',461,'2023-11-05 20:14:47','2023-11-05 20:14:47'),(317,8,700.0000,'cash','debit','expense',462,'2023-11-06 10:10:48','2023-11-06 10:10:48'),(318,8,24250.0000,'cash','credit','sell',463,'2023-11-06 10:16:21','2023-11-06 10:16:21'),(319,8,12830.0000,'cash','credit','sell',464,'2023-11-06 10:18:18','2023-11-06 10:18:18'),(320,8,1850.0000,'cash','credit','sell',465,'2023-11-06 10:23:33','2023-11-06 10:23:33'),(321,8,1500.0000,'cash','credit','sell',466,'2023-11-06 10:31:25','2023-11-06 10:31:25'),(322,8,1500.0000,'cash','credit','sell',467,'2023-11-06 11:29:21','2023-11-06 11:29:21'),(323,8,1480.0000,'cash','credit','sell',468,'2023-11-06 11:30:45','2023-11-06 11:30:45'),(324,8,7520.0000,'cash','credit','sell',469,'2023-11-06 11:32:56','2023-11-06 11:32:56'),(325,8,1250.0000,'cash','credit','sell',470,'2023-11-06 11:41:45','2023-11-06 11:41:45'),(326,8,2850.0000,'cash','credit','sell',471,'2023-11-06 11:42:39','2023-11-06 11:42:39'),(327,8,3040.0000,'cash','credit','sell',473,'2023-11-06 11:49:13','2023-11-06 11:49:13'),(328,8,2300.0000,'cash','credit','sell',474,'2023-11-06 12:05:19','2023-11-06 12:05:19'),(329,8,1550.0000,'cash','credit','sell',475,'2023-11-06 12:18:06','2023-11-06 12:18:06'),(330,8,1240.0000,'cash','credit','sell',476,'2023-11-06 12:34:05','2023-11-06 12:34:05'),(331,8,4150.0000,'cash','credit','sell',477,'2023-11-06 13:48:39','2023-11-06 13:48:39'),(335,8,8490.0000,'cash','credit','sell',481,'2023-11-06 13:52:37','2023-11-06 13:52:37'),(336,8,3250.0000,'cash','credit','sell',482,'2023-11-06 13:56:49','2023-11-06 13:56:49'),(338,8,350.0000,'cash','debit','expense',486,'2023-11-06 14:16:11','2023-11-06 14:16:11'),(339,8,4500.0000,'cash','credit','sell',489,'2023-11-06 14:18:07','2023-11-06 14:18:07'),(340,8,3300.0000,'cash','credit','sell',491,'2023-11-06 14:33:14','2023-11-06 14:33:14'),(341,8,4400.0000,'cash','debit','expense',492,'2023-11-06 14:45:30','2023-11-06 14:45:30'),(342,8,4560.0000,'cash','credit','sell',493,'2023-11-06 14:50:50','2023-11-06 14:50:50'),(343,8,15850.0000,'cash','credit','sell',496,'2023-11-06 17:09:50','2023-11-06 17:09:50'),(344,8,500.0000,'cash','debit','expense',498,'2023-11-06 17:32:57','2023-11-06 17:32:57'),(345,8,2600.0000,'cash','credit','sell',499,'2023-11-06 17:33:18','2023-11-06 17:33:18'),(346,8,2950.0000,'cash','credit','sell',500,'2023-11-06 17:36:59','2023-11-06 17:36:59'),(347,8,1250.0000,'cash','credit','sell',501,'2023-11-06 17:57:53','2023-11-06 17:57:53'),(348,8,1700.0000,'cash','credit','sell',502,'2023-11-06 18:03:19','2023-11-06 18:03:19'),(349,8,2480.0000,'cash','credit','sell',503,'2023-11-06 18:05:24','2023-11-06 18:05:24'),(350,8,1550.0000,'cash','credit','sell',504,'2023-11-06 18:31:44','2023-11-06 18:31:44'),(351,8,1500.0000,'cash','credit','sell',505,'2023-11-06 18:40:59','2023-11-06 18:40:59'),(352,8,1350.0000,'cash','credit','sell',506,'2023-11-06 18:41:42','2023-11-06 18:41:42'),(353,8,2600.0000,'cash','credit','sell',507,'2023-11-06 18:45:31','2023-11-06 18:45:31'),(354,8,1300.0000,'cash','credit','sell',508,'2023-11-06 18:47:18','2023-11-06 18:47:18'),(355,8,15538.8800,'cash','credit','sell',509,'2023-11-06 19:18:06','2023-11-06 19:18:06'),(356,8,1800.0000,'cash','credit','sell',510,'2023-11-06 19:26:52','2023-11-06 19:26:52'),(357,8,2000.0000,'cash','credit','sell',511,'2023-11-06 19:32:18','2023-11-06 19:32:18'),(358,8,2450.0000,'cash','credit','sell',512,'2023-11-06 19:36:43','2023-11-06 19:36:43'),(359,8,3250.0000,'cash','credit','sell',513,'2023-11-06 19:37:13','2023-11-06 19:37:13'),(360,8,3030.0000,'cash','credit','sell',514,'2023-11-06 19:44:03','2023-11-06 19:44:03'),(361,8,3400.0000,'cash','credit','sell',516,'2023-11-06 19:46:35','2023-11-06 19:46:35'),(362,8,1650.0000,'cash','credit','sell',518,'2023-11-06 19:50:51','2023-11-06 19:50:51'),(363,8,3100.0000,'cash','credit','sell',520,'2023-11-06 19:53:25','2023-11-06 19:53:25'),(364,9,177200.0000,'cash','credit','initial',NULL,'2023-11-06 20:09:24','2023-11-06 20:09:24'),(365,9,1350.0000,'cash','credit','sell',522,'2023-11-06 20:10:31','2023-11-06 20:10:31'),(366,9,1450.0000,'cash','credit','sell',523,'2023-11-06 20:10:57','2023-11-06 20:10:57'),(367,9,3400.0000,'cash','credit','sell',524,'2023-11-06 20:17:05','2023-11-06 20:17:05'),(368,9,1150.0000,'cash','credit','sell',525,'2023-11-06 20:21:29','2023-11-06 20:21:29'),(369,9,800.0000,'cash','debit','expense',526,'2023-11-07 10:16:34','2023-11-07 10:16:34'),(370,9,15000.0000,'cash','credit','sell',527,'2023-11-07 10:18:23','2023-11-07 10:18:23'),(371,9,2700.0000,'cash','credit','sell',529,'2023-11-07 10:20:10','2023-11-07 10:20:10'),(372,9,3040.0000,'cash','credit','sell',530,'2023-11-07 10:20:37','2023-11-07 10:20:37'),(373,9,1250.0000,'cash','credit','sell',531,'2023-11-07 10:27:02','2023-11-07 10:27:02'),(374,9,5750.0000,'cash','credit','sell',532,'2023-11-07 10:28:45','2023-11-07 10:28:45'),(376,9,5970.0000,'cash','credit','sell',535,'2023-11-07 10:44:26','2023-11-07 10:44:26'),(377,9,1400.0000,'cash','credit','sell',536,'2023-11-07 11:00:58','2023-11-07 11:00:58'),(378,9,3000.0000,'cash','credit','sell',539,'2023-11-07 11:18:27','2023-11-07 11:18:27'),(379,9,4400.0000,'cash','credit','sell',540,'2023-11-07 11:19:00','2023-11-07 11:19:00'),(380,9,3600.0000,'cash','credit','sell',541,'2023-11-07 11:45:26','2023-11-07 11:45:26'),(381,9,12250.0000,'cash','credit','sell',542,'2023-11-07 11:48:50','2023-11-07 11:48:50'),(382,9,5000.0000,'cash','credit','sell',543,'2023-11-07 14:18:53','2023-11-07 14:18:53'),(383,9,20030.0000,'cash','credit','sell',544,'2023-11-07 14:25:51','2023-11-07 14:25:51'),(384,9,5150.0000,'cash','credit','sell',545,'2023-11-07 14:27:24','2023-11-07 14:27:24'),(385,9,6200.0000,'cash','credit','sell',547,'2023-11-07 14:30:45','2023-11-07 14:30:45'),(386,9,2450.0000,'cash','credit','sell',548,'2023-11-07 14:59:06','2023-11-07 14:59:06'),(387,9,2750.0000,'cash','credit','sell',550,'2023-11-07 15:06:31','2023-11-07 15:06:31'),(388,9,3240.0000,'cash','credit','sell',551,'2023-11-07 15:08:39','2023-11-07 15:08:39'),(389,9,3300.0000,'cash','credit','sell',552,'2023-11-07 15:15:32','2023-11-07 15:15:32'),(390,9,2850.0000,'cash','credit','sell',553,'2023-11-07 16:45:07','2023-11-07 16:45:07'),(391,9,10640.0000,'cash','credit','sell',554,'2023-11-07 17:07:49','2023-11-07 17:07:49'),(392,9,16690.0000,'cash','credit','sell',556,'2023-11-07 17:11:52','2023-11-07 17:11:52'),(393,9,3350.0000,'cash','credit','sell',557,'2023-11-07 17:12:53','2023-11-07 17:12:53'),(394,9,200.0000,'cash','credit','sell',558,'2023-11-07 17:14:32','2023-11-07 17:14:32'),(395,9,2450.0000,'cash','credit','sell',559,'2023-11-07 17:21:46','2023-11-07 17:21:46'),(396,9,2125.0000,'cash','credit','sell',560,'2023-11-07 17:22:23','2023-11-07 17:22:23'),(397,9,3850.0000,'cash','credit','sell',561,'2023-11-07 17:27:29','2023-11-07 17:27:29'),(398,9,2700.0000,'cash','credit','sell',562,'2023-11-07 17:34:48','2023-11-07 17:34:48'),(399,9,650.0000,'cash','credit','sell',562,'2023-11-07 17:40:19','2023-11-07 17:40:19'),(400,9,1700.0000,'cash','credit','sell',563,'2023-11-07 17:54:16','2023-11-07 17:54:16'),(401,9,2600.0000,'cash','credit','sell',564,'2023-11-07 17:56:06','2023-11-07 17:56:06'),(402,9,1250.0000,'cash','credit','sell',565,'2023-11-07 17:58:20','2023-11-07 17:58:20'),(403,9,500.0000,'cash','debit','expense',566,'2023-11-07 18:08:06','2023-11-07 18:08:06'),(404,9,3040.0000,'cash','credit','sell',567,'2023-11-07 18:11:09','2023-11-07 18:11:09'),(405,9,65000.0000,'cash','credit','sell',568,'2023-11-07 18:17:13','2023-11-07 18:17:13'),(406,9,2600.0000,'cash','credit','sell',569,'2023-11-08 10:08:06','2023-11-08 10:08:06'),(407,9,20469.8000,'cash','credit','sell',570,'2023-11-08 10:20:29','2023-11-08 10:20:29'),(408,9,1230.0000,'cash','credit','sell',571,'2023-11-08 10:21:32','2023-11-08 10:21:32'),(409,9,19120.0000,'cash','credit','sell',572,'2023-11-08 10:23:29','2023-11-08 10:23:29'),(410,9,3250.0000,'cash','credit','sell',573,'2023-11-08 10:26:11','2023-11-08 10:26:11'),(411,9,12490.0000,'cash','credit','sell',574,'2023-11-08 10:28:49','2023-11-08 10:28:49'),(412,9,3000.0000,'cash','credit','sell',575,'2023-11-08 10:35:02','2023-11-08 10:35:02'),(413,9,4630.0000,'cash','credit','sell',576,'2023-11-08 11:03:14','2023-11-08 11:03:14'),(414,9,2200.0000,'cash','credit','sell',577,'2023-11-08 11:05:52','2023-11-08 11:05:52'),(415,9,1200.0000,'cash','credit','sell',578,'2023-11-08 11:11:27','2023-11-08 11:11:27'),(416,9,1500.0000,'cash','credit','sell',580,'2023-11-08 11:41:44','2023-11-08 11:41:44'),(417,9,3130.0000,'cash','credit','sell',581,'2023-11-08 12:01:15','2023-11-08 12:01:15'),(418,9,10000.0000,'cash','credit','sell',582,'2023-11-08 13:35:14','2023-11-08 13:35:14'),(420,9,9540.0000,'cash','credit','sell',584,'2023-11-08 13:41:58','2023-11-08 13:41:58'),(421,9,3280.0000,'cash','credit','sell',586,'2023-11-08 13:50:07','2023-11-08 13:50:07'),(422,9,3900.0000,'cash','credit','sell',587,'2023-11-08 13:50:36','2023-11-08 13:50:36'),(423,9,1530.0000,'cash','credit','sell',588,'2023-11-08 14:01:11','2023-11-08 14:01:11'),(424,9,4900.0000,'cash','credit','sell',589,'2023-11-08 14:18:19','2023-11-08 14:18:19'),(425,9,4520.0000,'cash','credit','sell',590,'2023-11-08 14:21:30','2023-11-08 14:21:30'),(426,9,11000.0000,'cash','credit','sell',579,'2023-11-08 14:22:38','2023-11-08 14:22:38'),(427,9,2980.0000,'cash','credit','sell',591,'2023-11-08 14:38:37','2023-11-08 14:38:37'),(428,9,1680.0000,'cash','credit','sell',592,'2023-11-08 17:31:03','2023-11-08 17:31:03'),(429,9,2750.0000,'cash','credit','sell',593,'2023-11-08 17:38:23','2023-11-08 17:38:23'),(430,9,3350.0000,'cash','credit','sell',595,'2023-11-08 17:44:28','2023-11-08 17:44:28'),(431,9,1700.0000,'cash','credit','sell',596,'2023-11-08 17:45:08','2023-11-08 17:45:08'),(432,9,11700.0000,'cash','credit','sell',598,'2023-11-08 17:47:56','2023-11-08 17:47:56'),(433,9,2280.0000,'cash','credit','sell',599,'2023-11-08 17:50:52','2023-11-08 17:50:52'),(434,9,360.0000,'cash','debit','expense',601,'2023-11-08 18:03:15','2023-11-08 18:03:15'),(435,9,7580.0000,'cash','credit','sell',602,'2023-11-08 18:09:30','2023-11-08 18:09:30'),(436,9,3000.0000,'cash','credit','sell',604,'2023-11-08 18:16:40','2023-11-08 18:16:40'),(437,9,3600.0000,'cash','credit','sell',605,'2023-11-08 18:32:42','2023-11-08 18:32:42'),(438,9,3000.0000,'cash','credit','sell',608,'2023-11-08 18:47:44','2023-11-08 18:47:44'),(439,9,1520.0000,'cash','credit','sell',609,'2023-11-08 18:54:48','2023-11-08 18:54:48'),(440,9,450.0000,'cash','debit','expense',610,'2023-11-08 19:27:09','2023-11-08 19:27:09'),(441,9,1700.0000,'cash','credit','sell',611,'2023-11-08 19:41:50','2023-11-08 19:41:50'),(442,9,1700.0000,'cash','credit','sell',612,'2023-11-08 19:50:37','2023-11-08 19:50:37'),(443,9,2600.0000,'cash','credit','sell',613,'2023-11-09 10:05:51','2023-11-09 10:05:51'),(444,9,23090.0000,'cash','credit','sell',615,'2023-11-09 10:20:40','2023-11-09 10:20:40'),(445,9,2800.0000,'cash','credit','sell',616,'2023-11-09 10:21:28','2023-11-09 10:21:28'),(446,9,2200.0000,'cash','credit','sell',617,'2023-11-09 10:26:14','2023-11-09 10:26:14'),(447,9,7510.0000,'cash','credit','sell',619,'2023-11-09 10:36:50','2023-11-09 10:36:50'),(448,9,1450.0000,'cash','credit','sell',620,'2023-11-09 10:41:40','2023-11-09 10:41:40'),(449,9,2850.0000,'cash','credit','sell',621,'2023-11-09 10:56:31','2023-11-09 10:56:31'),(450,9,1850.0000,'cash','credit','sell',622,'2023-11-09 10:57:47','2023-11-09 10:57:47'),(451,9,8350.0000,'cash','credit','sell',623,'2023-11-09 11:03:39','2023-11-09 11:03:39'),(452,9,1650.0000,'cash','credit','sell',624,'2023-11-09 12:13:53','2023-11-09 12:13:53'),(453,9,11880.0000,'cash','credit','sell',625,'2023-11-09 12:15:48','2023-11-09 12:15:48'),(454,9,3200.0000,'cash','credit','sell',626,'2023-11-09 12:21:19','2023-11-09 12:21:19'),(455,9,4000.0000,'cash','credit','sell',627,'2023-11-09 12:31:41','2023-11-09 12:31:41'),(456,9,2450.0000,'cash','credit','sell',629,'2023-11-09 12:46:22','2023-11-09 12:46:22'),(457,9,3400.0000,'cash','credit','sell',630,'2023-11-09 12:47:02','2023-11-09 12:47:02'),(458,9,800.0000,'cash','credit','sell',631,'2023-11-09 12:52:43','2023-11-09 12:52:43'),(459,9,5900.0000,'cash','credit','sell',634,'2023-11-09 13:41:37','2023-11-09 13:41:37'),(460,9,2750.0000,'cash','credit','sell',635,'2023-11-09 13:42:15','2023-11-09 13:42:15'),(461,9,1000.0000,'cash','debit','expense',636,'2023-11-09 13:55:21','2023-11-09 13:55:21'),(462,9,2850.0000,'cash','credit','sell',637,'2023-11-09 13:59:50','2023-11-09 13:59:50'),(463,9,7520.0000,'cash','credit','sell',638,'2023-11-09 14:09:59','2023-11-09 14:09:59'),(464,9,450.0000,'cash','debit','expense',639,'2023-11-09 14:30:13','2023-11-09 14:30:13'),(465,9,3400.0000,'cash','credit','sell',640,'2023-11-09 14:36:42','2023-11-09 14:36:42'),(466,9,29170.0000,'cash','credit','sell',641,'2023-11-09 17:11:52','2023-11-09 17:11:52'),(467,9,36120.0000,'cash','credit','sell',642,'2023-11-09 17:14:12','2023-11-09 17:14:12'),(468,9,1000.0000,'cash','credit','sell',643,'2023-11-09 17:16:40','2023-11-09 17:16:40'),(469,9,2450.0000,'cash','credit','sell',644,'2023-11-09 17:16:58','2023-11-09 17:16:58'),(470,9,2450.0000,'cash','credit','sell',645,'2023-11-09 17:40:51','2023-11-09 17:40:51'),(471,9,2800.0000,'cash','credit','sell',646,'2023-11-09 17:43:25','2023-11-09 17:43:25'),(472,9,3100.0000,'cash','credit','sell',647,'2023-11-09 17:48:46','2023-11-09 17:48:46'),(473,9,1380.0000,'cash','credit','sell',648,'2023-11-09 18:01:23','2023-11-09 18:01:23'),(474,9,1450.0000,'cash','credit','sell',651,'2023-11-09 18:29:11','2023-11-09 18:29:11'),(475,9,6220.0000,'cash','credit','sell',652,'2023-11-09 18:42:10','2023-11-09 18:42:10'),(476,9,1650.0000,'cash','credit','sell',655,'2023-11-09 19:05:01','2023-11-09 19:05:01'),(477,9,1550.0000,'cash','credit','sell',656,'2023-11-09 19:21:05','2023-11-09 19:21:05'),(478,9,1700.0000,'cash','credit','sell',658,'2023-11-09 19:27:05','2023-11-09 19:27:05'),(479,9,3150.0000,'cash','credit','sell',660,'2023-11-09 19:31:45','2023-11-09 19:31:45'),(480,9,3280.0000,'cash','credit','sell',661,'2023-11-09 19:33:17','2023-11-09 19:33:17'),(481,9,1650.0000,'cash','credit','sell',662,'2023-11-09 19:36:58','2023-11-09 19:36:58'),(482,9,240.0000,'cash','credit','sell',663,'2023-11-09 19:43:09','2023-11-09 19:43:09'),(483,9,300.0000,'cash','debit','expense',664,'2023-11-09 19:48:31','2023-11-09 19:48:31'),(484,9,60.0000,'cash','credit','sell',665,'2023-11-09 19:51:27','2023-11-09 19:51:27'),(485,9,2200.0000,'cash','credit','sell',666,'2023-11-09 19:51:42','2023-11-09 19:51:42'),(486,9,3000.0000,'cash','credit','sell',667,'2023-11-09 19:52:16','2023-11-09 19:52:16'),(487,9,2530.0000,'cash','credit','sell',668,'2023-11-09 19:52:55','2023-11-09 19:52:55'),(488,9,180.0000,'cash','credit','sell',669,'2023-11-09 19:54:10','2023-11-09 19:54:10'),(489,9,1680.0000,'cash','credit','sell',670,'2023-11-09 19:57:17','2023-11-09 19:57:17'),(490,9,4000.0000,'cash','debit','expense',671,'2023-11-09 20:01:00','2023-11-09 20:01:00'),(491,9,700.0000,'cash','debit','expense',672,'2023-11-09 20:01:49','2023-11-09 20:01:49'),(492,9,2750.0000,'cash','credit','sell',673,'2023-11-09 20:02:40','2023-11-09 20:02:40'),(493,9,3000.0000,'cash','credit','sell',674,'2023-11-11 10:17:30','2023-11-11 10:17:30'),(494,9,1000.0000,'cash','debit','expense',675,'2023-11-11 10:20:45','2023-11-11 10:20:45'),(495,9,12020.0000,'cash','credit','sell',676,'2023-11-11 10:23:18','2023-11-11 10:23:18'),(496,9,22310.0000,'cash','credit','sell',677,'2023-11-11 10:27:25','2023-11-11 10:27:25'),(497,9,8500.0000,'cash','credit','sell',678,'2023-11-11 10:28:26','2023-11-11 10:28:26'),(498,9,3100.0000,'cash','credit','sell',680,'2023-11-11 10:32:39','2023-11-11 10:32:39'),(499,9,3570.0000,'cash','credit','sell',682,'2023-11-11 10:35:22','2023-11-11 10:35:22'),(500,9,1380.0000,'cash','credit','sell',683,'2023-11-11 10:40:01','2023-11-11 10:40:01'),(501,9,3300.0000,'cash','credit','sell',686,'2023-11-11 10:59:18','2023-11-11 10:59:18'),(502,9,1650.0000,'cash','credit','sell',687,'2023-11-11 11:12:04','2023-11-11 11:12:04'),(503,9,3000.0000,'cash','credit','sell',688,'2023-11-11 11:12:40','2023-11-11 11:12:40'),(504,9,240.0000,'cash','credit','sell',689,'2023-11-11 11:16:58','2023-11-11 11:16:58'),(505,9,2850.0000,'cash','credit','sell',690,'2023-11-11 11:23:45','2023-11-11 11:23:45'),(506,9,5050.0000,'cash','credit','sell',691,'2023-11-11 11:30:56','2023-11-11 11:30:56'),(507,9,1900.0000,'cash','credit','sell',693,'2023-11-11 11:43:38','2023-11-11 11:43:38'),(508,9,2000.0000,'cash','credit','sell',694,'2023-11-11 11:53:37','2023-11-11 11:53:37'),(509,9,1800.0000,'cash','credit','sell',696,'2023-11-11 12:06:54','2023-11-11 12:06:54'),(510,9,1630.0000,'cash','credit','sell',698,'2023-11-11 12:33:50','2023-11-11 12:33:50'),(511,9,2200.0000,'cash','credit','sell',699,'2023-11-11 12:36:53','2023-11-11 12:36:53'),(512,9,150.0000,'cash','debit','expense',700,'2023-11-11 13:25:13','2023-11-11 13:25:13'),(513,9,1800.0000,'cash','credit','sell',701,'2023-11-11 13:35:04','2023-11-11 13:35:04'),(514,9,3200.0000,'cash','credit','sell',702,'2023-11-11 13:52:26','2023-11-11 13:52:26'),(515,9,2900.0000,'cash','credit','sell',703,'2023-11-11 13:54:28','2023-11-11 13:54:28'),(516,9,1780.0000,'cash','credit','sell',704,'2023-11-11 14:07:40','2023-11-11 14:07:40'),(517,9,5350.0000,'cash','credit','sell',705,'2023-11-11 14:09:38','2023-11-11 14:09:38'),(518,9,1640.0000,'cash','credit','sell',706,'2023-11-11 14:15:58','2023-11-11 14:15:58'),(519,9,1640.0000,'cash','credit','sell',707,'2023-11-11 14:16:33','2023-11-11 14:16:33'),(520,9,14800.0000,'cash','credit','sell',708,'2023-11-11 14:22:21','2023-11-11 14:22:21'),(521,9,4350.0000,'cash','credit','sell',709,'2023-11-11 14:26:52','2023-11-11 14:26:52'),(522,9,1450.0000,'cash','credit','sell',710,'2023-11-11 14:27:06','2023-11-11 14:27:06'),(523,9,2700.0000,'cash','credit','sell',711,'2023-11-11 14:29:53','2023-11-11 14:29:53'),(524,9,5400.0000,'cash','credit','sell',712,'2023-11-11 14:36:14','2023-11-11 14:36:14'),(525,9,1680.0000,'cash','credit','sell',713,'2023-11-11 14:39:29','2023-11-11 14:39:29'),(526,9,1090.0000,'cash','debit','expense',717,'2023-11-11 17:49:52','2023-11-11 17:49:52'),(527,9,5400.0000,'cash','credit','sell',718,'2023-11-11 17:51:34','2023-11-11 17:51:34'),(528,9,2500.0000,'cash','credit','sell',719,'2023-11-11 17:54:02','2023-11-11 17:54:02'),(529,9,91163.2500,'cash','credit','sell',721,'2023-11-11 18:02:45','2023-11-11 18:02:45'),(530,9,12780.0000,'cash','credit','sell',722,'2023-11-11 18:04:20','2023-11-11 18:04:20'),(531,9,500.0000,'cash','credit','sell',724,'2023-11-11 18:08:28','2023-11-11 18:08:28'),(532,9,21660.0000,'cash','credit','sell',725,'2023-11-11 18:11:51','2023-11-11 18:11:51'),(533,9,9000.0000,'cash','credit','sell',726,'2023-11-11 18:13:27','2023-11-11 18:13:27'),(534,9,6000.0000,'cash','credit','sell',727,'2023-11-11 18:14:00','2023-11-11 18:14:00'),(535,9,3300.0000,'cash','credit','sell',728,'2023-11-11 18:24:23','2023-11-11 18:24:23'),(536,9,1300.0000,'cash','credit','sell',729,'2023-11-11 18:43:11','2023-11-11 18:43:11'),(537,9,270.0000,'cash','debit','expense',730,'2023-11-11 19:07:12','2023-11-11 19:07:12'),(538,9,2700.0000,'cash','credit','sell',731,'2023-11-11 19:08:29','2023-11-11 19:08:29'),(539,9,2900.0000,'cash','credit','sell',732,'2023-11-11 19:09:49','2023-11-11 19:09:49'),(540,9,380.0000,'cash','credit','sell',733,'2023-11-11 19:18:05','2023-11-11 19:18:05'),(541,9,1620.0000,'cash','credit','sell',734,'2023-11-11 19:22:43','2023-11-11 19:22:43'),(542,9,2700.0000,'cash','credit','sell',735,'2023-11-11 19:33:30','2023-11-11 19:33:30'),(543,9,1700.0000,'cash','credit','sell',736,'2023-11-11 19:35:28','2023-11-11 19:35:28'),(544,9,2850.0000,'cash','credit','sell',737,'2023-11-11 19:36:29','2023-11-11 19:36:29'),(545,9,1400.0000,'cash','credit','sell',738,'2023-11-11 19:51:42','2023-11-11 19:51:42'),(546,9,1380.0000,'cash','credit','sell',739,'2023-11-11 19:56:19','2023-11-11 19:56:19'),(547,9,13670.0000,'cash','credit','sell',740,'2023-11-11 20:27:33','2023-11-11 20:27:33'),(548,9,700.0000,'cash','debit','expense',741,'2023-11-11 20:28:30','2023-11-11 20:28:30'),(549,9,2850.0000,'cash','credit','sell',742,'2023-11-12 10:29:32','2023-11-12 10:29:32'),(550,9,1600.0000,'cash','credit','sell',743,'2023-11-12 10:33:00','2023-11-12 10:33:00'),(551,9,2480.0000,'cash','credit','sell',744,'2023-11-12 10:48:42','2023-11-12 10:48:42'),(552,9,5840.0000,'cash','credit','sell',745,'2023-11-12 10:51:55','2023-11-12 10:51:55'),(553,9,5015.0000,'cash','credit','sell',746,'2023-11-12 10:54:39','2023-11-12 10:54:39'),(554,9,1750.0000,'cash','credit','sell',747,'2023-11-12 10:54:56','2023-11-12 10:54:56'),(555,9,9800.0000,'cash','credit','sell',748,'2023-11-12 10:56:34','2023-11-12 10:56:34'),(556,9,1200.0000,'cash','credit','sell',749,'2023-11-12 10:56:55','2023-11-12 10:56:55'),(557,9,4900.0000,'cash','credit','sell',750,'2023-11-12 10:57:25','2023-11-12 10:57:25'),(558,9,2750.0000,'cash','credit','sell',752,'2023-11-12 11:07:58','2023-11-12 11:07:58'),(559,9,2650.0000,'cash','credit','sell',753,'2023-11-12 11:29:27','2023-11-12 11:29:27'),(560,9,1000.0000,'cash','credit','sell',755,'2023-11-12 12:01:37','2023-11-12 12:01:37'),(561,9,1800.0000,'cash','credit','sell',756,'2023-11-12 12:02:44','2023-11-12 12:02:44'),(562,9,2950.0000,'cash','credit','sell',757,'2023-11-12 12:03:44','2023-11-12 12:03:44'),(563,9,2450.0000,'cash','credit','sell',758,'2023-11-12 12:05:49','2023-11-12 12:05:49'),(564,9,2950.0000,'cash','debit','refund',757,'2023-11-12 12:09:22','2023-11-12 12:09:22'),(565,9,2000.0000,'cash','debit','expense',759,'2023-11-12 12:12:26','2023-11-12 12:12:26'),(566,9,3000.0000,'cash','debit','expense',760,'2023-11-12 12:12:49','2023-11-12 12:12:49'),(567,9,2800.0000,'cash','credit','sell',762,'2023-11-12 14:15:30','2023-11-12 14:15:30'),(568,9,1300.0000,'cash','credit','sell',763,'2023-11-12 14:29:29','2023-11-12 14:29:29'),(569,9,2850.0000,'cash','credit','sell',764,'2023-11-12 14:54:01','2023-11-12 14:54:01'),(570,9,240.0000,'cash','credit','sell',765,'2023-11-12 14:56:03','2023-11-12 14:56:03'),(571,9,1800.0000,'cash','credit','sell',766,'2023-11-12 14:56:28','2023-11-12 14:56:28'),(572,9,14680.0000,'cash','credit','sell',767,'2023-11-12 17:35:27','2023-11-12 17:35:27'),(573,9,4950.0000,'cash','credit','sell',768,'2023-11-12 17:36:12','2023-11-12 17:36:12'),(574,9,3400.0000,'cash','credit','sell',769,'2023-11-12 17:42:10','2023-11-12 17:42:10'),(575,9,57900.0000,'cash','credit','sell',770,'2023-11-12 17:53:01','2023-11-12 17:53:01'),(576,9,1380.0000,'cash','credit','sell',771,'2023-11-12 17:59:49','2023-11-12 17:59:49'),(577,9,1380.0000,'cash','credit','sell',772,'2023-11-12 18:00:33','2023-11-12 18:00:33'),(578,9,200.0000,'cash','credit','sell',773,'2023-11-12 18:04:31','2023-11-12 18:04:31'),(579,9,340.0000,'cash','debit','expense',774,'2023-11-12 18:06:19','2023-11-12 18:06:19'),(580,9,350.0000,'cash','debit','expense',775,'2023-11-12 18:13:11','2023-11-12 18:13:11'),(581,9,3080.0000,'cash','credit','sell',776,'2023-11-12 18:22:08','2023-11-12 18:22:08'),(582,9,1380.0000,'cash','credit','sell',777,'2023-11-12 18:42:48','2023-11-12 18:42:48'),(583,9,3050.0000,'cash','credit','sell',778,'2023-11-12 18:46:25','2023-11-12 18:46:25'),(584,9,4500.0000,'cash','credit','sell',779,'2023-11-12 19:07:57','2023-11-12 19:07:57'),(585,9,1480.0000,'cash','credit','sell',780,'2023-11-12 19:20:32','2023-11-12 19:20:32'),(586,9,2200.0000,'cash','credit','sell',781,'2023-11-12 19:28:49','2023-11-12 19:28:49'),(587,9,3150.0000,'cash','credit','sell',782,'2023-11-12 19:56:34','2023-11-12 19:56:34'),(588,9,2580.0000,'cash','credit','sell',783,'2023-11-12 19:59:20','2023-11-12 19:59:20'),(589,9,2200.0000,'cash','credit','sell',784,'2023-11-12 20:11:52','2023-11-12 20:11:52'),(590,9,2850.0000,'cash','credit','sell',785,'2023-11-12 20:13:56','2023-11-12 20:13:56'),(591,9,1300.0000,'cash','credit','sell',786,'2023-11-12 20:18:48','2023-11-12 20:18:48'),(592,9,800.0000,'cash','credit','sell',787,'2023-11-12 20:33:36','2023-11-12 20:33:36'),(593,9,2600.0000,'cash','credit','sell',788,'2023-11-12 20:39:20','2023-11-12 20:39:20'),(594,9,3550.0000,'cash','credit','sell',789,'2023-11-12 20:45:43','2023-11-12 20:45:43'),(595,9,150.0000,'cash','debit','expense',790,'2023-11-12 20:47:11','2023-11-12 20:47:11'),(596,9,1150.0000,'cash','credit','sell',791,'2023-11-12 20:58:26','2023-11-12 20:58:26'),(597,9,2700.0000,'cash','credit','sell',792,'2023-11-13 10:30:01','2023-11-13 10:30:01'),(598,9,3330.0000,'cash','credit','sell',793,'2023-11-13 10:38:16','2023-11-13 10:38:16'),(599,9,1700.0000,'cash','credit','sell',794,'2023-11-13 10:43:09','2023-11-13 10:43:09'),(600,9,340.0000,'cash','debit','expense',796,'2023-11-13 11:13:19','2023-11-13 11:13:19'),(601,9,3300.0000,'cash','credit','sell',797,'2023-11-13 11:15:39','2023-11-13 11:15:39'),(602,9,2600.0000,'cash','credit','sell',798,'2023-11-13 11:37:10','2023-11-13 11:37:10'),(603,9,1280.0000,'cash','credit','sell',799,'2023-11-13 11:43:56','2023-11-13 11:43:56'),(604,9,2200.0000,'cash','credit','sell',800,'2023-11-13 12:13:36','2023-11-13 12:13:36'),(605,9,4120.0000,'cash','credit','sell',801,'2023-11-13 12:35:30','2023-11-13 12:35:30'),(606,9,2000.0000,'cash','credit','sell',802,'2023-11-13 12:44:14','2023-11-13 12:44:14'),(607,9,2450.0000,'cash','credit','sell',803,'2023-11-13 12:45:59','2023-11-13 12:45:59'),(608,9,1380.0000,'cash','credit','sell',807,'2023-11-13 13:44:10','2023-11-13 13:44:10'),(609,9,1380.0000,'cash','credit','sell',808,'2023-11-13 14:05:34','2023-11-13 14:05:34'),(610,9,3000.0000,'cash','credit','sell',809,'2023-11-13 14:14:22','2023-11-13 14:14:22'),(611,9,1630.0000,'cash','credit','sell',810,'2023-11-13 14:37:38','2023-11-13 14:37:38'),(612,9,7750.0000,'cash','credit','sell',812,'2023-11-13 14:53:58','2023-11-13 14:53:58'),(613,9,2170.0000,'cash','credit','sell',814,'2023-11-13 14:58:09','2023-11-13 14:58:09'),(614,9,3400.0000,'cash','credit','sell',816,'2023-11-13 19:13:25','2023-11-13 19:13:25'),(615,9,2480.0000,'cash','credit','sell',817,'2023-11-13 19:19:59','2023-11-13 19:19:59'),(616,9,770.0000,'cash','debit','expense',818,'2023-11-13 19:20:59','2023-11-13 19:20:59'),(617,9,15950.0000,'cash','credit','sell',819,'2023-11-13 19:26:16','2023-11-13 19:26:16'),(618,9,53200.0000,'cash','credit','sell',820,'2023-11-13 19:29:12','2023-11-13 19:29:12'),(619,9,12289.9200,'cash','credit','sell',821,'2023-11-13 19:34:07','2023-11-13 19:34:07'),(620,9,5950.0000,'cash','credit','sell',822,'2023-11-13 19:36:43','2023-11-13 19:36:43'),(621,9,6150.0000,'cash','credit','sell',823,'2023-11-13 19:47:54','2023-11-13 19:47:54'),(622,9,1350.0000,'cash','credit','sell',824,'2023-11-13 19:53:40','2023-11-13 19:53:40'),(623,9,4600.0000,'cash','credit','sell',825,'2023-11-13 20:01:37','2023-11-13 20:01:37'),(624,9,100.0000,'cash','debit','expense',826,'2023-11-13 20:08:21','2023-11-13 20:08:21'),(625,9,1400.0000,'cash','debit','expense',827,'2023-11-13 20:10:06','2023-11-13 20:10:06'),(626,9,1400.0000,'cash','credit','sell',828,'2023-11-13 20:15:36','2023-11-13 20:15:36'),(627,9,12259.9800,'cash','credit','sell',829,'2023-11-14 10:22:55','2023-11-14 10:22:55'),(628,9,3930.0000,'cash','credit','sell',830,'2023-11-14 10:24:14','2023-11-14 10:24:14'),(629,9,11500.0000,'cash','credit','sell',831,'2023-11-14 10:26:14','2023-11-14 10:26:14'),(630,9,2200.0000,'cash','credit','sell',832,'2023-11-14 10:26:49','2023-11-14 10:26:49'),(631,9,1300.0000,'cash','credit','sell',833,'2023-11-14 10:32:41','2023-11-14 10:32:41'),(632,9,1800.0000,'cash','credit','sell',834,'2023-11-14 10:35:19','2023-11-14 10:35:19'),(633,9,13000.0000,'cash','credit','sell',835,'2023-11-14 10:51:22','2023-11-14 10:51:22'),(634,9,3150.0000,'cash','credit','sell',836,'2023-11-14 10:53:53','2023-11-14 10:53:53'),(635,9,1380.0000,'cash','credit','sell',837,'2023-11-14 11:05:44','2023-11-14 11:05:44'),(636,9,4650.0000,'cash','credit','sell',838,'2023-11-14 12:19:48','2023-11-14 12:19:48'),(637,9,1700.0000,'cash','credit','sell',839,'2023-11-14 12:34:22','2023-11-14 12:34:22'),(638,9,3000.0000,'cash','credit','sell',840,'2023-11-14 12:36:22','2023-11-14 12:36:22'),(639,9,28340.0000,'cash','credit','sell',841,'2023-11-14 12:46:28','2023-11-14 12:46:28'),(640,9,7420.0000,'cash','credit','sell',842,'2023-11-14 13:22:02','2023-11-14 13:22:02'),(641,9,2450.0000,'cash','credit','sell',845,'2023-11-14 13:40:53','2023-11-14 13:40:53'),(642,9,1770.0000,'cash','credit','sell',846,'2023-11-14 13:56:37','2023-11-14 13:56:37'),(643,9,700.0000,'cash','credit','sell',847,'2023-11-14 13:59:01','2023-11-14 13:59:01'),(644,9,7500.0000,'cash','credit','sell',848,'2023-11-14 14:00:17','2023-11-14 14:00:17'),(645,9,2700.0000,'cash','credit','sell',849,'2023-11-14 14:02:00','2023-11-14 14:02:00'),(646,9,3400.0000,'cash','credit','sell',850,'2023-11-14 14:12:38','2023-11-14 14:12:38'),(647,9,400.0000,'cash','debit','expense',851,'2023-11-14 14:16:53','2023-11-14 14:16:53'),(648,9,4650.0000,'cash','credit','sell',852,'2023-11-14 14:24:38','2023-11-14 14:24:38'),(649,9,1775.0000,'cash','credit','sell',853,'2023-11-14 14:54:05','2023-11-14 14:54:05'),(650,9,1180.0000,'cash','credit','sell',854,'2023-11-14 17:43:29','2023-11-14 17:43:29'),(651,9,800.0000,'cash','debit','expense',856,'2023-11-14 17:48:53','2023-11-14 17:48:53'),(652,9,26160.0000,'cash','credit','sell',857,'2023-11-14 17:53:44','2023-11-14 17:53:44'),(653,9,22500.0000,'cash','credit','sell',858,'2023-11-14 17:57:38','2023-11-14 17:57:38'),(654,9,3639.5100,'cash','credit','sell',859,'2023-11-14 17:58:25','2023-11-14 17:58:25'),(655,9,1280.0000,'cash','credit','sell',861,'2023-11-14 18:07:15','2023-11-14 18:07:15'),(656,9,2930.0000,'cash','credit','sell',862,'2023-11-14 18:09:36','2023-11-14 18:09:36'),(657,9,3180.0000,'cash','credit','sell',863,'2023-11-14 18:25:47','2023-11-14 18:25:47'),(658,9,1650.0000,'cash','credit','sell',864,'2023-11-14 18:29:39','2023-11-14 18:29:39'),(659,9,2850.0000,'cash','credit','sell',866,'2023-11-14 18:32:52','2023-11-14 18:32:52'),(660,9,3400.0000,'cash','credit','sell',867,'2023-11-14 18:45:45','2023-11-14 18:45:45'),(661,9,3350.0000,'cash','credit','sell',868,'2023-11-14 18:48:55','2023-11-14 18:48:55'),(662,9,3350.0000,'cash','credit','sell',869,'2023-11-14 18:50:29','2023-11-14 18:50:29'),(663,9,5700.0000,'cash','credit','sell',870,'2023-11-14 19:36:46','2023-11-14 19:36:46'),(664,9,2450.0000,'cash','credit','sell',872,'2023-11-14 20:08:38','2023-11-14 20:08:38'),(665,9,100.0000,'cash','debit','expense',873,'2023-11-14 20:15:27','2023-11-14 20:15:27'),(666,9,700.0000,'cash','debit','expense',874,'2023-11-14 20:15:53','2023-11-14 20:15:53'),(667,9,2700.0000,'cash','credit','sell',875,'2023-11-15 10:27:50','2023-11-15 10:27:50'),(668,9,2200.0000,'cash','credit','sell',876,'2023-11-15 10:29:46','2023-11-15 10:29:46'),(669,9,2730.0000,'cash','credit','sell',877,'2023-11-15 10:31:23','2023-11-15 10:31:23'),(670,9,15600.0000,'cash','credit','sell',878,'2023-11-15 10:35:53','2023-11-15 10:35:53'),(671,9,1500.0000,'cash','credit','sell',879,'2023-11-15 10:38:37','2023-11-15 10:38:37'),(672,9,3000.0000,'cash','credit','sell',880,'2023-11-15 10:40:45','2023-11-15 10:40:45'),(673,9,2200.0000,'cash','credit','sell',881,'2023-11-15 10:49:01','2023-11-15 10:49:01'),(674,9,1300.0000,'cash','credit','sell',883,'2023-11-15 10:51:25','2023-11-15 10:51:25'),(675,9,17030.0000,'cash','credit','sell',884,'2023-11-15 10:55:53','2023-11-15 10:55:53'),(676,9,43371.3300,'cash','credit','sell',885,'2023-11-15 11:18:45','2023-11-15 11:18:45'),(677,9,2200.0000,'cash','credit','sell',886,'2023-11-15 11:21:21','2023-11-15 11:21:21'),(678,9,2970.0000,'cash','credit','sell',887,'2023-11-15 11:24:15','2023-11-15 11:24:15'),(679,9,1680.0000,'cash','credit','sell',888,'2023-11-15 12:16:10','2023-11-15 12:16:10'),(680,9,4300.0000,'cash','credit','sell',889,'2023-11-15 12:24:47','2023-11-15 12:24:47'),(681,9,775.0000,'cash','credit','sell',890,'2023-11-15 12:25:39','2023-11-15 12:25:39'),(682,9,5960.0000,'cash','credit','sell',893,'2023-11-15 12:35:23','2023-11-15 12:35:23'),(683,9,1700.0000,'cash','credit','sell',894,'2023-11-15 12:41:34','2023-11-15 12:41:34'),(684,9,3070.0000,'cash','credit','sell',895,'2023-11-15 12:49:14','2023-11-15 12:49:14'),(685,9,1650.0000,'cash','credit','sell',896,'2023-11-15 12:50:06','2023-11-15 12:50:06'),(686,9,5050.0000,'cash','credit','sell',897,'2023-11-15 14:00:53','2023-11-15 14:00:53'),(687,9,7860.0000,'cash','credit','sell',898,'2023-11-15 14:01:54','2023-11-15 14:01:54'),(688,9,340.0000,'cash','debit','expense',900,'2023-11-15 14:13:15','2023-11-15 14:13:15'),(689,9,6000.0000,'cash','credit','sell',901,'2023-11-15 14:15:39','2023-11-15 14:15:39'),(690,9,4000.0000,'cash','credit','sell',903,'2023-11-15 14:22:19','2023-11-15 14:22:19'),(691,9,4400.0000,'cash','credit','sell',904,'2023-11-15 14:45:46','2023-11-15 14:45:46'),(692,9,1650.0000,'cash','credit','sell',905,'2023-11-15 14:52:00','2023-11-15 14:52:00'),(693,9,1280.0000,'cash','credit','sell',906,'2023-11-15 14:55:33','2023-11-15 14:55:33'),(694,9,1680.0000,'cash','credit','sell',907,'2023-11-15 17:34:12','2023-11-15 17:34:12'),(695,9,10630.0000,'cash','credit','sell',908,'2023-11-15 18:05:21','2023-11-15 18:05:21'),(696,9,14400.0000,'cash','credit','sell',909,'2023-11-15 18:07:02','2023-11-15 18:07:02'),(697,9,2600.0000,'cash','credit','sell',910,'2023-11-15 18:26:39','2023-11-15 18:26:39'),(698,9,1700.0000,'cash','credit','sell',911,'2023-11-15 18:36:07','2023-11-15 18:36:07'),(699,9,8800.0000,'cash','credit','sell',912,'2023-11-15 18:37:21','2023-11-15 18:37:21'),(700,9,-4400.0000,'cash','credit','sell',912,'2023-11-15 18:37:21','2023-11-15 18:37:21'),(701,9,1450.0000,'cash','credit','sell',913,'2023-11-15 18:40:57','2023-11-15 18:40:57'),(702,9,3600.0000,'cash','credit','sell',914,'2023-11-15 19:24:24','2023-11-15 19:24:24'),(703,9,2900.0000,'cash','credit','sell',916,'2023-11-16 11:21:13','2023-11-16 11:21:13'),(704,9,1650.0000,'cash','credit','sell',917,'2023-11-16 11:21:45','2023-11-16 11:21:45'),(705,9,1850.0000,'cash','credit','sell',918,'2023-11-16 11:33:36','2023-11-16 11:33:36'),(706,9,1750.0000,'cash','credit','sell',919,'2023-11-16 11:52:28','2023-11-16 11:52:28'),(707,9,18450.0000,'cash','credit','sell',920,'2023-11-16 12:09:23','2023-11-16 12:09:23'),(708,9,13350.0000,'cash','credit','sell',922,'2023-11-16 12:13:13','2023-11-16 12:13:13'),(709,9,34500.0000,'cash','credit','sell',923,'2023-11-16 12:14:37','2023-11-16 12:14:37'),(710,9,13400.0000,'cash','credit','sell',924,'2023-11-16 12:16:45','2023-11-16 12:16:45'),(711,9,2500.0000,'cash','credit','sell',926,'2023-11-16 12:18:10','2023-11-16 12:18:10'),(712,9,1500.0000,'cash','credit','sell',927,'2023-11-16 12:29:03','2023-11-16 12:29:03'),(713,9,1650.0000,'cash','credit','sell',929,'2023-11-16 12:53:33','2023-11-16 12:53:33'),(714,9,10270.0000,'cash','credit','sell',930,'2023-11-16 13:24:12','2023-11-16 13:24:12'),(715,9,2150.0000,'cash','credit','sell',932,'2023-11-16 13:58:46','2023-11-16 13:58:46'),(716,9,1000.0000,'cash','debit','expense',933,'2023-11-16 17:01:40','2023-11-16 17:01:40'),(717,9,2750.0000,'cash','credit','sell',934,'2023-11-16 17:04:10','2023-11-16 17:04:10'),(718,9,520.0000,'cash','debit','expense',936,'2023-11-16 17:07:22','2023-11-16 17:07:22'),(719,9,1300.0000,'cash','credit','sell',937,'2023-11-16 17:11:03','2023-11-16 17:11:03'),(720,9,5500.0000,'cash','credit','sell',938,'2023-11-16 17:11:37','2023-11-16 17:11:37'),(721,9,15600.0000,'cash','credit','sell',939,'2023-11-16 17:12:27','2023-11-16 17:12:27'),(722,9,2900.0000,'cash','credit','sell',940,'2023-11-16 17:13:00','2023-11-16 17:13:00'),(723,9,10350.0000,'cash','credit','sell',941,'2023-11-16 17:14:29','2023-11-16 17:14:29'),(724,9,1300.0000,'cash','credit','sell',942,'2023-11-16 17:15:00','2023-11-16 17:15:00'),(725,9,1000.0000,'cash','debit','expense',943,'2023-11-16 17:18:25','2023-11-16 17:18:25'),(726,9,1500.0000,'cash','credit','sell',944,'2023-11-16 17:21:37','2023-11-16 17:21:37'),(727,9,1000.0000,'cash','credit','sell',945,'2023-11-16 17:28:02','2023-11-16 17:28:02'),(728,9,1200.0000,'cash','credit','sell',945,'2023-11-16 17:33:07','2023-11-16 17:33:07'),(729,9,2450.0000,'cash','credit','sell',946,'2023-11-16 17:49:36','2023-11-16 17:49:36'),(730,9,200.0000,'cash','credit','sell',947,'2023-11-16 18:02:49','2023-11-16 18:02:49'),(731,9,60.0000,'cash','debit','expense',948,'2023-11-16 18:06:23','2023-11-16 18:06:23'),(732,9,1900.0000,'cash','credit','sell',949,'2023-11-16 18:14:57','2023-11-16 18:14:57'),(733,9,1800.0000,'cash','credit','sell',950,'2023-11-16 18:24:49','2023-11-16 18:24:49'),(734,9,5550.0000,'cash','credit','sell',951,'2023-11-16 18:33:54','2023-11-16 18:33:54'),(735,9,1700.0000,'cash','credit','sell',954,'2023-11-16 19:17:13','2023-11-16 19:17:13'),(736,9,33000.0000,'cash','credit','sell',955,'2023-11-16 19:19:37','2023-11-16 19:19:37'),(737,9,1400.0000,'cash','credit','sell',956,'2023-11-16 19:29:02','2023-11-16 19:29:02'),(738,9,1800.0000,'cash','credit','sell',957,'2023-11-16 19:34:30','2023-11-16 19:34:30'),(739,9,2500.0000,'cash','credit','sell',958,'2023-11-16 19:41:11','2023-11-16 19:41:11'),(740,9,2700.0000,'cash','credit','sell',959,'2023-11-16 19:53:39','2023-11-16 19:53:39'),(741,9,1650.0000,'cash','credit','sell',960,'2023-11-16 19:59:42','2023-11-16 19:59:42'),(742,9,100.0000,'cash','debit','expense',961,'2023-11-16 20:00:16','2023-11-16 20:00:16'),(743,9,1000.0000,'cash','debit','expense',962,'2023-11-16 20:05:45','2023-11-16 20:05:45'),(744,9,1000.0000,'cash','debit','expense',963,'2023-11-16 20:06:19','2023-11-16 20:06:19'),(745,9,4000.0000,'cash','debit','expense',964,'2023-11-16 20:06:38','2023-11-16 20:06:38'),(746,9,700.0000,'cash','debit','expense',965,'2023-11-16 20:07:12','2023-11-16 20:07:12'),(747,9,2900.0000,'cash','credit','sell',966,'2023-11-16 20:09:08','2023-11-16 20:09:08'),(748,9,620.0000,'cash','debit','expense',967,'2023-11-18 14:45:02','2023-11-18 14:45:02'),(749,9,770.0000,'cash','debit','expense',968,'2023-11-18 14:45:59','2023-11-18 14:45:59'),(750,9,250.0000,'cash','debit','expense',969,'2023-11-18 14:46:28','2023-11-18 14:46:28'),(751,9,9660.0000,'cash','credit','sell',971,'2023-11-18 14:50:59','2023-11-18 14:50:59'),(752,9,21010.0000,'cash','credit','sell',972,'2023-11-18 14:53:38','2023-11-18 14:53:38'),(753,9,20120.0000,'cash','credit','sell',973,'2023-11-18 14:59:46','2023-11-18 14:59:46'),(754,9,41080.0000,'cash','credit','sell',975,'2023-11-18 15:05:41','2023-11-18 15:05:41'),(755,9,1200.0000,'cash','credit','sell',976,'2023-11-18 15:06:13','2023-11-18 15:06:13'),(756,9,18650.0000,'cash','credit','sell',977,'2023-11-18 15:08:48','2023-11-18 15:08:48'),(757,9,9680.0000,'cash','credit','sell',978,'2023-11-18 15:14:54','2023-11-18 15:14:54'),(758,9,9680.0000,'cash','debit','refund',978,'2023-11-18 15:16:38','2023-11-18 15:16:38'),(759,9,8030.0000,'cash','credit','sell',979,'2023-11-18 15:17:51','2023-11-18 15:17:51'),(760,9,18230.0000,'cash','credit','sell',980,'2023-11-18 15:19:55','2023-11-18 15:19:55'),(761,9,1650.0000,'cash','credit','sell',982,'2023-11-18 15:23:27','2023-11-18 15:23:27'),(762,9,6000.0000,'cash','credit','sell',983,'2023-11-18 15:45:08','2023-11-18 15:45:08'),(763,9,2500.0000,'cash','credit','sell',984,'2023-11-18 15:46:48','2023-11-18 15:46:48'),(764,9,3400.0000,'cash','credit','sell',986,'2023-11-18 15:50:06','2023-11-18 15:50:06'),(765,9,1780.0000,'cash','credit','sell',987,'2023-11-18 15:50:32','2023-11-18 15:50:32'),(766,9,1300.0000,'cash','credit','sell',988,'2023-11-18 15:53:50','2023-11-18 15:53:50'),(767,9,5000.0000,'cash','credit','sell',989,'2023-11-18 15:56:09','2023-11-18 15:56:09'),(768,9,2600.0000,'cash','credit','sell',990,'2023-11-18 15:57:54','2023-11-18 15:57:54'),(769,9,2500.0000,'cash','credit','sell',992,'2023-11-18 16:17:36','2023-11-18 16:17:36'),(770,9,9000.0000,'cash','credit','sell',993,'2023-11-18 16:26:44','2023-11-18 16:26:44'),(771,9,5500.0000,'cash','credit','sell',994,'2023-11-18 16:59:44','2023-11-18 16:59:44'),(772,9,3600.0000,'cash','credit','sell',995,'2023-11-18 17:34:54','2023-11-18 17:34:54'),(773,9,3180.0000,'cash','credit','sell',996,'2023-11-18 17:44:01','2023-11-18 17:44:01'),(774,9,1300.0000,'cash','credit','sell',997,'2023-11-18 17:50:51','2023-11-18 17:50:51'),(775,9,1400.0000,'cash','credit','sell',998,'2023-11-18 18:00:15','2023-11-18 18:00:15'),(776,9,1630.0000,'cash','credit','sell',999,'2023-11-18 18:04:28','2023-11-18 18:04:28'),(777,9,1400.0000,'cash','credit','sell',1000,'2023-11-18 18:15:24','2023-11-18 18:15:24'),(778,9,2950.0000,'cash','credit','sell',1001,'2023-11-18 18:16:44','2023-11-18 18:16:44'),(779,9,2450.0000,'cash','credit','sell',1002,'2023-11-18 18:20:29','2023-11-18 18:20:29'),(780,9,1680.0000,'cash','credit','sell',1003,'2023-11-18 18:38:08','2023-11-18 18:38:08'),(781,9,1400.0000,'cash','credit','sell',1004,'2023-11-18 18:41:56','2023-11-18 18:41:56'),(782,9,2500.0000,'cash','credit','sell',1005,'2023-11-18 18:44:58','2023-11-18 18:44:58'),(783,9,2200.0000,'cash','credit','sell',1006,'2023-11-18 18:48:25','2023-11-18 18:48:25'),(784,9,2700.0000,'cash','credit','sell',1007,'2023-11-18 18:48:45','2023-11-18 18:48:45'),(785,9,1430.0000,'cash','credit','sell',1008,'2023-11-18 19:15:09','2023-11-18 19:15:09'),(786,9,1680.0000,'cash','credit','sell',1009,'2023-11-18 19:18:34','2023-11-18 19:18:34'),(787,9,3170.0000,'cash','credit','sell',1010,'2023-11-18 19:20:16','2023-11-18 19:20:16'),(788,9,1680.0000,'cash','credit','sell',1011,'2023-11-18 19:34:28','2023-11-18 19:34:28'),(789,9,3200.0000,'cash','credit','sell',1012,'2023-11-18 19:36:17','2023-11-18 19:36:17'),(790,9,1000.0000,'cash','debit','expense',1013,'2023-11-18 19:43:16','2023-11-18 19:43:16'),(791,9,16400.0000,'cash','credit','sell',1015,'2023-11-19 12:47:03','2023-11-19 12:47:03'),(792,9,26973.0000,'cash','credit','sell',1016,'2023-11-19 12:48:35','2023-11-19 12:48:35'),(793,9,3350.0000,'cash','credit','sell',1017,'2023-11-19 12:49:09','2023-11-19 12:49:09'),(794,9,21130.0000,'cash','credit','sell',1018,'2023-11-19 12:53:40','2023-11-19 12:53:40'),(795,9,3600.0000,'cash','credit','sell',1019,'2023-11-19 12:54:06','2023-11-19 12:54:06'),(796,9,12550.0000,'cash','credit','sell',1020,'2023-11-19 13:16:47','2023-11-19 13:16:47'),(797,9,8260.0000,'cash','credit','sell',1021,'2023-11-19 13:17:32','2023-11-19 13:17:32'),(798,9,7400.0000,'cash','credit','sell',1023,'2023-11-19 13:20:19','2023-11-19 13:20:19'),(799,9,700.0000,'cash','debit','expense',1025,'2023-11-19 13:24:05','2023-11-19 13:24:05'),(800,9,1680.0000,'cash','credit','sell',1026,'2023-11-19 13:31:38','2023-11-19 13:31:38'),(801,9,1300.0000,'cash','credit','sell',1027,'2023-11-19 13:41:07','2023-11-19 13:41:07'),(802,9,1450.0000,'cash','credit','sell',1028,'2023-11-19 17:01:12','2023-11-19 17:01:12'),(803,9,3000.0000,'cash','credit','sell',1029,'2023-11-19 17:12:21','2023-11-19 17:12:21'),(804,9,15250.0000,'cash','credit','sell',1030,'2023-11-19 17:14:31','2023-11-19 17:14:31'),(805,9,11050.0000,'cash','credit','sell',1032,'2023-11-19 17:20:50','2023-11-19 17:20:50'),(806,9,1650.0000,'cash','credit','sell',1034,'2023-11-19 17:30:49','2023-11-19 17:30:49'),(807,9,1680.0000,'cash','credit','sell',1035,'2023-11-19 18:01:32','2023-11-19 18:01:32'),(808,9,120.0000,'cash','debit','expense',1036,'2023-11-19 18:05:21','2023-11-19 18:05:21'),(809,9,1550.0000,'cash','credit','sell',1037,'2023-11-19 18:32:55','2023-11-19 18:32:55'),(810,9,10350.0000,'cash','credit','sell',1038,'2023-11-19 18:42:04','2023-11-19 18:42:04'),(811,9,16720.0000,'cash','credit','sell',1040,'2023-11-20 10:52:08','2023-11-20 10:52:08'),(812,9,1600.0000,'cash','credit','sell',1041,'2023-11-20 10:54:31','2023-11-20 10:54:31'),(813,9,2650.0000,'cash','credit','sell',1042,'2023-11-20 10:55:52','2023-11-20 10:55:52'),(814,9,9050.0000,'cash','credit','sell',1043,'2023-11-20 10:59:13','2023-11-20 10:59:13'),(815,9,29860.0000,'cash','credit','sell',1044,'2023-11-20 11:01:14','2023-11-20 11:01:14'),(816,9,1640.0000,'cash','credit','sell',1045,'2023-11-20 11:03:40','2023-11-20 11:03:40'),(817,9,700.0000,'cash','debit','expense',1046,'2023-11-20 11:06:03','2023-11-20 11:06:03'),(818,9,1830.0000,'cash','credit','sell',1047,'2023-11-20 11:06:41','2023-11-20 11:06:41'),(819,9,2800.0000,'cash','credit','sell',1048,'2023-11-20 11:12:09','2023-11-20 11:12:09'),(820,9,30000.0000,'cash','credit','sell',1049,'2023-11-20 11:33:30','2023-11-20 11:33:30'),(821,9,2450.0000,'cash','credit','sell',1050,'2023-11-20 11:35:34','2023-11-20 11:35:34'),(822,9,2950.0000,'cash','credit','sell',1051,'2023-11-20 11:39:50','2023-11-20 11:39:50'),(823,9,2750.0000,'cash','credit','sell',1052,'2023-11-20 11:58:35','2023-11-20 11:58:35'),(824,9,1450.0000,'cash','credit','sell',1054,'2023-11-20 12:15:20','2023-11-20 12:15:20'),(825,9,60.0000,'cash','debit','expense',1055,'2023-11-20 12:19:28','2023-11-20 12:19:28'),(826,9,100.0000,'cash','debit','expense',1056,'2023-11-20 12:19:46','2023-11-20 12:19:46'),(827,9,1400.0000,'cash','credit','sell',1057,'2023-11-20 12:37:31','2023-11-20 12:37:31'),(828,9,2950.0000,'cash','credit','sell',1058,'2023-11-20 13:24:48','2023-11-20 13:24:48'),(829,9,3000.0000,'cash','debit','expense',1059,'2023-11-20 13:25:40','2023-11-20 13:25:40'),(830,9,1850.0000,'cash','credit','sell',1060,'2023-11-20 13:29:24','2023-11-20 13:29:24'),(831,9,2480.0000,'cash','credit','sell',1061,'2023-11-20 13:31:50','2023-11-20 13:31:50'),(832,9,2700.0000,'cash','credit','sell',1062,'2023-11-20 13:32:08','2023-11-20 13:32:08'),(833,9,1400.0000,'cash','credit','sell',1063,'2023-11-20 13:58:58','2023-11-20 13:58:58'),(834,9,1800.0000,'cash','credit','sell',1064,'2023-11-20 14:11:16','2023-11-20 14:11:16'),(835,9,2750.0000,'cash','credit','sell',1065,'2023-11-20 14:53:59','2023-11-20 14:53:59'),(836,9,38798.5000,'cash','credit','sell',1066,'2023-11-20 17:34:09','2023-11-20 17:34:09'),(837,9,1500.0000,'cash','credit','sell',1067,'2023-11-20 17:35:26','2023-11-20 17:35:26'),(838,9,5780.0000,'cash','credit','sell',1068,'2023-11-20 17:36:55','2023-11-20 17:36:55'),(839,9,2800.0000,'cash','credit','sell',1069,'2023-11-20 17:55:46','2023-11-20 17:55:46'),(840,9,1300.0000,'cash','credit','sell',1070,'2023-11-20 18:08:28','2023-11-20 18:08:28'),(841,9,2550.0000,'cash','credit','sell',1071,'2023-11-20 18:20:49','2023-11-20 18:20:49'),(842,9,1300.0000,'cash','credit','sell',1072,'2023-11-20 18:27:12','2023-11-20 18:27:12'),(843,9,6050.0000,'cash','credit','sell',1073,'2023-11-20 18:49:18','2023-11-20 18:49:18'),(844,9,1500.0000,'cash','credit','sell',1074,'2023-11-20 19:07:11','2023-11-20 19:07:11'),(845,9,1290.0000,'cash','credit','sell',1071,'2023-11-20 19:10:31','2023-11-20 19:10:31'),(846,9,2900.0000,'cash','credit','sell',1075,'2023-11-20 19:12:09','2023-11-20 19:12:09'),(847,9,1320.0000,'cash','credit','sell',1076,'2023-11-20 19:29:56','2023-11-20 19:29:56'),(848,10,456970.0000,'cash','credit','initial',NULL,'2023-11-20 19:47:38','2023-11-20 19:47:38'),(849,10,1300.0000,'cash','credit','sell',1077,'2023-11-20 19:49:04','2023-11-20 19:49:04'),(850,10,70.0000,'cash','debit','expense',1078,'2023-11-20 19:59:06','2023-11-20 19:59:06'),(851,10,700.0000,'cash','debit','expense',1079,'2023-11-21 10:33:09','2023-11-21 10:33:09'),(852,10,14870.0000,'cash','credit','sell',1080,'2023-11-21 10:38:04','2023-11-21 10:38:04'),(853,10,9250.0000,'cash','credit','sell',1081,'2023-11-21 10:39:44','2023-11-21 10:39:44'),(854,10,12380.0000,'cash','credit','sell',1082,'2023-11-21 10:41:23','2023-11-21 10:41:23'),(855,10,4380.0000,'cash','credit','sell',1083,'2023-11-21 10:42:51','2023-11-21 10:42:51'),(856,10,2200.0000,'cash','credit','sell',1084,'2023-11-21 10:53:20','2023-11-21 10:53:20'),(857,10,1940.0000,'cash','credit','sell',1086,'2023-11-21 11:22:16','2023-11-21 11:22:16'),(858,10,1650.0000,'cash','credit','sell',1087,'2023-11-21 11:24:40','2023-11-21 11:24:40'),(859,10,2000.0000,'cash','debit','expense',1089,'2023-11-21 11:51:49','2023-11-21 11:51:49'),(860,10,2480.0000,'cash','credit','sell',1091,'2023-11-21 13:53:26','2023-11-21 13:53:26'),(861,10,1680.0000,'cash','credit','sell',1092,'2023-11-21 14:02:00','2023-11-21 14:02:00'),(862,10,2000.0000,'cash','credit','sell',1093,'2023-11-21 14:13:49','2023-11-21 14:13:49'),(863,10,2580.0000,'cash','credit','sell',1094,'2023-11-21 14:20:19','2023-11-21 14:20:19'),(864,10,11550.0000,'cash','credit','sell',1095,'2023-11-21 14:27:45','2023-11-21 14:27:45'),(865,10,7100.0000,'cash','credit','sell',1096,'2023-11-21 14:37:10','2023-11-21 14:37:10'),(866,10,29400.0000,'cash','credit','sell',1097,'2023-11-21 14:43:10','2023-11-21 14:43:10'),(867,10,1700.0000,'cash','credit','sell',1098,'2023-11-21 14:48:22','2023-11-21 14:48:22'),(868,10,5980.0000,'cash','credit','sell',1099,'2023-11-21 14:55:17','2023-11-21 14:55:17'),(869,10,1650.0000,'cash','credit','sell',1100,'2023-11-21 14:55:56','2023-11-21 14:55:56'),(870,10,1300.0000,'cash','credit','sell',1102,'2023-11-21 17:35:00','2023-11-21 17:35:00'),(871,10,12590.0000,'cash','credit','sell',1103,'2023-11-21 17:39:56','2023-11-21 17:39:56'),(872,10,20435.0000,'cash','credit','sell',1104,'2023-11-21 17:41:00','2023-11-21 17:41:00'),(873,10,20640.0000,'cash','credit','sell',1106,'2023-11-21 17:46:23','2023-11-21 17:46:23'),(874,10,1300.0000,'cash','credit','sell',1107,'2023-11-21 17:47:45','2023-11-21 17:47:45'),(875,10,2650.0000,'cash','credit','sell',1108,'2023-11-21 17:54:52','2023-11-21 17:54:52'),(876,10,80.0000,'cash','debit','expense',1109,'2023-11-21 18:02:29','2023-11-21 18:02:29'),(877,10,1400.0000,'cash','credit','sell',1110,'2023-11-21 18:05:25','2023-11-21 18:05:25'),(878,10,2000.0000,'cash','debit','expense',1111,'2023-11-21 18:11:56','2023-11-21 18:11:56'),(879,10,2750.0000,'cash','credit','sell',1112,'2023-11-21 18:28:13','2023-11-21 18:28:13'),(880,10,3070.0000,'cash','credit','sell',1113,'2023-11-21 18:29:48','2023-11-21 18:29:48'),(881,10,3000.0000,'cash','credit','sell',1114,'2023-11-21 18:38:30','2023-11-21 18:38:30'),(882,10,10250.0000,'cash','credit','sell',1115,'2023-11-21 18:39:13','2023-11-21 18:39:13'),(883,10,3500.0000,'cash','credit','sell',1117,'2023-11-21 19:27:20','2023-11-21 19:27:20'),(884,10,2700.0000,'cash','credit','sell',1119,'2023-11-21 19:39:07','2023-11-21 19:39:07'),(885,10,2470.0000,'cash','credit','sell',1120,'2023-11-21 19:46:46','2023-11-21 19:46:46'),(886,10,2200.0000,'cash','credit','sell',1122,'2023-11-21 20:04:04','2023-11-21 20:04:04'),(887,10,1640.0000,'cash','debit','expense',1124,'2023-11-21 20:16:26','2023-11-21 20:16:26'),(888,10,10190.0000,'cash','credit','sell',1125,'2023-11-22 10:32:18','2023-11-22 10:32:18'),(889,10,10010.0000,'cash','credit','sell',1126,'2023-11-22 10:34:32','2023-11-22 10:34:32'),(890,10,2500.0000,'cash','credit','sell',1129,'2023-11-22 10:45:47','2023-11-22 10:45:47'),(891,10,3400.0000,'cash','credit','sell',1130,'2023-11-22 10:52:10','2023-11-22 10:52:10'),(892,10,8550.0000,'cash','credit','sell',1131,'2023-11-22 10:55:11','2023-11-22 10:55:11'),(893,10,3300.0000,'cash','credit','sell',1132,'2023-11-22 10:58:25','2023-11-22 10:58:25'),(894,10,2000.0000,'cash','credit','sell',1135,'2023-11-22 11:35:24','2023-11-22 11:35:24'),(895,10,1500.0000,'cash','credit','sell',1136,'2023-11-22 11:38:23','2023-11-22 11:38:23'),(896,10,3280.0000,'cash','credit','sell',1137,'2023-11-22 11:41:32','2023-11-22 11:41:32'),(897,10,1380.0000,'cash','credit','sell',1138,'2023-11-22 11:42:04','2023-11-22 11:42:04'),(898,10,2190.0000,'cash','credit','sell',1139,'2023-11-22 12:16:50','2023-11-22 12:16:50'),(899,10,1400.0000,'cash','credit','sell',1140,'2023-11-22 12:34:40','2023-11-22 12:34:40'),(900,10,1700.0000,'cash','credit','sell',1141,'2023-11-22 12:43:38','2023-11-22 12:43:38'),(901,10,2650.0000,'cash','credit','sell',1142,'2023-11-22 12:44:29','2023-11-22 12:44:29'),(902,10,2700.0000,'cash','credit','sell',1144,'2023-11-22 13:38:44','2023-11-22 13:38:44'),(903,10,2530.0000,'cash','credit','sell',1145,'2023-11-22 13:39:35','2023-11-22 13:39:35'),(904,10,1700.0000,'cash','credit','sell',1147,'2023-11-22 13:53:50','2023-11-22 13:53:50'),(905,10,4350.0000,'cash','credit','sell',1148,'2023-11-22 14:30:05','2023-11-22 14:30:05'),(906,10,48815.2500,'cash','credit','sell',1149,'2023-11-22 14:35:02','2023-11-22 14:35:02'),(907,10,1280.0000,'cash','debit','expense',1150,'2023-11-22 14:37:18','2023-11-22 14:37:18'),(908,10,1350.0000,'cash','credit','sell',1151,'2023-11-22 17:23:17','2023-11-22 17:23:17'),(909,10,10150.0000,'cash','credit','sell',1152,'2023-11-22 17:27:21','2023-11-22 17:27:21'),(912,10,3000.0000,'cash','credit','sell',1154,'2023-11-22 17:37:55','2023-11-22 17:37:55'),(913,10,3250.0000,'cash','credit','sell',1155,'2023-11-22 17:38:35','2023-11-22 17:38:35'),(914,10,9650.0000,'cash','credit','sell',1156,'2023-11-22 17:40:57','2023-11-22 17:40:57'),(915,10,830.0000,'cash','debit','expense',1157,'2023-11-22 17:45:58','2023-11-22 17:45:58'),(916,10,1800.0000,'cash','credit','sell',1158,'2023-11-22 17:46:41','2023-11-22 17:46:41'),(917,10,34920.0000,'cash','credit','sell',1159,'2023-11-22 18:17:56','2023-11-22 18:17:56'),(918,10,1700.0000,'cash','credit','sell',1160,'2023-11-22 18:18:53','2023-11-22 18:18:53'),(919,10,3000.0000,'cash','credit','sell',1161,'2023-11-22 18:24:26','2023-11-22 18:24:26'),(920,10,400.0000,'cash','credit','sell',1162,'2023-11-22 18:26:23','2023-11-22 18:26:23'),(921,10,700.0000,'cash','debit','expense',1163,'2023-11-22 18:33:14','2023-11-22 18:33:14'),(922,10,60.0000,'cash','debit','expense',1164,'2023-11-22 18:37:38','2023-11-22 18:37:38'),(923,10,3300.0000,'cash','credit','sell',1165,'2023-11-22 19:12:39','2023-11-22 19:12:39'),(924,10,1400.0000,'cash','credit','sell',1166,'2023-11-22 19:15:03','2023-11-22 19:15:03'),(925,10,3350.0000,'cash','credit','sell',1167,'2023-11-22 19:15:57','2023-11-22 19:15:57'),(926,10,3150.0000,'cash','credit','sell',1168,'2023-11-22 19:18:01','2023-11-22 19:18:01'),(927,10,300.0000,'cash','credit','sell',1169,'2023-11-22 19:22:58','2023-11-22 19:22:58'),(928,10,300.0000,'cash','debit','expense',1170,'2023-11-22 19:23:31','2023-11-22 19:23:31'),(929,10,3150.0000,'cash','credit','sell',1171,'2023-11-23 10:28:25','2023-11-23 10:28:25'),(930,10,15290.0000,'cash','credit','sell',1172,'2023-11-23 10:30:26','2023-11-23 10:30:26'),(931,10,1900.0000,'cash','credit','sell',1173,'2023-11-23 10:43:34','2023-11-23 10:43:34'),(932,10,2750.0000,'cash','credit','sell',1174,'2023-11-23 10:48:03','2023-11-23 10:48:03'),(933,10,1700.0000,'cash','credit','sell',1175,'2023-11-23 10:51:13','2023-11-23 10:51:13'),(934,10,2700.0000,'cash','credit','sell',1176,'2023-11-23 11:00:49','2023-11-23 11:00:49'),(935,10,10630.0000,'cash','credit','sell',1177,'2023-11-23 11:03:58','2023-11-23 11:03:58'),(936,10,12820.0000,'cash','credit','sell',1178,'2023-11-23 11:05:01','2023-11-23 11:05:01'),(937,10,44355.0000,'cash','credit','sell',1179,'2023-11-23 11:07:16','2023-11-23 11:07:16'),(938,10,2200.0000,'cash','credit','sell',1180,'2023-11-23 11:15:18','2023-11-23 11:15:18'),(939,10,1680.0000,'cash','credit','sell',1181,'2023-11-23 11:27:51','2023-11-23 11:27:51'),(940,10,6000.0000,'cash','credit','sell',1182,'2023-11-23 11:40:33','2023-11-23 11:40:33'),(941,10,700.0000,'cash','debit','expense',1183,'2023-11-23 11:41:25','2023-11-23 11:41:25'),(942,10,2550.0000,'cash','credit','sell',1185,'2023-11-23 12:14:44','2023-11-23 12:14:44'),(943,10,2700.0000,'cash','credit','sell',1188,'2023-11-23 12:36:56','2023-11-23 12:36:56'),(944,10,1400.0000,'cash','credit','sell',1190,'2023-11-23 13:36:51','2023-11-23 13:36:51'),(945,10,4750.0000,'cash','credit','sell',1192,'2023-11-23 13:39:52','2023-11-23 13:39:52'),(946,10,350.0000,'cash','credit','sell',1194,'2023-11-23 13:48:58','2023-11-23 13:48:58'),(947,10,4800.0000,'cash','credit','sell',1195,'2023-11-23 13:54:14','2023-11-23 13:54:14'),(948,10,2100.0000,'cash','credit','sell',1196,'2023-11-23 13:55:07','2023-11-23 13:55:07'),(949,10,320.0000,'cash','credit','sell',1197,'2023-11-23 14:05:16','2023-11-23 14:05:16'),(950,10,5250.0000,'cash','credit','sell',1198,'2023-11-23 14:41:12','2023-11-23 14:41:12'),(951,10,8850.0000,'cash','credit','sell',1201,'2023-11-23 17:42:38','2023-11-23 17:42:38'),(952,10,34245.6000,'cash','credit','sell',1202,'2023-11-23 17:49:04','2023-11-23 17:49:04'),(953,10,6000.0000,'cash','credit','sell',1203,'2023-11-23 17:50:51','2023-11-23 17:50:51'),(954,10,4630.0000,'cash','credit','sell',1204,'2023-11-23 17:53:08','2023-11-23 17:53:08'),(955,10,13320.0000,'cash','credit','sell',1205,'2023-11-23 17:55:29','2023-11-23 17:55:29'),(956,10,13000.0000,'cash','credit','sell',1206,'2023-11-23 17:56:14','2023-11-23 17:56:14'),(957,10,2950.0000,'cash','credit','sell',1208,'2023-11-23 18:14:17','2023-11-23 18:14:17'),(959,10,1360.0000,'cash','debit','expense',1210,'2023-11-23 18:35:41','2023-11-23 18:35:41'),(960,10,4330.0000,'cash','credit','sell',1211,'2023-11-23 19:08:08','2023-11-23 19:08:08'),(962,10,3481.0000,'cash','credit','sell',1212,'2023-11-23 19:14:03','2023-11-23 19:14:03'),(963,10,4560.0000,'cash','credit','sell',1213,'2023-11-23 19:17:52','2023-11-23 19:17:52'),(964,10,3600.0000,'cash','credit','sell',1214,'2023-11-23 19:28:13','2023-11-23 19:28:13'),(965,10,1380.0000,'cash','credit','sell',1215,'2023-11-23 19:31:33','2023-11-23 19:31:33'),(966,10,1930.0000,'cash','credit','sell',1216,'2023-11-23 19:31:48','2023-11-23 19:31:48'),(967,10,200.0000,'cash','debit','expense',1217,'2023-11-23 19:40:59','2023-11-23 19:40:59'),(968,10,4000.0000,'cash','debit','expense',1218,'2023-11-23 19:43:37','2023-11-23 19:43:37'),(969,10,700.0000,'cash','debit','expense',1219,'2023-11-23 19:45:23','2023-11-23 19:45:23'),(970,10,2500.0000,'cash','credit','sell',1220,'2023-11-23 19:47:01','2023-11-23 19:47:01'),(971,10,3000.0000,'cash','debit','expense',1222,'2023-11-23 19:50:42','2023-11-23 19:50:42'),(972,10,3300.0000,'cash','credit','sell',1223,'2023-11-25 10:39:54','2023-11-25 10:39:54'),(973,10,9860.0000,'cash','credit','sell',1226,'2023-11-25 10:45:37','2023-11-25 10:45:37'),(974,10,9700.0000,'cash','credit','sell',1227,'2023-11-25 10:47:57','2023-11-25 10:47:57'),(975,10,5400.0000,'cash','credit','sell',1228,'2023-11-25 10:48:36','2023-11-25 10:48:36'),(976,10,8420.0000,'cash','credit','sell',1229,'2023-11-25 10:50:24','2023-11-25 10:50:24'),(977,10,1400.0000,'cash','credit','sell',1230,'2023-11-25 10:52:53','2023-11-25 10:52:53'),(978,10,51695.0000,'cash','credit','sell',1231,'2023-11-25 10:54:56','2023-11-25 10:54:56'),(979,10,2200.0000,'cash','credit','sell',1232,'2023-11-25 10:58:00','2023-11-25 10:58:00'),(980,10,10230.0000,'cash','credit','sell',1233,'2023-11-25 11:00:47','2023-11-25 11:00:47'),(981,10,3000.0000,'cash','credit','sell',1234,'2023-11-25 11:03:40','2023-11-25 11:03:40'),(982,10,8000.0000,'cash','credit','sell',1235,'2023-11-25 11:04:44','2023-11-25 11:04:44'),(983,10,1300.0000,'cash','credit','sell',1236,'2023-11-25 11:04:58','2023-11-25 11:04:58'),(984,10,1650.0000,'cash','credit','sell',1237,'2023-11-25 11:07:05','2023-11-25 11:07:05'),(985,10,2900.0000,'cash','credit','sell',1238,'2023-11-25 11:08:11','2023-11-25 11:08:11'),(986,10,3700.0000,'cash','credit','sell',1239,'2023-11-25 11:15:27','2023-11-25 11:15:27'),(987,10,1600.0000,'cash','credit','sell',1241,'2023-11-25 11:32:40','2023-11-25 11:32:40'),(988,10,2680.0000,'cash','credit','sell',1242,'2023-11-25 11:40:32','2023-11-25 11:40:32'),(989,10,2750.0000,'cash','credit','sell',1243,'2023-11-25 11:57:21','2023-11-25 11:57:21'),(990,10,1350.0000,'cash','credit','sell',1244,'2023-11-25 12:07:59','2023-11-25 12:07:59'),(991,10,80.0000,'cash','credit','sell',1245,'2023-11-25 12:10:59','2023-11-25 12:10:59'),(992,10,2550.0000,'cash','credit','sell',1246,'2023-11-25 12:12:19','2023-11-25 12:12:19'),(993,10,3200.0000,'cash','credit','sell',1247,'2023-11-25 12:20:55','2023-11-25 12:20:55'),(994,10,4650.0000,'cash','credit','sell',1248,'2023-11-25 12:36:32','2023-11-25 12:36:32'),(995,10,1680.0000,'cash','credit','sell',1249,'2023-11-25 12:39:48','2023-11-25 12:39:48'),(996,10,2950.0000,'cash','credit','sell',1250,'2023-11-25 13:30:07','2023-11-25 13:30:07'),(997,10,1450.0000,'cash','credit','sell',1251,'2023-11-25 13:55:27','2023-11-25 13:55:27'),(998,10,2650.0000,'cash','credit','sell',1252,'2023-11-25 13:57:24','2023-11-25 13:57:24'),(999,10,3000.0000,'cash','credit','sell',1253,'2023-11-25 13:58:03','2023-11-25 13:58:03'),(1000,10,160.0000,'cash','credit','sell',1254,'2023-11-25 13:59:44','2023-11-25 13:59:44');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_card_slips` int(11) NOT NULL DEFAULT '0',
  `total_cheques` int(11) NOT NULL DEFAULT '0',
  `denominations` text COLLATE utf8mb4_unicode_ci,
  `closing_note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2023-10-15 17:45:00','2023-10-15 17:45:15'),(2,1,1,3,'close','2023-10-25 19:58:23',6060.0000,0,0,NULL,NULL,'2023-10-21 20:17:00','2023-10-25 19:58:23'),(3,1,1,2,'close','2023-10-25 19:57:21',100000.0000,0,0,NULL,NULL,'2023-10-25 14:57:00','2023-10-25 19:57:21'),(4,1,1,3,'close','2023-10-25 20:23:46',106060.0000,0,0,NULL,NULL,'2023-10-25 19:58:00','2023-10-25 20:23:46'),(5,1,1,3,'close','2023-10-29 21:53:41',-347767.9900,347768,0,NULL,NULL,'2023-10-25 20:24:00','2023-10-29 21:53:41'),(6,1,1,3,'close','2023-11-01 18:53:36',246212.9000,106882,0,NULL,NULL,'2023-10-29 21:59:00','2023-11-01 18:53:36'),(7,1,1,3,'close','2023-11-05 17:33:38',781265.9000,360125,0,NULL,NULL,'2023-11-01 18:54:00','2023-11-05 17:33:38'),(8,1,1,3,'close','2023-11-06 20:09:08',185734.0300,133134,0,NULL,NULL,'2023-11-05 17:33:00','2023-11-06 20:09:08'),(9,1,1,3,'close','2023-11-20 19:47:03',474213.2900,0,0,NULL,NULL,'2023-11-06 20:09:00','2023-11-20 19:47:03'),(10,1,1,3,'open',NULL,0.0000,0,0,NULL,NULL,'2023-11-20 19:47:00','2023-11-20 19:47:38');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_able` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Rice',1,NULL,0,1,'product',NULL,NULL,0,'2023-10-21 15:40:26','2023-10-15 18:04:34','2023-10-21 15:40:26'),(2,'Rice-চাল',1,NULL,0,1,'product',NULL,NULL,0,NULL,'2023-10-18 17:01:16','2023-10-18 17:01:16');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `first_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `middle_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_line_1` text COLLATE utf8mb4_unicode_ci,
  `address_line_2` text COLLATE utf8mb4_unicode_ci,
  `zip_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `total_rp` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT '0' COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_address` text COLLATE utf8mb4_unicode_ci,
  `shipping_custom_field_details` longtext COLLATE utf8mb4_unicode_ci,
  `is_export` tinyint(1) NOT NULL DEFAULT '0',
  `export_custom_field_1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `export_custom_field_6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field6` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field7` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field8` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field9` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field10` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-15 17:32:12','2023-10-19 16:19:54'),(2,1,'supplier','Sahed Ahmed','',NULL,NULL,NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01737361905',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-21 15:45:11','2023-10-15 18:23:51','2023-10-21 15:45:11'),(3,1,'customer',NULL,'Mr Sahed Ahmed','Mr','Sahed',NULL,'Ahmed',NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01737361905',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 02:09:19','2023-10-15 18:30:44','2023-10-19 02:09:19'),(4,1,'supplier',NULL,'xyz',NULL,'xyz',NULL,NULL,NULL,'CO0004','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-21 15:45:19','2023-10-18 17:03:45','2023-10-21 15:45:19'),(6,1,'customer','Shorif Store','shorif bhai',NULL,'shorif bhai',NULL,NULL,NULL,'101','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711704087',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:25:55','2023-10-22 13:38:58'),(7,1,'customer','Premium Fish Ltd.','',NULL,NULL,NULL,NULL,NULL,'102','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01904313209',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:29:34','2023-10-19 16:30:25'),(8,1,'customer','Nirapod Restaurant','',NULL,NULL,NULL,NULL,NULL,'103','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01611813846',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:34:28','2023-10-19 16:34:28'),(9,1,'customer','Royal Kitchen, Darga','',NULL,NULL,NULL,NULL,NULL,'104','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01722490962',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:36:27','2023-10-19 16:36:27'),(10,1,'customer','Abdur Rob , City Sanitary','',NULL,NULL,NULL,NULL,NULL,'105','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:39:12','2023-10-19 16:39:12'),(11,1,'customer','City Sanitary','Abul Miah',NULL,'Abul Miah',NULL,NULL,NULL,'106','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01714507341',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:41:22','2023-10-19 16:41:42'),(12,1,'customer','Yokoso Restaurant','Akib',NULL,'Akib',NULL,NULL,NULL,'107','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01722490962',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:47:47','2023-10-27 20:12:38'),(13,1,'customer','Alhamdulilla Hotel','Mustofa',NULL,'Mustofa',NULL,NULL,NULL,'108','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01724883322',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:50:51','2023-10-19 16:50:51'),(14,1,'customer','8-11','',NULL,NULL,NULL,NULL,NULL,'109','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01764889900',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:52:11','2023-10-22 12:51:15'),(15,1,'customer','Meraj Restaurant','',NULL,NULL,NULL,NULL,NULL,'110','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01715775099',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:53:37','2023-10-19 16:53:37'),(16,1,'customer',NULL,'Bilas Bilas Babu',NULL,'Bilas',NULL,'Bilas Babu',NULL,'111','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01752917222',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:54:46','2023-10-19 16:55:05'),(17,1,'customer','Bangla Store','',NULL,NULL,NULL,NULL,NULL,'112','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01721825927',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:56:37','2023-10-19 16:56:37'),(18,1,'customer',NULL,'Ajij Miah Jel Road',NULL,'Ajij Miah',NULL,'Jel Road',NULL,'113','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 16:57:41','2023-10-19 16:57:41'),(19,1,'customer','Banijjo Store , Ambarkana','Malek bhai',NULL,'Malek bhai',NULL,NULL,NULL,'114','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711484670',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 17:01:48','2023-10-22 13:37:16'),(20,1,'customer',NULL,'Tara Vai Raynogor',NULL,'Tara Vai',NULL,'Raynogor',NULL,'115','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711300681',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 17:02:40','2023-10-19 17:02:40'),(21,1,'customer',NULL,'Jaman, Rupali Bank',NULL,'Jaman, Rupali Bank',NULL,NULL,NULL,'116','active',NULL,NULL,NULL,NULL,'Rupali Bank',NULL,NULL,NULL,'01914825022',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 17:04:13','2023-11-12 19:11:46'),(22,1,'customer',NULL,'Rasel Vai',NULL,'Rasel Vai',NULL,NULL,NULL,'117','active',NULL,NULL,NULL,NULL,'Barutkhana sylhet',NULL,NULL,NULL,'01612977737',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 17:05:48','2023-10-22 13:31:04'),(23,1,'customer','Asma Store','',NULL,NULL,NULL,NULL,NULL,'118','active',NULL,NULL,NULL,NULL,'Bondor bazar',NULL,NULL,NULL,'017817577474',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 17:07:23','2023-10-19 17:07:23'),(24,1,'customer',NULL,'Others',NULL,'Others',NULL,NULL,NULL,'100','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-19 17:10:38','2023-10-19 17:10:38'),(25,1,'customer',NULL,'demo',NULL,'demo',NULL,NULL,NULL,'CO0025','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'000000000',NULL,NULL,NULL,NULL,NULL,1,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-21 15:44:01','2023-10-21 15:32:48','2023-10-21 15:44:01'),(27,1,'supplier',NULL,'',NULL,'0',NULL,NULL,NULL,'0','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 20:05:36','2023-10-21 20:32:03','2023-10-27 20:05:36'),(28,1,'supplier','M/s Motiur Rahman & Brothers','',NULL,NULL,NULL,NULL,NULL,'001','active',NULL,NULL,NULL,NULL,'Chaowl bazar, kalighat',NULL,NULL,NULL,'01711454374',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-22 13:46:43','2023-10-22 13:46:43'),(29,1,'supplier','M/S pal Traders','',NULL,NULL,NULL,NULL,NULL,'002','active',NULL,NULL,NULL,NULL,'Chaowl bazar, kalighat',NULL,NULL,NULL,'01715278409',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-22 13:49:21','2023-10-22 13:49:21'),(30,1,'supplier','Mosoddor Hazi & Sons','',NULL,NULL,NULL,NULL,NULL,'003','active',NULL,NULL,NULL,NULL,'Chaowl bazar, kalighat',NULL,NULL,NULL,'01716691828',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-22 13:50:52','2023-10-22 13:50:52'),(31,1,'supplier','M/S Motin & Brothers','',NULL,NULL,NULL,NULL,NULL,'CO0031','active',NULL,NULL,NULL,NULL,'Sheikghat Sylhet',NULL,NULL,NULL,'01713805296',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-22 13:55:18','2023-10-22 13:55:18'),(32,1,'supplier','M/S Hasan Traders','',NULL,NULL,NULL,NULL,NULL,'CO0032','active',NULL,NULL,NULL,NULL,'Sheikghat Sylhet',NULL,NULL,NULL,'01720824826',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-22 13:56:36','2023-10-22 13:56:36'),(33,1,'supplier','M/s maa kaddo vandar','',NULL,NULL,NULL,NULL,NULL,'CO0033','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711059698',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-24 19:42:16','2023-10-24 19:42:16'),(34,1,'supplier','Loknath Trading','',NULL,NULL,NULL,NULL,NULL,'CO0034','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01710705405',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 11:27:03','2023-10-25 11:27:03'),(35,1,'customer','Asma Store (running)','',NULL,NULL,NULL,NULL,NULL,'CO0035','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01781757474',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 20:07:14','2023-10-28 11:30:59'),(36,1,'customer','Hot Food','Hot Food Restaurent',NULL,'Hot Food Restaurent',NULL,NULL,NULL,'CO0036','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 20:14:00','2023-11-08 17:42:56'),(38,1,'customer',NULL,'Regular Customer 003',NULL,'Regular Customer 003',NULL,NULL,NULL,'CO0038','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 11:17:36','2023-10-29 19:17:12'),(40,1,'customer',NULL,'Regular Customer(Running)',NULL,'Regular Customer(Running)',NULL,NULL,NULL,'CO0040','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'03',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 11:28:53','2023-11-01 19:31:32'),(41,1,'supplier','M/S Bijon Kanti Midul','',NULL,NULL,NULL,NULL,NULL,'CO0041','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01713807179',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 20:12:03','2023-10-28 20:12:03'),(42,1,'customer',NULL,'Kobir vai Awamilige',NULL,'Kobir vai Awamilige',NULL,NULL,NULL,'CO0042','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01726307211',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:31:37','2023-10-29 18:31:37'),(43,1,'customer',NULL,'Pappu Bhai sowdagortula',NULL,'Pappu Bhai sowdagortula',NULL,NULL,NULL,'CO0043','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711059718',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:38:26','2023-10-30 13:37:35'),(44,1,'customer',NULL,'Suleman mia',NULL,'Suleman mia',NULL,NULL,NULL,'CO0044','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:11:46','2023-10-29 19:11:46'),(45,1,'customer',NULL,'Dilip caca Jail road',NULL,'Dilip caca Jail road',NULL,NULL,NULL,'CO0045','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711238113',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:12:45','2023-10-29 19:12:45'),(46,1,'customer',NULL,'Layek vai Kumar-para',NULL,'Layek vai Kumar-para',NULL,NULL,NULL,'CO0046','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01715748198',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:13:59','2023-10-29 19:13:59'),(47,1,'customer',NULL,'Jomir Dim',NULL,'Jomir Dim',NULL,NULL,NULL,'CO0047','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01705816444',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:15:16','2023-10-29 19:15:16'),(48,1,'supplier','Suhed Bhai, Mojid Mill','',NULL,NULL,NULL,NULL,NULL,'CO0048','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01712374708',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 13:30:02','2023-11-06 14:26:26'),(49,1,'customer',NULL,'Dinar (moshla Mill)',NULL,'Dinar (moshla Mill)',NULL,NULL,NULL,'CO0049','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711325031',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:06:27','2023-10-30 14:06:27'),(50,1,'customer',NULL,'Juel Vagna. Abul',NULL,'Juel Vagna. Abul',NULL,NULL,NULL,'CO0050','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:36:05','2023-10-30 14:36:05'),(51,1,'customer',NULL,'Alauddin Bura',NULL,'Alauddin Bura',NULL,NULL,NULL,'CO0051','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:40:16','2023-10-30 18:40:16'),(52,1,'customer',NULL,'Koysor Biron',NULL,'Koysor Biron',NULL,NULL,NULL,'CO0052','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01772355386',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:31:43','2023-10-30 19:31:43'),(53,1,'customer',NULL,'Rubel (Noddles)',NULL,'Rubel (Noddles)',NULL,NULL,NULL,'CO0053','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:41:31','2023-10-30 19:41:31'),(54,1,'customer',NULL,'Imam Jornarpar',NULL,'Imam Jornarpar',NULL,NULL,NULL,'CO0054','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:04:58','2023-10-31 12:04:58'),(55,1,'customer',NULL,'Burid Miah Kamalbazar',NULL,'Burid Miah Kamalbazar',NULL,NULL,NULL,'CO0055','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01782345554',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:55:34','2023-10-31 12:55:34'),(56,1,'customer',NULL,'Mura Ali Kamalbazar',NULL,'Mura Ali Kamalbazar',NULL,NULL,NULL,'CO0056','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01753350115',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 17:52:03','2023-10-31 17:52:03'),(57,1,'customer',NULL,'Shaheen (friend)',NULL,'Shaheen (friend)',NULL,NULL,NULL,'CO0057','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01719500059',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 18:48:47','2023-10-31 18:48:47'),(58,1,'customer',NULL,'Jhumon Chawala',NULL,'Jhumon Chawala',NULL,NULL,NULL,'CO0058','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'00000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:54:31','2023-11-01 17:54:31'),(59,1,'customer','Bangla Srore (Runnung)','',NULL,NULL,NULL,NULL,NULL,'CO0059','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'001',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:56:52','2023-11-01 17:56:52'),(60,1,'customer',NULL,'Jasim Friend',NULL,'Jasim Friend',NULL,NULL,NULL,'CO0060','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01717457839',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:02:56','2023-11-01 18:02:56'),(61,1,'customer',NULL,'SOUROV (Friend)',NULL,'SOUROV (Friend)',NULL,NULL,NULL,'CO0061','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01819591999',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 19:21:42','2023-11-01 19:21:42'),(62,1,'customer',NULL,'Sojol Hamidul Bhai Jelkhana',NULL,'Sojol Hamidul Bhai Jelkhana',NULL,NULL,NULL,'CO0062','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01619892349',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 11:00:20','2023-11-02 11:00:20'),(63,1,'customer',NULL,'Selim Rickshaw',NULL,'Selim Rickshaw',NULL,NULL,NULL,'CO0063','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01780937729',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:40:54','2023-11-02 17:40:54'),(64,1,'customer','Ali Store (Mirboxtula)','',NULL,NULL,NULL,NULL,NULL,'CO0064','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01785853837',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 19:57:50','2023-11-02 19:58:24'),(65,1,'customer',NULL,'Jony Enterperise',NULL,'Jony Enterperise',NULL,NULL,NULL,'CO0065','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01712769312',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:29:06','2023-11-02 20:29:06'),(66,1,'customer',NULL,'Hanif Kamalbazar',NULL,'Hanif Kamalbazar',NULL,NULL,NULL,'CO0066','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01765209082',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:55:25','2023-11-04 17:55:25'),(67,1,'customer',NULL,'Jubayer Bhai (Paglabazar)',NULL,'Jubayer Bhai (Paglabazar)',NULL,NULL,NULL,'CO0067','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01716006384',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 19:56:26','2023-11-04 19:56:26'),(68,1,'customer',NULL,'Mahbub Bhai(Hiramon)',NULL,'Mahbub Bhai(Hiramon)',NULL,NULL,NULL,'CO0068','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01715642401',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:41:28','2023-11-05 10:41:28'),(69,1,'customer',NULL,'Kollol Babu (Mediplus)',NULL,'Kollol Babu (Mediplus)',NULL,NULL,NULL,'CO0069','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01725617438',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:49:55','2023-11-05 10:49:55'),(70,1,'customer',NULL,'Bipul Babu (Motor)',NULL,'Bipul Babu (Motor)',NULL,NULL,NULL,'CO0070','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:27:34','2023-11-05 11:27:34'),(71,1,'customer',NULL,'Shofik Hobigonj',NULL,'Shofik Hobigonj',NULL,NULL,NULL,'CO0071','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01314797346',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 16:46:08','2023-11-05 16:46:08'),(72,1,'customer',NULL,'Manik Court (Biron)',NULL,'Manik Court (Biron)',NULL,NULL,NULL,'CO0072','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01784671965',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:13:11','2023-11-05 17:13:11'),(73,1,'supplier','M/S Haji Babul Enterprise','',NULL,NULL,NULL,NULL,NULL,'CO0073','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01715128830',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:37:44','2023-11-05 17:37:44'),(74,1,'customer',NULL,'Builders, Jailroad',NULL,'Builders, Jailroad',NULL,NULL,NULL,'CO0074','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'000',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:42:29','2023-11-05 17:42:29'),(75,1,'customer',NULL,'Monnan Cha',NULL,'Monnan Cha',NULL,NULL,NULL,'CO0075','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01673699312',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:30:08','2023-11-06 10:30:08'),(76,1,'supplier','M/s Maher Brothers','',NULL,NULL,NULL,NULL,NULL,'CO0076','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711041232',NULL,'01726656380',NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:53:32','2023-11-06 14:53:32'),(77,1,'customer','Woondal Restaurent','',NULL,NULL,NULL,NULL,NULL,'CO0077','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01688111760',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 11:02:08','2023-11-07 11:02:08'),(78,1,'supplier','Kutub Ali Horipur','',NULL,NULL,NULL,NULL,NULL,'CO0078','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01763182203',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:59:34','2023-11-07 14:59:34'),(79,1,'customer',NULL,'Liakot Bhai (tara mia & sons)',NULL,'Liakot Bhai (tara mia & sons)',NULL,NULL,NULL,'CO0079','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711198262',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:42:56','2023-11-08 18:42:56'),(80,1,'customer',NULL,'Monna Dim Nairpul',NULL,'Monna Dim Nairpul',NULL,NULL,NULL,'CO0080','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01912677447',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:31:05','2023-11-09 12:31:05'),(81,1,'customer',NULL,'Shahjahan Tela kumarpara',NULL,'Shahjahan Tela kumarpara',NULL,NULL,NULL,'CO0081','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01708548025',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:16:08','2023-11-21 10:48:01'),(82,1,'customer',NULL,'Imran Royel Kitchen',NULL,'Imran Royel Kitchen',NULL,NULL,NULL,'CO0082','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01742627218',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 18:05:58','2023-11-09 18:05:58'),(83,1,'supplier',NULL,'others suppliers',NULL,'others suppliers',NULL,NULL,NULL,'CO0083','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0124',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:41:27','2023-11-11 10:41:27'),(84,1,'customer',NULL,'Mahin or Maa',NULL,'Mahin or Maa',NULL,NULL,NULL,'CO0084','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01874135628',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:52:57','2023-11-11 11:52:57'),(85,1,'customer',NULL,'Yasmin Uposhohor',NULL,'Yasmin Uposhohor',NULL,NULL,NULL,'CO0085','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01729899690',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:01:05','2023-11-12 12:01:05'),(86,1,'customer','SEASONS','',NULL,NULL,NULL,NULL,NULL,'CO0086','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01716009447',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:09:13','2023-11-12 12:09:13'),(87,1,'customer',NULL,'Shofik (nazim) kamalbazar',NULL,'Shofik (nazim) kamalbazar',NULL,NULL,NULL,'CO0087','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0120',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:33:03','2023-11-12 20:33:03'),(88,1,'customer',NULL,'Moyur chacha',NULL,'Moyur chacha',NULL,NULL,NULL,'CO0088','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01819568192',NULL,NULL,NULL,NULL,NULL,3,1400.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:55:22','2023-11-21 13:29:59'),(89,1,'customer',NULL,'Munu Chacha',NULL,'Munu Chacha',NULL,NULL,NULL,'CO0089','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01882956659',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:28:59','2023-11-14 18:28:59'),(90,1,'supplier','Efran semi auto rice mill','',NULL,NULL,NULL,NULL,NULL,'CO0090','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01714768651',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 19:45:26','2023-11-14 19:45:26'),(91,1,'customer',NULL,'Mishtu (golden city)',NULL,'Mishtu (golden city)',NULL,NULL,NULL,'CO0091','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01712063152',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:10:32','2023-11-16 12:10:32'),(92,1,'customer','Nozrul Store (Ripon Vi)','',NULL,NULL,NULL,NULL,NULL,'CO0092','active',NULL,NULL,NULL,NULL,'Amborkhana Point ,Sylhet',NULL,NULL,NULL,'01785541521',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:31:42','2023-11-16 12:31:42'),(93,1,'customer',NULL,'Pakki mia (dim)',NULL,'Pakki mia (dim)',NULL,NULL,NULL,'CO0093','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01739752451',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:10:29','2023-11-16 17:10:29'),(94,1,'customer',NULL,'Nilkanto Singh Chacha',NULL,'Nilkanto Singh Chacha',NULL,NULL,NULL,'CO0094','active',NULL,NULL,NULL,NULL,'Abash - 26 , Raykeli House ,Jailroad',NULL,NULL,NULL,'01717802009',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-21 11:09:43','2023-11-21 11:10:53'),(95,1,'supplier','Nurul islam (baniachong)','',NULL,NULL,NULL,NULL,NULL,'CO0095','active',NULL,NULL,'Hobigonj','Bangladesh','Baniachong',NULL,NULL,NULL,'01705377075',NULL,NULL,NULL,NULL,NULL,3,150000.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-21 17:24:25','2023-11-21 13:52:04','2023-11-21 17:24:25'),(96,1,'supplier',NULL,'Nurul Islam Baniachong',NULL,'Nurul Islam Baniachong',NULL,NULL,NULL,'CO0096','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'004',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-21 17:26:14','2023-11-21 17:26:14'),(97,1,'customer',NULL,'Foruk Bhai Uposhohor c/o kajol babu',NULL,'Foruk Bhai Uposhohor c/o kajol babu',NULL,NULL,NULL,'CO0097','active',NULL,NULL,NULL,NULL,'Uposhohor',NULL,NULL,NULL,'01717507814',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-22 11:34:33','2023-11-22 12:17:49'),(98,1,'supplier',NULL,'Korim Bhai (chatak)',NULL,'Korim Bhai (chatak)',NULL,NULL,NULL,'CO0098','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01722740008',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-22 13:41:09','2023-11-22 13:41:09'),(99,1,'customer','Kosthury Restaurent','',NULL,NULL,NULL,NULL,NULL,'CO0099','active',NULL,NULL,NULL,NULL,'Jailroad baruthkhana,Sylhet',NULL,NULL,NULL,'111',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-23 13:38:02','2023-11-23 13:38:02'),(100,1,'customer',NULL,'Faruk Cha Uposhohor',NULL,'Faruk Cha Uposhohor',NULL,NULL,NULL,'CO0100','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1110',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-23 18:00:20','2023-11-23 18:00:20'),(101,1,'customer',NULL,'Oruni Kitchin',NULL,'Oruni Kitchin',NULL,NULL,NULL,'CO0101','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01711273896',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-25 11:27:01','2023-11-25 11:27:01');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
INSERT INTO `customer_groups` VALUES (1,1,'Regular customer',0.00,'percentage',NULL,3,'2023-10-29 17:57:01','2023-10-29 17:57:01');
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `spg` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `empty_product_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empty_product_returns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `brand_id` bigint(20) unsigned DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `empty_product_returns` WRITE;
/*!40000 ALTER TABLE `empty_product_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `empty_product_returns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
INSERT INTO `expense_categories` VALUES (1,'Shipping cost',1,NULL,NULL,NULL,'2023-10-21 20:05:23','2023-10-21 20:05:23'),(2,'Kajol Babu Salary',1,NULL,NULL,NULL,'2023-10-27 19:24:17','2023-10-27 19:26:24'),(3,'Arman (Delivery Cost)',1,NULL,NULL,NULL,'2023-10-27 19:25:22','2023-10-27 19:25:22'),(4,'Tea and Others Exp',1,NULL,NULL,NULL,'2023-10-27 19:28:23','2023-10-27 19:28:23'),(5,'Electricity Exp',1,NULL,NULL,NULL,'2023-10-27 19:28:43','2023-10-27 19:28:43'),(6,'Software & WiFi Exp',1,NULL,NULL,NULL,'2023-10-27 19:29:12','2023-10-27 19:29:12'),(7,'Home Expense',1,NULL,NULL,NULL,'2023-10-27 19:34:30','2023-10-27 19:34:30'),(8,'Other Expenses',1,NULL,NULL,NULL,'2023-10-27 19:35:16','2023-10-27 19:35:16'),(9,'Zakat',1,NULL,NULL,NULL,'2023-10-29 18:49:27','2023-10-29 18:49:27');
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `round_off_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT '0',
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_time_format` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT '1',
  `show_brand` tinyint(1) NOT NULL DEFAULT '0',
  `show_sku` tinyint(1) NOT NULL DEFAULT '1',
  `show_cat_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_expiry` tinyint(1) NOT NULL DEFAULT '0',
  `show_lot` tinyint(1) NOT NULL DEFAULT '0',
  `show_image` tinyint(1) NOT NULL DEFAULT '0',
  `show_sale_description` tinyint(1) NOT NULL DEFAULT '0',
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT '0',
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_business_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_location_name` tinyint(1) NOT NULL DEFAULT '1',
  `show_landmark` tinyint(1) NOT NULL DEFAULT '1',
  `show_city` tinyint(1) NOT NULL DEFAULT '1',
  `show_state` tinyint(1) NOT NULL DEFAULT '1',
  `show_zip_code` tinyint(1) NOT NULL DEFAULT '1',
  `show_country` tinyint(1) NOT NULL DEFAULT '1',
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT '1',
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT '0',
  `show_email` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax_1` tinyint(1) NOT NULL DEFAULT '1',
  `show_tax_2` tinyint(1) NOT NULL DEFAULT '0',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '0',
  `show_payments` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer` tinyint(1) NOT NULL DEFAULT '0',
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commission_agent_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT '0',
  `show_reward_point` tinyint(1) NOT NULL DEFAULT '0',
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci,
  `module_info` text COLLATE utf8mb4_unicode_ci,
  `common_settings` text COLLATE utf8mb4_unicode_ci,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT '0',
  `letter_head` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT '0',
  `qr_code_fields` text COLLATE utf8mb4_unicode_ci,
  `design` varchar(190) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT '0',
  `prev_bal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_message` text COLLATE utf8mb4_unicode_ci,
  `change_return_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `contact_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `location_custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'চালান নং:',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'মোট','ছাড়','টেক্স','সর্বমোট',NULL,NULL,'সর্বমোট পেইড',0,NULL,NULL,'তারিখ:',NULL,1,0,1,1,0,0,0,0,NULL,0,'পণ্যের নাম','সংখ্যা','মূল্য','মোট',NULL,'1697636168_salam-enterprise-invoice.png',0,0,1,1,1,1,1,1,1,1,0,0,0,0,1,1,'গ্রাহকের নাম:',NULL,0,0,'#000000','<h6 style=\"text-align: center; line-height: 1;\"><strong><span style=\"font-size: 8pt; font-family: helvetica, arial, sans-serif;\">Software by Purobi Technologies. Tel: 01737361905</span></strong></h6>',NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,1,0,NULL,0,NULL,'slim',NULL,NULL,NULL,NULL,1,'মোট বাকি','<p class=\"x11i5rnm xat24cr x1mh8g0r x1vvkbs xtlvy1s\" style=\"text-align: center; margin-bottom: 0px;\"><strong><span style=\"font-size: 8pt;\">ধন্যবাদ, আবার আসবেন।</span></strong></p>','ফেরত',NULL,NULL,NULL,'2023-10-15 17:32:12','2023-11-12 19:42:57');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT '0',
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank',NULL,1,976,4,1,'2023-10-15 17:32:12','2023-11-25 13:59:44');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_media_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=297 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(289,'2023_03_28_152513_create_take_profits_table',1),(290,'2023_06_20_173420_create_trades_table',1),(291,'2023_09_05_142140_create_product_dues_table',1),(292,'2023_09_05_175824_create_returnable_product_stocks_table',1),(293,'2023_09_09_122811_create_empty_product_returns_table',1),(294,'2023_09_13_162129_create_orders_table',1),(295,'2023_09_14_122227_create_order_items_table',1),(296,'2023_09_16_162041_add_transporter_id_to_transactions_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (92,'App\\User',1),(94,'App\\User',2),(92,'App\\User',3);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(2,'App\\User',2),(1,'App\\User',3);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `whatsapp_text` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bcc` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT '0',
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `order_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `order_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_items_product_id_foreign` (`product_id`),
  KEY `order_items_variation_id_foreign` (`variation_id`),
  CONSTRAINT `order_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `order_items_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `order_items` WRITE;
/*!40000 ALTER TABLE `order_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `order_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `invoice_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_notes` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orders_business_id_foreign` (`business_id`),
  KEY `orders_contact_id_foreign` (`contact_id`),
  KEY `orders_created_by_foreign` (`created_by`),
  CONSTRAINT `orders_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `orders_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `orders_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2023-09-30 13:27:06',NULL),(2,'direct_sell.access','web','2023-09-30 13:27:06',NULL),(3,'product.opening_stock','web','2023-09-30 13:27:11','2023-09-30 13:27:11'),(4,'crud_all_bookings','web','2023-09-30 13:27:12','2023-09-30 13:27:12'),(5,'crud_own_bookings','web','2023-09-30 13:27:12','2023-09-30 13:27:12'),(6,'access_default_selling_price','web','2023-09-30 13:27:13','2023-09-30 13:27:13'),(7,'purchase.payments','web','2023-09-30 13:27:14','2023-09-30 13:27:14'),(8,'sell.payments','web','2023-09-30 13:27:14','2023-09-30 13:27:14'),(9,'edit_product_price_from_sale_screen','web','2023-09-30 13:27:14','2023-09-30 13:27:14'),(10,'edit_product_discount_from_sale_screen','web','2023-09-30 13:27:14','2023-09-30 13:27:14'),(11,'roles.view','web','2023-09-30 13:27:15','2023-09-30 13:27:15'),(12,'roles.create','web','2023-09-30 13:27:15','2023-09-30 13:27:15'),(13,'roles.update','web','2023-09-30 13:27:15','2023-09-30 13:27:15'),(14,'roles.delete','web','2023-09-30 13:27:15','2023-09-30 13:27:15'),(15,'account.access','web','2023-09-30 13:27:16','2023-09-30 13:27:16'),(16,'discount.access','web','2023-09-30 13:27:16','2023-09-30 13:27:16'),(17,'view_purchase_price','web','2023-09-30 13:27:17','2023-09-30 13:27:17'),(18,'view_own_sell_only','web','2023-09-30 13:27:17','2023-09-30 13:27:17'),(19,'edit_product_discount_from_pos_screen','web','2023-09-30 13:27:18','2023-09-30 13:27:18'),(20,'edit_product_price_from_pos_screen','web','2023-09-30 13:27:18','2023-09-30 13:27:18'),(21,'access_shipping','web','2023-09-30 13:27:18','2023-09-30 13:27:18'),(22,'purchase.update_status','web','2023-09-30 13:27:19','2023-09-30 13:27:19'),(23,'list_drafts','web','2023-09-30 13:27:19','2023-09-30 13:27:19'),(24,'list_quotations','web','2023-09-30 13:27:19','2023-09-30 13:27:19'),(25,'view_cash_register','web','2023-09-30 13:27:21','2023-09-30 13:27:21'),(26,'close_cash_register','web','2023-09-30 13:27:21','2023-09-30 13:27:21'),(27,'print_invoice','web','2023-09-30 13:27:24','2023-09-30 13:27:24'),(28,'user.view','web','2023-09-30 13:27:28',NULL),(29,'user.create','web','2023-09-30 13:27:28',NULL),(30,'user.update','web','2023-09-30 13:27:28',NULL),(31,'user.delete','web','2023-09-30 13:27:28',NULL),(32,'supplier.view','web','2023-09-30 13:27:28',NULL),(33,'supplier.create','web','2023-09-30 13:27:28',NULL),(34,'supplier.update','web','2023-09-30 13:27:28',NULL),(35,'supplier.delete','web','2023-09-30 13:27:28',NULL),(36,'customer.view','web','2023-09-30 13:27:28',NULL),(37,'customer.create','web','2023-09-30 13:27:28',NULL),(38,'customer.update','web','2023-09-30 13:27:28',NULL),(39,'customer.delete','web','2023-09-30 13:27:28',NULL),(40,'product.view','web','2023-09-30 13:27:28',NULL),(41,'product.create','web','2023-09-30 13:27:28',NULL),(42,'product.update','web','2023-09-30 13:27:28',NULL),(43,'product.delete','web','2023-09-30 13:27:28',NULL),(44,'purchase.view','web','2023-09-30 13:27:28',NULL),(45,'purchase.create','web','2023-09-30 13:27:28',NULL),(46,'purchase.update','web','2023-09-30 13:27:28',NULL),(47,'purchase.delete','web','2023-09-30 13:27:28',NULL),(48,'sell.view','web','2023-09-30 13:27:28',NULL),(49,'sell.create','web','2023-09-30 13:27:28',NULL),(50,'sell.update','web','2023-09-30 13:27:28',NULL),(51,'sell.delete','web','2023-09-30 13:27:28',NULL),(52,'purchase_n_sell_report.view','web','2023-09-30 13:27:28',NULL),(53,'contacts_report.view','web','2023-09-30 13:27:28',NULL),(54,'stock_report.view','web','2023-09-30 13:27:28',NULL),(55,'tax_report.view','web','2023-09-30 13:27:28',NULL),(56,'trending_product_report.view','web','2023-09-30 13:27:28',NULL),(57,'register_report.view','web','2023-09-30 13:27:28',NULL),(58,'sales_representative.view','web','2023-09-30 13:27:28',NULL),(59,'expense_report.view','web','2023-09-30 13:27:28',NULL),(60,'business_settings.access','web','2023-09-30 13:27:28',NULL),(61,'barcode_settings.access','web','2023-09-30 13:27:28',NULL),(62,'invoice_settings.access','web','2023-09-30 13:27:28',NULL),(63,'brand.view','web','2023-09-30 13:27:28',NULL),(64,'brand.create','web','2023-09-30 13:27:28',NULL),(65,'brand.update','web','2023-09-30 13:27:28',NULL),(66,'brand.delete','web','2023-09-30 13:27:28',NULL),(67,'tax_rate.view','web','2023-09-30 13:27:28',NULL),(68,'tax_rate.create','web','2023-09-30 13:27:28',NULL),(69,'tax_rate.update','web','2023-09-30 13:27:28',NULL),(70,'tax_rate.delete','web','2023-09-30 13:27:28',NULL),(71,'unit.view','web','2023-09-30 13:27:28',NULL),(72,'unit.create','web','2023-09-30 13:27:28',NULL),(73,'unit.update','web','2023-09-30 13:27:28',NULL),(74,'unit.delete','web','2023-09-30 13:27:28',NULL),(75,'take_profit.view','web','2023-09-30 13:27:28',NULL),(76,'take_profit.create','web','2023-09-30 13:27:28',NULL),(77,'take_profit.update','web','2023-09-30 13:27:28',NULL),(78,'take_profit.delete','web','2023-09-30 13:27:28',NULL),(79,'trade.view','web','2023-09-30 13:27:28',NULL),(80,'trade.create','web','2023-09-30 13:27:28',NULL),(81,'trade.update','web','2023-09-30 13:27:28',NULL),(82,'trade.delete','web','2023-09-30 13:27:28',NULL),(83,'cylinder.view','web','2023-09-30 13:27:28',NULL),(84,'cylinder.create','web','2023-09-30 13:27:28',NULL),(85,'cylinder.update','web','2023-09-30 13:27:28',NULL),(86,'cylinder.delete','web','2023-09-30 13:27:28',NULL),(87,'category.view','web','2023-09-30 13:27:28',NULL),(88,'category.create','web','2023-09-30 13:27:28',NULL),(89,'category.update','web','2023-09-30 13:27:28',NULL),(90,'category.delete','web','2023-09-30 13:27:28',NULL),(91,'expense.access','web','2023-09-30 13:27:28',NULL),(92,'access_all_locations','web','2023-09-30 13:27:28',NULL),(93,'dashboard.data','web','2023-09-30 13:27:28',NULL),(94,'location.1','web','2023-10-15 17:32:12','2023-10-15 17:32:12'),(95,'view_export_buttons','web','2023-11-23 13:48:37','2023-11-23 13:48:37'),(96,'edit_purchase_payment','web','2023-11-23 13:48:37','2023-11-23 13:48:37'),(97,'delete_purchase_payment','web','2023-11-23 13:48:37','2023-11-23 13:48:37'),(98,'edit_pos_payment','web','2023-11-23 13:48:37','2023-11-23 13:48:37'),(99,'view_paid_sells_only','web','2023-11-23 13:48:37','2023-11-23 13:48:37'),(100,'view_due_sells_only','web','2023-11-23 13:48:37','2023-11-23 13:48:37'),(101,'view_partial_sells_only','web','2023-11-23 13:48:37','2023-11-23 13:48:37'),(102,'view_overdue_sells_only','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(103,'direct_sell.update','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(104,'direct_sell.delete','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(105,'view_commission_agent_sell','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(106,'edit_sell_payment','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(107,'delete_sell_payment','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(108,'access_sell_return','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(109,'access_own_sell_return','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(110,'edit_invoice_number','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(111,'draft.update','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(112,'draft.delete','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(113,'quotation.update','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(114,'quotation.delete','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(115,'access_pending_shipments_only','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(116,'access_commission_agent_shipping','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(117,'expense.add','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(118,'expense.edit','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(119,'expense.delete','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(120,'customer_irrespective_of_sell','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(121,'view_own_purchase','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(122,'direct_sell.view','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(123,'draft.view_all','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(124,'quotation.view_all','web','2023-11-23 13:48:38','2023-11-23 13:48:38'),(125,'all_expense.access','web','2023-11-23 13:48:38','2023-11-23 13:48:38');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_dues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_dues` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `brand_id` bigint(20) unsigned DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `type` enum('Collection','Due') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Due',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_dues` WRITE;
/*!40000 ALTER TABLE `product_dues` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_dues` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(65,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(95,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(146,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(165,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(172,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(180,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(190,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(207,1),(208,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (169,1,'বস্তা',169,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(170,1,'বস্তা',170,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(171,1,'বস্তা',171,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(172,NULL,'DUMMY',172,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(173,1,'বস্তা',173,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(174,1,'বস্তা',174,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(175,1,'বস্তা',175,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(176,1,'বস্তা',176,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(177,1,'বস্তা',177,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(178,1,'বস্তা',178,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(179,1,'বস্তা',179,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(180,1,'বস্তা',180,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(181,1,'বস্তা',181,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(182,NULL,'DUMMY',182,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(183,1,'বস্তা',183,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(184,NULL,'DUMMY',184,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(185,NULL,'DUMMY',185,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(186,NULL,'DUMMY',186,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(187,NULL,'DUMMY',187,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(188,NULL,'DUMMY',188,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(189,NULL,'DUMMY',189,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(190,1,'বস্তা',190,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(191,1,'বস্তা',191,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(192,NULL,'DUMMY',192,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(193,NULL,'DUMMY',193,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(194,NULL,'DUMMY',194,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(195,NULL,'DUMMY',195,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(196,NULL,'DUMMY',196,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(197,1,'বস্তা',197,0,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(198,NULL,'DUMMY',198,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(199,NULL,'DUMMY',199,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(200,NULL,'DUMMY',200,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(201,NULL,'DUMMY',201,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(202,NULL,'DUMMY',202,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(203,NULL,'DUMMY',203,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(204,NULL,'DUMMY',204,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(205,NULL,'DUMMY',205,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(206,NULL,'DUMMY',206,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(207,NULL,'DUMMY',207,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(208,NULL,'DUMMY',208,1,'2023-10-19 18:06:24','2023-10-19 18:06:24'),(209,NULL,'DUMMY',209,1,'2023-10-25 14:19:40','2023-10-25 14:19:40'),(210,NULL,'DUMMY',210,1,'2023-10-25 14:27:55','2023-10-25 14:27:55'),(211,NULL,'DUMMY',211,1,'2023-10-25 14:29:25','2023-10-25 14:29:25'),(212,NULL,'DUMMY',212,1,'2023-10-25 14:34:26','2023-10-25 14:34:26'),(213,NULL,'DUMMY',213,1,'2023-10-30 13:52:53','2023-10-30 13:52:53'),(214,NULL,'DUMMY',214,1,'2023-10-30 17:56:08','2023-10-30 17:56:08'),(215,NULL,'DUMMY',215,1,'2023-11-07 15:03:14','2023-11-07 15:03:14');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text COLLATE utf8mb4_unicode_ci,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT '0',
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT '0',
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT '0',
  `not_for_selling` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (169,'ACI কাটারি ভুগ',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'103','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697724128_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 19:22:55'),(170,'Jahanara জাহানারা কাটারি ভুগ',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'114','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881962_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 18:36:26'),(171,'Mofiz Katari - মফিজ কাটারি ভুগ চাল',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'125','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-29 20:19:18'),(172,'Rupchanda Katari - রুপচাদা কাটারি ভুগ চাল ২৫ কেজি',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'133','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-23 01:39:16'),(173,'Rojonigonda রজনীগন্ধা জিরা সিদ্ধ',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'129','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-23 10:51:46'),(174,'Khan Jira খান জিরা সিদ্ধ',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'118','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 18:40:09'),(175,'Solidসলিড জিরা সিদ্ধ চাল',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'136','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 20:00:35'),(176,'katari কাটারি আতব',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'117','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697882028_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-22 12:19:57'),(177,'S Alom এস আলম মিনিকেট সিদ্ধ',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'134','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 14:31:31'),(178,'Surjomukhiসূর্যমুখী মিনিকেট সিদ্ধ',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'139','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 19:56:42'),(179,'Nabilনাবিল মিনিকেট সিদ্ধ',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'126','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 19:52:43'),(180,'Dolphin ডলফিন কাজল লতা চাল',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881892_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 19:25:30'),(181,'Aam কাজল লতা',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'101','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697724076_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 19:21:52'),(182,'Mojumdarমজুমদার কাটারি ভুগ সিদ্ধ২৫kg',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'moj','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 17:48:15'),(183,'ACi চিনিগুড়া চাল',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'102','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697724096_kajal-lata-rice-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 19:23:45'),(184,'Sonar Chabiসোনার চাবি নবাব চিনিগুড়া২৫',1,'single',2,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'no25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 19:58:42'),(185,'Kibriya কিবরিয়া চিনিগুড়া২৫KG',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'119','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 18:41:47'),(186,'Sunar Chabiসোনার চাবি চিনিগুড়া৫০',1,'single',2,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'di50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-08 19:35:08'),(187,'Padmaপদ্মা মিনিকেট আতব৫০kg',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'pa50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 20:06:30'),(188,'Doyel দোয়েল মিনিকেট আতব ৫০KG',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'du50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881911_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 18:34:17'),(189,'Violaভিওলা মিনিকেট আতব২৫kg',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'vi25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 19:54:36'),(190,'Ilish ইলিশ সুপার মালা',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'113','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881944_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 19:25:53'),(191,'JuraSonkkoনাজিরশাইল',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'115','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881977_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 18:37:22'),(192,'Mojumderমজুমদার নাজিরশাইল২৫kg',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'mo','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 19:51:43'),(193,'Akij নাজিরশাইল চাল ২৫KG',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'ak25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881766_chinigura-rice-premium-1-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 15:11:45'),(194,'Nurjahanনুরজাহান পাইজাম সিদ্ধ৫০kg',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'127','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 19:53:51'),(195,'Atik পাইজাম সিদ্ধ ৫০KG',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'at50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881807_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 14:27:34'),(196,'Akij পাইজাম সিদ্ধ ৫০KG',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'ak50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881784_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,1,0,'2023-10-19 18:06:24','2023-11-20 18:46:45'),(197,'Bokul  বকুল মালা আতব চাল',1,'variable',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'108','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881861_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-20 19:50:01'),(198,'Chabi চাবি মালা আতব চাল ৫০ কেজি',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'109','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881877_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 18:32:46'),(199,'Hira / Mukta  হিরা/মুক্তা আতব৫০KG',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'hi50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881926_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-31 18:34:59'),(200,'Mofizমফিজ চিনিগুড়া',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'124','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 19:26:33'),(201,'Lal Biron Rice - লাল বিরন চাল ১ কেজি',1,'single',2,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'121','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-23 01:22:17'),(202,'Sada Biron Rice - সাদা বিরন চাল ১ কেজি',1,'single',2,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'135','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-23 01:41:35'),(203,'Rotnaরত্না সিদ্ধ চাল ৫০kg',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'132','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-01 20:01:12'),(204,'Basmati সিদ্ধ ২৫KG',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'ba25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881837_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-14 14:28:12'),(205,'Kalijira কালিজিরা চাল',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'kal','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1697881996_nazirshail-rice-premium-half-boiled-50-gm-5-kg.webp',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-22 12:19:01'),(206,'Rana Najir Rice - রানা নাজির চাল ২৫ কেজি',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'131','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-10-23 01:37:50'),(207,'Kibriya নাজির চাল ২৫ কেজি',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'pa25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2023-10-19 18:06:24','2023-11-23 10:52:29'),(208,'rojoniরজনীগন্ধা নাজির চাল ২৫ কেজি',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,5.0000,'..','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,1,0,'2023-10-19 18:06:24','2023-11-20 18:46:45'),(209,'Lichu Nazir (25 KG)',1,'single',4,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'li25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,0,0,'2023-10-25 14:19:40','2023-10-31 11:37:07'),(210,'Lichu Miniket (50 KG)',1,'single',4,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'142','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,1,0,'2023-10-25 14:27:55','2023-11-20 18:46:45'),(211,'Sunar Chavi Vug Atap (25KG)',1,'single',4,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'143','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,1,0,'2023-10-25 14:29:25','2023-11-09 19:03:26'),(212,'Sonar chabi Dinajpur chinigura (25KG)',1,'single',4,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'di25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,0,0,'2023-10-25 14:34:26','2023-10-30 14:57:24'),(213,'Suhed Mala ( 50kg )',1,'single',4,NULL,NULL,NULL,2,NULL,NULL,'inclusive',1,NULL,'su50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,0,0,'2023-10-30 13:52:53','2023-10-30 13:52:53'),(214,'Horin Mala (50KG)',1,'single',4,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'ho50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,0,0,'2023-10-30 17:56:08','2023-10-30 17:56:08'),(215,'Tepi Atop 50kg',1,'single',4,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'te50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,NULL,0,0,'2023-11-07 15:03:14','2023-11-07 15:03:14');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_requisition_line_id` int(11) DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT '0.0000' COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (29,58,169,188,26.0000,0.0000,3097.0000,0.00,3097.0000,3097.0000,0.0000,NULL,NULL,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-24 19:38:50','2023-11-25 10:45:37'),(31,60,197,232,44.0000,0.0000,1140.0000,0.00,1140.0000,1140.0000,0.0000,NULL,NULL,NULL,44.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 11:40:10','2023-11-09 10:20:40'),(32,61,191,224,6.0000,0.0000,2670.0000,0.00,2670.0000,2670.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 11:43:37','2023-11-06 11:42:39'),(33,62,191,225,14.0000,0.0000,1335.0000,0.00,1335.0000,1335.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 11:45:01','2023-11-20 12:15:20'),(34,63,192,226,36.0000,0.0000,1554.0000,0.00,1554.0000,1554.0000,0.0000,NULL,NULL,NULL,36.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 11:50:47','2023-11-04 13:32:12'),(35,64,169,189,33.0000,0.0000,1554.0000,0.00,1554.0000,1554.0000,0.0000,NULL,NULL,NULL,33.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-12 10:54:56'),(36,64,174,197,21.0000,0.0000,3067.0000,0.00,3067.0000,3067.0000,0.0000,NULL,NULL,NULL,21.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-11 10:27:25'),(37,64,174,198,36.0000,0.0000,1544.0000,0.00,1544.0000,1544.0000,0.0000,NULL,NULL,NULL,30.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-25 11:00:47'),(38,64,175,199,26.0000,0.0000,2907.0000,0.00,2907.0000,2907.0000,0.0000,NULL,NULL,NULL,24.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-25 10:43:56'),(39,64,175,200,56.0000,0.0000,1404.0000,0.00,1404.0000,1404.0000,0.0000,NULL,NULL,NULL,31.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-21 10:41:23'),(40,64,177,203,77.0000,0.0000,2527.0000,0.00,2527.0000,2527.0000,0.0000,NULL,NULL,NULL,45.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-25 11:40:32'),(41,64,177,204,32.0000,0.0000,1274.0000,0.00,1274.0000,1274.0000,0.0000,NULL,NULL,NULL,28.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-23 19:31:33'),(42,64,179,207,40.0000,0.0000,2387.0000,0.00,2387.0000,2387.0000,0.0000,NULL,NULL,NULL,40.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-09 10:13:09'),(43,64,179,208,56.0000,0.0000,1204.0000,0.00,1204.0000,1204.0000,0.0000,NULL,NULL,NULL,35.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-25 11:04:58'),(44,64,180,209,10.0000,0.0000,2677.0000,0.00,2677.0000,2677.0000,0.0000,NULL,NULL,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-04 19:56:25'),(45,64,180,210,23.0000,0.0000,1364.0000,0.00,1364.0000,1364.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-25 13:55:27'),(46,64,181,211,12.0000,0.0000,2777.0000,0.00,2777.0000,2777.0000,0.0000,NULL,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-18 14:53:38'),(47,64,181,212,20.0000,0.0000,1404.0000,0.00,1404.0000,1404.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-21 14:27:45'),(48,64,182,213,9.0000,0.0000,1454.0000,0.00,1454.0000,1454.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-08 13:50:07'),(49,64,183,214,2.0000,0.0000,6307.0000,0.00,6307.0000,6307.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-15 12:29:43'),(50,64,183,215,12.0000,0.0000,3154.0000,0.00,3154.0000,3154.0000,0.0000,NULL,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-22 17:38:35'),(52,64,185,217,20.0000,0.0000,1504.0000,0.00,1504.0000,1504.0000,0.0000,NULL,NULL,NULL,18.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-22 10:55:11'),(53,64,186,218,22.0000,0.0000,2987.0000,0.00,2987.0000,2987.0000,0.0000,NULL,NULL,NULL,22.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-10-27 14:29:48'),(54,64,187,219,13.0000,0.0000,2750.0000,0.00,2750.0000,2750.0000,0.0000,NULL,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-06 10:16:21'),(55,64,188,220,33.0000,0.0000,2727.0000,0.00,2727.0000,2727.0000,0.0000,NULL,NULL,NULL,25.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-25 13:30:07'),(56,64,189,221,25.0000,0.0000,1424.0000,0.00,1424.0000,1424.0000,0.0000,NULL,NULL,NULL,25.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:30:38','2023-11-22 11:38:23'),(57,65,190,222,63.0000,0.0000,2587.0000,0.00,2587.0000,2587.0000,0.0000,NULL,NULL,NULL,63.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:35:17','2023-11-04 17:49:29'),(58,65,190,223,136.0000,0.0000,1294.0000,0.00,1294.0000,1294.0000,0.0000,NULL,NULL,NULL,136.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 12:35:17','2023-11-19 17:01:12'),(68,68,170,190,1.0000,0.0000,3130.0000,0.00,3130.0000,3130.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-10-27 14:47:33'),(69,68,170,191,26.0000,0.0000,1570.0000,0.00,1570.0000,1570.0000,0.0000,NULL,NULL,NULL,26.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-11-06 10:18:18'),(70,68,171,193,3.0000,0.0000,1570.0000,0.00,1570.0000,1570.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-10-29 21:36:02'),(71,68,173,195,7.0000,0.0000,3110.0000,0.00,3110.0000,3110.0000,0.0000,NULL,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-11-11 10:28:26'),(72,68,173,196,26.0000,0.0000,1575.0000,0.00,1575.0000,1575.0000,0.0000,NULL,NULL,NULL,23.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-11-23 17:53:08'),(73,68,178,205,12.0000,0.0000,2410.0000,0.00,2410.0000,2410.0000,0.0000,NULL,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-10-31 11:44:45'),(74,68,178,206,30.0000,0.0000,1210.0000,0.00,1210.0000,1210.0000,0.0000,NULL,NULL,NULL,28.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-11-23 19:17:52'),(75,68,200,235,11.0000,0.0000,3150.0000,0.00,3150.0000,3150.0000,0.0000,NULL,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:17:21','2023-11-23 11:44:00'),(76,69,209,244,56.0000,0.0000,1555.0000,0.00,1555.0000,1555.0000,0.0000,NULL,NULL,NULL,29.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:20:38','2023-11-22 17:37:55'),(77,60,197,231,154.0000,0.0000,2220.0000,0.00,2220.0000,2220.0000,0.0000,NULL,NULL,NULL,154.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:24:09','2023-11-16 13:24:12'),(78,70,210,245,3.0000,0.0000,2620.0000,0.00,2620.0000,2620.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:32:19','2023-11-09 20:02:40'),(79,70,211,246,5.0000,0.0000,1545.0000,0.00,1545.0000,1545.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:32:19','2023-10-31 17:47:28'),(80,70,172,194,21.0000,0.0000,1610.0000,0.00,1610.0000,1610.0000,0.0000,NULL,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:32:19','2023-11-18 17:34:54'),(81,70,201,236,13.0000,0.0000,70.0000,0.00,70.0000,70.0000,0.0000,NULL,NULL,NULL,13.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:32:19','2023-10-27 15:04:16'),(82,71,212,247,184.0000,0.0000,1480.0000,0.00,1480.0000,1480.0000,0.0000,NULL,NULL,NULL,184.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 14:35:37','2023-11-11 18:02:45'),(85,74,198,233,11.0000,0.0000,2350.0000,0.00,2350.0000,2350.0000,0.0000,NULL,NULL,NULL,11.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 15:10:36','2023-11-14 10:51:22'),(86,75,176,201,16.0000,0.0000,2530.0000,0.00,2530.0000,2530.0000,0.0000,NULL,NULL,NULL,16.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-25 19:02:11','2023-11-06 12:05:19'),(88,76,186,218,8500.0000,0.0000,59.1400,0.00,59.1400,59.1400,0.0000,NULL,NULL,NULL,8500.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,5,'2023-10-26 14:52:36','2023-11-05 17:53:28'),(89,64,184,216,300.0000,0.0000,96.0000,0.00,96.0000,96.0000,0.0000,NULL,NULL,NULL,28.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,6,'2023-10-26 14:54:15','2023-11-22 18:26:23'),(90,99,174,197,25.0000,0.0000,3067.0000,0.00,3067.0000,3067.0000,0.0000,NULL,NULL,NULL,17.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-27 20:26:57','2023-11-25 12:20:55'),(91,99,170,190,15.0000,0.0000,3080.0000,0.00,3080.0000,3080.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-27 20:26:57','2023-11-22 10:35:03'),(92,99,171,192,15.0000,0.0000,3080.0000,0.00,3080.0000,3080.0000,0.0000,NULL,NULL,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-27 20:26:57','2023-11-21 10:39:44'),(94,113,192,226,110.0000,0.0000,1574.0000,0.00,1574.0000,1574.0000,0.0000,NULL,NULL,NULL,86.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-28 20:15:10','2023-11-25 12:39:48'),(95,114,187,219,18.0000,0.0000,2770.0000,0.00,2770.0000,2770.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-28 20:17:16','2023-11-25 10:45:37'),(96,139,169,189,3.0000,0.0000,1570.0000,0.00,1570.0000,1570.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:02:15','2023-10-30 14:34:24'),(97,143,180,210,1.0000,0.0000,1364.0000,0.00,1364.0000,1364.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:26:55','2023-10-30 15:02:42'),(98,144,170,191,2.0000,0.0000,1570.0000,0.00,1570.0000,1570.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:28:08','2023-10-30 14:34:24'),(99,145,176,201,1.0000,0.0000,2530.0000,0.00,2530.0000,2530.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:30:10','2023-10-30 19:23:47'),(100,146,185,217,1.0000,0.0000,1504.0000,0.00,1504.0000,1504.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:31:56','2023-10-31 11:19:21'),(101,149,179,207,2.0000,0.0000,2387.0000,0.00,2387.0000,2387.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:38:35','2023-10-31 11:19:21'),(102,151,194,228,1.0000,0.0000,2365.0000,0.00,2365.0000,2365.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:40:18','2023-10-30 18:13:50'),(103,152,187,219,1.0000,0.0000,2770.0000,0.00,2770.0000,2770.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:40:42','2023-10-30 18:23:58'),(104,154,175,200,2.0000,0.0000,1404.0000,0.00,1404.0000,1404.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:43:10','2023-10-30 14:34:24'),(105,155,212,247,2.0000,0.0000,1480.0000,0.00,1480.0000,1480.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:43:47','2023-10-30 15:11:34'),(106,157,186,218,934.0000,0.0000,59.7400,0.00,59.7400,59.7400,0.0000,NULL,NULL,NULL,934.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-29 21:49:21','2023-10-31 12:58:52'),(107,160,213,248,70.0000,0.0000,2370.0000,0.00,2370.0000,2370.0000,0.0000,NULL,NULL,NULL,38.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-30 13:53:55','2023-11-21 14:20:19'),(108,180,194,228,20.0000,0.0000,2347.0000,0.00,2347.0000,2347.0000,0.0000,NULL,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-30 17:58:44','2023-11-20 11:35:34'),(109,180,197,231,40.0000,0.0000,2357.0000,0.00,2357.0000,2357.0000,0.0000,NULL,NULL,NULL,40.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-30 17:58:44','2023-11-22 17:40:57'),(110,180,214,249,20.0000,0.0000,2547.0000,0.00,2547.0000,2547.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-30 17:58:44','2023-11-20 11:33:30'),(111,191,204,239,30.0000,0.0000,1669.0000,0.00,1669.0000,1669.0000,0.0000,NULL,NULL,NULL,29.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-30 18:34:50','2023-11-25 10:45:37'),(112,238,169,189,80.0000,0.0000,1584.0000,0.00,1584.0000,1584.0000,0.0000,NULL,NULL,NULL,22.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-31 20:02:52','2023-11-25 12:36:32'),(113,238,182,213,40.0000,0.0000,1529.0000,0.00,1529.0000,1529.0000,0.0000,NULL,NULL,NULL,15.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-31 20:02:52','2023-11-23 11:03:58'),(114,239,176,202,36.0000,0.0000,1300.0000,0.00,1300.0000,1300.0000,0.0000,NULL,NULL,NULL,36.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-10-31 20:12:40','2023-11-18 14:53:38'),(115,257,180,209,20.0000,0.0000,2670.0000,0.00,2670.0000,2670.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-01 18:44:42','2023-11-20 17:55:46'),(117,297,207,242,40.0000,0.0000,1734.0000,0.00,1734.0000,1734.0000,0.0000,NULL,NULL,NULL,25.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-02 14:43:00','2023-11-25 11:15:27'),(118,371,170,191,40.0000,0.0000,1540.0000,0.00,1540.0000,1540.0000,0.0000,NULL,NULL,NULL,30.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-04 14:11:45','2023-11-25 10:47:57'),(119,371,171,193,40.0000,0.0000,1540.0000,0.00,1540.0000,1540.0000,0.0000,NULL,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-04 14:11:45','2023-11-25 10:45:37'),(120,371,170,190,30.0000,0.0000,3080.0000,0.00,3080.0000,3080.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-04 14:11:45','2023-11-04 14:11:45'),(121,371,171,192,30.0000,0.0000,3080.0000,0.00,3080.0000,3080.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-04 14:11:45','2023-11-21 19:27:20'),(123,383,190,222,55.0000,0.0000,2757.0000,0.00,2757.0000,2757.0000,0.0000,NULL,NULL,NULL,55.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-04 17:48:23','2023-11-25 11:08:11'),(124,435,186,218,2700.0000,0.0000,58.1400,0.00,58.1400,58.1400,0.0000,NULL,NULL,NULL,2700.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-05 17:40:41','2023-11-11 12:20:43'),(125,442,199,234,33.0000,0.0000,2107.0000,0.00,2107.0000,2107.0000,0.0000,NULL,NULL,NULL,33.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-05 17:52:49','2023-11-18 18:48:25'),(126,457,208,243,14.0000,0.0000,1440.0000,0.00,1440.0000,1440.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-05 19:47:46','2023-11-12 17:35:27'),(127,472,191,224,20.0000,0.0000,2707.0000,0.00,2707.0000,2707.0000,0.0000,NULL,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 11:45:21','2023-11-22 11:35:24'),(128,472,189,221,40.0000,0.0000,1424.0000,0.00,1424.0000,1424.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 11:45:21','2023-11-23 11:05:01'),(129,483,195,229,60.0000,0.0000,2523.0000,0.00,2523.0000,2523.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 13:59:29','2023-11-25 11:28:26'),(130,484,197,231,45.0000,0.0000,2407.0000,0.00,2407.0000,2407.0000,0.0000,NULL,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 14:01:13','2023-11-25 12:12:19'),(131,484,203,238,5.0000,0.0000,2197.0000,0.00,2197.0000,2197.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 14:01:13','2023-11-12 17:35:27'),(132,484,190,222,45.0000,0.0000,2737.0000,0.00,2737.0000,2737.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 14:01:13','2023-11-06 14:06:55'),(133,487,193,227,5.0000,0.0000,1584.0000,0.00,1584.0000,1584.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 14:16:53','2023-11-09 10:20:40'),(134,488,196,230,8.0000,0.0000,2495.0000,0.00,2495.0000,2495.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 14:17:30','2023-11-06 17:33:18'),(135,490,176,201,20.0000,0.0000,2590.0000,0.00,2590.0000,2590.0000,0.0000,NULL,NULL,NULL,20.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 14:20:57','2023-11-18 15:19:55'),(136,494,179,207,60.0000,0.0000,2496.0000,0.00,2496.0000,2496.0000,0.0000,NULL,NULL,NULL,26.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-06 14:54:14','2023-11-25 10:50:24'),(137,534,205,240,5.0000,0.0000,3850.0000,0.00,3850.0000,3850.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-07 10:31:10','2023-11-16 13:24:12'),(138,549,179,208,1.0000,0.0000,1204.0000,0.00,1204.0000,1204.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-07 15:05:43','2023-11-07 15:05:43'),(139,549,201,236,200.0000,0.0000,72.5000,0.00,72.5000,72.5000,0.0000,NULL,NULL,NULL,200.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-07 15:05:43','2023-11-14 13:59:01'),(140,549,215,250,7.0000,0.0000,2600.0000,0.00,2600.0000,2600.0000,0.0000,NULL,NULL,NULL,7.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-07 15:05:43','2023-11-09 12:31:41'),(141,585,206,241,9.0000,0.0000,1870.0000,0.00,1870.0000,1870.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-08 13:44:44','2023-11-23 19:31:48'),(142,600,205,240,1.0000,0.0000,3607.0000,0.00,3607.0000,3607.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-08 17:51:23','2023-11-19 12:53:40'),(143,600,199,234,20.0000,0.0000,2097.0000,0.00,2097.0000,2097.0000,0.0000,NULL,NULL,NULL,14.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-08 17:51:23','2023-11-25 11:00:47'),(144,628,186,218,10000.0000,0.0000,58.1400,0.00,58.1400,58.1400,0.0000,NULL,NULL,NULL,10000.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-09 12:40:31','2023-11-16 19:19:37'),(145,632,178,205,25.0000,0.0000,2580.0000,0.00,2580.0000,2580.0000,0.0000,NULL,NULL,NULL,8.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-09 13:33:13','2023-11-25 10:50:24'),(146,684,202,237,24.0000,0.0000,85.0000,0.00,85.0000,85.0000,0.0000,NULL,NULL,NULL,24.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 10:43:01','2023-11-11 11:39:02'),(147,714,206,241,20.0000,0.0000,1854.0000,0.00,1854.0000,1854.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 17:35:54','2023-11-11 17:35:54'),(148,715,175,199,8.0000,0.0000,3047.0000,0.00,3047.0000,3047.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 17:41:10','2023-11-11 17:41:10'),(149,715,205,240,2.0000,0.0000,3607.0000,0.00,3607.0000,3607.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 17:41:10','2023-11-23 10:30:26'),(150,716,200,235,18.0000,0.0000,3120.0000,0.00,3120.0000,3120.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 17:48:49','2023-11-23 13:38:28'),(151,716,176,201,20.0000,0.0000,2597.0000,0.00,2597.0000,2597.0000,0.0000,NULL,NULL,NULL,12.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 17:48:49','2023-11-25 11:57:21'),(152,716,176,202,40.0000,0.0000,1304.0000,0.00,1304.0000,1304.0000,0.0000,NULL,NULL,NULL,9.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 17:48:49','2023-11-23 17:56:14'),(153,716,173,195,15.0000,0.0000,3157.0000,0.00,3157.0000,3157.0000,0.0000,NULL,NULL,NULL,5.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-11 17:48:49','2023-11-22 19:12:39'),(154,795,197,232,40.0000,0.0000,1209.0000,0.00,1209.0000,1209.0000,0.0000,NULL,NULL,NULL,36.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-13 11:11:49','2023-11-25 12:07:59'),(155,811,187,219,30.0000,0.0000,2877.0000,0.00,2877.0000,2877.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-13 14:40:25','2023-11-13 14:40:25'),(156,815,197,232,10.0000,0.0000,1209.0000,0.00,1209.0000,1209.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-13 19:05:05','2023-11-13 19:05:05'),(157,815,203,238,10.0000,0.0000,2207.0000,0.00,2207.0000,2207.0000,0.0000,NULL,NULL,NULL,6.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-13 19:05:05','2023-11-21 10:38:04'),(158,855,192,226,80.0000,0.0000,1604.0000,0.00,1604.0000,1604.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-14 17:46:52','2023-11-14 17:46:52'),(161,871,197,232,20.0000,0.0000,1250.0000,0.00,1250.0000,1250.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 11:05:24','2023-11-15 11:12:32'),(162,871,198,233,70.0000,0.0000,2500.0000,0.00,2500.0000,2500.0000,0.0000,NULL,NULL,NULL,10.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 11:12:32','2023-11-25 13:57:24'),(163,899,199,234,10.0000,0.0000,2117.0000,0.00,2117.0000,2117.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 14:12:47','2023-11-15 14:12:47'),(164,899,215,250,5.0000,0.0000,2637.0000,0.00,2637.0000,2637.0000,0.0000,NULL,NULL,NULL,4.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 14:12:47','2023-11-20 11:58:35'),(165,899,169,189,10.0000,0.0000,1584.0000,0.00,1584.0000,1584.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 14:12:47','2023-11-15 14:12:47'),(166,902,197,231,160.0000,0.0000,2450.0000,0.00,2450.0000,2450.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 14:21:46','2023-11-15 14:21:46'),(167,902,205,240,10.0000,0.0000,3600.0000,0.00,3600.0000,3600.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 14:21:46','2023-11-23 17:56:14'),(168,902,197,232,100.0000,0.0000,1235.0000,0.00,1235.0000,1235.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-15 14:21:46','2023-11-15 14:21:46'),(169,935,186,218,1500.0000,0.0000,58.1400,0.00,58.1400,58.1400,0.0000,NULL,NULL,NULL,1500.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-16 17:06:52','2023-11-19 12:47:03'),(170,991,186,218,2500.0000,0.0000,58.1400,0.00,58.1400,58.1400,0.0000,NULL,NULL,NULL,2500.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-18 16:08:36','2023-11-21 14:43:10'),(171,1053,186,218,10000.0000,0.0000,58.0000,0.00,58.0000,58.0000,0.0000,NULL,NULL,NULL,7037.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-20 12:04:51','2023-11-25 13:59:44'),(172,1101,202,237,3500.0000,0.0000,50.0000,0.00,50.0000,50.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-21 17:27:50','2023-11-21 17:27:50'),(173,1118,190,222,40.0000,0.0000,2802.0000,0.00,2802.0000,2802.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-21 19:28:45','2023-11-21 19:28:45'),(174,1118,207,242,40.0000,0.0000,1752.0000,0.00,1752.0000,1752.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-21 19:28:45','2023-11-21 19:28:45'),(175,1118,183,215,5.0000,0.0000,3114.0000,0.00,3114.0000,3114.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-21 19:28:45','2023-11-21 19:28:45'),(176,1118,191,225,8.0000,0.0000,1364.0000,0.00,1364.0000,1364.0000,0.0000,NULL,NULL,NULL,3.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-21 19:28:45','2023-11-23 19:17:52'),(177,1118,191,224,16.0000,0.0000,2707.0000,0.00,2707.0000,2707.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-21 19:28:45','2023-11-21 19:28:45'),(178,1123,204,239,45.0000,0.0000,1694.0000,0.00,1694.0000,1694.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-21 20:07:12','2023-11-21 20:07:12'),(179,1134,169,188,20.0000,0.0000,3157.0000,0.00,3157.0000,3157.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-22 11:21:41','2023-11-22 11:21:41'),(180,1134,176,202,30.0000,0.0000,1304.0000,0.00,1304.0000,1304.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-22 11:21:41','2023-11-22 11:21:41'),(181,1134,174,197,20.0000,0.0000,3087.0000,0.00,3087.0000,3087.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-22 11:21:41','2023-11-22 11:21:41'),(182,1143,176,201,11.0000,0.0000,2607.0000,0.00,2607.0000,2607.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-22 12:54:10','2023-11-22 12:54:10'),(183,1146,215,250,17.0000,0.0000,2500.0000,0.00,2500.0000,2500.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-22 13:48:15','2023-11-22 13:48:15'),(184,1193,199,234,15.0000,0.0000,2080.0000,0.00,2080.0000,2080.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-23 13:42:39','2023-11-23 13:42:39'),(185,1199,171,193,40.0000,0.0000,1570.0000,0.00,1570.0000,1570.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-23 17:34:17','2023-11-23 17:34:17'),(186,1199,174,198,20.0000,0.0000,1550.0000,0.00,1550.0000,1550.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-23 17:34:17','2023-11-23 17:34:17'),(187,1199,173,196,10.0000,0.0000,1560.0000,0.00,1560.0000,1560.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-23 17:34:17','2023-11-23 17:34:17'),(188,1200,170,191,36.0000,0.0000,1590.0000,0.00,1590.0000,1590.0000,0.0000,NULL,NULL,NULL,0.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2023-11-23 17:38:29','2023-11-23 17:38:29');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES (1,'contacts',101,1,'2023-10-15 17:32:12','2023-11-25 11:27:01'),(2,'business_location',1,1,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(3,'purchase',73,1,'2023-10-15 18:24:30','2023-11-23 17:38:29'),(4,'purchase_payment',228,1,'2023-10-15 18:24:30','2023-11-25 14:02:26'),(5,'sell_payment',1294,1,'2023-10-15 18:28:40','2023-11-25 14:02:26'),(6,'sell_return',19,1,'2023-10-18 17:42:39','2023-11-21 11:26:13'),(7,'purchase_return',4,1,'2023-10-18 17:51:57','2023-10-25 13:52:01'),(8,'opening_balance',45,1,'2023-10-19 17:19:52','2023-11-13 12:57:39'),(9,'expense',104,1,'2023-10-21 20:05:52','2023-11-23 19:50:42'),(10,'expense_payment',7,1,'2023-10-21 20:06:23','2023-11-09 10:31:53'),(11,'draft',2,1,'2023-10-21 20:25:26','2023-11-05 17:48:19'),(12,'',2,1,'2023-10-28 17:49:29','2023-11-04 11:02:49');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `returnable_product_stocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `returnable_product_stocks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `brand_id` bigint(20) unsigned NOT NULL,
  `quantity` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `returnable_product_stocks` WRITE;
/*!40000 ALTER TABLE `returnable_product_stocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `returnable_product_stocks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (2,2),(3,2),(6,2),(7,2),(8,2),(9,2),(10,2),(16,2),(17,2),(19,2),(20,2),(21,2),(22,2),(25,2),(26,2),(27,2),(32,2),(33,2),(34,2),(35,2),(36,2),(37,2),(38,2),(39,2),(40,2),(41,2),(42,2),(43,2),(45,2),(46,2),(47,2),(48,2),(49,2),(50,2),(51,2),(63,2),(64,2),(65,2),(66,2),(71,2),(72,2),(73,2),(74,2),(87,2),(88,2),(89,2),(90,2),(93,2),(95,2),(96,2),(97,2),(98,2),(99,2),(100,2),(101,2),(102,2),(103,2),(104,2),(105,2),(106,2),(107,2),(108,2),(109,2),(110,2),(111,2),(112,2),(113,2),(114,2),(115,2),(116,2),(117,2),(118,2),(119,2),(120,2),(121,2),(122,2),(123,2),(124,2),(125,2);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `is_service_staff` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin#1','web',1,1,0,'2023-10-15 17:32:12','2023-10-15 17:32:12'),(2,'Cashier#1','web',1,0,0,'2023-10-15 17:32:12','2023-10-15 17:32:12');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES (1,'db_version','5.0'),(2,'default_business_active_status','1');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `take_profits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `take_profits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `amount` decimal(8,2) NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `take_profits` WRITE;
/*!40000 ALTER TABLE `take_profits` DISABLE KEYS */;
/*!40000 ALTER TABLE `take_profits` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `for_tax_group` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `trades`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `trades` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned NOT NULL,
  `is_will_get` tinyint(1) NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `trades` WRITE;
/*!40000 ALTER TABLE `trades` DISABLE KEYS */;
/*!40000 ALTER TABLE `trades` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT '0.0000',
  `method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_transaction_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_holder_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_month` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_year` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_security` varchar(5) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cheque_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_account_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT '0',
  `gateway` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT '0',
  `payment_for` int(11) DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_no` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1546 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES (27,NULL,1,0,250000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-21 20:03:00',3,0,NULL,1,26,NULL,NULL,NULL,'PP2023/0005',NULL,'2023-10-21 20:04:10','2023-10-21 20:04:10'),(30,37,1,0,330.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-21 20:06:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'2023/0001',NULL,'2023-10-21 20:06:23','2023-10-21 20:06:23'),(32,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-22 13:18:00',3,0,NULL,1,5,NULL,NULL,NULL,'SP2023/0025',NULL,'2023-10-22 13:18:56','2023-10-22 13:18:56'),(33,63,1,0,55944.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 11:45:00',3,0,NULL,0,29,NULL,NULL,NULL,'PP2023/0008',NULL,'2023-10-25 11:50:47','2023-10-25 11:50:47'),(34,64,1,0,1035097.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 11:53:00',3,0,NULL,0,28,NULL,NULL,NULL,'PP2023/0009',NULL,'2023-10-25 12:30:38','2023-10-25 12:30:38'),(36,58,1,0,61940.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 12:32:00',3,0,NULL,0,28,NULL,NULL,NULL,'PP2023/0011',NULL,'2023-10-25 12:33:02','2023-10-25 12:33:02'),(37,65,1,0,338965.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 12:33:00',3,0,NULL,0,30,NULL,NULL,NULL,'PP2023/0012',NULL,'2023-10-25 12:35:17','2023-10-25 12:35:17'),(39,68,1,0,15430.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 14:06:00',3,0,NULL,0,32,NULL,NULL,NULL,'PP2023/0014',NULL,'2023-10-25 14:17:21','2023-10-25 14:17:21'),(40,69,1,0,50278.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 14:17:00',3,0,NULL,0,29,NULL,NULL,NULL,'PP2023/0015',NULL,'2023-10-25 14:20:38','2023-10-25 14:20:38'),(41,60,1,0,229786.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 14:24:00',3,0,NULL,0,34,NULL,NULL,NULL,'PP2023/0016',NULL,'2023-10-25 14:25:06','2023-10-25 14:25:06'),(42,70,1,0,785.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 14:26:00',3,0,NULL,0,31,NULL,NULL,NULL,'PP2023/0017',NULL,'2023-10-25 14:32:19','2023-10-25 14:32:19'),(43,71,1,0,76620.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 14:32:00',3,0,NULL,0,33,NULL,NULL,NULL,'PP2023/0018',NULL,'2023-10-25 14:35:37','2023-10-25 14:35:37'),(45,73,1,0,6060.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 15:02:43',3,0,NULL,0,1,NULL,NULL,NULL,'SP2023/0026',NULL,'2023-10-25 15:02:43','2023-10-25 15:02:43'),(46,74,1,0,25850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 15:07:00',3,0,NULL,0,28,NULL,NULL,NULL,'PP2023/0020',NULL,'2023-10-25 15:10:36','2023-10-25 15:10:36'),(47,62,1,0,18690.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 18:21:00',3,0,NULL,0,31,NULL,NULL,NULL,'PP2023/0021',NULL,'2023-10-25 18:21:31','2023-10-25 18:21:31'),(48,61,1,0,16020.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 18:21:00',3,0,NULL,0,31,NULL,NULL,NULL,'PP2023/0022',NULL,'2023-10-25 18:22:04','2023-10-25 18:22:04'),(49,58,1,0,18582.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 18:22:00',3,0,NULL,0,28,NULL,NULL,NULL,'PP2023/0023',NULL,'2023-10-25 18:22:36','2023-10-25 18:22:36'),(50,75,1,0,40480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 19:00:00',3,0,NULL,0,32,NULL,NULL,NULL,'PP2023/0024',NULL,'2023-10-25 19:02:11','2023-10-25 19:02:11'),(51,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 20:29:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0025',NULL,'2023-10-25 20:29:45','2023-10-25 20:29:45'),(52,71,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 20:29:00',3,0,NULL,0,33,51,NULL,NULL,'PP2023/0026',NULL,'2023-10-25 20:29:45','2023-10-25 20:29:45'),(53,77,1,0,5370.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-25 20:34:15',3,0,NULL,0,1,NULL,NULL,NULL,'SP2023/0027',NULL,'2023-10-25 20:34:15','2023-10-27 23:28:21'),(54,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-26 12:42:00',3,0,NULL,1,34,NULL,NULL,NULL,'PP2023/0027',NULL,'2023-10-26 12:43:23','2023-10-26 12:43:23'),(55,60,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-26 12:42:00',3,0,NULL,0,34,54,NULL,NULL,'PP2023/0028',NULL,'2023-10-26 12:43:23','2023-10-26 12:43:23'),(56,78,1,0,36440.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-26 13:00:03',3,0,NULL,0,1,NULL,NULL,NULL,'SP2023/0028',NULL,'2023-10-26 13:00:03','2023-10-27 23:38:12'),(57,79,1,0,15110.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 14:05:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0029',NULL,'2023-10-27 14:05:25','2023-10-27 14:05:25'),(58,80,1,0,129930.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 14:29:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0030',NULL,'2023-10-27 14:29:48','2023-10-27 14:29:48'),(59,81,1,0,21330.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 14:47:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0031',NULL,'2023-10-27 14:47:33','2023-10-27 14:47:33'),(60,82,1,0,79192.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 15:01:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0032',NULL,'2023-10-27 15:01:40','2023-10-27 15:01:40'),(61,83,1,0,1040.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 15:04:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0033',NULL,'2023-10-27 15:04:16','2023-10-27 15:04:16'),(62,84,1,0,7600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 15:07:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0034',NULL,'2023-10-27 15:07:34','2023-10-27 15:07:34'),(63,85,1,0,9120.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 15:08:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0035',NULL,'2023-10-27 15:08:14','2023-10-27 15:08:14'),(64,86,1,0,18370.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 15:13:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0036',NULL,'2023-10-27 15:13:43','2023-10-27 15:13:43'),(65,87,1,0,76000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 15:16:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0037',NULL,'2023-10-27 15:16:47','2023-10-27 15:16:47'),(66,88,1,0,2400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 15:18:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0038',NULL,'2023-10-27 15:18:48','2023-10-27 15:18:48'),(67,101,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-27 23:49:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0039',NULL,'2023-10-27 23:49:40','2023-10-27 23:49:40'),(68,NULL,1,0,100940.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 17:49:00',3,0,NULL,1,37,NULL,NULL,NULL,'2023/0001',NULL,'2023-10-28 17:49:29','2023-10-28 17:49:29'),(70,106,1,0,25950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 17:58:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0040',NULL,'2023-10-28 17:58:57','2023-10-28 17:58:57'),(71,107,1,0,9640.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 18:12:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0041',NULL,'2023-10-28 18:12:44','2023-10-28 18:12:44'),(72,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 18:14:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0042',NULL,'2023-10-28 18:14:22','2023-10-28 18:14:22'),(73,97,1,0,2000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 18:14:00',3,0,NULL,0,36,72,NULL,NULL,'PP2023/0030',NULL,'2023-10-28 18:14:22','2023-10-28 18:14:22'),(75,109,1,0,12600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 18:38:17',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0044',NULL,'2023-10-28 18:38:17','2023-10-28 18:38:17'),(76,110,1,0,35180.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 18:51:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0045',NULL,'2023-10-28 18:51:27','2023-10-28 18:51:27'),(77,111,1,0,40620.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 18:57:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0046',NULL,'2023-10-28 18:57:11','2023-10-28 18:57:11'),(79,113,1,0,130000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 20:12:00',3,0,NULL,0,41,NULL,NULL,NULL,'PP2023/0031',NULL,'2023-10-28 20:15:10','2023-10-28 20:15:10'),(80,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 20:19:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0032',NULL,'2023-10-28 20:19:37','2023-10-28 20:19:37'),(81,71,1,0,95700.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 20:19:00',3,0,NULL,0,33,80,NULL,NULL,'PP2023/0033',NULL,'2023-10-28 20:19:37','2023-10-28 20:19:37'),(82,76,1,0,54300.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-28 20:19:00',3,0,NULL,0,33,80,NULL,NULL,'PP2023/0034',NULL,'2023-10-28 20:19:37','2023-10-28 20:19:37'),(83,115,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 17:38:54',3,0,NULL,0,36,NULL,NULL,NULL,'SE2023/0048',NULL,'2023-10-29 17:38:54','2023-10-29 17:38:54'),(84,116,1,0,56561.0400,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 17:45:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0049',NULL,'2023-10-29 17:45:19','2023-10-29 17:45:19'),(85,117,1,0,33068.9500,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:13:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0050',NULL,'2023-10-29 18:13:27','2023-10-29 18:13:27'),(86,118,1,0,30660.0200,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:20:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0051',NULL,'2023-10-29 18:20:12','2023-10-29 18:20:12'),(87,119,1,0,26150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:25:17',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0052',NULL,'2023-10-29 18:25:17','2023-10-29 18:25:17'),(88,124,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:39:13',3,0,NULL,0,43,NULL,NULL,NULL,'SE2023/0053',NULL,'2023-10-29 18:39:13','2023-10-29 18:39:13'),(89,125,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:40:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0054',NULL,'2023-10-29 18:40:30','2023-10-29 18:40:30'),(90,NULL,1,0,20000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:42:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0055',NULL,'2023-10-29 18:42:55','2023-10-29 18:42:55'),(91,105,1,0,20000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:42:00',3,0,NULL,0,35,90,NULL,NULL,'PP2023/0035',NULL,'2023-10-29 18:42:55','2023-10-29 18:42:55'),(92,NULL,1,0,10000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:45:00',3,0,NULL,1,8,NULL,NULL,NULL,'SE2023/0056',NULL,'2023-10-29 18:45:33','2023-10-29 18:45:33'),(93,42,1,0,10000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:45:00',3,0,NULL,0,8,92,NULL,NULL,'PP2023/0036',NULL,'2023-10-29 18:45:33','2023-10-29 18:45:33'),(94,127,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:47:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0057',NULL,'2023-10-29 18:49:00','2023-10-29 18:49:00'),(95,128,1,0,25000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:49:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0058',NULL,'2023-10-29 18:50:23','2023-10-29 18:50:23'),(96,NULL,1,0,169075.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:55:00',3,0,NULL,1,32,NULL,NULL,NULL,'PP2023/0037',NULL,'2023-10-29 18:55:40','2023-10-29 18:55:40'),(97,68,1,0,169075.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:55:00',3,0,NULL,0,32,96,NULL,NULL,'PP2023/0038',NULL,'2023-10-29 18:55:40','2023-10-29 18:55:40'),(98,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:56:00',3,0,NULL,1,32,NULL,NULL,NULL,'PP2023/0039',NULL,'2023-10-29 18:56:17','2023-10-29 18:56:17'),(99,68,1,0,26745.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:56:00',3,0,NULL,0,32,98,NULL,NULL,'PP2023/0040',NULL,'2023-10-29 18:56:17','2023-10-29 18:56:17'),(100,99,1,0,73255.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:56:00',3,0,NULL,0,32,98,NULL,NULL,'PP2023/0041',NULL,'2023-10-29 18:56:17','2023-10-29 18:56:17'),(101,129,1,0,750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:56:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0059',NULL,'2023-10-29 18:57:28','2023-10-29 18:57:28'),(102,91,1,0,1290.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:57:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'2023/0002',NULL,'2023-10-29 18:57:59','2023-10-29 18:57:59'),(103,95,1,0,3500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:58:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'2023/0003',NULL,'2023-10-29 18:58:17','2023-10-29 18:58:17'),(104,94,1,0,300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:58:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'2023/0004',NULL,'2023-10-29 18:58:28','2023-10-29 18:58:28'),(105,93,1,0,1200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:58:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'2023/0005',NULL,'2023-10-29 18:58:39','2023-10-29 18:58:39'),(106,92,1,0,4000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 18:58:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'2023/0006',NULL,'2023-10-29 18:58:50','2023-10-29 18:58:50'),(107,130,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:07:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0060',NULL,'2023-10-29 19:07:43','2023-10-29 19:07:43'),(108,NULL,1,0,81210.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:19:00',3,0,NULL,1,39,NULL,NULL,NULL,'SE2023/0061',NULL,'2023-10-29 19:19:10','2023-10-29 19:19:10'),(110,NULL,1,0,484596.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:30:00',3,0,NULL,1,26,NULL,NULL,NULL,'PP2023/0043',NULL,'2023-10-29 19:30:27','2023-10-29 19:30:27'),(113,135,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 19:44:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0062',NULL,'2023-10-29 19:44:55','2023-10-29 19:44:55'),(114,136,1,0,1280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 20:07:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0063',NULL,'2023-10-29 20:07:08','2023-10-29 20:07:08'),(115,137,1,0,3250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 20:52:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0064',NULL,'2023-10-29 20:52:09','2023-10-29 20:52:09'),(116,138,1,0,7830.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 20:59:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0065',NULL,'2023-10-29 20:59:34','2023-10-29 20:59:34'),(117,140,1,0,5000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:04:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0066',NULL,'2023-10-29 21:04:43','2023-10-29 21:04:43'),(118,141,1,0,5250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:18:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0067',NULL,'2023-10-29 21:18:53','2023-10-29 21:18:53'),(119,142,1,0,5950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:24:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0068',NULL,'2023-10-29 21:24:37','2023-10-29 21:24:37'),(120,147,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:33:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0069',NULL,'2023-10-29 21:33:35','2023-10-29 21:33:35'),(121,148,1,0,4950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:36:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0070',NULL,'2023-10-29 21:36:02','2023-10-29 21:36:02'),(122,150,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:39:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0071',NULL,'2023-10-29 21:39:08','2023-10-29 21:39:08'),(123,153,1,0,1350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:42:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0072',NULL,'2023-10-29 21:42:12','2023-10-29 21:42:12'),(124,156,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:45:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0073',NULL,'2023-10-29 21:45:11','2023-10-29 21:45:11'),(125,158,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-29 21:51:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0074',NULL,'2023-10-29 21:51:13','2023-10-29 21:51:13'),(126,NULL,1,0,200.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 13:33:00',3,0,NULL,1,43,NULL,NULL,NULL,'SE2023/0075',NULL,'2023-10-30 13:33:46','2023-10-30 13:33:46'),(127,124,1,0,200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 13:33:00',3,0,NULL,0,43,126,NULL,NULL,'SE2023/0076',NULL,'2023-10-30 13:33:46','2023-10-30 13:33:46'),(128,159,1,0,4900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 13:36:25',3,0,NULL,0,43,NULL,NULL,NULL,'SE2023/0077',NULL,'2023-10-30 13:36:25','2023-10-30 13:36:25'),(129,161,1,0,2880.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 13:55:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0078',NULL,'2023-10-30 13:55:18','2023-10-30 13:55:18'),(130,162,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 13:56:22',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0079',NULL,'2023-10-30 13:56:22','2023-10-30 13:56:22'),(131,163,1,0,3200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 13:58:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0080',NULL,'2023-10-30 13:58:18','2023-10-30 13:58:18'),(132,165,1,0,1580.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:08:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0081',NULL,'2023-10-30 14:08:57','2023-10-30 14:08:57'),(133,166,1,0,7400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:12:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0082',NULL,'2023-10-30 14:12:02','2023-10-30 14:12:02'),(134,167,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:13:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0083',NULL,'2023-10-30 14:13:21','2023-10-30 14:13:21'),(135,169,1,0,11900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:29:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0084',NULL,'2023-10-30 14:29:12','2023-10-30 14:29:12'),(136,170,1,0,33000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:34:24',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0085',NULL,'2023-10-30 14:34:24','2023-10-30 14:34:24'),(137,171,1,0,3130.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:37:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0086',NULL,'2023-10-30 14:37:51','2023-10-30 14:37:51'),(138,173,1,0,5200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:42:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0087',NULL,'2023-10-30 14:42:47','2023-10-30 14:42:47'),(139,174,1,0,5380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:44:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0088',NULL,'2023-10-30 14:44:07','2023-10-30 14:44:07'),(140,175,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:44:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0089',NULL,'2023-10-30 14:44:49','2023-10-30 14:44:49'),(141,176,1,0,15169.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 14:59:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0090',NULL,'2023-10-30 14:59:23','2023-10-30 14:59:23'),(142,177,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 15:02:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0091',NULL,'2023-10-30 15:02:42','2023-10-30 15:02:42'),(143,178,1,0,11434.6000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 15:11:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0092',NULL,'2023-10-30 15:11:34','2023-10-30 15:11:34'),(144,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 17:22:00',3,0,NULL,1,48,NULL,NULL,NULL,'PP2023/0046',NULL,'2023-10-30 17:22:21','2023-10-30 17:22:21'),(145,160,1,0,50000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 17:22:00',3,0,NULL,0,48,144,NULL,NULL,'PP2023/0047',NULL,'2023-10-30 17:22:21','2023-10-30 17:22:21'),(146,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 17:44:00',3,0,NULL,1,49,NULL,NULL,NULL,'SE2023/0093',NULL,'2023-10-30 17:44:45','2023-10-30 17:44:45'),(147,164,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 17:44:00',3,0,NULL,0,49,146,NULL,NULL,'SE2023/0094',NULL,'2023-10-30 17:44:45','2023-10-30 17:44:45'),(148,181,1,0,3450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 17:59:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0095',NULL,'2023-10-30 17:59:21','2023-10-30 17:59:21'),(149,182,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:01:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0096',NULL,'2023-10-30 18:01:05','2023-10-30 18:01:05'),(150,183,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:02:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0097',NULL,'2023-10-30 18:02:34','2023-10-30 18:02:34'),(151,184,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:04:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0098',NULL,'2023-10-30 18:04:51','2023-10-30 18:04:51'),(152,186,1,0,25280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:13:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0099',NULL,'2023-10-30 18:13:50','2023-10-30 18:13:50'),(153,187,1,0,1750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:19:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0100',NULL,'2023-10-30 18:19:12','2023-10-30 18:19:12'),(154,188,1,0,16750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:23:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0101',NULL,'2023-10-30 18:23:58','2023-10-30 18:23:58'),(155,189,1,0,5550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:28:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0102',NULL,'2023-10-30 18:28:40','2023-10-30 18:28:40'),(156,190,1,0,2550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:32:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0103',NULL,'2023-10-30 18:32:16','2023-10-30 18:32:16'),(157,192,1,0,3600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:41:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0104',NULL,'2023-10-30 18:41:34','2023-10-30 18:41:34'),(158,193,1,0,3700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:43:03',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0105',NULL,'2023-10-30 18:43:03','2023-10-30 18:43:03'),(159,194,1,0,16459.2000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:45:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0106',NULL,'2023-10-30 18:45:15','2023-10-30 18:45:15'),(160,195,1,0,7700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:48:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0107',NULL,'2023-10-30 18:48:05','2023-10-30 18:48:05'),(161,196,1,0,5500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:51:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0108',NULL,'2023-10-30 18:51:20','2023-10-30 18:51:20'),(162,197,1,0,2650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:52:41',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0109',NULL,'2023-10-30 18:52:41','2023-10-30 18:52:41'),(163,198,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 18:57:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0110',NULL,'2023-10-30 18:57:12','2023-10-30 18:57:12'),(164,199,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:00:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0111',NULL,'2023-10-30 19:02:05','2023-10-30 19:02:05'),(165,200,1,0,9000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:23:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0112',NULL,'2023-10-30 19:23:47','2023-10-30 19:23:47'),(166,201,1,0,600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:24:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0113',NULL,'2023-10-30 19:24:35','2023-10-30 19:24:35'),(167,202,1,0,4550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:28:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0114',NULL,'2023-10-30 19:28:56','2023-10-30 19:28:56'),(168,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:31:00',3,0,NULL,1,52,NULL,NULL,NULL,'SE2023/0115',NULL,'2023-10-30 19:32:01','2023-10-30 19:32:01'),(169,203,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:31:00',3,0,NULL,0,52,168,NULL,NULL,'PP2023/0048',NULL,'2023-10-30 19:32:01','2023-10-30 19:32:01'),(170,204,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:33:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0116',NULL,'2023-10-30 19:33:50','2023-10-30 19:33:50'),(171,205,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:34:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0117',NULL,'2023-10-30 19:34:10','2023-10-30 19:34:10'),(172,206,1,0,1350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-30 19:37:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0118',NULL,'2023-10-30 19:37:30','2023-10-30 19:37:30'),(173,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:09:00',3,0,NULL,1,45,NULL,NULL,NULL,'SE2023/0119',NULL,'2023-10-31 11:10:14','2023-10-31 11:10:14'),(174,132,1,0,2000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:09:00',3,0,NULL,0,45,173,NULL,NULL,'PP2023/0049',NULL,'2023-10-31 11:10:14','2023-10-31 11:10:14'),(175,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:10:00',3,0,NULL,1,53,NULL,NULL,NULL,'SE2023/0120',NULL,'2023-10-31 11:10:46','2023-10-31 11:10:46'),(176,207,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:10:00',3,0,NULL,0,53,175,NULL,NULL,'PP2023/0050',NULL,'2023-10-31 11:10:46','2023-10-31 11:10:46'),(177,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:11:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0121',NULL,'2023-10-31 11:11:16','2023-10-31 11:11:16'),(178,97,1,0,3000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:11:00',3,0,NULL,0,36,177,NULL,NULL,'PP2023/0051',NULL,'2023-10-31 11:11:16','2023-10-31 11:11:16'),(179,208,1,0,29049.6000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:19:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0122',NULL,'2023-10-31 11:19:21','2023-10-31 11:19:21'),(180,209,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:24:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0123',NULL,'2023-10-31 11:24:33','2023-10-31 11:24:33'),(181,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:30:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0052',NULL,'2023-10-31 11:30:38','2023-10-31 11:30:38'),(182,76,1,0,150000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:30:00',3,0,NULL,0,33,181,NULL,NULL,'PP2023/0053',NULL,'2023-10-31 11:30:38','2023-10-31 11:30:38'),(183,210,1,0,25200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:44:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0124',NULL,'2023-10-31 11:44:45','2023-10-31 11:44:45'),(184,211,1,0,1850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:46:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0125',NULL,'2023-10-31 11:46:20','2023-10-31 11:46:20'),(185,212,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:52:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0126',NULL,'2023-10-31 11:52:27','2023-10-31 11:52:27'),(186,213,1,0,10000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 11:57:23',3,0,NULL,0,35,NULL,NULL,NULL,'SE2023/0127',NULL,'2023-10-31 11:57:23','2023-10-31 11:57:23'),(187,215,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:00:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0128',NULL,'2023-10-31 12:01:09','2023-10-31 12:01:09'),(188,216,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:01:00',3,0,NULL,0,NULL,NULL,'kajol babu + Arman',NULL,'SE2023/0129',NULL,'2023-10-31 12:01:58','2023-10-31 12:01:58'),(189,217,1,0,2000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:02:00',3,0,NULL,0,NULL,NULL,'biscuit +diper and others',NULL,'SE2023/0130',NULL,'2023-10-31 12:03:40','2023-10-31 12:03:40'),(190,NULL,1,0,2450.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:12:00',3,0,NULL,1,50,NULL,NULL,NULL,'SE2023/0131',NULL,'2023-10-31 12:12:59','2023-10-31 12:12:59'),(191,172,1,0,2450.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:12:00',3,0,NULL,0,50,190,NULL,NULL,'SE2023/0132',NULL,'2023-10-31 12:12:59','2023-10-31 12:12:59'),(192,NULL,1,0,900.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:13:00',3,0,NULL,1,54,NULL,NULL,NULL,'SE2023/0133',NULL,'2023-10-31 12:13:53','2023-10-31 12:13:53'),(193,218,1,0,900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:13:00',3,0,NULL,0,54,192,NULL,NULL,'PP2023/0054',NULL,'2023-10-31 12:13:53','2023-10-31 12:13:53'),(194,219,1,0,12090.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:18:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0134',NULL,'2023-10-31 12:18:16','2023-10-31 12:18:16'),(195,220,1,0,1900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:25:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0135',NULL,'2023-10-31 12:25:13','2023-10-31 12:25:13'),(196,222,1,0,6000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 12:58:52',3,0,NULL,0,55,NULL,NULL,NULL,'SE2023/0136',NULL,'2023-10-31 12:58:52','2023-10-31 12:58:52'),(197,223,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 13:45:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0137',NULL,'2023-10-31 13:45:39','2023-10-31 13:45:39'),(198,224,1,0,2800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 14:20:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0138',NULL,'2023-10-31 14:20:49','2023-10-31 14:20:49'),(199,225,1,0,12160.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 14:36:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0139',NULL,'2023-10-31 14:36:07','2023-10-31 14:36:07'),(200,226,1,0,3050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 14:39:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0140',NULL,'2023-10-31 14:39:53','2023-10-31 14:39:53'),(201,227,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 14:41:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0141',NULL,'2023-10-31 14:41:45','2023-10-31 14:41:45'),(202,228,1,0,1020.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 14:43:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0142',NULL,'2023-10-31 14:44:34','2023-10-31 14:44:34'),(203,NULL,1,0,1200.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 17:38:00',3,0,NULL,1,49,NULL,NULL,NULL,'SE2023/0143',NULL,'2023-10-31 17:41:55','2023-10-31 17:41:55'),(204,164,1,0,1200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 17:38:00',3,0,NULL,0,49,203,NULL,NULL,'SE2023/0144',NULL,'2023-10-31 17:41:55','2023-10-31 17:41:55'),(205,229,1,0,11500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 17:47:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0145',NULL,'2023-10-31 17:47:27','2023-10-31 17:47:27'),(206,NULL,1,0,2040.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 17:54:00',3,0,NULL,1,56,NULL,NULL,NULL,'SE2023/0146',NULL,'2023-10-31 17:55:07','2023-10-31 17:55:07'),(207,231,1,0,2040.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 17:54:00',3,0,NULL,0,56,206,NULL,NULL,'PP2023/0055',NULL,'2023-10-31 17:55:07','2023-10-31 17:55:07'),(208,232,1,0,1630.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 17:57:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0147',NULL,'2023-10-31 17:57:23','2023-10-31 17:57:23'),(209,234,1,0,1480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 18:52:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0148',NULL,'2023-10-31 18:52:01','2023-10-31 18:52:01'),(210,NULL,1,0,2500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 18:55:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0149',NULL,'2023-10-31 18:55:26','2023-10-31 18:55:26'),(211,193,1,0,2500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 18:55:00',3,0,NULL,0,51,210,NULL,NULL,'SE2023/0150',NULL,'2023-10-31 18:55:26','2023-10-31 18:55:26'),(212,235,1,0,2880.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 18:57:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0151',NULL,'2023-10-31 18:57:02','2023-10-31 18:57:02'),(213,236,1,0,2650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 18:58:30',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0152',NULL,'2023-10-31 18:58:30','2023-10-31 18:58:30'),(214,NULL,1,0,200000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:04:00',3,0,NULL,1,28,NULL,NULL,NULL,'PP2023/0056',NULL,'2023-10-31 20:04:33','2023-10-31 20:04:33'),(215,64,1,0,157662.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:04:00',3,0,NULL,0,28,214,NULL,NULL,'PP2023/0057',NULL,'2023-10-31 20:04:33','2023-10-31 20:04:33'),(216,180,1,0,42338.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:04:00',3,0,NULL,0,28,214,NULL,NULL,'PP2023/0058',NULL,'2023-10-31 20:04:33','2023-10-31 20:04:33'),(217,240,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:13:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0153',NULL,'2023-10-31 20:14:24','2023-10-31 20:14:24'),(218,241,1,0,600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:14:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0154',NULL,'2023-10-31 20:15:39','2023-10-31 20:15:39'),(219,242,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:15:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0155',NULL,'2023-10-31 20:16:02','2023-10-31 20:16:02'),(220,243,1,0,6270.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:18:04',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0156',NULL,'2023-10-31 20:18:04','2023-10-31 20:18:04'),(221,244,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:38:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0157',NULL,'2023-10-31 20:38:09','2023-10-31 20:38:09'),(222,245,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-10-31 20:40:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0158',NULL,'2023-10-31 20:40:47','2023-10-31 20:40:47'),(223,246,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:13:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0159',NULL,'2023-11-01 17:14:11','2023-11-01 17:14:11'),(224,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:15:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0160',NULL,'2023-11-01 17:16:08','2023-11-01 17:16:08'),(225,97,1,0,3000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:15:00',3,0,NULL,0,36,224,NULL,NULL,'PP2023/0059',NULL,'2023-11-01 17:16:08','2023-11-01 17:16:08'),(226,NULL,1,0,1500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:22:00',3,0,NULL,1,57,NULL,NULL,NULL,'SE2023/0161',NULL,'2023-11-01 17:23:14','2023-11-01 17:23:14'),(227,233,1,0,1500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:22:00',3,0,NULL,0,57,226,NULL,NULL,'SE2023/0162',NULL,'2023-11-01 17:23:14','2023-11-01 17:23:14'),(228,247,1,0,0.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:26:40',3,0,NULL,0,35,NULL,NULL,NULL,'SE2023/0163',NULL,'2023-11-01 17:26:40','2023-11-01 17:28:07'),(229,247,1,1,0.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:26:40',3,0,NULL,0,35,NULL,NULL,NULL,'SE2023/0164',NULL,'2023-11-01 17:26:40','2023-11-01 17:28:07'),(230,NULL,1,0,6000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:28:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0165',NULL,'2023-11-01 17:29:11','2023-11-01 17:29:11'),(231,105,1,0,6000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:28:00',3,0,NULL,0,35,230,NULL,NULL,'PP2023/0060',NULL,'2023-11-01 17:29:11','2023-11-01 17:29:11'),(232,248,1,0,29000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:44:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0166',NULL,'2023-11-01 17:44:15','2023-11-01 17:44:15'),(233,249,1,0,31730.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:51:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0167',NULL,'2023-11-01 17:51:23','2023-11-01 17:51:23'),(234,250,1,0,9080.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:53:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0168',NULL,'2023-11-01 17:53:29','2023-11-01 17:53:29'),(235,251,1,0,3500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 17:55:12',3,0,NULL,0,58,NULL,NULL,NULL,'SE2023/0169',NULL,'2023-11-01 17:55:12','2023-11-01 17:55:12'),(236,253,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:05:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0170',NULL,'2023-11-01 18:05:09','2023-11-01 18:05:09'),(237,256,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:33:40',3,0,NULL,0,53,NULL,NULL,NULL,'SE2023/0171',NULL,'2023-11-01 18:33:40','2023-11-01 18:33:40'),(238,NULL,1,0,10000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:35:00',3,0,NULL,1,44,NULL,NULL,NULL,'SE2023/0172',NULL,'2023-11-01 18:35:43','2023-11-01 18:35:43'),(239,131,1,0,10000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:35:00',3,0,NULL,0,44,238,NULL,NULL,'PP2023/0061',NULL,'2023-11-01 18:35:43','2023-11-01 18:35:43'),(240,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:45:00',3,0,NULL,1,32,NULL,'via jia',NULL,'PP2023/0062',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(241,99,1,0,95820.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:45:00',3,0,NULL,0,32,240,NULL,NULL,'PP2023/0063',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(242,239,1,0,46800.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:45:00',3,0,NULL,0,32,240,NULL,NULL,'PP2023/0064',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(243,257,1,0,7380.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:45:00',3,0,NULL,0,32,240,NULL,NULL,'PP2023/0065',NULL,'2023-11-01 18:45:31','2023-11-01 18:45:31'),(244,258,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 18:55:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0173',NULL,'2023-11-01 18:55:44','2023-11-01 18:55:44'),(245,260,1,0,1900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 19:23:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0174',NULL,'2023-11-01 19:23:25','2023-11-01 19:23:25'),(246,261,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 19:27:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0175',NULL,'2023-11-01 19:27:52','2023-11-01 19:27:52'),(247,262,1,0,1530.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 19:36:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0176',NULL,'2023-11-01 19:36:35','2023-11-01 19:36:35'),(248,263,1,0,2680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 19:48:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0177',NULL,'2023-11-01 19:48:27','2023-11-01 19:48:27'),(249,264,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 19:50:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0178',NULL,'2023-11-01 19:50:37','2023-11-01 19:50:37'),(250,265,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 19:55:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0179',NULL,'2023-11-01 19:55:44','2023-11-01 19:55:44'),(251,266,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 20:01:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0180',NULL,'2023-11-01 20:01:42','2023-11-01 20:01:42'),(252,267,1,0,2480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-01 20:07:04',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0181',NULL,'2023-11-01 20:07:04','2023-11-01 20:07:04'),(253,268,1,0,4900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:23:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0182',NULL,'2023-11-02 10:23:57','2023-11-02 10:23:57'),(254,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:25:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0183',NULL,'2023-11-02 10:25:57','2023-11-02 10:25:57'),(255,97,1,0,3000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:25:00',3,0,NULL,0,36,254,NULL,NULL,'PP2023/0066',NULL,'2023-11-02 10:25:57','2023-11-02 10:25:57'),(256,269,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:33:07',3,0,NULL,0,21,NULL,NULL,NULL,'SE2023/0184',NULL,'2023-11-02 10:33:07','2023-11-02 10:33:07'),(257,270,1,0,4480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:34:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0185',NULL,'2023-11-02 10:34:26','2023-11-02 10:34:26'),(258,NULL,1,0,1750.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:38:00',3,0,NULL,1,59,NULL,NULL,NULL,'SE2023/0186',NULL,'2023-11-02 10:39:07','2023-11-02 10:39:07'),(259,252,1,0,1750.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:38:00',3,0,NULL,0,59,258,NULL,NULL,'SE2023/0187',NULL,'2023-11-02 10:39:07','2023-11-02 10:39:07'),(260,NULL,1,0,7000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:40:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0188',NULL,'2023-11-02 10:41:14','2023-11-02 10:41:14'),(261,105,1,0,7000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:40:00',3,0,NULL,0,35,260,NULL,NULL,'PP2023/0067',NULL,'2023-11-02 10:41:14','2023-11-02 10:41:14'),(262,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:43:00',3,0,NULL,1,34,NULL,NULL,NULL,'PP2023/0068',NULL,'2023-11-02 10:43:54','2023-11-02 10:43:54'),(263,60,1,0,50000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:43:00',3,0,NULL,0,34,262,NULL,NULL,'PP2023/0069',NULL,'2023-11-02 10:43:54','2023-11-02 10:43:54'),(264,271,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:45:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0189',NULL,'2023-11-02 10:45:46','2023-11-02 10:45:46'),(265,272,1,0,50.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:46:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0190',NULL,'2023-11-02 10:46:16','2023-11-02 10:46:16'),(266,274,1,0,24350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:51:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0191',NULL,'2023-11-02 10:51:44','2023-11-02 10:51:44'),(267,275,1,0,8290.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:54:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0192',NULL,'2023-11-02 10:54:55','2023-11-02 10:54:55'),(268,276,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 10:55:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0193',NULL,'2023-11-02 10:55:16','2023-11-02 10:55:16'),(269,NULL,1,0,214920.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 11:19:00',3,0,NULL,1,19,NULL,NULL,NULL,'SE2023/0194',NULL,'2023-11-02 11:19:14','2023-11-02 11:19:14'),(270,56,1,0,214920.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 11:19:00',3,0,NULL,0,19,269,NULL,NULL,'PP2023/0070',NULL,'2023-11-02 11:19:14','2023-11-02 11:19:14'),(271,279,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 11:32:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0195',NULL,'2023-11-02 11:32:35','2023-11-02 11:32:35'),(272,280,1,0,2950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 11:37:22',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0196',NULL,'2023-11-02 11:37:22','2023-11-02 11:37:22'),(273,281,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 11:48:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0197',NULL,'2023-11-02 11:48:53','2023-11-02 11:48:53'),(274,282,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 11:55:41',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0198',NULL,'2023-11-02 11:55:41','2023-11-02 11:55:41'),(275,283,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 12:02:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0199',NULL,'2023-11-02 12:02:20','2023-11-02 12:02:20'),(276,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 12:19:00',3,0,NULL,1,26,NULL,NULL,NULL,'PP2023/0071',NULL,'2023-11-02 12:20:01','2023-11-02 12:20:01'),(278,284,1,0,3650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 12:25:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0200',NULL,'2023-11-02 12:25:11','2023-11-02 12:25:11'),(279,285,1,0,400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 12:26:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0201',NULL,'2023-11-02 12:26:51','2023-11-02 12:26:51'),(280,286,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 12:33:44',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0202',NULL,'2023-11-02 12:33:44','2023-11-02 12:33:44'),(281,287,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 12:41:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0203',NULL,'2023-11-02 12:41:50','2023-11-02 12:41:50'),(282,288,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 12:50:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0204',NULL,'2023-11-02 12:50:29','2023-11-02 12:50:29'),(283,290,1,0,4900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 13:21:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0205',NULL,'2023-11-02 13:21:43','2023-11-02 13:21:43'),(284,291,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 13:32:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0206',NULL,'2023-11-02 13:32:44','2023-11-02 13:32:44'),(285,292,1,0,7500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 14:02:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0207',NULL,'2023-11-02 14:02:13','2023-11-02 14:02:13'),(286,293,1,0,3700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 14:03:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0208',NULL,'2023-11-02 14:03:55','2023-11-02 14:03:55'),(287,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 14:14:00',3,0,NULL,1,48,NULL,NULL,NULL,'PP2023/0073',NULL,'2023-11-02 14:15:11','2023-11-02 14:15:11'),(288,160,1,0,50000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 14:14:00',3,0,NULL,0,48,287,NULL,NULL,'PP2023/0074',NULL,'2023-11-02 14:15:11','2023-11-02 14:15:11'),(289,294,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 14:17:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0209',NULL,'2023-11-02 14:17:52','2023-11-02 14:17:52'),(290,298,1,0,2650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:34:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0210',NULL,'2023-11-02 17:34:07','2023-11-02 17:34:07'),(291,299,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:36:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0211',NULL,'2023-11-02 17:36:44','2023-11-02 17:36:44'),(292,300,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:38:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0212',NULL,'2023-11-02 17:38:07','2023-11-02 17:38:07'),(293,301,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:38:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0213',NULL,'2023-11-02 17:38:46','2023-11-02 17:38:46'),(294,304,1,0,29380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:48:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0214',NULL,'2023-11-02 17:48:49','2023-11-02 17:48:49'),(295,305,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:49:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0215',NULL,'2023-11-02 17:49:47','2023-11-02 17:49:47'),(296,NULL,1,0,2600.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:51:00',3,0,NULL,1,9,NULL,NULL,NULL,'SE2023/0216',NULL,'2023-11-02 17:51:32','2023-11-02 17:51:32'),(297,43,1,0,2600.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:51:00',3,0,NULL,0,9,296,NULL,NULL,'PP2023/0075',NULL,'2023-11-02 17:51:32','2023-11-02 17:51:32'),(298,307,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:55:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0217',NULL,'2023-11-02 17:55:53','2023-11-02 17:55:53'),(299,NULL,1,0,43140.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:56:00',3,0,NULL,1,41,NULL,NULL,NULL,'PP2023/0076',NULL,'2023-11-02 17:56:42','2023-11-02 17:56:42'),(300,113,1,0,43140.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:56:00',3,0,NULL,0,41,299,NULL,NULL,'PP2023/0077',NULL,'2023-11-02 17:56:42','2023-11-02 17:56:42'),(301,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:56:00',3,0,NULL,1,29,NULL,NULL,NULL,'PP2023/0078',NULL,'2023-11-02 17:57:03','2023-11-02 17:57:03'),(302,69,1,0,36802.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:56:00',3,0,NULL,0,29,301,NULL,NULL,'PP2023/0079',NULL,'2023-11-02 17:57:03','2023-11-02 17:57:03'),(303,191,1,0,13198.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 17:56:00',3,0,NULL,0,29,301,NULL,NULL,'PP2023/0080',NULL,'2023-11-02 17:57:03','2023-11-02 17:57:03'),(304,308,1,0,5630.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 18:21:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0218',NULL,'2023-11-02 18:21:08','2023-11-02 18:21:08'),(305,309,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 18:30:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0219',NULL,'2023-11-02 18:30:10','2023-11-02 18:30:10'),(306,310,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 18:41:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0220',NULL,'2023-11-02 18:42:04','2023-11-02 18:42:04'),(307,311,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 18:42:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0221',NULL,'2023-11-02 18:42:37','2023-11-02 18:42:37'),(308,312,1,0,2650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 18:44:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0222',NULL,'2023-11-02 18:44:07','2023-11-02 18:44:07'),(309,313,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 18:48:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0223',NULL,'2023-11-02 18:48:25','2023-11-02 18:48:25'),(310,314,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 18:48:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0224',NULL,'2023-11-02 18:48:39','2023-11-02 18:48:39'),(311,315,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 19:01:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0225',NULL,'2023-11-02 19:01:05','2023-11-02 19:01:05'),(312,316,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 19:46:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0226',NULL,'2023-11-02 19:46:51','2023-11-02 19:46:51'),(313,317,1,0,5030.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 19:59:08',3,0,NULL,0,64,NULL,NULL,NULL,'SE2023/0227',NULL,'2023-11-02 19:59:08','2023-11-02 19:59:08'),(314,318,1,0,7900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:11:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0228',NULL,'2023-11-02 20:11:26','2023-11-02 20:11:26'),(315,319,1,0,1600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:16:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0229',NULL,'2023-11-02 20:16:55','2023-11-02 20:16:55'),(316,320,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:18:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0230',NULL,'2023-11-02 20:18:48','2023-11-02 20:18:48'),(317,321,1,0,23367.7000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:21:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0231',NULL,'2023-11-02 20:21:47','2023-11-02 20:21:47'),(318,323,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:45:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0232',NULL,'2023-11-02 20:45:11','2023-11-02 20:45:11'),(319,324,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:48:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0233',NULL,'2023-11-02 20:48:35','2023-11-02 20:48:35'),(320,325,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 20:56:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0234',NULL,'2023-11-02 20:56:54','2023-11-02 20:56:54'),(321,326,1,0,32250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 21:18:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0235',NULL,'2023-11-02 21:18:10','2023-11-02 21:18:10'),(322,327,1,0,1550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 21:18:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0236',NULL,'2023-11-02 21:18:50','2023-11-02 21:18:50'),(323,328,1,0,9350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 21:22:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0237',NULL,'2023-11-02 21:22:27','2023-11-02 21:22:27'),(324,329,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 21:26:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0238',NULL,'2023-11-02 21:26:11','2023-11-02 21:26:11'),(325,330,1,0,3030.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-02 21:27:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0239',NULL,'2023-11-02 21:27:11','2023-11-02 21:27:11'),(326,331,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:15:17',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0240',NULL,'2023-11-04 10:15:17','2023-11-04 10:15:17'),(327,NULL,1,0,900.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:21:00',3,0,NULL,1,58,NULL,NULL,NULL,'SE2023/0241',NULL,'2023-11-04 10:21:45','2023-11-04 10:21:45'),(328,251,1,0,900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:21:00',3,0,NULL,0,58,327,NULL,NULL,'SE2023/0242',NULL,'2023-11-04 10:21:45','2023-11-04 10:21:45'),(329,NULL,1,0,11900.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:22:00',3,0,NULL,1,59,NULL,NULL,NULL,'SE2023/0243',NULL,'2023-11-04 10:22:26','2023-11-04 10:22:26'),(330,295,1,0,11900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:22:00',3,0,NULL,0,59,329,NULL,NULL,'SE2023/0244',NULL,'2023-11-04 10:22:26','2023-11-04 10:22:26'),(331,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:29:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0245',NULL,'2023-11-04 10:29:53','2023-11-04 10:29:53'),(332,97,1,0,2000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:29:00',3,0,NULL,0,36,331,NULL,NULL,'PP2023/0081',NULL,'2023-11-04 10:29:53','2023-11-04 10:29:53'),(333,NULL,1,0,10000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:33:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0246',NULL,'2023-11-04 10:36:28','2023-11-04 10:36:28'),(334,105,1,0,10000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:33:00',3,0,NULL,0,35,333,NULL,NULL,'PP2023/0082',NULL,'2023-11-04 10:36:28','2023-11-04 10:36:28'),(335,332,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:38:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0247',NULL,'2023-11-04 10:38:49','2023-11-04 10:38:49'),(336,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:43:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0083',NULL,'2023-11-04 10:43:51','2023-11-04 10:43:51'),(337,76,1,0,150000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:43:00',3,0,NULL,0,33,336,NULL,NULL,'PP2023/0084',NULL,'2023-11-04 10:43:51','2023-11-04 10:43:51'),(338,333,1,0,1750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:49:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0248',NULL,'2023-11-04 10:49:19','2023-11-04 10:49:19'),(339,334,1,0,8950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:56:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0249',NULL,'2023-11-04 10:56:46','2023-11-04 10:56:46'),(340,335,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 10:59:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0250',NULL,'2023-11-04 10:59:25','2023-11-04 10:59:25'),(341,NULL,1,0,115200.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:02:00',3,0,NULL,1,37,NULL,NULL,NULL,'2023/0002',NULL,'2023-11-04 11:02:49','2023-11-04 11:02:49'),(342,336,1,0,1490.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:23:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0251',NULL,'2023-11-04 11:23:57','2023-11-04 11:23:57'),(343,337,1,0,9650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:25:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0252',NULL,'2023-11-04 11:25:55','2023-11-04 11:25:55'),(344,338,1,0,3600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:28:17',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0253',NULL,'2023-11-04 11:28:17','2023-11-04 11:28:17'),(345,339,1,0,2180.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:43:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0254',NULL,'2023-11-04 11:43:16','2023-11-04 11:43:16'),(346,340,1,0,3780.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:47:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0255',NULL,'2023-11-04 11:47:05','2023-11-04 11:47:05'),(347,341,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:48:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0256',NULL,'2023-11-04 11:48:48','2023-11-04 11:48:48'),(348,342,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 11:51:04',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0257',NULL,'2023-11-04 11:51:04','2023-11-04 11:51:04'),(349,343,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:01:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0258',NULL,'2023-11-04 12:01:02','2023-11-04 12:01:02'),(350,344,1,0,3900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:01:59',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0259',NULL,'2023-11-04 12:01:59','2023-11-04 12:01:59'),(351,345,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:04:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0260',NULL,'2023-11-04 12:04:53','2023-11-04 12:04:53'),(352,346,1,0,2880.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:14:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0261',NULL,'2023-11-04 12:14:33','2023-11-04 12:14:33'),(353,347,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:18:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0262',NULL,'2023-11-04 12:18:05','2023-11-04 12:18:05'),(354,348,1,0,5130.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:29:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0263',NULL,'2023-11-04 12:29:45','2023-11-04 12:29:45'),(355,349,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:32:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0264',NULL,'2023-11-04 12:32:13','2023-11-04 12:32:13'),(356,350,1,0,1600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:36:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0265',NULL,'2023-11-04 12:36:02','2023-11-04 12:36:02'),(357,351,1,0,3100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:41:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0266',NULL,'2023-11-04 12:41:53','2023-11-04 12:41:53'),(358,352,1,0,3030.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:43:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0267',NULL,'2023-11-04 12:43:51','2023-11-04 12:43:51'),(359,353,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:44:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0268',NULL,'2023-11-04 12:44:33','2023-11-04 12:44:33'),(360,354,1,0,450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 12:46:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0269',NULL,'2023-11-04 12:46:11','2023-11-04 12:46:11'),(361,355,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:21:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0270',NULL,'2023-11-04 13:21:02','2023-11-04 13:21:02'),(362,356,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:23:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0271',NULL,'2023-11-04 13:23:37','2023-11-04 13:23:37'),(363,357,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:24:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0272',NULL,'2023-11-04 13:24:01','2023-11-04 13:24:01'),(364,358,1,0,4000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:26:00',3,0,NULL,0,NULL,NULL,'thursdays exp',NULL,'SE2023/0273',NULL,'2023-11-04 13:26:55','2023-11-04 13:26:55'),(365,359,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:27:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0274',NULL,'2023-11-04 13:27:37','2023-11-04 13:27:37'),(366,361,1,0,8590.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:32:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0275',NULL,'2023-11-04 13:32:12','2023-11-04 13:32:12'),(367,362,1,0,4930.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:35:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0276',NULL,'2023-11-04 13:35:06','2023-11-04 13:35:06'),(368,363,1,0,6050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:37:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0277',NULL,'2023-11-04 13:37:38','2023-11-04 13:37:38'),(369,365,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:45:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0278',NULL,'2023-11-04 13:45:44','2023-11-04 13:45:44'),(370,366,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:48:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0279',NULL,'2023-11-04 13:48:16','2023-11-04 13:48:16'),(371,367,1,0,3500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 13:52:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0280',NULL,'2023-11-04 13:52:38','2023-11-04 13:52:38'),(372,368,1,0,6700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 14:00:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0281',NULL,'2023-11-04 14:00:18','2023-11-04 14:00:18'),(373,369,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 14:04:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0282',NULL,'2023-11-04 14:04:06','2023-11-04 14:04:06'),(374,370,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 14:09:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0283',NULL,'2023-11-04 14:09:00','2023-11-04 14:09:00'),(375,372,1,0,12950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 14:15:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0284',NULL,'2023-11-04 14:15:26','2023-11-04 14:15:26'),(376,373,1,0,2440.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 14:24:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0285',NULL,'2023-11-04 14:24:30','2023-11-04 14:24:30'),(377,374,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 14:31:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0286',NULL,'2023-11-04 14:31:30','2023-11-04 14:31:30'),(378,376,1,0,1640.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:04:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0287',NULL,'2023-11-04 17:04:49','2023-11-04 17:04:49'),(379,377,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:05:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0288',NULL,'2023-11-04 17:06:16','2023-11-04 17:06:16'),(380,NULL,1,0,12170.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:14:00',3,0,NULL,1,55,NULL,NULL,NULL,'SE2023/0289',NULL,'2023-11-04 17:15:06','2023-11-04 17:15:06'),(381,221,1,0,3020.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:14:00',3,0,NULL,0,55,380,NULL,NULL,'PP2023/0085',NULL,'2023-11-04 17:15:06','2023-11-04 17:15:06'),(382,222,1,0,9150.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:14:00',3,0,NULL,0,55,380,NULL,NULL,'SE2023/0290',NULL,'2023-11-04 17:15:06','2023-11-04 17:15:06'),(383,NULL,1,0,2100.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:16:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0291',NULL,'2023-11-04 17:16:36','2023-11-04 17:16:36'),(384,236,1,0,2000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:16:00',3,0,NULL,0,51,383,NULL,NULL,'SE2023/0292',NULL,'2023-11-04 17:16:36','2023-11-04 17:16:36'),(385,286,1,0,100.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:16:00',3,0,NULL,0,51,383,NULL,NULL,'SE2023/0293',NULL,'2023-11-04 17:16:36','2023-11-04 17:16:36'),(386,NULL,1,0,65900.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:25:00',3,0,NULL,1,48,NULL,NULL,NULL,'PP2023/0086',NULL,'2023-11-04 17:25:05','2023-11-04 17:25:05'),(387,160,1,0,65900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:25:00',3,0,NULL,0,48,386,NULL,NULL,'PP2023/0087',NULL,'2023-11-04 17:25:05','2023-11-04 17:25:05'),(388,378,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:28:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0294',NULL,'2023-11-04 17:28:32','2023-11-04 17:28:32'),(389,379,1,0,42460.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:34:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0295',NULL,'2023-11-04 17:34:48','2023-11-04 17:34:48'),(390,380,1,0,23780.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:43:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0296',NULL,'2023-11-04 17:43:35','2023-11-04 17:43:35'),(391,381,1,0,8222.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:45:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0297',NULL,'2023-11-04 17:45:53','2023-11-04 17:45:53'),(392,NULL,1,0,4600.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:57:00',3,0,NULL,1,66,NULL,NULL,NULL,'SE2023/0298',NULL,'2023-11-04 17:57:06','2023-11-04 17:57:06'),(393,385,1,0,4600.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 17:57:00',3,0,NULL,0,66,392,NULL,NULL,'PP2023/0088',NULL,'2023-11-04 17:57:06','2023-11-04 17:57:06'),(394,387,1,0,1600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 18:01:37',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0299',NULL,'2023-11-04 18:01:37','2023-11-04 18:01:37'),(395,388,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 18:02:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0300',NULL,'2023-11-04 18:02:53','2023-11-04 18:02:53'),(396,389,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 18:13:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0301',NULL,'2023-11-04 18:13:34','2023-11-04 18:13:34'),(397,390,1,0,25040.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 19:56:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0302',NULL,'2023-11-04 19:56:25','2023-11-04 19:56:25'),(398,NULL,1,0,115200.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 19:56:00',3,0,NULL,1,67,NULL,NULL,NULL,'SE2023/0303',NULL,'2023-11-04 19:56:40','2023-11-04 19:56:40'),(399,391,1,0,115200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 19:56:00',3,0,NULL,0,67,398,NULL,NULL,'PP2023/0089',NULL,'2023-11-04 19:56:40','2023-11-04 19:56:40'),(400,392,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:01:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0304',NULL,'2023-11-04 20:01:58','2023-11-04 20:01:58'),(401,393,1,0,2620.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:05:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0305',NULL,'2023-11-04 20:05:02','2023-11-04 20:05:02'),(402,394,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:07:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0306',NULL,'2023-11-04 20:07:09','2023-11-04 20:07:09'),(403,NULL,1,0,142335.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:19:00',3,0,NULL,1,26,NULL,NULL,NULL,'PP2023/0090',NULL,'2023-11-04 20:19:38','2023-11-04 20:19:38'),(406,395,1,0,22860.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:37:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0307',NULL,'2023-11-04 20:37:19','2023-11-04 20:37:19'),(407,396,1,0,6700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:39:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0308',NULL,'2023-11-04 20:39:47','2023-11-04 20:39:47'),(408,397,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:40:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0309',NULL,'2023-11-04 20:40:09','2023-11-04 20:40:09'),(409,NULL,1,0,6150.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:45:00',3,0,NULL,1,62,NULL,NULL,NULL,'SE2023/0310',NULL,'2023-11-04 20:45:04','2023-11-04 20:45:04'),(410,277,1,0,3650.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:45:00',3,0,NULL,0,62,409,NULL,NULL,'PP2023/0093',NULL,'2023-11-04 20:45:04','2023-11-04 20:45:04'),(411,278,1,0,2500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:45:00',3,0,NULL,0,62,409,NULL,NULL,'SE2023/0311',NULL,'2023-11-04 20:45:04','2023-11-04 20:45:04'),(412,398,1,0,3500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:49:06',3,0,NULL,0,62,NULL,NULL,NULL,'SE2023/0312',NULL,'2023-11-04 20:49:06','2023-11-04 20:49:06'),(413,NULL,1,0,80000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:51:00',3,0,NULL,1,31,NULL,NULL,NULL,'PP2023/0094',NULL,'2023-11-04 20:51:41','2023-11-04 20:51:41'),(414,70,1,0,49520.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:51:00',3,0,NULL,0,31,413,NULL,NULL,'PP2023/0095',NULL,'2023-11-04 20:51:41','2023-11-04 20:51:41'),(415,114,1,0,30480.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 20:51:00',3,0,NULL,0,31,413,NULL,NULL,'PP2023/0096',NULL,'2023-11-04 20:51:41','2023-11-04 20:51:41'),(416,399,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 21:01:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0313',NULL,'2023-11-04 21:01:09','2023-11-04 21:01:09'),(417,400,1,0,16036.2000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 21:03:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0314',NULL,'2023-11-04 21:03:30','2023-11-04 21:03:30'),(418,401,1,0,5880.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 21:05:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0315',NULL,'2023-11-04 21:05:16','2023-11-04 21:05:16'),(419,403,1,0,750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 21:13:00',3,0,NULL,0,NULL,NULL,'60 piece Egg',NULL,'SE2023/0316',NULL,'2023-11-04 21:14:15','2023-11-04 21:14:15'),(420,404,1,0,2000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-04 21:14:00',3,0,NULL,0,NULL,NULL,'Self + Veg',NULL,'SE2023/0317',NULL,'2023-11-04 21:14:48','2023-11-04 21:14:48'),(421,405,1,0,1200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:28:31',3,0,NULL,0,49,NULL,NULL,NULL,'SE2023/0318',NULL,'2023-11-05 10:28:31','2023-11-05 10:28:31'),(422,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:29:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0319',NULL,'2023-11-05 10:29:39','2023-11-05 10:29:39'),(423,97,1,0,2000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:29:00',3,0,NULL,0,36,422,NULL,NULL,'PP2023/0097',NULL,'2023-11-05 10:29:39','2023-11-05 10:29:39'),(424,NULL,1,0,7000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:31:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0320',NULL,'2023-11-05 10:31:27','2023-11-05 10:31:27'),(425,105,1,0,7000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:31:00',3,0,NULL,0,35,424,NULL,NULL,'PP2023/0098',NULL,'2023-11-05 10:31:27','2023-11-05 10:31:27'),(426,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:32:00',3,0,NULL,1,53,NULL,NULL,NULL,'SE2023/0321',NULL,'2023-11-05 10:32:07','2023-11-05 10:32:07'),(427,207,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:32:00',3,0,NULL,0,53,426,NULL,NULL,'PP2023/0099',NULL,'2023-11-05 10:32:07','2023-11-05 10:32:07'),(428,406,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:32:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0322',NULL,'2023-11-05 10:32:33','2023-11-05 10:32:33'),(429,NULL,1,0,9000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:37:00',3,0,NULL,1,44,NULL,NULL,NULL,'SE2023/0323',NULL,'2023-11-05 10:37:40','2023-11-05 10:37:40'),(430,131,1,0,9000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:37:00',3,0,NULL,0,44,429,NULL,NULL,'PP2023/0100',NULL,'2023-11-05 10:37:40','2023-11-05 10:37:40'),(431,407,1,0,18480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:40:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0324',NULL,'2023-11-05 10:40:26','2023-11-05 10:40:26'),(432,409,1,0,3040.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:43:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0325',NULL,'2023-11-05 10:43:39','2023-11-05 10:43:39'),(433,410,1,0,11800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:46:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0326',NULL,'2023-11-05 10:46:29','2023-11-05 10:46:29'),(434,411,1,0,8150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:47:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0327',NULL,'2023-11-05 10:47:35','2023-11-05 10:47:35'),(435,412,1,0,4480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:48:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0328',NULL,'2023-11-05 10:48:43','2023-11-05 10:48:43'),(436,413,1,0,1900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:50:55',3,0,NULL,0,69,NULL,NULL,NULL,'SE2023/0329',NULL,'2023-11-05 10:50:55','2023-11-05 10:50:55'),(437,414,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:53:17',3,0,NULL,0,47,NULL,NULL,NULL,'SE2023/0330',NULL,'2023-11-05 10:53:17','2023-11-05 10:53:17'),(438,415,1,0,14840.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 10:56:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0331',NULL,'2023-11-05 10:56:51','2023-11-05 10:56:51'),(439,416,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:09:00',3,0,NULL,0,NULL,NULL,'Millat rickshow',NULL,'SE2023/0332',NULL,'2023-11-05 11:09:54','2023-11-05 11:09:54'),(440,417,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:14:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0333',NULL,'2023-11-05 11:14:43','2023-11-05 11:14:43'),(441,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:30:00',3,0,NULL,1,70,NULL,NULL,NULL,'SE2023/0334',NULL,'2023-11-05 11:30:22','2023-11-05 11:30:22'),(442,418,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:30:00',3,0,NULL,0,70,441,NULL,NULL,'PP2023/0101',NULL,'2023-11-05 11:30:22','2023-11-05 11:30:22'),(443,420,1,0,2680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:32:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0335',NULL,'2023-11-05 11:32:58','2023-11-05 11:32:58'),(444,421,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:48:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0336',NULL,'2023-11-05 11:48:06','2023-11-05 11:48:06'),(445,422,1,0,3950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 11:49:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0337',NULL,'2023-11-05 11:49:02','2023-11-05 11:49:02'),(446,424,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 14:35:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0338',NULL,'2023-11-05 14:35:25','2023-11-05 14:35:25'),(447,425,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 14:50:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0339',NULL,'2023-11-05 14:50:27','2023-11-05 14:50:27'),(448,426,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 14:51:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0340',NULL,'2023-11-05 14:51:07','2023-11-05 14:55:15'),(449,426,1,1,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 14:55:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0341',NULL,'2023-11-05 14:55:15','2023-11-05 14:55:15'),(450,428,1,0,1550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 16:46:56',3,0,NULL,0,71,NULL,NULL,NULL,'SE2023/0342',NULL,'2023-11-05 16:46:56','2023-11-05 16:46:56'),(451,NULL,1,0,5250.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:09:00',3,0,NULL,1,63,NULL,NULL,NULL,'SE2023/0343',NULL,'2023-11-05 17:10:34','2023-11-05 17:10:34'),(452,302,1,0,1700.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:09:00',3,0,NULL,0,63,451,NULL,NULL,'PP2023/0102',NULL,'2023-11-05 17:10:34','2023-11-05 17:10:34'),(453,303,1,0,3550.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:09:00',3,0,NULL,0,63,451,NULL,NULL,'SE2023/0344',NULL,'2023-11-05 17:10:34','2023-11-05 17:10:34'),(454,430,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:12:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0345',NULL,'2023-11-05 17:12:08','2023-11-05 17:12:08'),(455,NULL,1,0,1100.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:13:00',3,0,NULL,1,72,NULL,NULL,NULL,'SE2023/0346',NULL,'2023-11-05 17:13:44','2023-11-05 17:13:44'),(456,431,1,0,1100.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:13:00',3,0,NULL,0,72,455,NULL,NULL,'PP2023/0103',NULL,'2023-11-05 17:13:44','2023-11-05 17:13:44'),(457,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:14:00',3,0,NULL,1,49,NULL,NULL,NULL,'SE2023/0347',NULL,'2023-11-05 17:14:23','2023-11-05 17:14:23'),(458,405,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:14:00',3,0,NULL,0,49,457,NULL,NULL,'SE2023/0348',NULL,'2023-11-05 17:14:23','2023-11-05 17:14:23'),(459,433,1,0,24820.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:19:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0349',NULL,'2023-11-05 17:19:16','2023-11-05 17:19:16'),(460,434,1,0,21000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:21:22',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0350',NULL,'2023-11-05 17:21:22','2023-11-05 17:21:22'),(461,436,1,0,580.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:41:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0351',NULL,'2023-11-05 17:41:32','2023-11-05 17:41:32'),(467,443,1,0,36450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:53:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0352',NULL,'2023-11-05 17:53:28','2023-11-05 17:53:28'),(468,444,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:55:31',3,0,NULL,0,58,NULL,NULL,NULL,'SE2023/0353',NULL,'2023-11-05 17:55:31','2023-11-05 17:55:31'),(469,445,1,0,769.9500,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 17:56:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0354',NULL,'2023-11-05 17:56:43','2023-11-05 17:56:43'),(470,446,1,0,7200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:00:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0355',NULL,'2023-11-05 18:00:11','2023-11-05 18:00:11'),(471,447,1,0,4550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:21:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0356',NULL,'2023-11-05 18:21:30','2023-11-05 18:21:30'),(472,448,1,0,1302.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:29:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0357',NULL,'2023-11-05 18:29:28','2023-11-05 18:29:28'),(473,449,1,0,121.2000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:31:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0358',NULL,'2023-11-05 18:31:42','2023-11-05 18:31:42'),(474,450,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:32:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0359',NULL,'2023-11-05 18:32:31','2023-11-05 18:32:31'),(475,451,1,0,2880.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:34:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0360',NULL,'2023-11-05 18:34:07','2023-11-05 18:34:07'),(476,NULL,1,0,130000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:52:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0104',NULL,'2023-11-05 18:52:35','2023-11-05 18:52:35'),(477,76,1,0,130000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 18:52:00',3,0,NULL,0,33,476,NULL,NULL,'PP2023/0105',NULL,'2023-11-05 18:52:35','2023-11-05 18:52:35'),(478,NULL,1,0,200000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 19:20:00',3,0,NULL,1,28,NULL,NULL,NULL,'PP2023/0106',NULL,'2023-11-05 19:20:26','2023-11-05 19:20:26'),(479,180,1,0,149822.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 19:20:00',3,0,NULL,0,28,478,NULL,NULL,'PP2023/0107',NULL,'2023-11-05 19:20:26','2023-11-05 19:20:26'),(480,238,1,0,50178.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 19:20:00',3,0,NULL,0,28,478,NULL,NULL,'PP2023/0108',NULL,'2023-11-05 19:20:26','2023-11-05 19:20:26'),(481,452,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 19:28:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0361',NULL,'2023-11-05 19:28:36','2023-11-05 19:28:36'),(486,458,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 19:48:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0362',NULL,'2023-11-05 19:48:57','2023-11-05 19:48:57'),(487,459,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 19:53:41',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0363',NULL,'2023-11-05 19:53:41','2023-11-05 20:05:19'),(488,460,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 19:56:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0364',NULL,'2023-11-05 19:56:43','2023-11-05 19:56:43'),(489,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 20:02:00',3,0,NULL,1,32,NULL,NULL,NULL,'PP2023/0109',NULL,'2023-11-05 20:02:59','2023-11-05 20:02:59'),(490,257,1,0,46020.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 20:02:00',3,0,NULL,0,32,489,NULL,NULL,'PP2023/0110',NULL,'2023-11-05 20:02:59','2023-11-05 20:02:59'),(491,371,1,0,103980.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 20:02:00',3,0,NULL,0,32,489,NULL,NULL,'PP2023/0111',NULL,'2023-11-05 20:02:59','2023-11-05 20:02:59'),(492,461,1,0,352.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-05 20:14:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0365',NULL,'2023-11-05 20:14:47','2023-11-05 20:14:47'),(493,NULL,1,0,7000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:08:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0366',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(494,105,1,0,2150.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:08:00',3,0,NULL,0,35,493,NULL,NULL,'PP2023/0112',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(495,126,1,0,4770.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:08:00',3,0,NULL,0,35,493,NULL,NULL,'SE2023/0367',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(496,213,1,0,80.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:08:00',3,0,NULL,0,35,493,NULL,NULL,'SE2023/0368',NULL,'2023-11-06 10:09:06','2023-11-06 10:09:06'),(497,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:09:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0369',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(498,97,1,0,1150.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:09:00',3,0,NULL,0,36,497,NULL,NULL,'PP2023/0113',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(499,115,1,0,300.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:09:00',3,0,NULL,0,36,497,NULL,NULL,'SE2023/0370',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(500,168,1,0,550.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:09:00',3,0,NULL,0,36,497,NULL,NULL,'SE2023/0371',NULL,'2023-11-06 10:09:45','2023-11-06 10:09:45'),(501,462,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:10:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0372',NULL,'2023-11-06 10:10:48','2023-11-06 10:10:48'),(502,463,1,0,24250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:16:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0373',NULL,'2023-11-06 10:16:21','2023-11-06 10:16:21'),(503,464,1,0,12830.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:18:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0374',NULL,'2023-11-06 10:18:18','2023-11-06 10:18:18'),(504,465,1,0,1850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:23:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0375',NULL,'2023-11-06 10:23:33','2023-11-06 10:23:33'),(505,466,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 10:31:25',3,0,NULL,0,75,NULL,NULL,NULL,'SE2023/0376',NULL,'2023-11-06 10:31:25','2023-11-06 10:31:25'),(506,NULL,1,0,6800.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:12:00',3,0,NULL,1,46,NULL,NULL,NULL,'SE2023/0377',NULL,'2023-11-06 11:12:04','2023-11-06 11:12:04'),(507,133,1,0,6800.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:12:00',3,0,NULL,0,46,506,NULL,NULL,'PP2023/0114',NULL,'2023-11-06 11:12:04','2023-11-06 11:12:04'),(508,467,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:29:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0378',NULL,'2023-11-06 11:29:21','2023-11-06 11:29:21'),(509,468,1,0,1480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:30:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0379',NULL,'2023-11-06 11:30:45','2023-11-06 11:30:45'),(510,469,1,0,7520.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:32:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0380',NULL,'2023-11-06 11:32:56','2023-11-06 11:32:56'),(511,470,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:41:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0381',NULL,'2023-11-06 11:41:45','2023-11-06 11:41:45'),(512,471,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:42:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0382',NULL,'2023-11-06 11:42:39','2023-11-06 11:42:39'),(513,473,1,0,3040.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 11:49:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0383',NULL,'2023-11-06 11:49:13','2023-11-06 11:49:13'),(514,474,1,0,2300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 12:05:19',3,0,NULL,0,46,NULL,NULL,NULL,'SE2023/0384',NULL,'2023-11-06 12:05:19','2023-11-06 12:05:19'),(515,475,1,0,1550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 12:18:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0385',NULL,'2023-11-06 12:18:06','2023-11-06 12:18:06'),(516,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 12:20:00',3,0,NULL,1,38,NULL,NULL,NULL,'SE2023/0386',NULL,'2023-11-06 12:20:53','2023-11-06 12:20:53'),(517,102,1,0,3000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 12:20:00',3,0,NULL,0,38,516,NULL,NULL,'PP2023/0115',NULL,'2023-11-06 12:20:53','2023-11-06 12:20:53'),(518,476,1,0,1240.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 12:34:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0387',NULL,'2023-11-06 12:34:05','2023-11-06 12:34:05'),(519,NULL,1,0,8000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 13:46:00',3,0,NULL,1,40,NULL,'misti+raj ray',NULL,'SE2023/0388',NULL,'2023-11-06 13:46:57','2023-11-06 13:46:57'),(520,104,1,0,8000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 13:46:00',3,0,NULL,0,40,519,NULL,NULL,'PP2023/0116',NULL,'2023-11-06 13:46:57','2023-11-06 13:46:57'),(521,477,1,0,4150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 13:48:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0389',NULL,'2023-11-06 13:48:39','2023-11-06 13:48:39'),(525,481,1,0,8490.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 13:52:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0390',NULL,'2023-11-06 13:52:37','2023-11-06 13:52:37'),(526,482,1,0,3250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 13:56:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0391',NULL,'2023-11-06 13:56:49','2023-11-06 13:56:49'),(527,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:08:00',3,0,NULL,1,30,NULL,NULL,NULL,'PP2023/0117',NULL,'2023-11-06 14:08:38','2023-11-06 14:08:38'),(528,383,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:08:00',3,0,NULL,0,30,527,NULL,NULL,'PP2023/0118',NULL,'2023-11-06 14:08:38','2023-11-06 14:08:38'),(530,486,1,0,350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:15:00',3,0,NULL,0,NULL,NULL,'lubia uri lebu',NULL,'SE2023/0392',NULL,'2023-11-06 14:16:11','2023-11-06 14:16:11'),(531,489,1,0,4500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:18:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0393',NULL,'2023-11-06 14:18:07','2023-11-06 14:18:07'),(532,491,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:33:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0394',NULL,'2023-11-06 14:33:14','2023-11-06 14:33:14'),(533,492,1,0,4400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:44:00',3,0,NULL,0,NULL,NULL,'kalighat sheikghat maher',NULL,'SE2023/0395',NULL,'2023-11-06 14:45:30','2023-11-06 14:45:30'),(534,493,1,0,4560.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 14:50:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0396',NULL,'2023-11-06 14:50:50','2023-11-06 14:50:50'),(535,NULL,1,0,30000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:05:00',3,0,NULL,1,46,NULL,NULL,NULL,'SE2023/0397',NULL,'2023-11-06 17:05:47','2023-11-06 17:05:47'),(536,474,1,0,30000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:05:00',3,0,NULL,0,46,535,NULL,NULL,'SE2023/0398',NULL,'2023-11-06 17:05:47','2023-11-06 17:05:47'),(537,NULL,1,0,6100.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:06:00',3,0,NULL,1,66,NULL,NULL,NULL,'SE2023/0399',NULL,'2023-11-06 17:06:36','2023-11-06 17:06:36'),(538,386,1,0,6100.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:06:00',3,0,NULL,0,66,537,NULL,NULL,'SE2023/0400',NULL,'2023-11-06 17:06:36','2023-11-06 17:06:36'),(539,496,1,0,15850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:09:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0401',NULL,'2023-11-06 17:09:50','2023-11-06 17:09:50'),(540,498,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:29:00',3,0,NULL,0,NULL,NULL,'shebul incentive joblumamu',NULL,'SE2023/0402',NULL,'2023-11-06 17:32:57','2023-11-06 17:32:57'),(541,499,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:33:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0403',NULL,'2023-11-06 17:33:18','2023-11-06 17:33:18'),(542,500,1,0,2950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:36:59',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0404',NULL,'2023-11-06 17:36:59','2023-11-06 17:36:59'),(543,501,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:57:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0405',NULL,'2023-11-06 17:57:53','2023-11-06 17:57:53'),(544,NULL,1,0,400.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:58:00',3,0,NULL,1,64,NULL,NULL,NULL,'SE2023/0406',NULL,'2023-11-06 17:58:42','2023-11-06 17:58:42'),(545,317,1,0,400.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 17:58:00',3,0,NULL,0,64,544,NULL,NULL,'SE2023/0407',NULL,'2023-11-06 17:58:42','2023-11-06 17:58:42'),(546,502,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 18:03:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0408',NULL,'2023-11-06 18:03:19','2023-11-06 18:03:19'),(547,503,1,0,2480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 18:05:24',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0409',NULL,'2023-11-06 18:05:24','2023-11-06 18:05:24'),(548,504,1,0,1550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 18:31:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0410',NULL,'2023-11-06 18:31:44','2023-11-06 18:31:44'),(549,505,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 18:40:59',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0411',NULL,'2023-11-06 18:40:59','2023-11-06 18:40:59'),(550,506,1,0,1350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 18:41:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0412',NULL,'2023-11-06 18:41:42','2023-11-06 18:41:42'),(551,507,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 18:45:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0413',NULL,'2023-11-06 18:45:31','2023-11-06 18:45:31'),(552,508,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 18:47:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0414',NULL,'2023-11-06 18:47:18','2023-11-06 18:47:18'),(553,509,1,0,15538.8800,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:18:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0415',NULL,'2023-11-06 19:18:06','2023-11-06 19:18:06'),(554,510,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:26:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0416',NULL,'2023-11-06 19:26:52','2023-11-06 19:26:52'),(555,511,1,0,2000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:32:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0417',NULL,'2023-11-06 19:32:18','2023-11-06 19:32:18'),(556,512,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:36:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0418',NULL,'2023-11-06 19:36:43','2023-11-06 19:36:43'),(557,513,1,0,3250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:37:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0419',NULL,'2023-11-06 19:37:13','2023-11-06 19:37:13'),(558,514,1,0,3030.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:44:03',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0420',NULL,'2023-11-06 19:44:03','2023-11-06 19:44:03'),(559,515,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:46:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0421',NULL,'2023-11-06 19:46:03','2023-11-06 19:46:03'),(560,516,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:46:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0422',NULL,'2023-11-06 19:46:35','2023-11-06 19:46:35'),(561,517,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:50:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0423',NULL,'2023-11-06 19:50:36','2023-11-06 19:50:36'),(562,518,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:50:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0424',NULL,'2023-11-06 19:50:51','2023-11-06 19:50:51'),(563,519,1,0,3050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:52:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0425',NULL,'2023-11-06 19:52:26','2023-11-06 19:52:26'),(564,520,1,0,3100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:53:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0426',NULL,'2023-11-06 19:53:25','2023-11-06 19:53:25'),(565,521,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 19:54:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0427',NULL,'2023-11-06 19:54:56','2023-11-06 19:54:56'),(566,522,1,0,1350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 20:10:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0428',NULL,'2023-11-06 20:10:31','2023-11-06 20:10:31'),(567,523,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 20:10:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0429',NULL,'2023-11-06 20:10:57','2023-11-06 20:10:57'),(568,NULL,1,0,3050.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 20:13:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0430',NULL,'2023-11-06 20:13:51','2023-11-06 20:13:51'),(569,387,1,0,3050.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 20:13:00',3,0,NULL,0,51,568,NULL,NULL,'SE2023/0431',NULL,'2023-11-06 20:13:51','2023-11-06 20:13:51'),(570,524,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 20:17:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0432',NULL,'2023-11-06 20:17:05','2023-11-06 20:17:05'),(571,525,1,0,1150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-06 20:21:29',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0433',NULL,'2023-11-06 20:21:29','2023-11-06 20:21:29'),(572,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:11:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0434',NULL,'2023-11-07 10:12:20','2023-11-07 10:12:20'),(573,168,1,0,3000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:11:00',3,0,NULL,0,36,572,NULL,NULL,'SE2023/0435',NULL,'2023-11-07 10:12:20','2023-11-07 10:12:20'),(574,526,1,0,800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:16:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0436',NULL,'2023-11-07 10:16:34','2023-11-07 10:16:34'),(575,527,1,0,15000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:18:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0437',NULL,'2023-11-07 10:18:23','2023-11-07 10:18:23'),(576,529,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:20:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0438',NULL,'2023-11-07 10:20:10','2023-11-07 10:20:10'),(577,530,1,0,3040.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:20:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0439',NULL,'2023-11-07 10:20:37','2023-11-07 10:20:37'),(578,531,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:27:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0440',NULL,'2023-11-07 10:27:02','2023-11-07 10:27:02'),(579,532,1,0,5750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:28:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0441',NULL,'2023-11-07 10:28:45','2023-11-07 10:28:45'),(581,535,1,0,5970.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 10:44:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0442',NULL,'2023-11-07 10:44:26','2023-11-07 10:44:26'),(582,536,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 11:00:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0443',NULL,'2023-11-07 11:00:58','2023-11-07 11:00:58'),(583,539,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 11:18:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0444',NULL,'2023-11-07 11:18:27','2023-11-07 11:18:27'),(584,540,1,0,4400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 11:19:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0445',NULL,'2023-11-07 11:19:00','2023-11-07 11:19:00'),(585,541,1,0,3600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 11:45:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0446',NULL,'2023-11-07 11:45:26','2023-11-07 11:45:26'),(586,542,1,0,12250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 11:48:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0447',NULL,'2023-11-07 11:48:50','2023-11-07 11:48:50'),(587,543,1,0,5000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:18:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0448',NULL,'2023-11-07 14:18:53','2023-11-07 14:18:53'),(588,544,1,0,20030.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:25:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0449',NULL,'2023-11-07 14:25:51','2023-11-07 14:25:51'),(589,545,1,0,5150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:27:24',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0450',NULL,'2023-11-07 14:27:24','2023-11-07 14:27:24'),(590,547,1,0,6200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:30:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0451',NULL,'2023-11-07 14:30:45','2023-11-07 14:30:45'),(591,NULL,1,0,149760.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:32:00',3,0,NULL,1,76,NULL,NULL,NULL,'PP2023/0119',NULL,'2023-11-07 14:32:37','2023-11-07 14:32:37'),(592,494,1,0,149760.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:32:00',3,0,NULL,0,76,591,NULL,NULL,'PP2023/0120',NULL,'2023-11-07 14:32:37','2023-11-07 14:32:37'),(593,548,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:59:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0452',NULL,'2023-11-07 14:59:06','2023-11-07 14:59:06'),(594,549,1,0,33904.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 14:57:00',3,0,NULL,0,78,NULL,NULL,NULL,'PP2023/0121',NULL,'2023-11-07 15:05:43','2023-11-07 15:05:43'),(595,550,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 15:06:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0453',NULL,'2023-11-07 15:06:31','2023-11-07 15:06:31'),(596,551,1,0,3240.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 15:08:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0454',NULL,'2023-11-07 15:08:39','2023-11-07 15:08:39'),(597,552,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 15:15:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0455',NULL,'2023-11-07 15:15:32','2023-11-07 15:15:32'),(598,553,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 16:45:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0456',NULL,'2023-11-07 16:45:07','2023-11-07 16:45:07'),(599,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 16:46:00',3,0,NULL,1,52,NULL,NULL,NULL,'SE2023/0457',NULL,'2023-11-07 16:46:32','2023-11-07 16:46:32'),(600,203,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 16:46:00',3,0,NULL,0,52,599,NULL,NULL,'PP2023/0122',NULL,'2023-11-07 16:46:32','2023-11-07 16:46:32'),(601,554,1,0,10640.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:07:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0458',NULL,'2023-11-07 17:07:49','2023-11-07 17:07:49'),(602,556,1,0,16690.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:11:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0459',NULL,'2023-11-07 17:11:52','2023-11-07 17:11:52'),(603,557,1,0,3350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:12:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0460',NULL,'2023-11-07 17:12:53','2023-11-07 17:12:53'),(604,558,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:14:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0461',NULL,'2023-11-07 17:14:32','2023-11-07 17:14:32'),(605,559,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:21:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0462',NULL,'2023-11-07 17:21:46','2023-11-07 17:21:46'),(606,560,1,0,2125.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:22:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0463',NULL,'2023-11-07 17:22:23','2023-11-07 17:22:23'),(607,561,1,0,3850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:27:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0464',NULL,'2023-11-07 17:27:29','2023-11-07 17:27:29'),(608,562,1,0,3350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:34:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0465',NULL,'2023-11-07 17:34:48','2023-11-07 17:40:19'),(609,563,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:54:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0466',NULL,'2023-11-07 17:54:16','2023-11-07 17:54:16'),(610,564,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:56:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0467',NULL,'2023-11-07 17:56:06','2023-11-07 17:56:06'),(611,565,1,0,1250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 17:58:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0468',NULL,'2023-11-07 17:58:20','2023-11-07 17:58:20'),(612,NULL,1,0,2300.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 18:07:00',3,0,NULL,1,45,NULL,NULL,NULL,'SE2023/0469',NULL,'2023-11-07 18:07:27','2023-11-07 18:07:27'),(613,132,1,0,2300.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 18:07:00',3,0,NULL,0,45,612,NULL,NULL,'PP2023/0123',NULL,'2023-11-07 18:07:27','2023-11-07 18:07:27'),(614,566,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 18:07:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0470',NULL,'2023-11-07 18:08:06','2023-11-07 18:08:06'),(615,567,1,0,3040.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 18:11:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0471',NULL,'2023-11-07 18:11:09','2023-11-07 18:11:09'),(616,568,1,0,65000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-07 18:17:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0472',NULL,'2023-11-07 18:17:13','2023-11-07 18:17:13'),(617,569,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:08:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0473',NULL,'2023-11-08 10:08:06','2023-11-08 10:08:06'),(618,NULL,1,0,3600.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:11:00',3,0,NULL,1,77,NULL,NULL,NULL,'SE2023/0474',NULL,'2023-11-08 10:11:26','2023-11-08 10:11:26'),(619,537,1,0,3600.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:11:00',3,0,NULL,0,77,618,NULL,NULL,'SE2023/0475',NULL,'2023-11-08 10:11:26','2023-11-08 10:11:26'),(620,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:12:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0476',NULL,'2023-11-08 10:12:30','2023-11-08 10:12:30'),(621,168,1,0,1350.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:12:00',3,0,NULL,0,36,620,NULL,NULL,'SE2023/0477',NULL,'2023-11-08 10:12:30','2023-11-08 10:12:30'),(622,185,1,0,1650.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:12:00',3,0,NULL,0,36,620,NULL,NULL,'SE2023/0478',NULL,'2023-11-08 10:12:30','2023-11-08 10:12:30'),(623,NULL,1,0,1950.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:12:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0479',NULL,'2023-11-08 10:12:57','2023-11-08 10:12:57'),(624,525,1,0,1950.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:12:00',3,0,NULL,0,51,623,NULL,NULL,'SE2023/0480',NULL,'2023-11-08 10:12:57','2023-11-08 10:12:57'),(625,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:13:00',3,0,NULL,1,53,NULL,NULL,NULL,'SE2023/0481',NULL,'2023-11-08 10:13:28','2023-11-08 10:13:28'),(626,207,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:13:00',3,0,NULL,0,53,625,NULL,NULL,'PP2023/0124',NULL,'2023-11-08 10:13:28','2023-11-08 10:13:28'),(627,NULL,1,0,6000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:13:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0482',NULL,'2023-11-08 10:13:50','2023-11-08 10:13:50'),(628,213,1,0,4940.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:13:00',3,0,NULL,0,35,627,NULL,NULL,'SE2023/0483',NULL,'2023-11-08 10:13:50','2023-11-08 10:13:50'),(629,214,1,0,1060.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:13:00',3,0,NULL,0,35,627,NULL,NULL,'SE2023/0484',NULL,'2023-11-08 10:13:50','2023-11-08 10:13:50'),(630,NULL,1,0,2500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:14:00',3,0,NULL,1,71,NULL,'via bkash exp 38',NULL,'SE2023/0485',NULL,'2023-11-08 10:15:16','2023-11-08 10:15:16'),(631,427,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:14:00',3,0,NULL,0,71,630,NULL,NULL,'PP2023/0125',NULL,'2023-11-08 10:15:16','2023-11-08 10:15:16'),(632,428,1,0,1500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:14:00',3,0,NULL,0,71,630,NULL,NULL,'SE2023/0486',NULL,'2023-11-08 10:15:16','2023-11-08 10:15:16'),(633,570,1,0,20469.8000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:20:29',3,0,NULL,0,36,NULL,NULL,NULL,'SE2023/0487',NULL,'2023-11-08 10:20:29','2023-11-08 10:20:29'),(634,571,1,0,1230.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:21:32',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0488',NULL,'2023-11-08 10:21:32','2023-11-08 10:21:32'),(635,572,1,0,19120.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:23:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0489',NULL,'2023-11-08 10:23:29','2023-11-08 10:23:29'),(636,573,1,0,3250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:26:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0490',NULL,'2023-11-08 10:26:11','2023-11-08 10:26:11'),(637,574,1,0,12490.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:28:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0491',NULL,'2023-11-08 10:28:49','2023-11-08 10:28:49'),(638,575,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 10:35:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0492',NULL,'2023-11-08 10:35:02','2023-11-08 10:35:02'),(639,576,1,0,4630.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:03:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0493',NULL,'2023-11-08 11:03:14','2023-11-08 11:03:14'),(640,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:04:00',3,0,NULL,1,47,NULL,NULL,NULL,'SE2023/0494',NULL,'2023-11-08 11:05:08','2023-11-08 11:05:08'),(641,134,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:04:00',3,0,NULL,0,47,640,NULL,NULL,'PP2023/0126',NULL,'2023-11-08 11:05:08','2023-11-08 11:05:08'),(642,577,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:05:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0495',NULL,'2023-11-08 11:05:52','2023-11-08 11:05:52'),(643,578,1,0,1200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:11:27',3,0,NULL,0,49,NULL,NULL,NULL,'SE2023/0496',NULL,'2023-11-08 11:11:27','2023-11-08 11:11:27'),(644,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:37:00',3,0,NULL,1,58,NULL,NULL,NULL,'SE2023/0497',NULL,'2023-11-08 11:37:26','2023-11-08 11:37:26'),(645,444,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:37:00',3,0,NULL,0,58,644,NULL,NULL,'SE2023/0498',NULL,'2023-11-08 11:37:26','2023-11-08 11:37:26'),(646,580,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:41:44',3,0,NULL,0,58,NULL,NULL,NULL,'SE2023/0499',NULL,'2023-11-08 11:41:44','2023-11-08 11:41:44'),(647,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:45:00',3,0,NULL,1,30,NULL,NULL,NULL,'PP2023/0127',NULL,'2023-11-08 11:45:30','2023-11-08 11:45:30'),(648,383,1,0,51635.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:45:00',3,0,NULL,0,30,647,NULL,NULL,'PP2023/0128',NULL,'2023-11-08 11:45:30','2023-11-08 11:45:30'),(649,484,1,0,48365.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 11:45:00',3,0,NULL,0,30,647,NULL,NULL,'PP2023/0129',NULL,'2023-11-08 11:45:30','2023-11-08 11:45:30'),(650,581,1,0,3130.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 12:01:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0500',NULL,'2023-11-08 12:01:15','2023-11-08 12:01:15'),(651,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 13:32:00',3,0,NULL,1,73,NULL,NULL,NULL,'PP2023/0130',NULL,'2023-11-08 13:33:10','2023-11-08 13:33:10'),(652,435,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 13:32:00',3,0,NULL,0,73,651,NULL,NULL,'PP2023/0131',NULL,'2023-11-08 13:33:10','2023-11-08 13:33:10'),(653,582,1,0,10000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 13:35:14',3,0,NULL,0,55,NULL,NULL,NULL,'SE2023/0501',NULL,'2023-11-08 13:35:14','2023-11-08 13:35:14'),(655,584,1,0,9540.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 13:41:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0502',NULL,'2023-11-08 13:41:58','2023-11-08 13:41:58'),(656,586,1,0,3280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 13:50:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0503',NULL,'2023-11-08 13:50:07','2023-11-08 13:50:07'),(657,587,1,0,3900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 13:50:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0504',NULL,'2023-11-08 13:50:36','2023-11-08 13:50:36'),(658,588,1,0,1530.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 14:01:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0505',NULL,'2023-11-08 14:01:11','2023-11-08 14:01:11'),(659,589,1,0,4900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 14:18:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0506',NULL,'2023-11-08 14:18:19','2023-11-08 14:18:19'),(660,590,1,0,4520.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 14:21:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0507',NULL,'2023-11-08 14:21:30','2023-11-08 14:21:30'),(661,579,1,0,11000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 14:22:38',3,0,NULL,0,40,NULL,NULL,NULL,'SE2023/0508',NULL,'2023-11-08 14:22:38','2023-11-08 14:22:38'),(662,591,1,0,2980.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 14:38:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0509',NULL,'2023-11-08 14:38:37','2023-11-08 14:38:37'),(663,592,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 17:31:03',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0510',NULL,'2023-11-08 17:31:03','2023-11-08 17:31:03'),(664,593,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 17:38:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0511',NULL,'2023-11-08 17:38:23','2023-11-08 17:38:23'),(665,595,1,0,3350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 17:44:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0512',NULL,'2023-11-08 17:44:28','2023-11-08 17:44:28'),(666,596,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 17:45:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0513',NULL,'2023-11-08 17:45:08','2023-11-08 17:45:08'),(667,598,1,0,11700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 17:47:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0514',NULL,'2023-11-08 17:47:56','2023-11-08 17:47:56'),(668,599,1,0,2280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 17:50:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0515',NULL,'2023-11-08 17:50:52','2023-11-08 17:50:52'),(669,601,1,0,360.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:02:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0516',NULL,'2023-11-08 18:03:15','2023-11-08 18:03:15'),(670,602,1,0,7580.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:09:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0517',NULL,'2023-11-08 18:09:30','2023-11-08 18:09:30'),(671,604,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:16:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0518',NULL,'2023-11-08 18:16:40','2023-11-08 18:16:40'),(672,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:16:00',3,0,NULL,1,52,NULL,NULL,NULL,'SE2023/0519',NULL,'2023-11-08 18:17:00','2023-11-08 18:17:00'),(673,203,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:16:00',3,0,NULL,0,52,672,NULL,NULL,'PP2023/0132',NULL,'2023-11-08 18:17:00','2023-11-08 18:17:00'),(674,605,1,0,3600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:32:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0520',NULL,'2023-11-08 18:32:42','2023-11-08 18:32:42'),(675,NULL,1,0,16000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:45:00',3,0,NULL,1,44,NULL,NULL,NULL,'SE2023/0521',NULL,'2023-11-08 18:45:35','2023-11-08 18:45:35'),(676,131,1,0,16000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:45:00',3,0,NULL,0,44,675,NULL,NULL,'PP2023/0133',NULL,'2023-11-08 18:45:35','2023-11-08 18:45:35'),(677,608,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:47:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0522',NULL,'2023-11-08 18:47:44','2023-11-08 18:47:44'),(678,609,1,0,1520.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 18:54:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0523',NULL,'2023-11-08 18:54:48','2023-11-08 18:54:48'),(679,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 19:26:00',3,0,NULL,1,58,NULL,NULL,NULL,'SE2023/0524',NULL,'2023-11-08 19:26:15','2023-11-08 19:26:15'),(680,580,1,0,2000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 19:26:00',3,0,NULL,0,58,679,NULL,NULL,'SE2023/0525',NULL,'2023-11-08 19:26:15','2023-11-08 19:26:15'),(681,610,1,0,450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 19:26:00',3,0,NULL,0,NULL,NULL,'buscuit cake me nd babu',NULL,'SE2023/0526',NULL,'2023-11-08 19:27:09','2023-11-08 19:27:09'),(682,611,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 19:41:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0527',NULL,'2023-11-08 19:41:50','2023-11-08 19:41:50'),(683,612,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-08 19:50:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0528',NULL,'2023-11-08 19:50:37','2023-11-08 19:50:37'),(684,613,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:05:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0529',NULL,'2023-11-09 10:05:51','2023-11-09 10:05:51'),(685,NULL,1,0,900.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:06:00',3,0,NULL,1,58,NULL,NULL,NULL,'SE2023/0530',NULL,'2023-11-09 10:06:57','2023-11-09 10:06:57'),(686,580,1,0,900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:06:00',3,0,NULL,0,58,685,NULL,NULL,'SE2023/0531',NULL,'2023-11-09 10:06:57','2023-11-09 10:06:57'),(687,NULL,1,0,750.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:07:00',3,0,NULL,1,53,NULL,NULL,NULL,'SE2023/0532',NULL,'2023-11-09 10:07:37','2023-11-09 10:07:37'),(688,207,1,0,750.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:07:00',3,0,NULL,0,53,687,NULL,NULL,'PP2023/0134',NULL,'2023-11-09 10:07:37','2023-11-09 10:07:37'),(689,NULL,1,0,2500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:07:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0533',NULL,'2023-11-09 10:07:57','2023-11-09 10:07:57'),(690,230,1,0,1650.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:07:00',3,0,NULL,0,36,689,NULL,NULL,'SE2023/0534',NULL,'2023-11-09 10:07:57','2023-11-09 10:07:57'),(691,273,1,0,850.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:07:00',3,0,NULL,0,36,689,NULL,NULL,'SE2023/0535',NULL,'2023-11-09 10:07:57','2023-11-09 10:07:57'),(692,NULL,1,0,2830.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,1,59,NULL,NULL,NULL,'SE2023/0536',NULL,'2023-11-09 10:08:17','2023-11-09 10:08:17'),(693,597,1,0,2830.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,0,59,692,NULL,NULL,'SE2023/0537',NULL,'2023-11-09 10:08:17','2023-11-09 10:08:17'),(694,NULL,1,0,5000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0538',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(695,214,1,0,1740.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,0,35,694,NULL,NULL,'SE2023/0539',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(696,247,1,0,2450.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,0,35,694,NULL,NULL,'SE2023/0540',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(697,289,1,0,810.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,0,35,694,NULL,NULL,'SE2023/0541',NULL,'2023-11-09 10:08:37','2023-11-09 10:08:37'),(698,NULL,1,0,2650.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,1,63,NULL,NULL,NULL,'SE2023/0542',NULL,'2023-11-09 10:09:29','2023-11-09 10:09:29'),(699,303,1,0,1700.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,0,63,698,NULL,NULL,'SE2023/0543',NULL,'2023-11-09 10:09:29','2023-11-09 10:09:29'),(700,603,1,0,950.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:08:00',3,0,NULL,0,63,698,NULL,NULL,'SE2023/0544',NULL,'2023-11-09 10:09:29','2023-11-09 10:09:29'),(701,615,1,0,23090.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:20:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0545',NULL,'2023-11-09 10:20:40','2023-11-09 10:20:40'),(702,616,1,0,2800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:21:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0546',NULL,'2023-11-09 10:21:28','2023-11-09 10:21:28'),(703,NULL,1,0,4800.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:21:00',3,0,NULL,1,34,NULL,'cash2000+mejban2800=4800',NULL,'PP2023/0135',NULL,'2023-11-09 10:22:29','2023-11-09 10:22:29'),(704,60,1,0,4800.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:21:00',3,0,NULL,0,34,703,NULL,NULL,'PP2023/0136',NULL,'2023-11-09 10:22:29','2023-11-09 10:22:29'),(705,617,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:26:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0547',NULL,'2023-11-09 10:26:14','2023-11-09 10:26:14'),(706,618,1,0,800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:31:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'2023/0007',NULL,'2023-11-09 10:31:53','2023-11-09 10:31:53'),(707,619,1,0,7510.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:36:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0548',NULL,'2023-11-09 10:36:50','2023-11-09 10:36:50'),(708,620,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:41:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0549',NULL,'2023-11-09 10:41:40','2023-11-09 10:41:40'),(709,621,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:56:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0550',NULL,'2023-11-09 10:56:31','2023-11-09 10:56:31'),(710,622,1,0,1850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 10:57:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0551',NULL,'2023-11-09 10:57:47','2023-11-09 10:57:47'),(711,NULL,1,0,200.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 11:02:00',3,0,NULL,1,47,NULL,NULL,NULL,'SE2023/0552',NULL,'2023-11-09 11:02:24','2023-11-09 11:02:24'),(712,134,1,0,200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 11:02:00',3,0,NULL,0,47,711,NULL,NULL,'PP2023/0137',NULL,'2023-11-09 11:02:24','2023-11-09 11:02:24'),(713,623,1,0,8350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 11:03:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0553',NULL,'2023-11-09 11:03:39','2023-11-09 11:03:39'),(714,624,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:13:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0554',NULL,'2023-11-09 12:13:53','2023-11-09 12:13:53'),(715,625,1,0,11880.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:15:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0555',NULL,'2023-11-09 12:15:48','2023-11-09 12:15:48'),(716,626,1,0,3200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:21:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0556',NULL,'2023-11-09 12:21:19','2023-11-09 12:21:19'),(717,627,1,0,4000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:31:41',3,0,NULL,0,80,NULL,NULL,NULL,'SE2023/0557',NULL,'2023-11-09 12:31:41','2023-11-09 12:31:41'),(718,NULL,1,0,24300.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:41:00',3,0,NULL,1,33,NULL,'Gari bara from dinajpur',NULL,'PP2023/0138',NULL,'2023-11-09 12:42:01','2023-11-09 12:42:01'),(719,76,1,0,18390.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:41:00',3,0,NULL,0,33,718,NULL,NULL,'PP2023/0139',NULL,'2023-11-09 12:42:01','2023-11-09 12:42:01'),(720,628,1,0,5910.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:41:00',3,0,NULL,0,33,718,NULL,NULL,'PP2023/0140',NULL,'2023-11-09 12:42:01','2023-11-09 12:42:01'),(721,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:42:00',3,0,NULL,1,33,NULL,'cash prodip',NULL,'PP2023/0141',NULL,'2023-11-09 12:42:33','2023-11-09 12:42:33'),(722,628,1,0,150000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:42:00',3,0,NULL,0,33,721,NULL,NULL,'PP2023/0142',NULL,'2023-11-09 12:42:33','2023-11-09 12:42:33'),(723,NULL,1,0,600.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:44:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0558',NULL,'2023-11-09 12:44:40','2023-11-09 12:44:40'),(724,571,1,0,600.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:44:00',3,0,NULL,0,51,723,NULL,NULL,'SE2023/0559',NULL,'2023-11-09 12:44:40','2023-11-09 12:44:40'),(725,629,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:46:22',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0560',NULL,'2023-11-09 12:46:22','2023-11-09 12:46:22'),(726,630,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:47:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0561',NULL,'2023-11-09 12:47:02','2023-11-09 12:47:02'),(727,631,1,0,800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 12:52:43',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0562',NULL,'2023-11-09 12:52:43','2023-11-09 12:52:43'),(728,NULL,1,0,950.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:15:00',3,0,NULL,1,80,NULL,NULL,NULL,'SE2023/0563',NULL,'2023-11-09 13:15:48','2023-11-09 13:15:48'),(729,627,1,0,950.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:15:00',3,0,NULL,0,80,728,NULL,NULL,'SE2023/0564',NULL,'2023-11-09 13:15:48','2023-11-09 13:15:48'),(730,634,1,0,5900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:41:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0565',NULL,'2023-11-09 13:41:37','2023-11-09 13:41:37'),(731,635,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:42:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0566',NULL,'2023-11-09 13:42:15','2023-11-09 13:42:15'),(732,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:49:00',3,0,NULL,1,28,NULL,NULL,NULL,'PP2023/0143',NULL,'2023-11-09 13:50:28','2023-11-09 13:50:28'),(733,238,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:49:00',3,0,NULL,0,28,732,NULL,NULL,'PP2023/0144',NULL,'2023-11-09 13:50:28','2023-11-09 13:50:28'),(734,636,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:54:00',3,0,NULL,0,NULL,NULL,'liton 53 bosta',NULL,'SE2023/0567',NULL,'2023-11-09 13:55:21','2023-11-09 13:55:21'),(735,637,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 13:59:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0568',NULL,'2023-11-09 13:59:50','2023-11-09 13:59:50'),(736,638,1,0,7520.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 14:09:59',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0569',NULL,'2023-11-09 14:09:59','2023-11-09 14:09:59'),(737,639,1,0,450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 14:29:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0570',NULL,'2023-11-09 14:30:13','2023-11-09 14:30:13'),(738,640,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 14:36:42',3,0,NULL,0,43,NULL,NULL,NULL,'SE2023/0571',NULL,'2023-11-09 14:36:42','2023-11-09 14:36:42'),(739,NULL,1,0,3200.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:07:00',3,0,NULL,1,79,NULL,NULL,NULL,'SE2023/0572',NULL,'2023-11-09 17:07:59','2023-11-09 17:07:59'),(740,607,1,0,3200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:07:00',3,0,NULL,0,79,739,NULL,NULL,'SE2023/0573',NULL,'2023-11-09 17:07:59','2023-11-09 17:07:59'),(741,641,1,0,29170.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:11:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0574',NULL,'2023-11-09 17:11:52','2023-11-09 17:11:52'),(742,642,1,0,36120.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:14:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0575',NULL,'2023-11-09 17:14:12','2023-11-09 17:14:12'),(743,643,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:16:40',3,0,NULL,0,81,NULL,NULL,NULL,'SE2023/0576',NULL,'2023-11-09 17:16:40','2023-11-09 17:16:40'),(744,644,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:16:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0577',NULL,'2023-11-09 17:16:58','2023-11-09 17:16:58'),(745,645,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:40:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0578',NULL,'2023-11-09 17:40:51','2023-11-09 17:40:51'),(746,646,1,0,2800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:43:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0579',NULL,'2023-11-09 17:43:25','2023-11-09 17:43:25'),(747,647,1,0,3100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:48:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0580',NULL,'2023-11-09 17:48:46','2023-11-09 17:48:46'),(748,NULL,1,0,2900.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:55:00',3,0,NULL,1,74,NULL,NULL,NULL,'SE2023/0581',NULL,'2023-11-09 17:55:24','2023-11-09 17:55:24'),(749,437,1,0,2900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 17:55:00',3,0,NULL,0,74,748,NULL,NULL,'SE2023/0582',NULL,'2023-11-09 17:55:24','2023-11-09 17:55:24'),(750,648,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 18:01:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0583',NULL,'2023-11-09 18:01:23','2023-11-09 18:01:23'),(751,651,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 18:29:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0584',NULL,'2023-11-09 18:29:11','2023-11-09 18:29:11'),(752,652,1,0,6220.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 18:42:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0585',NULL,'2023-11-09 18:42:10','2023-11-09 18:42:10'),(753,653,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 18:44:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0586',NULL,'2023-11-09 18:44:18','2023-11-09 18:44:18'),(754,654,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 18:53:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0587',NULL,'2023-11-09 18:53:28','2023-11-09 18:53:28'),(755,655,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:05:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0588',NULL,'2023-11-09 19:05:01','2023-11-09 19:05:01'),(756,656,1,0,1550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:21:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0589',NULL,'2023-11-09 19:21:05','2023-11-09 19:21:05'),(757,657,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:26:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0590',NULL,'2023-11-09 19:26:34','2023-11-09 19:26:34'),(758,658,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:27:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0591',NULL,'2023-11-09 19:27:05','2023-11-09 19:27:05'),(759,660,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:31:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0592',NULL,'2023-11-09 19:31:45','2023-11-09 19:31:45'),(760,661,1,0,3280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:33:17',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0593',NULL,'2023-11-09 19:33:17','2023-11-09 19:33:17'),(761,662,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:36:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0594',NULL,'2023-11-09 19:36:58','2023-11-09 19:36:58'),(762,663,1,0,240.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:43:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0595',NULL,'2023-11-09 19:43:09','2023-11-09 19:43:09'),(763,664,1,0,300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:47:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0596',NULL,'2023-11-09 19:48:31','2023-11-09 19:48:31'),(764,665,1,0,60.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:51:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0597',NULL,'2023-11-09 19:51:27','2023-11-09 19:51:27'),(765,666,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:51:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0598',NULL,'2023-11-09 19:51:42','2023-11-09 19:51:42'),(766,667,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:52:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0599',NULL,'2023-11-09 19:52:16','2023-11-09 19:52:16'),(767,668,1,0,2530.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:52:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0600',NULL,'2023-11-09 19:52:55','2023-11-09 19:52:55'),(768,669,1,0,180.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:54:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0601',NULL,'2023-11-09 19:54:10','2023-11-09 19:54:10'),(769,670,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 19:57:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0602',NULL,'2023-11-09 19:57:16','2023-11-09 19:57:16'),(770,671,1,0,4000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 20:00:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0603',NULL,'2023-11-09 20:01:00','2023-11-09 20:01:00'),(771,672,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 20:01:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0604',NULL,'2023-11-09 20:01:49','2023-11-09 20:01:49'),(772,673,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-09 20:02:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0605',NULL,'2023-11-09 20:02:40','2023-11-09 20:02:40'),(773,674,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:17:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0606',NULL,'2023-11-11 10:17:30','2023-11-11 10:17:30'),(774,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:18:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0607',NULL,'2023-11-11 10:19:13','2023-11-11 10:19:13'),(775,273,1,0,800.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:18:00',3,0,NULL,0,36,774,NULL,NULL,'SE2023/0608',NULL,'2023-11-11 10:19:13','2023-11-11 10:19:13'),(776,360,1,0,1200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:18:00',3,0,NULL,0,36,774,NULL,NULL,'SE2023/0609',NULL,'2023-11-11 10:19:13','2023-11-11 10:19:13'),(777,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:19:00',3,0,NULL,1,81,NULL,NULL,NULL,'SE2023/0610',NULL,'2023-11-11 10:19:26','2023-11-11 10:19:26'),(778,643,1,0,2000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:19:00',3,0,NULL,0,81,777,NULL,NULL,'SE2023/0611',NULL,'2023-11-11 10:19:26','2023-11-11 10:19:26'),(779,NULL,1,0,3080.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:19:00',3,0,NULL,1,59,NULL,NULL,NULL,'SE2023/0612',NULL,'2023-11-11 10:19:41','2023-11-11 10:19:41'),(780,659,1,0,3080.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:19:00',3,0,NULL,0,59,779,NULL,NULL,'SE2023/0613',NULL,'2023-11-11 10:19:41','2023-11-11 10:19:41'),(781,675,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:20:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0614',NULL,'2023-11-11 10:20:45','2023-11-11 10:20:45'),(782,676,1,0,12020.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:23:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0615',NULL,'2023-11-11 10:23:18','2023-11-11 10:23:18'),(783,677,1,0,22310.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:27:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0616',NULL,'2023-11-11 10:27:25','2023-11-11 10:27:25'),(784,678,1,0,8500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:28:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0617',NULL,'2023-11-11 10:28:26','2023-11-11 10:28:26'),(785,NULL,1,0,6000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:29:00',3,0,NULL,1,20,NULL,NULL,NULL,'SE2023/0618',NULL,'2023-11-11 10:29:13','2023-11-11 10:29:13'),(786,51,1,0,6000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:29:00',3,0,NULL,0,20,785,NULL,NULL,'PP2023/0145',NULL,'2023-11-11 10:29:13','2023-11-11 10:29:13'),(787,680,1,0,3100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:32:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0619',NULL,'2023-11-11 10:32:39','2023-11-11 10:32:39'),(788,682,1,0,3570.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:35:22',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0620',NULL,'2023-11-11 10:35:22','2023-11-11 10:35:22'),(789,683,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:40:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0621',NULL,'2023-11-11 10:40:01','2023-11-11 10:40:01'),(790,684,1,0,2040.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:41:00',3,0,NULL,0,83,NULL,NULL,NULL,'PP2023/0146',NULL,'2023-11-11 10:43:01','2023-11-11 10:43:01'),(791,686,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 10:59:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0622',NULL,'2023-11-11 10:59:18','2023-11-11 10:59:18'),(792,687,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:12:04',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0623',NULL,'2023-11-11 11:12:04','2023-11-11 11:12:04'),(793,688,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:12:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0624',NULL,'2023-11-11 11:12:40','2023-11-11 11:12:40'),(794,689,1,0,240.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:16:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0625',NULL,'2023-11-11 11:16:58','2023-11-11 11:16:58'),(795,690,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:23:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0626',NULL,'2023-11-11 11:23:45','2023-11-11 11:23:45'),(796,691,1,0,5050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:30:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0627',NULL,'2023-11-11 11:30:56','2023-11-11 11:30:56'),(797,693,1,0,1900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:43:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0628',NULL,'2023-11-11 11:43:38','2023-11-11 11:43:38'),(798,NULL,1,0,3480.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:48:00',3,0,NULL,1,45,NULL,NULL,NULL,'SE2023/0629',NULL,'2023-11-11 11:48:24','2023-11-11 11:48:24'),(799,692,1,0,3480.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:48:00',3,0,NULL,0,45,798,NULL,NULL,'SE2023/0630',NULL,'2023-11-11 11:48:24','2023-11-11 11:48:24'),(800,694,1,0,2000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 11:53:37',3,0,NULL,0,84,NULL,NULL,NULL,'SE2023/0631',NULL,'2023-11-11 11:53:37','2023-11-11 11:53:37'),(801,696,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 12:06:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0632',NULL,'2023-11-11 12:06:54','2023-11-11 12:06:54'),(802,NULL,1,0,130380.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 12:17:00',3,0,NULL,1,67,NULL,NULL,NULL,'SE2023/0633',NULL,'2023-11-11 12:17:47','2023-11-11 12:17:47'),(803,402,1,0,130380.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 12:17:00',3,0,NULL,0,67,802,NULL,NULL,'SE2023/0634',NULL,'2023-11-11 12:17:47','2023-11-11 12:17:47'),(804,698,1,0,1630.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 12:33:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0635',NULL,'2023-11-11 12:33:50','2023-11-11 12:33:50'),(805,699,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 12:36:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0636',NULL,'2023-11-11 12:36:53','2023-11-11 12:36:53'),(806,NULL,1,0,5000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 13:24:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0637',NULL,'2023-11-11 13:24:13','2023-11-11 13:24:13'),(807,360,1,0,450.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 13:24:00',3,0,NULL,0,36,806,NULL,NULL,'SE2023/0638',NULL,'2023-11-11 13:24:13','2023-11-11 13:24:13'),(808,382,1,0,4550.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 13:24:00',3,0,NULL,0,36,806,NULL,NULL,'SE2023/0639',NULL,'2023-11-11 13:24:13','2023-11-11 13:24:13'),(809,700,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 13:24:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0640',NULL,'2023-11-11 13:25:13','2023-11-11 13:25:13'),(810,701,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 13:35:04',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0641',NULL,'2023-11-11 13:35:04','2023-11-11 13:35:04'),(811,702,1,0,3200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 13:52:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0642',NULL,'2023-11-11 13:52:26','2023-11-11 13:52:26'),(812,703,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 13:54:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0643',NULL,'2023-11-11 13:54:28','2023-11-11 13:54:28'),(813,704,1,0,1780.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:07:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0644',NULL,'2023-11-11 14:07:40','2023-11-11 14:07:40'),(814,NULL,1,0,1500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:08:00',3,0,NULL,1,43,NULL,NULL,NULL,'SE2023/0645',NULL,'2023-11-11 14:08:13','2023-11-11 14:08:13'),(815,640,1,0,1500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:08:00',3,0,NULL,0,43,814,NULL,NULL,'SE2023/0646',NULL,'2023-11-11 14:08:13','2023-11-11 14:08:13'),(816,705,1,0,5350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:09:38',3,0,NULL,0,43,NULL,NULL,NULL,'SE2023/0647',NULL,'2023-11-11 14:09:38','2023-11-11 14:09:38'),(817,706,1,0,1640.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:15:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0648',NULL,'2023-11-11 14:15:58','2023-11-11 14:15:58'),(818,707,1,0,1640.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:16:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0649',NULL,'2023-11-11 14:16:33','2023-11-11 14:16:33'),(819,708,1,0,14800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:22:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0650',NULL,'2023-11-11 14:22:21','2023-11-11 14:22:21'),(820,709,1,0,4350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:26:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0651',NULL,'2023-11-11 14:26:52','2023-11-11 14:26:52'),(821,710,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:27:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0652',NULL,'2023-11-11 14:27:06','2023-11-11 14:27:06'),(822,711,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:29:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0653',NULL,'2023-11-11 14:29:53','2023-11-11 14:29:53'),(823,712,1,0,5400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:36:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0654',NULL,'2023-11-11 14:36:14','2023-11-11 14:36:14'),(824,713,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 14:39:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0655',NULL,'2023-11-11 14:39:29','2023-11-11 14:39:29'),(825,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:36:00',3,0,NULL,1,29,NULL,NULL,NULL,'PP2023/0147',NULL,'2023-11-11 17:36:44','2023-11-11 17:36:44'),(826,191,1,0,36872.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:36:00',3,0,NULL,0,29,825,NULL,NULL,'PP2023/0148',NULL,'2023-11-11 17:36:44','2023-11-11 17:36:44'),(827,714,1,0,13128.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:36:00',3,0,NULL,0,29,825,NULL,NULL,'PP2023/0149',NULL,'2023-11-11 17:36:44','2023-11-11 17:36:44'),(828,NULL,1,0,10000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:42:00',3,0,NULL,1,29,NULL,NULL,NULL,'PP2023/0150',NULL,'2023-11-11 17:42:46','2023-11-11 17:42:46'),(829,714,1,0,10000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:42:00',3,0,NULL,0,29,828,NULL,NULL,'PP2023/0151',NULL,'2023-11-11 17:42:46','2023-11-11 17:42:46'),(830,717,1,0,1090.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:48:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0656',NULL,'2023-11-11 17:49:52','2023-11-11 17:49:52'),(831,718,1,0,5400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:51:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0657',NULL,'2023-11-11 17:51:34','2023-11-11 17:51:34'),(832,719,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:54:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0658',NULL,'2023-11-11 17:54:02','2023-11-11 17:54:02'),(833,NULL,1,0,5000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:55:00',3,0,NULL,1,55,NULL,NULL,NULL,'SE2023/0659',NULL,'2023-11-11 17:55:06','2023-11-11 17:55:06'),(834,582,1,0,5000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 17:55:00',3,0,NULL,0,55,833,NULL,NULL,'SE2023/0660',NULL,'2023-11-11 17:55:06','2023-11-11 17:55:06'),(835,721,1,0,91163.2500,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:02:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0661',NULL,'2023-11-11 18:02:45','2023-11-11 18:02:45'),(836,722,1,0,12780.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:04:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0662',NULL,'2023-11-11 18:04:20','2023-11-11 18:04:20'),(837,NULL,1,0,2250.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:06:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0663',NULL,'2023-11-11 18:06:54','2023-11-11 18:06:54'),(838,631,1,0,2250.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:06:00',3,0,NULL,0,51,837,NULL,NULL,'SE2023/0664',NULL,'2023-11-11 18:06:54','2023-11-11 18:06:54'),(839,724,1,0,500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:08:28',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0665',NULL,'2023-11-11 18:08:28','2023-11-11 18:08:28'),(840,725,1,0,21660.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:11:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0666',NULL,'2023-11-11 18:11:51','2023-11-11 18:11:51'),(841,726,1,0,9000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:13:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0667',NULL,'2023-11-11 18:13:27','2023-11-11 18:13:27'),(842,727,1,0,6000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:14:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0668',NULL,'2023-11-11 18:14:00','2023-11-11 18:14:00'),(843,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:14:00',3,0,NULL,1,49,NULL,NULL,NULL,'SE2023/0669',NULL,'2023-11-11 18:14:59','2023-11-11 18:14:59'),(844,578,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:14:00',3,0,NULL,0,49,843,NULL,NULL,'SE2023/0670',NULL,'2023-11-11 18:14:59','2023-11-11 18:14:59'),(845,728,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:24:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0671',NULL,'2023-11-11 18:24:23','2023-11-11 18:24:23'),(846,NULL,1,0,56978.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:42:00',3,0,NULL,1,73,NULL,NULL,NULL,'PP2023/0152',NULL,'2023-11-11 18:42:55','2023-11-11 18:42:55'),(847,435,1,0,56978.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:42:00',3,0,NULL,0,73,846,NULL,NULL,'PP2023/0153',NULL,'2023-11-11 18:42:55','2023-11-11 18:42:55'),(848,729,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 18:43:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0672',NULL,'2023-11-11 18:43:11','2023-11-11 18:43:11'),(849,730,1,0,270.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:06:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0673',NULL,'2023-11-11 19:07:12','2023-11-11 19:07:12'),(850,731,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:08:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0674',NULL,'2023-11-11 19:08:29','2023-11-11 19:08:29'),(851,732,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:09:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0675',NULL,'2023-11-11 19:09:49','2023-11-11 19:09:49'),(852,733,1,0,380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:18:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0676',NULL,'2023-11-11 19:18:05','2023-11-11 19:18:05'),(853,734,1,0,1620.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:22:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0677',NULL,'2023-11-11 19:22:43','2023-11-11 19:22:43'),(854,NULL,1,0,250000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:24:00',3,0,NULL,1,32,NULL,NULL,NULL,'PP2023/0154',NULL,'2023-11-11 19:24:36','2023-11-11 19:24:36'),(855,371,1,0,204020.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:24:00',3,0,NULL,0,32,854,NULL,NULL,'PP2023/0155',NULL,'2023-11-11 19:24:36','2023-11-11 19:24:36'),(856,490,1,0,45980.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:24:00',3,0,NULL,0,32,854,NULL,NULL,'PP2023/0156',NULL,'2023-11-11 19:24:36','2023-11-11 19:24:36'),(857,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:24:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0157',NULL,'2023-11-11 19:24:59','2023-11-11 19:24:59'),(858,628,1,0,150000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:24:00',3,0,NULL,0,33,857,NULL,NULL,'PP2023/0158',NULL,'2023-11-11 19:24:59','2023-11-11 19:24:59'),(859,735,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:33:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0678',NULL,'2023-11-11 19:33:30','2023-11-11 19:33:30'),(860,736,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:35:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0679',NULL,'2023-11-11 19:35:28','2023-11-11 19:35:28'),(861,737,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:36:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0680',NULL,'2023-11-11 19:36:29','2023-11-11 19:36:29'),(862,738,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:51:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0681',NULL,'2023-11-11 19:51:42','2023-11-11 19:51:42'),(863,739,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 19:56:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0682',NULL,'2023-11-11 19:56:19','2023-11-11 19:56:19'),(864,740,1,0,13670.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 20:27:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0683',NULL,'2023-11-11 20:27:33','2023-11-11 20:27:33'),(865,741,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 20:28:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0684',NULL,'2023-11-11 20:28:30','2023-11-11 20:28:30'),(866,NULL,1,0,2450.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 20:28:00',3,0,NULL,1,50,NULL,NULL,NULL,'SE2023/0685',NULL,'2023-11-11 20:28:55','2023-11-11 20:28:55'),(867,679,1,0,2450.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-11 20:28:00',3,0,NULL,0,50,866,NULL,NULL,'SE2023/0686',NULL,'2023-11-11 20:28:55','2023-11-11 20:28:55'),(868,NULL,1,0,6160.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:12:00',3,0,NULL,1,59,NULL,NULL,NULL,'SE2023/0687',NULL,'2023-11-12 10:12:53','2023-11-12 10:12:53'),(869,723,1,0,6160.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:12:00',3,0,NULL,0,59,868,NULL,NULL,'SE2023/0688',NULL,'2023-11-12 10:12:53','2023-11-12 10:12:53'),(870,NULL,1,0,7000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:13:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0689',NULL,'2023-11-12 10:13:18','2023-11-12 10:13:18'),(871,289,1,0,1640.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:13:00',3,0,NULL,0,35,870,NULL,NULL,'SE2023/0690',NULL,'2023-11-12 10:13:18','2023-11-12 10:13:18'),(872,364,1,0,5360.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:13:00',3,0,NULL,0,35,870,NULL,NULL,'SE2023/0691',NULL,'2023-11-12 10:13:18','2023-11-12 10:13:18'),(873,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:14:00',3,0,NULL,1,53,NULL,NULL,NULL,'SE2023/0692',NULL,'2023-11-12 10:16:01','2023-11-12 10:16:01'),(874,606,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:14:00',3,0,NULL,0,53,873,NULL,NULL,'SE2023/0693',NULL,'2023-11-12 10:16:01','2023-11-12 10:16:01'),(875,742,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:29:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0694',NULL,'2023-11-12 10:29:32','2023-11-12 10:29:32'),(876,743,1,0,1600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:33:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0695',NULL,'2023-11-12 10:33:00','2023-11-12 10:33:00'),(877,744,1,0,2480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:48:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0696',NULL,'2023-11-12 10:48:42','2023-11-12 10:48:42'),(878,745,1,0,5840.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:51:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0697',NULL,'2023-11-12 10:51:55','2023-11-12 10:51:55'),(879,746,1,0,5015.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:54:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0698',NULL,'2023-11-12 10:54:39','2023-11-12 10:54:39'),(880,747,1,0,1750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:54:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0699',NULL,'2023-11-12 10:54:56','2023-11-12 10:54:56'),(881,748,1,0,9800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:56:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0700',NULL,'2023-11-12 10:56:34','2023-11-12 10:56:34'),(882,749,1,0,1200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:56:55',3,0,NULL,0,49,NULL,NULL,NULL,'SE2023/0701',NULL,'2023-11-12 10:56:55','2023-11-12 10:56:55'),(883,750,1,0,4900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 10:57:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0702',NULL,'2023-11-12 10:57:25','2023-11-12 10:57:25'),(884,752,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 11:07:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0703',NULL,'2023-11-12 11:07:58','2023-11-12 11:07:58'),(885,753,1,0,2650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 11:29:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0704',NULL,'2023-11-12 11:29:27','2023-11-12 11:29:27'),(886,755,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:01:37',3,0,NULL,0,85,NULL,NULL,NULL,'SE2023/0705',NULL,'2023-11-12 12:01:37','2023-11-12 12:01:37'),(887,756,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:02:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0706',NULL,'2023-11-12 12:02:44','2023-11-12 12:02:44'),(888,757,1,0,0.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:03:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0707',NULL,'2023-11-12 12:03:44','2023-11-12 12:09:22'),(889,758,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:05:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0708',NULL,'2023-11-12 12:05:49','2023-11-12 12:05:49'),(890,759,1,0,2000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:11:00',3,0,NULL,0,NULL,NULL,'chicken via sanna',NULL,'SE2023/0709',NULL,'2023-11-12 12:12:26','2023-11-12 12:12:26'),(891,760,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 12:12:00',3,0,NULL,0,NULL,NULL,'manna cash',NULL,'SE2023/0710',NULL,'2023-11-12 12:12:49','2023-11-12 12:12:49'),(892,762,1,0,2800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 14:15:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0711',NULL,'2023-11-12 14:15:30','2023-11-12 14:15:30'),(893,763,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 14:29:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0712',NULL,'2023-11-12 14:29:29','2023-11-12 14:29:29'),(894,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 14:30:00',3,0,NULL,1,30,NULL,NULL,NULL,'PP2023/0159',NULL,'2023-11-12 14:30:35','2023-11-12 14:30:35'),(895,484,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 14:30:00',3,0,NULL,0,30,894,NULL,NULL,'PP2023/0160',NULL,'2023-11-12 14:30:35','2023-11-12 14:30:35'),(896,764,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 14:54:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0713',NULL,'2023-11-12 14:54:01','2023-11-12 14:54:01'),(897,765,1,0,240.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 14:56:03',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0714',NULL,'2023-11-12 14:56:03','2023-11-12 14:56:03'),(898,766,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 14:56:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0715',NULL,'2023-11-12 14:56:28','2023-11-12 14:56:28'),(899,767,1,0,14680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 17:35:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0716',NULL,'2023-11-12 17:35:27','2023-11-12 17:35:27'),(900,768,1,0,4950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 17:36:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0717',NULL,'2023-11-12 17:36:11','2023-11-12 17:36:11'),(901,769,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 17:42:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0718',NULL,'2023-11-12 17:42:10','2023-11-12 17:42:10'),(902,770,1,0,57900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 17:53:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0719',NULL,'2023-11-12 17:53:01','2023-11-12 17:53:01'),(903,771,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 17:59:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0720',NULL,'2023-11-12 17:59:49','2023-11-12 17:59:49'),(904,772,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:00:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0721',NULL,'2023-11-12 18:00:33','2023-11-12 18:00:33'),(905,773,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:04:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0722',NULL,'2023-11-12 18:04:31','2023-11-12 18:04:31'),(906,774,1,0,340.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:05:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0723',NULL,'2023-11-12 18:06:19','2023-11-12 18:06:19'),(907,775,1,0,350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:11:00',3,0,NULL,0,NULL,NULL,'vegetable via billal',NULL,'SE2023/0724',NULL,'2023-11-12 18:13:11','2023-11-12 18:13:11'),(908,776,1,0,3080.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:22:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0725',NULL,'2023-11-12 18:22:08','2023-11-12 18:22:08'),(909,NULL,1,0,1450.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:32:00',3,0,NULL,1,82,NULL,NULL,NULL,'SE2023/0726',NULL,'2023-11-12 18:32:17','2023-11-12 18:32:17'),(910,650,1,0,1450.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:32:00',3,0,NULL,0,82,909,NULL,NULL,'SE2023/0727',NULL,'2023-11-12 18:32:17','2023-11-12 18:32:17'),(911,777,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:42:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0728',NULL,'2023-11-12 18:42:48','2023-11-12 18:42:48'),(912,778,1,0,3050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 18:46:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0729',NULL,'2023-11-12 18:46:25','2023-11-12 18:46:25'),(913,779,1,0,4500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 19:07:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0730',NULL,'2023-11-12 19:07:57','2023-11-12 19:07:57'),(914,780,1,0,1480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 19:20:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0731',NULL,'2023-11-12 19:20:32','2023-11-12 19:20:32'),(915,781,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 19:28:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0732',NULL,'2023-11-12 19:28:49','2023-11-12 19:28:49'),(916,782,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 19:56:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0733',NULL,'2023-11-12 19:56:34','2023-11-12 19:56:34'),(917,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 19:56:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0734',NULL,'2023-11-12 19:56:34','2023-11-12 19:56:34'),(918,783,1,0,2580.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 19:59:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0735',NULL,'2023-11-12 19:59:20','2023-11-12 19:59:20'),(919,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 19:59:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0736',NULL,'2023-11-12 19:59:20','2023-11-12 19:59:20'),(920,784,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:11:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0737',NULL,'2023-11-12 20:11:52','2023-11-12 20:11:52'),(921,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:11:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0738',NULL,'2023-11-12 20:11:52','2023-11-12 20:11:52'),(922,785,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:13:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0739',NULL,'2023-11-12 20:13:56','2023-11-12 20:13:56'),(923,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:13:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0740',NULL,'2023-11-12 20:13:56','2023-11-12 20:13:56'),(924,786,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:18:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0741',NULL,'2023-11-12 20:18:48','2023-11-12 20:18:48'),(925,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:18:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0742',NULL,'2023-11-12 20:18:48','2023-11-12 20:18:48'),(926,787,1,0,800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:33:36',3,0,NULL,0,87,NULL,NULL,NULL,'SE2023/0743',NULL,'2023-11-12 20:33:36','2023-11-12 20:33:36'),(927,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:33:00',3,0,NULL,1,87,NULL,NULL,NULL,'SE2023/0744',NULL,'2023-11-12 20:33:36','2023-11-12 20:33:36'),(928,788,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:39:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0745',NULL,'2023-11-12 20:39:20','2023-11-12 20:39:20'),(929,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:39:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0746',NULL,'2023-11-12 20:39:20','2023-11-12 20:39:20'),(930,789,1,0,3550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:45:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0747',NULL,'2023-11-12 20:45:43','2023-11-12 20:45:43'),(931,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:45:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0748',NULL,'2023-11-12 20:45:43','2023-11-12 20:45:43'),(932,790,1,0,150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:46:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0749',NULL,'2023-11-12 20:47:11','2023-11-12 20:47:11'),(933,791,1,0,1150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:58:26',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0750',NULL,'2023-11-12 20:58:26','2023-11-12 20:58:26'),(934,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-12 20:58:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0751',NULL,'2023-11-12 20:58:26','2023-11-12 20:58:26'),(935,792,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:30:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0752',NULL,'2023-11-13 10:30:01','2023-11-13 10:30:01'),(936,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:30:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0753',NULL,'2023-11-13 10:30:01','2023-11-13 10:30:01'),(937,NULL,1,0,700.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:33:00',3,0,NULL,1,87,NULL,NULL,NULL,'SE2023/0754',NULL,'2023-11-13 10:33:19','2023-11-13 10:33:19'),(938,787,1,0,700.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:33:00',3,0,NULL,0,87,937,NULL,NULL,'SE2023/0755',NULL,'2023-11-13 10:33:19','2023-11-13 10:33:19'),(939,NULL,1,0,6000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:33:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0756',NULL,'2023-11-13 10:33:49','2023-11-13 10:33:49'),(940,364,1,0,6000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:33:00',3,0,NULL,0,35,939,NULL,NULL,'SE2023/0757',NULL,'2023-11-13 10:33:49','2023-11-13 10:33:49'),(941,NULL,1,0,1500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:33:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0758',NULL,'2023-11-13 10:34:06','2023-11-13 10:34:06'),(942,382,1,0,350.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:33:00',3,0,NULL,0,36,941,NULL,NULL,'SE2023/0759',NULL,'2023-11-13 10:34:06','2023-11-13 10:34:06'),(943,432,1,0,1150.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:33:00',3,0,NULL,0,36,941,NULL,NULL,'SE2023/0760',NULL,'2023-11-13 10:34:06','2023-11-13 10:34:06'),(944,793,1,0,3330.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:38:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0761',NULL,'2023-11-13 10:38:16','2023-11-13 10:38:16'),(945,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:38:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0762',NULL,'2023-11-13 10:38:16','2023-11-13 10:38:16'),(946,794,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:43:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0763',NULL,'2023-11-13 10:43:09','2023-11-13 10:43:09'),(947,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 10:43:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0764',NULL,'2023-11-13 10:43:09','2023-11-13 10:43:09'),(948,796,1,0,340.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 11:12:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0765',NULL,'2023-11-13 11:13:19','2023-11-13 11:13:19'),(949,797,1,0,3300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 11:15:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0766',NULL,'2023-11-13 11:15:39','2023-11-13 11:15:39'),(950,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 11:15:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0767',NULL,'2023-11-13 11:15:40','2023-11-13 11:15:40'),(951,798,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 11:37:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0768',NULL,'2023-11-13 11:37:10','2023-11-13 11:37:10'),(952,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 11:37:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0769',NULL,'2023-11-13 11:37:10','2023-11-13 11:37:10'),(953,799,1,0,1280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 11:43:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0770',NULL,'2023-11-13 11:43:56','2023-11-13 11:43:56'),(954,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 11:43:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0771',NULL,'2023-11-13 11:43:56','2023-11-13 11:43:56'),(955,800,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:13:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0772',NULL,'2023-11-13 12:13:36','2023-11-13 12:13:36'),(956,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:13:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0773',NULL,'2023-11-13 12:13:36','2023-11-13 12:13:36'),(957,801,1,0,4120.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:35:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0774',NULL,'2023-11-13 12:35:30','2023-11-13 12:35:30'),(958,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:35:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0775',NULL,'2023-11-13 12:35:30','2023-11-13 12:35:30'),(959,802,1,0,2000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:44:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0776',NULL,'2023-11-13 12:44:14','2023-11-13 12:44:14'),(960,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:44:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0777',NULL,'2023-11-13 12:44:14','2023-11-13 12:44:14'),(961,803,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:45:59',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0778',NULL,'2023-11-13 12:45:59','2023-11-13 12:45:59'),(962,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 12:45:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0779',NULL,'2023-11-13 12:45:59','2023-11-13 12:45:59'),(965,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 13:38:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0781',NULL,'2023-11-13 13:38:36','2023-11-13 13:38:36'),(966,807,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 13:44:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0782',NULL,'2023-11-13 13:44:10','2023-11-13 13:44:10'),(967,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 13:44:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0783',NULL,'2023-11-13 13:44:10','2023-11-13 13:44:10'),(968,808,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:05:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0784',NULL,'2023-11-13 14:05:34','2023-11-13 14:05:34'),(969,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:05:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0785',NULL,'2023-11-13 14:05:34','2023-11-13 14:05:34'),(970,809,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:14:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0786',NULL,'2023-11-13 14:14:21','2023-11-13 14:14:21'),(971,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:14:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0787',NULL,'2023-11-13 14:14:22','2023-11-13 14:14:22'),(972,810,1,0,1630.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:37:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0788',NULL,'2023-11-13 14:37:38','2023-11-13 14:37:38'),(973,NULL,1,0,0.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:37:00',3,0,NULL,1,1,NULL,NULL,NULL,'SE2023/0789',NULL,'2023-11-13 14:37:38','2023-11-13 14:37:38'),(974,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:41:00',3,0,NULL,1,28,NULL,'via shamim',NULL,'PP2023/0162',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(975,238,1,0,37702.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:41:00',3,0,NULL,0,28,974,NULL,NULL,'PP2023/0163',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(976,297,1,0,69360.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:41:00',3,0,NULL,0,28,974,NULL,NULL,'PP2023/0164',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(977,472,1,0,42938.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:41:00',3,0,NULL,0,28,974,NULL,NULL,'PP2023/0165',NULL,'2023-11-13 14:42:06','2023-11-13 14:42:06'),(978,812,1,0,7750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:53:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0790',NULL,'2023-11-13 14:53:58','2023-11-13 14:53:58'),(979,NULL,1,0,1330.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:57:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0791',NULL,'2023-11-13 14:57:16','2023-11-13 14:57:16'),(980,724,1,0,1330.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:57:00',3,0,NULL,0,51,979,NULL,NULL,'SE2023/0792',NULL,'2023-11-13 14:57:16','2023-11-13 14:57:16'),(981,814,1,0,2170.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 14:58:09',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0793',NULL,'2023-11-13 14:58:09','2023-11-13 14:58:09'),(982,NULL,1,0,9000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:07:00',3,0,NULL,1,13,NULL,NULL,NULL,'SE2023/0794',NULL,'2023-11-13 19:07:34','2023-11-13 19:07:34'),(983,46,1,0,7900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:07:00',3,0,NULL,0,13,982,NULL,NULL,'PP2023/0166',NULL,'2023-11-13 19:07:34','2023-11-13 19:07:34'),(984,237,1,0,1100.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:07:00',3,0,NULL,0,13,982,NULL,NULL,'SE2023/0795',NULL,'2023-11-13 19:07:34','2023-11-13 19:07:34'),(985,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:11:00',3,0,NULL,1,73,NULL,NULL,NULL,'PP2023/0167',NULL,'2023-11-13 19:11:49','2023-11-13 19:11:49'),(986,795,1,0,48360.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:11:00',3,0,NULL,0,73,985,NULL,NULL,'PP2023/0168',NULL,'2023-11-13 19:11:49','2023-11-13 19:11:49'),(987,815,1,0,1640.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:11:00',3,0,NULL,0,73,985,NULL,NULL,'PP2023/0169',NULL,'2023-11-13 19:11:49','2023-11-13 19:11:49'),(988,816,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:13:25',3,0,NULL,0,58,NULL,NULL,NULL,'SE2023/0796',NULL,'2023-11-13 19:13:25','2023-11-13 19:13:25'),(989,817,1,0,2480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:19:59',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0797',NULL,'2023-11-13 19:19:59','2023-11-13 19:19:59'),(990,818,1,0,770.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:20:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0798',NULL,'2023-11-13 19:20:59','2023-11-13 19:20:59'),(991,819,1,0,15950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:26:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0799',NULL,'2023-11-13 19:26:16','2023-11-13 19:26:16'),(992,820,1,0,53200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:29:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0800',NULL,'2023-11-13 19:29:12','2023-11-13 19:29:12'),(993,821,1,0,12289.9200,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:34:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0801',NULL,'2023-11-13 19:34:07','2023-11-13 19:34:07'),(994,822,1,0,5950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:36:43',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0802',NULL,'2023-11-13 19:36:43','2023-11-13 19:36:43'),(995,823,1,0,6150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:47:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0803',NULL,'2023-11-13 19:47:54','2023-11-13 19:47:54'),(996,824,1,0,1350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 19:53:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0804',NULL,'2023-11-13 19:53:40','2023-11-13 19:53:40'),(997,825,1,0,4600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 20:01:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0805',NULL,'2023-11-13 20:01:37','2023-11-13 20:01:37'),(998,826,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 20:07:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0806',NULL,'2023-11-13 20:08:21','2023-11-13 20:08:21'),(999,827,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 20:09:00',3,0,NULL,0,NULL,NULL,'sunday night+adv monday night',NULL,'SE2023/0807',NULL,'2023-11-13 20:10:06','2023-11-13 20:10:06'),(1000,828,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-13 20:15:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0808',NULL,'2023-11-13 20:15:36','2023-11-13 20:15:36'),(1001,829,1,0,12259.9800,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:22:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0809',NULL,'2023-11-14 10:22:54','2023-11-14 10:22:54'),(1002,830,1,0,3930.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:24:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0810',NULL,'2023-11-14 10:24:14','2023-11-14 10:24:14'),(1003,831,1,0,11500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:26:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0811',NULL,'2023-11-14 10:26:13','2023-11-14 10:26:13'),(1004,832,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:26:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0812',NULL,'2023-11-14 10:26:49','2023-11-14 10:26:49'),(1005,833,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:32:41',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0813',NULL,'2023-11-14 10:32:41','2023-11-14 10:32:41'),(1006,834,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:35:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0814',NULL,'2023-11-14 10:35:19','2023-11-14 10:35:19'),(1007,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:46:00',3,0,NULL,1,53,NULL,NULL,NULL,'SE2023/0815',NULL,'2023-11-14 10:46:35','2023-11-14 10:46:35'),(1008,606,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:46:00',3,0,NULL,0,53,1007,NULL,NULL,'SE2023/0816',NULL,'2023-11-14 10:46:35','2023-11-14 10:46:35'),(1009,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:46:00',3,0,NULL,1,81,NULL,NULL,NULL,'SE2023/0817',NULL,'2023-11-14 10:46:54','2023-11-14 10:46:54'),(1010,720,1,0,3000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:46:00',3,0,NULL,0,81,1009,NULL,NULL,'SE2023/0818',NULL,'2023-11-14 10:46:54','2023-11-14 10:46:54'),(1011,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:47:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0819',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1012,432,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:47:00',3,0,NULL,0,36,1011,NULL,NULL,'SE2023/0820',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1013,495,1,0,1650.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:47:00',3,0,NULL,0,36,1011,NULL,NULL,'SE2023/0821',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1014,528,1,0,850.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:47:00',3,0,NULL,0,36,1011,NULL,NULL,'SE2023/0822',NULL,'2023-11-14 10:47:27','2023-11-14 10:47:27'),(1015,835,1,0,13000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:51:22',3,0,NULL,0,35,NULL,NULL,NULL,'SE2023/0823',NULL,'2023-11-14 10:51:22','2023-11-14 10:51:22'),(1016,836,1,0,3150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 10:53:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0824',NULL,'2023-11-14 10:53:53','2023-11-14 10:53:53'),(1017,837,1,0,1380.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 11:05:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0825',NULL,'2023-11-14 11:05:44','2023-11-14 11:05:44'),(1018,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 11:32:00',3,0,NULL,1,58,NULL,NULL,NULL,'SE2023/0826',NULL,'2023-11-14 11:32:04','2023-11-14 11:32:04'),(1019,816,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 11:32:00',3,0,NULL,0,58,1018,NULL,NULL,'SE2023/0827',NULL,'2023-11-14 11:32:04','2023-11-14 11:32:04'),(1020,838,1,0,4650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 12:19:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0828',NULL,'2023-11-14 12:19:48','2023-11-14 12:19:48'),(1021,839,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 12:34:22',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0829',NULL,'2023-11-14 12:34:22','2023-11-14 12:34:22'),(1022,840,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 12:36:22',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0830',NULL,'2023-11-14 12:36:22','2023-11-14 12:36:22'),(1023,841,1,0,28340.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 12:46:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0831',NULL,'2023-11-14 12:46:28','2023-11-14 12:46:28'),(1024,842,1,0,7420.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 13:22:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0832',NULL,'2023-11-14 13:22:02','2023-11-14 13:22:02'),(1025,845,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 13:40:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0833',NULL,'2023-11-14 13:40:53','2023-11-14 13:40:53'),(1026,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 13:50:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0170',NULL,'2023-11-14 13:51:04','2023-11-14 13:51:04'),(1027,628,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 13:50:00',3,0,NULL,0,33,1026,NULL,NULL,'PP2023/0171',NULL,'2023-11-14 13:51:04','2023-11-14 13:51:04'),(1028,846,1,0,1770.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 13:56:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0834',NULL,'2023-11-14 13:56:37','2023-11-14 13:56:37'),(1029,847,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 13:59:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0835',NULL,'2023-11-14 13:59:01','2023-11-14 13:59:01'),(1030,848,1,0,7500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 14:00:17',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0836',NULL,'2023-11-14 14:00:17','2023-11-14 14:00:17'),(1031,849,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 14:02:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0837',NULL,'2023-11-14 14:02:00','2023-11-14 14:02:00'),(1032,850,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 14:12:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0838',NULL,'2023-11-14 14:12:38','2023-11-14 14:12:38'),(1033,851,1,0,400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 14:16:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0839',NULL,'2023-11-14 14:16:53','2023-11-14 14:16:53'),(1034,852,1,0,4650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 14:24:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0840',NULL,'2023-11-14 14:24:38','2023-11-14 14:24:38'),(1035,853,1,0,1775.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 14:54:05',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0841',NULL,'2023-11-14 14:54:05','2023-11-14 14:54:05'),(1036,854,1,0,1180.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 17:43:29',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0842',NULL,'2023-11-14 17:43:29','2023-11-14 17:43:29'),(1037,856,1,0,800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 17:48:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0843',NULL,'2023-11-14 17:48:53','2023-11-14 17:48:53'),(1038,857,1,0,26160.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 17:53:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0844',NULL,'2023-11-14 17:53:44','2023-11-14 17:53:44'),(1039,858,1,0,22500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 17:57:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0845',NULL,'2023-11-14 17:57:38','2023-11-14 17:57:38'),(1040,859,1,0,3639.5100,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 17:58:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0846',NULL,'2023-11-14 17:58:25','2023-11-14 17:58:25'),(1041,861,1,0,1280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:07:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0847',NULL,'2023-11-14 18:07:15','2023-11-14 18:07:15'),(1042,862,1,0,2930.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:09:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0848',NULL,'2023-11-14 18:09:36','2023-11-14 18:09:36'),(1043,NULL,1,0,8000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:23:00',3,0,NULL,1,44,NULL,NULL,NULL,'SE2023/0849',NULL,'2023-11-14 18:23:10','2023-11-14 18:23:10'),(1044,131,1,0,8000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:23:00',3,0,NULL,0,44,1043,NULL,NULL,'PP2023/0172',NULL,'2023-11-14 18:23:10','2023-11-14 18:23:10'),(1045,863,1,0,3180.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:25:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0850',NULL,'2023-11-14 18:25:47','2023-11-14 18:25:47'),(1046,864,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:29:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0851',NULL,'2023-11-14 18:29:39','2023-11-14 18:29:39'),(1047,866,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:32:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0852',NULL,'2023-11-14 18:32:52','2023-11-14 18:32:52'),(1048,867,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:45:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0853',NULL,'2023-11-14 18:45:45','2023-11-14 18:45:45'),(1049,868,1,0,3350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:48:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0854',NULL,'2023-11-14 18:48:55','2023-11-14 18:48:55'),(1050,869,1,0,3350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 18:50:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0855',NULL,'2023-11-14 18:50:29','2023-11-14 18:50:29'),(1051,870,1,0,5700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 19:36:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0856',NULL,'2023-11-14 19:36:46','2023-11-14 19:36:46'),(1052,871,1,0,150000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 19:44:00',3,0,NULL,0,90,NULL,NULL,NULL,'PP2023/0173',NULL,'2023-11-14 19:49:38','2023-11-14 19:49:38'),(1053,872,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 20:08:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0857',NULL,'2023-11-14 20:08:38','2023-11-14 20:08:38'),(1054,873,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 20:15:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0858',NULL,'2023-11-14 20:15:27','2023-11-14 20:15:27'),(1055,874,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-14 20:15:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0859',NULL,'2023-11-14 20:15:53','2023-11-14 20:15:53'),(1056,NULL,1,0,2050.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:20:00',3,0,NULL,1,89,NULL,NULL,NULL,'SE2023/0860',NULL,'2023-11-15 10:20:37','2023-11-15 10:20:37'),(1057,865,1,0,2050.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:20:00',3,0,NULL,0,89,1056,NULL,NULL,'SE2023/0861',NULL,'2023-11-15 10:20:37','2023-11-15 10:20:37'),(1058,NULL,1,0,1000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:21:00',3,0,NULL,1,49,NULL,NULL,NULL,'SE2023/0862',NULL,'2023-11-15 10:21:18','2023-11-15 10:21:18'),(1059,749,1,0,1000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:21:00',3,0,NULL,0,49,1058,NULL,NULL,'SE2023/0863',NULL,'2023-11-15 10:21:18','2023-11-15 10:21:18'),(1060,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:21:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0864',NULL,'2023-11-15 10:21:45','2023-11-15 10:21:45'),(1061,528,1,0,800.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:21:00',3,0,NULL,0,36,1060,NULL,NULL,'SE2023/0865',NULL,'2023-11-15 10:21:45','2023-11-15 10:21:45'),(1062,555,1,0,1200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:21:00',3,0,NULL,0,36,1060,NULL,NULL,'SE2023/0866',NULL,'2023-11-15 10:21:45','2023-11-15 10:21:45'),(1063,875,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:27:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0867',NULL,'2023-11-15 10:27:50','2023-11-15 10:27:50'),(1064,876,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:29:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0868',NULL,'2023-11-15 10:29:46','2023-11-15 10:29:46'),(1065,877,1,0,2730.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:31:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0869',NULL,'2023-11-15 10:31:23','2023-11-15 10:31:23'),(1066,878,1,0,15600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:35:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0870',NULL,'2023-11-15 10:35:53','2023-11-15 10:35:53'),(1067,879,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:38:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0871',NULL,'2023-11-15 10:38:37','2023-11-15 10:38:37'),(1068,880,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:40:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0872',NULL,'2023-11-15 10:40:45','2023-11-15 10:40:45'),(1069,881,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:49:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0873',NULL,'2023-11-15 10:49:01','2023-11-15 10:49:01'),(1070,883,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:51:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0874',NULL,'2023-11-15 10:51:25','2023-11-15 10:51:25'),(1071,884,1,0,17030.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 10:55:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0875',NULL,'2023-11-15 10:55:53','2023-11-15 10:55:53'),(1072,885,1,0,43371.3300,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 11:18:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0876',NULL,'2023-11-15 11:18:45','2023-11-15 11:18:45'),(1073,886,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 11:21:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0877',NULL,'2023-11-15 11:21:21','2023-11-15 11:21:21'),(1074,887,1,0,2970.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 11:24:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0878',NULL,'2023-11-15 11:24:15','2023-11-15 11:24:15'),(1075,888,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:16:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0879',NULL,'2023-11-15 12:16:10','2023-11-15 12:16:10'),(1076,NULL,1,0,1225.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:21:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/0880',NULL,'2023-11-15 12:21:17','2023-11-15 12:21:17'),(1077,814,1,0,880.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:21:00',3,0,NULL,0,51,1076,NULL,NULL,'SE2023/0881',NULL,'2023-11-15 12:21:17','2023-11-15 12:21:17'),(1078,854,1,0,345.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:21:00',3,0,NULL,0,51,1076,NULL,NULL,'SE2023/0882',NULL,'2023-11-15 12:21:17','2023-11-15 12:21:17'),(1079,889,1,0,4300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:24:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0883',NULL,'2023-11-15 12:24:47','2023-11-15 12:24:47'),(1080,890,1,0,775.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:25:39',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/0884',NULL,'2023-11-15 12:25:39','2023-11-15 12:25:39'),(1081,893,1,0,5960.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:35:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0885',NULL,'2023-11-15 12:35:23','2023-11-15 12:35:23'),(1082,894,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:41:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0886',NULL,'2023-11-15 12:41:34','2023-11-15 12:41:34'),(1083,895,1,0,3070.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:49:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0887',NULL,'2023-11-15 12:49:14','2023-11-15 12:49:14'),(1084,896,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 12:50:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0888',NULL,'2023-11-15 12:50:06','2023-11-15 12:50:06'),(1085,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 13:18:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0889',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1086,555,1,0,450.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 13:18:00',3,0,NULL,0,36,1085,NULL,NULL,'SE2023/0890',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1087,594,1,0,1650.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 13:18:00',3,0,NULL,0,36,1085,NULL,NULL,'SE2023/0891',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1088,633,1,0,900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 13:18:00',3,0,NULL,0,36,1085,NULL,NULL,'SE2023/0892',NULL,'2023-11-15 13:18:29','2023-11-15 13:18:29'),(1089,897,1,0,5050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:00:53',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0893',NULL,'2023-11-15 14:00:53','2023-11-15 14:00:53'),(1090,898,1,0,7860.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:01:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0894',NULL,'2023-11-15 14:01:54','2023-11-15 14:01:54'),(1091,900,1,0,340.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:12:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0895',NULL,'2023-11-15 14:13:15','2023-11-15 14:13:15'),(1092,901,1,0,6000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:15:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0896',NULL,'2023-11-15 14:15:39','2023-11-15 14:15:39'),(1093,903,1,0,4000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:22:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0897',NULL,'2023-11-15 14:22:19','2023-11-15 14:22:19'),(1094,904,1,0,4400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:45:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0898',NULL,'2023-11-15 14:45:46','2023-11-15 14:45:46'),(1095,905,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:52:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0899',NULL,'2023-11-15 14:52:00','2023-11-15 14:52:00'),(1096,906,1,0,1280.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 14:55:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0900',NULL,'2023-11-15 14:55:33','2023-11-15 14:55:33'),(1097,NULL,1,0,32000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:06:00',3,0,NULL,1,12,NULL,NULL,NULL,'SE2023/0901',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1098,96,1,0,22020.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:06:00',3,0,NULL,0,12,1097,NULL,NULL,'PP2023/0174',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1099,122,1,0,5700.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:06:00',3,0,NULL,0,12,1097,NULL,NULL,'SE2023/0902',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1100,179,1,0,2900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:06:00',3,0,NULL,0,12,1097,NULL,NULL,'SE2023/0903',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1101,423,1,0,1380.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:06:00',3,0,NULL,0,12,1097,NULL,NULL,'SE2023/0904',NULL,'2023-11-15 17:06:42','2023-11-15 17:06:42'),(1102,NULL,1,0,5000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:32:00',3,0,NULL,1,34,NULL,NULL,NULL,'PP2023/0175',NULL,'2023-11-15 17:32:39','2023-11-15 17:32:39'),(1103,60,1,0,5000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:32:00',3,0,NULL,0,34,1102,NULL,NULL,'PP2023/0176',NULL,'2023-11-15 17:32:39','2023-11-15 17:32:39'),(1104,907,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:34:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0905',NULL,'2023-11-15 17:34:12','2023-11-15 17:34:12'),(1105,NULL,1,0,1500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:36:00',3,0,NULL,1,40,NULL,NULL,NULL,'SE2023/0906',NULL,'2023-11-15 17:36:50','2023-11-15 17:36:50'),(1106,104,1,0,1500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 17:36:00',3,0,NULL,0,40,1105,NULL,NULL,'PP2023/0177',NULL,'2023-11-15 17:36:50','2023-11-15 17:36:50'),(1107,908,1,0,10630.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:05:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0907',NULL,'2023-11-15 18:05:21','2023-11-15 18:05:21'),(1108,909,1,0,14400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:07:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0908',NULL,'2023-11-15 18:07:02','2023-11-15 18:07:02'),(1109,910,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:26:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0909',NULL,'2023-11-15 18:26:39','2023-11-15 18:26:39'),(1110,911,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:36:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0910',NULL,'2023-11-15 18:36:07','2023-11-15 18:36:07'),(1111,912,1,0,8800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:37:21',3,0,NULL,0,68,NULL,NULL,NULL,'SE2023/0911',NULL,'2023-11-15 18:37:21','2023-11-15 18:37:21'),(1112,912,1,1,4400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:37:21',3,0,NULL,0,68,NULL,NULL,NULL,'SE2023/0912',NULL,'2023-11-15 18:37:21','2023-11-15 18:37:21'),(1113,913,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:40:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0913',NULL,'2023-11-15 18:40:57','2023-11-15 18:40:57'),(1114,NULL,1,0,4400.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:45:00',3,0,NULL,1,68,NULL,NULL,NULL,'SE2023/0914',NULL,'2023-11-15 18:45:42','2023-11-15 18:45:42'),(1115,408,1,0,4400.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 18:45:00',3,0,NULL,0,68,1114,NULL,NULL,'SE2023/0915',NULL,'2023-11-15 18:45:42','2023-11-15 18:45:42'),(1116,NULL,1,0,1200.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 19:18:00',3,0,NULL,1,34,NULL,'driver after counting by camera',NULL,'PP2023/0178',NULL,'2023-11-15 19:19:36','2023-11-15 19:19:36'),(1117,60,1,0,1200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 19:18:00',3,0,NULL,0,34,1116,NULL,NULL,'PP2023/0179',NULL,'2023-11-15 19:19:36','2023-11-15 19:19:36'),(1118,914,1,0,3600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 19:24:24',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0916',NULL,'2023-11-15 19:24:24','2023-11-15 19:24:24'),(1119,NULL,1,0,1850.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 19:41:00',3,0,NULL,1,65,NULL,NULL,NULL,'SE2023/0917',NULL,'2023-11-15 19:41:39','2023-11-15 19:41:39'),(1120,322,1,0,1850.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 19:41:00',3,0,NULL,0,65,1119,NULL,NULL,'SE2023/0918',NULL,'2023-11-15 19:41:39','2023-11-15 19:41:39'),(1121,NULL,1,0,2950.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 19:53:00',3,0,NULL,1,86,NULL,NULL,NULL,'SE2023/0919',NULL,'2023-11-15 19:53:59','2023-11-15 19:53:59'),(1122,757,1,0,2950.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-15 19:53:00',3,0,NULL,0,86,1121,NULL,NULL,'SE2023/0920',NULL,'2023-11-15 19:53:59','2023-11-15 19:53:59'),(1123,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:17:00',3,0,NULL,1,34,NULL,NULL,NULL,'PP2023/0180',NULL,'2023-11-16 11:19:53','2023-11-16 11:19:53'),(1124,60,1,0,1254.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:17:00',3,0,NULL,0,34,1123,NULL,NULL,'PP2023/0181',NULL,'2023-11-16 11:19:53','2023-11-16 11:19:53'),(1125,902,1,0,148746.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:17:00',3,0,NULL,0,34,1123,NULL,NULL,'PP2023/0182',NULL,'2023-11-16 11:19:53','2023-11-16 11:19:53'),(1126,916,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:21:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0921',NULL,'2023-11-16 11:21:13','2023-11-16 11:21:13'),(1127,917,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:21:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0922',NULL,'2023-11-16 11:21:45','2023-11-16 11:21:45'),(1128,NULL,1,0,1500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:24:00',3,0,NULL,1,88,NULL,'staff',NULL,'SE2023/0923',NULL,'2023-11-16 11:25:05','2023-11-16 11:25:05'),(1129,805,1,0,1500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:24:00',3,0,NULL,0,88,1128,NULL,NULL,'SE2023/0924',NULL,'2023-11-16 11:25:05','2023-11-16 11:25:05'),(1130,NULL,1,0,5000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:31:00',3,0,NULL,1,35,NULL,'15/11/23',NULL,'SE2023/0925',NULL,'2023-11-16 11:31:43','2023-11-16 11:31:43'),(1131,364,1,0,1310.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:31:00',3,0,NULL,0,35,1130,NULL,NULL,'SE2023/0926',NULL,'2023-11-16 11:31:43','2023-11-16 11:31:43'),(1132,429,1,0,3690.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:31:00',3,0,NULL,0,35,1130,NULL,NULL,'SE2023/0927',NULL,'2023-11-16 11:31:43','2023-11-16 11:31:43'),(1133,NULL,1,0,10000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:31:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0928',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1134,429,1,0,3490.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:31:00',3,0,NULL,0,35,1133,NULL,NULL,'SE2023/0929',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1135,497,1,0,5900.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:31:00',3,0,NULL,0,35,1133,NULL,NULL,'SE2023/0930',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1136,538,1,0,610.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:31:00',3,0,NULL,0,35,1133,NULL,NULL,'SE2023/0931',NULL,'2023-11-16 11:32:11','2023-11-16 11:32:11'),(1137,NULL,1,0,2350.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:32:00',3,0,NULL,1,59,NULL,NULL,NULL,'SE2023/0932',NULL,'2023-11-16 11:32:30','2023-11-16 11:32:30'),(1138,882,1,0,2350.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:32:00',3,0,NULL,0,59,1137,NULL,NULL,'SE2023/0933',NULL,'2023-11-16 11:32:30','2023-11-16 11:32:30'),(1139,918,1,0,1850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:33:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0934',NULL,'2023-11-16 11:33:36','2023-11-16 11:33:36'),(1140,919,1,0,1750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:52:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0935',NULL,'2023-11-16 11:52:28','2023-11-16 11:52:28'),(1141,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:59:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0183',NULL,'2023-11-16 12:00:01','2023-11-16 12:00:01'),(1142,628,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 11:59:00',3,0,NULL,0,33,1141,NULL,NULL,'PP2023/0184',NULL,'2023-11-16 12:00:01','2023-11-16 12:00:01'),(1143,NULL,1,0,128320.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:00:00',3,0,NULL,1,76,NULL,NULL,NULL,'PP2023/0185',NULL,'2023-11-16 12:00:43','2023-11-16 12:00:43'),(1144,855,1,0,128320.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:00:00',3,0,NULL,0,76,1143,NULL,NULL,'PP2023/0186',NULL,'2023-11-16 12:00:43','2023-11-16 12:00:43'),(1145,920,1,0,18450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:09:23',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0936',NULL,'2023-11-16 12:09:23','2023-11-16 12:09:23'),(1146,922,1,0,13350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:13:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0937',NULL,'2023-11-16 12:13:13','2023-11-16 12:13:13'),(1147,923,1,0,34500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:14:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0938',NULL,'2023-11-16 12:14:37','2023-11-16 12:14:37'),(1148,924,1,0,13400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:16:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0939',NULL,'2023-11-16 12:16:45','2023-11-16 12:16:45'),(1149,926,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:18:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0940',NULL,'2023-11-16 12:18:10','2023-11-16 12:18:10'),(1150,927,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:29:03',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0941',NULL,'2023-11-16 12:29:03','2023-11-16 12:29:03'),(1151,929,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 12:53:33',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0942',NULL,'2023-11-16 12:53:33','2023-11-16 12:53:33'),(1152,930,1,0,10270.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 13:24:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0943',NULL,'2023-11-16 13:24:12','2023-11-16 13:24:12'),(1153,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 13:39:00',3,0,NULL,1,18,NULL,NULL,NULL,'SE2023/0944',NULL,'2023-11-16 13:39:10','2023-11-16 13:39:10'),(1154,50,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 13:39:00',3,0,NULL,0,18,1153,NULL,NULL,'PP2023/0187',NULL,'2023-11-16 13:39:10','2023-11-16 13:39:10'),(1155,932,1,0,2150.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 13:58:46',3,0,NULL,0,43,NULL,NULL,NULL,'SE2023/0945',NULL,'2023-11-16 13:58:46','2023-11-16 13:58:46'),(1156,NULL,1,0,700.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 16:59:00',3,0,NULL,1,84,NULL,NULL,NULL,'SE2023/0946',NULL,'2023-11-16 16:59:56','2023-11-16 16:59:56'),(1157,694,1,0,700.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 16:59:00',3,0,NULL,0,84,1156,NULL,NULL,'SE2023/0947',NULL,'2023-11-16 16:59:56','2023-11-16 16:59:56'),(1158,933,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:01:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0948',NULL,'2023-11-16 17:01:40','2023-11-16 17:01:40'),(1159,934,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:04:10',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0949',NULL,'2023-11-16 17:04:10','2023-11-16 17:04:10'),(1160,936,1,0,520.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:07:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0950',NULL,'2023-11-16 17:07:22','2023-11-16 17:07:22'),(1161,937,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:11:03',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0951',NULL,'2023-11-16 17:11:03','2023-11-16 17:11:03'),(1162,938,1,0,5500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:11:37',3,0,NULL,0,93,NULL,NULL,NULL,'SE2023/0952',NULL,'2023-11-16 17:11:37','2023-11-16 17:11:37'),(1163,939,1,0,15600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:12:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0953',NULL,'2023-11-16 17:12:27','2023-11-16 17:12:27'),(1164,940,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:13:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0954',NULL,'2023-11-16 17:13:00','2023-11-16 17:13:00'),(1165,941,1,0,10350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:14:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0955',NULL,'2023-11-16 17:14:29','2023-11-16 17:14:29'),(1166,942,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:15:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0956',NULL,'2023-11-16 17:15:00','2023-11-16 17:15:00'),(1167,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:15:00',3,0,NULL,1,73,NULL,NULL,NULL,'PP2023/0188',NULL,'2023-11-16 17:16:00','2023-11-16 17:16:00'),(1168,815,1,0,32520.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:15:00',3,0,NULL,0,73,1167,NULL,NULL,'PP2023/0189',NULL,'2023-11-16 17:16:00','2023-11-16 17:16:00'),(1169,935,1,0,17480.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:15:00',3,0,NULL,0,73,1167,NULL,NULL,'PP2023/0190',NULL,'2023-11-16 17:16:00','2023-11-16 17:16:00'),(1170,943,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:16:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0957',NULL,'2023-11-16 17:18:25','2023-11-16 17:18:25'),(1171,944,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:21:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0958',NULL,'2023-11-16 17:21:37','2023-11-16 17:21:37'),(1172,945,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:28:02',3,0,NULL,0,58,NULL,NULL,NULL,'SE2023/0959',NULL,'2023-11-16 17:28:02','2023-11-16 17:33:07'),(1173,946,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 17:49:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0960',NULL,'2023-11-16 17:49:36','2023-11-16 17:49:36'),(1174,947,1,0,200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 18:02:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0961',NULL,'2023-11-16 18:02:49','2023-11-16 18:02:49'),(1175,948,1,0,60.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 18:06:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0962',NULL,'2023-11-16 18:06:23','2023-11-16 18:06:23'),(1176,949,1,0,1900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 18:14:57',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0963',NULL,'2023-11-16 18:14:57','2023-11-16 18:14:57'),(1177,950,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 18:24:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0964',NULL,'2023-11-16 18:24:49','2023-11-16 18:24:49'),(1178,951,1,0,5550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 18:33:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0965',NULL,'2023-11-16 18:33:54','2023-11-16 18:33:54'),(1179,952,1,0,1750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 18:36:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0966',NULL,'2023-11-16 18:36:33','2023-11-16 18:36:33'),(1180,953,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 18:41:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0967',NULL,'2023-11-16 18:41:39','2023-11-16 18:41:39'),(1181,954,1,0,1700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:17:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0968',NULL,'2023-11-16 19:17:13','2023-11-16 19:17:13'),(1182,955,1,0,33000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:19:37',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0969',NULL,'2023-11-16 19:19:37','2023-11-16 19:19:37'),(1183,956,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:29:02',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0970',NULL,'2023-11-16 19:29:02','2023-11-16 19:29:02'),(1184,957,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:34:30',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0971',NULL,'2023-11-16 19:34:30','2023-11-16 19:34:30'),(1185,958,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:41:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0972',NULL,'2023-11-16 19:41:11','2023-11-16 19:41:11'),(1186,959,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:53:39',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0973',NULL,'2023-11-16 19:53:39','2023-11-16 19:53:39'),(1187,960,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:59:42',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0974',NULL,'2023-11-16 19:59:42','2023-11-16 19:59:42'),(1188,961,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 19:59:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0975',NULL,'2023-11-16 20:00:16','2023-11-16 20:00:16'),(1189,962,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 20:04:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0976',NULL,'2023-11-16 20:05:45','2023-11-16 20:05:45'),(1190,963,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 20:05:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0977',NULL,'2023-11-16 20:06:19','2023-11-16 20:06:19'),(1191,964,1,0,4000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 20:06:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0978',NULL,'2023-11-16 20:06:38','2023-11-16 20:06:38'),(1192,965,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 20:06:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0979',NULL,'2023-11-16 20:07:12','2023-11-16 20:07:12'),(1193,966,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-16 20:09:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0980',NULL,'2023-11-16 20:09:08','2023-11-16 20:09:08'),(1194,967,1,0,620.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:44:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0981',NULL,'2023-11-18 14:45:02','2023-11-18 14:45:02'),(1195,968,1,0,770.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:45:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0982',NULL,'2023-11-18 14:45:59','2023-11-18 14:45:59'),(1196,969,1,0,250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:46:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/0983',NULL,'2023-11-18 14:46:28','2023-11-18 14:46:28'),(1197,NULL,1,0,500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:46:00',3,0,NULL,1,93,NULL,NULL,NULL,'SE2023/0984',NULL,'2023-11-18 14:46:56','2023-11-18 14:46:56'),(1198,938,1,0,500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:46:00',3,0,NULL,0,93,1197,NULL,NULL,'SE2023/0985',NULL,'2023-11-18 14:46:56','2023-11-18 14:46:56'),(1199,NULL,1,0,350.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,1,43,NULL,NULL,NULL,'SE2023/0986',NULL,'2023-11-18 14:47:14','2023-11-18 14:47:14'),(1200,932,1,0,350.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,0,43,1199,NULL,NULL,'SE2023/0987',NULL,'2023-11-18 14:47:14','2023-11-18 14:47:14'),(1201,NULL,1,0,2500.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/0988',NULL,'2023-11-18 14:47:33','2023-11-18 14:47:33'),(1202,633,1,0,750.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,0,36,1201,NULL,NULL,'SE2023/0989',NULL,'2023-11-18 14:47:33','2023-11-18 14:47:33'),(1203,681,1,0,1750.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,0,36,1201,NULL,NULL,'SE2023/0990',NULL,'2023-11-18 14:47:33','2023-11-18 14:47:33'),(1204,NULL,1,0,5000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/0991',NULL,'2023-11-18 14:47:55','2023-11-18 14:47:55'),(1205,538,1,0,1840.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,0,35,1204,NULL,NULL,'SE2023/0992',NULL,'2023-11-18 14:47:55','2023-11-18 14:47:55'),(1206,614,1,0,3160.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:47:00',3,0,NULL,0,35,1204,NULL,NULL,'SE2023/0993',NULL,'2023-11-18 14:47:55','2023-11-18 14:47:55'),(1207,971,1,0,9660.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:50:59',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0994',NULL,'2023-11-18 14:50:59','2023-11-18 14:50:59'),(1208,972,1,0,21010.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:53:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0995',NULL,'2023-11-18 14:53:38','2023-11-18 14:53:38'),(1209,973,1,0,20120.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 14:59:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0996',NULL,'2023-11-18 14:59:46','2023-11-18 14:59:46'),(1210,974,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:02:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0997',NULL,'2023-11-18 15:02:19','2023-11-18 15:02:19'),(1211,975,1,0,41080.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:05:41',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/0998',NULL,'2023-11-18 15:05:41','2023-11-18 15:05:41'),(1212,976,1,0,1200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:06:13',3,0,NULL,0,49,NULL,NULL,NULL,'SE2023/0999',NULL,'2023-11-18 15:06:13','2023-11-18 15:06:13'),(1213,977,1,0,18650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:08:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1000',NULL,'2023-11-18 15:08:48','2023-11-18 15:08:48'),(1214,978,1,0,0.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:14:54',3,0,NULL,0,36,NULL,NULL,NULL,'SE2023/1001',NULL,'2023-11-18 15:14:54','2023-11-18 15:16:38'),(1215,979,1,0,8030.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:17:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1002',NULL,'2023-11-18 15:17:51','2023-11-18 15:17:51'),(1216,980,1,0,18230.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:19:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1003',NULL,'2023-11-18 15:19:55','2023-11-18 15:19:55'),(1217,982,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:23:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1004',NULL,'2023-11-18 15:23:27','2023-11-18 15:23:27'),(1218,983,1,0,6000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:45:08',3,0,NULL,0,93,NULL,NULL,NULL,'SE2023/1005',NULL,'2023-11-18 15:45:08','2023-11-18 15:45:08'),(1219,984,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:46:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1006',NULL,'2023-11-18 15:46:48','2023-11-18 15:46:48'),(1220,985,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:49:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1007',NULL,'2023-11-18 15:49:46','2023-11-18 15:49:46'),(1221,986,1,0,3400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:50:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1008',NULL,'2023-11-18 15:50:06','2023-11-18 15:50:06'),(1222,987,1,0,1780.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:50:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1009',NULL,'2023-11-18 15:50:32','2023-11-18 15:50:32'),(1223,988,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:53:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1010',NULL,'2023-11-18 15:53:50','2023-11-18 15:53:50'),(1224,989,1,0,5000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:56:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1011',NULL,'2023-11-18 15:56:09','2023-11-18 15:56:09'),(1225,990,1,0,2600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 15:57:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1012',NULL,'2023-11-18 15:57:54','2023-11-18 15:57:54'),(1226,992,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 16:17:36',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1013',NULL,'2023-11-18 16:17:36','2023-11-18 16:17:36'),(1227,993,1,0,9000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 16:26:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1014',NULL,'2023-11-18 16:26:44','2023-11-18 16:26:44'),(1228,994,1,0,5500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 16:59:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1015',NULL,'2023-11-18 16:59:44','2023-11-18 16:59:44'),(1229,995,1,0,3600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 17:34:54',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1016',NULL,'2023-11-18 17:34:54','2023-11-18 17:34:54'),(1230,996,1,0,3180.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 17:44:01',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1017',NULL,'2023-11-18 17:44:01','2023-11-18 17:44:01'),(1231,997,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 17:50:51',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1018',NULL,'2023-11-18 17:50:51','2023-11-18 17:50:51'),(1232,998,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:00:15',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1019',NULL,'2023-11-18 18:00:15','2023-11-18 18:00:15'),(1233,999,1,0,1630.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:04:27',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1020',NULL,'2023-11-18 18:04:27','2023-11-18 18:04:27'),(1234,1000,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:15:24',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1021',NULL,'2023-11-18 18:15:24','2023-11-18 18:15:24'),(1235,1001,1,0,2950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:16:44',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1022',NULL,'2023-11-18 18:16:44','2023-11-18 18:16:44'),(1236,1002,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:20:29',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1023',NULL,'2023-11-18 18:20:29','2023-11-18 18:20:29'),(1237,1003,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:38:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1024',NULL,'2023-11-18 18:38:08','2023-11-18 18:38:08'),(1238,1004,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:41:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1025',NULL,'2023-11-18 18:41:56','2023-11-18 18:41:56'),(1239,1005,1,0,2500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:44:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1026',NULL,'2023-11-18 18:44:58','2023-11-18 18:44:58'),(1240,1006,1,0,2200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:48:25',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1027',NULL,'2023-11-18 18:48:25','2023-11-18 18:48:25'),(1241,1007,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 18:48:45',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1028',NULL,'2023-11-18 18:48:45','2023-11-18 18:48:45'),(1242,1008,1,0,1430.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 19:15:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1029',NULL,'2023-11-18 19:15:08','2023-11-18 19:15:08'),(1243,1009,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 19:18:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1030',NULL,'2023-11-18 19:18:34','2023-11-18 19:18:34'),(1244,1010,1,0,3170.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 19:20:16',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1031',NULL,'2023-11-18 19:20:16','2023-11-18 19:20:16'),(1245,1011,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 19:34:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1032',NULL,'2023-11-18 19:34:28','2023-11-18 19:34:28'),(1246,1012,1,0,3200.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 19:36:17',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1033',NULL,'2023-11-18 19:36:17','2023-11-18 19:36:17'),(1247,1013,1,0,1000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-18 19:43:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/1034',NULL,'2023-11-18 19:43:16','2023-11-18 19:43:16'),(1248,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:36:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0191',NULL,'2023-11-19 12:36:48','2023-11-19 12:36:48'),(1249,628,1,0,75490.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:36:00',3,0,NULL,0,33,1248,NULL,NULL,'PP2023/0192',NULL,'2023-11-19 12:36:48','2023-11-19 12:36:48'),(1250,991,1,0,24510.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:36:00',3,0,NULL,0,33,1248,NULL,NULL,'PP2023/0193',NULL,'2023-11-19 12:36:48','2023-11-19 12:36:48'),(1251,NULL,1,0,50000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:36:00',3,0,NULL,1,73,NULL,NULL,NULL,'PP2023/0194',NULL,'2023-11-19 12:37:01','2023-11-19 12:37:01'),(1252,935,1,0,50000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:36:00',3,0,NULL,0,73,1251,NULL,NULL,'PP2023/0195',NULL,'2023-11-19 12:37:01','2023-11-19 12:37:01'),(1253,NULL,1,0,3000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:37:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/1035',NULL,'2023-11-19 12:37:32','2023-11-19 12:37:32'),(1254,681,1,0,3000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:37:00',3,0,NULL,0,36,1253,NULL,NULL,'SE2023/1036',NULL,'2023-11-19 12:37:32','2023-11-19 12:37:32'),(1255,NULL,1,0,5000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:38:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/1037',NULL,'2023-11-19 12:39:03','2023-11-19 12:39:03'),(1256,614,1,0,4490.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:38:00',3,0,NULL,0,35,1255,NULL,NULL,'SE2023/1038',NULL,'2023-11-19 12:39:03','2023-11-19 12:39:03'),(1257,685,1,0,510.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:38:00',3,0,NULL,0,35,1255,NULL,NULL,'SE2023/1039',NULL,'2023-11-19 12:39:03','2023-11-19 12:39:03'),(1258,1015,1,0,16400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:47:03',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1040',NULL,'2023-11-19 12:47:03','2023-11-19 12:47:03'),(1259,1016,1,0,26973.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:48:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1041',NULL,'2023-11-19 12:48:35','2023-11-19 12:48:35'),(1260,1017,1,0,3350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:49:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1042',NULL,'2023-11-19 12:49:09','2023-11-19 12:49:09'),(1261,1018,1,0,21130.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:53:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1043',NULL,'2023-11-19 12:53:40','2023-11-19 12:53:40'),(1262,1019,1,0,3600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 12:54:06',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1044',NULL,'2023-11-19 12:54:06','2023-11-19 12:54:06'),(1263,1020,1,0,12550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 13:16:47',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1045',NULL,'2023-11-19 13:16:47','2023-11-19 13:16:47'),(1264,1021,1,0,8260.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 13:17:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1046',NULL,'2023-11-19 13:17:32','2023-11-19 13:17:32'),(1265,1023,1,0,7400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 13:20:19',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1047',NULL,'2023-11-19 13:20:19','2023-11-19 13:20:19'),(1266,1025,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 13:23:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/1048',NULL,'2023-11-19 13:24:05','2023-11-19 13:24:05'),(1267,1026,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 13:31:38',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1049',NULL,'2023-11-19 13:31:38','2023-11-19 13:31:38'),(1268,1027,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 13:41:07',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1050',NULL,'2023-11-19 13:41:07','2023-11-19 13:41:07'),(1269,1028,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 17:01:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1051',NULL,'2023-11-19 17:01:12','2023-11-19 17:01:12'),(1270,1029,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 17:12:21',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1052',NULL,'2023-11-19 17:12:21','2023-11-19 17:12:21'),(1271,1030,1,0,15250.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 17:14:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1053',NULL,'2023-11-19 17:14:31','2023-11-19 17:14:31'),(1272,1032,1,0,11050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 17:20:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1054',NULL,'2023-11-19 17:20:50','2023-11-19 17:20:50'),(1273,1033,1,0,2850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 17:26:00',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1055',NULL,'2023-11-19 17:26:26','2023-11-19 17:26:26'),(1274,1034,1,0,1650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 17:30:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1056',NULL,'2023-11-19 17:30:49','2023-11-19 17:30:49'),(1275,NULL,1,0,114120.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 18:00:00',3,0,NULL,1,67,NULL,NULL,NULL,'SE2023/1057',NULL,'2023-11-19 18:00:54','2023-11-19 18:00:54'),(1276,697,1,0,114120.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 18:00:00',3,0,NULL,0,67,1275,NULL,NULL,'SE2023/1058',NULL,'2023-11-19 18:00:54','2023-11-19 18:00:54'),(1277,1035,1,0,1680.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 18:01:32',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1059',NULL,'2023-11-19 18:01:32','2023-11-19 18:01:32'),(1278,1036,1,0,120.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 18:04:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/1060',NULL,'2023-11-19 18:05:20','2023-11-19 18:05:20'),(1279,1037,1,0,1550.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 18:32:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1061',NULL,'2023-11-19 18:32:55','2023-11-19 18:32:55'),(1280,1038,1,0,10350.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-19 18:42:04',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1062',NULL,'2023-11-19 18:42:04','2023-11-19 18:42:04'),(1281,NULL,1,0,2000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:42:00',3,0,NULL,1,36,NULL,NULL,NULL,'SE2023/1063',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1282,681,1,0,150.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:42:00',3,0,NULL,0,36,1281,NULL,NULL,'SE2023/1064',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1283,695,1,0,1650.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:42:00',3,0,NULL,0,36,1281,NULL,NULL,'SE2023/1065',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1284,761,1,0,200.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:42:00',3,0,NULL,0,36,1281,NULL,NULL,'SE2023/1066',NULL,'2023-11-20 10:42:17','2023-11-20 10:42:17'),(1285,NULL,1,0,7000.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:42:00',3,0,NULL,1,35,NULL,NULL,NULL,'SE2023/1067',NULL,'2023-11-20 10:42:53','2023-11-20 10:42:53'),(1286,685,1,0,7000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:42:00',3,0,NULL,0,35,1285,NULL,NULL,'SE2023/1068',NULL,'2023-11-20 10:42:53','2023-11-20 10:42:53'),(1287,NULL,1,0,150000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:44:00',3,0,NULL,1,28,NULL,NULL,NULL,'PP2023/0196',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1288,472,1,0,68162.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:44:00',3,0,NULL,0,28,1287,NULL,NULL,'PP2023/0197',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1289,600,1,0,45547.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:44:00',3,0,NULL,0,28,1287,NULL,NULL,'PP2023/0198',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1290,715,1,0,31590.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:44:00',3,0,NULL,0,28,1287,NULL,NULL,'PP2023/0199',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1291,811,1,0,4701.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:44:00',3,0,NULL,0,28,1287,NULL,NULL,'PP2023/0200',NULL,'2023-11-20 10:44:16','2023-11-20 10:44:16'),(1292,NULL,1,0,100000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:44:00',3,0,NULL,1,33,NULL,NULL,NULL,'PP2023/0201',NULL,'2023-11-20 10:44:54','2023-11-20 10:44:54'),(1293,991,1,0,100000.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:44:00',3,0,NULL,0,33,1292,NULL,NULL,'PP2023/0202',NULL,'2023-11-20 10:44:54','2023-11-20 10:44:54'),(1294,1040,1,0,16720.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:52:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1069',NULL,'2023-11-20 10:52:08','2023-11-20 10:52:08'),(1295,1041,1,0,1600.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:54:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1070',NULL,'2023-11-20 10:54:31','2023-11-20 10:54:31'),(1296,1042,1,0,2650.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:55:52',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1071',NULL,'2023-11-20 10:55:52','2023-11-20 10:55:52'),(1297,1043,1,0,9050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 10:59:13',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1072',NULL,'2023-11-20 10:59:13','2023-11-20 10:59:13'),(1298,1044,1,0,29860.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:01:14',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1073',NULL,'2023-11-20 11:01:14','2023-11-20 11:01:14'),(1299,1045,1,0,1640.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:03:40',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1074',NULL,'2023-11-20 11:03:40','2023-11-20 11:03:40'),(1300,1046,1,0,700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:05:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/1075',NULL,'2023-11-20 11:06:03','2023-11-20 11:06:03'),(1301,1047,1,0,1830.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:06:41',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1076',NULL,'2023-11-20 11:06:41','2023-11-20 11:06:41'),(1302,1048,1,0,2800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:12:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1077',NULL,'2023-11-20 11:12:09','2023-11-20 11:12:09'),(1303,1049,1,0,30000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:33:30',3,0,NULL,0,46,NULL,NULL,NULL,'SE2023/1078',NULL,'2023-11-20 11:33:30','2023-11-20 11:33:30'),(1304,1050,1,0,2450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:35:34',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1079',NULL,'2023-11-20 11:35:34','2023-11-20 11:35:34'),(1305,1051,1,0,2950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:39:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1080',NULL,'2023-11-20 11:39:50','2023-11-20 11:44:38'),(1306,1052,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:58:35',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1081',NULL,'2023-11-20 11:58:35','2023-11-20 11:58:35'),(1307,1054,1,0,1450.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 12:15:20',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1082',NULL,'2023-11-20 12:15:20','2023-11-20 12:15:20'),(1308,1055,1,0,60.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 12:18:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/1083',NULL,'2023-11-20 12:19:28','2023-11-20 12:19:28'),(1309,1056,1,0,100.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 12:19:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/1084',NULL,'2023-11-20 12:19:46','2023-11-20 12:19:46'),(1310,1057,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 12:37:31',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1085',NULL,'2023-11-20 12:37:31','2023-11-20 12:37:31'),(1311,1058,1,0,2950.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 13:24:48',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1086',NULL,'2023-11-20 13:24:48','2023-11-20 13:24:48'),(1312,1059,1,0,3000.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 13:24:00',3,0,NULL,0,NULL,NULL,NULL,NULL,'SE2023/1087',NULL,'2023-11-20 13:25:40','2023-11-20 13:25:40'),(1313,1060,1,0,1850.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 13:29:24',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1088',NULL,'2023-11-20 13:29:24','2023-11-20 13:29:24'),(1314,1061,1,0,2480.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 13:31:50',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1089',NULL,'2023-11-20 13:31:50','2023-11-20 13:31:50'),(1315,1062,1,0,2700.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 13:32:08',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1090',NULL,'2023-11-20 13:32:08','2023-11-20 13:32:08'),(1316,1063,1,0,1400.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 13:58:58',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1091',NULL,'2023-11-20 13:58:58','2023-11-20 13:58:58'),(1317,1064,1,0,1800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 14:11:16',3,0,NULL,0,67,NULL,NULL,NULL,'SE2023/1092',NULL,'2023-11-20 14:11:16','2023-11-20 14:11:16'),(1318,NULL,1,0,2275.0000,'cash','credit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 14:52:00',3,0,NULL,1,51,NULL,NULL,NULL,'SE2023/1093',NULL,'2023-11-20 14:52:56','2023-11-20 14:52:56'),(1319,890,1,0,2275.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 14:52:00',3,0,NULL,0,51,1318,NULL,NULL,'SE2023/1094',NULL,'2023-11-20 14:52:56','2023-11-20 14:52:56'),(1320,1065,1,0,2750.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 14:53:59',3,0,NULL,0,51,NULL,NULL,NULL,'SE2023/1095',NULL,'2023-11-20 14:53:59','2023-11-20 14:53:59'),(1321,1066,1,0,38798.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 17:34:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1096',NULL,'2023-11-20 17:34:09','2023-11-20 17:34:09'),(1322,1067,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 17:35:26',3,0,NULL,0,36,NULL,NULL,NULL,'SE2023/1097',NULL,'2023-11-20 17:35:26','2023-11-20 17:35:26'),(1323,1068,1,0,5780.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 17:36:55',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1098',NULL,'2023-11-20 17:36:55','2023-11-20 17:36:55'),(1324,1069,1,0,2800.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 17:55:46',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1099',NULL,'2023-11-20 17:55:46','2023-11-20 17:55:46'),(1325,1070,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 18:08:28',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1100',NULL,'2023-11-20 18:08:28','2023-11-20 18:08:28'),(1326,1071,1,0,3840.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 18:20:49',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1101',NULL,'2023-11-20 18:20:49','2023-11-20 19:10:31'),(1327,1072,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 18:27:12',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1102',NULL,'2023-11-20 18:27:12','2023-11-20 18:27:12'),(1328,1073,1,0,6050.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 18:49:18',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1103',NULL,'2023-11-20 18:49:18','2023-11-20 18:49:18'),(1329,1074,1,0,1500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:07:11',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1104',NULL,'2023-11-20 19:07:11','2023-11-20 19:07:11'),(1330,1075,1,0,2900.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:12:09',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1105',NULL,'2023-11-20 19:12:09','2023-11-20 19:12:09'),(1331,1076,1,0,1320.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:29:56',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1106',NULL,'2023-11-20 19:29:56','2023-11-20 19:29:56'),(1332,1077,1,0,1300.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:49:04',3,0,NULL,0,1,NULL,NULL,NULL,'SE2023/1107',NULL,'2023-11-20 19:49:04','2023-11-20 19:49:04'),(1333,NULL,1,0,200000.0000,'cash','debit',NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:57:00',3,0,NULL,1,32,NULL,NULL,NULL,'PP2023/0203',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1334,490,1,0,5820.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:57:00',3,0,NULL,0,32,1333,NULL,NULL,'PP2023/0204',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1335,632,1,0,64500.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:57:00',3,0,NULL,0,32,1333,NULL,NULL,'PP2023/0205',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1336,716,1,0,129680.0000,'cash',NULL,'cash',NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:57:00',3,0,NULL,0,32,1333,NULL,NULL,'PP2023/0206',NULL,'2023-11-20 19:57:57','2023-11-20 19:57:57'),(1337,1078,1,0,70.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 19:58:00',3,0,NULL,0,NULL,N