@extends('layouts.app')
@section('title', __('lang_v1.all_product_dues'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('lang_v1.product_due')</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>



<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
                
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_due_filter_contact_id', __('contact.customer') . ':') !!}
                        {!! Form::select('product_due_filter_contact_id', $customers, null, [
                            'class' => 'form-control select2',
                            'style' => 'width:100%',
                            'id' => 'product_due_filter_contact_id',
                            'placeholder' => __('lang_v1.all'),
                        ]) !!}
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_due_filter_type', __('lang_v1.type') . ':') !!}
                        {!! Form::select(
                            'product_due_filter_type',
                            $types,
                            null,
                            ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'id' => 'product_due_filter_type',],
                        ) !!}
                    </div>
                </div>
    
                
            @endcomponent
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_product_dues')])
                @slot('tool')
                    <div class="box-tools">
                        <button type="button" class="btn btn-block btn-primary btn-modal" 
                        data-href="{{action([\App\Http\Controllers\ProductDueController::class, 'create'])}}" 
                        data-container=".product_due_modal">
                        <i class="fa fa-plus"></i> @lang('messages.add')</button>
                    </div>
                @endslot
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="product_due_table">
                        <thead>
                            <tr>
                                <th>@lang('contact.name')</th>
                                <th>@lang('sale.product')</th>
                                <th>@lang('sale.qty')</th>
                                <th>@lang('lang_v1.type')</th>
                                <th>@lang('lang_v1.date')</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr>
                                <th class="text-right" colspan="2">Total Returnable(Due {{ $due }} - Collection {{ $collect }})</th>
                                <th colspan="4">{{ $due - $collect }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>

    <div class="modal fade product_due_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

@endsection
