<div class="modal-dialog" role="document">
    <div class="modal-content">

        {!! Form::open([
            'url' => action([\App\Http\Controllers\ProductDueController::class, 'store']),
            'method' => 'post',
            'id' => 'product_due_add_form',
            'class' => 'form-horizontal',
        ]) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                    aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('lang_v1.add_product_due')</h4>
        </div>

        <div class="modal-body">
            <div class="form-group">
                {!! Form::label('contact_id', __('contact.name') . ':*', ['class' => 'col-sm-3 control-label']) !!}
                <div class="col-sm-9">
                    {!! Form::select('contact_id', $contacts, null, [
                        'class' => 'form-control select2',
                        'placeholder' => __('messages.please_select'),
                        'required',
                    ]) !!}
                </div>
            </div>

            <div class="form-group">
                {!! Form::label('product_id', __('sale.product') . ':*', ['class' => 'col-sm-3 control-label']) !!}
                <div class="col-sm-9">
                    {!! Form::select('product_id', $products, null, [
                        'class' => 'form-control select2',
                        'placeholder' => __('messages.please_select'),
                        'required',
                    ]) !!}
                </div>
            </div>

            <div class="form-group">
                {!! Form::label('type', __('lang_v1.type') . ':*', ['class' => 'col-sm-3 control-label']) !!}
                <div class="col-sm-9">
                    {!! Form::select(
                        'type',
                        $types,
                        null,
                        ['class' => 'form-control', 'placeholder' => __('messages.please_select')],
                    ) !!}
                </div>
            </div>

            <div class="form-group">
                {!! Form::label('quantity', __('sale.qty') . ':*', ['class' => 'col-sm-3 control-label']) !!}
                <div class="col-sm-9">
                    {!! Form::text('quantity', null, ['class' => 'form-control', 'required', 'placeholder' => __('sale.qty')]) !!}
                </div>
            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>

        {!! Form::close() !!}

    </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->
