<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $guarded = ['id'];
    
    public function contact()
    {
        return $this->belongsTo(\App\Contact::class, 'contact_id');
    }

    public function business()
    {
        return $this->belongsTo(\App\Business::class, 'business_id');
    }

    public function sales_person()
    {
        return $this->belongsTo(\App\User::class, 'created_by');
    }

    /**
     * Get all of the items for the Order
     */
    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }
}
