<?php

namespace App\Http\Controllers;

use App\Contact;
use App\Trade;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Utils\ModuleUtil;
use App\Utils\Util;
use Illuminate\Support\Facades\Log;

class TradeController extends Controller
{

    /**
     * Constructor
     *
     * @param  Util  $commonUtil
     * @param  ModuleUtil  $moduleUtil
     * @return void
     */
    public function __construct(public Util $commonUtil, public ModuleUtil $moduleUtil){}

    /**
     * Display a listing of the resource.
     *
     */
    public function index()
    {
//        if (! auth()->user()->can('trade.view') && ! auth()->user()->can('trade.create')) {
//            abort(403, 'Unauthorized action.');
//        }
        // <button data-href="{{action(\'App\Http\Controllers\TradeController@edit\', [$id])}}" class="btn btn-xs btn-primary edit_trade_button"><i class="glyphicon glyphicon-edit"></i> @lang("messages.edit")</button>
        if (request()->ajax()) {
            return Datatables::of(Trade::query())
                ->addColumn(
                    'action',
                    '   <button data-href="{{action(\'App\Http\Controllers\TradeController@edit\', [$id])}}" class="btn btn-xs btn-primary edit_trade_button"><i class="glyphicon glyphicon-edit"></i> @lang("messages.edit")</button>
                        <a href="{{action(\'App\Http\Controllers\TradeController@show\', [$id])}}" class="btn btn-xs btn-primary"><i class="fas fa-eye" aria-hidden="true"></i> @lang("messages.view")</a>
                        
                        &nbsp;
                        @if(empty($total_pv))
                        <button data-href="{{action(\'App\Http\Controllers\TradeController@destroy\', [$id])}}" class="btn btn-xs btn-danger delete_trade_button"><i class="glyphicon glyphicon-trash"></i> @lang("messages.delete")</button>
                        @endif'
                )
                ->editColumn('contact_id', function($data) {
                    return $data->contact?->name;
                })
                ->editColumn('amount', function($data) {
                    return $this->commonUtil->num_f($data->amount, true);
                })
                ->editColumn('is_will_get', function($data) {
                    return $data->is_will_get ? '(+)'.__('lang_v1.will_get'):'(-)'.__('lang_v1.will_give');
                })
                ->editColumn('created_at', function($data) {
                    return $data->created_at->format('d-m-Y g:i A');
                })
                ->removeColumn('id')
                ->removeColumn('updated_at')
                ->rawColumns([4])
                ->make(false);
        }



        return view('trade.index', [
            'total_trade' => $this->commonUtil->num_f(Trade::sum('amount'), true)
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     */
    public function create()
    {
//        if (! auth()->user()->can('trade.create')) {
//            abort(403, 'Unauthorized action.');
//        }
        $contacts = Contact::contactDropdown(1);
        return view('trade.create', compact('contacts'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     */
    public function store(Request $request)
    {
//        if (! auth()->user()->can('trade.create')) {
//            abort(403, 'Unauthorized action.');
//        }
        try {
            $input = $request->only(['contact_id','amount']);
            $input['is_will_get'] = $request->type == 'will_get';
            $trade = Trade::query()->create($input);

            $output = [
                'success' => true,
                'data' => $trade,
                'msg' => 'Trade added succesfully',
            ];
        } catch (\Exception $e) {
            Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

            $output = [
                'success' => false,
                'msg' => 'Something went wrong, please try again',
            ];
        }

        return $output;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Trade  $trade
     */
    public function show(Trade $trade)
    {
//        if (! auth()->user()->can('trade.view')) {
//            abort(403, 'Unauthorized action.');
//        }

        return view('trade.show', compact('trade'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Trade  $trade
     */
    public function edit(Trade $trade)
    {
//        if (! auth()->user()->can('trade.update')) {
//            abort(403, 'Unauthorized action.');
//        }
        $contacts = Contact::contactDropdown(1);
        return view('trade.edit', compact('contacts', 'trade'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Trade  $trade
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Trade $trade)
    {
//        if (! auth()->user()->can('take_profit.update')) {
//            abort(403, 'Unauthorized action.');
//        }
        if (request()->ajax()) {
            try {
                $input = $request->only(['contact_id','amount']);
                $input['is_will_get'] = $request->type == 'will_get';
                $trade->update($input);

                $output = [
                    'success' => true,
                    'msg' => 'Trade updated succesfully',
                ];
            } catch (\Exception $e) {
                Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

                $output = ['success' => false,
                    'msg' => 'Something went wrong, please try again',
                ];
            }
            return $output;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Trade  $trade
     * @return \Illuminate\Http\Response
     */
    public function destroy(Trade $trade)
    {
//        if (! auth()->user()->can('trade.delete')) {
//            abort(403, 'Unauthorized action.');
//        }
        if (request()->ajax()) {
            try {
                $trade->delete();
                $output = [
                    'success' => true,
                    'msg' => 'Trade deleted succesfully',
                ];
            } catch (\Exception $e) {
                Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());

                $output = [
                    'success' => false,
                    'msg' => 'Something went wrong, please try again',
                ];
            }

            return $output;
        }
    }
}
