<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmptyProductReturn extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    /**
     * Get the product that owns the Returnable Product Stock
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * Get the contact that owns the Returnable Product Stock
     */
    public function contact()
    {
        return $this->belongsTo(Contact::class);
    }
}
